/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IScrollCaptureCallbacks
extends IInterface {
    public static final String DESCRIPTOR = "android.view.IScrollCaptureCallbacks";

    public void onCaptureStarted() throws RemoteException;

    public void onImageRequestCompleted(int var1, Rect var2) throws RemoteException;

    public void onCaptureEnded() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IScrollCaptureCallbacks {
        static final int TRANSACTION_onCaptureStarted = 1;
        static final int TRANSACTION_onImageRequestCompleted = 2;
        static final int TRANSACTION_onCaptureEnded = 3;

        public Stub() {
            this.attachInterface(this, IScrollCaptureCallbacks.DESCRIPTOR);
        }

        public static IScrollCaptureCallbacks asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IScrollCaptureCallbacks.DESCRIPTOR);
            if (iin != null && iin instanceof IScrollCaptureCallbacks) {
                return (IScrollCaptureCallbacks)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onCaptureStarted";
                }
                case 2: {
                    return "onImageRequestCompleted";
                }
                case 3: {
                    return "onCaptureEnded";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IScrollCaptureCallbacks.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    this.onCaptureStarted();
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    Rect _arg1 = data.readTypedObject(Rect.CREATOR);
                    data.enforceNoDataAvail();
                    this.onImageRequestCompleted(_arg0, _arg1);
                    break;
                }
                case 3: {
                    this.onCaptureEnded();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IScrollCaptureCallbacks {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IScrollCaptureCallbacks.DESCRIPTOR;
            }

            @Override
            public void onCaptureStarted() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScrollCaptureCallbacks.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onImageRequestCompleted(int flags, Rect capturedArea) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScrollCaptureCallbacks.DESCRIPTOR);
                    _data.writeInt(flags);
                    _data.writeTypedObject(capturedArea, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onCaptureEnded() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScrollCaptureCallbacks.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IScrollCaptureCallbacks {
        @Override
        public void onCaptureStarted() throws RemoteException {
        }

        @Override
        public void onImageRequestCompleted(int flags, Rect capturedArea) throws RemoteException {
        }

        @Override
        public void onCaptureEnded() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

