/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.sysprop.InputProperties;
import android.util.ArrayMap;
import android.util.Pools;
import android.view.MotionEvent;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;

public class VelocityTracker {
    private static final Pools.SynchronizedPool<VelocityTracker> sPool = new Pools.SynchronizedPool(2);
    private static final int ACTIVE_POINTER_ID = -1;
    public static final int VELOCITY_TRACKER_STRATEGY_DEFAULT = -1;
    public static final int VELOCITY_TRACKER_STRATEGY_IMPULSE = 0;
    public static final int VELOCITY_TRACKER_STRATEGY_LSQ1 = 1;
    public static final int VELOCITY_TRACKER_STRATEGY_LSQ2 = 2;
    public static final int VELOCITY_TRACKER_STRATEGY_LSQ3 = 3;
    public static final int VELOCITY_TRACKER_STRATEGY_WLSQ2_DELTA = 4;
    public static final int VELOCITY_TRACKER_STRATEGY_WLSQ2_CENTRAL = 5;
    public static final int VELOCITY_TRACKER_STRATEGY_WLSQ2_RECENT = 6;
    public static final int VELOCITY_TRACKER_STRATEGY_INT1 = 7;
    public static final int VELOCITY_TRACKER_STRATEGY_INT2 = 8;
    public static final int VELOCITY_TRACKER_STRATEGY_LEGACY = 9;
    private static final Map<String, Integer> STRATEGIES = new ArrayMap<String, Integer>();
    private long mPtr;
    private final int mStrategy;

    private static long nativeInitialize(int n) {
        return OverrideMethod.invokeL("android.view.VelocityTracker#nativeInitialize(I)J", true, null);
    }

    private static void nativeDispose(long l) {
        OverrideMethod.invokeV("android.view.VelocityTracker#nativeDispose(J)V", true, null);
    }

    private static void nativeClear(long l) {
        OverrideMethod.invokeV("android.view.VelocityTracker#nativeClear(J)V", true, null);
    }

    private static void nativeAddMovement(long l, MotionEvent motionEvent) {
        OverrideMethod.invokeV("android.view.VelocityTracker#nativeAddMovement(JLandroid/view/MotionEvent;)V", true, null);
    }

    private static void nativeComputeCurrentVelocity(long l, int n, float f) {
        OverrideMethod.invokeV("android.view.VelocityTracker#nativeComputeCurrentVelocity(JIF)V", true, null);
    }

    private static float nativeGetXVelocity(long l, int n) {
        return OverrideMethod.invokeF("android.view.VelocityTracker#nativeGetXVelocity(JI)F", true, null);
    }

    private static float nativeGetYVelocity(long l, int n) {
        return OverrideMethod.invokeF("android.view.VelocityTracker#nativeGetYVelocity(JI)F", true, null);
    }

    private static boolean nativeGetEstimator(long l, int n, Estimator estimator) {
        return OverrideMethod.invokeI("android.view.VelocityTracker#nativeGetEstimator(JILandroid/view/VelocityTracker$Estimator;)Z", true, null) != 0;
    }

    private static int toStrategyId(String strStrategy) {
        if (STRATEGIES.containsKey(strStrategy)) {
            return STRATEGIES.get(strStrategy);
        }
        return -1;
    }

    public static VelocityTracker obtain() {
        VelocityTracker instance = sPool.acquire();
        return instance != null ? instance : new VelocityTracker(-1);
    }

    @Deprecated
    @UnsupportedAppUsage
    public static VelocityTracker obtain(String strategy) {
        if (strategy == null) {
            return VelocityTracker.obtain();
        }
        return new VelocityTracker(VelocityTracker.toStrategyId(strategy));
    }

    public static VelocityTracker obtain(int strategy) {
        return new VelocityTracker(strategy);
    }

    public void recycle() {
        if (this.mStrategy == -1) {
            this.clear();
            sPool.release(this);
        }
    }

    public int getStrategyId() {
        return this.mStrategy;
    }

    private VelocityTracker(int strategy) {
        String strategyProperty;
        this.mStrategy = strategy == -1 ? ((strategyProperty = (String)InputProperties.velocitytracker_strategy().orElse(null)) == null || strategyProperty.isEmpty() ? strategy : VelocityTracker.toStrategyId(strategyProperty)) : strategy;
        this.mPtr = VelocityTracker.nativeInitialize(this.mStrategy);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mPtr != 0L) {
                VelocityTracker.nativeDispose(this.mPtr);
                this.mPtr = 0L;
            }
        }
        finally {
            super.finalize();
        }
    }

    public void clear() {
        VelocityTracker.nativeClear(this.mPtr);
    }

    public void addMovement(MotionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        VelocityTracker.nativeAddMovement(this.mPtr, event);
    }

    public void computeCurrentVelocity(int units) {
        VelocityTracker.nativeComputeCurrentVelocity(this.mPtr, units, Float.MAX_VALUE);
    }

    public void computeCurrentVelocity(int units, float maxVelocity) {
        VelocityTracker.nativeComputeCurrentVelocity(this.mPtr, units, maxVelocity);
    }

    public float getXVelocity() {
        return VelocityTracker.nativeGetXVelocity(this.mPtr, -1);
    }

    public float getYVelocity() {
        return VelocityTracker.nativeGetYVelocity(this.mPtr, -1);
    }

    public float getXVelocity(int id2) {
        return VelocityTracker.nativeGetXVelocity(this.mPtr, id2);
    }

    public float getYVelocity(int id2) {
        return VelocityTracker.nativeGetYVelocity(this.mPtr, id2);
    }

    public boolean getEstimator(int id2, Estimator outEstimator) {
        if (outEstimator == null) {
            throw new IllegalArgumentException("outEstimator must not be null");
        }
        return VelocityTracker.nativeGetEstimator(this.mPtr, id2, outEstimator);
    }

    static {
        STRATEGIES.put("impulse", 0);
        STRATEGIES.put("lsq1", 1);
        STRATEGIES.put("lsq2", 2);
        STRATEGIES.put("lsq3", 3);
        STRATEGIES.put("wlsq2-delta", 4);
        STRATEGIES.put("wlsq2-central", 5);
        STRATEGIES.put("wlsq2-recent", 6);
        STRATEGIES.put("int1", 7);
        STRATEGIES.put("int2", 8);
        STRATEGIES.put("legacy", 9);
    }

    public static class Estimator {
        private static final int MAX_DEGREE = 4;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public final float[] xCoeff = new float[5];
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public final float[] yCoeff = new float[5];
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public int degree;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public float confidence;

        public float estimateX(float time) {
            return this.estimate(time, this.xCoeff);
        }

        public float estimateY(float time) {
            return this.estimate(time, this.yCoeff);
        }

        public float getXCoeff(int index) {
            return index <= this.degree ? this.xCoeff[index] : 0.0f;
        }

        public float getYCoeff(int index) {
            return index <= this.degree ? this.yCoeff[index] : 0.0f;
        }

        private float estimate(float time, float[] c) {
            float a = 0.0f;
            float scale = 1.0f;
            for (int i = 0; i <= this.degree; ++i) {
                a += c[i] * scale;
                scale *= time;
            }
            return a;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VelocityTrackerStrategy {
    }
}

