/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.content.Context;
import android.os.Handler;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.util.Log;
import android.view.IWindow;
import android.view.IWindowSession;
import android.window.BackEvent;
import android.window.CompatOnBackInvokedCallback;
import android.window.IOnBackInvokedCallback;
import android.window.ImeOnBackInvokedDispatcher;
import android.window.OnBackAnimationCallback;
import android.window.OnBackInvokedCallback;
import android.window.OnBackInvokedCallbackInfo;
import android.window.OnBackInvokedDispatcher;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.TreeMap;

public class WindowOnBackInvokedDispatcher
implements OnBackInvokedDispatcher {
    private IWindowSession mWindowSession;
    private IWindow mWindow;
    private static final String TAG = "WindowOnBackDispatcher";
    private static final boolean ENABLE_PREDICTIVE_BACK = SystemProperties.getInt("persist.wm.debug.predictive_back", 1) != 0;
    private static final boolean ALWAYS_ENFORCE_PREDICTIVE_BACK = SystemProperties.getInt("persist.wm.debug.predictive_back_always_enforce", 0) != 0;
    private ImeOnBackInvokedDispatcher mImeDispatcher;
    private final HashMap<OnBackInvokedCallback, Integer> mAllCallbacks = new HashMap();
    private final TreeMap<Integer, ArrayList<OnBackInvokedCallback>> mOnBackInvokedCallbacks = new TreeMap();
    private final Checker mChecker;

    public WindowOnBackInvokedDispatcher(boolean applicationCallBackEnabled) {
        this.mChecker = new Checker(applicationCallBackEnabled);
    }

    public void attachToWindow(IWindowSession windowSession, IWindow window) {
        this.mWindowSession = windowSession;
        this.mWindow = window;
        if (!this.mAllCallbacks.isEmpty()) {
            this.setTopOnBackInvokedCallback(this.getTopCallback());
        }
    }

    public void detachFromWindow() {
        this.clear();
        this.mWindow = null;
        this.mWindowSession = null;
    }

    @Override
    public void registerOnBackInvokedCallback(int priority, OnBackInvokedCallback callback) {
        if (this.mChecker.checkApplicationCallbackRegistration(priority, callback)) {
            this.registerOnBackInvokedCallbackUnchecked(callback, priority);
        }
    }

    public void registerOnBackInvokedCallbackUnchecked(OnBackInvokedCallback callback, int priority) {
        if (this.mImeDispatcher != null) {
            this.mImeDispatcher.registerOnBackInvokedCallback(priority, callback);
            return;
        }
        if (!this.mOnBackInvokedCallbacks.containsKey(priority)) {
            this.mOnBackInvokedCallbacks.put(priority, new ArrayList());
        }
        ArrayList<OnBackInvokedCallback> callbacks = this.mOnBackInvokedCallbacks.get(priority);
        if (this.mAllCallbacks.containsKey(callback)) {
            Integer prevPriority = this.mAllCallbacks.get(callback);
            this.mOnBackInvokedCallbacks.get(prevPriority).remove(callback);
        }
        OnBackInvokedCallback previousTopCallback = this.getTopCallback();
        callbacks.add(callback);
        this.mAllCallbacks.put(callback, priority);
        if (previousTopCallback == null || previousTopCallback != callback && this.mAllCallbacks.get(previousTopCallback) <= priority) {
            this.setTopOnBackInvokedCallback(callback);
        }
    }

    @Override
    public void unregisterOnBackInvokedCallback(OnBackInvokedCallback callback) {
        if (this.mImeDispatcher != null) {
            this.mImeDispatcher.unregisterOnBackInvokedCallback(callback);
            return;
        }
        if (!this.mAllCallbacks.containsKey(callback)) {
            return;
        }
        OnBackInvokedCallback previousTopCallback = this.getTopCallback();
        Integer priority = this.mAllCallbacks.get(callback);
        ArrayList<OnBackInvokedCallback> callbacks = this.mOnBackInvokedCallbacks.get(priority);
        callbacks.remove(callback);
        if (callbacks.isEmpty()) {
            this.mOnBackInvokedCallbacks.remove(priority);
        }
        this.mAllCallbacks.remove(callback);
        if (previousTopCallback == callback) {
            this.setTopOnBackInvokedCallback(this.getTopCallback());
        }
    }

    @Override
    public void registerSystemOnBackInvokedCallback(OnBackInvokedCallback callback) {
        this.registerOnBackInvokedCallbackUnchecked(callback, -1);
    }

    public void clear() {
        if (this.mImeDispatcher != null) {
            this.mImeDispatcher.clear();
            this.mImeDispatcher = null;
        }
        if (!this.mAllCallbacks.isEmpty()) {
            this.setTopOnBackInvokedCallback(null);
        }
        this.mAllCallbacks.clear();
        this.mOnBackInvokedCallbacks.clear();
    }

    private void setTopOnBackInvokedCallback(OnBackInvokedCallback callback) {
        if (this.mWindowSession == null || this.mWindow == null) {
            return;
        }
        try {
            OnBackInvokedCallbackInfo callbackInfo = null;
            if (callback != null) {
                int priority = this.mAllCallbacks.get(callback);
                IOnBackInvokedCallback iCallback = callback instanceof ImeOnBackInvokedDispatcher.ImeOnBackInvokedCallback ? ((ImeOnBackInvokedDispatcher.ImeOnBackInvokedCallback)callback).getIOnBackInvokedCallback() : new OnBackInvokedCallbackWrapper(callback);
                callbackInfo = new OnBackInvokedCallbackInfo(iCallback, priority);
            }
            this.mWindowSession.setOnBackInvokedCallbackInfo(this.mWindow, callbackInfo);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to set OnBackInvokedCallback to WM. Error: " + e);
        }
    }

    public OnBackInvokedCallback getTopCallback() {
        if (this.mAllCallbacks.isEmpty()) {
            return null;
        }
        for (Integer priority : this.mOnBackInvokedCallbacks.descendingKeySet()) {
            ArrayList<OnBackInvokedCallback> callbacks = this.mOnBackInvokedCallbacks.get(priority);
            if (callbacks.isEmpty()) continue;
            return callbacks.get(callbacks.size() - 1);
        }
        return null;
    }

    public Checker getChecker() {
        return this.mChecker;
    }

    public static boolean isOnBackInvokedCallbackEnabled(Context context) {
        boolean featureFlagEnabled = ENABLE_PREDICTIVE_BACK;
        boolean appRequestsPredictiveBack = context != null && context.getApplicationInfo().isOnBackInvokedCallbackEnabled();
        return featureFlagEnabled && (appRequestsPredictiveBack || ALWAYS_ENFORCE_PREDICTIVE_BACK);
    }

    @Override
    public void setImeOnBackInvokedDispatcher(ImeOnBackInvokedDispatcher imeDispatcher) {
        this.mImeDispatcher = imeDispatcher;
    }

    public static class Checker {
        private final boolean mApplicationCallBackEnabled;

        public Checker(boolean applicationCallBackEnabled) {
            this.mApplicationCallBackEnabled = applicationCallBackEnabled;
        }

        public boolean checkApplicationCallbackRegistration(int priority, OnBackInvokedCallback callback) {
            if (!this.mApplicationCallBackEnabled && !(callback instanceof CompatOnBackInvokedCallback)) {
                Log.w("OnBackInvokedCallback", "OnBackInvokedCallback is not enabled for the application.\nSet 'android:enableOnBackInvokedCallback=\"true\"' in the application manifest.");
                return false;
            }
            if (priority < 0) {
                throw new IllegalArgumentException("Application registered OnBackInvokedCallback cannot have negative priority. Priority: " + priority);
            }
            Objects.requireNonNull(callback);
            return true;
        }
    }

    static class OnBackInvokedCallbackWrapper
    extends IOnBackInvokedCallback.Stub {
        private final WeakReference<OnBackInvokedCallback> mCallback;

        OnBackInvokedCallbackWrapper(OnBackInvokedCallback callback) {
            this.mCallback = new WeakReference<OnBackInvokedCallback>(callback);
        }

        @Override
        public void onBackStarted() {
            Handler.getMain().post(() -> {
                OnBackAnimationCallback callback = this.getBackAnimationCallback();
                if (callback != null) {
                    callback.onBackStarted();
                }
            });
        }

        @Override
        public void onBackProgressed(BackEvent backEvent) {
            Handler.getMain().post(() -> {
                OnBackAnimationCallback callback = this.getBackAnimationCallback();
                if (callback != null) {
                    callback.onBackProgressed(backEvent);
                }
            });
        }

        @Override
        public void onBackCancelled() {
            Handler.getMain().post(() -> {
                OnBackAnimationCallback callback = this.getBackAnimationCallback();
                if (callback != null) {
                    callback.onBackCancelled();
                }
            });
        }

        @Override
        public void onBackInvoked() throws RemoteException {
            Handler.getMain().post(() -> {
                OnBackInvokedCallback callback = (OnBackInvokedCallback)this.mCallback.get();
                if (callback == null) {
                    return;
                }
                callback.onBackInvoked();
            });
        }

        private OnBackAnimationCallback getBackAnimationCallback() {
            OnBackInvokedCallback callback = (OnBackInvokedCallback)this.mCallback.get();
            return callback instanceof OnBackAnimationCallback ? (OnBackAnimationCallback)callback : null;
        }
    }
}

