/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.os.Bundle;
import android.text.Editable;
import android.text.Selection;
import android.text.method.KeyListener;
import android.util.proto.ProtoOutputStream;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.DumpableInputConnection;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.widget.TextView;

public class EditableInputConnection
extends BaseInputConnection
implements DumpableInputConnection {
    private static final boolean DEBUG = false;
    private static final String TAG = "EditableInputConnection";
    private final TextView mTextView;
    private int mBatchEditNesting;

    public EditableInputConnection(TextView textview) {
        super(textview, true);
        this.mTextView = textview;
    }

    @Override
    public Editable getEditable() {
        TextView tv = this.mTextView;
        if (tv != null) {
            return tv.getEditableText();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean beginBatchEdit() {
        EditableInputConnection editableInputConnection = this;
        synchronized (editableInputConnection) {
            if (this.mBatchEditNesting >= 0) {
                this.mTextView.beginBatchEdit();
                ++this.mBatchEditNesting;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean endBatchEdit() {
        EditableInputConnection editableInputConnection = this;
        synchronized (editableInputConnection) {
            if (this.mBatchEditNesting > 0) {
                this.mTextView.endBatchEdit();
                --this.mBatchEditNesting;
                return this.mBatchEditNesting > 0;
            }
        }
        return false;
    }

    @Override
    public void endComposingRegionEditInternal() {
        this.mTextView.notifyContentCaptureTextChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeConnection() {
        super.closeConnection();
        EditableInputConnection editableInputConnection = this;
        synchronized (editableInputConnection) {
            while (this.mBatchEditNesting > 0) {
                this.endBatchEdit();
            }
            this.mBatchEditNesting = -1;
        }
    }

    @Override
    public boolean clearMetaKeyStates(int states) {
        Editable content = this.getEditable();
        if (content == null) {
            return false;
        }
        KeyListener kl = this.mTextView.getKeyListener();
        if (kl != null) {
            try {
                kl.clearMetaKeyState(this.mTextView, content, states);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public boolean commitCompletion(CompletionInfo text) {
        this.mTextView.beginBatchEdit();
        this.mTextView.onCommitCompletion(text);
        this.mTextView.endBatchEdit();
        return true;
    }

    @Override
    public boolean commitCorrection(CorrectionInfo correctionInfo) {
        this.mTextView.beginBatchEdit();
        this.mTextView.onCommitCorrection(correctionInfo);
        this.mTextView.endBatchEdit();
        return true;
    }

    @Override
    public boolean performEditorAction(int actionCode) {
        this.mTextView.onEditorAction(actionCode);
        return true;
    }

    @Override
    public boolean performContextMenuAction(int id2) {
        this.mTextView.beginBatchEdit();
        this.mTextView.onTextContextMenuItem(id2);
        this.mTextView.endBatchEdit();
        return true;
    }

    @Override
    public ExtractedText getExtractedText(ExtractedTextRequest request, int flags) {
        ExtractedText et;
        if (this.mTextView != null && this.mTextView.extractText(request, et = new ExtractedText())) {
            if ((flags & 1) != 0) {
                this.mTextView.setExtracting(request);
            }
            return et;
        }
        return null;
    }

    @Override
    public boolean performSpellCheck() {
        this.mTextView.onPerformSpellCheck();
        return true;
    }

    @Override
    public boolean performPrivateCommand(String action, Bundle data) {
        this.mTextView.onPrivateIMECommand(action, data);
        return true;
    }

    @Override
    public boolean commitText(CharSequence text, int newCursorPosition) {
        if (this.mTextView == null) {
            return super.commitText(text, newCursorPosition);
        }
        this.mTextView.resetErrorChangedFlag();
        boolean success = super.commitText(text, newCursorPosition);
        this.mTextView.hideErrorIfUnchanged();
        return success;
    }

    @Override
    public boolean requestCursorUpdates(int cursorUpdateMode, int cursorUpdateFilter) {
        return this.requestCursorUpdates(cursorUpdateMode | cursorUpdateFilter);
    }

    @Override
    public boolean requestCursorUpdates(int cursorUpdateMode) {
        int knownFlagMask = 31;
        int unknownFlags = cursorUpdateMode & 0xFFFFFFE0;
        if (unknownFlags != 0) {
            return false;
        }
        if (this.mIMM == null) {
            return false;
        }
        this.mIMM.setUpdateCursorAnchorInfoMode(cursorUpdateMode);
        if ((cursorUpdateMode & 1) != 0 && this.mTextView != null && !this.mTextView.isInLayout()) {
            this.mTextView.requestLayout();
        }
        return true;
    }

    @Override
    public boolean setImeConsumesInput(boolean imeConsumesInput) {
        if (this.mTextView == null) {
            return super.setImeConsumesInput(imeConsumesInput);
        }
        this.mTextView.setImeConsumesInput(imeConsumesInput);
        return true;
    }

    @Override
    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        CharSequence editableText = this.mTextView.getText();
        CharSequence selectedText = this.getSelectedText(0);
        Editable content = this.getEditable();
        if (content != null) {
            int start = Selection.getSelectionStart(content);
            int end = Selection.getSelectionEnd(content);
            proto.write(1120986464259L, start);
            proto.write(1120986464260L, end);
        }
        proto.write(0x10500000005L, this.getCursorCapsMode(0));
        proto.end(token);
    }
}

