/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.uielement;

import com.google.android.apps.common.testing.accessibility.framework.uielement.DisplayInfo;
import com.google.android.apps.common.testing.accessibility.framework.uielement.proto.AccessibilityHierarchyProtos;
import com.google.common.base.Splitter;
import com.google.errorprone.annotations.Immutable;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

@Immutable
public class DeviceState {
    protected static final Splitter HYPHEN_SPLITTER = Splitter.on((char)'-');
    private final DisplayInfo defaultDisplayInfo;
    protected final int sdkVersion;
    protected final Locale locale;
    protected final @Nullable Float fontScale;

    DeviceState(AccessibilityHierarchyProtos.DeviceStateProto fromProto) {
        this.sdkVersion = fromProto.getSdkVersion();
        this.defaultDisplayInfo = new DisplayInfo(fromProto.getDefaultDisplayInfo());
        String languageTag = fromProto.getLocale();
        this.locale = languageTag.isEmpty() ? Locale.ENGLISH : DeviceState.getLocaleFromLanguageTag(languageTag);
        this.fontScale = fromProto.hasFontScale() ? Float.valueOf(fromProto.getFontScale()) : null;
    }

    protected DeviceState(int sdkVersion, Locale locale, @Nullable Float fontScale) {
        this.sdkVersion = sdkVersion;
        this.locale = locale;
        this.fontScale = fontScale;
        this.defaultDisplayInfo = new DisplayInfo();
    }

    public DisplayInfo getDefaultDisplayInfo() {
        return this.defaultDisplayInfo;
    }

    public int getSdkVersion() {
        return this.sdkVersion;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public @Nullable Float getFontScale() {
        return this.fontScale;
    }

    AccessibilityHierarchyProtos.DeviceStateProto toProto() {
        AccessibilityHierarchyProtos.DeviceStateProto.Builder builder = AccessibilityHierarchyProtos.DeviceStateProto.newBuilder();
        builder.setSdkVersion(this.sdkVersion);
        builder.setDefaultDisplayInfo(this.getDefaultDisplayInfo().toProto());
        builder.setLocale(this.getLanguageTag());
        if (this.fontScale != null) {
            builder.setFontScale(this.fontScale.floatValue());
        }
        return (AccessibilityHierarchyProtos.DeviceStateProto)builder.build();
    }

    private String getLanguageTag() {
        return this.locale.toLanguageTag();
    }

    private static Locale getLocaleFromLanguageTag(String languageTag) {
        return Locale.forLanguageTag(languageTag);
    }
}

