/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ILocalWallpaperColorConsumer;
import android.app.IWallpaperManagerCallback;
import android.app.WallpaperColors;
import android.app.WallpaperInfo;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IWallpaperManager
extends IInterface {
    public ParcelFileDescriptor setWallpaper(String var1, String var2, Rect var3, boolean var4, Bundle var5, int var6, IWallpaperManagerCallback var7, int var8) throws RemoteException;

    public void setWallpaperComponentChecked(ComponentName var1, String var2, int var3) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/app/IWallpaperManager.aidl:60:1:60:25")
    public void setWallpaperComponent(ComponentName var1) throws RemoteException;

    @Deprecated
    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/app/IWallpaperManager.aidl:68:1:68:25")
    public ParcelFileDescriptor getWallpaper(String var1, IWallpaperManagerCallback var2, int var3, Bundle var4, int var5) throws RemoteException;

    public ParcelFileDescriptor getWallpaperWithFeature(String var1, String var2, IWallpaperManagerCallback var3, int var4, Bundle var5, int var6) throws RemoteException;

    public int getWallpaperIdForUser(int var1, int var2) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/app/IWallpaperManager.aidl:88:1:88:69")
    public WallpaperInfo getWallpaperInfo(int var1) throws RemoteException;

    public void clearWallpaper(String var1, int var2, int var3) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/app/IWallpaperManager.aidl:99:1:99:25")
    public boolean hasNamedWallpaper(String var1) throws RemoteException;

    public void setDimensionHints(int var1, int var2, String var3, int var4) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/app/IWallpaperManager.aidl:111:1:111:25")
    public int getWidthHint(int var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/app/IWallpaperManager.aidl:117:1:117:25")
    public int getHeightHint(int var1) throws RemoteException;

    public void setDisplayPadding(Rect var1, String var2, int var3) throws RemoteException;

    public String getName() throws RemoteException;

    public void settingsRestored() throws RemoteException;

    public boolean isWallpaperSupported(String var1) throws RemoteException;

    public boolean isSetWallpaperAllowed(String var1) throws RemoteException;

    public boolean isWallpaperBackupEligible(int var1, int var2) throws RemoteException;

    public boolean setLockWallpaperCallback(IWallpaperManagerCallback var1) throws RemoteException;

    public WallpaperColors getWallpaperColors(int var1, int var2, int var3) throws RemoteException;

    public void removeOnLocalColorsChangedListener(ILocalWallpaperColorConsumer var1, List<RectF> var2, int var3, int var4, int var5) throws RemoteException;

    public void addOnLocalColorsChangedListener(ILocalWallpaperColorConsumer var1, List<RectF> var2, int var3, int var4, int var5) throws RemoteException;

    public void registerWallpaperColorsCallback(IWallpaperManagerCallback var1, int var2, int var3) throws RemoteException;

    public void unregisterWallpaperColorsCallback(IWallpaperManagerCallback var1, int var2, int var3) throws RemoteException;

    public void setInAmbientMode(boolean var1, long var2) throws RemoteException;

    public void notifyWakingUp(int var1, int var2, Bundle var3) throws RemoteException;

    public void notifyGoingToSleep(int var1, int var2, Bundle var3) throws RemoteException;

    public void setWallpaperDimAmount(float var1) throws RemoteException;

    public float getWallpaperDimAmount() throws RemoteException;

    public boolean lockScreenWallpaperExists() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWallpaperManager {
        public static final String DESCRIPTOR = "android.app.IWallpaperManager";
        static final int TRANSACTION_setWallpaper = 1;
        static final int TRANSACTION_setWallpaperComponentChecked = 2;
        static final int TRANSACTION_setWallpaperComponent = 3;
        static final int TRANSACTION_getWallpaper = 4;
        static final int TRANSACTION_getWallpaperWithFeature = 5;
        static final int TRANSACTION_getWallpaperIdForUser = 6;
        static final int TRANSACTION_getWallpaperInfo = 7;
        static final int TRANSACTION_clearWallpaper = 8;
        static final int TRANSACTION_hasNamedWallpaper = 9;
        static final int TRANSACTION_setDimensionHints = 10;
        static final int TRANSACTION_getWidthHint = 11;
        static final int TRANSACTION_getHeightHint = 12;
        static final int TRANSACTION_setDisplayPadding = 13;
        static final int TRANSACTION_getName = 14;
        static final int TRANSACTION_settingsRestored = 15;
        static final int TRANSACTION_isWallpaperSupported = 16;
        static final int TRANSACTION_isSetWallpaperAllowed = 17;
        static final int TRANSACTION_isWallpaperBackupEligible = 18;
        static final int TRANSACTION_setLockWallpaperCallback = 19;
        static final int TRANSACTION_getWallpaperColors = 20;
        static final int TRANSACTION_removeOnLocalColorsChangedListener = 21;
        static final int TRANSACTION_addOnLocalColorsChangedListener = 22;
        static final int TRANSACTION_registerWallpaperColorsCallback = 23;
        static final int TRANSACTION_unregisterWallpaperColorsCallback = 24;
        static final int TRANSACTION_setInAmbientMode = 25;
        static final int TRANSACTION_notifyWakingUp = 26;
        static final int TRANSACTION_notifyGoingToSleep = 27;
        static final int TRANSACTION_setWallpaperDimAmount = 28;
        static final int TRANSACTION_getWallpaperDimAmount = 29;
        static final int TRANSACTION_lockScreenWallpaperExists = 30;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWallpaperManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWallpaperManager) {
                return (IWallpaperManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setWallpaper";
                }
                case 2: {
                    return "setWallpaperComponentChecked";
                }
                case 3: {
                    return "setWallpaperComponent";
                }
                case 4: {
                    return "getWallpaper";
                }
                case 5: {
                    return "getWallpaperWithFeature";
                }
                case 6: {
                    return "getWallpaperIdForUser";
                }
                case 7: {
                    return "getWallpaperInfo";
                }
                case 8: {
                    return "clearWallpaper";
                }
                case 9: {
                    return "hasNamedWallpaper";
                }
                case 10: {
                    return "setDimensionHints";
                }
                case 11: {
                    return "getWidthHint";
                }
                case 12: {
                    return "getHeightHint";
                }
                case 13: {
                    return "setDisplayPadding";
                }
                case 14: {
                    return "getName";
                }
                case 15: {
                    return "settingsRestored";
                }
                case 16: {
                    return "isWallpaperSupported";
                }
                case 17: {
                    return "isSetWallpaperAllowed";
                }
                case 18: {
                    return "isWallpaperBackupEligible";
                }
                case 19: {
                    return "setLockWallpaperCallback";
                }
                case 20: {
                    return "getWallpaperColors";
                }
                case 21: {
                    return "removeOnLocalColorsChangedListener";
                }
                case 22: {
                    return "addOnLocalColorsChangedListener";
                }
                case 23: {
                    return "registerWallpaperColorsCallback";
                }
                case 24: {
                    return "unregisterWallpaperColorsCallback";
                }
                case 25: {
                    return "setInAmbientMode";
                }
                case 26: {
                    return "notifyWakingUp";
                }
                case 27: {
                    return "notifyGoingToSleep";
                }
                case 28: {
                    return "setWallpaperDimAmount";
                }
                case 29: {
                    return "getWallpaperDimAmount";
                }
                case 30: {
                    return "lockScreenWallpaperExists";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    Rect _arg2 = data.readTypedObject(Rect.CREATOR);
                    boolean _arg3 = data.readBoolean();
                    Bundle _arg4 = new Bundle();
                    int _arg5 = data.readInt();
                    IWallpaperManagerCallback _arg6 = IWallpaperManagerCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg7 = data.readInt();
                    data.enforceNoDataAvail();
                    ParcelFileDescriptor _result = this.setWallpaper(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    reply.writeTypedObject(_arg4, 1);
                    break;
                }
                case 2: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setWallpaperComponentChecked(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.setWallpaperComponent(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    IWallpaperManagerCallback _arg1 = IWallpaperManagerCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    Bundle _arg3 = new Bundle();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    ParcelFileDescriptor _result = this.getWallpaper(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    reply.writeTypedObject(_arg3, 1);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    IWallpaperManagerCallback _arg2 = IWallpaperManagerCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg3 = data.readInt();
                    Bundle _arg4 = new Bundle();
                    int _arg5 = data.readInt();
                    data.enforceNoDataAvail();
                    ParcelFileDescriptor _result = this.getWallpaperWithFeature(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    reply.writeTypedObject(_arg4, 1);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getWallpaperIdForUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    WallpaperInfo _result = this.getWallpaperInfo(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.clearWallpaper(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasNamedWallpaper(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setDimensionHints(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getWidthHint(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getHeightHint(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 13: {
                    Rect _arg0 = data.readTypedObject(Rect.CREATOR);
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setDisplayPadding(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    String _result = this.getName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 15: {
                    this.settingsRestored();
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isWallpaperSupported(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 17: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isSetWallpaperAllowed(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isWallpaperBackupEligible(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 19: {
                    IWallpaperManagerCallback _arg0 = IWallpaperManagerCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.setLockWallpaperCallback(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 20: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    WallpaperColors _result = this.getWallpaperColors(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 21: {
                    ILocalWallpaperColorConsumer _arg0 = ILocalWallpaperColorConsumer.Stub.asInterface(data.readStrongBinder());
                    ArrayList<RectF> _arg1 = data.createTypedArrayList(RectF.CREATOR);
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removeOnLocalColorsChangedListener(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    ILocalWallpaperColorConsumer _arg0 = ILocalWallpaperColorConsumer.Stub.asInterface(data.readStrongBinder());
                    ArrayList<RectF> _arg1 = data.createTypedArrayList(RectF.CREATOR);
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.addOnLocalColorsChangedListener(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    IWallpaperManagerCallback _arg0 = IWallpaperManagerCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.registerWallpaperColorsCallback(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    IWallpaperManagerCallback _arg0 = IWallpaperManagerCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unregisterWallpaperColorsCallback(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    boolean _arg0 = data.readBoolean();
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    this.setInAmbientMode(_arg0, _arg1);
                    break;
                }
                case 26: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyWakingUp(_arg0, _arg1, _arg2);
                    break;
                }
                case 27: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyGoingToSleep(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    float _arg0 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setWallpaperDimAmount(_arg0);
                    break;
                }
                case 29: {
                    float _result = this.getWallpaperDimAmount();
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                case 30: {
                    boolean _result = this.lockScreenWallpaperExists();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 29;
        }

        private static class Proxy
        implements IWallpaperManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelFileDescriptor setWallpaper(String name, String callingPackage, Rect cropHint, boolean allowBackup, Bundle extras, int which, IWallpaperManagerCallback completion, int userId) throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeString(callingPackage);
                    _data.writeTypedObject(cropHint, 0);
                    _data.writeBoolean(allowBackup);
                    _data.writeInt(which);
                    _data.writeStrongInterface(completion);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParcelFileDescriptor.CREATOR);
                    if (0 != _reply.readInt()) {
                        extras.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWallpaperComponentChecked(ComponentName name, String callingPackage, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(name, 0);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWallpaperComponent(ComponentName name) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(name, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelFileDescriptor getWallpaper(String callingPkg, IWallpaperManagerCallback cb, int which, Bundle outParams, int userId) throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPkg);
                    _data.writeStrongInterface(cb);
                    _data.writeInt(which);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParcelFileDescriptor.CREATOR);
                    if (0 != _reply.readInt()) {
                        outParams.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelFileDescriptor getWallpaperWithFeature(String callingPkg, String callingFeatureId, IWallpaperManagerCallback cb, int which, Bundle outParams, int userId) throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPkg);
                    _data.writeString(callingFeatureId);
                    _data.writeStrongInterface(cb);
                    _data.writeInt(which);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParcelFileDescriptor.CREATOR);
                    if (0 != _reply.readInt()) {
                        outParams.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getWallpaperIdForUser(int which, int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(which);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WallpaperInfo getWallpaperInfo(int userId) throws RemoteException {
                WallpaperInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(WallpaperInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearWallpaper(String callingPackage, int which, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(which);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNamedWallpaper(String name) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDimensionHints(int width, int height, String callingPackage, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(width);
                    _data.writeInt(height);
                    _data.writeString(callingPackage);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getWidthHint(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getHeightHint(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisplayPadding(Rect padding, String callingPackage, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(padding, 0);
                    _data.writeString(callingPackage);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void settingsRestored() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isWallpaperSupported(String callingPackage) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSetWallpaperAllowed(String callingPackage) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isWallpaperBackupEligible(int which, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(which);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setLockWallpaperCallback(IWallpaperManagerCallback cb) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WallpaperColors getWallpaperColors(int which, int userId, int displayId) throws RemoteException {
                WallpaperColors _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(which);
                    _data.writeInt(userId);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(WallpaperColors.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeOnLocalColorsChangedListener(ILocalWallpaperColorConsumer callback, List<RectF> area, int which, int userId, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeTypedList(area);
                    _data.writeInt(which);
                    _data.writeInt(userId);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addOnLocalColorsChangedListener(ILocalWallpaperColorConsumer callback, List<RectF> regions, int which, int userId, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeTypedList(regions);
                    _data.writeInt(which);
                    _data.writeInt(userId);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerWallpaperColorsCallback(IWallpaperManagerCallback cb, int userId, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    _data.writeInt(userId);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterWallpaperColorsCallback(IWallpaperManagerCallback cb, int userId, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    _data.writeInt(userId);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInAmbientMode(boolean inAmbientMode, long animationDuration) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(inAmbientMode);
                    _data.writeLong(animationDuration);
                    boolean bl = this.mRemote.transact(25, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyWakingUp(int x, int y, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(x);
                    _data.writeInt(y);
                    _data.writeTypedObject(extras, 0);
                    boolean bl = this.mRemote.transact(26, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyGoingToSleep(int x, int y, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(x);
                    _data.writeInt(y);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWallpaperDimAmount(float dimAmount) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(dimAmount);
                    boolean bl = this.mRemote.transact(28, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getWallpaperDimAmount() throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean lockScreenWallpaperExists() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IWallpaperManager {
        @Override
        public ParcelFileDescriptor setWallpaper(String name, String callingPackage, Rect cropHint, boolean allowBackup, Bundle extras, int which, IWallpaperManagerCallback completion, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void setWallpaperComponentChecked(ComponentName name, String callingPackage, int userId) throws RemoteException {
        }

        @Override
        public void setWallpaperComponent(ComponentName name) throws RemoteException {
        }

        @Override
        public ParcelFileDescriptor getWallpaper(String callingPkg, IWallpaperManagerCallback cb, int which, Bundle outParams, int userId) throws RemoteException {
            return null;
        }

        @Override
        public ParcelFileDescriptor getWallpaperWithFeature(String callingPkg, String callingFeatureId, IWallpaperManagerCallback cb, int which, Bundle outParams, int userId) throws RemoteException {
            return null;
        }

        @Override
        public int getWallpaperIdForUser(int which, int userId) throws RemoteException {
            return 0;
        }

        @Override
        public WallpaperInfo getWallpaperInfo(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void clearWallpaper(String callingPackage, int which, int userId) throws RemoteException {
        }

        @Override
        public boolean hasNamedWallpaper(String name) throws RemoteException {
            return false;
        }

        @Override
        public void setDimensionHints(int width, int height, String callingPackage, int displayId) throws RemoteException {
        }

        @Override
        public int getWidthHint(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public int getHeightHint(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public void setDisplayPadding(Rect padding, String callingPackage, int displayId) throws RemoteException {
        }

        @Override
        public String getName() throws RemoteException {
            return null;
        }

        @Override
        public void settingsRestored() throws RemoteException {
        }

        @Override
        public boolean isWallpaperSupported(String callingPackage) throws RemoteException {
            return false;
        }

        @Override
        public boolean isSetWallpaperAllowed(String callingPackage) throws RemoteException {
            return false;
        }

        @Override
        public boolean isWallpaperBackupEligible(int which, int userId) throws RemoteException {
            return false;
        }

        @Override
        public boolean setLockWallpaperCallback(IWallpaperManagerCallback cb) throws RemoteException {
            return false;
        }

        @Override
        public WallpaperColors getWallpaperColors(int which, int userId, int displayId) throws RemoteException {
            return null;
        }

        @Override
        public void removeOnLocalColorsChangedListener(ILocalWallpaperColorConsumer callback, List<RectF> area, int which, int userId, int displayId) throws RemoteException {
        }

        @Override
        public void addOnLocalColorsChangedListener(ILocalWallpaperColorConsumer callback, List<RectF> regions, int which, int userId, int displayId) throws RemoteException {
        }

        @Override
        public void registerWallpaperColorsCallback(IWallpaperManagerCallback cb, int userId, int displayId) throws RemoteException {
        }

        @Override
        public void unregisterWallpaperColorsCallback(IWallpaperManagerCallback cb, int userId, int displayId) throws RemoteException {
        }

        @Override
        public void setInAmbientMode(boolean inAmbientMode, long animationDuration) throws RemoteException {
        }

        @Override
        public void notifyWakingUp(int x, int y, Bundle extras) throws RemoteException {
        }

        @Override
        public void notifyGoingToSleep(int x, int y, Bundle extras) throws RemoteException {
        }

        @Override
        public void setWallpaperDimAmount(float dimAmount) throws RemoteException {
        }

        @Override
        public float getWallpaperDimAmount() throws RemoteException {
            return 0.0f;
        }

        @Override
        public boolean lockScreenWallpaperExists() throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

