/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.IntRange;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.app.AppOpsManager;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.Immutable;
import com.android.internal.util.AnnotationValidations;

@SystemApi
@Immutable
public class RuntimeAppOpAccessMessage
implements Parcelable {
    private final int mUid;
    private final int mOpCode;
    private final String mPackageName;
    private final String mAttributionTag;
    private final String mMessage;
    private final int mSamplingStrategy;
    public static final Parcelable.Creator<RuntimeAppOpAccessMessage> CREATOR = new Parcelable.Creator<RuntimeAppOpAccessMessage>(){

        public RuntimeAppOpAccessMessage[] newArray(int size) {
            return new RuntimeAppOpAccessMessage[size];
        }

        @Override
        public RuntimeAppOpAccessMessage createFromParcel(Parcel in) {
            return new RuntimeAppOpAccessMessage(in);
        }
    };

    public String getOp() {
        return AppOpsManager.opToPublicName(this.mOpCode);
    }

    public RuntimeAppOpAccessMessage(int uid, int opCode, String packageName, String attributionTag, String message, int samplingStrategy) {
        this.mUid = uid;
        AnnotationValidations.validate(IntRange.class, null, this.mUid, "from", 0L);
        this.mOpCode = opCode;
        AnnotationValidations.validate(IntRange.class, null, this.mOpCode, "from", 0L, "to", 120L);
        this.mPackageName = packageName;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mPackageName);
        this.mAttributionTag = attributionTag;
        this.mMessage = message;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mMessage);
        this.mSamplingStrategy = samplingStrategy;
        AnnotationValidations.validate(AppOpsManager.SamplingStrategy.class, null, this.mSamplingStrategy);
    }

    public int getUid() {
        return this.mUid;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getAttributionTag() {
        return this.mAttributionTag;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public int getSamplingStrategy() {
        return this.mSamplingStrategy;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        byte flg = 0;
        if (this.mAttributionTag != null) {
            flg = (byte)(flg | 8);
        }
        dest.writeByte(flg);
        dest.writeInt(this.mUid);
        dest.writeInt(this.mOpCode);
        dest.writeString(this.mPackageName);
        if (this.mAttributionTag != null) {
            dest.writeString(this.mAttributionTag);
        }
        dest.writeString(this.mMessage);
        dest.writeInt(this.mSamplingStrategy);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    RuntimeAppOpAccessMessage(Parcel in) {
        byte flg = in.readByte();
        int uid = in.readInt();
        int opCode = in.readInt();
        String packageName = in.readString();
        String attributionTag = (flg & 8) == 0 ? null : in.readString();
        String message = in.readString();
        int samplingStrategy = in.readInt();
        this.mUid = uid;
        AnnotationValidations.validate(IntRange.class, null, this.mUid, "from", 0L);
        this.mOpCode = opCode;
        AnnotationValidations.validate(IntRange.class, null, this.mOpCode, "from", 0L, "to", 120L);
        this.mPackageName = packageName;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mPackageName);
        this.mAttributionTag = attributionTag;
        this.mMessage = message;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mMessage);
        this.mSamplingStrategy = samplingStrategy;
        AnnotationValidations.validate(AppOpsManager.SamplingStrategy.class, null, this.mSamplingStrategy);
    }

    @Deprecated
    private void __metadata() {
    }
}

