/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.IntRange;
import android.annotation.NonNull;
import android.app.ActivityThread;
import android.app.AppOpsManager;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.Immutable;
import com.android.internal.util.AnnotationValidations;
import java.util.Objects;

@Immutable
public class SyncNotedAppOp
implements Parcelable {
    private final int mOpMode;
    private final int mOpCode;
    private final String mAttributionTag;
    private final String mPackageName;
    public static final Parcelable.Creator<SyncNotedAppOp> CREATOR = new Parcelable.Creator<SyncNotedAppOp>(){

        public SyncNotedAppOp[] newArray(int size) {
            return new SyncNotedAppOp[size];
        }

        @Override
        public SyncNotedAppOp createFromParcel(Parcel in) {
            return new SyncNotedAppOp(in);
        }
    };

    public SyncNotedAppOp(int opMode, int opCode, String attributionTag, String packageName) {
        this.mOpCode = opCode;
        AnnotationValidations.validate(IntRange.class, null, this.mOpCode, "from", 0L, "to", 120L);
        this.mAttributionTag = attributionTag;
        this.mOpMode = opMode;
        this.mPackageName = packageName;
    }

    public SyncNotedAppOp(int opCode, String attributionTag) {
        this(1, opCode, attributionTag, ActivityThread.currentPackageName());
    }

    public SyncNotedAppOp(int opCode, String attributionTag, String packageName) {
        this(1, opCode, attributionTag, packageName);
    }

    public String getOp() {
        return AppOpsManager.opToPublicName(this.mOpCode);
    }

    public int getOpMode() {
        return this.mOpMode;
    }

    private String opCodeToString() {
        return this.getOp();
    }

    public String getAttributionTag() {
        return this.mAttributionTag;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String toString() {
        return "SyncNotedAppOp { opMode = " + this.mOpMode + ", opCode = " + this.opCodeToString() + ", attributionTag = " + this.mAttributionTag + ", packageName = " + this.mPackageName + " }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyncNotedAppOp that = (SyncNotedAppOp)o;
        return this.mOpMode == that.mOpMode && this.mOpCode == that.mOpCode && Objects.equals(this.mAttributionTag, that.mAttributionTag) && Objects.equals(this.mPackageName, that.mPackageName);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.mOpMode;
        _hash = 31 * _hash + this.mOpCode;
        _hash = 31 * _hash + Objects.hashCode(this.mAttributionTag);
        _hash = 31 * _hash + Objects.hashCode(this.mPackageName);
        return _hash;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        byte flg = 0;
        if (this.mAttributionTag != null) {
            flg = (byte)(flg | 4);
        }
        dest.writeByte(flg);
        dest.writeInt(this.mOpMode);
        dest.writeInt(this.mOpCode);
        if (this.mAttributionTag != null) {
            dest.writeString(this.mAttributionTag);
        }
        dest.writeString(this.mPackageName);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    SyncNotedAppOp(Parcel in) {
        byte flg = in.readByte();
        int opMode = in.readInt();
        int opCode = in.readInt();
        String attributionTag = (flg & 4) == 0 ? null : in.readString();
        String packageName = in.readString();
        this.mOpMode = opMode;
        this.mOpCode = opCode;
        AnnotationValidations.validate(IntRange.class, null, this.mOpCode, "from", 0L, "to", 120L);
        this.mAttributionTag = attributionTag;
        this.mPackageName = packageName;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mPackageName);
    }

    @Deprecated
    private void __metadata() {
    }
}

