/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManager;
import android.app.PictureInPictureParams;
import android.app.WindowConfiguration;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Intent;
import android.content.LocusId;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.IBinder;
import android.os.Parcel;
import android.window.WindowContainerToken;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Objects;

public class TaskInfo {
    private static final String TAG = "TaskInfo";
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int userId;
    public int taskId;
    public boolean isRunning;
    public Intent baseIntent;
    public ComponentName baseActivity;
    public ComponentName topActivity;
    public ComponentName origActivity;
    public ComponentName realActivity;
    public int numActivities;
    @UnsupportedAppUsage
    public long lastActiveTime;
    public int displayId;
    public int displayAreaFeatureId = -1;
    public ActivityManager.TaskDescription taskDescription;
    public LocusId mTopActivityLocusId;
    @UnsupportedAppUsage
    public boolean supportsSplitScreenMultiWindow;
    public boolean supportsMultiWindow;
    @UnsupportedAppUsage
    public int resizeMode;
    @UnsupportedAppUsage
    public final Configuration configuration = new Configuration();
    public WindowContainerToken token;
    public PictureInPictureParams pictureInPictureParams;
    public boolean shouldDockBigOverlays;
    public int launchIntoPipHostTaskId;
    public Rect displayCutoutInsets;
    @WindowConfiguration.ActivityType
    public int topActivityType;
    public ActivityInfo topActivityInfo;
    public boolean topActivityInSizeCompat;
    public boolean topActivityEligibleForLetterboxEducation;
    public boolean isResizeable;
    public int minWidth;
    public int minHeight;
    public int defaultMinSize;
    public Point positionInParent;
    public ArrayList<IBinder> launchCookies = new ArrayList();
    public int parentTaskId;
    public boolean isFocused;
    public boolean isVisible;
    public boolean isSleeping;
    public static final int CAMERA_COMPAT_CONTROL_HIDDEN = 0;
    public static final int CAMERA_COMPAT_CONTROL_TREATMENT_SUGGESTED = 1;
    public static final int CAMERA_COMPAT_CONTROL_TREATMENT_APPLIED = 2;
    public static final int CAMERA_COMPAT_CONTROL_DISMISSED = 3;
    public int cameraCompatControlState = 0;

    TaskInfo() {
    }

    private TaskInfo(Parcel source) {
        this.readFromParcel(source);
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public WindowContainerToken getToken() {
        return this.token;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public PictureInPictureParams getPictureInPictureParams() {
        return this.pictureInPictureParams;
    }

    public boolean shouldDockBigOverlays() {
        return this.shouldDockBigOverlays;
    }

    @WindowConfiguration.WindowingMode
    public int getWindowingMode() {
        return this.configuration.windowConfiguration.getWindowingMode();
    }

    @WindowConfiguration.ActivityType
    public int getActivityType() {
        return this.configuration.windowConfiguration.getActivityType();
    }

    public void addLaunchCookie(IBinder cookie) {
        if (cookie == null || this.launchCookies.contains(cookie)) {
            return;
        }
        this.launchCookies.add(cookie);
    }

    public boolean hasCameraCompatControl() {
        return this.cameraCompatControlState != 0 && this.cameraCompatControlState != 3;
    }

    public boolean hasCompatUI() {
        return this.hasCameraCompatControl() || this.topActivityInSizeCompat || this.topActivityEligibleForLetterboxEducation;
    }

    public boolean containsLaunchCookie(IBinder cookie) {
        return this.launchCookies.contains(cookie);
    }

    public int getParentTaskId() {
        return this.parentTaskId;
    }

    public boolean hasParentTask() {
        return this.parentTaskId != -1;
    }

    public boolean equalsForTaskOrganizer(TaskInfo that) {
        if (that == null) {
            return false;
        }
        return this.topActivityType == that.topActivityType && this.isResizeable == that.isResizeable && this.supportsMultiWindow == that.supportsMultiWindow && this.displayAreaFeatureId == that.displayAreaFeatureId && Objects.equals(this.positionInParent, that.positionInParent) && Objects.equals(this.pictureInPictureParams, that.pictureInPictureParams) && Objects.equals(this.shouldDockBigOverlays, that.shouldDockBigOverlays) && Objects.equals(this.displayCutoutInsets, that.displayCutoutInsets) && this.getWindowingMode() == that.getWindowingMode() && Objects.equals(this.taskDescription, that.taskDescription) && this.isFocused == that.isFocused && this.isVisible == that.isVisible && this.isSleeping == that.isSleeping && Objects.equals(this.mTopActivityLocusId, that.mTopActivityLocusId) && this.parentTaskId == that.parentTaskId;
    }

    public boolean equalsForCompatUi(TaskInfo that) {
        if (that == null) {
            return false;
        }
        return !(this.displayId != that.displayId || this.taskId != that.taskId || this.topActivityInSizeCompat != that.topActivityInSizeCompat || this.topActivityEligibleForLetterboxEducation != that.topActivityEligibleForLetterboxEducation || this.cameraCompatControlState != that.cameraCompatControlState || this.hasCompatUI() && !this.configuration.windowConfiguration.getBounds().equals(that.configuration.windowConfiguration.getBounds()) || this.hasCompatUI() && this.configuration.getLayoutDirection() != that.configuration.getLayoutDirection() || this.hasCompatUI() && this.isVisible != that.isVisible);
    }

    void readFromParcel(Parcel source) {
        this.userId = source.readInt();
        this.taskId = source.readInt();
        this.displayId = source.readInt();
        this.isRunning = source.readBoolean();
        this.baseIntent = source.readTypedObject(Intent.CREATOR);
        this.baseActivity = ComponentName.readFromParcel(source);
        this.topActivity = ComponentName.readFromParcel(source);
        this.origActivity = ComponentName.readFromParcel(source);
        this.realActivity = ComponentName.readFromParcel(source);
        this.numActivities = source.readInt();
        this.lastActiveTime = source.readLong();
        this.taskDescription = source.readTypedObject(ActivityManager.TaskDescription.CREATOR);
        this.supportsSplitScreenMultiWindow = source.readBoolean();
        this.supportsMultiWindow = source.readBoolean();
        this.resizeMode = source.readInt();
        this.configuration.readFromParcel(source);
        this.token = WindowContainerToken.CREATOR.createFromParcel(source);
        this.topActivityType = source.readInt();
        this.pictureInPictureParams = source.readTypedObject(PictureInPictureParams.CREATOR);
        this.shouldDockBigOverlays = source.readBoolean();
        this.launchIntoPipHostTaskId = source.readInt();
        this.displayCutoutInsets = source.readTypedObject(Rect.CREATOR);
        this.topActivityInfo = source.readTypedObject(ActivityInfo.CREATOR);
        this.isResizeable = source.readBoolean();
        this.minWidth = source.readInt();
        this.minHeight = source.readInt();
        this.defaultMinSize = source.readInt();
        source.readBinderList(this.launchCookies);
        this.positionInParent = source.readTypedObject(Point.CREATOR);
        this.parentTaskId = source.readInt();
        this.isFocused = source.readBoolean();
        this.isVisible = source.readBoolean();
        this.isSleeping = source.readBoolean();
        this.topActivityInSizeCompat = source.readBoolean();
        this.topActivityEligibleForLetterboxEducation = source.readBoolean();
        this.mTopActivityLocusId = source.readTypedObject(LocusId.CREATOR);
        this.displayAreaFeatureId = source.readInt();
        this.cameraCompatControlState = source.readInt();
    }

    void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.userId);
        dest.writeInt(this.taskId);
        dest.writeInt(this.displayId);
        dest.writeBoolean(this.isRunning);
        dest.writeTypedObject(this.baseIntent, 0);
        ComponentName.writeToParcel(this.baseActivity, dest);
        ComponentName.writeToParcel(this.topActivity, dest);
        ComponentName.writeToParcel(this.origActivity, dest);
        ComponentName.writeToParcel(this.realActivity, dest);
        dest.writeInt(this.numActivities);
        dest.writeLong(this.lastActiveTime);
        dest.writeTypedObject(this.taskDescription, flags);
        dest.writeBoolean(this.supportsSplitScreenMultiWindow);
        dest.writeBoolean(this.supportsMultiWindow);
        dest.writeInt(this.resizeMode);
        this.configuration.writeToParcel(dest, flags);
        this.token.writeToParcel(dest, flags);
        dest.writeInt(this.topActivityType);
        dest.writeTypedObject(this.pictureInPictureParams, flags);
        dest.writeBoolean(this.shouldDockBigOverlays);
        dest.writeInt(this.launchIntoPipHostTaskId);
        dest.writeTypedObject(this.displayCutoutInsets, flags);
        dest.writeTypedObject(this.topActivityInfo, flags);
        dest.writeBoolean(this.isResizeable);
        dest.writeInt(this.minWidth);
        dest.writeInt(this.minHeight);
        dest.writeInt(this.defaultMinSize);
        dest.writeBinderList(this.launchCookies);
        dest.writeTypedObject(this.positionInParent, flags);
        dest.writeInt(this.parentTaskId);
        dest.writeBoolean(this.isFocused);
        dest.writeBoolean(this.isVisible);
        dest.writeBoolean(this.isSleeping);
        dest.writeBoolean(this.topActivityInSizeCompat);
        dest.writeBoolean(this.topActivityEligibleForLetterboxEducation);
        dest.writeTypedObject(this.mTopActivityLocusId, flags);
        dest.writeInt(this.displayAreaFeatureId);
        dest.writeInt(this.cameraCompatControlState);
    }

    public String toString() {
        return "TaskInfo{userId=" + this.userId + " taskId=" + this.taskId + " displayId=" + this.displayId + " isRunning=" + this.isRunning + " baseIntent=" + this.baseIntent + " baseActivity=" + this.baseActivity + " topActivity=" + this.topActivity + " origActivity=" + this.origActivity + " realActivity=" + this.realActivity + " numActivities=" + this.numActivities + " lastActiveTime=" + this.lastActiveTime + " supportsSplitScreenMultiWindow=" + this.supportsSplitScreenMultiWindow + " supportsMultiWindow=" + this.supportsMultiWindow + " resizeMode=" + this.resizeMode + " isResizeable=" + this.isResizeable + " minWidth=" + this.minWidth + " minHeight=" + this.minHeight + " defaultMinSize=" + this.defaultMinSize + " token=" + this.token + " topActivityType=" + this.topActivityType + " pictureInPictureParams=" + this.pictureInPictureParams + " shouldDockBigOverlays=" + this.shouldDockBigOverlays + " launchIntoPipHostTaskId=" + this.launchIntoPipHostTaskId + " displayCutoutSafeInsets=" + this.displayCutoutInsets + " topActivityInfo=" + this.topActivityInfo + " launchCookies=" + this.launchCookies + " positionInParent=" + this.positionInParent + " parentTaskId=" + this.parentTaskId + " isFocused=" + this.isFocused + " isVisible=" + this.isVisible + " isSleeping=" + this.isSleeping + " topActivityInSizeCompat=" + this.topActivityInSizeCompat + " topActivityEligibleForLetterboxEducation= " + this.topActivityEligibleForLetterboxEducation + " locusId=" + this.mTopActivityLocusId + " displayAreaFeatureId=" + this.displayAreaFeatureId + " cameraCompatControlState=" + TaskInfo.cameraCompatControlStateToString(this.cameraCompatControlState) + "}";
    }

    public static String cameraCompatControlStateToString(int cameraCompatControlState) {
        switch (cameraCompatControlState) {
            case 0: {
                return "hidden";
            }
            case 1: {
                return "treatment-suggested";
            }
            case 2: {
                return "treatment-applied";
            }
            case 3: {
                return "dismissed";
            }
        }
        throw new AssertionError((Object)("Unexpected camera compat control state: " + cameraCompatControlState));
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CameraCompatControlState {
    }
}

