/*
 * Decompiled with CFR 0.152.
 */
package android.app.cloudsearch;

import android.annotation.SystemApi;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class SearchRequest
implements Parcelable {
    private final String mQuery;
    private final int mResultOffset;
    private final int mResultNumber;
    private final float mMaxLatencyMillis;
    private String mId = null;
    public static final String CONSTRAINT_IS_PRESUBMIT_SUGGESTION = "android.app.cloudsearch.IS_PRESUBMIT_SUGGESTION";
    public static final String CONSTRAINT_SEARCH_PROVIDER_FILTER = "android.app.cloudsearch.SEARCH_PROVIDER_FILTER";
    private Bundle mSearchConstraints;
    private String mCallerPackageName;
    public static final Parcelable.Creator<SearchRequest> CREATOR = new Parcelable.Creator<SearchRequest>(){

        @Override
        public SearchRequest createFromParcel(Parcel p) {
            return new SearchRequest(p);
        }

        public SearchRequest[] newArray(int size) {
            return new SearchRequest[size];
        }
    };

    private SearchRequest(Parcel in) {
        this.mQuery = in.readString();
        this.mResultOffset = in.readInt();
        this.mResultNumber = in.readInt();
        this.mMaxLatencyMillis = in.readFloat();
        this.mSearchConstraints = in.readBundle();
        this.mId = in.readString();
        this.mCallerPackageName = in.readString();
    }

    private SearchRequest(String query, int resultOffset, int resultNumber, float maxLatencyMillis, Bundle searchConstraints, String callerPackageName) {
        this.mQuery = query;
        this.mResultOffset = resultOffset;
        this.mResultNumber = resultNumber;
        this.mMaxLatencyMillis = maxLatencyMillis;
        this.mSearchConstraints = searchConstraints;
        this.mCallerPackageName = callerPackageName;
    }

    public String getQuery() {
        return this.mQuery;
    }

    public int getResultOffset() {
        return this.mResultOffset;
    }

    public int getResultNumber() {
        return this.mResultNumber;
    }

    public float getMaxLatencyMillis() {
        return this.mMaxLatencyMillis;
    }

    public Bundle getSearchConstraints() {
        return this.mSearchConstraints;
    }

    public String getCallerPackageName() {
        return this.mCallerPackageName;
    }

    public String getRequestId() {
        if (this.mId == null || this.mId.length() == 0) {
            this.mId = String.valueOf(this.toString().hashCode());
        }
        return this.mId;
    }

    public void setCallerPackageName(String callerPackageName) {
        this.mCallerPackageName = callerPackageName;
    }

    private SearchRequest(Builder b) {
        this.mQuery = Objects.requireNonNull(b.mQuery);
        this.mResultOffset = b.mResultOffset;
        this.mResultNumber = b.mResultNumber;
        this.mMaxLatencyMillis = b.mMaxLatencyMillis;
        this.mSearchConstraints = Objects.requireNonNull(b.mSearchConstraints);
        this.mCallerPackageName = Objects.requireNonNull(b.mCallerPackageName);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mQuery);
        dest.writeInt(this.mResultOffset);
        dest.writeInt(this.mResultNumber);
        dest.writeFloat(this.mMaxLatencyMillis);
        dest.writeBundle(this.mSearchConstraints);
        dest.writeString(this.getRequestId());
        dest.writeString(this.mCallerPackageName);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SearchRequest that = (SearchRequest)obj;
        return Objects.equals(this.mQuery, that.mQuery) && this.mResultOffset == that.mResultOffset && this.mResultNumber == that.mResultNumber && this.mMaxLatencyMillis == that.mMaxLatencyMillis && Objects.equals(this.mSearchConstraints, that.mSearchConstraints) && Objects.equals(this.mCallerPackageName, that.mCallerPackageName);
    }

    public String toString() {
        boolean isPresubmit = this.mSearchConstraints.containsKey(CONSTRAINT_IS_PRESUBMIT_SUGGESTION) && this.mSearchConstraints.getBoolean(CONSTRAINT_IS_PRESUBMIT_SUGGESTION);
        String searchProvider = "EMPTY";
        if (this.mSearchConstraints.containsKey(CONSTRAINT_SEARCH_PROVIDER_FILTER)) {
            searchProvider = this.mSearchConstraints.getString(CONSTRAINT_SEARCH_PROVIDER_FILTER);
        }
        return String.format("SearchRequest: {query:%s,offset:%d;number:%d;max_latency:%f;is_presubmit:%b;search_provider:%s;callerPackageName:%s}", this.mQuery, this.mResultOffset, this.mResultNumber, Float.valueOf(this.mMaxLatencyMillis), isPresubmit, searchProvider, this.mCallerPackageName);
    }

    public int hashCode() {
        return Objects.hash(this.mQuery, this.mResultOffset, this.mResultNumber, Float.valueOf(this.mMaxLatencyMillis), this.mSearchConstraints, this.mCallerPackageName);
    }

    @SystemApi
    public static class Builder {
        private String mQuery;
        private int mResultOffset;
        private int mResultNumber;
        private float mMaxLatencyMillis;
        private Bundle mSearchConstraints;
        private String mCallerPackageName;

        @SystemApi
        public Builder(String query) {
            this.mQuery = query;
            this.mResultOffset = 0;
            this.mResultNumber = 10;
            this.mMaxLatencyMillis = 200.0f;
            this.mSearchConstraints = Bundle.EMPTY;
            this.mCallerPackageName = "DEFAULT_CALLER";
        }

        public Builder setQuery(String query) {
            this.mQuery = query;
            return this;
        }

        public Builder setResultOffset(int resultOffset) {
            this.mResultOffset = resultOffset;
            return this;
        }

        public Builder setResultNumber(int resultNumber) {
            this.mResultNumber = resultNumber;
            return this;
        }

        public Builder setMaxLatencyMillis(float maxLatencyMillis) {
            this.mMaxLatencyMillis = maxLatencyMillis;
            return this;
        }

        public Builder setSearchConstraints(Bundle searchConstraints) {
            this.mSearchConstraints = searchConstraints;
            return this;
        }

        public Builder setCallerPackageName(String callerPackageName) {
            this.mCallerPackageName = callerPackageName;
            return this;
        }

        public SearchRequest build() {
            if (this.mQuery == null || this.mResultOffset < 0 || this.mResultNumber < 1 || this.mMaxLatencyMillis < 0.0f || this.mSearchConstraints == null) {
                throw new IllegalStateException("Please make sure all required args are valid.");
            }
            return new SearchRequest(this.mQuery, this.mResultOffset, this.mResultNumber, this.mMaxLatencyMillis, this.mSearchConstraints, this.mCallerPackageName);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SearchConstraintKey {
    }
}

