/*
 * Decompiled with CFR 0.152.
 */
package android.app.role;

import android.app.role.IOnRoleHoldersChangedListener;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteCallback;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IRoleManager
extends IInterface {
    public static final String DESCRIPTOR = "android.app.role.IRoleManager";

    public boolean isRoleAvailable(String var1) throws RemoteException;

    public boolean isRoleHeld(String var1, String var2) throws RemoteException;

    public List<String> getRoleHoldersAsUser(String var1, int var2) throws RemoteException;

    public void addRoleHolderAsUser(String var1, String var2, int var3, int var4, RemoteCallback var5) throws RemoteException;

    public void removeRoleHolderAsUser(String var1, String var2, int var3, int var4, RemoteCallback var5) throws RemoteException;

    public void clearRoleHoldersAsUser(String var1, int var2, int var3, RemoteCallback var4) throws RemoteException;

    public void addOnRoleHoldersChangedListenerAsUser(IOnRoleHoldersChangedListener var1, int var2) throws RemoteException;

    public void removeOnRoleHoldersChangedListenerAsUser(IOnRoleHoldersChangedListener var1, int var2) throws RemoteException;

    public boolean isBypassingRoleQualification() throws RemoteException;

    public void setBypassingRoleQualification(boolean var1) throws RemoteException;

    public void setRoleNamesFromController(List<String> var1) throws RemoteException;

    public boolean addRoleHolderFromController(String var1, String var2) throws RemoteException;

    public boolean removeRoleHolderFromController(String var1, String var2) throws RemoteException;

    public List<String> getHeldRolesFromController(String var1) throws RemoteException;

    public String getBrowserRoleHolder(int var1) throws RemoteException;

    public boolean setBrowserRoleHolder(String var1, int var2) throws RemoteException;

    public String getSmsRoleHolder(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRoleManager {
        static final int TRANSACTION_isRoleAvailable = 1;
        static final int TRANSACTION_isRoleHeld = 2;
        static final int TRANSACTION_getRoleHoldersAsUser = 3;
        static final int TRANSACTION_addRoleHolderAsUser = 4;
        static final int TRANSACTION_removeRoleHolderAsUser = 5;
        static final int TRANSACTION_clearRoleHoldersAsUser = 6;
        static final int TRANSACTION_addOnRoleHoldersChangedListenerAsUser = 7;
        static final int TRANSACTION_removeOnRoleHoldersChangedListenerAsUser = 8;
        static final int TRANSACTION_isBypassingRoleQualification = 9;
        static final int TRANSACTION_setBypassingRoleQualification = 10;
        static final int TRANSACTION_setRoleNamesFromController = 11;
        static final int TRANSACTION_addRoleHolderFromController = 12;
        static final int TRANSACTION_removeRoleHolderFromController = 13;
        static final int TRANSACTION_getHeldRolesFromController = 14;
        static final int TRANSACTION_getBrowserRoleHolder = 15;
        static final int TRANSACTION_setBrowserRoleHolder = 16;
        static final int TRANSACTION_getSmsRoleHolder = 17;

        public Stub() {
            this.attachInterface(this, IRoleManager.DESCRIPTOR);
        }

        public static IRoleManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IRoleManager.DESCRIPTOR);
            if (iin != null && iin instanceof IRoleManager) {
                return (IRoleManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IRoleManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    boolean _result = this.isRoleAvailable(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _result = this.isRoleHeld(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    List<String> _result = this.getRoleHoldersAsUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    RemoteCallback _arg4 = data.readTypedObject(RemoteCallback.CREATOR);
                    this.addRoleHolderAsUser(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    RemoteCallback _arg4 = data.readTypedObject(RemoteCallback.CREATOR);
                    this.removeRoleHolderAsUser(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    RemoteCallback _arg3 = data.readTypedObject(RemoteCallback.CREATOR);
                    this.clearRoleHoldersAsUser(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    IOnRoleHoldersChangedListener _arg0 = IOnRoleHoldersChangedListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.addOnRoleHoldersChangedListenerAsUser(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    IOnRoleHoldersChangedListener _arg0 = IOnRoleHoldersChangedListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.removeOnRoleHoldersChangedListenerAsUser(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    boolean _result = this.isBypassingRoleQualification();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 10: {
                    boolean _arg0 = data.readBoolean();
                    this.setBypassingRoleQualification(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    ArrayList<String> _arg0 = data.createStringArrayList();
                    this.setRoleNamesFromController(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _result = this.addRoleHolderFromController(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 13: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _result = this.removeRoleHolderFromController(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 14: {
                    String _arg0 = data.readString();
                    List<String> _result = this.getHeldRolesFromController(_arg0);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    String _result = this.getBrowserRoleHolder(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 16: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _result = this.setBrowserRoleHolder(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    String _result = this.getSmsRoleHolder(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IRoleManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IRoleManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isRoleAvailable(String roleName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isRoleHeld(String roleName, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getRoleHoldersAsUser(String roleName, int userId) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addRoleHolderAsUser(String roleName, String packageName, int flags, int userId, RemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeString(packageName);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    _data.writeTypedObject(callback, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeRoleHolderAsUser(String roleName, String packageName, int flags, int userId, RemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeString(packageName);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    _data.writeTypedObject(callback, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearRoleHoldersAsUser(String roleName, int flags, int userId, RemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    _data.writeTypedObject(callback, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addOnRoleHoldersChangedListenerAsUser(IOnRoleHoldersChangedListener listener, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeOnRoleHoldersChangedListenerAsUser(IOnRoleHoldersChangedListener listener, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBypassingRoleQualification() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBypassingRoleQualification(boolean bypassRoleQualification) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeBoolean(bypassRoleQualification);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRoleNamesFromController(List<String> roleNames) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeStringList(roleNames);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean addRoleHolderFromController(String roleName, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeRoleHolderFromController(String roleName, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getHeldRolesFromController(String packageName) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getBrowserRoleHolder(int userId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setBrowserRoleHolder(String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getSmsRoleHolder(int userId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IRoleManager {
        @Override
        public boolean isRoleAvailable(String roleName) throws RemoteException {
            return false;
        }

        @Override
        public boolean isRoleHeld(String roleName, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public List<String> getRoleHoldersAsUser(String roleName, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void addRoleHolderAsUser(String roleName, String packageName, int flags, int userId, RemoteCallback callback) throws RemoteException {
        }

        @Override
        public void removeRoleHolderAsUser(String roleName, String packageName, int flags, int userId, RemoteCallback callback) throws RemoteException {
        }

        @Override
        public void clearRoleHoldersAsUser(String roleName, int flags, int userId, RemoteCallback callback) throws RemoteException {
        }

        @Override
        public void addOnRoleHoldersChangedListenerAsUser(IOnRoleHoldersChangedListener listener, int userId) throws RemoteException {
        }

        @Override
        public void removeOnRoleHoldersChangedListenerAsUser(IOnRoleHoldersChangedListener listener, int userId) throws RemoteException {
        }

        @Override
        public boolean isBypassingRoleQualification() throws RemoteException {
            return false;
        }

        @Override
        public void setBypassingRoleQualification(boolean bypassRoleQualification) throws RemoteException {
        }

        @Override
        public void setRoleNamesFromController(List<String> roleNames) throws RemoteException {
        }

        @Override
        public boolean addRoleHolderFromController(String roleName, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean removeRoleHolderFromController(String roleName, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public List<String> getHeldRolesFromController(String packageName) throws RemoteException {
            return null;
        }

        @Override
        public String getBrowserRoleHolder(int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean setBrowserRoleHolder(String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public String getSmsRoleHolder(int userId) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

