/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.bluetooth.Attributable;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothCodecConfig;
import android.bluetooth.BluetoothCodecStatus;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothProfileConnector;
import android.bluetooth.BluetoothUtils;
import android.bluetooth.BluetoothUuid;
import android.bluetooth.BufferConstraints;
import android.bluetooth.IBluetoothA2dp;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.content.Context;
import android.os.IBinder;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class BluetoothA2dp
implements BluetoothProfile {
    private static final String TAG = "BluetoothA2dp";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_PLAYING_STATE_CHANGED = "android.bluetooth.a2dp.profile.action.PLAYING_STATE_CHANGED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_AVRCP_CONNECTION_STATE_CHANGED = "android.bluetooth.a2dp.profile.action.AVRCP_CONNECTION_STATE_CHANGED";
    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_ACTIVE_DEVICE_CHANGED = "android.bluetooth.a2dp.profile.action.ACTIVE_DEVICE_CHANGED";
    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_CODEC_CONFIG_CHANGED = "android.bluetooth.a2dp.profile.action.CODEC_CONFIG_CHANGED";
    public static final int STATE_PLAYING = 10;
    public static final int STATE_NOT_PLAYING = 11;
    @SystemApi
    public static final int OPTIONAL_CODECS_SUPPORT_UNKNOWN = -1;
    @SystemApi
    public static final int OPTIONAL_CODECS_NOT_SUPPORTED = 0;
    @SystemApi
    public static final int OPTIONAL_CODECS_SUPPORTED = 1;
    @SystemApi
    public static final int OPTIONAL_CODECS_PREF_UNKNOWN = -1;
    @SystemApi
    public static final int OPTIONAL_CODECS_PREF_DISABLED = 0;
    @SystemApi
    public static final int OPTIONAL_CODECS_PREF_ENABLED = 1;
    @SystemApi
    public static final int DYNAMIC_BUFFER_SUPPORT_NONE = 0;
    @SystemApi
    public static final int DYNAMIC_BUFFER_SUPPORT_A2DP_OFFLOAD = 1;
    @SystemApi
    public static final int DYNAMIC_BUFFER_SUPPORT_A2DP_SOFTWARE_ENCODING = 2;
    private final BluetoothAdapter mAdapter;
    private final AttributionSource mAttributionSource;
    private final BluetoothProfileConnector<IBluetoothA2dp> mProfileConnector = new BluetoothProfileConnector(this, 2, "BluetoothA2dp", IBluetoothA2dp.class.getName()){

        public IBluetoothA2dp getServiceInterface(IBinder service) {
            return IBluetoothA2dp.Stub.asInterface(service);
        }
    };

    BluetoothA2dp(Context context, BluetoothProfile.ServiceListener listener, BluetoothAdapter adapter) {
        this.mAdapter = adapter;
        this.mAttributionSource = adapter.getAttributionSource();
        this.mProfileConnector.connect(context, listener);
    }

    @UnsupportedAppUsage
    void close() {
        this.mProfileConnector.disconnect();
    }

    private IBluetoothA2dp getService() {
        return this.mProfileConnector.getService();
    }

    public void finalize() {
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @UnsupportedAppUsage
    public boolean connect(BluetoothDevice device) {
        BluetoothA2dp.log("connect(" + device + ")");
        IBluetoothA2dp service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothA2dp.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.connectWithAttribution(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @UnsupportedAppUsage
    public boolean disconnect(BluetoothDevice device) {
        BluetoothA2dp.log("disconnect(" + device + ")");
        IBluetoothA2dp service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothA2dp.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.disconnectWithAttribution(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getConnectedDevices() {
        IBluetoothA2dp service = this.getService();
        ArrayList<BluetoothDevice> defaultValue = new ArrayList<BluetoothDevice>();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothA2dp.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getConnectedDevicesWithAttribution(this.mAttributionSource, recv);
                return Attributable.setAttributionSource((List)recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue), this.mAttributionSource);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        IBluetoothA2dp service = this.getService();
        ArrayList<BluetoothDevice> defaultValue = new ArrayList<BluetoothDevice>();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothA2dp.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getDevicesMatchingConnectionStatesWithAttribution(states, this.mAttributionSource, recv);
                return Attributable.setAttributionSource((List)recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue), this.mAttributionSource);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getConnectionState(BluetoothDevice device) {
        IBluetoothA2dp service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothA2dp.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getConnectionStateWithAttribution(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 0;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @UnsupportedAppUsage(trackingBug=171933273L)
    public boolean setActiveDevice(BluetoothDevice device) {
        BluetoothA2dp.log("setActiveDevice(" + device + ")");
        IBluetoothA2dp service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothA2dp.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && (device == null || this.isValidDevice(device))) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.setActiveDevice(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @UnsupportedAppUsage(trackingBug=171933273L)
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothDevice getActiveDevice() {
        IBluetoothA2dp service = this.getService();
        BluetoothDevice defaultValue = null;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothA2dp.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getActiveDevice(this.mAttributionSource, recv);
                return Attributable.setAttributionSource(recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue), this.mAttributionSource);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setPriority(BluetoothDevice device, int priority) {
        BluetoothA2dp.log("setPriority(" + device + ", " + priority + ")");
        return this.setConnectionPolicy(device, BluetoothAdapter.priorityToConnectionPolicy(priority));
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setConnectionPolicy(BluetoothDevice device, int connectionPolicy) {
        BluetoothA2dp.log("setConnectionPolicy(" + device + ", " + connectionPolicy + ")");
        IBluetoothA2dp service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothA2dp.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && this.isValidDevice(device) && (connectionPolicy == 0 || connectionPolicy == 100)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.setConnectionPolicy(device, connectionPolicy, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public int getPriority(BluetoothDevice device) {
        return BluetoothAdapter.connectionPolicyToPriority(this.getConnectionPolicy(device));
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getConnectionPolicy(BluetoothDevice device) {
        IBluetoothA2dp service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothA2dp.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getConnectionPolicy(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 0;
    }

    @RequiresNoPermission
    public boolean isAvrcpAbsoluteVolumeSupported() {
        Log.d(TAG, "isAvrcpAbsoluteVolumeSupported");
        IBluetoothA2dp service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothA2dp.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.isAvrcpAbsoluteVolumeSupported(recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void setAvrcpAbsoluteVolume(int volume) {
        Log.d(TAG, "setAvrcpAbsoluteVolume");
        IBluetoothA2dp service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothA2dp.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                service.setAvrcpAbsoluteVolume(volume, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean isA2dpPlaying(BluetoothDevice device) {
        BluetoothA2dp.log("isA2dpPlaying(" + device + ")");
        IBluetoothA2dp service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothA2dp.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.isA2dpPlaying(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean shouldSendVolumeKeys(BluetoothDevice device) {
        if (this.isEnabled() && this.isValidDevice(device)) {
            ParcelUuid[] uuids = device.getUuids();
            if (uuids == null) {
                return false;
            }
            for (ParcelUuid uuid : uuids) {
                if (!uuid.equals(BluetoothUuid.AVRCP_TARGET)) continue;
                return true;
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public BluetoothCodecStatus getCodecStatus(BluetoothDevice device) {
        Log.d(TAG, "getCodecStatus(" + device + ")");
        this.verifyDeviceNotNull(device, "getCodecStatus");
        IBluetoothA2dp service = this.getService();
        BluetoothCodecStatus defaultValue = null;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothA2dp.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getCodecStatus(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void setCodecConfigPreference(BluetoothDevice device, BluetoothCodecConfig codecConfig) {
        Log.d(TAG, "setCodecConfigPreference(" + device + ")");
        this.verifyDeviceNotNull(device, "setCodecConfigPreference");
        if (codecConfig == null) {
            Log.e(TAG, "setCodecConfigPreference: Codec config can't be null");
            throw new IllegalArgumentException("codecConfig cannot be null");
        }
        IBluetoothA2dp service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothA2dp.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                service.setCodecConfigPreference(device, codecConfig, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void enableOptionalCodecs(BluetoothDevice device) {
        Log.d(TAG, "enableOptionalCodecs(" + device + ")");
        this.verifyDeviceNotNull(device, "enableOptionalCodecs");
        this.enableDisableOptionalCodecs(device, true);
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void disableOptionalCodecs(BluetoothDevice device) {
        Log.d(TAG, "disableOptionalCodecs(" + device + ")");
        this.verifyDeviceNotNull(device, "disableOptionalCodecs");
        this.enableDisableOptionalCodecs(device, false);
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    private void enableDisableOptionalCodecs(BluetoothDevice device, boolean enable) {
        IBluetoothA2dp service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothA2dp.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                if (enable) {
                    service.enableOptionalCodecs(device, this.mAttributionSource);
                } else {
                    service.disableOptionalCodecs(device, this.mAttributionSource);
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int isOptionalCodecsSupported(BluetoothDevice device) {
        BluetoothA2dp.log("isOptionalCodecsSupported(" + device + ")");
        this.verifyDeviceNotNull(device, "isOptionalCodecsSupported");
        IBluetoothA2dp service = this.getService();
        int defaultValue = -1;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothA2dp.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.isOptionalCodecsSupported(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(-1);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return -1;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int isOptionalCodecsEnabled(BluetoothDevice device) {
        BluetoothA2dp.log("isOptionalCodecsEnabled(" + device + ")");
        this.verifyDeviceNotNull(device, "isOptionalCodecsEnabled");
        IBluetoothA2dp service = this.getService();
        int defaultValue = -1;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothA2dp.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.isOptionalCodecsEnabled(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(-1);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return -1;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void setOptionalCodecsEnabled(BluetoothDevice device, int value) {
        BluetoothA2dp.log("setOptionalCodecsEnabled(" + device + ")");
        this.verifyDeviceNotNull(device, "setOptionalCodecsEnabled");
        if (value != -1 && value != 0 && value != 1) {
            Log.e(TAG, "Invalid value passed to setOptionalCodecsEnabled: " + value);
            return;
        }
        IBluetoothA2dp service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothA2dp.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                service.setOptionalCodecsEnabled(device, value, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getDynamicBufferSupport() {
        IBluetoothA2dp service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothA2dp.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getDynamicBufferSupport(this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 0;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public BufferConstraints getBufferConstraints() {
        IBluetoothA2dp service = this.getService();
        BufferConstraints defaultValue = null;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothA2dp.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getBufferConstraints(this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setBufferLengthMillis(int codec, int value) {
        if (value < 0) {
            Log.e(TAG, "Trying to set audio buffer length to a negative value: " + value);
            return false;
        }
        IBluetoothA2dp service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothA2dp.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.setBufferLengthMillis(codec, value, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public static String stateToString(int state) {
        switch (state) {
            case 0: {
                return "disconnected";
            }
            case 1: {
                return "connecting";
            }
            case 2: {
                return "connected";
            }
            case 3: {
                return "disconnecting";
            }
            case 10: {
                return "playing";
            }
            case 11: {
                return "not playing";
            }
        }
        return "<unknown state " + state + ">";
    }

    private boolean isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    private void verifyDeviceNotNull(BluetoothDevice device, String methodName) {
        if (device == null) {
            Log.e(TAG, methodName + ": device param is null");
            throw new IllegalArgumentException("Device cannot be null");
        }
    }

    private boolean isValidDevice(BluetoothDevice device) {
        if (device == null) {
            return false;
        }
        return BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OptionalCodecsPreferenceStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OptionalCodecsSupportStatus {
    }
}

