/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IBluetoothVolumeControlCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.bluetooth.IBluetoothVolumeControlCallback";

    public void onVolumeOffsetChanged(BluetoothDevice var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothVolumeControlCallback {
        static final int TRANSACTION_onVolumeOffsetChanged = 1;

        public Stub() {
            this.attachInterface(this, IBluetoothVolumeControlCallback.DESCRIPTOR);
        }

        public static IBluetoothVolumeControlCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBluetoothVolumeControlCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothVolumeControlCallback) {
                return (IBluetoothVolumeControlCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBluetoothVolumeControlCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onVolumeOffsetChanged(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IBluetoothVolumeControlCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBluetoothVolumeControlCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onVolumeOffsetChanged(BluetoothDevice device, int volumeOffset) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothVolumeControlCallback.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(volumeOffset);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBluetoothVolumeControlCallback {
        @Override
        public void onVolumeOffsetChanged(BluetoothDevice device, int volumeOffset) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

