/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ContentResolver;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PatternMatcher;
import android.text.TextUtils;
import android.util.AndroidException;
import android.util.Log;
import android.util.Printer;
import android.util.proto.ProtoOutputStream;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class IntentFilter
implements Parcelable {
    private static final String TAG = "IntentFilter";
    private static final String AGLOB_STR = "aglob";
    private static final String SGLOB_STR = "sglob";
    private static final String PREFIX_STR = "prefix";
    private static final String SUFFIX_STR = "suffix";
    private static final String LITERAL_STR = "literal";
    private static final String PATH_STR = "path";
    private static final String PORT_STR = "port";
    private static final String HOST_STR = "host";
    private static final String AUTH_STR = "auth";
    private static final String SSP_STR = "ssp";
    private static final String SCHEME_STR = "scheme";
    private static final String STATIC_TYPE_STR = "staticType";
    private static final String TYPE_STR = "type";
    private static final String GROUP_STR = "group";
    private static final String CAT_STR = "cat";
    private static final String NAME_STR = "name";
    private static final String ACTION_STR = "action";
    private static final String AUTO_VERIFY_STR = "autoVerify";
    public static final int SYSTEM_HIGH_PRIORITY = 1000;
    public static final int SYSTEM_LOW_PRIORITY = -1000;
    public static final int MATCH_CATEGORY_MASK = 0xFFF0000;
    public static final int MATCH_ADJUSTMENT_MASK = 65535;
    public static final int MATCH_ADJUSTMENT_NORMAL = 32768;
    public static final int MATCH_CATEGORY_EMPTY = 0x100000;
    public static final int MATCH_CATEGORY_SCHEME = 0x200000;
    public static final int MATCH_CATEGORY_HOST = 0x300000;
    public static final int MATCH_CATEGORY_PORT = 0x400000;
    public static final int MATCH_CATEGORY_PATH = 0x500000;
    public static final int MATCH_CATEGORY_SCHEME_SPECIFIC_PART = 0x580000;
    public static final int MATCH_CATEGORY_TYPE = 0x600000;
    public static final int NO_MATCH_TYPE = -1;
    public static final int NO_MATCH_DATA = -2;
    public static final int NO_MATCH_ACTION = -3;
    public static final int NO_MATCH_CATEGORY = -4;
    public static final String SCHEME_HTTP = "http";
    public static final String SCHEME_HTTPS = "https";
    public static final String SCHEME_PACKAGE = "package";
    public static final String WILDCARD = "*";
    public static final String WILDCARD_PATH = "/*";
    private int mPriority;
    @UnsupportedAppUsage
    private int mOrder;
    @UnsupportedAppUsage
    private final ArrayList<String> mActions;
    private ArrayList<String> mCategories = null;
    private ArrayList<String> mDataSchemes = null;
    private ArrayList<PatternMatcher> mDataSchemeSpecificParts = null;
    private ArrayList<AuthorityEntry> mDataAuthorities = null;
    private ArrayList<PatternMatcher> mDataPaths = null;
    private ArrayList<String> mStaticDataTypes = null;
    private ArrayList<String> mDataTypes = null;
    private ArrayList<String> mMimeGroups = null;
    private boolean mHasStaticPartialTypes = false;
    private boolean mHasDynamicPartialTypes = false;
    private static final int STATE_VERIFY_AUTO = 1;
    private static final int STATE_NEED_VERIFY = 16;
    private static final int STATE_NEED_VERIFY_CHECKED = 256;
    private static final int STATE_VERIFIED = 4096;
    private int mVerifyState;
    public static final int VISIBILITY_NONE = 0;
    public static final int VISIBILITY_EXPLICIT = 1;
    public static final int VISIBILITY_IMPLICIT = 2;
    private int mInstantAppVisibility;
    public static final Parcelable.Creator<IntentFilter> CREATOR = new Parcelable.Creator<IntentFilter>(){

        @Override
        public IntentFilter createFromParcel(Parcel source) {
            return new IntentFilter(source);
        }

        public IntentFilter[] newArray(int size) {
            return new IntentFilter[size];
        }
    };

    private static int findStringInSet(String[] set, String string2, int[] lengths, int lenPos) {
        if (set == null) {
            return -1;
        }
        int N = lengths[lenPos];
        for (int i = 0; i < N; ++i) {
            if (!set[i].equals(string2)) continue;
            return i;
        }
        return -1;
    }

    private static String[] addStringToSet(String[] set, String string2, int[] lengths, int lenPos) {
        if (IntentFilter.findStringInSet(set, string2, lengths, lenPos) >= 0) {
            return set;
        }
        if (set == null) {
            set = new String[2];
            set[0] = string2;
            lengths[lenPos] = 1;
            return set;
        }
        int N = lengths[lenPos];
        if (N < set.length) {
            set[N] = string2;
            lengths[lenPos] = N + 1;
            return set;
        }
        String[] newSet = new String[N * 3 / 2 + 2];
        System.arraycopy(set, 0, newSet, 0, N);
        set = newSet;
        set[N] = string2;
        lengths[lenPos] = N + 1;
        return set;
    }

    private static String[] removeStringFromSet(String[] set, String string2, int[] lengths, int lenPos) {
        int pos = IntentFilter.findStringInSet(set, string2, lengths, lenPos);
        if (pos < 0) {
            return set;
        }
        int N = lengths[lenPos];
        if (N > set.length / 4) {
            int copyLen = N - (pos + 1);
            if (copyLen > 0) {
                System.arraycopy(set, pos + 1, set, pos, copyLen);
            }
            set[N - 1] = null;
            lengths[lenPos] = N - 1;
            return set;
        }
        String[] newSet = new String[set.length / 3];
        if (pos > 0) {
            System.arraycopy(set, 0, newSet, 0, pos);
        }
        if (pos + 1 < N) {
            System.arraycopy(set, pos + 1, newSet, pos, N - (pos + 1));
        }
        return newSet;
    }

    public static IntentFilter create(String action, String dataType) {
        try {
            return new IntentFilter(action, dataType);
        }
        catch (MalformedMimeTypeException e) {
            throw new RuntimeException("Bad MIME type", e);
        }
    }

    public IntentFilter() {
        this.mPriority = 0;
        this.mActions = new ArrayList();
    }

    public IntentFilter(String action) {
        this.mPriority = 0;
        this.mActions = new ArrayList();
        this.addAction(action);
    }

    public IntentFilter(String action, String dataType) throws MalformedMimeTypeException {
        this.mPriority = 0;
        this.mActions = new ArrayList();
        this.addAction(action);
        this.addDataType(dataType);
    }

    public IntentFilter(IntentFilter o) {
        this.mPriority = o.mPriority;
        this.mOrder = o.mOrder;
        this.mActions = new ArrayList<String>(o.mActions);
        if (o.mCategories != null) {
            this.mCategories = new ArrayList<String>(o.mCategories);
        }
        if (o.mStaticDataTypes != null) {
            this.mStaticDataTypes = new ArrayList<String>(o.mStaticDataTypes);
        }
        if (o.mDataTypes != null) {
            this.mDataTypes = new ArrayList<String>(o.mDataTypes);
        }
        if (o.mDataSchemes != null) {
            this.mDataSchemes = new ArrayList<String>(o.mDataSchemes);
        }
        if (o.mDataSchemeSpecificParts != null) {
            this.mDataSchemeSpecificParts = new ArrayList<PatternMatcher>(o.mDataSchemeSpecificParts);
        }
        if (o.mDataAuthorities != null) {
            this.mDataAuthorities = new ArrayList<AuthorityEntry>(o.mDataAuthorities);
        }
        if (o.mDataPaths != null) {
            this.mDataPaths = new ArrayList<PatternMatcher>(o.mDataPaths);
        }
        if (o.mMimeGroups != null) {
            this.mMimeGroups = new ArrayList<String>(o.mMimeGroups);
        }
        this.mHasStaticPartialTypes = o.mHasStaticPartialTypes;
        this.mHasDynamicPartialTypes = o.mHasDynamicPartialTypes;
        this.mVerifyState = o.mVerifyState;
        this.mInstantAppVisibility = o.mInstantAppVisibility;
    }

    public void setPriority(int priority) {
        this.mPriority = priority;
    }

    public int getPriority() {
        return this.mPriority;
    }

    @SystemApi
    public void setOrder(int order) {
        this.mOrder = order;
    }

    @SystemApi
    public int getOrder() {
        return this.mOrder;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setAutoVerify(boolean autoVerify) {
        this.mVerifyState &= 0xFFFFFFFE;
        if (autoVerify) {
            this.mVerifyState |= 1;
        }
    }

    public boolean getAutoVerify() {
        return (this.mVerifyState & 1) == 1;
    }

    public boolean handleAllWebDataURI() {
        return this.hasCategory("android.intent.category.APP_BROWSER") || this.handlesWebUris(false) && this.countDataAuthorities() == 0;
    }

    public boolean handlesWebUris(boolean onlyWebSchemes) {
        if (!this.hasAction("android.intent.action.VIEW") || !this.hasCategory("android.intent.category.BROWSABLE") || this.mDataSchemes == null || this.mDataSchemes.size() == 0) {
            return false;
        }
        int N = this.mDataSchemes.size();
        for (int i = 0; i < N; ++i) {
            boolean isWebScheme;
            String scheme = this.mDataSchemes.get(i);
            boolean bl = isWebScheme = SCHEME_HTTP.equals(scheme) || SCHEME_HTTPS.equals(scheme);
            if (onlyWebSchemes) {
                if (isWebScheme) continue;
                return false;
            }
            if (!isWebScheme) continue;
            return true;
        }
        return onlyWebSchemes;
    }

    public boolean needsVerification() {
        return this.getAutoVerify() && this.handlesWebUris(true);
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public boolean isVerified() {
        if ((this.mVerifyState & 0x100) == 256) {
            return (this.mVerifyState & 0x10) == 16;
        }
        return false;
    }

    public void setVerified(boolean verified) {
        this.mVerifyState |= 0x100;
        this.mVerifyState &= 0xFFFFEFFF;
        if (verified) {
            this.mVerifyState |= 0x1000;
        }
    }

    public void setVisibilityToInstantApp(int visibility) {
        this.mInstantAppVisibility = visibility;
    }

    public int getVisibilityToInstantApp() {
        return this.mInstantAppVisibility;
    }

    public boolean isVisibleToInstantApp() {
        return this.mInstantAppVisibility != 0;
    }

    public boolean isExplicitlyVisibleToInstantApp() {
        return this.mInstantAppVisibility == 1;
    }

    public boolean isImplicitlyVisibleToInstantApp() {
        return this.mInstantAppVisibility == 2;
    }

    public void addAction(String action) {
        if (!this.mActions.contains(action)) {
            this.mActions.add(action.intern());
        }
    }

    public int countActions() {
        return this.mActions.size();
    }

    public String getAction(int index) {
        return this.mActions.get(index);
    }

    public boolean hasAction(String action) {
        return action != null && this.mActions.contains(action);
    }

    public boolean matchAction(String action) {
        return this.matchAction(action, false, null);
    }

    private boolean matchAction(String action, boolean wildcardSupported, Collection<String> ignoreActions) {
        if (wildcardSupported && WILDCARD.equals(action)) {
            if (ignoreActions == null) {
                return !this.mActions.isEmpty();
            }
            for (int i = this.mActions.size() - 1; i >= 0; --i) {
                if (ignoreActions.contains(this.mActions.get(i))) continue;
                return true;
            }
            return false;
        }
        if (ignoreActions != null && ignoreActions.contains(action)) {
            return false;
        }
        return this.hasAction(action);
    }

    public Iterator<String> actionsIterator() {
        return this.mActions != null ? this.mActions.iterator() : null;
    }

    public void addDataType(String type) throws MalformedMimeTypeException {
        this.processMimeType(type, (internalType, isPartial) -> {
            if (this.mDataTypes == null) {
                this.mDataTypes = new ArrayList();
            }
            if (this.mStaticDataTypes == null) {
                this.mStaticDataTypes = new ArrayList();
            }
            if (this.mDataTypes.contains(internalType)) {
                return;
            }
            this.mDataTypes.add(internalType.intern());
            this.mStaticDataTypes.add(internalType.intern());
            this.mHasStaticPartialTypes = this.mHasStaticPartialTypes || isPartial != false;
        });
    }

    public void addDynamicDataType(String type) throws MalformedMimeTypeException {
        this.processMimeType(type, (internalType, isPartial) -> {
            if (this.mDataTypes == null) {
                this.mDataTypes = new ArrayList();
            }
            if (!this.mDataTypes.contains(internalType)) {
                this.mDataTypes.add(internalType.intern());
                this.mHasDynamicPartialTypes = this.mHasDynamicPartialTypes || isPartial != false;
            }
        });
    }

    private void processMimeType(String type, BiConsumer<String, Boolean> action) throws MalformedMimeTypeException {
        int slashpos = type.indexOf(47);
        int typelen = type.length();
        if (slashpos <= 0 || typelen < slashpos + 2) {
            throw new MalformedMimeTypeException(type);
        }
        String internalType = type;
        boolean isPartialType = false;
        if (typelen == slashpos + 2 && type.charAt(slashpos + 1) == '*') {
            internalType = type.substring(0, slashpos);
            isPartialType = true;
        }
        action.accept(internalType, isPartialType);
    }

    public void clearDynamicDataTypes() {
        if (this.mDataTypes == null) {
            return;
        }
        if (this.mStaticDataTypes != null) {
            this.mDataTypes.clear();
            this.mDataTypes.addAll(this.mStaticDataTypes);
        } else {
            this.mDataTypes = null;
        }
        this.mHasDynamicPartialTypes = false;
    }

    public int countStaticDataTypes() {
        return this.mStaticDataTypes != null ? this.mStaticDataTypes.size() : 0;
    }

    public boolean hasDataType(String type) {
        return this.mDataTypes != null && this.findMimeType(type);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean hasExactDataType(String type) {
        return this.mDataTypes != null && this.mDataTypes.contains(type);
    }

    public boolean hasExactDynamicDataType(String type) {
        return this.hasExactDataType(type) && !this.hasExactStaticDataType(type);
    }

    public boolean hasExactStaticDataType(String type) {
        return this.mStaticDataTypes != null && this.mStaticDataTypes.contains(type);
    }

    public int countDataTypes() {
        return this.mDataTypes != null ? this.mDataTypes.size() : 0;
    }

    public String getDataType(int index) {
        return this.mDataTypes.get(index);
    }

    public Iterator<String> typesIterator() {
        return this.mDataTypes != null ? this.mDataTypes.iterator() : null;
    }

    public List<String> dataTypes() {
        return this.mDataTypes != null ? new ArrayList<String>(this.mDataTypes) : null;
    }

    public void addMimeGroup(String name) {
        if (this.mMimeGroups == null) {
            this.mMimeGroups = new ArrayList();
        }
        if (!this.mMimeGroups.contains(name)) {
            this.mMimeGroups.add(name);
        }
    }

    public boolean hasMimeGroup(String name) {
        return this.mMimeGroups != null && this.mMimeGroups.contains(name);
    }

    public String getMimeGroup(int index) {
        return this.mMimeGroups.get(index);
    }

    public int countMimeGroups() {
        return this.mMimeGroups != null ? this.mMimeGroups.size() : 0;
    }

    public Iterator<String> mimeGroupsIterator() {
        return this.mMimeGroups != null ? this.mMimeGroups.iterator() : null;
    }

    public void addDataScheme(String scheme) {
        if (this.mDataSchemes == null) {
            this.mDataSchemes = new ArrayList();
        }
        if (!this.mDataSchemes.contains(scheme)) {
            this.mDataSchemes.add(scheme.intern());
        }
    }

    public int countDataSchemes() {
        return this.mDataSchemes != null ? this.mDataSchemes.size() : 0;
    }

    public String getDataScheme(int index) {
        return this.mDataSchemes.get(index);
    }

    public boolean hasDataScheme(String scheme) {
        return this.mDataSchemes != null && this.mDataSchemes.contains(scheme);
    }

    public Iterator<String> schemesIterator() {
        return this.mDataSchemes != null ? this.mDataSchemes.iterator() : null;
    }

    public void addDataSchemeSpecificPart(String ssp, int type) {
        this.addDataSchemeSpecificPart(new PatternMatcher(ssp, type));
    }

    public void addDataSchemeSpecificPart(PatternMatcher ssp) {
        if (this.mDataSchemeSpecificParts == null) {
            this.mDataSchemeSpecificParts = new ArrayList();
        }
        this.mDataSchemeSpecificParts.add(ssp);
    }

    public int countDataSchemeSpecificParts() {
        return this.mDataSchemeSpecificParts != null ? this.mDataSchemeSpecificParts.size() : 0;
    }

    public PatternMatcher getDataSchemeSpecificPart(int index) {
        return this.mDataSchemeSpecificParts.get(index);
    }

    public boolean hasDataSchemeSpecificPart(String data) {
        return this.hasDataSchemeSpecificPart(data, false);
    }

    private boolean hasDataSchemeSpecificPart(String data, boolean supportWildcards) {
        if (this.mDataSchemeSpecificParts == null) {
            return false;
        }
        if (supportWildcards && WILDCARD.equals(data) && this.mDataSchemeSpecificParts.size() > 0) {
            return true;
        }
        int numDataSchemeSpecificParts = this.mDataSchemeSpecificParts.size();
        for (int i = 0; i < numDataSchemeSpecificParts; ++i) {
            PatternMatcher pe = this.mDataSchemeSpecificParts.get(i);
            if (!pe.match(data)) continue;
            return true;
        }
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean hasDataSchemeSpecificPart(PatternMatcher ssp) {
        if (this.mDataSchemeSpecificParts == null) {
            return false;
        }
        int numDataSchemeSpecificParts = this.mDataSchemeSpecificParts.size();
        for (int i = 0; i < numDataSchemeSpecificParts; ++i) {
            PatternMatcher pe = this.mDataSchemeSpecificParts.get(i);
            if (pe.getType() != ssp.getType() || !pe.getPath().equals(ssp.getPath())) continue;
            return true;
        }
        return false;
    }

    public Iterator<PatternMatcher> schemeSpecificPartsIterator() {
        return this.mDataSchemeSpecificParts != null ? this.mDataSchemeSpecificParts.iterator() : null;
    }

    public void addDataAuthority(String host, String port) {
        if (port != null) {
            port = port.intern();
        }
        this.addDataAuthority(new AuthorityEntry(host.intern(), port));
    }

    public void addDataAuthority(AuthorityEntry ent) {
        if (this.mDataAuthorities == null) {
            this.mDataAuthorities = new ArrayList();
        }
        this.mDataAuthorities.add(ent);
    }

    public int countDataAuthorities() {
        return this.mDataAuthorities != null ? this.mDataAuthorities.size() : 0;
    }

    public AuthorityEntry getDataAuthority(int index) {
        return this.mDataAuthorities.get(index);
    }

    public boolean hasDataAuthority(Uri data) {
        return this.matchDataAuthority(data) >= 0;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean hasDataAuthority(AuthorityEntry auth) {
        if (this.mDataAuthorities == null) {
            return false;
        }
        int numDataAuthorities = this.mDataAuthorities.size();
        for (int i = 0; i < numDataAuthorities; ++i) {
            if (!this.mDataAuthorities.get(i).match(auth)) continue;
            return true;
        }
        return false;
    }

    public Iterator<AuthorityEntry> authoritiesIterator() {
        return this.mDataAuthorities != null ? this.mDataAuthorities.iterator() : null;
    }

    public void addDataPath(String path, int type) {
        this.addDataPath(new PatternMatcher(path.intern(), type));
    }

    public void addDataPath(PatternMatcher path) {
        if (this.mDataPaths == null) {
            this.mDataPaths = new ArrayList();
        }
        this.mDataPaths.add(path);
    }

    public int countDataPaths() {
        return this.mDataPaths != null ? this.mDataPaths.size() : 0;
    }

    public PatternMatcher getDataPath(int index) {
        return this.mDataPaths.get(index);
    }

    public boolean hasDataPath(String data) {
        return this.hasDataPath(data, false);
    }

    private boolean hasDataPath(String data, boolean wildcardSupported) {
        if (this.mDataPaths == null) {
            return false;
        }
        if (wildcardSupported && WILDCARD_PATH.equals(data)) {
            return true;
        }
        int numDataPaths = this.mDataPaths.size();
        for (int i = 0; i < numDataPaths; ++i) {
            PatternMatcher pe = this.mDataPaths.get(i);
            if (!pe.match(data)) continue;
            return true;
        }
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean hasDataPath(PatternMatcher path) {
        if (this.mDataPaths == null) {
            return false;
        }
        int numDataPaths = this.mDataPaths.size();
        for (int i = 0; i < numDataPaths; ++i) {
            PatternMatcher pe = this.mDataPaths.get(i);
            if (pe.getType() != path.getType() || !pe.getPath().equals(path.getPath())) continue;
            return true;
        }
        return false;
    }

    public Iterator<PatternMatcher> pathsIterator() {
        return this.mDataPaths != null ? this.mDataPaths.iterator() : null;
    }

    public int matchDataAuthority(Uri data) {
        return this.matchDataAuthority(data, false);
    }

    public int matchDataAuthority(Uri data, boolean wildcardSupported) {
        if (data == null || this.mDataAuthorities == null) {
            return -2;
        }
        int numDataAuthorities = this.mDataAuthorities.size();
        for (int i = 0; i < numDataAuthorities; ++i) {
            AuthorityEntry ae = this.mDataAuthorities.get(i);
            int match = ae.match(data, wildcardSupported);
            if (match < 0) continue;
            return match;
        }
        return -2;
    }

    public int matchData(String type, String scheme, Uri data) {
        return this.matchData(type, scheme, data, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int matchData(String type, String scheme, Uri data, boolean wildcardSupported) {
        boolean wildcardWithMimegroups = wildcardSupported && this.countMimeGroups() != 0;
        ArrayList<String> types = this.mDataTypes;
        ArrayList<String> schemes = this.mDataSchemes;
        int match = 0x100000;
        if (!wildcardWithMimegroups && types == null && schemes == null) {
            if (type != null) return -2;
            if (data != null) return -2;
            return 0x108000;
        }
        if (schemes != null) {
            ArrayList<AuthorityEntry> authorities;
            if (!schemes.contains(scheme != null ? scheme : "")) {
                if (!wildcardSupported) return -2;
                if (!WILDCARD.equals(scheme)) return -2;
            }
            match = 0x200000;
            ArrayList<PatternMatcher> schemeSpecificParts = this.mDataSchemeSpecificParts;
            if (schemeSpecificParts != null && data != null) {
                int n = match = this.hasDataSchemeSpecificPart(data.getSchemeSpecificPart(), wildcardSupported) ? 0x580000 : -2;
            }
            if (match != 0x580000 && (authorities = this.mDataAuthorities) != null) {
                int authMatch = this.matchDataAuthority(data, wildcardSupported);
                if (authMatch < 0) return -2;
                ArrayList<PatternMatcher> paths = this.mDataPaths;
                if (paths == null) {
                    match = authMatch;
                } else {
                    if (!this.hasDataPath(data.getPath(), wildcardSupported)) return -2;
                    match = 0x500000;
                }
            }
            if (match == -2) {
                return -2;
            }
        } else if (!(scheme == null || "".equals(scheme) || "content".equals(scheme) || "file".equals(scheme))) {
            if (!wildcardSupported) return -2;
            if (!WILDCARD.equals(scheme)) {
                return -2;
            }
        }
        if (wildcardWithMimegroups) {
            return 0x600000;
        }
        if (types != null) {
            if (!this.findMimeType(type)) return -1;
            return 0x608000;
        }
        if (type == null) return match + 32768;
        return -1;
    }

    public void addCategory(String category) {
        if (this.mCategories == null) {
            this.mCategories = new ArrayList();
        }
        if (!this.mCategories.contains(category)) {
            this.mCategories.add(category.intern());
        }
    }

    public int countCategories() {
        return this.mCategories != null ? this.mCategories.size() : 0;
    }

    public String getCategory(int index) {
        return this.mCategories.get(index);
    }

    public boolean hasCategory(String category) {
        return this.mCategories != null && this.mCategories.contains(category);
    }

    public Iterator<String> categoriesIterator() {
        return this.mCategories != null ? this.mCategories.iterator() : null;
    }

    public String matchCategories(Set<String> categories) {
        if (categories == null) {
            return null;
        }
        Iterator<String> it = categories.iterator();
        if (this.mCategories == null) {
            return it.hasNext() ? it.next() : null;
        }
        while (it.hasNext()) {
            String category = it.next();
            if (this.mCategories.contains(category)) continue;
            return category;
        }
        return null;
    }

    public Predicate<Intent> asPredicate() {
        return i -> this.match(null, (Intent)i, false, TAG) >= 0;
    }

    public Predicate<Intent> asPredicateWithTypeResolution(ContentResolver resolver) {
        Objects.requireNonNull(resolver);
        return i -> this.match(resolver, (Intent)i, true, TAG) >= 0;
    }

    public int match(ContentResolver resolver, Intent intent, boolean resolve, String logTag) {
        String type = resolve ? intent.resolveType(resolver) : intent.getType();
        return this.match(intent.getAction(), type, intent.getScheme(), intent.getData(), intent.getCategories(), logTag);
    }

    public int match(String action, String type, String scheme, Uri data, Set<String> categories, String logTag) {
        return this.match(action, type, scheme, data, categories, logTag, false, null);
    }

    public int match(String action, String type, String scheme, Uri data, Set<String> categories, String logTag, boolean supportWildcards, Collection<String> ignoreActions) {
        if (action != null && !this.matchAction(action, supportWildcards, ignoreActions)) {
            return -3;
        }
        int dataMatch = this.matchData(type, scheme, data, supportWildcards);
        if (dataMatch < 0) {
            return dataMatch;
        }
        String categoryMismatch = this.matchCategories(categories);
        if (categoryMismatch != null) {
            return -4;
        }
        return dataMatch;
    }

    public void writeToXml(XmlSerializer serializer) throws IOException {
        PatternMatcher pe;
        int i;
        if (this.getAutoVerify()) {
            serializer.attribute(null, AUTO_VERIFY_STR, Boolean.toString(true));
        }
        int N = this.countActions();
        for (i = 0; i < N; ++i) {
            serializer.startTag(null, ACTION_STR);
            serializer.attribute(null, NAME_STR, this.mActions.get(i));
            serializer.endTag(null, ACTION_STR);
        }
        N = this.countCategories();
        for (i = 0; i < N; ++i) {
            serializer.startTag(null, CAT_STR);
            serializer.attribute(null, NAME_STR, this.mCategories.get(i));
            serializer.endTag(null, CAT_STR);
        }
        this.writeDataTypesToXml(serializer);
        N = this.countMimeGroups();
        for (i = 0; i < N; ++i) {
            serializer.startTag(null, GROUP_STR);
            serializer.attribute(null, NAME_STR, this.mMimeGroups.get(i));
            serializer.endTag(null, GROUP_STR);
        }
        N = this.countDataSchemes();
        for (i = 0; i < N; ++i) {
            serializer.startTag(null, SCHEME_STR);
            serializer.attribute(null, NAME_STR, this.mDataSchemes.get(i));
            serializer.endTag(null, SCHEME_STR);
        }
        N = this.countDataSchemeSpecificParts();
        for (i = 0; i < N; ++i) {
            serializer.startTag(null, SSP_STR);
            pe = this.mDataSchemeSpecificParts.get(i);
            switch (pe.getType()) {
                case 0: {
                    serializer.attribute(null, LITERAL_STR, pe.getPath());
                    break;
                }
                case 1: {
                    serializer.attribute(null, PREFIX_STR, pe.getPath());
                    break;
                }
                case 2: {
                    serializer.attribute(null, SGLOB_STR, pe.getPath());
                    break;
                }
                case 3: {
                    serializer.attribute(null, AGLOB_STR, pe.getPath());
                    break;
                }
                case 4: {
                    serializer.attribute(null, SUFFIX_STR, pe.getPath());
                }
            }
            serializer.endTag(null, SSP_STR);
        }
        N = this.countDataAuthorities();
        for (i = 0; i < N; ++i) {
            serializer.startTag(null, AUTH_STR);
            AuthorityEntry ae = this.mDataAuthorities.get(i);
            serializer.attribute(null, HOST_STR, ae.getHost());
            if (ae.getPort() >= 0) {
                serializer.attribute(null, PORT_STR, Integer.toString(ae.getPort()));
            }
            serializer.endTag(null, AUTH_STR);
        }
        N = this.countDataPaths();
        for (i = 0; i < N; ++i) {
            serializer.startTag(null, PATH_STR);
            pe = this.mDataPaths.get(i);
            switch (pe.getType()) {
                case 0: {
                    serializer.attribute(null, LITERAL_STR, pe.getPath());
                    break;
                }
                case 1: {
                    serializer.attribute(null, PREFIX_STR, pe.getPath());
                    break;
                }
                case 2: {
                    serializer.attribute(null, SGLOB_STR, pe.getPath());
                    break;
                }
                case 3: {
                    serializer.attribute(null, AGLOB_STR, pe.getPath());
                    break;
                }
                case 4: {
                    serializer.attribute(null, SUFFIX_STR, pe.getPath());
                }
            }
            serializer.endTag(null, PATH_STR);
        }
    }

    private void writeDataTypesToXml(XmlSerializer serializer) throws IOException {
        if (this.mStaticDataTypes == null) {
            return;
        }
        int i = 0;
        for (String staticType : this.mStaticDataTypes) {
            while (!this.mDataTypes.get(i).equals(staticType)) {
                this.writeDataTypeToXml(serializer, this.mDataTypes.get(i), TYPE_STR);
                ++i;
            }
            this.writeDataTypeToXml(serializer, staticType, STATIC_TYPE_STR);
            ++i;
        }
        while (i < this.mDataTypes.size()) {
            this.writeDataTypeToXml(serializer, this.mDataTypes.get(i), TYPE_STR);
            ++i;
        }
    }

    private void writeDataTypeToXml(XmlSerializer serializer, String type, String tag) throws IOException {
        serializer.startTag(null, tag);
        if (type.indexOf(47) < 0) {
            type = type + WILDCARD_PATH;
        }
        serializer.attribute(null, NAME_STR, type);
        serializer.endTag(null, tag);
    }

    public void readFromXml(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        String autoVerify = parser.getAttributeValue(null, AUTO_VERIFY_STR);
        this.setAutoVerify(TextUtils.isEmpty(autoVerify) ? false : Boolean.getBoolean(autoVerify));
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String name;
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals(ACTION_STR)) {
                name = parser.getAttributeValue(null, NAME_STR);
                if (name != null) {
                    this.addAction(name);
                }
            } else if (tagName.equals(CAT_STR)) {
                name = parser.getAttributeValue(null, NAME_STR);
                if (name != null) {
                    this.addCategory(name);
                }
            } else if (tagName.equals(STATIC_TYPE_STR)) {
                name = parser.getAttributeValue(null, NAME_STR);
                if (name != null) {
                    try {
                        this.addDataType(name);
                    }
                    catch (MalformedMimeTypeException malformedMimeTypeException) {}
                }
            } else if (tagName.equals(TYPE_STR)) {
                name = parser.getAttributeValue(null, NAME_STR);
                if (name != null) {
                    try {
                        this.addDynamicDataType(name);
                    }
                    catch (MalformedMimeTypeException malformedMimeTypeException) {}
                }
            } else if (tagName.equals(GROUP_STR)) {
                name = parser.getAttributeValue(null, NAME_STR);
                if (name != null) {
                    this.addMimeGroup(name);
                }
            } else if (tagName.equals(SCHEME_STR)) {
                name = parser.getAttributeValue(null, NAME_STR);
                if (name != null) {
                    this.addDataScheme(name);
                }
            } else if (tagName.equals(SSP_STR)) {
                String ssp = parser.getAttributeValue(null, LITERAL_STR);
                if (ssp != null) {
                    this.addDataSchemeSpecificPart(ssp, 0);
                } else {
                    ssp = parser.getAttributeValue(null, PREFIX_STR);
                    if (ssp != null) {
                        this.addDataSchemeSpecificPart(ssp, 1);
                    } else {
                        ssp = parser.getAttributeValue(null, SGLOB_STR);
                        if (ssp != null) {
                            this.addDataSchemeSpecificPart(ssp, 2);
                        } else {
                            ssp = parser.getAttributeValue(null, AGLOB_STR);
                            if (ssp != null) {
                                this.addDataSchemeSpecificPart(ssp, 3);
                            } else {
                                ssp = parser.getAttributeValue(null, SUFFIX_STR);
                                if (ssp != null) {
                                    this.addDataSchemeSpecificPart(ssp, 4);
                                }
                            }
                        }
                    }
                }
            } else if (tagName.equals(AUTH_STR)) {
                String host = parser.getAttributeValue(null, HOST_STR);
                String port = parser.getAttributeValue(null, PORT_STR);
                if (host != null) {
                    this.addDataAuthority(host, port);
                }
            } else if (tagName.equals(PATH_STR)) {
                String path = parser.getAttributeValue(null, LITERAL_STR);
                if (path != null) {
                    this.addDataPath(path, 0);
                } else {
                    path = parser.getAttributeValue(null, PREFIX_STR);
                    if (path != null) {
                        this.addDataPath(path, 1);
                    } else {
                        path = parser.getAttributeValue(null, SGLOB_STR);
                        if (path != null) {
                            this.addDataPath(path, 2);
                        } else {
                            path = parser.getAttributeValue(null, AGLOB_STR);
                            if (path != null) {
                                this.addDataPath(path, 3);
                            } else {
                                path = parser.getAttributeValue(null, SUFFIX_STR);
                                if (path != null) {
                                    this.addDataPath(path, 4);
                                }
                            }
                        }
                    }
                }
            } else {
                Log.w(TAG, "Unknown tag parsing IntentFilter: " + tagName);
            }
            XmlUtils.skipCurrentTag(parser);
        }
    }

    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        Iterator<Object> it;
        long token = proto.start(fieldId);
        if (this.mActions.size() > 0) {
            it = this.mActions.iterator();
            while (it.hasNext()) {
                proto.write(2237677961217L, it.next());
            }
        }
        if (this.mCategories != null) {
            it = this.mCategories.iterator();
            while (it.hasNext()) {
                proto.write(0x20900000002L, it.next());
            }
        }
        if (this.mDataSchemes != null) {
            it = this.mDataSchemes.iterator();
            while (it.hasNext()) {
                proto.write(2237677961219L, (String)it.next());
            }
        }
        if (this.mDataSchemeSpecificParts != null) {
            it = this.mDataSchemeSpecificParts.iterator();
            while (it.hasNext()) {
                ((PatternMatcher)it.next()).dumpDebug(proto, 2246267895812L);
            }
        }
        if (this.mDataAuthorities != null) {
            it = this.mDataAuthorities.iterator();
            while (it.hasNext()) {
                ((AuthorityEntry)it.next()).dumpDebug(proto, 2246267895813L);
            }
        }
        if (this.mDataPaths != null) {
            it = this.mDataPaths.iterator();
            while (it.hasNext()) {
                ((PatternMatcher)it.next()).dumpDebug(proto, 2246267895814L);
            }
        }
        if (this.mDataTypes != null) {
            it = this.mDataTypes.iterator();
            while (it.hasNext()) {
                proto.write(2237677961223L, (String)it.next());
            }
        }
        if (this.mMimeGroups != null) {
            it = this.mMimeGroups.iterator();
            while (it.hasNext()) {
                proto.write(2237677961227L, (String)it.next());
            }
        }
        if (this.mPriority != 0 || this.hasPartialTypes()) {
            proto.write(1120986464264L, this.mPriority);
            proto.write(1133871366153L, this.hasPartialTypes());
        }
        proto.write(1133871366154L, this.getAutoVerify());
        proto.end(token);
    }

    public void dump(Printer du, String prefix) {
        Iterator<Object> it;
        StringBuilder sb = new StringBuilder(256);
        if (this.mActions.size() > 0) {
            it = this.mActions.iterator();
            while (it.hasNext()) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("Action: \"");
                sb.append((String)it.next());
                sb.append("\"");
                du.println(sb.toString());
            }
        }
        if (this.mCategories != null) {
            it = this.mCategories.iterator();
            while (it.hasNext()) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("Category: \"");
                sb.append((String)it.next());
                sb.append("\"");
                du.println(sb.toString());
            }
        }
        if (this.mDataSchemes != null) {
            it = this.mDataSchemes.iterator();
            while (it.hasNext()) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("Scheme: \"");
                sb.append((String)it.next());
                sb.append("\"");
                du.println(sb.toString());
            }
        }
        if (this.mDataSchemeSpecificParts != null) {
            for (PatternMatcher pe : this.mDataSchemeSpecificParts) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("Ssp: \"");
                sb.append(pe);
                sb.append("\"");
                du.println(sb.toString());
            }
        }
        if (this.mDataAuthorities != null) {
            for (AuthorityEntry ae : this.mDataAuthorities) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("Authority: \"");
                sb.append(ae.mHost);
                sb.append("\": ");
                sb.append(ae.mPort);
                if (ae.mWild) {
                    sb.append(" WILD");
                }
                du.println(sb.toString());
            }
        }
        if (this.mDataPaths != null) {
            for (PatternMatcher pe : this.mDataPaths) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("Path: \"");
                sb.append(pe);
                sb.append("\"");
                du.println(sb.toString());
            }
        }
        if (this.mStaticDataTypes != null) {
            it = this.mStaticDataTypes.iterator();
            while (it.hasNext()) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("StaticType: \"");
                sb.append((String)it.next());
                sb.append("\"");
                du.println(sb.toString());
            }
        }
        if (this.mDataTypes != null) {
            for (String dataType : this.mDataTypes) {
                if (this.hasExactStaticDataType(dataType)) continue;
                sb.setLength(0);
                sb.append(prefix);
                sb.append("Type: \"");
                sb.append(dataType);
                sb.append("\"");
                du.println(sb.toString());
            }
        }
        if (this.mMimeGroups != null) {
            it = this.mMimeGroups.iterator();
            while (it.hasNext()) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("MimeGroup: \"");
                sb.append((String)it.next());
                sb.append("\"");
                du.println(sb.toString());
            }
        }
        if (this.mPriority != 0 || this.mOrder != 0 || this.hasPartialTypes()) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("mPriority=");
            sb.append(this.mPriority);
            sb.append(", mOrder=");
            sb.append(this.mOrder);
            sb.append(", mHasStaticPartialTypes=");
            sb.append(this.mHasStaticPartialTypes);
            sb.append(", mHasDynamicPartialTypes=");
            sb.append(this.mHasDynamicPartialTypes);
            du.println(sb.toString());
        }
        if (this.getAutoVerify()) {
            sb.setLength(0);
            sb.append(prefix);
            sb.append("AutoVerify=");
            sb.append(this.getAutoVerify());
            du.println(sb.toString());
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        int i;
        int N;
        dest.writeStringList(this.mActions);
        if (this.mCategories != null) {
            dest.writeInt(1);
            dest.writeStringList(this.mCategories);
        } else {
            dest.writeInt(0);
        }
        if (this.mDataSchemes != null) {
            dest.writeInt(1);
            dest.writeStringList(this.mDataSchemes);
        } else {
            dest.writeInt(0);
        }
        if (this.mStaticDataTypes != null) {
            dest.writeInt(1);
            dest.writeStringList(this.mStaticDataTypes);
        } else {
            dest.writeInt(0);
        }
        if (this.mDataTypes != null) {
            dest.writeInt(1);
            dest.writeStringList(this.mDataTypes);
        } else {
            dest.writeInt(0);
        }
        if (this.mMimeGroups != null) {
            dest.writeInt(1);
            dest.writeStringList(this.mMimeGroups);
        } else {
            dest.writeInt(0);
        }
        if (this.mDataSchemeSpecificParts != null) {
            N = this.mDataSchemeSpecificParts.size();
            dest.writeInt(N);
            for (i = 0; i < N; ++i) {
                this.mDataSchemeSpecificParts.get(i).writeToParcel(dest, flags);
            }
        } else {
            dest.writeInt(0);
        }
        if (this.mDataAuthorities != null) {
            N = this.mDataAuthorities.size();
            dest.writeInt(N);
            for (i = 0; i < N; ++i) {
                this.mDataAuthorities.get(i).writeToParcel(dest);
            }
        } else {
            dest.writeInt(0);
        }
        if (this.mDataPaths != null) {
            N = this.mDataPaths.size();
            dest.writeInt(N);
            for (i = 0; i < N; ++i) {
                this.mDataPaths.get(i).writeToParcel(dest, flags);
            }
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.mPriority);
        dest.writeInt(this.mHasStaticPartialTypes ? 1 : 0);
        dest.writeInt(this.mHasDynamicPartialTypes ? 1 : 0);
        dest.writeInt(this.getAutoVerify() ? 1 : 0);
        dest.writeInt(this.mInstantAppVisibility);
        dest.writeInt(this.mOrder);
    }

    public boolean debugCheck() {
        return true;
    }

    public IntentFilter(Parcel source) {
        int i;
        int N;
        this.mActions = new ArrayList();
        source.readStringList(this.mActions);
        if (source.readInt() != 0) {
            this.mCategories = new ArrayList();
            source.readStringList(this.mCategories);
        }
        if (source.readInt() != 0) {
            this.mDataSchemes = new ArrayList();
            source.readStringList(this.mDataSchemes);
        }
        if (source.readInt() != 0) {
            this.mStaticDataTypes = new ArrayList();
            source.readStringList(this.mStaticDataTypes);
        }
        if (source.readInt() != 0) {
            this.mDataTypes = new ArrayList();
            source.readStringList(this.mDataTypes);
        }
        if (source.readInt() != 0) {
            this.mMimeGroups = new ArrayList();
            source.readStringList(this.mMimeGroups);
        }
        if ((N = source.readInt()) > 0) {
            this.mDataSchemeSpecificParts = new ArrayList(N);
            for (i = 0; i < N; ++i) {
                this.mDataSchemeSpecificParts.add(new PatternMatcher(source));
            }
        }
        if ((N = source.readInt()) > 0) {
            this.mDataAuthorities = new ArrayList(N);
            for (i = 0; i < N; ++i) {
                this.mDataAuthorities.add(new AuthorityEntry(source));
            }
        }
        if ((N = source.readInt()) > 0) {
            this.mDataPaths = new ArrayList(N);
            for (i = 0; i < N; ++i) {
                this.mDataPaths.add(new PatternMatcher(source));
            }
        }
        this.mPriority = source.readInt();
        this.mHasStaticPartialTypes = source.readInt() > 0;
        this.mHasDynamicPartialTypes = source.readInt() > 0;
        this.setAutoVerify(source.readInt() > 0);
        this.setVisibilityToInstantApp(source.readInt());
        this.mOrder = source.readInt();
    }

    private boolean hasPartialTypes() {
        return this.mHasStaticPartialTypes || this.mHasDynamicPartialTypes;
    }

    private boolean findMimeType(String type) {
        ArrayList<String> t = this.mDataTypes;
        if (type == null) {
            return false;
        }
        if (t.contains(type)) {
            return true;
        }
        int typeLength = type.length();
        if (typeLength == 3 && type.equals("*/*")) {
            return !t.isEmpty();
        }
        if (this.hasPartialTypes() && t.contains(WILDCARD)) {
            return true;
        }
        int slashpos = type.indexOf(47);
        if (slashpos > 0) {
            if (this.hasPartialTypes() && t.contains(type.substring(0, slashpos))) {
                return true;
            }
            if (typeLength == slashpos + 2 && type.charAt(slashpos + 1) == '*') {
                int numTypes = t.size();
                for (int i = 0; i < numTypes; ++i) {
                    String v = t.get(i);
                    if (!type.regionMatches(0, v, 0, slashpos + 1)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public ArrayList<String> getHostsList() {
        ArrayList<String> result = new ArrayList<String>();
        Iterator<AuthorityEntry> it = this.authoritiesIterator();
        if (it != null) {
            while (it.hasNext()) {
                AuthorityEntry entry = it.next();
                result.add(entry.getHost());
            }
        }
        return result;
    }

    public String[] getHosts() {
        ArrayList<String> list = this.getHostsList();
        return list.toArray(new String[list.size()]);
    }

    public static class AuthorityEntry {
        private final String mOrigHost;
        private final String mHost;
        private final boolean mWild;
        private final int mPort;

        public AuthorityEntry(String host, String port) {
            this.mOrigHost = host;
            this.mWild = host.length() > 0 && host.charAt(0) == '*';
            this.mHost = this.mWild ? host.substring(1).intern() : host;
            this.mPort = port != null ? Integer.parseInt(port) : -1;
        }

        AuthorityEntry(Parcel src) {
            this.mOrigHost = src.readString();
            this.mHost = src.readString();
            this.mWild = src.readInt() != 0;
            this.mPort = src.readInt();
        }

        void writeToParcel(Parcel dest) {
            dest.writeString(this.mOrigHost);
            dest.writeString(this.mHost);
            dest.writeInt(this.mWild ? 1 : 0);
            dest.writeInt(this.mPort);
        }

        void dumpDebug(ProtoOutputStream proto, long fieldId) {
            long token = proto.start(fieldId);
            proto.write(0x10900000001L, this.mHost);
            proto.write(1133871366146L, this.mWild);
            proto.write(1120986464259L, this.mPort);
            proto.end(token);
        }

        public String getHost() {
            return this.mOrigHost;
        }

        public int getPort() {
            return this.mPort;
        }

        public boolean match(AuthorityEntry other) {
            if (this.mWild != other.mWild) {
                return false;
            }
            if (!this.mHost.equals(other.mHost)) {
                return false;
            }
            return this.mPort == other.mPort;
        }

        public boolean equals(Object obj) {
            if (obj instanceof AuthorityEntry) {
                AuthorityEntry other = (AuthorityEntry)obj;
                return this.match(other);
            }
            return false;
        }

        public int match(Uri data) {
            return this.match(data, false);
        }

        public int match(Uri data, boolean wildcardSupported) {
            String host = data.getHost();
            if (host == null) {
                if (wildcardSupported && this.mWild && this.mHost.isEmpty()) {
                    return 0x300000;
                }
                return -2;
            }
            if (!wildcardSupported || !IntentFilter.WILDCARD.equals(host)) {
                if (this.mWild) {
                    if (host.length() < this.mHost.length()) {
                        return -2;
                    }
                    host = host.substring(host.length() - this.mHost.length());
                }
                if (host.compareToIgnoreCase(this.mHost) != 0) {
                    return -2;
                }
            }
            if (!wildcardSupported && this.mPort >= 0) {
                if (this.mPort != data.getPort()) {
                    return -2;
                }
                return 0x400000;
            }
            return 0x300000;
        }
    }

    public static class MalformedMimeTypeException
    extends AndroidException {
        public MalformedMimeTypeException() {
        }

        public MalformedMimeTypeException(String name) {
            super(name);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InstantAppVisibility {
    }
}

