/*
 * Decompiled with CFR 0.152.
 */
package android.content.integrity;

import android.annotation.SystemApi;
import android.content.integrity.Rule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SystemApi
public class RuleSet {
    private final String mVersion;
    private final List<Rule> mRules;

    private RuleSet(String version, List<Rule> rules) {
        this.mVersion = version;
        this.mRules = Collections.unmodifiableList(rules);
    }

    public String getVersion() {
        return this.mVersion;
    }

    public List<Rule> getRules() {
        return this.mRules;
    }

    public static class Builder {
        private String mVersion;
        private List<Rule> mRules = new ArrayList<Rule>();

        public Builder setVersion(String version) {
            this.mVersion = version;
            return this;
        }

        public Builder addRules(List<Rule> rules) {
            this.mRules.addAll(rules);
            return this;
        }

        public RuleSet build() {
            Objects.requireNonNull(this.mVersion);
            return new RuleSet(this.mVersion, this.mRules);
        }
    }
}

