/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IBiometricContextListener
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.biometrics.IBiometricContextListener";

    public void onDozeChanged(boolean var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBiometricContextListener {
        static final int TRANSACTION_onDozeChanged = 1;

        public Stub() {
            this.attachInterface(this, IBiometricContextListener.DESCRIPTOR);
        }

        public static IBiometricContextListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBiometricContextListener.DESCRIPTOR);
            if (iin != null && iin instanceof IBiometricContextListener) {
                return (IBiometricContextListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onDozeChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBiometricContextListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onDozeChanged(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IBiometricContextListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBiometricContextListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDozeChanged(boolean isDozing) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBiometricContextListener.DESCRIPTOR);
                    _data.writeBoolean(isDozing);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBiometricContextListener {
        @Override
        public void onDozeChanged(boolean isDozing) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

