/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Rect;
import android.hardware.camera2.CameraMetadata;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.impl.PublicKey;
import android.hardware.camera2.impl.SyntheticKey;
import android.hardware.camera2.params.ColorSpaceTransform;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.params.OutputConfiguration;
import android.hardware.camera2.params.RggbChannelVector;
import android.hardware.camera2.params.TonemapCurve;
import android.hardware.camera2.utils.HashCodeHelpers;
import android.hardware.camera2.utils.SurfaceUtils;
import android.hardware.camera2.utils.TypeReference;
import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import android.util.Log;
import android.util.Range;
import android.util.Size;
import android.util.SparseArray;
import android.view.Surface;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CaptureRequest
extends CameraMetadata<Key<?>>
implements Parcelable {
    private final String TAG = "CaptureRequest-JV";
    private final ArraySet<Surface> mSurfaceSet = new ArraySet();
    private final Object mSurfacesLock = new Object();
    private boolean mSurfaceConverted = false;
    private int[] mStreamIdxArray;
    private int[] mSurfaceIdxArray;
    private static final ArraySet<Surface> mEmptySurfaceSet = new ArraySet();
    private String mLogicalCameraId;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private CameraMetadataNative mLogicalCameraSettings;
    private final HashMap<String, CameraMetadataNative> mPhysicalCameraSettings = new HashMap();
    private boolean mIsReprocess;
    public static final int REQUEST_TYPE_REGULAR = 0;
    public static final int REQUEST_TYPE_REPROCESS = 1;
    public static final int REQUEST_TYPE_ZSL_STILL = 2;
    public static final int REQUEST_TYPE_COUNT = 3;
    private int mRequestType = -1;
    private static final String SET_TAG_STRING_PREFIX = "android.hardware.camera2.CaptureRequest.setTag.";
    private boolean mIsPartOfCHSRequestList = false;
    private int mReprocessableSessionId;
    private Object mUserTag;
    public static final Parcelable.Creator<CaptureRequest> CREATOR = new Parcelable.Creator<CaptureRequest>(){

        @Override
        public CaptureRequest createFromParcel(Parcel in) {
            CaptureRequest request = new CaptureRequest();
            request.readFromParcel(in);
            return request;
        }

        public CaptureRequest[] newArray(int size) {
            return new CaptureRequest[size];
        }
    };
    @PublicKey
    public static final Key<Integer> COLOR_CORRECTION_MODE = new Key<Integer>("android.colorCorrection.mode", Integer.TYPE);
    @PublicKey
    public static final Key<ColorSpaceTransform> COLOR_CORRECTION_TRANSFORM = new Key<ColorSpaceTransform>("android.colorCorrection.transform", ColorSpaceTransform.class);
    @PublicKey
    public static final Key<RggbChannelVector> COLOR_CORRECTION_GAINS = new Key<RggbChannelVector>("android.colorCorrection.gains", RggbChannelVector.class);
    @PublicKey
    public static final Key<Integer> COLOR_CORRECTION_ABERRATION_MODE = new Key<Integer>("android.colorCorrection.aberrationMode", Integer.TYPE);
    @PublicKey
    public static final Key<Integer> CONTROL_AE_ANTIBANDING_MODE = new Key<Integer>("android.control.aeAntibandingMode", Integer.TYPE);
    @PublicKey
    public static final Key<Integer> CONTROL_AE_EXPOSURE_COMPENSATION = new Key<Integer>("android.control.aeExposureCompensation", Integer.TYPE);
    @PublicKey
    public static final Key<Boolean> CONTROL_AE_LOCK = new Key<Boolean>("android.control.aeLock", Boolean.TYPE);
    @PublicKey
    public static final Key<Integer> CONTROL_AE_MODE = new Key<Integer>("android.control.aeMode", Integer.TYPE);
    @PublicKey
    public static final Key<MeteringRectangle[]> CONTROL_AE_REGIONS = new Key<MeteringRectangle[]>("android.control.aeRegions", MeteringRectangle[].class);
    @PublicKey
    public static final Key<Range<Integer>> CONTROL_AE_TARGET_FPS_RANGE = new Key<Range<Integer>>("android.control.aeTargetFpsRange", new TypeReference<Range<Integer>>(){});
    @PublicKey
    public static final Key<Integer> CONTROL_AE_PRECAPTURE_TRIGGER = new Key<Integer>("android.control.aePrecaptureTrigger", Integer.TYPE);
    @PublicKey
    public static final Key<Integer> CONTROL_AF_MODE = new Key<Integer>("android.control.afMode", Integer.TYPE);
    @PublicKey
    public static final Key<MeteringRectangle[]> CONTROL_AF_REGIONS = new Key<MeteringRectangle[]>("android.control.afRegions", MeteringRectangle[].class);
    @PublicKey
    public static final Key<Integer> CONTROL_AF_TRIGGER = new Key<Integer>("android.control.afTrigger", Integer.TYPE);
    @PublicKey
    public static final Key<Boolean> CONTROL_AWB_LOCK = new Key<Boolean>("android.control.awbLock", Boolean.TYPE);
    @PublicKey
    public static final Key<Integer> CONTROL_AWB_MODE = new Key<Integer>("android.control.awbMode", Integer.TYPE);
    @PublicKey
    public static final Key<MeteringRectangle[]> CONTROL_AWB_REGIONS = new Key<MeteringRectangle[]>("android.control.awbRegions", MeteringRectangle[].class);
    @PublicKey
    public static final Key<Integer> CONTROL_CAPTURE_INTENT = new Key<Integer>("android.control.captureIntent", Integer.TYPE);
    @PublicKey
    public static final Key<Integer> CONTROL_EFFECT_MODE = new Key<Integer>("android.control.effectMode", Integer.TYPE);
    @PublicKey
    public static final Key<Integer> CONTROL_MODE = new Key<Integer>("android.control.mode", Integer.TYPE);
    @PublicKey
    public static final Key<Integer> CONTROL_SCENE_MODE = new Key<Integer>("android.control.sceneMode", Integer.TYPE);
    @PublicKey
    public static final Key<Integer> CONTROL_VIDEO_STABILIZATION_MODE = new Key<Integer>("android.control.videoStabilizationMode", Integer.TYPE);
    @PublicKey
    public static final Key<Integer> CONTROL_POST_RAW_SENSITIVITY_BOOST = new Key<Integer>("android.control.postRawSensitivityBoost", Integer.TYPE);
    @PublicKey
    public static final Key<Boolean> CONTROL_ENABLE_ZSL = new Key<Boolean>("android.control.enableZsl", Boolean.TYPE);
    @PublicKey
    public static final Key<Integer> CONTROL_EXTENDED_SCENE_MODE = new Key<Integer>("android.control.extendedSceneMode", Integer.TYPE);
    @PublicKey
    public static final Key<Float> CONTROL_ZOOM_RATIO = new Key<Float>("android.control.zoomRatio", Float.TYPE);
    public static final Key<Boolean> CONTROL_AF_REGIONS_SET = new Key<Boolean>("android.control.afRegionsSet", Boolean.TYPE);
    public static final Key<Boolean> CONTROL_AE_REGIONS_SET = new Key<Boolean>("android.control.aeRegionsSet", Boolean.TYPE);
    public static final Key<Boolean> CONTROL_AWB_REGIONS_SET = new Key<Boolean>("android.control.awbRegionsSet", Boolean.TYPE);
    @PublicKey
    public static final Key<Integer> EDGE_MODE = new Key<Integer>("android.edge.mode", Integer.TYPE);
    @PublicKey
    public static final Key<Integer> FLASH_MODE = new Key<Integer>("android.flash.mode", Integer.TYPE);
    @PublicKey
    public static final Key<Integer> HOT_PIXEL_MODE = new Key<Integer>("android.hotPixel.mode", Integer.TYPE);
    @PublicKey
    @SyntheticKey
    public static final Key<Location> JPEG_GPS_LOCATION = new Key<Location>("android.jpeg.gpsLocation", Location.class);
    public static final Key<double[]> JPEG_GPS_COORDINATES = new Key<double[]>("android.jpeg.gpsCoordinates", double[].class);
    public static final Key<String> JPEG_GPS_PROCESSING_METHOD = new Key<String>("android.jpeg.gpsProcessingMethod", String.class);
    public static final Key<Long> JPEG_GPS_TIMESTAMP = new Key<Long>("android.jpeg.gpsTimestamp", Long.TYPE);
    @PublicKey
    public static final Key<Integer> JPEG_ORIENTATION = new Key<Integer>("android.jpeg.orientation", Integer.TYPE);
    @PublicKey
    public static final Key<Byte> JPEG_QUALITY = new Key<Byte>("android.jpeg.quality", Byte.TYPE);
    @PublicKey
    public static final Key<Byte> JPEG_THUMBNAIL_QUALITY = new Key<Byte>("android.jpeg.thumbnailQuality", Byte.TYPE);
    @PublicKey
    public static final Key<Size> JPEG_THUMBNAIL_SIZE = new Key<Size>("android.jpeg.thumbnailSize", Size.class);
    @PublicKey
    public static final Key<Float> LENS_APERTURE = new Key<Float>("android.lens.aperture", Float.TYPE);
    @PublicKey
    public static final Key<Float> LENS_FILTER_DENSITY = new Key<Float>("android.lens.filterDensity", Float.TYPE);
    @PublicKey
    public static final Key<Float> LENS_FOCAL_LENGTH = new Key<Float>("android.lens.focalLength", Float.TYPE);
    @PublicKey
    public static final Key<Float> LENS_FOCUS_DISTANCE = new Key<Float>("android.lens.focusDistance", Float.TYPE);
    @PublicKey
    public static final Key<Integer> LENS_OPTICAL_STABILIZATION_MODE = new Key<Integer>("android.lens.opticalStabilizationMode", Integer.TYPE);
    @PublicKey
    public static final Key<Integer> NOISE_REDUCTION_MODE = new Key<Integer>("android.noiseReduction.mode", Integer.TYPE);
    public static final Key<Integer> REQUEST_ID = new Key<Integer>("android.request.id", Integer.TYPE);
    @PublicKey
    public static final Key<Rect> SCALER_CROP_REGION = new Key<Rect>("android.scaler.cropRegion", Rect.class);
    @PublicKey
    public static final Key<Integer> SCALER_ROTATE_AND_CROP = new Key<Integer>("android.scaler.rotateAndCrop", Integer.TYPE);
    public static final Key<Boolean> SCALER_CROP_REGION_SET = new Key<Boolean>("android.scaler.cropRegionSet", Boolean.TYPE);
    @PublicKey
    public static final Key<Long> SENSOR_EXPOSURE_TIME = new Key<Long>("android.sensor.exposureTime", Long.TYPE);
    @PublicKey
    public static final Key<Long> SENSOR_FRAME_DURATION = new Key<Long>("android.sensor.frameDuration", Long.TYPE);
    @PublicKey
    public static final Key<Integer> SENSOR_SENSITIVITY = new Key<Integer>("android.sensor.sensitivity", Integer.TYPE);
    @PublicKey
    public static final Key<int[]> SENSOR_TEST_PATTERN_DATA = new Key<int[]>("android.sensor.testPatternData", int[].class);
    @PublicKey
    public static final Key<Integer> SENSOR_TEST_PATTERN_MODE = new Key<Integer>("android.sensor.testPatternMode", Integer.TYPE);
    @PublicKey
    public static final Key<Integer> SENSOR_PIXEL_MODE = new Key<Integer>("android.sensor.pixelMode", Integer.TYPE);
    @PublicKey
    public static final Key<Integer> SHADING_MODE = new Key<Integer>("android.shading.mode", Integer.TYPE);
    @PublicKey
    public static final Key<Integer> STATISTICS_FACE_DETECT_MODE = new Key<Integer>("android.statistics.faceDetectMode", Integer.TYPE);
    @PublicKey
    public static final Key<Boolean> STATISTICS_HOT_PIXEL_MAP_MODE = new Key<Boolean>("android.statistics.hotPixelMapMode", Boolean.TYPE);
    @PublicKey
    public static final Key<Integer> STATISTICS_LENS_SHADING_MAP_MODE = new Key<Integer>("android.statistics.lensShadingMapMode", Integer.TYPE);
    @PublicKey
    public static final Key<Integer> STATISTICS_OIS_DATA_MODE = new Key<Integer>("android.statistics.oisDataMode", Integer.TYPE);
    public static final Key<float[]> TONEMAP_CURVE_BLUE = new Key<float[]>("android.tonemap.curveBlue", float[].class);
    public static final Key<float[]> TONEMAP_CURVE_GREEN = new Key<float[]>("android.tonemap.curveGreen", float[].class);
    public static final Key<float[]> TONEMAP_CURVE_RED = new Key<float[]>("android.tonemap.curveRed", float[].class);
    @PublicKey
    @SyntheticKey
    public static final Key<TonemapCurve> TONEMAP_CURVE = new Key<TonemapCurve>("android.tonemap.curve", TonemapCurve.class);
    @PublicKey
    public static final Key<Integer> TONEMAP_MODE = new Key<Integer>("android.tonemap.mode", Integer.TYPE);
    @PublicKey
    public static final Key<Float> TONEMAP_GAMMA = new Key<Float>("android.tonemap.gamma", Float.TYPE);
    @PublicKey
    public static final Key<Integer> TONEMAP_PRESET_CURVE = new Key<Integer>("android.tonemap.presetCurve", Integer.TYPE);
    public static final Key<Boolean> LED_TRANSMIT = new Key<Boolean>("android.led.transmit", Boolean.TYPE);
    @PublicKey
    public static final Key<Boolean> BLACK_LEVEL_LOCK = new Key<Boolean>("android.blackLevel.lock", Boolean.TYPE);
    @PublicKey
    public static final Key<Float> REPROCESS_EFFECTIVE_EXPOSURE_FACTOR = new Key<Float>("android.reprocess.effectiveExposureFactor", Float.TYPE);
    @PublicKey
    public static final Key<Integer> DISTORTION_CORRECTION_MODE = new Key<Integer>("android.distortionCorrection.mode", Integer.TYPE);

    public int getRequestType() {
        if (this.mRequestType == -1) {
            if (this.mIsReprocess) {
                this.mRequestType = 1;
            } else {
                int captureIntent;
                Boolean enableZsl = this.mLogicalCameraSettings.get(CONTROL_ENABLE_ZSL);
                boolean isZslStill = false;
                if (enableZsl != null && enableZsl.booleanValue() && (captureIntent = this.mLogicalCameraSettings.get(CONTROL_CAPTURE_INTENT).intValue()) == 2) {
                    isZslStill = true;
                }
                this.mRequestType = isZslStill ? 2 : 0;
            }
        }
        return this.mRequestType;
    }

    private CaptureRequest() {
        this.mIsReprocess = false;
        this.mReprocessableSessionId = -1;
    }

    private CaptureRequest(CaptureRequest source) {
        this.mLogicalCameraId = new String(source.mLogicalCameraId);
        for (Map.Entry<String, CameraMetadataNative> entry : source.mPhysicalCameraSettings.entrySet()) {
            this.mPhysicalCameraSettings.put(new String(entry.getKey()), new CameraMetadataNative(entry.getValue()));
        }
        this.mLogicalCameraSettings = this.mPhysicalCameraSettings.get(this.mLogicalCameraId);
        this.setNativeInstance(this.mLogicalCameraSettings);
        this.mSurfaceSet.addAll(source.mSurfaceSet);
        this.mIsReprocess = source.mIsReprocess;
        this.mIsPartOfCHSRequestList = source.mIsPartOfCHSRequestList;
        this.mReprocessableSessionId = source.mReprocessableSessionId;
        this.mUserTag = source.mUserTag;
    }

    private CaptureRequest(CameraMetadataNative settings, boolean isReprocess, int reprocessableSessionId, String logicalCameraId, Set<String> physicalCameraIdSet) {
        if (physicalCameraIdSet != null && isReprocess) {
            throw new IllegalArgumentException("Create a reprocess capture request with with more than one physical camera is not supported!");
        }
        this.mLogicalCameraId = logicalCameraId;
        this.mLogicalCameraSettings = CameraMetadataNative.move(settings);
        this.mPhysicalCameraSettings.put(this.mLogicalCameraId, this.mLogicalCameraSettings);
        if (physicalCameraIdSet != null) {
            for (String physicalId : physicalCameraIdSet) {
                this.mPhysicalCameraSettings.put(physicalId, new CameraMetadataNative(this.mLogicalCameraSettings));
            }
        }
        this.setNativeInstance(this.mLogicalCameraSettings);
        this.mIsReprocess = isReprocess;
        if (isReprocess) {
            if (reprocessableSessionId == -1) {
                throw new IllegalArgumentException("Create a reprocess capture request with an invalid session ID: " + reprocessableSessionId);
            }
            this.mReprocessableSessionId = reprocessableSessionId;
        } else {
            this.mReprocessableSessionId = -1;
        }
    }

    public <T> T get(Key<T> key) {
        return this.mLogicalCameraSettings.get(key);
    }

    @Override
    protected <T> T getProtected(Key<?> key) {
        return (T)this.mLogicalCameraSettings.get(key);
    }

    @Override
    protected Class<Key<?>> getKeyClass() {
        Class<Key> thisClass = Key.class;
        return thisClass;
    }

    @Override
    public List<Key<?>> getKeys() {
        return super.getKeys();
    }

    public Object getTag() {
        return this.mUserTag;
    }

    public boolean isReprocess() {
        return this.mIsReprocess;
    }

    public boolean isPartOfCRequestList() {
        return this.mIsPartOfCHSRequestList;
    }

    public CameraMetadataNative getNativeCopy() {
        return new CameraMetadataNative(this.mLogicalCameraSettings);
    }

    public int getReprocessableSessionId() {
        if (!this.mIsReprocess || this.mReprocessableSessionId == -1) {
            throw new IllegalStateException("Getting the reprocessable session ID for a non-reprocess capture request is illegal.");
        }
        return this.mReprocessableSessionId;
    }

    public boolean equals(Object other) {
        return other instanceof CaptureRequest && this.equals((CaptureRequest)other);
    }

    private boolean equals(CaptureRequest other) {
        return other != null && Objects.equals(this.mUserTag, other.mUserTag) && this.mSurfaceSet.equals(other.mSurfaceSet) && this.mPhysicalCameraSettings.equals(other.mPhysicalCameraSettings) && this.mLogicalCameraId.equals(other.mLogicalCameraId) && this.mLogicalCameraSettings.equals(other.mLogicalCameraSettings) && this.mIsReprocess == other.mIsReprocess && this.mReprocessableSessionId == other.mReprocessableSessionId;
    }

    public int hashCode() {
        return HashCodeHelpers.hashCodeGeneric(this.mPhysicalCameraSettings, this.mSurfaceSet, this.mUserTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFromParcel(Parcel in) {
        boolean hasUserTagStr;
        int physicalCameraCount = in.readInt();
        if (physicalCameraCount <= 0) {
            throw new RuntimeException("Physical camera count" + physicalCameraCount + " should always be positive");
        }
        this.mLogicalCameraId = in.readString();
        this.mLogicalCameraSettings = new CameraMetadataNative();
        this.mLogicalCameraSettings.readFromParcel(in);
        this.setNativeInstance(this.mLogicalCameraSettings);
        this.mPhysicalCameraSettings.put(this.mLogicalCameraId, this.mLogicalCameraSettings);
        for (int i = 1; i < physicalCameraCount; ++i) {
            String physicalId = in.readString();
            Parcelable[] physicalCameraSettings = new CameraMetadataNative();
            physicalCameraSettings.readFromParcel(in);
            this.mPhysicalCameraSettings.put(physicalId, (CameraMetadataNative)physicalCameraSettings);
        }
        this.mIsReprocess = in.readInt() != 0;
        this.mReprocessableSessionId = -1;
        Object i = this.mSurfacesLock;
        synchronized (i) {
            int streamSurfaceSize;
            this.mSurfaceSet.clear();
            Parcelable[] parcelableArray = in.readParcelableArray(Surface.class.getClassLoader(), Surface.class);
            if (parcelableArray != null) {
                for (Parcelable p : parcelableArray) {
                    Surface s = (Surface)p;
                    this.mSurfaceSet.add(s);
                }
            }
            if ((streamSurfaceSize = in.readInt()) != 0) {
                throw new RuntimeException("Reading cached CaptureRequest is not supported");
            }
        }
        boolean bl = hasUserTagStr = in.readInt() == 1;
        if (hasUserTagStr) {
            this.mUserTag = in.readString();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (!this.mPhysicalCameraSettings.containsKey(this.mLogicalCameraId)) {
            throw new IllegalStateException("Physical camera settings map must contain a key for the logical camera id.");
        }
        int physicalCameraCount = this.mPhysicalCameraSettings.size();
        dest.writeInt(physicalCameraCount);
        dest.writeString(this.mLogicalCameraId);
        this.mLogicalCameraSettings.writeToParcel(dest, flags);
        for (Map.Entry<String, CameraMetadataNative> entry : this.mPhysicalCameraSettings.entrySet()) {
            if (entry.getKey().equals(this.mLogicalCameraId)) continue;
            dest.writeString(entry.getKey());
            entry.getValue().writeToParcel(dest, flags);
        }
        dest.writeInt(this.mIsReprocess ? 1 : 0);
        Object object = this.mSurfacesLock;
        synchronized (object) {
            ArraySet<Surface> surfaces = this.mSurfaceConverted ? mEmptySurfaceSet : this.mSurfaceSet;
            dest.writeParcelableArray(surfaces.toArray(new Surface[surfaces.size()]), flags);
            if (this.mSurfaceConverted) {
                dest.writeInt(this.mStreamIdxArray.length);
                for (int i = 0; i < this.mStreamIdxArray.length; ++i) {
                    dest.writeInt(this.mStreamIdxArray[i]);
                    dest.writeInt(this.mSurfaceIdxArray[i]);
                }
            } else {
                dest.writeInt(0);
            }
        }
        if (this.mUserTag != null) {
            String userTagStr = this.mUserTag.toString();
            if (userTagStr != null && userTagStr.startsWith(SET_TAG_STRING_PREFIX)) {
                dest.writeInt(1);
                dest.writeString(userTagStr.substring(SET_TAG_STRING_PREFIX.length()));
            } else {
                dest.writeInt(0);
            }
        } else {
            dest.writeInt(0);
        }
    }

    public boolean containsTarget(Surface surface) {
        return this.mSurfaceSet.contains(surface);
    }

    @UnsupportedAppUsage
    public Collection<Surface> getTargets() {
        return Collections.unmodifiableCollection(this.mSurfaceSet);
    }

    public String getLogicalCameraId() {
        return this.mLogicalCameraId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertSurfaceToStreamId(SparseArray<OutputConfiguration> configuredOutputs) {
        Object object = this.mSurfacesLock;
        synchronized (object) {
            if (this.mSurfaceConverted) {
                Log.v("CaptureRequest-JV", "Cannot convert already converted surfaces!");
                return;
            }
            this.mStreamIdxArray = new int[this.mSurfaceSet.size()];
            this.mSurfaceIdxArray = new int[this.mSurfaceSet.size()];
            int i = 0;
            for (Surface s : this.mSurfaceSet) {
                boolean streamFound = false;
                for (int j = 0; j < configuredOutputs.size(); ++j) {
                    int streamId = configuredOutputs.keyAt(j);
                    OutputConfiguration outConfig = configuredOutputs.valueAt(j);
                    int surfaceId = 0;
                    for (Surface outSurface : outConfig.getSurfaces()) {
                        if (s == outSurface) {
                            streamFound = true;
                            this.mStreamIdxArray[i] = streamId;
                            this.mSurfaceIdxArray[i] = surfaceId;
                            ++i;
                            break;
                        }
                        ++surfaceId;
                    }
                    if (streamFound) break;
                }
                if (!streamFound) {
                    long reqSurfaceId = SurfaceUtils.getSurfaceId(s);
                    for (int j = 0; j < configuredOutputs.size(); ++j) {
                        int streamId = configuredOutputs.keyAt(j);
                        OutputConfiguration outConfig = configuredOutputs.valueAt(j);
                        int surfaceId = 0;
                        for (Surface outSurface : outConfig.getSurfaces()) {
                            if (reqSurfaceId == SurfaceUtils.getSurfaceId(outSurface)) {
                                streamFound = true;
                                this.mStreamIdxArray[i] = streamId;
                                this.mSurfaceIdxArray[i] = surfaceId;
                                ++i;
                                break;
                            }
                            ++surfaceId;
                        }
                        if (streamFound) break;
                    }
                }
                if (streamFound) continue;
                this.mStreamIdxArray = null;
                this.mSurfaceIdxArray = null;
                throw new IllegalArgumentException("CaptureRequest contains unconfigured Input/Output Surface!");
            }
            this.mSurfaceConverted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverStreamIdToSurface() {
        Object object = this.mSurfacesLock;
        synchronized (object) {
            if (!this.mSurfaceConverted) {
                Log.v("CaptureRequest-JV", "Cannot convert already converted surfaces!");
                return;
            }
            this.mStreamIdxArray = null;
            this.mSurfaceIdxArray = null;
            this.mSurfaceConverted = false;
        }
    }

    public static class Builder {
        private final CaptureRequest mRequest;

        public Builder(CameraMetadataNative template, boolean reprocess, int reprocessableSessionId, String logicalCameraId, Set<String> physicalCameraIdSet) {
            this.mRequest = new CaptureRequest(template, reprocess, reprocessableSessionId, logicalCameraId, physicalCameraIdSet);
        }

        public void addTarget(Surface outputTarget) {
            this.mRequest.mSurfaceSet.add(outputTarget);
        }

        public void removeTarget(Surface outputTarget) {
            this.mRequest.mSurfaceSet.remove(outputTarget);
        }

        public <T> void set(Key<T> key, T value) {
            this.mRequest.mLogicalCameraSettings.set(key, value);
        }

        public <T> T get(Key<T> key) {
            return this.mRequest.mLogicalCameraSettings.get(key);
        }

        public <T> Builder setPhysicalCameraKey(Key<T> key, T value, String physicalCameraId) {
            if (!this.mRequest.mPhysicalCameraSettings.containsKey(physicalCameraId)) {
                throw new IllegalArgumentException("Physical camera id: " + physicalCameraId + " is not valid!");
            }
            this.mRequest.mPhysicalCameraSettings.get(physicalCameraId).set(key, value);
            return this;
        }

        public <T> T getPhysicalCameraKey(Key<T> key, String physicalCameraId) {
            if (!this.mRequest.mPhysicalCameraSettings.containsKey(physicalCameraId)) {
                throw new IllegalArgumentException("Physical camera id: " + physicalCameraId + " is not valid!");
            }
            return this.mRequest.mPhysicalCameraSettings.get(physicalCameraId).get(key);
        }

        public void setTag(Object tag) {
            this.mRequest.mUserTag = tag;
        }

        @UnsupportedAppUsage
        public void setPartOfCHSRequestList(boolean partOfCHSList) {
            this.mRequest.mIsPartOfCHSRequestList = partOfCHSList;
        }

        public CaptureRequest build() {
            return new CaptureRequest(this.mRequest);
        }

        public boolean isEmpty() {
            return this.mRequest.mLogicalCameraSettings.isEmpty();
        }
    }

    public static class Key<T> {
        private final CameraMetadataNative.Key<T> mKey;

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public Key(String name, Class<T> type, long vendorId) {
            this.mKey = new CameraMetadataNative.Key<T>(name, type, vendorId);
        }

        public Key(String name, Class<T> type) {
            this.mKey = new CameraMetadataNative.Key<T>(name, type);
        }

        @UnsupportedAppUsage
        public Key(String name, TypeReference<T> typeReference) {
            this.mKey = new CameraMetadataNative.Key<T>(name, typeReference);
        }

        public String getName() {
            return this.mKey.getName();
        }

        public long getVendorId() {
            return this.mKey.getVendorId();
        }

        public int hashCode() {
            return this.mKey.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof Key && ((Key)o).mKey.equals(this.mKey);
        }

        public String toString() {
            return String.format("CaptureRequest.Key(%s)", this.mKey.getName());
        }

        @UnsupportedAppUsage
        public CameraMetadataNative.Key<T> getNativeKey() {
            return this.mKey;
        }

        Key(CameraMetadataNative.Key<?> nativeKey) {
            this.mKey = nativeKey;
        }
    }
}

