/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.annotation.RequiresPermission;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.SyncFence;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraExtensionCharacteristics;
import android.hardware.camera2.CameraExtensionSession;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.extension.CaptureBundle;
import android.hardware.camera2.extension.CaptureStageImpl;
import android.hardware.camera2.extension.ICaptureProcessorImpl;
import android.hardware.camera2.extension.IImageCaptureExtenderImpl;
import android.hardware.camera2.extension.IInitializeSessionCallback;
import android.hardware.camera2.extension.IPreviewExtenderImpl;
import android.hardware.camera2.extension.IProcessResultImpl;
import android.hardware.camera2.extension.IRequestUpdateProcessorImpl;
import android.hardware.camera2.extension.ParcelImage;
import android.hardware.camera2.impl.CameraExtensionForwardProcessor;
import android.hardware.camera2.impl.CameraExtensionJpegProcessor;
import android.hardware.camera2.impl.CameraExtensionUtils;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.impl.PhysicalCaptureResultInfo;
import android.hardware.camera2.params.ExtensionSessionConfiguration;
import android.hardware.camera2.params.OutputConfiguration;
import android.hardware.camera2.params.SessionConfiguration;
import android.hardware.camera2.utils.SurfaceUtils;
import android.media.Image;
import android.media.ImageReader;
import android.media.ImageWriter;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.RemoteException;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.Pair;
import android.util.Size;
import android.view.Surface;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;

public class CameraExtensionSessionImpl
extends CameraExtensionSession {
    private static final int PREVIEW_QUEUE_SIZE = 10;
    private static final String TAG = "CameraExtensionSessionImpl";
    private final Executor mExecutor;
    private final CameraDevice mCameraDevice;
    private final long mExtensionClientId;
    private final IImageCaptureExtenderImpl mImageExtender;
    private final IPreviewExtenderImpl mPreviewExtender;
    private final Handler mHandler;
    private final HandlerThread mHandlerThread;
    private final CameraExtensionSession.StateCallback mCallbacks;
    private final List<Size> mSupportedPreviewSizes;
    private final InitializeSessionHandler mInitializeHandler;
    private final int mSessionId;
    private final Set<CaptureRequest.Key> mSupportedRequestKeys;
    private final Set<CaptureResult.Key> mSupportedResultKeys;
    private boolean mCaptureResultsSupported;
    private CameraCaptureSession mCaptureSession = null;
    private Surface mCameraRepeatingSurface;
    private Surface mClientRepeatingRequestSurface;
    private Surface mCameraBurstSurface;
    private Surface mClientCaptureSurface;
    private ImageReader mRepeatingRequestImageReader = null;
    private ImageReader mBurstCaptureImageReader = null;
    private ImageReader mStubCaptureImageReader = null;
    private ImageWriter mRepeatingRequestImageWriter = null;
    private CameraOutputImageCallback mRepeatingRequestImageCallback = null;
    private CameraOutputImageCallback mBurstCaptureImageCallback = null;
    private CameraExtensionJpegProcessor mImageJpegProcessor = null;
    private ICaptureProcessorImpl mImageProcessor = null;
    private CameraExtensionForwardProcessor mPreviewImageProcessor = null;
    private IRequestUpdateProcessorImpl mPreviewRequestUpdateProcessor = null;
    private int mPreviewProcessorType = 2;
    private boolean mInitialized;
    private boolean mInternalRepeatingRequestEnabled = true;
    final Object mInterfaceLock = new Object();

    private static int nativeGetSurfaceFormat(Surface surface) {
        return SurfaceUtils.getSurfaceFormat(surface);
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public static CameraExtensionSessionImpl createCameraExtensionSession(CameraDevice cameraDevice, Context ctx, ExtensionSessionConfiguration config, int sessionId) throws CameraAccessException, RemoteException {
        long clientId = CameraExtensionCharacteristics.registerClient(ctx);
        if (clientId < 0L) {
            throw new UnsupportedOperationException("Unsupported extension!");
        }
        String cameraId = cameraDevice.getId();
        CameraManager manager = ctx.getSystemService(CameraManager.class);
        CameraCharacteristics chars = manager.getCameraCharacteristics(cameraId);
        CameraExtensionCharacteristics extensionChars = new CameraExtensionCharacteristics(ctx, cameraId, chars);
        if (!CameraExtensionCharacteristics.isExtensionSupported(cameraDevice.getId(), config.getExtension(), chars)) {
            throw new UnsupportedOperationException("Unsupported extension type: " + config.getExtension());
        }
        if (config.getOutputConfigurations().isEmpty() || config.getOutputConfigurations().size() > 2) {
            throw new IllegalArgumentException("Unexpected amount of output surfaces, received: " + config.getOutputConfigurations().size() + " expected <= 2");
        }
        for (OutputConfiguration c : config.getOutputConfigurations()) {
            if (c.getDynamicRangeProfile() != 1L) {
                throw new IllegalArgumentException("Unsupported dynamic range profile: " + c.getDynamicRangeProfile());
            }
            if (c.getStreamUseCase() == 0L) continue;
            throw new IllegalArgumentException("Unsupported stream use case: " + c.getStreamUseCase());
        }
        Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders = CameraExtensionCharacteristics.initializeExtension(config.getExtension());
        int suitableSurfaceCount = 0;
        List<Size> supportedPreviewSizes = extensionChars.getExtensionSupportedSizes(config.getExtension(), SurfaceTexture.class);
        Surface repeatingRequestSurface = CameraExtensionUtils.getRepeatingRequestSurface(config.getOutputConfigurations(), supportedPreviewSizes);
        if (repeatingRequestSurface != null) {
            ++suitableSurfaceCount;
        }
        HashMap<Integer, List<Size>> supportedCaptureSizes = new HashMap<Integer, List<Size>>();
        for (int format : CameraExtensionUtils.SUPPORTED_CAPTURE_OUTPUT_FORMATS) {
            List<Size> supportedSizes = extensionChars.getExtensionSupportedSizes(config.getExtension(), format);
            if (supportedSizes == null) continue;
            supportedCaptureSizes.put(format, supportedSizes);
        }
        Surface burstCaptureSurface = CameraExtensionUtils.getBurstCaptureSurface(config.getOutputConfigurations(), supportedCaptureSizes);
        if (burstCaptureSurface != null) {
            ++suitableSurfaceCount;
        }
        if (suitableSurfaceCount != config.getOutputConfigurations().size()) {
            throw new IllegalArgumentException("One or more unsupported output surfaces found!");
        }
        ((IPreviewExtenderImpl)extenders.first).init(cameraId, chars.getNativeMetadata());
        ((IPreviewExtenderImpl)extenders.first).onInit(cameraId, chars.getNativeMetadata());
        ((IImageCaptureExtenderImpl)extenders.second).init(cameraId, chars.getNativeMetadata());
        ((IImageCaptureExtenderImpl)extenders.second).onInit(cameraId, chars.getNativeMetadata());
        CameraExtensionSessionImpl session = new CameraExtensionSessionImpl((IImageCaptureExtenderImpl)extenders.second, (IPreviewExtenderImpl)extenders.first, supportedPreviewSizes, clientId, cameraDevice, repeatingRequestSurface, burstCaptureSurface, config.getStateCallback(), config.getExecutor(), sessionId, extensionChars.getAvailableCaptureRequestKeys(config.getExtension()), extensionChars.getAvailableCaptureResultKeys(config.getExtension()));
        session.initialize();
        return session;
    }

    public CameraExtensionSessionImpl(IImageCaptureExtenderImpl imageExtender, IPreviewExtenderImpl previewExtender, List<Size> previewSizes, long extensionClientId, CameraDevice cameraDevice, Surface repeatingRequestSurface, Surface burstCaptureSurface, CameraExtensionSession.StateCallback callback, Executor executor, int sessionId, Set<CaptureRequest.Key> requestKeys, Set<CaptureResult.Key> resultKeys) {
        this.mExtensionClientId = extensionClientId;
        this.mImageExtender = imageExtender;
        this.mPreviewExtender = previewExtender;
        this.mCameraDevice = cameraDevice;
        this.mCallbacks = callback;
        this.mExecutor = executor;
        this.mClientRepeatingRequestSurface = repeatingRequestSurface;
        this.mClientCaptureSurface = burstCaptureSurface;
        this.mSupportedPreviewSizes = previewSizes;
        this.mHandlerThread = new HandlerThread(TAG);
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
        this.mInitialized = false;
        this.mInitializeHandler = new InitializeSessionHandler();
        this.mSessionId = sessionId;
        this.mSupportedRequestKeys = requestKeys;
        this.mSupportedResultKeys = resultKeys;
        this.mCaptureResultsSupported = !resultKeys.isEmpty();
    }

    private void initializeRepeatingRequestPipeline() throws RemoteException {
        CameraExtensionUtils.SurfaceInfo repeatingSurfaceInfo = new CameraExtensionUtils.SurfaceInfo();
        this.mPreviewProcessorType = this.mPreviewExtender.getProcessorType();
        if (this.mClientRepeatingRequestSurface != null) {
            repeatingSurfaceInfo = CameraExtensionUtils.querySurface(this.mClientRepeatingRequestSurface);
        } else {
            CameraExtensionUtils.SurfaceInfo captureSurfaceInfo = CameraExtensionUtils.querySurface(this.mClientCaptureSurface);
            Size captureSize = new Size(captureSurfaceInfo.mWidth, captureSurfaceInfo.mHeight);
            Size previewSize = CameraExtensionSessionImpl.findSmallestAspectMatchedSize(this.mSupportedPreviewSizes, captureSize);
            repeatingSurfaceInfo.mWidth = previewSize.getWidth();
            repeatingSurfaceInfo.mHeight = previewSize.getHeight();
            repeatingSurfaceInfo.mUsage = 256L;
        }
        if (this.mPreviewProcessorType == 1) {
            try {
                this.mPreviewImageProcessor = new CameraExtensionForwardProcessor(this.mPreviewExtender.getPreviewImageProcessor(), repeatingSurfaceInfo.mFormat, repeatingSurfaceInfo.mUsage, this.mHandler);
            }
            catch (ClassCastException e) {
                throw new UnsupportedOperationException("Failed casting preview processor!");
            }
            this.mPreviewImageProcessor.onImageFormatUpdate(35);
            this.mPreviewImageProcessor.onResolutionUpdate(new Size(repeatingSurfaceInfo.mWidth, repeatingSurfaceInfo.mHeight));
            this.mPreviewImageProcessor.onOutputSurface(null, -1);
            this.mRepeatingRequestImageReader = ImageReader.newInstance(repeatingSurfaceInfo.mWidth, repeatingSurfaceInfo.mHeight, 35, 10, repeatingSurfaceInfo.mUsage);
            this.mCameraRepeatingSurface = this.mRepeatingRequestImageReader.getSurface();
        } else if (this.mPreviewProcessorType == 0) {
            try {
                this.mPreviewRequestUpdateProcessor = this.mPreviewExtender.getRequestUpdateProcessor();
            }
            catch (ClassCastException e) {
                throw new UnsupportedOperationException("Failed casting preview processor!");
            }
            this.mRepeatingRequestImageReader = ImageReader.newInstance(repeatingSurfaceInfo.mWidth, repeatingSurfaceInfo.mHeight, 34, 10, repeatingSurfaceInfo.mUsage);
            this.mCameraRepeatingSurface = this.mRepeatingRequestImageReader.getSurface();
            android.hardware.camera2.extension.Size sz = new android.hardware.camera2.extension.Size();
            sz.width = repeatingSurfaceInfo.mWidth;
            sz.height = repeatingSurfaceInfo.mHeight;
            this.mPreviewRequestUpdateProcessor.onResolutionUpdate(sz);
            this.mPreviewRequestUpdateProcessor.onImageFormatUpdate(34);
        } else {
            this.mRepeatingRequestImageReader = ImageReader.newInstance(repeatingSurfaceInfo.mWidth, repeatingSurfaceInfo.mHeight, 34, 10, repeatingSurfaceInfo.mUsage);
            this.mCameraRepeatingSurface = this.mRepeatingRequestImageReader.getSurface();
        }
        this.mRepeatingRequestImageCallback = new CameraOutputImageCallback(this.mRepeatingRequestImageReader);
        this.mRepeatingRequestImageReader.setOnImageAvailableListener(this.mRepeatingRequestImageCallback, this.mHandler);
    }

    private void initializeBurstCapturePipeline() throws RemoteException {
        this.mImageProcessor = this.mImageExtender.getCaptureProcessor();
        if (this.mImageProcessor == null && this.mImageExtender.getMaxCaptureStage() != 1) {
            throw new UnsupportedOperationException("Multiple stages expected without a valid capture processor!");
        }
        if (this.mImageProcessor != null) {
            if (this.mClientCaptureSurface != null) {
                CameraExtensionUtils.SurfaceInfo surfaceInfo = CameraExtensionUtils.querySurface(this.mClientCaptureSurface);
                if (surfaceInfo.mFormat == 256) {
                    this.mImageJpegProcessor = new CameraExtensionJpegProcessor(this.mImageProcessor);
                    this.mImageProcessor = this.mImageJpegProcessor;
                }
                this.mBurstCaptureImageReader = ImageReader.newInstance(surfaceInfo.mWidth, surfaceInfo.mHeight, 35, this.mImageExtender.getMaxCaptureStage());
            } else {
                this.mBurstCaptureImageReader = ImageReader.newInstance(this.mRepeatingRequestImageReader.getWidth(), this.mRepeatingRequestImageReader.getHeight(), 35, 1);
                this.mStubCaptureImageReader = ImageReader.newInstance(this.mRepeatingRequestImageReader.getWidth(), this.mRepeatingRequestImageReader.getHeight(), 35, 1);
                this.mImageProcessor.onOutputSurface(this.mStubCaptureImageReader.getSurface(), 35);
            }
            this.mBurstCaptureImageCallback = new CameraOutputImageCallback(this.mBurstCaptureImageReader);
            this.mBurstCaptureImageReader.setOnImageAvailableListener(this.mBurstCaptureImageCallback, this.mHandler);
            this.mCameraBurstSurface = this.mBurstCaptureImageReader.getSurface();
            android.hardware.camera2.extension.Size sz = new android.hardware.camera2.extension.Size();
            sz.width = this.mBurstCaptureImageReader.getWidth();
            sz.height = this.mBurstCaptureImageReader.getHeight();
            this.mImageProcessor.onResolutionUpdate(sz);
            this.mImageProcessor.onImageFormatUpdate(this.mBurstCaptureImageReader.getImageFormat());
        } else if (this.mClientCaptureSurface != null) {
            this.mCameraBurstSurface = this.mClientCaptureSurface;
        } else {
            this.mBurstCaptureImageReader = ImageReader.newInstance(this.mRepeatingRequestImageReader.getWidth(), this.mRepeatingRequestImageReader.getHeight(), 256, 1);
            this.mCameraBurstSurface = this.mBurstCaptureImageReader.getSurface();
        }
    }

    private void finishPipelineInitialization() throws RemoteException {
        if (this.mClientRepeatingRequestSurface != null) {
            if (this.mPreviewProcessorType == 0) {
                this.mPreviewRequestUpdateProcessor.onOutputSurface(this.mClientRepeatingRequestSurface, CameraExtensionSessionImpl.nativeGetSurfaceFormat(this.mClientRepeatingRequestSurface));
                this.mRepeatingRequestImageWriter = ImageWriter.newInstance(this.mClientRepeatingRequestSurface, 10, 34);
            } else if (this.mPreviewProcessorType == 2) {
                this.mRepeatingRequestImageWriter = ImageWriter.newInstance(this.mClientRepeatingRequestSurface, 10, 34);
            }
        }
        if (this.mImageProcessor != null && this.mClientCaptureSurface != null) {
            CameraExtensionUtils.SurfaceInfo surfaceInfo = CameraExtensionUtils.querySurface(this.mClientCaptureSurface);
            this.mImageProcessor.onOutputSurface(this.mClientCaptureSurface, surfaceInfo.mFormat);
        }
    }

    public synchronized void initialize() throws CameraAccessException, RemoteException {
        if (this.mInitialized) {
            Log.d(TAG, "Session already initialized");
            return;
        }
        ArrayList<CaptureStageImpl> sessionParamsList = new ArrayList<CaptureStageImpl>();
        ArrayList<OutputConfiguration> outputList = new ArrayList<OutputConfiguration>();
        this.initializeRepeatingRequestPipeline();
        outputList.add(new OutputConfiguration(this.mCameraRepeatingSurface));
        CaptureStageImpl previewSessionParams = this.mPreviewExtender.onPresetSession();
        if (previewSessionParams != null) {
            sessionParamsList.add(previewSessionParams);
        }
        this.initializeBurstCapturePipeline();
        outputList.add(new OutputConfiguration(this.mCameraBurstSurface));
        CaptureStageImpl stillCaptureSessionParams = this.mImageExtender.onPresetSession();
        if (stillCaptureSessionParams != null) {
            sessionParamsList.add(stillCaptureSessionParams);
        }
        SessionConfiguration sessionConfig = new SessionConfiguration(0, outputList, new CameraExtensionUtils.HandlerExecutor(this.mHandler), new SessionStateHandler());
        if (!sessionParamsList.isEmpty()) {
            CaptureRequest sessionParamRequest = this.createRequest(this.mCameraDevice, sessionParamsList, null, 1);
            sessionConfig.setSessionParameters(sessionParamRequest);
        }
        this.mCameraDevice.createCaptureSession(sessionConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CameraDevice getDevice() {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            return this.mCameraDevice;
        }
    }

    @Override
    public int setRepeatingRequest(CaptureRequest request, Executor executor, CameraExtensionSession.ExtensionCaptureCallback listener) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (!this.mInitialized) {
                throw new IllegalStateException("Uninitialized component");
            }
            if (this.mClientRepeatingRequestSurface == null) {
                throw new IllegalArgumentException("No registered preview surface");
            }
            if (!request.containsTarget(this.mClientRepeatingRequestSurface) || request.getTargets().size() != 1) {
                throw new IllegalArgumentException("Invalid repeating request output target!");
            }
            this.mInternalRepeatingRequestEnabled = false;
            try {
                return this.setRepeatingRequest(this.mPreviewExtender.getCaptureStage(), new PreviewRequestHandler(request, executor, listener, this.mRepeatingRequestImageCallback), request);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to set repeating request! Extension service does not respond");
                throw new CameraAccessException(3);
            }
        }
    }

    private ArrayList<CaptureStageImpl> compileInitialRequestList() {
        ArrayList<CaptureStageImpl> captureStageList = new ArrayList<CaptureStageImpl>();
        try {
            CaptureStageImpl initialStillCaptureParams;
            CaptureStageImpl initialPreviewParams = this.mPreviewExtender.onEnableSession();
            if (initialPreviewParams != null) {
                captureStageList.add(initialPreviewParams);
            }
            if ((initialStillCaptureParams = this.mImageExtender.onEnableSession()) != null) {
                captureStageList.add(initialStillCaptureParams);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to initialize session parameters! Extension service does not respond!");
        }
        return captureStageList;
    }

    private List<CaptureRequest> createBurstRequest(CameraDevice cameraDevice, List<CaptureStageImpl> captureStageList, CaptureRequest clientRequest, Surface target, int captureTemplate, Map<CaptureRequest, Integer> captureMap) {
        ArrayList<CaptureRequest> ret = new ArrayList<CaptureRequest>();
        for (CaptureStageImpl captureStage : captureStageList) {
            CaptureRequest.Builder requestBuilder;
            try {
                requestBuilder = cameraDevice.createCaptureRequest(captureTemplate);
            }
            catch (CameraAccessException e) {
                return null;
            }
            for (CaptureRequest.Key requestKey : this.mSupportedRequestKeys) {
                Object value = clientRequest.get(requestKey);
                if (value == null) continue;
                captureStage.parameters.set(requestKey, value);
            }
            requestBuilder.addTarget(target);
            CaptureRequest request = requestBuilder.build();
            CameraMetadataNative.update(request.getNativeMetadata(), captureStage.parameters);
            ret.add(request);
            if (captureMap == null) continue;
            captureMap.put(request, captureStage.id);
        }
        return ret;
    }

    private CaptureRequest createRequest(CameraDevice cameraDevice, List<CaptureStageImpl> captureStageList, Surface target, int captureTemplate, CaptureRequest clientRequest) throws CameraAccessException {
        CaptureRequest.Builder requestBuilder = cameraDevice.createCaptureRequest(captureTemplate);
        if (target != null) {
            requestBuilder.addTarget(target);
        }
        CaptureRequest ret = requestBuilder.build();
        CameraMetadataNative nativeMeta = ret.getNativeMetadata();
        for (CaptureStageImpl captureStage : captureStageList) {
            if (captureStage == null) continue;
            CameraMetadataNative.update(nativeMeta, captureStage.parameters);
        }
        if (clientRequest != null) {
            for (CaptureRequest.Key requestKey : this.mSupportedRequestKeys) {
                Object value = clientRequest.get(requestKey);
                if (value == null) continue;
                nativeMeta.set(requestKey, value);
            }
        }
        return ret;
    }

    private CaptureRequest createRequest(CameraDevice cameraDevice, List<CaptureStageImpl> captureStageList, Surface target, int captureTemplate) throws CameraAccessException {
        return this.createRequest(cameraDevice, captureStageList, target, captureTemplate, null);
    }

    @Override
    public int capture(CaptureRequest request, Executor executor, CameraExtensionSession.ExtensionCaptureCallback listener) throws CameraAccessException {
        if (!this.mInitialized) {
            throw new IllegalStateException("Uninitialized component");
        }
        if (request.getTargets().size() != 1) {
            throw new IllegalArgumentException("Single capture to both preview & still capture outputs target is not supported!");
        }
        int seqId = -1;
        if (this.mClientCaptureSurface != null && request.containsTarget(this.mClientCaptureSurface)) {
            List<CaptureRequest> burstRequest;
            HashMap<CaptureRequest, Integer> requestMap = new HashMap<CaptureRequest, Integer>();
            try {
                burstRequest = this.createBurstRequest(this.mCameraDevice, this.mImageExtender.getCaptureStages(), request, this.mCameraBurstSurface, 2, requestMap);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to initialize internal burst request! Extension service does not respond!");
                throw new CameraAccessException(3);
            }
            if (burstRequest == null) {
                throw new UnsupportedOperationException("Failed to create still capture burst request");
            }
            seqId = this.mCaptureSession.captureBurstRequests(burstRequest, new CameraExtensionUtils.HandlerExecutor(this.mHandler), new BurstRequestHandler(request, executor, listener, requestMap, this.mBurstCaptureImageCallback));
        } else if (this.mClientRepeatingRequestSurface != null && request.containsTarget(this.mClientRepeatingRequestSurface)) {
            CaptureRequest captureRequest = null;
            try {
                ArrayList<CaptureStageImpl> captureStageList = new ArrayList<CaptureStageImpl>();
                captureStageList.add(this.mPreviewExtender.getCaptureStage());
                captureRequest = this.createRequest(this.mCameraDevice, captureStageList, this.mCameraRepeatingSurface, 1, request);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to initialize capture request! Extension service does not respond!");
                throw new CameraAccessException(3);
            }
            seqId = this.mCaptureSession.capture(captureRequest, new PreviewRequestHandler(request, executor, listener, this.mRepeatingRequestImageCallback, true), this.mHandler);
        } else {
            throw new IllegalArgumentException("Capture request to unknown output surface!");
        }
        return seqId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopRepeating() throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (!this.mInitialized) {
                throw new IllegalStateException("Uninitialized component");
            }
            this.mInternalRepeatingRequestEnabled = true;
            this.mCaptureSession.stopRepeating();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (this.mInitialized) {
                this.mInternalRepeatingRequestEnabled = false;
                this.mCaptureSession.stopRepeating();
                ArrayList<CaptureStageImpl> captureStageList = new ArrayList<CaptureStageImpl>();
                try {
                    CaptureStageImpl disableStillCaptureParams;
                    CaptureStageImpl disableParams = this.mPreviewExtender.onDisableSession();
                    if (disableParams != null) {
                        captureStageList.add(disableParams);
                    }
                    if ((disableStillCaptureParams = this.mImageExtender.onDisableSession()) != null) {
                        captureStageList.add(disableStillCaptureParams);
                    }
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Failed to disable extension! Extension service does not respond!");
                }
                if (!captureStageList.isEmpty()) {
                    CaptureRequest disableRequest = this.createRequest(this.mCameraDevice, captureStageList, this.mCameraRepeatingSurface, 1);
                    this.mCaptureSession.capture(disableRequest, new CloseRequestHandler(this.mRepeatingRequestImageCallback), this.mHandler);
                }
                this.mCaptureSession.close();
            }
        }
    }

    private void setInitialCaptureRequest(List<CaptureStageImpl> captureStageList, InitialRequestHandler requestHandler) throws CameraAccessException {
        CaptureRequest initialRequest = this.createRequest(this.mCameraDevice, captureStageList, this.mCameraRepeatingSurface, 1);
        this.mCaptureSession.capture(initialRequest, requestHandler, this.mHandler);
    }

    private int setRepeatingRequest(CaptureStageImpl captureStage, CameraCaptureSession.CaptureCallback requestHandler) throws CameraAccessException {
        return this.setRepeatingRequest(captureStage, requestHandler, null);
    }

    private int setRepeatingRequest(CaptureStageImpl captureStage, CameraCaptureSession.CaptureCallback requestHandler, CaptureRequest clientRequest) throws CameraAccessException {
        ArrayList<CaptureStageImpl> captureStageList = new ArrayList<CaptureStageImpl>();
        captureStageList.add(captureStage);
        CaptureRequest repeatingRequest = this.createRequest(this.mCameraDevice, captureStageList, this.mCameraRepeatingSurface, 1, clientRequest);
        return this.mCaptureSession.setSingleRepeatingRequest(repeatingRequest, new CameraExtensionUtils.HandlerExecutor(this.mHandler), requestHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(boolean skipCloseNotification) {
        boolean notifyClose = false;
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.mInternalRepeatingRequestEnabled = false;
            this.mHandlerThread.quitSafely();
            try {
                this.mPreviewExtender.onDeInit();
                this.mImageExtender.onDeInit();
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to release extensions! Extension service does not respond!");
            }
            if (this.mExtensionClientId >= 0L) {
                CameraExtensionCharacteristics.unregisterClient(this.mExtensionClientId);
                if (this.mInitialized) {
                    notifyClose = true;
                    CameraExtensionCharacteristics.releaseSession();
                }
            }
            this.mInitialized = false;
            if (this.mRepeatingRequestImageCallback != null) {
                this.mRepeatingRequestImageCallback.close();
                this.mRepeatingRequestImageCallback = null;
            }
            if (this.mRepeatingRequestImageReader != null) {
                this.mRepeatingRequestImageReader.close();
                this.mRepeatingRequestImageReader = null;
            }
            if (this.mBurstCaptureImageCallback != null) {
                this.mBurstCaptureImageCallback.close();
                this.mBurstCaptureImageCallback = null;
            }
            if (this.mBurstCaptureImageReader != null) {
                this.mBurstCaptureImageReader.close();
                this.mBurstCaptureImageReader = null;
            }
            if (this.mStubCaptureImageReader != null) {
                this.mStubCaptureImageReader.close();
                this.mStubCaptureImageReader = null;
            }
            if (this.mRepeatingRequestImageWriter != null) {
                this.mRepeatingRequestImageWriter.close();
                this.mRepeatingRequestImageWriter = null;
            }
            if (this.mPreviewImageProcessor != null) {
                this.mPreviewImageProcessor.close();
                this.mPreviewImageProcessor = null;
            }
            if (this.mImageJpegProcessor != null) {
                this.mImageJpegProcessor.close();
                this.mImageJpegProcessor = null;
            }
            this.mCaptureSession = null;
            this.mImageProcessor = null;
            this.mClientRepeatingRequestSurface = null;
            this.mCameraRepeatingSurface = null;
            this.mClientCaptureSurface = null;
            this.mCameraBurstSurface = null;
        }
        if (notifyClose && !skipCloseNotification) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallbacks.onClosed(this));
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyConfigurationFailure() {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (this.mInitialized) {
                return;
            }
        }
        this.release(true);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mExecutor.execute(() -> this.mCallbacks.onConfigureFailed(this));
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyConfigurationSuccess() {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (this.mInitialized) {
                return;
            }
            this.mInitialized = true;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.mExecutor.execute(() -> this.mCallbacks.onConfigured(this));
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private CameraMetadataNative initializeFilteredResults(TotalCaptureResult result) {
        CameraMetadataNative captureResults = new CameraMetadataNative();
        for (CaptureResult.Key key : this.mSupportedResultKeys) {
            Object value = result.get(key);
            if (value == null) continue;
            captureResults.set(key, value);
        }
        return captureResults;
    }

    private static Size findSmallestAspectMatchedSize(List<Size> sizes, Size arSize) {
        float TOLL = 0.01f;
        if (arSize.getHeight() == 0) {
            throw new IllegalArgumentException("Invalid input aspect ratio");
        }
        float targetAR = (float)arSize.getWidth() / (float)arSize.getHeight();
        Size ret = null;
        Size fallbackSize = null;
        for (Size sz : sizes) {
            float currentAR;
            if (fallbackSize == null) {
                fallbackSize = sz;
            }
            if (sz.getHeight() <= 0 || ret != null && ret.getWidth() * ret.getHeight() >= sz.getWidth() * sz.getHeight() || !(Math.abs((currentAR = (float)sz.getWidth() / (float)sz.getHeight()) - targetAR) <= 0.01f)) continue;
            ret = sz;
        }
        if (ret == null) {
            Log.e(TAG, "AR matched size not found returning first size in list");
            ret = fallbackSize;
        }
        return ret;
    }

    private static ParcelImage initializeParcelImage(Image img) {
        ParcelImage parcelImage = new ParcelImage();
        parcelImage.buffer = img.getHardwareBuffer();
        try {
            SyncFence fd = img.getFence();
            if (fd.isValid()) {
                parcelImage.fence = fd.getFdDup();
            }
        }
        catch (IOException e) {
            Log.e(TAG, "Failed to parcel buffer fence!");
        }
        parcelImage.width = img.getWidth();
        parcelImage.height = img.getHeight();
        parcelImage.format = img.getFormat();
        parcelImage.timestamp = img.getTimestamp();
        parcelImage.transform = img.getTransform();
        parcelImage.scalingMode = img.getScalingMode();
        parcelImage.planeCount = img.getPlaneCount();
        parcelImage.crop = img.getCropRect();
        return parcelImage;
    }

    private static List<CaptureBundle> initializeParcelable(HashMap<Integer, Pair<Image, TotalCaptureResult>> captureMap, Integer jpegOrientation, Byte jpegQuality) {
        ArrayList<CaptureBundle> ret = new ArrayList<CaptureBundle>();
        for (Integer stagetId : captureMap.keySet()) {
            Pair<Image, TotalCaptureResult> entry = captureMap.get(stagetId);
            CaptureBundle bundle = new CaptureBundle();
            bundle.stage = stagetId;
            bundle.captureImage = CameraExtensionSessionImpl.initializeParcelImage((Image)entry.first);
            bundle.sequenceId = ((TotalCaptureResult)entry.second).getSequenceId();
            bundle.captureResult = ((TotalCaptureResult)entry.second).getNativeMetadata();
            if (jpegOrientation != null) {
                bundle.captureResult.set(CaptureResult.JPEG_ORIENTATION, jpegOrientation);
            }
            if (jpegQuality != null) {
                bundle.captureResult.set(CaptureResult.JPEG_QUALITY, jpegQuality);
            }
            ret.add(bundle);
        }
        return ret;
    }

    private class PreviewRequestHandler
    extends CameraCaptureSession.CaptureCallback {
        private final Executor mExecutor;
        private final CameraExtensionSession.ExtensionCaptureCallback mCallbacks;
        private final CaptureRequest mClientRequest;
        private final boolean mClientNotificationsEnabled;
        private final CameraOutputImageCallback mRepeatingImageCallback;
        private final boolean mSingleCapture;
        private OnImageAvailableListener mImageCallback = null;
        private LongSparseArray<Pair<Image, TotalCaptureResult>> mPendingResultMap = new LongSparseArray();
        private CaptureResultHandler mCaptureResultHandler = null;
        private boolean mRequestUpdatedNeeded = false;

        public PreviewRequestHandler(CaptureRequest clientRequest, Executor executor, CameraExtensionSession.ExtensionCaptureCallback listener, CameraOutputImageCallback imageCallback) {
            this(clientRequest, executor, listener, imageCallback, false);
        }

        public PreviewRequestHandler(CaptureRequest clientRequest, Executor executor, CameraExtensionSession.ExtensionCaptureCallback listener, CameraOutputImageCallback imageCallback, boolean singleCapture) {
            this.mClientRequest = clientRequest;
            this.mExecutor = executor;
            this.mCallbacks = listener;
            this.mClientNotificationsEnabled = this.mClientRequest != null && this.mExecutor != null && this.mCallbacks != null;
            this.mRepeatingImageCallback = imageCallback;
            this.mSingleCapture = singleCapture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureStarted(CameraCaptureSession session, CaptureRequest request, long timestamp, long frameNumber) {
            Object object = CameraExtensionSessionImpl.this.mInterfaceLock;
            synchronized (object) {
                if (this.mImageCallback == null) {
                    if (CameraExtensionSessionImpl.this.mPreviewProcessorType == 1) {
                        if (this.mClientNotificationsEnabled) {
                            CameraExtensionSessionImpl.this.mPreviewImageProcessor.onOutputSurface(CameraExtensionSessionImpl.this.mClientRepeatingRequestSurface, CameraExtensionSessionImpl.nativeGetSurfaceFormat(CameraExtensionSessionImpl.this.mClientRepeatingRequestSurface));
                        } else {
                            CameraExtensionSessionImpl.this.mPreviewImageProcessor.onOutputSurface(null, -1);
                        }
                        this.mImageCallback = new ImageProcessCallback();
                    } else {
                        this.mImageCallback = this.mClientNotificationsEnabled ? new ImageForwardCallback(CameraExtensionSessionImpl.this.mRepeatingRequestImageWriter) : new ImageLoopbackCallback();
                    }
                }
            }
            if (this.mClientNotificationsEnabled) {
                long ident = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mCallbacks.onCaptureStarted(CameraExtensionSessionImpl.this, this.mClientRequest, timestamp));
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
            this.mRepeatingImageCallback.registerListener(timestamp, this.mImageCallback);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureSequenceAborted(CameraCaptureSession session, int sequenceId) {
            Object object = CameraExtensionSessionImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraExtensionSessionImpl.this.mInternalRepeatingRequestEnabled && !this.mSingleCapture) {
                    this.resumeInternalRepeatingRequest(true);
                }
            }
            if (this.mClientNotificationsEnabled) {
                long ident = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mCallbacks.onCaptureSequenceAborted(CameraExtensionSessionImpl.this, sequenceId));
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            } else {
                CameraExtensionSessionImpl.this.notifyConfigurationFailure();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureSequenceCompleted(CameraCaptureSession session, int sequenceId, long frameNumber) {
            Object object = CameraExtensionSessionImpl.this.mInterfaceLock;
            synchronized (object) {
                if (this.mRequestUpdatedNeeded && !this.mSingleCapture) {
                    this.mRequestUpdatedNeeded = false;
                    this.resumeInternalRepeatingRequest(false);
                } else if (CameraExtensionSessionImpl.this.mInternalRepeatingRequestEnabled && !this.mSingleCapture) {
                    this.resumeInternalRepeatingRequest(true);
                }
            }
            if (this.mClientNotificationsEnabled) {
                long ident = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mCallbacks.onCaptureSequenceCompleted(CameraExtensionSessionImpl.this, sequenceId));
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureFailed(CameraCaptureSession session, CaptureRequest request, CaptureFailure failure) {
            if (this.mClientNotificationsEnabled) {
                long ident = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mCallbacks.onCaptureFailed(CameraExtensionSessionImpl.this, this.mClientRequest));
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
            notifyClient = this.mClientNotificationsEnabled;
            processStatus = true;
            var6_6 = CameraExtensionSessionImpl.this.mInterfaceLock;
            synchronized (var6_6) {
                timestamp = result.get(CaptureResult.SENSOR_TIMESTAMP);
                if (timestamp != null) {
                    if (CameraExtensionSessionImpl.this.mCaptureResultsSupported && this.mClientNotificationsEnabled && this.mCaptureResultHandler == null) {
                        this.mCaptureResultHandler = new CaptureResultHandler(this.mClientRequest, this.mExecutor, this.mCallbacks, result.getSequenceId());
                    }
                    if (!this.mSingleCapture && CameraExtensionSessionImpl.this.mPreviewProcessorType == 0) {
                        captureStage = null;
                        try {
                            captureStage = CameraExtensionSessionImpl.this.mPreviewRequestUpdateProcessor.process(result.getNativeMetadata(), result.getSequenceId());
                        }
                        catch (RemoteException e) {
                            Log.e("CameraExtensionSessionImpl", "Extension service does not respond during processing!");
                        }
                        if (captureStage != null) {
                            try {
                                CameraExtensionSessionImpl.this.setRepeatingRequest(captureStage, this, request);
                                this.mRequestUpdatedNeeded = true;
                            }
                            catch (IllegalStateException e) {
                            }
                            catch (CameraAccessException e) {
                                Log.e("CameraExtensionSessionImpl", "Failed to update repeating request settings!");
                            }
                        } else {
                            this.mRequestUpdatedNeeded = false;
                        }
                    } else if (CameraExtensionSessionImpl.this.mPreviewProcessorType == 1) {
                        idx = this.mPendingResultMap.indexOfKey(timestamp);
                        if (idx >= 0 && this.mPendingResultMap.get((long)timestamp.longValue()).first == null) {
                            if (this.mCaptureResultHandler != null) {
                                this.mCaptureResultHandler.onCaptureCompleted(timestamp, CameraExtensionSessionImpl.this.initializeFilteredResults(result));
                            }
                            this.discardPendingRepeatingResults(idx, this.mPendingResultMap, false);
                        } else if (idx >= 0) {
                            parcelImage = CameraExtensionSessionImpl.initializeParcelImage((Image)this.mPendingResultMap.get((long)timestamp.longValue()).first);
                            try {
                                CameraExtensionSessionImpl.this.mPreviewImageProcessor.process(parcelImage, result, this.mCaptureResultHandler);
                            }
                            catch (RemoteException e) {
                                processStatus = false;
                                Log.e("CameraExtensionSessionImpl", "Extension service does not respond during processing, dropping frame!");
                            }
                            catch (RuntimeException e) {
                                processStatus = false;
                                Log.e("CameraExtensionSessionImpl", "Runtime exception encountered during buffer processing, dropping frame!");
                            }
                            finally {
                                parcelImage.buffer.close();
                                ((Image)this.mPendingResultMap.get((long)timestamp.longValue()).first).close();
                            }
                            this.discardPendingRepeatingResults(idx, this.mPendingResultMap, false);
                        } else {
                            notifyClient = false;
                            this.mPendingResultMap.put(timestamp, new Pair<Object, TotalCaptureResult>(null, result));
                        }
                    }
                    if (notifyClient) {
                        ident = Binder.clearCallingIdentity();
                        try {
                            if (processStatus) {
                                this.mExecutor.execute((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$onCaptureCompleted$4(), ()V)((PreviewRequestHandler)this));
                                if (this.mCaptureResultHandler == null || CameraExtensionSessionImpl.this.mPreviewProcessorType == 1) ** GOTO lbl82
                                this.mCaptureResultHandler.onCaptureCompleted(timestamp, CameraExtensionSessionImpl.this.initializeFilteredResults(result));
                            }
                            this.mExecutor.execute((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$onCaptureCompleted$5(), ()V)((PreviewRequestHandler)this));
                        }
                        finally {
                            Binder.restoreCallingIdentity(ident);
                        }
                    }
                } else {
                    Log.e("CameraExtensionSessionImpl", "Result without valid sensor timestamp!");
                }
            }
lbl82:
            // 5 sources

            if (!notifyClient) {
                CameraExtensionSessionImpl.this.notifyConfigurationSuccess();
            }
        }

        private void resumeInternalRepeatingRequest(boolean internal) {
            try {
                if (internal) {
                    CameraExtensionSessionImpl.this.setRepeatingRequest(CameraExtensionSessionImpl.this.mPreviewExtender.getCaptureStage(), new PreviewRequestHandler(null, null, null, this.mRepeatingImageCallback));
                } else {
                    CameraExtensionSessionImpl.this.setRepeatingRequest(CameraExtensionSessionImpl.this.mPreviewExtender.getCaptureStage(), this, this.mClientRequest);
                }
            }
            catch (RemoteException e) {
                Log.e(CameraExtensionSessionImpl.TAG, "Failed to resume internal repeating request, extension service fails to respond!");
            }
            catch (IllegalStateException e) {
                Log.w(CameraExtensionSessionImpl.TAG, "Failed to resume internal repeating request!");
            }
            catch (CameraAccessException e) {
                Log.e(CameraExtensionSessionImpl.TAG, "Failed to resume internal repeating request!");
            }
        }

        private Long calculatePruneThreshold(LongSparseArray<Pair<Image, TotalCaptureResult>> previewMap) {
            long oldestTimestamp = Long.MAX_VALUE;
            for (int idx = 0; idx < previewMap.size(); ++idx) {
                Pair<Image, TotalCaptureResult> entry = previewMap.valueAt(idx);
                long timestamp = previewMap.keyAt(idx);
                if (entry.first == null || timestamp >= oldestTimestamp) continue;
                oldestTimestamp = timestamp;
            }
            return oldestTimestamp == Long.MAX_VALUE ? 0L : oldestTimestamp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void discardPendingRepeatingResults(int idx, LongSparseArray<Pair<Image, TotalCaptureResult>> previewMap, boolean notifyCurrentIndex) {
            if (idx < 0) {
                return;
            }
            for (int i = idx; i >= 0; --i) {
                if (previewMap.valueAt((int)i).first != null) {
                    ((Image)previewMap.valueAt((int)i).first).close();
                } else if (this.mClientNotificationsEnabled && previewMap.valueAt((int)i).second != null && (i != idx || notifyCurrentIndex)) {
                    TotalCaptureResult result = (TotalCaptureResult)previewMap.valueAt((int)i).second;
                    Long timestamp = result.get(CaptureResult.SENSOR_TIMESTAMP);
                    this.mCaptureResultHandler.onCaptureCompleted(timestamp, CameraExtensionSessionImpl.this.initializeFilteredResults(result));
                    Log.w(CameraExtensionSessionImpl.TAG, "Preview frame drop with timestamp: " + previewMap.keyAt(i));
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.mExecutor.execute(() -> this.mCallbacks.onCaptureFailed(CameraExtensionSessionImpl.this, this.mClientRequest));
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
                previewMap.removeAt(i);
            }
        }

        private /* synthetic */ void lambda$onCaptureCompleted$5() {
            this.mCallbacks.onCaptureFailed(CameraExtensionSessionImpl.this, this.mClientRequest);
        }

        private /* synthetic */ void lambda$onCaptureCompleted$4() {
            this.mCallbacks.onCaptureProcessStarted(CameraExtensionSessionImpl.this, this.mClientRequest);
        }

        private class ImageProcessCallback
        implements OnImageAvailableListener {
            private ImageProcessCallback() {
            }

            @Override
            public void onImageDropped(long timestamp) {
                PreviewRequestHandler.this.discardPendingRepeatingResults(PreviewRequestHandler.this.mPendingResultMap.indexOfKey(timestamp), PreviewRequestHandler.this.mPendingResultMap, true);
                PreviewRequestHandler.this.mPendingResultMap.put(timestamp, new Pair<Object, Object>(null, null));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onImageAvailable(ImageReader reader, Image img) {
                if (PreviewRequestHandler.this.mPendingResultMap.size() + 1 >= 10) {
                    PreviewRequestHandler.this.discardPendingRepeatingResults(PreviewRequestHandler.this.mPendingResultMap.indexOfKey(PreviewRequestHandler.this.calculatePruneThreshold(PreviewRequestHandler.this.mPendingResultMap)), PreviewRequestHandler.this.mPendingResultMap, true);
                }
                if (img == null) {
                    Log.e(CameraExtensionSessionImpl.TAG, "Invalid preview buffer!");
                    return;
                }
                try {
                    reader.detachImage(img);
                }
                catch (Exception e) {
                    Log.e(CameraExtensionSessionImpl.TAG, "Failed to detach image!");
                    img.close();
                    return;
                }
                long timestamp = img.getTimestamp();
                int idx = PreviewRequestHandler.this.mPendingResultMap.indexOfKey(timestamp);
                if (idx >= 0) {
                    boolean processStatus = true;
                    ParcelImage parcelImage = CameraExtensionSessionImpl.initializeParcelImage(img);
                    try {
                        CameraExtensionSessionImpl.this.mPreviewImageProcessor.process(parcelImage, (TotalCaptureResult)PreviewRequestHandler.this.mPendingResultMap.get((long)timestamp).second, PreviewRequestHandler.this.mCaptureResultHandler);
                    }
                    catch (RemoteException e) {
                        processStatus = false;
                        Log.e(CameraExtensionSessionImpl.TAG, "Extension service does not respond during processing, dropping frame!");
                    }
                    finally {
                        parcelImage.buffer.close();
                        img.close();
                    }
                    PreviewRequestHandler.this.discardPendingRepeatingResults(idx, PreviewRequestHandler.this.mPendingResultMap, false);
                    if (PreviewRequestHandler.this.mClientNotificationsEnabled) {
                        long ident = Binder.clearCallingIdentity();
                        try {
                            if (processStatus) {
                                PreviewRequestHandler.this.mExecutor.execute(() -> PreviewRequestHandler.this.mCallbacks.onCaptureProcessStarted(CameraExtensionSessionImpl.this, PreviewRequestHandler.this.mClientRequest));
                            }
                            PreviewRequestHandler.this.mExecutor.execute(() -> PreviewRequestHandler.this.mCallbacks.onCaptureFailed(CameraExtensionSessionImpl.this, PreviewRequestHandler.this.mClientRequest));
                        }
                        finally {
                            Binder.restoreCallingIdentity(ident);
                        }
                    }
                } else {
                    PreviewRequestHandler.this.mPendingResultMap.put(timestamp, new Pair<Image, Object>(img, null));
                }
            }
        }

        private class ImageForwardCallback
        implements OnImageAvailableListener {
            private final ImageWriter mOutputWriter;

            public ImageForwardCallback(ImageWriter imageWriter) {
                this.mOutputWriter = imageWriter;
            }

            @Override
            public void onImageDropped(long timestamp) {
                PreviewRequestHandler.this.discardPendingRepeatingResults(PreviewRequestHandler.this.mPendingResultMap.indexOfKey(timestamp), PreviewRequestHandler.this.mPendingResultMap, true);
            }

            @Override
            public void onImageAvailable(ImageReader reader, Image img) {
                if (img == null) {
                    Log.e(CameraExtensionSessionImpl.TAG, "Invalid image!");
                    return;
                }
                try {
                    this.mOutputWriter.queueInputImage(img);
                }
                catch (IllegalStateException e) {
                    Log.w(CameraExtensionSessionImpl.TAG, "Output surface likely abandoned, dropping buffer!");
                    img.close();
                }
            }
        }
    }

    private class CaptureResultHandler
    extends IProcessResultImpl.Stub {
        private final Executor mExecutor;
        private final CameraExtensionSession.ExtensionCaptureCallback mCallbacks;
        private final CaptureRequest mClientRequest;
        private final int mRequestId;

        public CaptureResultHandler(CaptureRequest clientRequest, Executor executor, CameraExtensionSession.ExtensionCaptureCallback listener, int requestId) {
            this.mClientRequest = clientRequest;
            this.mExecutor = executor;
            this.mCallbacks = listener;
            this.mRequestId = requestId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureCompleted(long shutterTimestamp, CameraMetadataNative result) {
            if (result == null) {
                Log.e(CameraExtensionSessionImpl.TAG, "Invalid capture result!");
                return;
            }
            result.set(CaptureResult.SENSOR_TIMESTAMP, Long.valueOf(shutterTimestamp));
            TotalCaptureResult totalResult = new TotalCaptureResult(CameraExtensionSessionImpl.this.mCameraDevice.getId(), result, this.mClientRequest, this.mRequestId, shutterTimestamp, new ArrayList<CaptureResult>(), CameraExtensionSessionImpl.this.mSessionId, new PhysicalCaptureResultInfo[0]);
            long ident = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallbacks.onCaptureResultAvailable(CameraExtensionSessionImpl.this, this.mClientRequest, totalResult));
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    private class CloseRequestHandler
    extends CameraCaptureSession.CaptureCallback {
        private final CameraOutputImageCallback mImageCallback;

        public CloseRequestHandler(CameraOutputImageCallback imageCallback) {
            this.mImageCallback = imageCallback;
        }

        @Override
        public void onCaptureStarted(CameraCaptureSession session, CaptureRequest request, long timestamp, long frameNumber) {
            this.mImageCallback.registerListener(timestamp, new ImageLoopbackCallback());
        }
    }

    private class CameraOutputImageCallback
    implements ImageReader.OnImageAvailableListener,
    Closeable {
        private final ImageReader mImageReader;
        private HashMap<Long, Pair<Image, OnImageAvailableListener>> mImageListenerMap = new HashMap();
        private boolean mOutOfBuffers = false;

        CameraOutputImageCallback(ImageReader imageReader) {
            this.mImageReader = imageReader;
        }

        @Override
        public void onImageAvailable(ImageReader reader) {
            Image img;
            try {
                img = reader.acquireNextImage();
            }
            catch (IllegalStateException e) {
                Log.e(CameraExtensionSessionImpl.TAG, "Failed to acquire image, too many images pending!");
                this.mOutOfBuffers = true;
                return;
            }
            if (img == null) {
                Log.e(CameraExtensionSessionImpl.TAG, "Invalid image!");
                return;
            }
            Long timestamp = img.getTimestamp();
            if (this.mImageListenerMap.containsKey(timestamp)) {
                Pair<Image, OnImageAvailableListener> entry = this.mImageListenerMap.remove(timestamp);
                if (entry.second != null) {
                    ((OnImageAvailableListener)entry.second).onImageAvailable(reader, img);
                } else {
                    Log.w(CameraExtensionSessionImpl.TAG, "Invalid image listener, dropping frame!");
                    img.close();
                }
            } else {
                this.mImageListenerMap.put(img.getTimestamp(), new Pair<Image, Object>(img, null));
            }
            this.notifyDroppedImages(timestamp);
        }

        private void notifyDroppedImages(long timestamp) {
            Set<Long> timestamps = this.mImageListenerMap.keySet();
            ArrayList<Long> removedTs = new ArrayList<Long>();
            for (long ts : timestamps) {
                if (ts >= timestamp) continue;
                Log.e(CameraExtensionSessionImpl.TAG, "Dropped image with ts: " + ts);
                Pair<Image, OnImageAvailableListener> entry = this.mImageListenerMap.get(ts);
                if (entry.second != null) {
                    ((OnImageAvailableListener)entry.second).onImageDropped(ts);
                }
                if (entry.first != null) {
                    ((Image)entry.first).close();
                }
                removedTs.add(ts);
            }
            for (long ts : removedTs) {
                this.mImageListenerMap.remove(ts);
            }
        }

        public void registerListener(Long timestamp, OnImageAvailableListener listener) {
            if (this.mImageListenerMap.containsKey(timestamp)) {
                Pair<Image, OnImageAvailableListener> entry = this.mImageListenerMap.remove(timestamp);
                if (entry.first != null) {
                    listener.onImageAvailable(this.mImageReader, (Image)entry.first);
                    if (this.mOutOfBuffers) {
                        this.mOutOfBuffers = false;
                        Log.w(CameraExtensionSessionImpl.TAG, "Out of buffers, retry!");
                        this.onImageAvailable(this.mImageReader);
                    }
                } else {
                    Log.w(CameraExtensionSessionImpl.TAG, "No valid image for listener with ts: " + timestamp);
                }
            } else {
                this.mImageListenerMap.put(timestamp, new Pair<Object, OnImageAvailableListener>(null, listener));
            }
        }

        @Override
        public void close() {
            for (Pair<Image, OnImageAvailableListener> entry : this.mImageListenerMap.values()) {
                if (entry.first == null) continue;
                ((Image)entry.first).close();
            }
            Iterator<Object> iterator = this.mImageListenerMap.keySet().iterator();
            while (iterator.hasNext()) {
                long timestamp = (Long)iterator.next();
                Pair<Image, OnImageAvailableListener> entry = this.mImageListenerMap.get(timestamp);
                if (entry.second == null) continue;
                ((OnImageAvailableListener)entry.second).onImageDropped(timestamp);
            }
            this.mImageListenerMap.clear();
        }
    }

    private static interface OnImageAvailableListener {
        public void onImageDropped(long var1);

        public void onImageAvailable(ImageReader var1, Image var2);
    }

    private class InitialRequestHandler
    extends CameraCaptureSession.CaptureCallback {
        private final CameraOutputImageCallback mImageCallback;

        public InitialRequestHandler(CameraOutputImageCallback imageCallback) {
            this.mImageCallback = imageCallback;
        }

        @Override
        public void onCaptureStarted(CameraCaptureSession session, CaptureRequest request, long timestamp, long frameNumber) {
            this.mImageCallback.registerListener(timestamp, new ImageLoopbackCallback());
        }

        @Override
        public void onCaptureSequenceAborted(CameraCaptureSession session, int sequenceId) {
            Log.e(CameraExtensionSessionImpl.TAG, "Initial capture request aborted!");
            CameraExtensionSessionImpl.this.notifyConfigurationFailure();
        }

        @Override
        public void onCaptureFailed(CameraCaptureSession session, CaptureRequest request, CaptureFailure failure) {
            Log.e(CameraExtensionSessionImpl.TAG, "Initial capture request failed!");
            CameraExtensionSessionImpl.this.notifyConfigurationFailure();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureSequenceCompleted(CameraCaptureSession session, int sequenceId, long frameNumber) {
            boolean status = true;
            Object object = CameraExtensionSessionImpl.this.mInterfaceLock;
            synchronized (object) {
                try {
                    CameraExtensionSessionImpl.this.setRepeatingRequest(CameraExtensionSessionImpl.this.mPreviewExtender.getCaptureStage(), new PreviewRequestHandler(null, null, null, this.mImageCallback));
                }
                catch (CameraAccessException | RemoteException e) {
                    Log.e(CameraExtensionSessionImpl.TAG, "Failed to start the internal repeating request!");
                    status = false;
                }
            }
            if (!status) {
                CameraExtensionSessionImpl.this.notifyConfigurationFailure();
            }
        }
    }

    private class ImageLoopbackCallback
    implements OnImageAvailableListener {
        private ImageLoopbackCallback() {
        }

        @Override
        public void onImageDropped(long timestamp) {
        }

        @Override
        public void onImageAvailable(ImageReader reader, Image img) {
            img.close();
        }
    }

    private class BurstRequestHandler
    extends CameraCaptureSession.CaptureCallback {
        private final Executor mExecutor;
        private final CameraExtensionSession.ExtensionCaptureCallback mCallbacks;
        private final CaptureRequest mClientRequest;
        private final HashMap<CaptureRequest, Integer> mCaptureRequestMap;
        private final CameraOutputImageCallback mBurstImageCallback;
        private HashMap<Integer, Pair<Image, TotalCaptureResult>> mCaptureStageMap = new HashMap();
        private LongSparseArray<Pair<Image, Integer>> mCapturePendingMap = new LongSparseArray();
        private ImageCallback mImageCallback = null;
        private boolean mCaptureFailed = false;
        private CaptureResultHandler mCaptureResultHandler = null;

        public BurstRequestHandler(CaptureRequest request, Executor executor, CameraExtensionSession.ExtensionCaptureCallback callbacks, HashMap<CaptureRequest, Integer> requestMap, CameraOutputImageCallback imageCallback) {
            this.mClientRequest = request;
            this.mExecutor = executor;
            this.mCallbacks = callbacks;
            this.mCaptureRequestMap = requestMap;
            this.mBurstImageCallback = imageCallback;
        }

        private void notifyCaptureFailed() {
            if (!this.mCaptureFailed) {
                this.mCaptureFailed = true;
                long ident = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mCallbacks.onCaptureFailed(CameraExtensionSessionImpl.this, this.mClientRequest));
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
                for (Pair<Image, TotalCaptureResult> captureStage : this.mCaptureStageMap.values()) {
                    ((Image)captureStage.first).close();
                }
                this.mCaptureStageMap.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureStarted(CameraCaptureSession session, CaptureRequest request, long timestamp, long frameNumber) {
            boolean initialCallback = false;
            Object object = CameraExtensionSessionImpl.this.mInterfaceLock;
            synchronized (object) {
                if (CameraExtensionSessionImpl.this.mImageProcessor != null && this.mImageCallback == null) {
                    this.mImageCallback = new ImageCallback();
                    initialCallback = true;
                } else if (CameraExtensionSessionImpl.this.mImageProcessor == null) {
                    initialCallback = true;
                }
            }
            if (initialCallback) {
                long ident = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mCallbacks.onCaptureStarted(CameraExtensionSessionImpl.this, this.mClientRequest, timestamp));
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
            if (this.mBurstImageCallback != null && this.mImageCallback != null) {
                this.mBurstImageCallback.registerListener(timestamp, this.mImageCallback);
            }
        }

        @Override
        public void onCaptureBufferLost(CameraCaptureSession session, CaptureRequest request, Surface target, long frameNumber) {
            this.notifyCaptureFailed();
        }

        @Override
        public void onCaptureFailed(CameraCaptureSession session, CaptureRequest request, CaptureFailure failure) {
            this.notifyCaptureFailed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureSequenceAborted(CameraCaptureSession session, int sequenceId) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallbacks.onCaptureSequenceAborted(CameraExtensionSessionImpl.this, sequenceId));
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCaptureSequenceCompleted(CameraCaptureSession session, int sequenceId, long frameNumber) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallbacks.onCaptureSequenceCompleted(CameraExtensionSessionImpl.this, sequenceId));
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
            if (!this.mCaptureRequestMap.containsKey(request)) {
                Log.e(CameraExtensionSessionImpl.TAG, "Unexpected still capture request received!");
                return;
            }
            Integer stageId = this.mCaptureRequestMap.get(request);
            Long timestamp = result.get(CaptureResult.SENSOR_TIMESTAMP);
            if (timestamp != null) {
                if (CameraExtensionSessionImpl.this.mCaptureResultsSupported && this.mCaptureResultHandler == null) {
                    this.mCaptureResultHandler = new CaptureResultHandler(this.mClientRequest, this.mExecutor, this.mCallbacks, result.getSequenceId());
                }
                if (CameraExtensionSessionImpl.this.mImageProcessor != null) {
                    if (this.mCapturePendingMap.indexOfKey(timestamp) >= 0) {
                        Image img = (Image)this.mCapturePendingMap.get((long)timestamp.longValue()).first;
                        this.mCaptureStageMap.put(stageId, new Pair<Image, TotalCaptureResult>(img, result));
                        this.checkAndFireBurstProcessing();
                        return;
                    } else {
                        this.mCapturePendingMap.put(timestamp, new Pair<Object, Integer>(null, stageId));
                        this.mCaptureStageMap.put(stageId, new Pair<Object, TotalCaptureResult>(null, result));
                    }
                    return;
                } else {
                    this.mCaptureRequestMap.clear();
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.mExecutor.execute(() -> this.mCallbacks.onCaptureProcessStarted(CameraExtensionSessionImpl.this, this.mClientRequest));
                        if (this.mCaptureResultHandler == null) return;
                        this.mCaptureResultHandler.onCaptureCompleted(timestamp, CameraExtensionSessionImpl.this.initializeFilteredResults(result));
                        return;
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
            } else {
                Log.e(CameraExtensionSessionImpl.TAG, "Capture result without valid sensor timestamp!");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkAndFireBurstProcessing() {
            if (this.mCaptureRequestMap.size() == this.mCaptureStageMap.size()) {
                for (Pair<Image, TotalCaptureResult> captureStage : this.mCaptureStageMap.values()) {
                    if (captureStage.first != null && captureStage.second != null) continue;
                    return;
                }
                this.mCaptureRequestMap.clear();
                this.mCapturePendingMap.clear();
                boolean processStatus = true;
                Byte jpegQuality = this.mClientRequest.get(CaptureRequest.JPEG_QUALITY);
                Integer jpegOrientation = this.mClientRequest.get(CaptureRequest.JPEG_ORIENTATION);
                List<CaptureBundle> captureList = CameraExtensionSessionImpl.initializeParcelable(this.mCaptureStageMap, jpegOrientation, jpegQuality);
                try {
                    CameraExtensionSessionImpl.this.mImageProcessor.process(captureList, this.mCaptureResultHandler);
                }
                catch (RemoteException e) {
                    Log.e(CameraExtensionSessionImpl.TAG, "Failed to process multi-frame request! Extension service does not respond!");
                    processStatus = false;
                }
                for (CaptureBundle captureBundle : captureList) {
                    captureBundle.captureImage.buffer.close();
                }
                captureList.clear();
                for (Pair pair : this.mCaptureStageMap.values()) {
                    ((Image)pair.first).close();
                }
                this.mCaptureStageMap.clear();
                long ident = Binder.clearCallingIdentity();
                try {
                    if (processStatus) {
                        this.mExecutor.execute(() -> this.mCallbacks.onCaptureProcessStarted(CameraExtensionSessionImpl.this, this.mClientRequest));
                    } else {
                        this.mExecutor.execute(() -> this.mCallbacks.onCaptureFailed(CameraExtensionSessionImpl.this, this.mClientRequest));
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
        }

        private class ImageCallback
        implements OnImageAvailableListener {
            private ImageCallback() {
            }

            @Override
            public void onImageDropped(long timestamp) {
                BurstRequestHandler.this.notifyCaptureFailed();
            }

            @Override
            public void onImageAvailable(ImageReader reader, Image img) {
                if (BurstRequestHandler.this.mCaptureFailed) {
                    img.close();
                }
                long timestamp = img.getTimestamp();
                reader.detachImage(img);
                if (BurstRequestHandler.this.mCapturePendingMap.indexOfKey(timestamp) >= 0) {
                    Integer stageId = (Integer)BurstRequestHandler.this.mCapturePendingMap.get((long)timestamp).second;
                    Pair<Image, TotalCaptureResult> captureStage = BurstRequestHandler.this.mCaptureStageMap.get(stageId);
                    if (captureStage != null) {
                        BurstRequestHandler.this.mCaptureStageMap.put(stageId, new Pair<Image, TotalCaptureResult>(img, (TotalCaptureResult)captureStage.second));
                        BurstRequestHandler.this.checkAndFireBurstProcessing();
                    } else {
                        Log.e(CameraExtensionSessionImpl.TAG, "Capture stage: " + BurstRequestHandler.this.mCapturePendingMap.get((long)timestamp).second + " is absent!");
                    }
                } else {
                    BurstRequestHandler.this.mCapturePendingMap.put(timestamp, new Pair<Image, Integer>(img, -1));
                }
            }
        }
    }

    private class InitializeSessionHandler
    extends IInitializeSessionCallback.Stub {
        private InitializeSessionHandler() {
        }

        @Override
        public void onSuccess() {
            boolean status = true;
            ArrayList<CaptureStageImpl> initialRequestList = CameraExtensionSessionImpl.this.compileInitialRequestList();
            if (!initialRequestList.isEmpty()) {
                try {
                    CameraExtensionSessionImpl.this.setInitialCaptureRequest(initialRequestList, new InitialRequestHandler(CameraExtensionSessionImpl.this.mRepeatingRequestImageCallback));
                }
                catch (CameraAccessException e) {
                    Log.e(CameraExtensionSessionImpl.TAG, "Failed to initialize the initial capture request!");
                    status = false;
                }
            } else {
                try {
                    CameraExtensionSessionImpl.this.setRepeatingRequest(CameraExtensionSessionImpl.this.mPreviewExtender.getCaptureStage(), new PreviewRequestHandler(null, null, null, CameraExtensionSessionImpl.this.mRepeatingRequestImageCallback));
                }
                catch (CameraAccessException | RemoteException e) {
                    Log.e(CameraExtensionSessionImpl.TAG, "Failed to initialize internal repeating request!");
                    status = false;
                }
            }
            if (!status) {
                CameraExtensionSessionImpl.this.notifyConfigurationFailure();
            }
        }

        @Override
        public void onFailure() {
            CameraExtensionSessionImpl.this.mCaptureSession.close();
            Log.e(CameraExtensionSessionImpl.TAG, "Failed to initialize proxy service session! This can happen when trying to configure multiple concurrent extension sessions!");
            CameraExtensionSessionImpl.this.notifyConfigurationFailure();
        }
    }

    private class SessionStateHandler
    extends CameraCaptureSession.StateCallback {
        private SessionStateHandler() {
        }

        @Override
        public void onClosed(CameraCaptureSession session) {
            CameraExtensionSessionImpl.this.release(false);
        }

        @Override
        public void onConfigureFailed(CameraCaptureSession session) {
            CameraExtensionSessionImpl.this.notifyConfigurationFailure();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConfigured(CameraCaptureSession session) {
            Object object = CameraExtensionSessionImpl.this.mInterfaceLock;
            synchronized (object) {
                CameraExtensionSessionImpl.this.mCaptureSession = session;
                try {
                    CameraExtensionSessionImpl.this.finishPipelineInitialization();
                    CameraExtensionCharacteristics.initializeSession(CameraExtensionSessionImpl.this.mInitializeHandler);
                }
                catch (RemoteException e) {
                    Log.e(CameraExtensionSessionImpl.TAG, "Failed to initialize session! Extension service does not respond!");
                    CameraExtensionSessionImpl.this.notifyConfigurationFailure();
                }
            }
        }
    }
}

