/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.params.RggbChannelVector;
import android.hardware.camera2.utils.TypeReference;
import java.nio.ByteBuffer;

public class MarshalQueryableRggbChannelVector
implements MarshalQueryable<RggbChannelVector> {
    private static final int SIZE = 16;

    @Override
    public Marshaler<RggbChannelVector> createMarshaler(TypeReference<RggbChannelVector> managedType, int nativeType) {
        return new MarshalerRggbChannelVector(managedType, nativeType);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<RggbChannelVector> managedType, int nativeType) {
        return nativeType == 2 && RggbChannelVector.class.equals((Object)managedType.getType());
    }

    private class MarshalerRggbChannelVector
    extends Marshaler<RggbChannelVector> {
        protected MarshalerRggbChannelVector(TypeReference<RggbChannelVector> typeReference, int nativeType) {
            super(MarshalQueryableRggbChannelVector.this, typeReference, nativeType);
        }

        @Override
        public void marshal(RggbChannelVector value, ByteBuffer buffer) {
            for (int i = 0; i < 4; ++i) {
                buffer.putFloat(value.getComponent(i));
            }
        }

        @Override
        public RggbChannelVector unmarshal(ByteBuffer buffer) {
            float red = buffer.getFloat();
            float gEven = buffer.getFloat();
            float gOdd = buffer.getFloat();
            float blue = buffer.getFloat();
            return new RggbChannelVector(red, gEven, gOdd, blue);
        }

        @Override
        public int getNativeSize() {
            return 16;
        }
    }
}

