/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.app.ActivityThread;
import android.hardware.input.InputManager;
import android.hardware.lights.Light;
import android.hardware.lights.LightState;
import android.hardware.lights.LightsManager;
import android.hardware.lights.LightsRequest;
import android.util.CloseGuard;
import com.android.internal.util.Preconditions;
import java.lang.ref.Reference;
import java.util.List;

class InputDeviceLightsManager
extends LightsManager {
    private static final String TAG = "InputDeviceLightsManager";
    private static final boolean DEBUG = false;
    private final InputManager mInputManager;
    private final int mDeviceId;
    private final String mPackageName;

    InputDeviceLightsManager(InputManager inputManager, int deviceId) {
        super(ActivityThread.currentActivityThread().getSystemContext());
        this.mInputManager = inputManager;
        this.mDeviceId = deviceId;
        this.mPackageName = ActivityThread.currentPackageName();
    }

    @Override
    public List<Light> getLights() {
        return this.mInputManager.getLights(this.mDeviceId);
    }

    @Override
    public LightState getLightState(Light light) {
        Preconditions.checkNotNull(light);
        return this.mInputManager.getLightState(this.mDeviceId, light);
    }

    @Override
    public LightsManager.LightsSession openSession() {
        InputDeviceLightsSession session = new InputDeviceLightsSession();
        this.mInputManager.openLightSession(this.mDeviceId, this.mPackageName, session.getToken());
        return session;
    }

    @Override
    public LightsManager.LightsSession openSession(int priority) {
        throw new UnsupportedOperationException();
    }

    public class InputDeviceLightsSession
    extends LightsManager.LightsSession
    implements AutoCloseable {
        private final CloseGuard mCloseGuard = new CloseGuard();
        private boolean mClosed = false;

        private InputDeviceLightsSession() {
            this.mCloseGuard.open("InputDeviceLightsSession.close");
        }

        @Override
        public void requestLights(LightsRequest request) {
            Preconditions.checkNotNull(request);
            Preconditions.checkArgument(!this.mClosed);
            InputDeviceLightsManager.this.mInputManager.requestLights(InputDeviceLightsManager.this.mDeviceId, request, this.getToken());
        }

        @Override
        public void close() {
            if (!this.mClosed) {
                InputDeviceLightsManager.this.mInputManager.closeLightSession(InputDeviceLightsManager.this.mDeviceId, this.getToken());
                this.mClosed = true;
                this.mCloseGuard.close();
            }
            Reference.reachabilityFence(this);
        }

        protected void finalize() throws Throwable {
            try {
                this.mCloseGuard.warnIfOpen();
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }
}

