/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.RequiresPermission;
import android.bluetooth.BluetoothDevice;
import android.compat.annotation.UnsupportedAppUsage;
import android.media.AudioAttributes;
import android.media.AudioDeviceAttributes;
import android.media.AudioFocusInfo;
import android.media.AudioFormat;
import android.media.AudioPlaybackConfiguration;
import android.media.AudioRecordingConfiguration;
import android.media.AudioRoutesInfo;
import android.media.BluetoothProfileConnectionInfo;
import android.media.IAudioDeviceVolumeDispatcher;
import android.media.IAudioFocusDispatcher;
import android.media.IAudioModeDispatcher;
import android.media.IAudioRoutesObserver;
import android.media.IAudioServerStateDispatcher;
import android.media.ICapturePresetDevicesRoleDispatcher;
import android.media.ICommunicationDeviceDispatcher;
import android.media.IDeviceVolumeBehaviorDispatcher;
import android.media.IMuteAwaitConnectionCallback;
import android.media.IPlaybackConfigDispatcher;
import android.media.IRecordingConfigDispatcher;
import android.media.IRingtonePlayer;
import android.media.ISpatializerCallback;
import android.media.ISpatializerHeadToSoundStagePoseCallback;
import android.media.ISpatializerHeadTrackerAvailableCallback;
import android.media.ISpatializerHeadTrackingModeCallback;
import android.media.ISpatializerOutputCallback;
import android.media.IStrategyPreferredDevicesDispatcher;
import android.media.IVolumeController;
import android.media.PlayerBase;
import android.media.VolumeInfo;
import android.media.VolumePolicy;
import android.media.audiopolicy.AudioPolicyConfig;
import android.media.audiopolicy.AudioProductStrategy;
import android.media.audiopolicy.AudioVolumeGroup;
import android.media.audiopolicy.IAudioPolicyCallback;
import android.media.projection.IMediaProjection;
import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.UserHandle;
import android.view.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface IAudioService
extends IInterface {
    public int trackPlayer(PlayerBase.PlayerIdCard var1) throws RemoteException;

    public void playerAttributes(int var1, AudioAttributes var2) throws RemoteException;

    public void playerEvent(int var1, int var2, int var3) throws RemoteException;

    public void releasePlayer(int var1) throws RemoteException;

    public int trackRecorder(IBinder var1) throws RemoteException;

    public void recorderEvent(int var1, int var2) throws RemoteException;

    public void releaseRecorder(int var1) throws RemoteException;

    public void playerSessionId(int var1, int var2) throws RemoteException;

    public void adjustStreamVolume(int var1, int var2, int var3, String var4) throws RemoteException;

    public void adjustStreamVolumeWithAttribution(int var1, int var2, int var3, String var4, String var5) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/media/java/android/media/IAudioService.aidl:95:1:95:69")
    public void setStreamVolume(int var1, int var2, int var3, String var4) throws RemoteException;

    public void setStreamVolumeWithAttribution(int var1, int var2, int var3, String var4, String var5) throws RemoteException;

    public void handleVolumeKey(KeyEvent var1, boolean var2, String var3, String var4) throws RemoteException;

    public boolean isStreamMute(int var1) throws RemoteException;

    public void forceRemoteSubmixFullVolume(boolean var1, IBinder var2) throws RemoteException;

    public boolean isMasterMute() throws RemoteException;

    public void setMasterMute(boolean var1, int var2, String var3, int var4, String var5) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/media/java/android/media/IAudioService.aidl:113:1:113:25")
    public int getStreamVolume(int var1) throws RemoteException;

    public int getStreamMinVolume(int var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/media/java/android/media/IAudioService.aidl:118:1:118:25")
    public int getStreamMaxVolume(int var1) throws RemoteException;

    public List<AudioVolumeGroup> getAudioVolumeGroups() throws RemoteException;

    public void setVolumeIndexForAttributes(AudioAttributes var1, int var2, int var3, String var4, String var5) throws RemoteException;

    public int getVolumeIndexForAttributes(AudioAttributes var1) throws RemoteException;

    public int getMaxVolumeIndexForAttributes(AudioAttributes var1) throws RemoteException;

    public int getMinVolumeIndexForAttributes(AudioAttributes var1) throws RemoteException;

    public int getLastAudibleStreamVolume(int var1) throws RemoteException;

    public void setSupportedSystemUsages(int[] var1) throws RemoteException;

    public int[] getSupportedSystemUsages() throws RemoteException;

    public List<AudioProductStrategy> getAudioProductStrategies() throws RemoteException;

    public boolean isMicrophoneMuted() throws RemoteException;

    public boolean isUltrasoundSupported() throws RemoteException;

    public void setMicrophoneMute(boolean var1, String var2, int var3, String var4) throws RemoteException;

    public void setMicrophoneMuteFromSwitch(boolean var1) throws RemoteException;

    public void setRingerModeExternal(int var1, String var2) throws RemoteException;

    public void setRingerModeInternal(int var1, String var2) throws RemoteException;

    public int getRingerModeExternal() throws RemoteException;

    public int getRingerModeInternal() throws RemoteException;

    public boolean isValidRingerMode(int var1) throws RemoteException;

    public void setVibrateSetting(int var1, int var2) throws RemoteException;

    public int getVibrateSetting(int var1) throws RemoteException;

    public boolean shouldVibrate(int var1) throws RemoteException;

    public void setMode(int var1, IBinder var2, String var3) throws RemoteException;

    public int getMode() throws RemoteException;

    public void playSoundEffect(int var1, int var2) throws RemoteException;

    public void playSoundEffectVolume(int var1, float var2) throws RemoteException;

    public boolean loadSoundEffects() throws RemoteException;

    public void unloadSoundEffects() throws RemoteException;

    public void reloadAudioSettings() throws RemoteException;

    public Map getSurroundFormats() throws RemoteException;

    public List getReportedSurroundFormats() throws RemoteException;

    public boolean setSurroundFormatEnabled(int var1, boolean var2) throws RemoteException;

    public boolean isSurroundFormatEnabled(int var1) throws RemoteException;

    public boolean setEncodedSurroundMode(int var1) throws RemoteException;

    public int getEncodedSurroundMode(int var1) throws RemoteException;

    public void setSpeakerphoneOn(IBinder var1, boolean var2) throws RemoteException;

    public boolean isSpeakerphoneOn() throws RemoteException;

    public void setBluetoothScoOn(boolean var1) throws RemoteException;

    public boolean isBluetoothScoOn() throws RemoteException;

    public void setBluetoothA2dpOn(boolean var1) throws RemoteException;

    public boolean isBluetoothA2dpOn() throws RemoteException;

    public int requestAudioFocus(AudioAttributes var1, int var2, IBinder var3, IAudioFocusDispatcher var4, String var5, String var6, String var7, int var8, IAudioPolicyCallback var9, int var10) throws RemoteException;

    public int abandonAudioFocus(IAudioFocusDispatcher var1, String var2, AudioAttributes var3, String var4) throws RemoteException;

    public void unregisterAudioFocusClient(String var1) throws RemoteException;

    public int getCurrentAudioFocus() throws RemoteException;

    public void startBluetoothSco(IBinder var1, int var2) throws RemoteException;

    public void startBluetoothScoVirtualCall(IBinder var1) throws RemoteException;

    public void stopBluetoothSco(IBinder var1) throws RemoteException;

    public void forceVolumeControlStream(int var1, IBinder var2) throws RemoteException;

    public void setRingtonePlayer(IRingtonePlayer var1) throws RemoteException;

    public IRingtonePlayer getRingtonePlayer() throws RemoteException;

    public int getUiSoundsStreamType() throws RemoteException;

    public void setWiredDeviceConnectionState(AudioDeviceAttributes var1, int var2, String var3) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/media/java/android/media/IAudioService.aidl:225:1:225:25")
    public AudioRoutesInfo startWatchingRoutes(IAudioRoutesObserver var1) throws RemoteException;

    public boolean isCameraSoundForced() throws RemoteException;

    public void setVolumeController(IVolumeController var1) throws RemoteException;

    public void notifyVolumeControllerVisible(IVolumeController var1, boolean var2) throws RemoteException;

    public boolean isStreamAffectedByRingerMode(int var1) throws RemoteException;

    public boolean isStreamAffectedByMute(int var1) throws RemoteException;

    public void disableSafeMediaVolume(String var1) throws RemoteException;

    public int setHdmiSystemAudioSupported(boolean var1) throws RemoteException;

    public boolean isHdmiSystemAudioSupported() throws RemoteException;

    public String registerAudioPolicy(AudioPolicyConfig var1, IAudioPolicyCallback var2, boolean var3, boolean var4, boolean var5, boolean var6, IMediaProjection var7) throws RemoteException;

    public void unregisterAudioPolicyAsync(IAudioPolicyCallback var1) throws RemoteException;

    public void unregisterAudioPolicy(IAudioPolicyCallback var1) throws RemoteException;

    public int addMixForPolicy(AudioPolicyConfig var1, IAudioPolicyCallback var2) throws RemoteException;

    public int removeMixForPolicy(AudioPolicyConfig var1, IAudioPolicyCallback var2) throws RemoteException;

    public int setFocusPropertiesForPolicy(int var1, IAudioPolicyCallback var2) throws RemoteException;

    public void setVolumePolicy(VolumePolicy var1) throws RemoteException;

    public boolean hasRegisteredDynamicPolicy() throws RemoteException;

    public void registerRecordingCallback(IRecordingConfigDispatcher var1) throws RemoteException;

    public void unregisterRecordingCallback(IRecordingConfigDispatcher var1) throws RemoteException;

    public List<AudioRecordingConfiguration> getActiveRecordingConfigurations() throws RemoteException;

    public void registerPlaybackCallback(IPlaybackConfigDispatcher var1) throws RemoteException;

    public void unregisterPlaybackCallback(IPlaybackConfigDispatcher var1) throws RemoteException;

    public List<AudioPlaybackConfiguration> getActivePlaybackConfigurations() throws RemoteException;

    public int getFocusRampTimeMs(int var1, AudioAttributes var2) throws RemoteException;

    public int dispatchFocusChange(AudioFocusInfo var1, int var2, IAudioPolicyCallback var3) throws RemoteException;

    public void playerHasOpPlayAudio(int var1, boolean var2) throws RemoteException;

    public void handleBluetoothActiveDeviceChanged(BluetoothDevice var1, BluetoothDevice var2, BluetoothProfileConnectionInfo var3) throws RemoteException;

    public void setFocusRequestResultFromExtPolicy(AudioFocusInfo var1, int var2, IAudioPolicyCallback var3) throws RemoteException;

    public void registerAudioServerStateDispatcher(IAudioServerStateDispatcher var1) throws RemoteException;

    public void unregisterAudioServerStateDispatcher(IAudioServerStateDispatcher var1) throws RemoteException;

    public boolean isAudioServerRunning() throws RemoteException;

    public int setUidDeviceAffinity(IAudioPolicyCallback var1, int var2, int[] var3, String[] var4) throws RemoteException;

    public int removeUidDeviceAffinity(IAudioPolicyCallback var1, int var2) throws RemoteException;

    public int setUserIdDeviceAffinity(IAudioPolicyCallback var1, int var2, int[] var3, String[] var4) throws RemoteException;

    public int removeUserIdDeviceAffinity(IAudioPolicyCallback var1, int var2) throws RemoteException;

    public boolean hasHapticChannels(Uri var1) throws RemoteException;

    public boolean isCallScreeningModeSupported() throws RemoteException;

    public int setPreferredDevicesForStrategy(int var1, List<AudioDeviceAttributes> var2) throws RemoteException;

    public int removePreferredDevicesForStrategy(int var1) throws RemoteException;

    public List<AudioDeviceAttributes> getPreferredDevicesForStrategy(int var1) throws RemoteException;

    public List<AudioDeviceAttributes> getDevicesForAttributes(AudioAttributes var1) throws RemoteException;

    public List<AudioDeviceAttributes> getDevicesForAttributesUnprotected(AudioAttributes var1) throws RemoteException;

    public int setAllowedCapturePolicy(int var1) throws RemoteException;

    public int getAllowedCapturePolicy() throws RemoteException;

    public void registerStrategyPreferredDevicesDispatcher(IStrategyPreferredDevicesDispatcher var1) throws RemoteException;

    public void unregisterStrategyPreferredDevicesDispatcher(IStrategyPreferredDevicesDispatcher var1) throws RemoteException;

    public void setRttEnabled(boolean var1) throws RemoteException;

    public void setDeviceVolumeBehavior(AudioDeviceAttributes var1, int var2, String var3) throws RemoteException;

    public int getDeviceVolumeBehavior(AudioDeviceAttributes var1) throws RemoteException;

    public void setMultiAudioFocusEnabled(boolean var1) throws RemoteException;

    public int setPreferredDevicesForCapturePreset(int var1, List<AudioDeviceAttributes> var2) throws RemoteException;

    public int clearPreferredDevicesForCapturePreset(int var1) throws RemoteException;

    public List<AudioDeviceAttributes> getPreferredDevicesForCapturePreset(int var1) throws RemoteException;

    public void registerCapturePresetDevicesRoleDispatcher(ICapturePresetDevicesRoleDispatcher var1) throws RemoteException;

    public void unregisterCapturePresetDevicesRoleDispatcher(ICapturePresetDevicesRoleDispatcher var1) throws RemoteException;

    public void adjustStreamVolumeForUid(int var1, int var2, int var3, String var4, int var5, int var6, UserHandle var7, int var8) throws RemoteException;

    public void adjustSuggestedStreamVolumeForUid(int var1, int var2, int var3, String var4, int var5, int var6, UserHandle var7, int var8) throws RemoteException;

    public void setStreamVolumeForUid(int var1, int var2, int var3, String var4, int var5, int var6, UserHandle var7, int var8) throws RemoteException;

    public boolean isMusicActive(boolean var1) throws RemoteException;

    public int getDeviceMaskForStream(int var1) throws RemoteException;

    public int[] getAvailableCommunicationDeviceIds() throws RemoteException;

    public boolean setCommunicationDevice(IBinder var1, int var2) throws RemoteException;

    public int getCommunicationDevice() throws RemoteException;

    public void registerCommunicationDeviceDispatcher(ICommunicationDeviceDispatcher var1) throws RemoteException;

    public void unregisterCommunicationDeviceDispatcher(ICommunicationDeviceDispatcher var1) throws RemoteException;

    public boolean areNavigationRepeatSoundEffectsEnabled() throws RemoteException;

    public void setNavigationRepeatSoundEffectsEnabled(boolean var1) throws RemoteException;

    public boolean isHomeSoundEffectEnabled() throws RemoteException;

    public void setHomeSoundEffectEnabled(boolean var1) throws RemoteException;

    public boolean setAdditionalOutputDeviceDelay(AudioDeviceAttributes var1, long var2) throws RemoteException;

    public long getAdditionalOutputDeviceDelay(AudioDeviceAttributes var1) throws RemoteException;

    public long getMaxAdditionalOutputDeviceDelay(AudioDeviceAttributes var1) throws RemoteException;

    public int requestAudioFocusForTest(AudioAttributes var1, int var2, IBinder var3, IAudioFocusDispatcher var4, String var5, String var6, int var7, int var8, int var9) throws RemoteException;

    public int abandonAudioFocusForTest(IAudioFocusDispatcher var1, String var2, AudioAttributes var3, String var4) throws RemoteException;

    public long getFadeOutDurationOnFocusLossMillis(AudioAttributes var1) throws RemoteException;

    public void registerModeDispatcher(IAudioModeDispatcher var1) throws RemoteException;

    public void unregisterModeDispatcher(IAudioModeDispatcher var1) throws RemoteException;

    public int getSpatializerImmersiveAudioLevel() throws RemoteException;

    public boolean isSpatializerEnabled() throws RemoteException;

    public boolean isSpatializerAvailable() throws RemoteException;

    public boolean isSpatializerAvailableForDevice(AudioDeviceAttributes var1) throws RemoteException;

    public boolean hasHeadTracker(AudioDeviceAttributes var1) throws RemoteException;

    public void setHeadTrackerEnabled(boolean var1, AudioDeviceAttributes var2) throws RemoteException;

    public boolean isHeadTrackerEnabled(AudioDeviceAttributes var1) throws RemoteException;

    public boolean isHeadTrackerAvailable() throws RemoteException;

    public void registerSpatializerHeadTrackerAvailableCallback(ISpatializerHeadTrackerAvailableCallback var1, boolean var2) throws RemoteException;

    public void setSpatializerEnabled(boolean var1) throws RemoteException;

    public boolean canBeSpatialized(AudioAttributes var1, AudioFormat var2) throws RemoteException;

    public void registerSpatializerCallback(ISpatializerCallback var1) throws RemoteException;

    public void unregisterSpatializerCallback(ISpatializerCallback var1) throws RemoteException;

    public void registerSpatializerHeadTrackingCallback(ISpatializerHeadTrackingModeCallback var1) throws RemoteException;

    public void unregisterSpatializerHeadTrackingCallback(ISpatializerHeadTrackingModeCallback var1) throws RemoteException;

    public void registerHeadToSoundstagePoseCallback(ISpatializerHeadToSoundStagePoseCallback var1) throws RemoteException;

    public void unregisterHeadToSoundstagePoseCallback(ISpatializerHeadToSoundStagePoseCallback var1) throws RemoteException;

    public List<AudioDeviceAttributes> getSpatializerCompatibleAudioDevices() throws RemoteException;

    public void addSpatializerCompatibleAudioDevice(AudioDeviceAttributes var1) throws RemoteException;

    public void removeSpatializerCompatibleAudioDevice(AudioDeviceAttributes var1) throws RemoteException;

    public void setDesiredHeadTrackingMode(int var1) throws RemoteException;

    public int getDesiredHeadTrackingMode() throws RemoteException;

    public int[] getSupportedHeadTrackingModes() throws RemoteException;

    public int getActualHeadTrackingMode() throws RemoteException;

    public void setSpatializerGlobalTransform(float[] var1) throws RemoteException;

    public void recenterHeadTracker() throws RemoteException;

    public void setSpatializerParameter(int var1, byte[] var2) throws RemoteException;

    public void getSpatializerParameter(int var1, byte[] var2) throws RemoteException;

    public int getSpatializerOutput() throws RemoteException;

    public void registerSpatializerOutputCallback(ISpatializerOutputCallback var1) throws RemoteException;

    public void unregisterSpatializerOutputCallback(ISpatializerOutputCallback var1) throws RemoteException;

    public boolean isVolumeFixed() throws RemoteException;

    public VolumeInfo getDefaultVolumeInfo() throws RemoteException;

    public boolean isPstnCallAudioInterceptable() throws RemoteException;

    public void muteAwaitConnection(int[] var1, AudioDeviceAttributes var2, long var3) throws RemoteException;

    public void cancelMuteAwaitConnection(AudioDeviceAttributes var1) throws RemoteException;

    public AudioDeviceAttributes getMutingExpectedDevice() throws RemoteException;

    public void registerMuteAwaitConnectionDispatcher(IMuteAwaitConnectionCallback var1, boolean var2) throws RemoteException;

    public void setTestDeviceConnectionState(AudioDeviceAttributes var1, boolean var2) throws RemoteException;

    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.QUERY_AUDIO_STATE"})
    public void registerDeviceVolumeBehaviorDispatcher(boolean var1, IDeviceVolumeBehaviorDispatcher var2) throws RemoteException;

    public List<AudioFocusInfo> getFocusStack() throws RemoteException;

    public boolean sendFocusLoss(AudioFocusInfo var1, IAudioPolicyCallback var2) throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public void addAssistantServicesUids(int[] var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public void removeAssistantServicesUids(int[] var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public void setActiveAssistantServiceUids(int[] var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public int[] getAssistantServicesUids() throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public int[] getActiveAssistantServiceUids() throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public void registerDeviceVolumeDispatcherForAbsoluteVolume(boolean var1, IAudioDeviceVolumeDispatcher var2, String var3, AudioDeviceAttributes var4, List<VolumeInfo> var5, boolean var6) throws RemoteException;

    public String getHalVersion() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAudioService {
        public static final String DESCRIPTOR = "android.media.IAudioService";
        static final int TRANSACTION_trackPlayer = 1;
        static final int TRANSACTION_playerAttributes = 2;
        static final int TRANSACTION_playerEvent = 3;
        static final int TRANSACTION_releasePlayer = 4;
        static final int TRANSACTION_trackRecorder = 5;
        static final int TRANSACTION_recorderEvent = 6;
        static final int TRANSACTION_releaseRecorder = 7;
        static final int TRANSACTION_playerSessionId = 8;
        static final int TRANSACTION_adjustStreamVolume = 9;
        static final int TRANSACTION_adjustStreamVolumeWithAttribution = 10;
        static final int TRANSACTION_setStreamVolume = 11;
        static final int TRANSACTION_setStreamVolumeWithAttribution = 12;
        static final int TRANSACTION_handleVolumeKey = 13;
        static final int TRANSACTION_isStreamMute = 14;
        static final int TRANSACTION_forceRemoteSubmixFullVolume = 15;
        static final int TRANSACTION_isMasterMute = 16;
        static final int TRANSACTION_setMasterMute = 17;
        static final int TRANSACTION_getStreamVolume = 18;
        static final int TRANSACTION_getStreamMinVolume = 19;
        static final int TRANSACTION_getStreamMaxVolume = 20;
        static final int TRANSACTION_getAudioVolumeGroups = 21;
        static final int TRANSACTION_setVolumeIndexForAttributes = 22;
        static final int TRANSACTION_getVolumeIndexForAttributes = 23;
        static final int TRANSACTION_getMaxVolumeIndexForAttributes = 24;
        static final int TRANSACTION_getMinVolumeIndexForAttributes = 25;
        static final int TRANSACTION_getLastAudibleStreamVolume = 26;
        static final int TRANSACTION_setSupportedSystemUsages = 27;
        static final int TRANSACTION_getSupportedSystemUsages = 28;
        static final int TRANSACTION_getAudioProductStrategies = 29;
        static final int TRANSACTION_isMicrophoneMuted = 30;
        static final int TRANSACTION_isUltrasoundSupported = 31;
        static final int TRANSACTION_setMicrophoneMute = 32;
        static final int TRANSACTION_setMicrophoneMuteFromSwitch = 33;
        static final int TRANSACTION_setRingerModeExternal = 34;
        static final int TRANSACTION_setRingerModeInternal = 35;
        static final int TRANSACTION_getRingerModeExternal = 36;
        static final int TRANSACTION_getRingerModeInternal = 37;
        static final int TRANSACTION_isValidRingerMode = 38;
        static final int TRANSACTION_setVibrateSetting = 39;
        static final int TRANSACTION_getVibrateSetting = 40;
        static final int TRANSACTION_shouldVibrate = 41;
        static final int TRANSACTION_setMode = 42;
        static final int TRANSACTION_getMode = 43;
        static final int TRANSACTION_playSoundEffect = 44;
        static final int TRANSACTION_playSoundEffectVolume = 45;
        static final int TRANSACTION_loadSoundEffects = 46;
        static final int TRANSACTION_unloadSoundEffects = 47;
        static final int TRANSACTION_reloadAudioSettings = 48;
        static final int TRANSACTION_getSurroundFormats = 49;
        static final int TRANSACTION_getReportedSurroundFormats = 50;
        static final int TRANSACTION_setSurroundFormatEnabled = 51;
        static final int TRANSACTION_isSurroundFormatEnabled = 52;
        static final int TRANSACTION_setEncodedSurroundMode = 53;
        static final int TRANSACTION_getEncodedSurroundMode = 54;
        static final int TRANSACTION_setSpeakerphoneOn = 55;
        static final int TRANSACTION_isSpeakerphoneOn = 56;
        static final int TRANSACTION_setBluetoothScoOn = 57;
        static final int TRANSACTION_isBluetoothScoOn = 58;
        static final int TRANSACTION_setBluetoothA2dpOn = 59;
        static final int TRANSACTION_isBluetoothA2dpOn = 60;
        static final int TRANSACTION_requestAudioFocus = 61;
        static final int TRANSACTION_abandonAudioFocus = 62;
        static final int TRANSACTION_unregisterAudioFocusClient = 63;
        static final int TRANSACTION_getCurrentAudioFocus = 64;
        static final int TRANSACTION_startBluetoothSco = 65;
        static final int TRANSACTION_startBluetoothScoVirtualCall = 66;
        static final int TRANSACTION_stopBluetoothSco = 67;
        static final int TRANSACTION_forceVolumeControlStream = 68;
        static final int TRANSACTION_setRingtonePlayer = 69;
        static final int TRANSACTION_getRingtonePlayer = 70;
        static final int TRANSACTION_getUiSoundsStreamType = 71;
        static final int TRANSACTION_setWiredDeviceConnectionState = 72;
        static final int TRANSACTION_startWatchingRoutes = 73;
        static final int TRANSACTION_isCameraSoundForced = 74;
        static final int TRANSACTION_setVolumeController = 75;
        static final int TRANSACTION_notifyVolumeControllerVisible = 76;
        static final int TRANSACTION_isStreamAffectedByRingerMode = 77;
        static final int TRANSACTION_isStreamAffectedByMute = 78;
        static final int TRANSACTION_disableSafeMediaVolume = 79;
        static final int TRANSACTION_setHdmiSystemAudioSupported = 80;
        static final int TRANSACTION_isHdmiSystemAudioSupported = 81;
        static final int TRANSACTION_registerAudioPolicy = 82;
        static final int TRANSACTION_unregisterAudioPolicyAsync = 83;
        static final int TRANSACTION_unregisterAudioPolicy = 84;
        static final int TRANSACTION_addMixForPolicy = 85;
        static final int TRANSACTION_removeMixForPolicy = 86;
        static final int TRANSACTION_setFocusPropertiesForPolicy = 87;
        static final int TRANSACTION_setVolumePolicy = 88;
        static final int TRANSACTION_hasRegisteredDynamicPolicy = 89;
        static final int TRANSACTION_registerRecordingCallback = 90;
        static final int TRANSACTION_unregisterRecordingCallback = 91;
        static final int TRANSACTION_getActiveRecordingConfigurations = 92;
        static final int TRANSACTION_registerPlaybackCallback = 93;
        static final int TRANSACTION_unregisterPlaybackCallback = 94;
        static final int TRANSACTION_getActivePlaybackConfigurations = 95;
        static final int TRANSACTION_getFocusRampTimeMs = 96;
        static final int TRANSACTION_dispatchFocusChange = 97;
        static final int TRANSACTION_playerHasOpPlayAudio = 98;
        static final int TRANSACTION_handleBluetoothActiveDeviceChanged = 99;
        static final int TRANSACTION_setFocusRequestResultFromExtPolicy = 100;
        static final int TRANSACTION_registerAudioServerStateDispatcher = 101;
        static final int TRANSACTION_unregisterAudioServerStateDispatcher = 102;
        static final int TRANSACTION_isAudioServerRunning = 103;
        static final int TRANSACTION_setUidDeviceAffinity = 104;
        static final int TRANSACTION_removeUidDeviceAffinity = 105;
        static final int TRANSACTION_setUserIdDeviceAffinity = 106;
        static final int TRANSACTION_removeUserIdDeviceAffinity = 107;
        static final int TRANSACTION_hasHapticChannels = 108;
        static final int TRANSACTION_isCallScreeningModeSupported = 109;
        static final int TRANSACTION_setPreferredDevicesForStrategy = 110;
        static final int TRANSACTION_removePreferredDevicesForStrategy = 111;
        static final int TRANSACTION_getPreferredDevicesForStrategy = 112;
        static final int TRANSACTION_getDevicesForAttributes = 113;
        static final int TRANSACTION_getDevicesForAttributesUnprotected = 114;
        static final int TRANSACTION_setAllowedCapturePolicy = 115;
        static final int TRANSACTION_getAllowedCapturePolicy = 116;
        static final int TRANSACTION_registerStrategyPreferredDevicesDispatcher = 117;
        static final int TRANSACTION_unregisterStrategyPreferredDevicesDispatcher = 118;
        static final int TRANSACTION_setRttEnabled = 119;
        static final int TRANSACTION_setDeviceVolumeBehavior = 120;
        static final int TRANSACTION_getDeviceVolumeBehavior = 121;
        static final int TRANSACTION_setMultiAudioFocusEnabled = 122;
        static final int TRANSACTION_setPreferredDevicesForCapturePreset = 123;
        static final int TRANSACTION_clearPreferredDevicesForCapturePreset = 124;
        static final int TRANSACTION_getPreferredDevicesForCapturePreset = 125;
        static final int TRANSACTION_registerCapturePresetDevicesRoleDispatcher = 126;
        static final int TRANSACTION_unregisterCapturePresetDevicesRoleDispatcher = 127;
        static final int TRANSACTION_adjustStreamVolumeForUid = 128;
        static final int TRANSACTION_adjustSuggestedStreamVolumeForUid = 129;
        static final int TRANSACTION_setStreamVolumeForUid = 130;
        static final int TRANSACTION_isMusicActive = 131;
        static final int TRANSACTION_getDeviceMaskForStream = 132;
        static final int TRANSACTION_getAvailableCommunicationDeviceIds = 133;
        static final int TRANSACTION_setCommunicationDevice = 134;
        static final int TRANSACTION_getCommunicationDevice = 135;
        static final int TRANSACTION_registerCommunicationDeviceDispatcher = 136;
        static final int TRANSACTION_unregisterCommunicationDeviceDispatcher = 137;
        static final int TRANSACTION_areNavigationRepeatSoundEffectsEnabled = 138;
        static final int TRANSACTION_setNavigationRepeatSoundEffectsEnabled = 139;
        static final int TRANSACTION_isHomeSoundEffectEnabled = 140;
        static final int TRANSACTION_setHomeSoundEffectEnabled = 141;
        static final int TRANSACTION_setAdditionalOutputDeviceDelay = 142;
        static final int TRANSACTION_getAdditionalOutputDeviceDelay = 143;
        static final int TRANSACTION_getMaxAdditionalOutputDeviceDelay = 144;
        static final int TRANSACTION_requestAudioFocusForTest = 145;
        static final int TRANSACTION_abandonAudioFocusForTest = 146;
        static final int TRANSACTION_getFadeOutDurationOnFocusLossMillis = 147;
        static final int TRANSACTION_registerModeDispatcher = 148;
        static final int TRANSACTION_unregisterModeDispatcher = 149;
        static final int TRANSACTION_getSpatializerImmersiveAudioLevel = 150;
        static final int TRANSACTION_isSpatializerEnabled = 151;
        static final int TRANSACTION_isSpatializerAvailable = 152;
        static final int TRANSACTION_isSpatializerAvailableForDevice = 153;
        static final int TRANSACTION_hasHeadTracker = 154;
        static final int TRANSACTION_setHeadTrackerEnabled = 155;
        static final int TRANSACTION_isHeadTrackerEnabled = 156;
        static final int TRANSACTION_isHeadTrackerAvailable = 157;
        static final int TRANSACTION_registerSpatializerHeadTrackerAvailableCallback = 158;
        static final int TRANSACTION_setSpatializerEnabled = 159;
        static final int TRANSACTION_canBeSpatialized = 160;
        static final int TRANSACTION_registerSpatializerCallback = 161;
        static final int TRANSACTION_unregisterSpatializerCallback = 162;
        static final int TRANSACTION_registerSpatializerHeadTrackingCallback = 163;
        static final int TRANSACTION_unregisterSpatializerHeadTrackingCallback = 164;
        static final int TRANSACTION_registerHeadToSoundstagePoseCallback = 165;
        static final int TRANSACTION_unregisterHeadToSoundstagePoseCallback = 166;
        static final int TRANSACTION_getSpatializerCompatibleAudioDevices = 167;
        static final int TRANSACTION_addSpatializerCompatibleAudioDevice = 168;
        static final int TRANSACTION_removeSpatializerCompatibleAudioDevice = 169;
        static final int TRANSACTION_setDesiredHeadTrackingMode = 170;
        static final int TRANSACTION_getDesiredHeadTrackingMode = 171;
        static final int TRANSACTION_getSupportedHeadTrackingModes = 172;
        static final int TRANSACTION_getActualHeadTrackingMode = 173;
        static final int TRANSACTION_setSpatializerGlobalTransform = 174;
        static final int TRANSACTION_recenterHeadTracker = 175;
        static final int TRANSACTION_setSpatializerParameter = 176;
        static final int TRANSACTION_getSpatializerParameter = 177;
        static final int TRANSACTION_getSpatializerOutput = 178;
        static final int TRANSACTION_registerSpatializerOutputCallback = 179;
        static final int TRANSACTION_unregisterSpatializerOutputCallback = 180;
        static final int TRANSACTION_isVolumeFixed = 181;
        static final int TRANSACTION_getDefaultVolumeInfo = 182;
        static final int TRANSACTION_isPstnCallAudioInterceptable = 183;
        static final int TRANSACTION_muteAwaitConnection = 184;
        static final int TRANSACTION_cancelMuteAwaitConnection = 185;
        static final int TRANSACTION_getMutingExpectedDevice = 186;
        static final int TRANSACTION_registerMuteAwaitConnectionDispatcher = 187;
        static final int TRANSACTION_setTestDeviceConnectionState = 188;
        static final int TRANSACTION_registerDeviceVolumeBehaviorDispatcher = 189;
        static final int TRANSACTION_getFocusStack = 190;
        static final int TRANSACTION_sendFocusLoss = 191;
        static final int TRANSACTION_addAssistantServicesUids = 192;
        static final int TRANSACTION_removeAssistantServicesUids = 193;
        static final int TRANSACTION_setActiveAssistantServiceUids = 194;
        static final int TRANSACTION_getAssistantServicesUids = 195;
        static final int TRANSACTION_getActiveAssistantServiceUids = 196;
        static final int TRANSACTION_registerDeviceVolumeDispatcherForAbsoluteVolume = 197;
        static final int TRANSACTION_getHalVersion = 198;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IAudioService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IAudioService) {
                return (IAudioService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "trackPlayer";
                }
                case 2: {
                    return "playerAttributes";
                }
                case 3: {
                    return "playerEvent";
                }
                case 4: {
                    return "releasePlayer";
                }
                case 5: {
                    return "trackRecorder";
                }
                case 6: {
                    return "recorderEvent";
                }
                case 7: {
                    return "releaseRecorder";
                }
                case 8: {
                    return "playerSessionId";
                }
                case 9: {
                    return "adjustStreamVolume";
                }
                case 10: {
                    return "adjustStreamVolumeWithAttribution";
                }
                case 11: {
                    return "setStreamVolume";
                }
                case 12: {
                    return "setStreamVolumeWithAttribution";
                }
                case 13: {
                    return "handleVolumeKey";
                }
                case 14: {
                    return "isStreamMute";
                }
                case 15: {
                    return "forceRemoteSubmixFullVolume";
                }
                case 16: {
                    return "isMasterMute";
                }
                case 17: {
                    return "setMasterMute";
                }
                case 18: {
                    return "getStreamVolume";
                }
                case 19: {
                    return "getStreamMinVolume";
                }
                case 20: {
                    return "getStreamMaxVolume";
                }
                case 21: {
                    return "getAudioVolumeGroups";
                }
                case 22: {
                    return "setVolumeIndexForAttributes";
                }
                case 23: {
                    return "getVolumeIndexForAttributes";
                }
                case 24: {
                    return "getMaxVolumeIndexForAttributes";
                }
                case 25: {
                    return "getMinVolumeIndexForAttributes";
                }
                case 26: {
                    return "getLastAudibleStreamVolume";
                }
                case 27: {
                    return "setSupportedSystemUsages";
                }
                case 28: {
                    return "getSupportedSystemUsages";
                }
                case 29: {
                    return "getAudioProductStrategies";
                }
                case 30: {
                    return "isMicrophoneMuted";
                }
                case 31: {
                    return "isUltrasoundSupported";
                }
                case 32: {
                    return "setMicrophoneMute";
                }
                case 33: {
                    return "setMicrophoneMuteFromSwitch";
                }
                case 34: {
                    return "setRingerModeExternal";
                }
                case 35: {
                    return "setRingerModeInternal";
                }
                case 36: {
                    return "getRingerModeExternal";
                }
                case 37: {
                    return "getRingerModeInternal";
                }
                case 38: {
                    return "isValidRingerMode";
                }
                case 39: {
                    return "setVibrateSetting";
                }
                case 40: {
                    return "getVibrateSetting";
                }
                case 41: {
                    return "shouldVibrate";
                }
                case 42: {
                    return "setMode";
                }
                case 43: {
                    return "getMode";
                }
                case 44: {
                    return "playSoundEffect";
                }
                case 45: {
                    return "playSoundEffectVolume";
                }
                case 46: {
                    return "loadSoundEffects";
                }
                case 47: {
                    return "unloadSoundEffects";
                }
                case 48: {
                    return "reloadAudioSettings";
                }
                case 49: {
                    return "getSurroundFormats";
                }
                case 50: {
                    return "getReportedSurroundFormats";
                }
                case 51: {
                    return "setSurroundFormatEnabled";
                }
                case 52: {
                    return "isSurroundFormatEnabled";
                }
                case 53: {
                    return "setEncodedSurroundMode";
                }
                case 54: {
                    return "getEncodedSurroundMode";
                }
                case 55: {
                    return "setSpeakerphoneOn";
                }
                case 56: {
                    return "isSpeakerphoneOn";
                }
                case 57: {
                    return "setBluetoothScoOn";
                }
                case 58: {
                    return "isBluetoothScoOn";
                }
                case 59: {
                    return "setBluetoothA2dpOn";
                }
                case 60: {
                    return "isBluetoothA2dpOn";
                }
                case 61: {
                    return "requestAudioFocus";
                }
                case 62: {
                    return "abandonAudioFocus";
                }
                case 63: {
                    return "unregisterAudioFocusClient";
                }
                case 64: {
                    return "getCurrentAudioFocus";
                }
                case 65: {
                    return "startBluetoothSco";
                }
                case 66: {
                    return "startBluetoothScoVirtualCall";
                }
                case 67: {
                    return "stopBluetoothSco";
                }
                case 68: {
                    return "forceVolumeControlStream";
                }
                case 69: {
                    return "setRingtonePlayer";
                }
                case 70: {
                    return "getRingtonePlayer";
                }
                case 71: {
                    return "getUiSoundsStreamType";
                }
                case 72: {
                    return "setWiredDeviceConnectionState";
                }
                case 73: {
                    return "startWatchingRoutes";
                }
                case 74: {
                    return "isCameraSoundForced";
                }
                case 75: {
                    return "setVolumeController";
                }
                case 76: {
                    return "notifyVolumeControllerVisible";
                }
                case 77: {
                    return "isStreamAffectedByRingerMode";
                }
                case 78: {
                    return "isStreamAffectedByMute";
                }
                case 79: {
                    return "disableSafeMediaVolume";
                }
                case 80: {
                    return "setHdmiSystemAudioSupported";
                }
                case 81: {
                    return "isHdmiSystemAudioSupported";
                }
                case 82: {
                    return "registerAudioPolicy";
                }
                case 83: {
                    return "unregisterAudioPolicyAsync";
                }
                case 84: {
                    return "unregisterAudioPolicy";
                }
                case 85: {
                    return "addMixForPolicy";
                }
                case 86: {
                    return "removeMixForPolicy";
                }
                case 87: {
                    return "setFocusPropertiesForPolicy";
                }
                case 88: {
                    return "setVolumePolicy";
                }
                case 89: {
                    return "hasRegisteredDynamicPolicy";
                }
                case 90: {
                    return "registerRecordingCallback";
                }
                case 91: {
                    return "unregisterRecordingCallback";
                }
                case 92: {
                    return "getActiveRecordingConfigurations";
                }
                case 93: {
                    return "registerPlaybackCallback";
                }
                case 94: {
                    return "unregisterPlaybackCallback";
                }
                case 95: {
                    return "getActivePlaybackConfigurations";
                }
                case 96: {
                    return "getFocusRampTimeMs";
                }
                case 97: {
                    return "dispatchFocusChange";
                }
                case 98: {
                    return "playerHasOpPlayAudio";
                }
                case 99: {
                    return "handleBluetoothActiveDeviceChanged";
                }
                case 100: {
                    return "setFocusRequestResultFromExtPolicy";
                }
                case 101: {
                    return "registerAudioServerStateDispatcher";
                }
                case 102: {
                    return "unregisterAudioServerStateDispatcher";
                }
                case 103: {
                    return "isAudioServerRunning";
                }
                case 104: {
                    return "setUidDeviceAffinity";
                }
                case 105: {
                    return "removeUidDeviceAffinity";
                }
                case 106: {
                    return "setUserIdDeviceAffinity";
                }
                case 107: {
                    return "removeUserIdDeviceAffinity";
                }
                case 108: {
                    return "hasHapticChannels";
                }
                case 109: {
                    return "isCallScreeningModeSupported";
                }
                case 110: {
                    return "setPreferredDevicesForStrategy";
                }
                case 111: {
                    return "removePreferredDevicesForStrategy";
                }
                case 112: {
                    return "getPreferredDevicesForStrategy";
                }
                case 113: {
                    return "getDevicesForAttributes";
                }
                case 114: {
                    return "getDevicesForAttributesUnprotected";
                }
                case 115: {
                    return "setAllowedCapturePolicy";
                }
                case 116: {
                    return "getAllowedCapturePolicy";
                }
                case 117: {
                    return "registerStrategyPreferredDevicesDispatcher";
                }
                case 118: {
                    return "unregisterStrategyPreferredDevicesDispatcher";
                }
                case 119: {
                    return "setRttEnabled";
                }
                case 120: {
                    return "setDeviceVolumeBehavior";
                }
                case 121: {
                    return "getDeviceVolumeBehavior";
                }
                case 122: {
                    return "setMultiAudioFocusEnabled";
                }
                case 123: {
                    return "setPreferredDevicesForCapturePreset";
                }
                case 124: {
                    return "clearPreferredDevicesForCapturePreset";
                }
                case 125: {
                    return "getPreferredDevicesForCapturePreset";
                }
                case 126: {
                    return "registerCapturePresetDevicesRoleDispatcher";
                }
                case 127: {
                    return "unregisterCapturePresetDevicesRoleDispatcher";
                }
                case 128: {
                    return "adjustStreamVolumeForUid";
                }
                case 129: {
                    return "adjustSuggestedStreamVolumeForUid";
                }
                case 130: {
                    return "setStreamVolumeForUid";
                }
                case 131: {
                    return "isMusicActive";
                }
                case 132: {
                    return "getDeviceMaskForStream";
                }
                case 133: {
                    return "getAvailableCommunicationDeviceIds";
                }
                case 134: {
                    return "setCommunicationDevice";
                }
                case 135: {
                    return "getCommunicationDevice";
                }
                case 136: {
                    return "registerCommunicationDeviceDispatcher";
                }
                case 137: {
                    return "unregisterCommunicationDeviceDispatcher";
                }
                case 138: {
                    return "areNavigationRepeatSoundEffectsEnabled";
                }
                case 139: {
                    return "setNavigationRepeatSoundEffectsEnabled";
                }
                case 140: {
                    return "isHomeSoundEffectEnabled";
                }
                case 141: {
                    return "setHomeSoundEffectEnabled";
                }
                case 142: {
                    return "setAdditionalOutputDeviceDelay";
                }
                case 143: {
                    return "getAdditionalOutputDeviceDelay";
                }
                case 144: {
                    return "getMaxAdditionalOutputDeviceDelay";
                }
                case 145: {
                    return "requestAudioFocusForTest";
                }
                case 146: {
                    return "abandonAudioFocusForTest";
                }
                case 147: {
                    return "getFadeOutDurationOnFocusLossMillis";
                }
                case 148: {
                    return "registerModeDispatcher";
                }
                case 149: {
                    return "unregisterModeDispatcher";
                }
                case 150: {
                    return "getSpatializerImmersiveAudioLevel";
                }
                case 151: {
                    return "isSpatializerEnabled";
                }
                case 152: {
                    return "isSpatializerAvailable";
                }
                case 153: {
                    return "isSpatializerAvailableForDevice";
                }
                case 154: {
                    return "hasHeadTracker";
                }
                case 155: {
                    return "setHeadTrackerEnabled";
                }
                case 156: {
                    return "isHeadTrackerEnabled";
                }
                case 157: {
                    return "isHeadTrackerAvailable";
                }
                case 158: {
                    return "registerSpatializerHeadTrackerAvailableCallback";
                }
                case 159: {
                    return "setSpatializerEnabled";
                }
                case 160: {
                    return "canBeSpatialized";
                }
                case 161: {
                    return "registerSpatializerCallback";
                }
                case 162: {
                    return "unregisterSpatializerCallback";
                }
                case 163: {
                    return "registerSpatializerHeadTrackingCallback";
                }
                case 164: {
                    return "unregisterSpatializerHeadTrackingCallback";
                }
                case 165: {
                    return "registerHeadToSoundstagePoseCallback";
                }
                case 166: {
                    return "unregisterHeadToSoundstagePoseCallback";
                }
                case 167: {
                    return "getSpatializerCompatibleAudioDevices";
                }
                case 168: {
                    return "addSpatializerCompatibleAudioDevice";
                }
                case 169: {
                    return "removeSpatializerCompatibleAudioDevice";
                }
                case 170: {
                    return "setDesiredHeadTrackingMode";
                }
                case 171: {
                    return "getDesiredHeadTrackingMode";
                }
                case 172: {
                    return "getSupportedHeadTrackingModes";
                }
                case 173: {
                    return "getActualHeadTrackingMode";
                }
                case 174: {
                    return "setSpatializerGlobalTransform";
                }
                case 175: {
                    return "recenterHeadTracker";
                }
                case 176: {
                    return "setSpatializerParameter";
                }
                case 177: {
                    return "getSpatializerParameter";
                }
                case 178: {
                    return "getSpatializerOutput";
                }
                case 179: {
                    return "registerSpatializerOutputCallback";
                }
                case 180: {
                    return "unregisterSpatializerOutputCallback";
                }
                case 181: {
                    return "isVolumeFixed";
                }
                case 182: {
                    return "getDefaultVolumeInfo";
                }
                case 183: {
                    return "isPstnCallAudioInterceptable";
                }
                case 184: {
                    return "muteAwaitConnection";
                }
                case 185: {
                    return "cancelMuteAwaitConnection";
                }
                case 186: {
                    return "getMutingExpectedDevice";
                }
                case 187: {
                    return "registerMuteAwaitConnectionDispatcher";
                }
                case 188: {
                    return "setTestDeviceConnectionState";
                }
                case 189: {
                    return "registerDeviceVolumeBehaviorDispatcher";
                }
                case 190: {
                    return "getFocusStack";
                }
                case 191: {
                    return "sendFocusLoss";
                }
                case 192: {
                    return "addAssistantServicesUids";
                }
                case 193: {
                    return "removeAssistantServicesUids";
                }
                case 194: {
                    return "setActiveAssistantServiceUids";
                }
                case 195: {
                    return "getAssistantServicesUids";
                }
                case 196: {
                    return "getActiveAssistantServiceUids";
                }
                case 197: {
                    return "registerDeviceVolumeDispatcherForAbsoluteVolume";
                }
                case 198: {
                    return "getHalVersion";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    PlayerBase.PlayerIdCard _arg0 = data.readTypedObject(PlayerBase.PlayerIdCard.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.trackPlayer(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    AudioAttributes _arg1 = data.readTypedObject(AudioAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    this.playerAttributes(_arg0, _arg1);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.playerEvent(_arg0, _arg1, _arg2);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.releasePlayer(_arg0);
                    break;
                }
                case 5: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    int _result = this.trackRecorder(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.recorderEvent(_arg0, _arg1);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.releaseRecorder(_arg0);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.playerSessionId(_arg0, _arg1);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.adjustStreamVolume(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.adjustStreamVolumeWithAttribution(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.setStreamVolume(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.setStreamVolumeWithAttribution(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    KeyEvent _arg0 = data.readTypedObject(KeyEvent.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.handleVolumeKey(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isStreamMute(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 15: {
                    boolean _arg0 = data.readBoolean();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.forceRemoteSubmixFullVolume(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    boolean _result = this.isMasterMute();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 17: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.setMasterMute(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getStreamVolume(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 19: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getStreamMinVolume(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 20: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getStreamMaxVolume(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 21: {
                    List<AudioVolumeGroup> _result = this.getAudioVolumeGroups();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 22: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.setVolumeIndexForAttributes(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getVolumeIndexForAttributes(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 24: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getMaxVolumeIndexForAttributes(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 25: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getMinVolumeIndexForAttributes(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 26: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getLastAudibleStreamVolume(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 27: {
                    int[] _arg0 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.setSupportedSystemUsages(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    int[] _result = this.getSupportedSystemUsages();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 29: {
                    List<AudioProductStrategy> _result = this.getAudioProductStrategies();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 30: {
                    boolean _result = this.isMicrophoneMuted();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 31: {
                    boolean _result = this.isUltrasoundSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 32: {
                    boolean _arg0 = data.readBoolean();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.setMicrophoneMute(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setMicrophoneMuteFromSwitch(_arg0);
                    break;
                }
                case 34: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.setRingerModeExternal(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.setRingerModeInternal(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    int _result = this.getRingerModeExternal();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 37: {
                    int _result = this.getRingerModeInternal();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 38: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isValidRingerMode(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 39: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setVibrateSetting(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 40: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getVibrateSetting(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 41: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.shouldVibrate(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 42: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.setMode(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 43: {
                    int _result = this.getMode();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 44: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.playSoundEffect(_arg0, _arg1);
                    break;
                }
                case 45: {
                    int _arg0 = data.readInt();
                    float _arg1 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.playSoundEffectVolume(_arg0, _arg1);
                    break;
                }
                case 46: {
                    boolean _result = this.loadSoundEffects();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 47: {
                    this.unloadSoundEffects();
                    break;
                }
                case 48: {
                    this.reloadAudioSettings();
                    break;
                }
                case 49: {
                    Map _result = this.getSurroundFormats();
                    reply.writeNoException();
                    reply.writeMap(_result);
                    break;
                }
                case 50: {
                    List _result = this.getReportedSurroundFormats();
                    reply.writeNoException();
                    reply.writeList(_result);
                    break;
                }
                case 51: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.setSurroundFormatEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 52: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isSurroundFormatEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 53: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.setEncodedSurroundMode(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 54: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getEncodedSurroundMode(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 55: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setSpeakerphoneOn(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 56: {
                    boolean _result = this.isSpeakerphoneOn();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 57: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setBluetoothScoOn(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 58: {
                    boolean _result = this.isBluetoothScoOn();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 59: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setBluetoothA2dpOn(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 60: {
                    boolean _result = this.isBluetoothA2dpOn();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 61: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    int _arg1 = data.readInt();
                    IBinder _arg2 = data.readStrongBinder();
                    IAudioFocusDispatcher _arg3 = IAudioFocusDispatcher.Stub.asInterface(data.readStrongBinder());
                    String _arg4 = data.readString();
                    String _arg5 = data.readString();
                    String _arg6 = data.readString();
                    int _arg7 = data.readInt();
                    IAudioPolicyCallback _arg8 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg9 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.requestAudioFocus(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 62: {
                    IAudioFocusDispatcher _arg0 = IAudioFocusDispatcher.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    AudioAttributes _arg2 = data.readTypedObject(AudioAttributes.CREATOR);
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.abandonAudioFocus(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 63: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.unregisterAudioFocusClient(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 64: {
                    int _result = this.getCurrentAudioFocus();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 65: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.startBluetoothSco(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 66: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.startBluetoothScoVirtualCall(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 67: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.stopBluetoothSco(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 68: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.forceVolumeControlStream(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 69: {
                    IRingtonePlayer _arg0 = IRingtonePlayer.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setRingtonePlayer(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 70: {
                    IRingtonePlayer _result = this.getRingtonePlayer();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 71: {
                    int _result = this.getUiSoundsStreamType();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 72: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.setWiredDeviceConnectionState(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 73: {
                    IAudioRoutesObserver _arg0 = IAudioRoutesObserver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    AudioRoutesInfo _result = this.startWatchingRoutes(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 74: {
                    boolean _result = this.isCameraSoundForced();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 75: {
                    IVolumeController _arg0 = IVolumeController.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setVolumeController(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 76: {
                    IVolumeController _arg0 = IVolumeController.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.notifyVolumeControllerVisible(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 77: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isStreamAffectedByRingerMode(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 78: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isStreamAffectedByMute(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 79: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.disableSafeMediaVolume(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 80: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    int _result = this.setHdmiSystemAudioSupported(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 81: {
                    boolean _result = this.isHdmiSystemAudioSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 82: {
                    AudioPolicyConfig _arg0 = data.readTypedObject(AudioPolicyConfig.CREATOR);
                    IAudioPolicyCallback _arg1 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    boolean _arg2 = data.readBoolean();
                    boolean _arg3 = data.readBoolean();
                    boolean _arg4 = data.readBoolean();
                    boolean _arg5 = data.readBoolean();
                    IMediaProjection _arg6 = IMediaProjection.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    String _result = this.registerAudioPolicy(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 83: {
                    IAudioPolicyCallback _arg0 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterAudioPolicyAsync(_arg0);
                    break;
                }
                case 84: {
                    IAudioPolicyCallback _arg0 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterAudioPolicy(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 85: {
                    AudioPolicyConfig _arg0 = data.readTypedObject(AudioPolicyConfig.CREATOR);
                    IAudioPolicyCallback _arg1 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.addMixForPolicy(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 86: {
                    AudioPolicyConfig _arg0 = data.readTypedObject(AudioPolicyConfig.CREATOR);
                    IAudioPolicyCallback _arg1 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.removeMixForPolicy(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 87: {
                    int _arg0 = data.readInt();
                    IAudioPolicyCallback _arg1 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.setFocusPropertiesForPolicy(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 88: {
                    VolumePolicy _arg0 = data.readTypedObject(VolumePolicy.CREATOR);
                    data.enforceNoDataAvail();
                    this.setVolumePolicy(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 89: {
                    boolean _result = this.hasRegisteredDynamicPolicy();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 90: {
                    IRecordingConfigDispatcher _arg0 = IRecordingConfigDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerRecordingCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 91: {
                    IRecordingConfigDispatcher _arg0 = IRecordingConfigDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterRecordingCallback(_arg0);
                    break;
                }
                case 92: {
                    List<AudioRecordingConfiguration> _result = this.getActiveRecordingConfigurations();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 93: {
                    IPlaybackConfigDispatcher _arg0 = IPlaybackConfigDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerPlaybackCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 94: {
                    IPlaybackConfigDispatcher _arg0 = IPlaybackConfigDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterPlaybackCallback(_arg0);
                    break;
                }
                case 95: {
                    List<AudioPlaybackConfiguration> _result = this.getActivePlaybackConfigurations();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 96: {
                    int _arg0 = data.readInt();
                    AudioAttributes _arg1 = data.readTypedObject(AudioAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getFocusRampTimeMs(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 97: {
                    AudioFocusInfo _arg0 = data.readTypedObject(AudioFocusInfo.CREATOR);
                    int _arg1 = data.readInt();
                    IAudioPolicyCallback _arg2 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.dispatchFocusChange(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 98: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.playerHasOpPlayAudio(_arg0, _arg1);
                    break;
                }
                case 99: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    BluetoothDevice _arg1 = data.readTypedObject(BluetoothDevice.CREATOR);
                    BluetoothProfileConnectionInfo _arg2 = data.readTypedObject(BluetoothProfileConnectionInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.handleBluetoothActiveDeviceChanged(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 100: {
                    AudioFocusInfo _arg0 = data.readTypedObject(AudioFocusInfo.CREATOR);
                    int _arg1 = data.readInt();
                    IAudioPolicyCallback _arg2 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setFocusRequestResultFromExtPolicy(_arg0, _arg1, _arg2);
                    break;
                }
                case 101: {
                    IAudioServerStateDispatcher _arg0 = IAudioServerStateDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerAudioServerStateDispatcher(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 102: {
                    IAudioServerStateDispatcher _arg0 = IAudioServerStateDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterAudioServerStateDispatcher(_arg0);
                    break;
                }
                case 103: {
                    boolean _result = this.isAudioServerRunning();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 104: {
                    IAudioPolicyCallback _arg0 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int[] _arg2 = data.createIntArray();
                    String[] _arg3 = data.createStringArray();
                    data.enforceNoDataAvail();
                    int _result = this.setUidDeviceAffinity(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 105: {
                    IAudioPolicyCallback _arg0 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.removeUidDeviceAffinity(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 106: {
                    IAudioPolicyCallback _arg0 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int[] _arg2 = data.createIntArray();
                    String[] _arg3 = data.createStringArray();
                    data.enforceNoDataAvail();
                    int _result = this.setUserIdDeviceAffinity(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 107: {
                    IAudioPolicyCallback _arg0 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.removeUserIdDeviceAffinity(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 108: {
                    Uri _arg0 = data.readTypedObject(Uri.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.hasHapticChannels(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 109: {
                    boolean _result = this.isCallScreeningModeSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 110: {
                    int _arg0 = data.readInt();
                    ArrayList<AudioDeviceAttributes> _arg1 = data.createTypedArrayList(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.setPreferredDevicesForStrategy(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 111: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.removePreferredDevicesForStrategy(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 112: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<AudioDeviceAttributes> _result = this.getPreferredDevicesForStrategy(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 113: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    List<AudioDeviceAttributes> _result = this.getDevicesForAttributes(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 114: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    List<AudioDeviceAttributes> _result = this.getDevicesForAttributesUnprotected(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 115: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.setAllowedCapturePolicy(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 116: {
                    int _result = this.getAllowedCapturePolicy();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 117: {
                    IStrategyPreferredDevicesDispatcher _arg0 = IStrategyPreferredDevicesDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerStrategyPreferredDevicesDispatcher(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 118: {
                    IStrategyPreferredDevicesDispatcher _arg0 = IStrategyPreferredDevicesDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterStrategyPreferredDevicesDispatcher(_arg0);
                    break;
                }
                case 119: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setRttEnabled(_arg0);
                    break;
                }
                case 120: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.setDeviceVolumeBehavior(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 121: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getDeviceVolumeBehavior(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 122: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setMultiAudioFocusEnabled(_arg0);
                    break;
                }
                case 123: {
                    int _arg0 = data.readInt();
                    ArrayList<AudioDeviceAttributes> _arg1 = data.createTypedArrayList(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.setPreferredDevicesForCapturePreset(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 124: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.clearPreferredDevicesForCapturePreset(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 125: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<AudioDeviceAttributes> _result = this.getPreferredDevicesForCapturePreset(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 126: {
                    ICapturePresetDevicesRoleDispatcher _arg0 = ICapturePresetDevicesRoleDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerCapturePresetDevicesRoleDispatcher(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 127: {
                    ICapturePresetDevicesRoleDispatcher _arg0 = ICapturePresetDevicesRoleDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterCapturePresetDevicesRoleDispatcher(_arg0);
                    break;
                }
                case 128: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    UserHandle _arg6 = data.readTypedObject(UserHandle.CREATOR);
                    int _arg7 = data.readInt();
                    data.enforceNoDataAvail();
                    this.adjustStreamVolumeForUid(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    break;
                }
                case 129: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    UserHandle _arg6 = data.readTypedObject(UserHandle.CREATOR);
                    int _arg7 = data.readInt();
                    data.enforceNoDataAvail();
                    this.adjustSuggestedStreamVolumeForUid(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    break;
                }
                case 130: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    UserHandle _arg6 = data.readTypedObject(UserHandle.CREATOR);
                    int _arg7 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setStreamVolumeForUid(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    break;
                }
                case 131: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.isMusicActive(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 132: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getDeviceMaskForStream(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 133: {
                    int[] _result = this.getAvailableCommunicationDeviceIds();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 134: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.setCommunicationDevice(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 135: {
                    int _result = this.getCommunicationDevice();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 136: {
                    ICommunicationDeviceDispatcher _arg0 = ICommunicationDeviceDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerCommunicationDeviceDispatcher(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 137: {
                    ICommunicationDeviceDispatcher _arg0 = ICommunicationDeviceDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterCommunicationDeviceDispatcher(_arg0);
                    break;
                }
                case 138: {
                    boolean _result = this.areNavigationRepeatSoundEffectsEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 139: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setNavigationRepeatSoundEffectsEnabled(_arg0);
                    break;
                }
                case 140: {
                    boolean _result = this.isHomeSoundEffectEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 141: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setHomeSoundEffectEnabled(_arg0);
                    break;
                }
                case 142: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    boolean _result = this.setAdditionalOutputDeviceDelay(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 143: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    long _result = this.getAdditionalOutputDeviceDelay(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 144: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    long _result = this.getMaxAdditionalOutputDeviceDelay(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 145: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    int _arg1 = data.readInt();
                    IBinder _arg2 = data.readStrongBinder();
                    IAudioFocusDispatcher _arg3 = IAudioFocusDispatcher.Stub.asInterface(data.readStrongBinder());
                    String _arg4 = data.readString();
                    String _arg5 = data.readString();
                    int _arg6 = data.readInt();
                    int _arg7 = data.readInt();
                    int _arg8 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.requestAudioFocusForTest(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 146: {
                    IAudioFocusDispatcher _arg0 = IAudioFocusDispatcher.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    AudioAttributes _arg2 = data.readTypedObject(AudioAttributes.CREATOR);
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.abandonAudioFocusForTest(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 147: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    long _result = this.getFadeOutDurationOnFocusLossMillis(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 148: {
                    IAudioModeDispatcher _arg0 = IAudioModeDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerModeDispatcher(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 149: {
                    IAudioModeDispatcher _arg0 = IAudioModeDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterModeDispatcher(_arg0);
                    break;
                }
                case 150: {
                    int _result = this.getSpatializerImmersiveAudioLevel();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 151: {
                    boolean _result = this.isSpatializerEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 152: {
                    boolean _result = this.isSpatializerAvailable();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 153: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isSpatializerAvailableForDevice(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 154: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.hasHeadTracker(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 155: {
                    boolean _arg0 = data.readBoolean();
                    AudioDeviceAttributes _arg1 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    this.setHeadTrackerEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 156: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isHeadTrackerEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 157: {
                    boolean _result = this.isHeadTrackerAvailable();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 158: {
                    ISpatializerHeadTrackerAvailableCallback _arg0 = ISpatializerHeadTrackerAvailableCallback.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.registerSpatializerHeadTrackerAvailableCallback(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 159: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setSpatializerEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 160: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    AudioFormat _arg1 = data.readTypedObject(AudioFormat.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.canBeSpatialized(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 161: {
                    ISpatializerCallback _arg0 = ISpatializerCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerSpatializerCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 162: {
                    ISpatializerCallback _arg0 = ISpatializerCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterSpatializerCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 163: {
                    ISpatializerHeadTrackingModeCallback _arg0 = ISpatializerHeadTrackingModeCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerSpatializerHeadTrackingCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 164: {
                    ISpatializerHeadTrackingModeCallback _arg0 = ISpatializerHeadTrackingModeCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterSpatializerHeadTrackingCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 165: {
                    ISpatializerHeadToSoundStagePoseCallback _arg0 = ISpatializerHeadToSoundStagePoseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerHeadToSoundstagePoseCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 166: {
                    ISpatializerHeadToSoundStagePoseCallback _arg0 = ISpatializerHeadToSoundStagePoseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterHeadToSoundstagePoseCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 167: {
                    List<AudioDeviceAttributes> _result = this.getSpatializerCompatibleAudioDevices();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 168: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    this.addSpatializerCompatibleAudioDevice(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 169: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    this.removeSpatializerCompatibleAudioDevice(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 170: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setDesiredHeadTrackingMode(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 171: {
                    int _result = this.getDesiredHeadTrackingMode();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 172: {
                    int[] _result = this.getSupportedHeadTrackingModes();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 173: {
                    int _result = this.getActualHeadTrackingMode();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 174: {
                    float[] _arg0 = data.createFloatArray();
                    data.enforceNoDataAvail();
                    this.setSpatializerGlobalTransform(_arg0);
                    break;
                }
                case 175: {
                    this.recenterHeadTracker();
                    break;
                }
                case 176: {
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.setSpatializerParameter(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 177: {
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.getSpatializerParameter(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeByteArray(_arg1);
                    break;
                }
                case 178: {
                    int _result = this.getSpatializerOutput();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 179: {
                    ISpatializerOutputCallback _arg0 = ISpatializerOutputCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerSpatializerOutputCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 180: {
                    ISpatializerOutputCallback _arg0 = ISpatializerOutputCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterSpatializerOutputCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 181: {
                    boolean _result = this.isVolumeFixed();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 182: {
                    VolumeInfo _result = this.getDefaultVolumeInfo();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 183: {
                    boolean _result = this.isPstnCallAudioInterceptable();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 184: {
                    int[] _arg0 = data.createIntArray();
                    AudioDeviceAttributes _arg1 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    this.muteAwaitConnection(_arg0, _arg1, _arg2);
                    break;
                }
                case 185: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    this.cancelMuteAwaitConnection(_arg0);
                    break;
                }
                case 186: {
                    AudioDeviceAttributes _result = this.getMutingExpectedDevice();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 187: {
                    IMuteAwaitConnectionCallback _arg0 = IMuteAwaitConnectionCallback.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.registerMuteAwaitConnectionDispatcher(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 188: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setTestDeviceConnectionState(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 189: {
                    boolean _arg0 = data.readBoolean();
                    IDeviceVolumeBehaviorDispatcher _arg1 = IDeviceVolumeBehaviorDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerDeviceVolumeBehaviorDispatcher(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 190: {
                    List<AudioFocusInfo> _result = this.getFocusStack();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 191: {
                    AudioFocusInfo _arg0 = data.readTypedObject(AudioFocusInfo.CREATOR);
                    IAudioPolicyCallback _arg1 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.sendFocusLoss(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 192: {
                    int[] _arg0 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.addAssistantServicesUids(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 193: {
                    int[] _arg0 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.removeAssistantServicesUids(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 194: {
                    int[] _arg0 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.setActiveAssistantServiceUids(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 195: {
                    int[] _result = this.getAssistantServicesUids();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 196: {
                    int[] _result = this.getActiveAssistantServiceUids();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 197: {
                    boolean _arg0 = data.readBoolean();
                    IAudioDeviceVolumeDispatcher _arg1 = IAudioDeviceVolumeDispatcher.Stub.asInterface(data.readStrongBinder());
                    String _arg2 = data.readString();
                    AudioDeviceAttributes _arg3 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    ArrayList<VolumeInfo> _arg4 = data.createTypedArrayList(VolumeInfo.CREATOR);
                    boolean _arg5 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.registerDeviceVolumeDispatcherForAbsoluteVolume(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 198: {
                    String _result = this.getHalVersion();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 197;
        }

        private static class Proxy
        implements IAudioService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int trackPlayer(PlayerBase.PlayerIdCard pic) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(pic, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playerAttributes(int piid, AudioAttributes attr2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(piid);
                    _data.writeTypedObject(attr2, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playerEvent(int piid, int event, int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(piid);
                    _data.writeInt(event);
                    _data.writeInt(deviceId);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releasePlayer(int piid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(piid);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int trackRecorder(IBinder recorder) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(recorder);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void recorderEvent(int riid, int event) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(riid);
                    _data.writeInt(event);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseRecorder(int riid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(riid);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playerSessionId(int piid, int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(piid);
                    _data.writeInt(sessionId);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void adjustStreamVolume(int streamType, int direction, int flags, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(direction);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void adjustStreamVolumeWithAttribution(int streamType, int direction, int flags, String callingPackage, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(direction);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setStreamVolume(int streamType, int index, int flags, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(index);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setStreamVolumeWithAttribution(int streamType, int index, int flags, String callingPackage, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(index);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleVolumeKey(KeyEvent event, boolean isOnTv, String callingPackage, String caller) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(event, 0);
                    _data.writeBoolean(isOnTv);
                    _data.writeString(callingPackage);
                    _data.writeString(caller);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isStreamMute(int streamType) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forceRemoteSubmixFullVolume(boolean startForcing, IBinder cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(startForcing);
                    _data.writeStrongBinder(cb);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMasterMute() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMasterMute(boolean mute, int flags, String callingPackage, int userId, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(mute);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getStreamVolume(int streamType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getStreamMinVolume(int streamType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getStreamMaxVolume(int streamType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioVolumeGroup> getAudioVolumeGroups() throws RemoteException {
                ArrayList<AudioVolumeGroup> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioVolumeGroup.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVolumeIndexForAttributes(AudioAttributes aa, int index, int flags, String callingPackage, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(aa, 0);
                    _data.writeInt(index);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getVolumeIndexForAttributes(AudioAttributes aa) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(aa, 0);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMaxVolumeIndexForAttributes(AudioAttributes aa) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(aa, 0);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMinVolumeIndexForAttributes(AudioAttributes aa) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(aa, 0);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getLastAudibleStreamVolume(int streamType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSupportedSystemUsages(int[] systemUsages) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(systemUsages);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getSupportedSystemUsages() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioProductStrategy> getAudioProductStrategies() throws RemoteException {
                ArrayList<AudioProductStrategy> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioProductStrategy.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMicrophoneMuted() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isUltrasoundSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMicrophoneMute(boolean on, String callingPackage, int userId, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(on);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMicrophoneMuteFromSwitch(boolean on) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(on);
                    boolean bl = this.mRemote.transact(33, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRingerModeExternal(int ringerMode, String caller) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(ringerMode);
                    _data.writeString(caller);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRingerModeInternal(int ringerMode, String caller) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(ringerMode);
                    _data.writeString(caller);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRingerModeExternal() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRingerModeInternal() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isValidRingerMode(int ringerMode) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(ringerMode);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVibrateSetting(int vibrateType, int vibrateSetting) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(vibrateType);
                    _data.writeInt(vibrateSetting);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getVibrateSetting(int vibrateType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(vibrateType);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean shouldVibrate(int vibrateType) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(vibrateType);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMode(int mode, IBinder cb, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    _data.writeStrongBinder(cb);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMode() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playSoundEffect(int effectType, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(effectType);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(44, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playSoundEffectVolume(int effectType, float volume) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(effectType);
                    _data.writeFloat(volume);
                    boolean bl = this.mRemote.transact(45, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean loadSoundEffects() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public void unloadSoundEffects() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(47, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void reloadAudioSettings() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(48, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getSurroundFormats() throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List getReportedSurroundFormats() throws RemoteException {
                ArrayList _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readArrayList(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setSurroundFormatEnabled(int audioFormat, boolean enabled) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(audioFormat);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSurroundFormatEnabled(int audioFormat) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(audioFormat);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setEncodedSurroundMode(int mode) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getEncodedSurroundMode(int targetSdkVersion) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(targetSdkVersion);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSpeakerphoneOn(IBinder cb, boolean on) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(cb);
                    _data.writeBoolean(on);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSpeakerphoneOn() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBluetoothScoOn(boolean on) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(on);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBluetoothScoOn() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBluetoothA2dpOn(boolean on) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(on);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBluetoothA2dpOn() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(60, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int requestAudioFocus(AudioAttributes aa, int durationHint, IBinder cb, IAudioFocusDispatcher fd, String clientId, String callingPackageName, String attributionTag, int flags, IAudioPolicyCallback pcb, int sdk) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(aa, 0);
                    _data.writeInt(durationHint);
                    _data.writeStrongBinder(cb);
                    _data.writeStrongInterface(fd);
                    _data.writeString(clientId);
                    _data.writeString(callingPackageName);
                    _data.writeString(attributionTag);
                    _data.writeInt(flags);
                    _data.writeStrongInterface(pcb);
                    _data.writeInt(sdk);
                    boolean _status = this.mRemote.transact(61, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int abandonAudioFocus(IAudioFocusDispatcher fd, String clientId, AudioAttributes aa, String callingPackageName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(fd);
                    _data.writeString(clientId);
                    _data.writeTypedObject(aa, 0);
                    _data.writeString(callingPackageName);
                    boolean _status = this.mRemote.transact(62, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAudioFocusClient(String clientId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(clientId);
                    boolean _status = this.mRemote.transact(63, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getCurrentAudioFocus() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(64, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startBluetoothSco(IBinder cb, int targetSdkVersion) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(cb);
                    _data.writeInt(targetSdkVersion);
                    boolean _status = this.mRemote.transact(65, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startBluetoothScoVirtualCall(IBinder cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(cb);
                    boolean _status = this.mRemote.transact(66, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopBluetoothSco(IBinder cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(cb);
                    boolean _status = this.mRemote.transact(67, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forceVolumeControlStream(int streamType, IBinder cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeStrongBinder(cb);
                    boolean _status = this.mRemote.transact(68, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRingtonePlayer(IRingtonePlayer player) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(player);
                    boolean _status = this.mRemote.transact(69, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRingtonePlayer getRingtonePlayer() throws RemoteException {
                IRingtonePlayer _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(70, _data, _reply, 0);
                    _reply.readException();
                    _result = IRingtonePlayer.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getUiSoundsStreamType() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(71, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWiredDeviceConnectionState(AudioDeviceAttributes aa, int state, String caller) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(aa, 0);
                    _data.writeInt(state);
                    _data.writeString(caller);
                    boolean _status = this.mRemote.transact(72, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AudioRoutesInfo startWatchingRoutes(IAudioRoutesObserver observer) throws RemoteException {
                AudioRoutesInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(observer);
                    boolean _status = this.mRemote.transact(73, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(AudioRoutesInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isCameraSoundForced() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(74, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVolumeController(IVolumeController controller) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(controller);
                    boolean _status = this.mRemote.transact(75, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyVolumeControllerVisible(IVolumeController controller, boolean visible) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(controller);
                    _data.writeBoolean(visible);
                    boolean _status = this.mRemote.transact(76, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isStreamAffectedByRingerMode(int streamType) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(77, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isStreamAffectedByMute(int streamType) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(78, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableSafeMediaVolume(String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(79, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setHdmiSystemAudioSupported(boolean on) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(on);
                    boolean _status = this.mRemote.transact(80, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHdmiSystemAudioSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(81, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String registerAudioPolicy(AudioPolicyConfig policyConfig, IAudioPolicyCallback pcb, boolean hasFocusListener, boolean isFocusPolicy, boolean isTestFocusPolicy, boolean isVolumeController, IMediaProjection projection) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(policyConfig, 0);
                    _data.writeStrongInterface(pcb);
                    _data.writeBoolean(hasFocusListener);
                    _data.writeBoolean(isFocusPolicy);
                    _data.writeBoolean(isTestFocusPolicy);
                    _data.writeBoolean(isVolumeController);
                    _data.writeStrongInterface(projection);
                    boolean _status = this.mRemote.transact(82, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAudioPolicyAsync(IAudioPolicyCallback pcb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(pcb);
                    boolean bl = this.mRemote.transact(83, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAudioPolicy(IAudioPolicyCallback pcb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(pcb);
                    boolean _status = this.mRemote.transact(84, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addMixForPolicy(AudioPolicyConfig policyConfig, IAudioPolicyCallback pcb) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(policyConfig, 0);
                    _data.writeStrongInterface(pcb);
                    boolean _status = this.mRemote.transact(85, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int removeMixForPolicy(AudioPolicyConfig policyConfig, IAudioPolicyCallback pcb) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(policyConfig, 0);
                    _data.writeStrongInterface(pcb);
                    boolean _status = this.mRemote.transact(86, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setFocusPropertiesForPolicy(int duckingBehavior, IAudioPolicyCallback pcb) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(duckingBehavior);
                    _data.writeStrongInterface(pcb);
                    boolean _status = this.mRemote.transact(87, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVolumePolicy(VolumePolicy policy) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(policy, 0);
                    boolean _status = this.mRemote.transact(88, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasRegisteredDynamicPolicy() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(89, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerRecordingCallback(IRecordingConfigDispatcher rcdb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(rcdb);
                    boolean _status = this.mRemote.transact(90, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterRecordingCallback(IRecordingConfigDispatcher rcdb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(rcdb);
                    boolean bl = this.mRemote.transact(91, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioRecordingConfiguration> getActiveRecordingConfigurations() throws RemoteException {
                ArrayList<AudioRecordingConfiguration> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(92, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioRecordingConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerPlaybackCallback(IPlaybackConfigDispatcher pcdb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(pcdb);
                    boolean _status = this.mRemote.transact(93, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterPlaybackCallback(IPlaybackConfigDispatcher pcdb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(pcdb);
                    boolean bl = this.mRemote.transact(94, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioPlaybackConfiguration> getActivePlaybackConfigurations() throws RemoteException {
                ArrayList<AudioPlaybackConfiguration> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(95, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioPlaybackConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getFocusRampTimeMs(int focusGain, AudioAttributes attr2) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(focusGain);
                    _data.writeTypedObject(attr2, 0);
                    boolean _status = this.mRemote.transact(96, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int dispatchFocusChange(AudioFocusInfo afi, int focusChange, IAudioPolicyCallback pcb) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(afi, 0);
                    _data.writeInt(focusChange);
                    _data.writeStrongInterface(pcb);
                    boolean _status = this.mRemote.transact(97, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playerHasOpPlayAudio(int piid, boolean hasOpPlayAudio) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(piid);
                    _data.writeBoolean(hasOpPlayAudio);
                    boolean bl = this.mRemote.transact(98, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleBluetoothActiveDeviceChanged(BluetoothDevice newDevice, BluetoothDevice previousDevice, BluetoothProfileConnectionInfo info) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(newDevice, 0);
                    _data.writeTypedObject(previousDevice, 0);
                    _data.writeTypedObject(info, 0);
                    boolean _status = this.mRemote.transact(99, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFocusRequestResultFromExtPolicy(AudioFocusInfo afi, int requestResult, IAudioPolicyCallback pcb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(afi, 0);
                    _data.writeInt(requestResult);
                    _data.writeStrongInterface(pcb);
                    boolean bl = this.mRemote.transact(100, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerAudioServerStateDispatcher(IAudioServerStateDispatcher asd) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(asd);
                    boolean _status = this.mRemote.transact(101, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAudioServerStateDispatcher(IAudioServerStateDispatcher asd) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(asd);
                    boolean bl = this.mRemote.transact(102, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAudioServerRunning() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(103, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setUidDeviceAffinity(IAudioPolicyCallback pcb, int uid, int[] deviceTypes, String[] deviceAddresses) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(pcb);
                    _data.writeInt(uid);
                    _data.writeIntArray(deviceTypes);
                    _data.writeStringArray(deviceAddresses);
                    boolean _status = this.mRemote.transact(104, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int removeUidDeviceAffinity(IAudioPolicyCallback pcb, int uid) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(pcb);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(105, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setUserIdDeviceAffinity(IAudioPolicyCallback pcb, int userId, int[] deviceTypes, String[] deviceAddresses) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(pcb);
                    _data.writeInt(userId);
                    _data.writeIntArray(deviceTypes);
                    _data.writeStringArray(deviceAddresses);
                    boolean _status = this.mRemote.transact(106, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int removeUserIdDeviceAffinity(IAudioPolicyCallback pcb, int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(pcb);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(107, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasHapticChannels(Uri uri) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(uri, 0);
                    boolean _status = this.mRemote.transact(108, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isCallScreeningModeSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(109, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setPreferredDevicesForStrategy(int strategy, List<AudioDeviceAttributes> device) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(strategy);
                    _data.writeTypedList(device);
                    boolean _status = this.mRemote.transact(110, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int removePreferredDevicesForStrategy(int strategy) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(strategy);
                    boolean _status = this.mRemote.transact(111, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioDeviceAttributes> getPreferredDevicesForStrategy(int strategy) throws RemoteException {
                ArrayList<AudioDeviceAttributes> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(strategy);
                    boolean _status = this.mRemote.transact(112, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioDeviceAttributes.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioDeviceAttributes> getDevicesForAttributes(AudioAttributes attributes) throws RemoteException {
                ArrayList<AudioDeviceAttributes> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributes, 0);
                    boolean _status = this.mRemote.transact(113, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioDeviceAttributes.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioDeviceAttributes> getDevicesForAttributesUnprotected(AudioAttributes attributes) throws RemoteException {
                ArrayList<AudioDeviceAttributes> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributes, 0);
                    boolean _status = this.mRemote.transact(114, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioDeviceAttributes.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setAllowedCapturePolicy(int capturePolicy) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(capturePolicy);
                    boolean _status = this.mRemote.transact(115, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getAllowedCapturePolicy() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(116, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerStrategyPreferredDevicesDispatcher(IStrategyPreferredDevicesDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean _status = this.mRemote.transact(117, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterStrategyPreferredDevicesDispatcher(IStrategyPreferredDevicesDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean bl = this.mRemote.transact(118, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRttEnabled(boolean rttEnabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(rttEnabled);
                    boolean bl = this.mRemote.transact(119, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDeviceVolumeBehavior(AudioDeviceAttributes device, int deviceVolumeBehavior, String pkgName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(deviceVolumeBehavior);
                    _data.writeString(pkgName);
                    boolean _status = this.mRemote.transact(120, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDeviceVolumeBehavior(AudioDeviceAttributes device) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(121, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMultiAudioFocusEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(122, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setPreferredDevicesForCapturePreset(int capturePreset, List<AudioDeviceAttributes> devices) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(capturePreset);
                    _data.writeTypedList(devices);
                    boolean _status = this.mRemote.transact(123, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int clearPreferredDevicesForCapturePreset(int capturePreset) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(capturePreset);
                    boolean _status = this.mRemote.transact(124, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioDeviceAttributes> getPreferredDevicesForCapturePreset(int capturePreset) throws RemoteException {
                ArrayList<AudioDeviceAttributes> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(capturePreset);
                    boolean _status = this.mRemote.transact(125, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioDeviceAttributes.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCapturePresetDevicesRoleDispatcher(ICapturePresetDevicesRoleDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean _status = this.mRemote.transact(126, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCapturePresetDevicesRoleDispatcher(ICapturePresetDevicesRoleDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean bl = this.mRemote.transact(127, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void adjustStreamVolumeForUid(int streamType, int direction, int flags, String packageName, int uid, int pid, UserHandle userHandle, int targetSdkVersion) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(direction);
                    _data.writeInt(flags);
                    _data.writeString(packageName);
                    _data.writeInt(uid);
                    _data.writeInt(pid);
                    _data.writeTypedObject(userHandle, 0);
                    _data.writeInt(targetSdkVersion);
                    boolean bl = this.mRemote.transact(128, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void adjustSuggestedStreamVolumeForUid(int streamType, int direction, int flags, String packageName, int uid, int pid, UserHandle userHandle, int targetSdkVersion) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(direction);
                    _data.writeInt(flags);
                    _data.writeString(packageName);
                    _data.writeInt(uid);
                    _data.writeInt(pid);
                    _data.writeTypedObject(userHandle, 0);
                    _data.writeInt(targetSdkVersion);
                    boolean bl = this.mRemote.transact(129, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setStreamVolumeForUid(int streamType, int direction, int flags, String packageName, int uid, int pid, UserHandle userHandle, int targetSdkVersion) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(direction);
                    _data.writeInt(flags);
                    _data.writeString(packageName);
                    _data.writeInt(uid);
                    _data.writeInt(pid);
                    _data.writeTypedObject(userHandle, 0);
                    _data.writeInt(targetSdkVersion);
                    boolean bl = this.mRemote.transact(130, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMusicActive(boolean remotely) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(remotely);
                    boolean _status = this.mRemote.transact(131, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDeviceMaskForStream(int streamType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(132, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getAvailableCommunicationDeviceIds() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(133, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setCommunicationDevice(IBinder cb, int portId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(cb);
                    _data.writeInt(portId);
                    boolean _status = this.mRemote.transact(134, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getCommunicationDevice() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(135, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCommunicationDeviceDispatcher(ICommunicationDeviceDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean _status = this.mRemote.transact(136, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCommunicationDeviceDispatcher(ICommunicationDeviceDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean bl = this.mRemote.transact(137, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean areNavigationRepeatSoundEffectsEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(138, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNavigationRepeatSoundEffectsEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(139, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHomeSoundEffectEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(140, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setHomeSoundEffectEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(141, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setAdditionalOutputDeviceDelay(AudioDeviceAttributes device, long delayMillis) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeLong(delayMillis);
                    boolean _status = this.mRemote.transact(142, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getAdditionalOutputDeviceDelay(AudioDeviceAttributes device) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(143, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getMaxAdditionalOutputDeviceDelay(AudioDeviceAttributes device) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(144, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int requestAudioFocusForTest(AudioAttributes aa, int durationHint, IBinder cb, IAudioFocusDispatcher fd, String clientId, String callingPackageName, int flags, int uid, int sdk) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(aa, 0);
                    _data.writeInt(durationHint);
                    _data.writeStrongBinder(cb);
                    _data.writeStrongInterface(fd);
                    _data.writeString(clientId);
                    _data.writeString(callingPackageName);
                    _data.writeInt(flags);
                    _data.writeInt(uid);
                    _data.writeInt(sdk);
                    boolean _status = this.mRemote.transact(145, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int abandonAudioFocusForTest(IAudioFocusDispatcher fd, String clientId, AudioAttributes aa, String callingPackageName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(fd);
                    _data.writeString(clientId);
                    _data.writeTypedObject(aa, 0);
                    _data.writeString(callingPackageName);
                    boolean _status = this.mRemote.transact(146, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getFadeOutDurationOnFocusLossMillis(AudioAttributes aa) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(aa, 0);
                    boolean _status = this.mRemote.transact(147, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerModeDispatcher(IAudioModeDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean _status = this.mRemote.transact(148, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterModeDispatcher(IAudioModeDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean bl = this.mRemote.transact(149, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getSpatializerImmersiveAudioLevel() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(150, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSpatializerEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(151, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSpatializerAvailable() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(152, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSpatializerAvailableForDevice(AudioDeviceAttributes device) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(153, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasHeadTracker(AudioDeviceAttributes device) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(154, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setHeadTrackerEnabled(boolean enabled, AudioDeviceAttributes device) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(155, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHeadTrackerEnabled(AudioDeviceAttributes device) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(156, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHeadTrackerAvailable() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(157, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSpatializerHeadTrackerAvailableCallback(ISpatializerHeadTrackerAvailableCallback cb, boolean register) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    _data.writeBoolean(register);
                    boolean _status = this.mRemote.transact(158, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSpatializerEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(159, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canBeSpatialized(AudioAttributes aa, AudioFormat af) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(aa, 0);
                    _data.writeTypedObject(af, 0);
                    boolean _status = this.mRemote.transact(160, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSpatializerCallback(ISpatializerCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(161, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSpatializerCallback(ISpatializerCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(162, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSpatializerHeadTrackingCallback(ISpatializerHeadTrackingModeCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(163, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSpatializerHeadTrackingCallback(ISpatializerHeadTrackingModeCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(164, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerHeadToSoundstagePoseCallback(ISpatializerHeadToSoundStagePoseCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(165, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterHeadToSoundstagePoseCallback(ISpatializerHeadToSoundStagePoseCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(166, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioDeviceAttributes> getSpatializerCompatibleAudioDevices() throws RemoteException {
                ArrayList<AudioDeviceAttributes> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(167, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioDeviceAttributes.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addSpatializerCompatibleAudioDevice(AudioDeviceAttributes ada) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ada, 0);
                    boolean _status = this.mRemote.transact(168, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeSpatializerCompatibleAudioDevice(AudioDeviceAttributes ada) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ada, 0);
                    boolean _status = this.mRemote.transact(169, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDesiredHeadTrackingMode(int mode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(170, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDesiredHeadTrackingMode() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(171, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getSupportedHeadTrackingModes() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(172, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getActualHeadTrackingMode() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(173, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSpatializerGlobalTransform(float[] transform) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloatArray(transform);
                    boolean bl = this.mRemote.transact(174, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void recenterHeadTracker() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(175, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSpatializerParameter(int key, byte[] value) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(key);
                    _data.writeByteArray(value);
                    boolean _status = this.mRemote.transact(176, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getSpatializerParameter(int key, byte[] value) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(key);
                    _data.writeByteArray(value);
                    boolean _status = this.mRemote.transact(177, _data, _reply, 0);
                    _reply.readException();
                    _reply.readByteArray(value);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getSpatializerOutput() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(178, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSpatializerOutputCallback(ISpatializerOutputCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(179, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSpatializerOutputCallback(ISpatializerOutputCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(180, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isVolumeFixed() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(181, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VolumeInfo getDefaultVolumeInfo() throws RemoteException {
                VolumeInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(182, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(VolumeInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPstnCallAudioInterceptable() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(183, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void muteAwaitConnection(int[] usagesToMute, AudioDeviceAttributes dev, long timeOutMs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(usagesToMute);
                    _data.writeTypedObject(dev, 0);
                    _data.writeLong(timeOutMs);
                    boolean bl = this.mRemote.transact(184, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelMuteAwaitConnection(AudioDeviceAttributes dev) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(dev, 0);
                    boolean bl = this.mRemote.transact(185, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AudioDeviceAttributes getMutingExpectedDevice() throws RemoteException {
                AudioDeviceAttributes _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(186, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(AudioDeviceAttributes.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerMuteAwaitConnectionDispatcher(IMuteAwaitConnectionCallback cb, boolean register) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    _data.writeBoolean(register);
                    boolean _status = this.mRemote.transact(187, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTestDeviceConnectionState(AudioDeviceAttributes device, boolean connected) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeBoolean(connected);
                    boolean _status = this.mRemote.transact(188, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerDeviceVolumeBehaviorDispatcher(boolean register, IDeviceVolumeBehaviorDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(register);
                    _data.writeStrongInterface(dispatcher);
                    boolean _status = this.mRemote.transact(189, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioFocusInfo> getFocusStack() throws RemoteException {
                ArrayList<AudioFocusInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(190, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioFocusInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendFocusLoss(AudioFocusInfo focusLoser, IAudioPolicyCallback apcb) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(focusLoser, 0);
                    _data.writeStrongInterface(apcb);
                    boolean _status = this.mRemote.transact(191, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addAssistantServicesUids(int[] assistantUID) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(assistantUID);
                    boolean _status = this.mRemote.transact(192, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAssistantServicesUids(int[] assistantUID) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(assistantUID);
                    boolean _status = this.mRemote.transact(193, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setActiveAssistantServiceUids(int[] activeUids) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(activeUids);
                    boolean _status = this.mRemote.transact(194, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getAssistantServicesUids() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(195, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getActiveAssistantServiceUids() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(196, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerDeviceVolumeDispatcherForAbsoluteVolume(boolean register, IAudioDeviceVolumeDispatcher cb, String packageName, AudioDeviceAttributes device, List<VolumeInfo> volumes, boolean handlesvolumeAdjustment) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(register);
                    _data.writeStrongInterface(cb);
                    _data.writeString(packageName);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedList(volumes);
                    _data.writeBoolean(handlesvolumeAdjustment);
                    boolean _status = this.mRemote.transact(197, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getHalVersion() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(198, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IAudioService {
        @Override
        public int trackPlayer(PlayerBase.PlayerIdCard pic) throws RemoteException {
            return 0;
        }

        @Override
        public void playerAttributes(int piid, AudioAttributes attr2) throws RemoteException {
        }

        @Override
        public void playerEvent(int piid, int event, int deviceId) throws RemoteException {
        }

        @Override
        public void releasePlayer(int piid) throws RemoteException {
        }

        @Override
        public int trackRecorder(IBinder recorder) throws RemoteException {
            return 0;
        }

        @Override
        public void recorderEvent(int riid, int event) throws RemoteException {
        }

        @Override
        public void releaseRecorder(int riid) throws RemoteException {
        }

        @Override
        public void playerSessionId(int piid, int sessionId) throws RemoteException {
        }

        @Override
        public void adjustStreamVolume(int streamType, int direction, int flags, String callingPackage) throws RemoteException {
        }

        @Override
        public void adjustStreamVolumeWithAttribution(int streamType, int direction, int flags, String callingPackage, String attributionTag) throws RemoteException {
        }

        @Override
        public void setStreamVolume(int streamType, int index, int flags, String callingPackage) throws RemoteException {
        }

        @Override
        public void setStreamVolumeWithAttribution(int streamType, int index, int flags, String callingPackage, String attributionTag) throws RemoteException {
        }

        @Override
        public void handleVolumeKey(KeyEvent event, boolean isOnTv, String callingPackage, String caller) throws RemoteException {
        }

        @Override
        public boolean isStreamMute(int streamType) throws RemoteException {
            return false;
        }

        @Override
        public void forceRemoteSubmixFullVolume(boolean startForcing, IBinder cb) throws RemoteException {
        }

        @Override
        public boolean isMasterMute() throws RemoteException {
            return false;
        }

        @Override
        public void setMasterMute(boolean mute, int flags, String callingPackage, int userId, String attributionTag) throws RemoteException {
        }

        @Override
        public int getStreamVolume(int streamType) throws RemoteException {
            return 0;
        }

        @Override
        public int getStreamMinVolume(int streamType) throws RemoteException {
            return 0;
        }

        @Override
        public int getStreamMaxVolume(int streamType) throws RemoteException {
            return 0;
        }

        @Override
        public List<AudioVolumeGroup> getAudioVolumeGroups() throws RemoteException {
            return null;
        }

        @Override
        public void setVolumeIndexForAttributes(AudioAttributes aa, int index, int flags, String callingPackage, String attributionTag) throws RemoteException {
        }

        @Override
        public int getVolumeIndexForAttributes(AudioAttributes aa) throws RemoteException {
            return 0;
        }

        @Override
        public int getMaxVolumeIndexForAttributes(AudioAttributes aa) throws RemoteException {
            return 0;
        }

        @Override
        public int getMinVolumeIndexForAttributes(AudioAttributes aa) throws RemoteException {
            return 0;
        }

        @Override
        public int getLastAudibleStreamVolume(int streamType) throws RemoteException {
            return 0;
        }

        @Override
        public void setSupportedSystemUsages(int[] systemUsages) throws RemoteException {
        }

        @Override
        public int[] getSupportedSystemUsages() throws RemoteException {
            return null;
        }

        @Override
        public List<AudioProductStrategy> getAudioProductStrategies() throws RemoteException {
            return null;
        }

        @Override
        public boolean isMicrophoneMuted() throws RemoteException {
            return false;
        }

        @Override
        public boolean isUltrasoundSupported() throws RemoteException {
            return false;
        }

        @Override
        public void setMicrophoneMute(boolean on, String callingPackage, int userId, String attributionTag) throws RemoteException {
        }

        @Override
        public void setMicrophoneMuteFromSwitch(boolean on) throws RemoteException {
        }

        @Override
        public void setRingerModeExternal(int ringerMode, String caller) throws RemoteException {
        }

        @Override
        public void setRingerModeInternal(int ringerMode, String caller) throws RemoteException {
        }

        @Override
        public int getRingerModeExternal() throws RemoteException {
            return 0;
        }

        @Override
        public int getRingerModeInternal() throws RemoteException {
            return 0;
        }

        @Override
        public boolean isValidRingerMode(int ringerMode) throws RemoteException {
            return false;
        }

        @Override
        public void setVibrateSetting(int vibrateType, int vibrateSetting) throws RemoteException {
        }

        @Override
        public int getVibrateSetting(int vibrateType) throws RemoteException {
            return 0;
        }

        @Override
        public boolean shouldVibrate(int vibrateType) throws RemoteException {
            return false;
        }

        @Override
        public void setMode(int mode, IBinder cb, String callingPackage) throws RemoteException {
        }

        @Override
        public int getMode() throws RemoteException {
            return 0;
        }

        @Override
        public void playSoundEffect(int effectType, int userId) throws RemoteException {
        }

        @Override
        public void playSoundEffectVolume(int effectType, float volume) throws RemoteException {
        }

        @Override
        public boolean loadSoundEffects() throws RemoteException {
            return false;
        }

        @Override
        public void unloadSoundEffects() throws RemoteException {
        }

        @Override
        public void reloadAudioSettings() throws RemoteException {
        }

        @Override
        public Map getSurroundFormats() throws RemoteException {
            return null;
        }

        @Override
        public List getReportedSurroundFormats() throws RemoteException {
            return null;
        }

        @Override
        public boolean setSurroundFormatEnabled(int audioFormat, boolean enabled) throws RemoteException {
            return false;
        }

        @Override
        public boolean isSurroundFormatEnabled(int audioFormat) throws RemoteException {
            return false;
        }

        @Override
        public boolean setEncodedSurroundMode(int mode) throws RemoteException {
            return false;
        }

        @Override
        public int getEncodedSurroundMode(int targetSdkVersion) throws RemoteException {
            return 0;
        }

        @Override
        public void setSpeakerphoneOn(IBinder cb, boolean on) throws RemoteException {
        }

        @Override
        public boolean isSpeakerphoneOn() throws RemoteException {
            return false;
        }

        @Override
        public void setBluetoothScoOn(boolean on) throws RemoteException {
        }

        @Override
        public boolean isBluetoothScoOn() throws RemoteException {
            return false;
        }

        @Override
        public void setBluetoothA2dpOn(boolean on) throws RemoteException {
        }

        @Override
        public boolean isBluetoothA2dpOn() throws RemoteException {
            return false;
        }

        @Override
        public int requestAudioFocus(AudioAttributes aa, int durationHint, IBinder cb, IAudioFocusDispatcher fd, String clientId, String callingPackageName, String attributionTag, int flags, IAudioPolicyCallback pcb, int sdk) throws RemoteException {
            return 0;
        }

        @Override
        public int abandonAudioFocus(IAudioFocusDispatcher fd, String clientId, AudioAttributes aa, String callingPackageName) throws RemoteException {
            return 0;
        }

        @Override
        public void unregisterAudioFocusClient(String clientId) throws RemoteException {
        }

        @Override
        public int getCurrentAudioFocus() throws RemoteException {
            return 0;
        }

        @Override
        public void startBluetoothSco(IBinder cb, int targetSdkVersion) throws RemoteException {
        }

        @Override
        public void startBluetoothScoVirtualCall(IBinder cb) throws RemoteException {
        }

        @Override
        public void stopBluetoothSco(IBinder cb) throws RemoteException {
        }

        @Override
        public void forceVolumeControlStream(int streamType, IBinder cb) throws RemoteException {
        }

        @Override
        public void setRingtonePlayer(IRingtonePlayer player) throws RemoteException {
        }

        @Override
        public IRingtonePlayer getRingtonePlayer() throws RemoteException {
            return null;
        }

        @Override
        public int getUiSoundsStreamType() throws RemoteException {
            return 0;
        }

        @Override
        public void setWiredDeviceConnectionState(AudioDeviceAttributes aa, int state, String caller) throws RemoteException {
        }

        @Override
        public AudioRoutesInfo startWatchingRoutes(IAudioRoutesObserver observer) throws RemoteException {
            return null;
        }

        @Override
        public boolean isCameraSoundForced() throws RemoteException {
            return false;
        }

        @Override
        public void setVolumeController(IVolumeController controller) throws RemoteException {
        }

        @Override
        public void notifyVolumeControllerVisible(IVolumeController controller, boolean visible) throws RemoteException {
        }

        @Override
        public boolean isStreamAffectedByRingerMode(int streamType) throws RemoteException {
            return false;
        }

        @Override
        public boolean isStreamAffectedByMute(int streamType) throws RemoteException {
            return false;
        }

        @Override
        public void disableSafeMediaVolume(String callingPackage) throws RemoteException {
        }

        @Override
        public int setHdmiSystemAudioSupported(boolean on) throws RemoteException {
            return 0;
        }

        @Override
        public boolean isHdmiSystemAudioSupported() throws RemoteException {
            return false;
        }

        @Override
        public String registerAudioPolicy(AudioPolicyConfig policyConfig, IAudioPolicyCallback pcb, boolean hasFocusListener, boolean isFocusPolicy, boolean isTestFocusPolicy, boolean isVolumeController, IMediaProjection projection) throws RemoteException {
            return null;
        }

        @Override
        public void unregisterAudioPolicyAsync(IAudioPolicyCallback pcb) throws RemoteException {
        }

        @Override
        public void unregisterAudioPolicy(IAudioPolicyCallback pcb) throws RemoteException {
        }

        @Override
        public int addMixForPolicy(AudioPolicyConfig policyConfig, IAudioPolicyCallback pcb) throws RemoteException {
            return 0;
        }

        @Override
        public int removeMixForPolicy(AudioPolicyConfig policyConfig, IAudioPolicyCallback pcb) throws RemoteException {
            return 0;
        }

        @Override
        public int setFocusPropertiesForPolicy(int duckingBehavior, IAudioPolicyCallback pcb) throws RemoteException {
            return 0;
        }

        @Override
        public void setVolumePolicy(VolumePolicy policy) throws RemoteException {
        }

        @Override
        public boolean hasRegisteredDynamicPolicy() throws RemoteException {
            return false;
        }

        @Override
        public void registerRecordingCallback(IRecordingConfigDispatcher rcdb) throws RemoteException {
        }

        @Override
        public void unregisterRecordingCallback(IRecordingConfigDispatcher rcdb) throws RemoteException {
        }

        @Override
        public List<AudioRecordingConfiguration> getActiveRecordingConfigurations() throws RemoteException {
            return null;
        }

        @Override
        public void registerPlaybackCallback(IPlaybackConfigDispatcher pcdb) throws RemoteException {
        }

        @Override
        public void unregisterPlaybackCallback(IPlaybackConfigDispatcher pcdb) throws RemoteException {
        }

        @Override
        public List<AudioPlaybackConfiguration> getActivePlaybackConfigurations() throws RemoteException {
            return null;
        }

        @Override
        public int getFocusRampTimeMs(int focusGain, AudioAttributes attr2) throws RemoteException {
            return 0;
        }

        @Override
        public int dispatchFocusChange(AudioFocusInfo afi, int focusChange, IAudioPolicyCallback pcb) throws RemoteException {
            return 0;
        }

        @Override
        public void playerHasOpPlayAudio(int piid, boolean hasOpPlayAudio) throws RemoteException {
        }

        @Override
        public void handleBluetoothActiveDeviceChanged(BluetoothDevice newDevice, BluetoothDevice previousDevice, BluetoothProfileConnectionInfo info) throws RemoteException {
        }

        @Override
        public void setFocusRequestResultFromExtPolicy(AudioFocusInfo afi, int requestResult, IAudioPolicyCallback pcb) throws RemoteException {
        }

        @Override
        public void registerAudioServerStateDispatcher(IAudioServerStateDispatcher asd) throws RemoteException {
        }

        @Override
        public void unregisterAudioServerStateDispatcher(IAudioServerStateDispatcher asd) throws RemoteException {
        }

        @Override
        public boolean isAudioServerRunning() throws RemoteException {
            return false;
        }

        @Override
        public int setUidDeviceAffinity(IAudioPolicyCallback pcb, int uid, int[] deviceTypes, String[] deviceAddresses) throws RemoteException {
            return 0;
        }

        @Override
        public int removeUidDeviceAffinity(IAudioPolicyCallback pcb, int uid) throws RemoteException {
            return 0;
        }

        @Override
        public int setUserIdDeviceAffinity(IAudioPolicyCallback pcb, int userId, int[] deviceTypes, String[] deviceAddresses) throws RemoteException {
            return 0;
        }

        @Override
        public int removeUserIdDeviceAffinity(IAudioPolicyCallback pcb, int userId) throws RemoteException {
            return 0;
        }

        @Override
        public boolean hasHapticChannels(Uri uri) throws RemoteException {
            return false;
        }

        @Override
        public boolean isCallScreeningModeSupported() throws RemoteException {
            return false;
        }

        @Override
        public int setPreferredDevicesForStrategy(int strategy, List<AudioDeviceAttributes> device) throws RemoteException {
            return 0;
        }

        @Override
        public int removePreferredDevicesForStrategy(int strategy) throws RemoteException {
            return 0;
        }

        @Override
        public List<AudioDeviceAttributes> getPreferredDevicesForStrategy(int strategy) throws RemoteException {
            return null;
        }

        @Override
        public List<AudioDeviceAttributes> getDevicesForAttributes(AudioAttributes attributes) throws RemoteException {
            return null;
        }

        @Override
        public List<AudioDeviceAttributes> getDevicesForAttributesUnprotected(AudioAttributes attributes) throws RemoteException {
            return null;
        }

        @Override
        public int setAllowedCapturePolicy(int capturePolicy) throws RemoteException {
            return 0;
        }

        @Override
        public int getAllowedCapturePolicy() throws RemoteException {
            return 0;
        }

        @Override
        public void registerStrategyPreferredDevicesDispatcher(IStrategyPreferredDevicesDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public void unregisterStrategyPreferredDevicesDispatcher(IStrategyPreferredDevicesDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public void setRttEnabled(boolean rttEnabled) throws RemoteException {
        }

        @Override
        public void setDeviceVolumeBehavior(AudioDeviceAttributes device, int deviceVolumeBehavior, String pkgName) throws RemoteException {
        }

        @Override
        public int getDeviceVolumeBehavior(AudioDeviceAttributes device) throws RemoteException {
            return 0;
        }

        @Override
        public void setMultiAudioFocusEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public int setPreferredDevicesForCapturePreset(int capturePreset, List<AudioDeviceAttributes> devices) throws RemoteException {
            return 0;
        }

        @Override
        public int clearPreferredDevicesForCapturePreset(int capturePreset) throws RemoteException {
            return 0;
        }

        @Override
        public List<AudioDeviceAttributes> getPreferredDevicesForCapturePreset(int capturePreset) throws RemoteException {
            return null;
        }

        @Override
        public void registerCapturePresetDevicesRoleDispatcher(ICapturePresetDevicesRoleDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public void unregisterCapturePresetDevicesRoleDispatcher(ICapturePresetDevicesRoleDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public void adjustStreamVolumeForUid(int streamType, int direction, int flags, String packageName, int uid, int pid, UserHandle userHandle, int targetSdkVersion) throws RemoteException {
        }

        @Override
        public void adjustSuggestedStreamVolumeForUid(int streamType, int direction, int flags, String packageName, int uid, int pid, UserHandle userHandle, int targetSdkVersion) throws RemoteException {
        }

        @Override
        public void setStreamVolumeForUid(int streamType, int direction, int flags, String packageName, int uid, int pid, UserHandle userHandle, int targetSdkVersion) throws RemoteException {
        }

        @Override
        public boolean isMusicActive(boolean remotely) throws RemoteException {
            return false;
        }

        @Override
        public int getDeviceMaskForStream(int streamType) throws RemoteException {
            return 0;
        }

        @Override
        public int[] getAvailableCommunicationDeviceIds() throws RemoteException {
            return null;
        }

        @Override
        public boolean setCommunicationDevice(IBinder cb, int portId) throws RemoteException {
            return false;
        }

        @Override
        public int getCommunicationDevice() throws RemoteException {
            return 0;
        }

        @Override
        public void registerCommunicationDeviceDispatcher(ICommunicationDeviceDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public void unregisterCommunicationDeviceDispatcher(ICommunicationDeviceDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public boolean areNavigationRepeatSoundEffectsEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void setNavigationRepeatSoundEffectsEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean isHomeSoundEffectEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void setHomeSoundEffectEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean setAdditionalOutputDeviceDelay(AudioDeviceAttributes device, long delayMillis) throws RemoteException {
            return false;
        }

        @Override
        public long getAdditionalOutputDeviceDelay(AudioDeviceAttributes device) throws RemoteException {
            return 0L;
        }

        @Override
        public long getMaxAdditionalOutputDeviceDelay(AudioDeviceAttributes device) throws RemoteException {
            return 0L;
        }

        @Override
        public int requestAudioFocusForTest(AudioAttributes aa, int durationHint, IBinder cb, IAudioFocusDispatcher fd, String clientId, String callingPackageName, int flags, int uid, int sdk) throws RemoteException {
            return 0;
        }

        @Override
        public int abandonAudioFocusForTest(IAudioFocusDispatcher fd, String clientId, AudioAttributes aa, String callingPackageName) throws RemoteException {
            return 0;
        }

        @Override
        public long getFadeOutDurationOnFocusLossMillis(AudioAttributes aa) throws RemoteException {
            return 0L;
        }

        @Override
        public void registerModeDispatcher(IAudioModeDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public void unregisterModeDispatcher(IAudioModeDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public int getSpatializerImmersiveAudioLevel() throws RemoteException {
            return 0;
        }

        @Override
        public boolean isSpatializerEnabled() throws RemoteException {
            return false;
        }

        @Override
        public boolean isSpatializerAvailable() throws RemoteException {
            return false;
        }

        @Override
        public boolean isSpatializerAvailableForDevice(AudioDeviceAttributes device) throws RemoteException {
            return false;
        }

        @Override
        public boolean hasHeadTracker(AudioDeviceAttributes device) throws RemoteException {
            return false;
        }

        @Override
        public void setHeadTrackerEnabled(boolean enabled, AudioDeviceAttributes device) throws RemoteException {
        }

        @Override
        public boolean isHeadTrackerEnabled(AudioDeviceAttributes device) throws RemoteException {
            return false;
        }

        @Override
        public boolean isHeadTrackerAvailable() throws RemoteException {
            return false;
        }

        @Override
        public void registerSpatializerHeadTrackerAvailableCallback(ISpatializerHeadTrackerAvailableCallback cb, boolean register) throws RemoteException {
        }

        @Override
        public void setSpatializerEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean canBeSpatialized(AudioAttributes aa, AudioFormat af) throws RemoteException {
            return false;
        }

        @Override
        public void registerSpatializerCallback(ISpatializerCallback cb) throws RemoteException {
        }

        @Override
        public void unregisterSpatializerCallback(ISpatializerCallback cb) throws RemoteException {
        }

        @Override
        public void registerSpatializerHeadTrackingCallback(ISpatializerHeadTrackingModeCallback cb) throws RemoteException {
        }

        @Override
        public void unregisterSpatializerHeadTrackingCallback(ISpatializerHeadTrackingModeCallback cb) throws RemoteException {
        }

        @Override
        public void registerHeadToSoundstagePoseCallback(ISpatializerHeadToSoundStagePoseCallback cb) throws RemoteException {
        }

        @Override
        public void unregisterHeadToSoundstagePoseCallback(ISpatializerHeadToSoundStagePoseCallback cb) throws RemoteException {
        }

        @Override
        public List<AudioDeviceAttributes> getSpatializerCompatibleAudioDevices() throws RemoteException {
            return null;
        }

        @Override
        public void addSpatializerCompatibleAudioDevice(AudioDeviceAttributes ada) throws RemoteException {
        }

        @Override
        public void removeSpatializerCompatibleAudioDevice(AudioDeviceAttributes ada) throws RemoteException {
        }

        @Override
        public void setDesiredHeadTrackingMode(int mode) throws RemoteException {
        }

        @Override
        public int getDesiredHeadTrackingMode() throws RemoteException {
            return 0;
        }

        @Override
        public int[] getSupportedHeadTrackingModes() throws RemoteException {
            return null;
        }

        @Override
        public int getActualHeadTrackingMode() throws RemoteException {
            return 0;
        }

        @Override
        public void setSpatializerGlobalTransform(float[] transform) throws RemoteException {
        }

        @Override
        public void recenterHeadTracker() throws RemoteException {
        }

        @Override
        public void setSpatializerParameter(int key, byte[] value) throws RemoteException {
        }

        @Override
        public void getSpatializerParameter(int key, byte[] value) throws RemoteException {
        }

        @Override
        public int getSpatializerOutput() throws RemoteException {
            return 0;
        }

        @Override
        public void registerSpatializerOutputCallback(ISpatializerOutputCallback cb) throws RemoteException {
        }

        @Override
        public void unregisterSpatializerOutputCallback(ISpatializerOutputCallback cb) throws RemoteException {
        }

        @Override
        public boolean isVolumeFixed() throws RemoteException {
            return false;
        }

        @Override
        public VolumeInfo getDefaultVolumeInfo() throws RemoteException {
            return null;
        }

        @Override
        public boolean isPstnCallAudioInterceptable() throws RemoteException {
            return false;
        }

        @Override
        public void muteAwaitConnection(int[] usagesToMute, AudioDeviceAttributes dev, long timeOutMs) throws RemoteException {
        }

        @Override
        public void cancelMuteAwaitConnection(AudioDeviceAttributes dev) throws RemoteException {
        }

        @Override
        public AudioDeviceAttributes getMutingExpectedDevice() throws RemoteException {
            return null;
        }

        @Override
        public void registerMuteAwaitConnectionDispatcher(IMuteAwaitConnectionCallback cb, boolean register) throws RemoteException {
        }

        @Override
        public void setTestDeviceConnectionState(AudioDeviceAttributes device, boolean connected) throws RemoteException {
        }

        @Override
        public void registerDeviceVolumeBehaviorDispatcher(boolean register, IDeviceVolumeBehaviorDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public List<AudioFocusInfo> getFocusStack() throws RemoteException {
            return null;
        }

        @Override
        public boolean sendFocusLoss(AudioFocusInfo focusLoser, IAudioPolicyCallback apcb) throws RemoteException {
            return false;
        }

        @Override
        public void addAssistantServicesUids(int[] assistantUID) throws RemoteException {
        }

        @Override
        public void removeAssistantServicesUids(int[] assistantUID) throws RemoteException {
        }

        @Override
        public void setActiveAssistantServiceUids(int[] activeUids) throws RemoteException {
        }

        @Override
        public int[] getAssistantServicesUids() throws RemoteException {
            return null;
        }

        @Override
        public int[] getActiveAssistantServiceUids() throws RemoteException {
            return null;
        }

        @Override
        public void registerDeviceVolumeDispatcherForAbsoluteVolume(boolean register, IAudioDeviceVolumeDispatcher cb, String packageName, AudioDeviceAttributes device, List<VolumeInfo> volumes, boolean handlesvolumeAdjustment) throws RemoteException {
        }

        @Override
        public String getHalVersion() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

