/*
 * Decompiled with CFR 0.152.
 */
package android.nearby;

import android.annotation.SystemApi;
import android.nearby.CredentialElement;
import android.nearby.PresenceCredential;
import android.net.connectivity.com.android.internal.util.Preconditions;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;

@SystemApi
public class PrivateCredential
extends PresenceCredential
implements Parcelable {
    public static final Parcelable.Creator<PrivateCredential> CREATOR = new Parcelable.Creator<PrivateCredential>(){

        @Override
        public PrivateCredential createFromParcel(Parcel in) {
            in.readInt();
            return PrivateCredential.createFromParcelBody(in);
        }

        public PrivateCredential[] newArray(int size) {
            return new PrivateCredential[size];
        }
    };
    private byte[] mMetadataEncryptionKey;
    private String mDeviceName;

    private PrivateCredential(Parcel in) {
        super(0, in);
        this.mMetadataEncryptionKey = new byte[in.readInt()];
        in.readByteArray(this.mMetadataEncryptionKey);
        this.mDeviceName = in.readString();
    }

    private PrivateCredential(int identityType, byte[] secretId, String deviceName, byte[] authenticityKey, List<CredentialElement> credentialElements, byte[] metadataEncryptionKey) {
        super(0, identityType, secretId, authenticityKey, credentialElements);
        this.mDeviceName = deviceName;
        this.mMetadataEncryptionKey = metadataEncryptionKey;
    }

    static PrivateCredential createFromParcelBody(Parcel in) {
        return new PrivateCredential(in);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.mMetadataEncryptionKey.length);
        dest.writeByteArray(this.mMetadataEncryptionKey);
        dest.writeString(this.mDeviceName);
    }

    public byte[] getMetadataEncryptionKey() {
        return this.mMetadataEncryptionKey;
    }

    public String getDeviceName() {
        return this.mDeviceName;
    }

    public static class Builder {
        private final List<CredentialElement> mCredentialElements;
        private int mIdentityType;
        private final byte[] mSecretId;
        private final byte[] mAuthenticityKey;
        private final byte[] mMetadataEncryptionKey;
        private final String mDeviceName;

        public Builder(byte[] secretId, byte[] authenticityKey, byte[] metadataEncryptionKey, String deviceName) {
            Preconditions.checkState(secretId != null && secretId.length > 0, "secret id cannot be empty");
            Preconditions.checkState(authenticityKey != null && authenticityKey.length > 0, "authenticity key cannot be empty");
            Preconditions.checkState(metadataEncryptionKey != null && metadataEncryptionKey.length > 0, "metadataEncryptionKey cannot be empty");
            Preconditions.checkState(deviceName != null && deviceName.length() > 0, "deviceName cannot be empty");
            this.mSecretId = secretId;
            this.mAuthenticityKey = authenticityKey;
            this.mMetadataEncryptionKey = metadataEncryptionKey;
            this.mDeviceName = deviceName;
            this.mCredentialElements = new ArrayList<CredentialElement>();
        }

        public Builder setIdentityType(int identityType) {
            this.mIdentityType = identityType;
            return this;
        }

        public Builder addCredentialElement(CredentialElement credentialElement) {
            this.mCredentialElements.add(credentialElement);
            return this;
        }

        public PrivateCredential build() {
            return new PrivateCredential(this.mIdentityType, this.mSecretId, this.mDeviceName, this.mAuthenticityKey, this.mCredentialElements, this.mMetadataEncryptionKey);
        }
    }
}

