/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.Network;
import android.net.QosFilter;
import android.net.QosSocketInfo;
import android.os.ParcelFileDescriptor;
import android.system.ErrnoException;
import android.system.Os;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import java.io.FileDescriptor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;

public class QosSocketFilter
extends QosFilter {
    private static final String TAG = QosSocketFilter.class.getSimpleName();
    private final QosSocketInfo mQosSocketInfo;

    public QosSocketFilter(QosSocketInfo qosSocketInfo) {
        Objects.requireNonNull(qosSocketInfo, "qosSocketInfo must be non-null");
        this.mQosSocketInfo = qosSocketInfo;
    }

    public QosSocketInfo getQosSocketInfo() {
        return this.mQosSocketInfo;
    }

    @Override
    public int validate() {
        InetSocketAddress sa = this.getAddressFromFileDescriptor();
        if (sa == null) {
            return 2;
        }
        if (!sa.equals(this.mQosSocketInfo.getLocalSocketAddress())) {
            return 4;
        }
        return 0;
    }

    private InetSocketAddress getAddressFromFileDescriptor() {
        SocketAddress address;
        ParcelFileDescriptor parcelFileDescriptor = this.mQosSocketInfo.getParcelFileDescriptor();
        if (parcelFileDescriptor == null) {
            return null;
        }
        FileDescriptor fd = parcelFileDescriptor.getFileDescriptor();
        if (fd == null) {
            return null;
        }
        try {
            address = Os.getsockname(fd);
        }
        catch (ErrnoException e) {
            Log.e(TAG, "getAddressFromFileDescriptor: getLocalAddress exception", e);
            return null;
        }
        if (address instanceof InetSocketAddress) {
            return (InetSocketAddress)address;
        }
        return null;
    }

    @Override
    public Network getNetwork() {
        return this.mQosSocketInfo.getNetwork();
    }

    @Override
    public boolean matchesLocalAddress(InetAddress address, int startPort, int endPort) {
        if (this.mQosSocketInfo.getLocalSocketAddress() == null) {
            return false;
        }
        return QosSocketFilter.matchesAddress(this.mQosSocketInfo.getLocalSocketAddress(), address, startPort, endPort);
    }

    @Override
    public boolean matchesRemoteAddress(InetAddress address, int startPort, int endPort) {
        if (this.mQosSocketInfo.getRemoteSocketAddress() == null) {
            return false;
        }
        return QosSocketFilter.matchesAddress(this.mQosSocketInfo.getRemoteSocketAddress(), address, startPort, endPort);
    }

    @VisibleForTesting
    public static boolean matchesAddress(InetSocketAddress filterSocketAddress, InetAddress address, int startPort, int endPort) {
        return startPort <= filterSocketAddress.getPort() && endPort >= filterSocketAddress.getPort() && filterSocketAddress.getAddress().equals(address);
    }
}

