/*
 * Decompiled with CFR 0.152.
 */
package android.net.ipsec.ike;

import android.net.InetAddresses;
import android.net.ipsec.ike.exceptions.InvalidSyntaxException;
import android.os.PersistableBundle;
import android.util.ArraySet;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Objects;

public class IkeTrafficSelector {
    @VisibleForTesting
    static final int IP_PROTOCOL_ID_UNSPEC = 0;
    @VisibleForTesting
    static final int IP_PROTOCOL_ID_ICMP = 1;
    @VisibleForTesting
    static final int IP_PROTOCOL_ID_TCP = 6;
    @VisibleForTesting
    static final int IP_PROTOCOL_ID_UDP = 17;
    private static final ArraySet<Integer> IP_PROTOCOL_ID_SET = new ArraySet();
    public static final int TRAFFIC_SELECTOR_TYPE_IPV4_ADDR_RANGE = 7;
    public static final int TRAFFIC_SELECTOR_TYPE_IPV6_ADDR_RANGE = 8;
    public static final int PORT_NUMBER_MIN = 0;
    public static final int PORT_NUMBER_MAX = 65535;
    private static final int IPV4_ADDR_LEN = 4;
    private static final int IPV6_ADDR_LEN = 16;
    @VisibleForTesting
    static final int TRAFFIC_SELECTOR_IPV4_LEN = 16;
    @VisibleForTesting
    static final int TRAFFIC_SELECTOR_IPV6_LEN = 40;
    private static final String START_PORT_KEY = "startPort";
    private static final String END_PORT_KEY = "endPort";
    private static final String START_ADDRESS_KEY = "startingAddress";
    private static final String END_ADDRESS_KEY = "endingAddress";
    public final int tsType;
    public final int ipProtocolId;
    public final int selectorLength;
    public final int startPort;
    public final int endPort;
    public final InetAddress startingAddress;
    public final InetAddress endingAddress;

    private IkeTrafficSelector(int tsType, int ipProtocolId, int selectorLength, int startPort, int endPort, InetAddress startingAddress, InetAddress endingAddress) {
        this.tsType = tsType;
        this.ipProtocolId = ipProtocolId;
        this.selectorLength = selectorLength;
        this.startPort = startPort;
        this.endPort = endPort;
        this.startingAddress = startingAddress;
        this.endingAddress = endingAddress;
    }

    public IkeTrafficSelector(int startPort, int endPort, InetAddress startingAddress, InetAddress endingAddress) {
        this(IkeTrafficSelector.getTsType(startingAddress), startPort, endPort, startingAddress, endingAddress);
    }

    private static int getTsType(InetAddress address) {
        if (address instanceof Inet4Address) {
            return 7;
        }
        return 8;
    }

    public IkeTrafficSelector(int tsType, int startPort, int endPort, InetAddress startingAddress, InetAddress endingAddress) {
        this.tsType = tsType;
        this.ipProtocolId = 0;
        switch (tsType) {
            case 7: {
                this.selectorLength = 16;
                if (startingAddress instanceof Inet4Address && endingAddress instanceof Inet4Address) break;
                throw new IllegalArgumentException("Invalid address range: TS_IPV4_ADDR_RANGE requires IPv4 addresses.");
            }
            case 8: {
                this.selectorLength = 40;
                if (startingAddress instanceof Inet6Address && endingAddress instanceof Inet6Address) break;
                throw new IllegalArgumentException("Invalid address range: TS_IPV6_ADDR_RANGE requires IPv6 addresses.");
            }
            default: {
                throw new IllegalArgumentException("Unrecognized Traffic Selector type.");
            }
        }
        if (IkeTrafficSelector.compareInetAddressTo(startingAddress, endingAddress) > 0) {
            throw new IllegalArgumentException("Received invalid address range.");
        }
        if (!IkeTrafficSelector.isPortRangeValid(startPort, endPort)) {
            throw new IllegalArgumentException("Invalid port range. startPort: " + startPort + " endPort: " + endPort);
        }
        this.startPort = startPort;
        this.endPort = endPort;
        this.startingAddress = startingAddress;
        this.endingAddress = endingAddress;
    }

    public static IkeTrafficSelector fromPersistableBundle(PersistableBundle in) {
        Objects.requireNonNull(in, "PersistableBundle not provided");
        int startPort = in.getInt(START_PORT_KEY);
        int endPort = in.getInt(END_PORT_KEY);
        InetAddress startingAddress = InetAddresses.parseNumericAddress(in.getString(START_ADDRESS_KEY));
        Objects.requireNonNull(in, "startAddress not provided");
        InetAddress endingAddress = InetAddresses.parseNumericAddress(in.getString(END_ADDRESS_KEY));
        Objects.requireNonNull(in, "endAddress not provided");
        return new IkeTrafficSelector(startPort, endPort, startingAddress, endingAddress);
    }

    public PersistableBundle toPersistableBundle() {
        PersistableBundle result = new PersistableBundle();
        result.putInt(START_PORT_KEY, this.startPort);
        result.putInt(END_PORT_KEY, this.endPort);
        result.putString(START_ADDRESS_KEY, this.startingAddress.getHostAddress());
        result.putString(END_ADDRESS_KEY, this.endingAddress.getHostAddress());
        return result;
    }

    public static IkeTrafficSelector[] decodeIkeTrafficSelectors(int numTs, byte[] tsBytes) throws InvalidSyntaxException {
        IkeTrafficSelector[] tsArray = new IkeTrafficSelector[numTs];
        ByteBuffer inputBuffer = ByteBuffer.wrap(tsBytes);
        try {
            block6: for (int i = 0; i < numTs; ++i) {
                int tsType = Byte.toUnsignedInt(inputBuffer.get());
                switch (tsType) {
                    case 7: {
                        tsArray[i] = IkeTrafficSelector.decodeTrafficSelector(inputBuffer, 7);
                        continue block6;
                    }
                    case 8: {
                        tsArray[i] = IkeTrafficSelector.decodeTrafficSelector(inputBuffer, 8);
                        continue block6;
                    }
                    default: {
                        throw new InvalidSyntaxException("Invalid Traffic Selector type: " + tsType);
                    }
                }
            }
        }
        catch (BufferOverflowException e) {
            throw new InvalidSyntaxException(e);
        }
        if (inputBuffer.remaining() != 0) {
            throw new InvalidSyntaxException("Unexpected trailing characters of Traffic Selectors.");
        }
        return tsArray;
    }

    private static IkeTrafficSelector decodeTrafficSelector(ByteBuffer inputBuffer, int tsType) throws InvalidSyntaxException {
        int endPort;
        int tsLength;
        int ipProtocolId = Byte.toUnsignedInt(inputBuffer.get());
        if (!IP_PROTOCOL_ID_SET.contains(ipProtocolId)) {
            throw new InvalidSyntaxException("Invalid IP Protocol ID.");
        }
        boolean isTsIpv4 = tsType == 7;
        int expectedTsLen = isTsIpv4 ? 16 : 40;
        if (expectedTsLen != (tsLength = Short.toUnsignedInt(inputBuffer.getShort()))) {
            throw new InvalidSyntaxException("Invalid Traffic Selector Length.");
        }
        int startPort = Short.toUnsignedInt(inputBuffer.getShort());
        if (!IkeTrafficSelector.isPortRangeValid(startPort, endPort = Short.toUnsignedInt(inputBuffer.getShort()))) {
            throw new InvalidSyntaxException("Received invalid port range. startPort: " + startPort + " endPort: " + endPort);
        }
        int expectedAddrLen = isTsIpv4 ? 4 : 16;
        byte[] startAddressBytes = new byte[expectedAddrLen];
        byte[] endAddressBytes = new byte[expectedAddrLen];
        inputBuffer.get(startAddressBytes);
        inputBuffer.get(endAddressBytes);
        try {
            InetAddress startAddress = InetAddress.getByAddress(startAddressBytes);
            InetAddress endAddress = InetAddress.getByAddress(endAddressBytes);
            boolean isStartAddrIpv4 = startAddress instanceof Inet4Address;
            boolean isEndAddrIpv4 = endAddress instanceof Inet4Address;
            if (isTsIpv4 != isStartAddrIpv4 || isTsIpv4 != isEndAddrIpv4) {
                throw new InvalidSyntaxException("Invalid IP address family");
            }
            if (IkeTrafficSelector.compareInetAddressTo(startAddress, endAddress) > 0) {
                throw new InvalidSyntaxException("Received invalid IP address range.");
            }
            return new IkeTrafficSelector(tsType, ipProtocolId, expectedTsLen, startPort, endPort, startAddress, endAddress);
        }
        catch (ClassCastException | IllegalArgumentException | UnknownHostException e) {
            throw new InvalidSyntaxException(e);
        }
    }

    private static boolean isPortRangeValid(int startPort, int endPort) {
        return startPort >= 0 && startPort <= 65535 && endPort >= 0 && endPort <= 65535 && startPort <= endPort;
    }

    private static int compareInetAddressTo(InetAddress leftAddress, InetAddress rightAddress) {
        byte[] rightAddrBytes;
        byte[] leftAddrBytes = leftAddress.getAddress();
        if (leftAddrBytes.length != (rightAddrBytes = rightAddress.getAddress()).length) {
            throw new IllegalArgumentException("Two addresses are different types.");
        }
        for (int i = 0; i < leftAddrBytes.length; ++i) {
            int unsignedByteRight;
            int unsignedByteLeft = Byte.toUnsignedInt(leftAddrBytes[i]);
            int result = Integer.compare(unsignedByteLeft, unsignedByteRight = Byte.toUnsignedInt(rightAddrBytes[i]));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public boolean contains(IkeTrafficSelector ts) {
        return this.tsType == ts.tsType && this.ipProtocolId == ts.ipProtocolId && this.startPort <= ts.startPort && this.endPort >= ts.endPort && IkeTrafficSelector.compareInetAddressTo(this.startingAddress, ts.startingAddress) <= 0 && IkeTrafficSelector.compareInetAddressTo(this.endingAddress, ts.endingAddress) >= 0;
    }

    public int hashCode() {
        return Objects.hash(this.tsType, this.ipProtocolId, this.selectorLength, this.startPort, this.endPort, this.startingAddress, this.endingAddress);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IkeTrafficSelector)) {
            return false;
        }
        IkeTrafficSelector other = (IkeTrafficSelector)o;
        if (this.tsType != other.tsType || this.ipProtocolId != other.ipProtocolId || this.startPort != other.startPort || this.endPort != other.endPort) {
            return false;
        }
        switch (this.tsType) {
            case 7: {
                return ((Inet4Address)this.startingAddress).equals((Inet4Address)other.startingAddress) && ((Inet4Address)this.endingAddress).equals((Inet4Address)other.endingAddress);
            }
            case 8: {
                return ((Inet6Address)this.startingAddress).equals((Inet6Address)other.startingAddress) && ((Inet6Address)this.endingAddress).equals((Inet6Address)other.endingAddress);
            }
        }
        throw new UnsupportedOperationException("Unrecognized TS type");
    }

    public void encodeToByteBuffer(ByteBuffer byteBuffer) {
        byteBuffer.put((byte)this.tsType).put((byte)this.ipProtocolId).putShort((short)this.selectorLength).putShort((short)this.startPort).putShort((short)this.endPort).put(this.startingAddress.getAddress()).put(this.endingAddress.getAddress());
    }

    static {
        IP_PROTOCOL_ID_SET.add(0);
        IP_PROTOCOL_ID_SET.add(1);
        IP_PROTOCOL_ID_SET.add(6);
        IP_PROTOCOL_ID_SET.add(17);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TrafficSelectorType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IpProtocolId {
    }
}

