/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IInterfaceCreationInfoCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.IInterfaceCreationInfoCallback";

    public void onResults(boolean var1, int[] var2, String[] var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInterfaceCreationInfoCallback {
        static final int TRANSACTION_onResults = 1;

        public Stub() {
            this.attachInterface(this, IInterfaceCreationInfoCallback.DESCRIPTOR);
        }

        public static IInterfaceCreationInfoCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IInterfaceCreationInfoCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IInterfaceCreationInfoCallback) {
                return (IInterfaceCreationInfoCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IInterfaceCreationInfoCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    boolean _arg0 = data.readBoolean();
                    int[] _arg1 = data.createIntArray();
                    String[] _arg2 = data.createStringArray();
                    this.onResults(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IInterfaceCreationInfoCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IInterfaceCreationInfoCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResults(boolean canCreate, int[] interfacesToDelete, String[] packagesForInterfaces) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInterfaceCreationInfoCallback.DESCRIPTOR);
                    _data.writeBoolean(canCreate);
                    _data.writeIntArray(interfacesToDelete);
                    _data.writeStringArray(packagesForInterfaces);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IInterfaceCreationInfoCallback {
        @Override
        public void onResults(boolean canCreate, int[] interfacesToDelete, String[] packagesForInterfaces) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

