/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.net.NetworkSpecifier;
import android.net.wifi.aware.DiscoverySession;
import android.net.wifi.aware.PeerHandle;
import android.net.wifi.aware.PublishDiscoverySession;
import android.net.wifi.aware.SubscribeDiscoverySession;
import android.net.wifi.aware.WifiAwareAgentNetworkSpecifier;
import android.net.wifi.aware.WifiAwareDataPathSecurityConfig;
import android.net.wifi.aware.WifiAwareUtils;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RequiresApi;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.util.Arrays;
import java.util.Objects;

public class WifiAwareNetworkSpecifier
extends NetworkSpecifier
implements Parcelable {
    public static final int NETWORK_SPECIFIER_TYPE_IB = 0;
    public static final int NETWORK_SPECIFIER_TYPE_IB_ANY_PEER = 1;
    public static final int NETWORK_SPECIFIER_TYPE_OOB = 2;
    public static final int NETWORK_SPECIFIER_TYPE_OOB_ANY_PEER = 3;
    public static final int NETWORK_SPECIFIER_TYPE_MAX_VALID = 3;
    public final int type;
    public final int role;
    public final int clientId;
    public final int sessionId;
    public final int peerId;
    public final byte[] peerMac;
    public final byte[] pmk;
    public final String passphrase;
    public final int port;
    public final int transportProtocol;
    private final int mChannelInMhz;
    private final boolean mForcedChannel;
    private final WifiAwareDataPathSecurityConfig mSecurityConfig;
    public static final Parcelable.Creator<WifiAwareNetworkSpecifier> CREATOR = new Parcelable.Creator<WifiAwareNetworkSpecifier>(){

        @Override
        public WifiAwareNetworkSpecifier createFromParcel(Parcel in) {
            return new WifiAwareNetworkSpecifier(in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.createByteArray(), in.readInt(), in.readInt(), in.readInt(), in.readBoolean(), (WifiAwareDataPathSecurityConfig)in.readParcelable(WifiAwareDataPathSecurityConfig.class.getClassLoader()));
        }

        public WifiAwareNetworkSpecifier[] newArray(int size) {
            return new WifiAwareNetworkSpecifier[size];
        }
    };

    public int getChannelFrequencyMhz() {
        return this.mChannelInMhz;
    }

    public boolean isChannelRequired() {
        return this.mForcedChannel;
    }

    public WifiAwareDataPathSecurityConfig getWifiAwareDataPathSecurityConfig() {
        return this.mSecurityConfig;
    }

    public WifiAwareNetworkSpecifier(int type, int role, int clientId, int sessionId, int peerId, byte[] peerMac, int port, int transportProtocol, int channel, boolean forcedChannel, WifiAwareDataPathSecurityConfig securityConfig) {
        this.type = type;
        this.role = role;
        this.clientId = clientId;
        this.sessionId = sessionId;
        this.peerId = peerId;
        this.peerMac = peerMac;
        this.port = port;
        this.transportProtocol = transportProtocol;
        this.mChannelInMhz = channel;
        this.mForcedChannel = forcedChannel;
        this.mSecurityConfig = securityConfig;
        this.passphrase = securityConfig == null ? null : securityConfig.getPskPassphrase();
        this.pmk = securityConfig == null ? null : securityConfig.getPmk();
    }

    public WifiAwareNetworkSpecifier(int type, int role, int clientId, int sessionId, int peerId, byte[] peerMac, byte[] pmk, String passphrase, int port, int transportProtocol) {
        this.type = type;
        this.role = role;
        this.clientId = clientId;
        this.sessionId = sessionId;
        this.peerId = peerId;
        this.peerMac = peerMac;
        this.port = port;
        this.transportProtocol = transportProtocol;
        this.mChannelInMhz = 0;
        this.mForcedChannel = false;
        this.pmk = pmk;
        this.passphrase = passphrase;
        this.mSecurityConfig = pmk != null || passphrase != null ? new WifiAwareDataPathSecurityConfig(1, pmk, null, passphrase) : null;
    }

    public boolean isOutOfBand() {
        return this.type == 2 || this.type == 3;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.type);
        dest.writeInt(this.role);
        dest.writeInt(this.clientId);
        dest.writeInt(this.sessionId);
        dest.writeInt(this.peerId);
        dest.writeByteArray(this.peerMac);
        dest.writeInt(this.port);
        dest.writeInt(this.transportProtocol);
        dest.writeInt(this.mChannelInMhz);
        dest.writeBoolean(this.mForcedChannel);
        dest.writeParcelable(this.mSecurityConfig, flags);
    }

    @Override
    public boolean canBeSatisfiedBy(NetworkSpecifier other) {
        if (other instanceof WifiAwareAgentNetworkSpecifier) {
            return ((WifiAwareAgentNetworkSpecifier)other).satisfiesAwareNetworkSpecifier(this);
        }
        return this.equals(other);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.role, this.clientId, this.sessionId, this.peerId, Arrays.hashCode(this.peerMac), this.port, this.transportProtocol, this.mChannelInMhz, this.mForcedChannel, this.mSecurityConfig);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WifiAwareNetworkSpecifier)) {
            return false;
        }
        WifiAwareNetworkSpecifier lhs = (WifiAwareNetworkSpecifier)obj;
        return this.type == lhs.type && this.role == lhs.role && this.clientId == lhs.clientId && this.sessionId == lhs.sessionId && this.peerId == lhs.peerId && Arrays.equals(this.peerMac, lhs.peerMac) && this.port == lhs.port && this.transportProtocol == lhs.transportProtocol && this.mChannelInMhz == lhs.mChannelInMhz && this.mForcedChannel == lhs.mForcedChannel && Objects.equals(this.mSecurityConfig, lhs.mSecurityConfig);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WifiAwareNetworkSpecifier [");
        sb.append("type=").append(this.type).append(", role=").append(this.role).append(", clientId=").append(this.clientId).append(", sessionId=").append(this.sessionId).append(", peerId=").append(this.peerId).append(", peerMac=").append(this.peerMac == null ? "<null>" : "<non-null>").append(", securityConfig=").append(this.mSecurityConfig).append(", port=").append(this.port).append(", transportProtocol=").append(this.transportProtocol).append(", channel=").append(this.mChannelInMhz).append(", forceChannel=").append(this.mForcedChannel).append("]");
        return sb.toString();
    }

    public static class Builder {
        private DiscoverySession mDiscoverySession;
        private PeerHandle mPeerHandle;
        private String mPskPassphrase;
        private byte[] mPmk;
        private int mPort = 0;
        private int mTransportProtocol = -1;
        private int mChannel = 0;
        private boolean mIsRequired = false;
        private WifiAwareDataPathSecurityConfig mSecurityConfig;

        public Builder(DiscoverySession discoverySession, PeerHandle peerHandle) {
            if (discoverySession == null) {
                throw new IllegalArgumentException("Non-null discoverySession required");
            }
            if (peerHandle == null) {
                throw new IllegalArgumentException("Non-null peerHandle required");
            }
            this.mDiscoverySession = discoverySession;
            this.mPeerHandle = peerHandle;
        }

        @RequiresApi(value=31)
        public Builder(PublishDiscoverySession publishDiscoverySession) {
            if (!SdkLevel.isAtLeastS()) {
                throw new UnsupportedOperationException();
            }
            if (publishDiscoverySession == null) {
                throw new IllegalArgumentException("Non-null publishDiscoverySession required");
            }
            this.mDiscoverySession = publishDiscoverySession;
            this.mPeerHandle = null;
        }

        public Builder setPskPassphrase(String pskPassphrase) {
            if (!WifiAwareUtils.validatePassphrase(pskPassphrase)) {
                throw new IllegalArgumentException("Passphrase must meet length requirements");
            }
            this.mPskPassphrase = pskPassphrase;
            return this;
        }

        public Builder setPmk(byte[] pmk) {
            if (!WifiAwareUtils.validatePmk(pmk)) {
                throw new IllegalArgumentException("PMK must 32 bytes");
            }
            this.mPmk = pmk;
            return this;
        }

        public Builder setPort(int port) {
            if (port <= 0 || port > 65535) {
                throw new IllegalArgumentException("The port must be a positive value (0, 65535]");
            }
            this.mPort = port;
            return this;
        }

        public Builder setTransportProtocol(int transportProtocol) {
            if (transportProtocol < 0 || transportProtocol > 255) {
                throw new IllegalArgumentException("The transport protocol must be in range [0, 255]");
            }
            this.mTransportProtocol = transportProtocol;
            return this;
        }

        public Builder setChannelFrequencyMhz(int channelInMhz, boolean required) {
            this.mChannel = channelInMhz;
            this.mIsRequired = required;
            return this;
        }

        public Builder setDataPathSecurityConfig(WifiAwareDataPathSecurityConfig securityConfig) {
            if (securityConfig == null) {
                throw new IllegalArgumentException("The WifiAwareDataPathSecurityConfig should be non-null");
            }
            if (!securityConfig.isValid()) {
                throw new IllegalArgumentException("The WifiAwareDataPathSecurityConfig is invalid");
            }
            this.mSecurityConfig = securityConfig;
            return this;
        }

        public WifiAwareNetworkSpecifier build() {
            int role;
            if (this.mDiscoverySession == null) {
                throw new IllegalStateException("Null discovery session!?");
            }
            if (this.mPskPassphrase != null && this.mPmk != null) {
                throw new IllegalStateException("Can only specify a Passphrase or a PMK - not both!");
            }
            WifiAwareDataPathSecurityConfig securityConfig = this.mSecurityConfig;
            if (this.mPskPassphrase != null || this.mPmk != null) {
                if (securityConfig != null) {
                    throw new IllegalStateException("Can only specify a SecurityConfig or a PMK(Passphrase) - not both!");
                }
                securityConfig = new WifiAwareDataPathSecurityConfig(1, this.mPmk, null, this.mPskPassphrase);
            }
            int n = role = this.mDiscoverySession instanceof SubscribeDiscoverySession ? 0 : 1;
            if (this.mPort != 0 || this.mTransportProtocol != -1) {
                if (role != 1) {
                    throw new IllegalStateException("Port and transport protocol information can only be specified on the Publisher device (which is the server");
                }
                if (securityConfig == null) {
                    throw new IllegalStateException("Port and transport protocol information can only be specified on a secure link");
                }
            }
            int type = this.mPeerHandle == null ? 1 : 0;
            return new WifiAwareNetworkSpecifier(type, role, this.mDiscoverySession.mClientId, this.mDiscoverySession.mSessionId, this.mPeerHandle != null ? this.mPeerHandle.peerId : 0, null, this.mPort, this.mTransportProtocol, this.mChannel, this.mIsRequired, securityConfig);
        }
    }
}

