/*
 * Decompiled with CFR 0.152.
 */
package android.permission;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ILegacyPermissionManager
extends IInterface {
    public static final String DESCRIPTOR = "android.permission.ILegacyPermissionManager";

    public int checkDeviceIdentifierAccess(String var1, String var2, String var3, int var4, int var5) throws RemoteException;

    public int checkPhoneNumberAccess(String var1, String var2, String var3, int var4, int var5) throws RemoteException;

    public void grantDefaultPermissionsToEnabledCarrierApps(String[] var1, int var2) throws RemoteException;

    public void grantDefaultPermissionsToEnabledImsServices(String[] var1, int var2) throws RemoteException;

    public void grantDefaultPermissionsToEnabledTelephonyDataServices(String[] var1, int var2) throws RemoteException;

    public void revokeDefaultPermissionsFromDisabledTelephonyDataServices(String[] var1, int var2) throws RemoteException;

    public void grantDefaultPermissionsToActiveLuiApp(String var1, int var2) throws RemoteException;

    public void revokeDefaultPermissionsFromLuiApps(String[] var1, int var2) throws RemoteException;

    public void grantDefaultPermissionsToCarrierServiceApp(String var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILegacyPermissionManager {
        static final int TRANSACTION_checkDeviceIdentifierAccess = 1;
        static final int TRANSACTION_checkPhoneNumberAccess = 2;
        static final int TRANSACTION_grantDefaultPermissionsToEnabledCarrierApps = 3;
        static final int TRANSACTION_grantDefaultPermissionsToEnabledImsServices = 4;
        static final int TRANSACTION_grantDefaultPermissionsToEnabledTelephonyDataServices = 5;
        static final int TRANSACTION_revokeDefaultPermissionsFromDisabledTelephonyDataServices = 6;
        static final int TRANSACTION_grantDefaultPermissionsToActiveLuiApp = 7;
        static final int TRANSACTION_revokeDefaultPermissionsFromLuiApps = 8;
        static final int TRANSACTION_grantDefaultPermissionsToCarrierServiceApp = 9;

        public Stub() {
            this.attachInterface(this, ILegacyPermissionManager.DESCRIPTOR);
        }

        public static ILegacyPermissionManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ILegacyPermissionManager.DESCRIPTOR);
            if (iin != null && iin instanceof ILegacyPermissionManager) {
                return (ILegacyPermissionManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "checkDeviceIdentifierAccess";
                }
                case 2: {
                    return "checkPhoneNumberAccess";
                }
                case 3: {
                    return "grantDefaultPermissionsToEnabledCarrierApps";
                }
                case 4: {
                    return "grantDefaultPermissionsToEnabledImsServices";
                }
                case 5: {
                    return "grantDefaultPermissionsToEnabledTelephonyDataServices";
                }
                case 6: {
                    return "revokeDefaultPermissionsFromDisabledTelephonyDataServices";
                }
                case 7: {
                    return "grantDefaultPermissionsToActiveLuiApp";
                }
                case 8: {
                    return "revokeDefaultPermissionsFromLuiApps";
                }
                case 9: {
                    return "grantDefaultPermissionsToCarrierServiceApp";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ILegacyPermissionManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.checkDeviceIdentifierAccess(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.checkPhoneNumberAccess(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 3: {
                    String[] _arg0 = data.createStringArray();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.grantDefaultPermissionsToEnabledCarrierApps(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    String[] _arg0 = data.createStringArray();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.grantDefaultPermissionsToEnabledImsServices(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    String[] _arg0 = data.createStringArray();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.grantDefaultPermissionsToEnabledTelephonyDataServices(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    String[] _arg0 = data.createStringArray();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.revokeDefaultPermissionsFromDisabledTelephonyDataServices(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.grantDefaultPermissionsToActiveLuiApp(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    String[] _arg0 = data.createStringArray();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.revokeDefaultPermissionsFromLuiApps(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.grantDefaultPermissionsToCarrierServiceApp(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 8;
        }

        private static class Proxy
        implements ILegacyPermissionManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ILegacyPermissionManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int checkDeviceIdentifierAccess(String packageName, String message, String callingFeatureId, int pid, int uid) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILegacyPermissionManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(message);
                    _data.writeString(callingFeatureId);
                    _data.writeInt(pid);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int checkPhoneNumberAccess(String packageName, String message, String callingFeatureId, int pid, int uid) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILegacyPermissionManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(message);
                    _data.writeString(callingFeatureId);
                    _data.writeInt(pid);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void grantDefaultPermissionsToEnabledCarrierApps(String[] packageNames, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILegacyPermissionManager.DESCRIPTOR);
                    _data.writeStringArray(packageNames);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void grantDefaultPermissionsToEnabledImsServices(String[] packageNames, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILegacyPermissionManager.DESCRIPTOR);
                    _data.writeStringArray(packageNames);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void grantDefaultPermissionsToEnabledTelephonyDataServices(String[] packageNames, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILegacyPermissionManager.DESCRIPTOR);
                    _data.writeStringArray(packageNames);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void revokeDefaultPermissionsFromDisabledTelephonyDataServices(String[] packageNames, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILegacyPermissionManager.DESCRIPTOR);
                    _data.writeStringArray(packageNames);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void grantDefaultPermissionsToActiveLuiApp(String packageName, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILegacyPermissionManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void revokeDefaultPermissionsFromLuiApps(String[] packageNames, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILegacyPermissionManager.DESCRIPTOR);
                    _data.writeStringArray(packageNames);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void grantDefaultPermissionsToCarrierServiceApp(String packageName, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILegacyPermissionManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ILegacyPermissionManager {
        @Override
        public int checkDeviceIdentifierAccess(String packageName, String message, String callingFeatureId, int pid, int uid) throws RemoteException {
            return 0;
        }

        @Override
        public int checkPhoneNumberAccess(String packageName, String message, String callingFeatureId, int pid, int uid) throws RemoteException {
            return 0;
        }

        @Override
        public void grantDefaultPermissionsToEnabledCarrierApps(String[] packageNames, int userId) throws RemoteException {
        }

        @Override
        public void grantDefaultPermissionsToEnabledImsServices(String[] packageNames, int userId) throws RemoteException {
        }

        @Override
        public void grantDefaultPermissionsToEnabledTelephonyDataServices(String[] packageNames, int userId) throws RemoteException {
        }

        @Override
        public void revokeDefaultPermissionsFromDisabledTelephonyDataServices(String[] packageNames, int userId) throws RemoteException {
        }

        @Override
        public void grantDefaultPermissionsToActiveLuiApp(String packageName, int userId) throws RemoteException {
        }

        @Override
        public void revokeDefaultPermissionsFromLuiApps(String[] packageNames, int userId) throws RemoteException {
        }

        @Override
        public void grantDefaultPermissionsToCarrierServiceApp(String packageName, int userId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

