/*
 * Decompiled with CFR 0.152.
 */
package android.permission;

import android.content.AttributionSourceState;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IPermissionChecker
extends IInterface {
    public static final String DESCRIPTOR = "android$permission$IPermissionChecker".replace('$', '.');
    public static final int PERMISSION_GRANTED = 0;
    public static final int PERMISSION_SOFT_DENIED = 1;
    public static final int PERMISSION_HARD_DENIED = 2;

    public int checkPermission(String var1, AttributionSourceState var2, String var3, boolean var4, boolean var5, boolean var6, int var7) throws RemoteException;

    public void finishDataDelivery(int var1, AttributionSourceState var2, boolean var3) throws RemoteException;

    public int checkOp(int var1, AttributionSourceState var2, String var3, boolean var4, boolean var5) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPermissionChecker {
        static final int TRANSACTION_checkPermission = 1;
        static final int TRANSACTION_finishDataDelivery = 2;
        static final int TRANSACTION_checkOp = 3;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IPermissionChecker asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IPermissionChecker) {
                return (IPermissionChecker)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    AttributionSourceState _arg1 = data.readTypedObject(AttributionSourceState.CREATOR);
                    String _arg2 = data.readString();
                    boolean _arg3 = data.readBoolean();
                    boolean _arg4 = data.readBoolean();
                    boolean _arg5 = data.readBoolean();
                    int _arg6 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.checkPermission(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    AttributionSourceState _arg1 = data.readTypedObject(AttributionSourceState.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.finishDataDelivery(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    AttributionSourceState _arg1 = data.readTypedObject(AttributionSourceState.CREATOR);
                    String _arg2 = data.readString();
                    boolean _arg3 = data.readBoolean();
                    boolean _arg4 = data.readBoolean();
                    data.enforceNoDataAvail();
                    int _result = this.checkOp(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IPermissionChecker {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int checkPermission(String permission2, AttributionSourceState attributionSource, String message, boolean forDataDelivery, boolean startDataDelivery, boolean fromDatasource, int attributedOp) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeString(permission2);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeString(message);
                    _data.writeBoolean(forDataDelivery);
                    _data.writeBoolean(startDataDelivery);
                    _data.writeBoolean(fromDatasource);
                    _data.writeInt(attributedOp);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finishDataDelivery(int op, AttributionSourceState attributionSource, boolean fromDatasource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(op);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeBoolean(fromDatasource);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int checkOp(int op, AttributionSourceState attributionSource, String message, boolean forDataDelivery, boolean startDataDelivery) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(op);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeString(message);
                    _data.writeBoolean(forDataDelivery);
                    _data.writeBoolean(startDataDelivery);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IPermissionChecker {
        @Override
        public int checkPermission(String permission2, AttributionSourceState attributionSource, String message, boolean forDataDelivery, boolean startDataDelivery, boolean fromDatasource, int attributedOp) throws RemoteException {
            return 0;
        }

        @Override
        public void finishDataDelivery(int op, AttributionSourceState attributionSource, boolean fromDatasource) throws RemoteException {
        }

        @Override
        public int checkOp(int op, AttributionSourceState attributionSource, String message, boolean forDataDelivery, boolean startDataDelivery) throws RemoteException {
            return 0;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

