/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore2;

import android.security.KeyStoreSecurityLevel;
import android.security.keystore2.AndroidKeyStorePrivateKey;
import android.security.keystore2.AndroidKeyStorePublicKey;
import android.security.keystore2.AndroidKeyStoreRSAPrivateKey;
import android.system.keystore2.KeyDescriptor;
import android.system.keystore2.KeyMetadata;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;

public class AndroidKeyStoreRSAPublicKey
extends AndroidKeyStorePublicKey
implements RSAPublicKey {
    private final BigInteger mModulus;
    private final BigInteger mPublicExponent;

    public AndroidKeyStoreRSAPublicKey(KeyDescriptor descriptor, KeyMetadata metadata, byte[] x509EncodedForm, KeyStoreSecurityLevel securityLevel, BigInteger modulus, BigInteger publicExponent) {
        super(descriptor, metadata, x509EncodedForm, "RSA", securityLevel);
        this.mModulus = modulus;
        this.mPublicExponent = publicExponent;
    }

    public AndroidKeyStoreRSAPublicKey(KeyDescriptor descriptor, KeyMetadata metadata, KeyStoreSecurityLevel securityLevel, RSAPublicKey info) {
        this(descriptor, metadata, info.getEncoded(), securityLevel, info.getModulus(), info.getPublicExponent());
        if (!"X.509".equalsIgnoreCase(info.getFormat())) {
            throw new IllegalArgumentException("Unsupported key export format: " + info.getFormat());
        }
    }

    @Override
    public AndroidKeyStorePrivateKey getPrivateKey() {
        return new AndroidKeyStoreRSAPrivateKey(this.getUserKeyDescriptor(), this.getKeyIdDescriptor().nspace, this.getAuthorizations(), this.getSecurityLevel(), this.mModulus);
    }

    @Override
    public BigInteger getModulus() {
        return this.mModulus;
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.mPublicExponent;
    }
}

