/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.data;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TrafficDescriptor
implements Parcelable {
    private final String mDnn;
    private final OsAppId mOsAppId;
    public static final Parcelable.Creator<TrafficDescriptor> CREATOR = new Parcelable.Creator<TrafficDescriptor>(){

        @Override
        public TrafficDescriptor createFromParcel(Parcel source) {
            return new TrafficDescriptor(source);
        }

        public TrafficDescriptor[] newArray(int size) {
            return new TrafficDescriptor[size];
        }
    };

    private TrafficDescriptor(Parcel in) {
        this.mDnn = in.readString();
        byte[] osAppIdBytes = in.createByteArray();
        OsAppId osAppId = null;
        if (osAppIdBytes != null) {
            osAppId = new OsAppId(osAppIdBytes);
        }
        this.mOsAppId = osAppId;
        this.enforceAllowedIds();
    }

    public TrafficDescriptor(String dnn, byte[] osAppIdRawBytes) {
        this.mDnn = dnn;
        OsAppId osAppId = null;
        if (osAppIdRawBytes != null) {
            osAppId = new OsAppId(osAppIdRawBytes);
        }
        this.mOsAppId = osAppId;
        this.enforceAllowedIds();
    }

    private void enforceAllowedIds() {
        if (this.mOsAppId != null && !this.mOsAppId.getOsId().equals(OsAppId.ANDROID_OS_ID)) {
            throw new IllegalArgumentException("OS id " + this.mOsAppId.getOsId() + " does not match " + OsAppId.ANDROID_OS_ID);
        }
        if (this.mOsAppId != null && !OsAppId.ALLOWED_APP_IDS.contains(this.mOsAppId.getAppId())) {
            throw new IllegalArgumentException("Illegal app id " + this.mOsAppId.getAppId() + ". Only allowing one of the following " + OsAppId.ALLOWED_APP_IDS);
        }
    }

    public String getDataNetworkName() {
        return this.mDnn;
    }

    public byte[] getOsAppId() {
        return this.mOsAppId != null ? this.mOsAppId.getBytes() : null;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "TrafficDescriptor={mDnn=" + this.mDnn + ", " + this.mOsAppId + "}";
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mDnn);
        dest.writeByteArray(this.mOsAppId != null ? this.mOsAppId.getBytes() : null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrafficDescriptor that = (TrafficDescriptor)o;
        return Objects.equals(this.mDnn, that.mDnn) && Objects.equals(this.mOsAppId, that.mOsAppId);
    }

    public int hashCode() {
        return Objects.hash(this.mDnn, this.mOsAppId);
    }

    public static class Builder {
        private String mDnn = null;
        private byte[] mOsAppId = null;

        public Builder setDataNetworkName(String dnn) {
            this.mDnn = dnn;
            return this;
        }

        public Builder setOsAppId(byte[] osAppId) {
            this.mOsAppId = osAppId;
            return this;
        }

        public TrafficDescriptor build() {
            if (this.mDnn == null && this.mOsAppId == null) {
                throw new IllegalArgumentException("DNN and OS App ID are null");
            }
            return new TrafficDescriptor(this.mDnn, this.mOsAppId);
        }
    }

    public static class OsAppId {
        public static final UUID ANDROID_OS_ID = UUID.fromString("97a498e3-fc92-5c94-8986-0333d06e4e47");
        private static final Set<String> ALLOWED_APP_IDS = Set.of("ENTERPRISE", "PRIORITIZE_LATENCY", "PRIORITIZE_BANDWIDTH", "CBS");
        private final UUID mOsId;
        private final String mAppId;
        private final int mDifferentiator;

        public OsAppId(UUID osId, String appId) {
            this(osId, appId, 1);
        }

        public OsAppId(UUID osId, String appId, int differentiator) {
            Objects.requireNonNull(osId);
            Objects.requireNonNull(appId);
            if (differentiator < 1) {
                throw new IllegalArgumentException("Invalid differentiator " + differentiator);
            }
            this.mOsId = osId;
            this.mAppId = appId;
            this.mDifferentiator = differentiator;
        }

        public OsAppId(byte[] rawOsAppId) {
            try {
                ByteBuffer bb = ByteBuffer.wrap(rawOsAppId);
                this.mOsId = new UUID(bb.getLong(), bb.getLong());
                byte appIdLen = bb.get();
                byte[] appIdAndDifferentiator = new byte[appIdLen];
                bb.get(appIdAndDifferentiator, 0, appIdLen);
                String appIdAndDifferentiatorStr = new String(appIdAndDifferentiator);
                Pattern pattern = Pattern.compile("[^0-9]+([0-9]+)$");
                Matcher matcher = pattern.matcher(new String(appIdAndDifferentiator));
                if (matcher.find()) {
                    this.mDifferentiator = Integer.parseInt(matcher.group(1));
                    this.mAppId = appIdAndDifferentiatorStr.replace(matcher.group(1), "");
                } else {
                    this.mDifferentiator = 1;
                    this.mAppId = appIdAndDifferentiatorStr;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to decode " + (rawOsAppId != null ? new BigInteger(1, rawOsAppId).toString(16) : null));
            }
        }

        public UUID getOsId() {
            return this.mOsId;
        }

        public String getAppId() {
            return this.mAppId;
        }

        public int getDifferentiator() {
            return this.mDifferentiator;
        }

        public byte[] getBytes() {
            byte[] osAppId = (this.mAppId + (this.mDifferentiator > 1 ? Integer.valueOf(this.mDifferentiator) : "")).getBytes();
            ByteBuffer bb = ByteBuffer.allocate(17 + osAppId.length);
            bb.putLong(this.mOsId.getMostSignificantBits());
            bb.putLong(this.mOsId.getLeastSignificantBits());
            bb.put((byte)osAppId.length);
            bb.put(osAppId);
            return bb.array();
        }

        public String toString() {
            return "[OsAppId: OS=" + this.mOsId + ", App=" + this.mAppId + ", differentiator=" + this.mDifferentiator + ", raw=" + new BigInteger(1, this.getBytes()).toString(16) + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OsAppId osAppId = (OsAppId)o;
            return this.mDifferentiator == osAppId.mDifferentiator && this.mOsId.equals(osAppId.mOsId) && this.mAppId.equals(osAppId.mAppId);
        }

        public int hashCode() {
            return Objects.hash(this.mOsId, this.mAppId, this.mDifferentiator);
        }
    }
}

