/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.graphics.BLASTBufferQueue;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PixelFormat;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.RenderNode;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.SystemClock;
import android.util.ArraySet;
import android.util.AttributeSet;
import android.util.Log;
import android.view.RemoteAccessibilityController;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.SurfaceControlViewHost;
import android.view.SurfaceHolder;
import android.view.SurfaceSession;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.IAccessibilityEmbeddedConnection;
import android.window.SurfaceSyncer;
import com.android.internal.view.SurfaceCallbackHelper;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;

public class _Original_SurfaceView
extends View
implements ViewRootImpl.SurfaceChangedCallback {
    private static final String TAG = "SurfaceView";
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_POSITION = false;
    @UnsupportedAppUsage
    final ArrayList<SurfaceHolder.Callback> mCallbacks = new ArrayList();
    final int[] mLocation = new int[2];
    @UnsupportedAppUsage
    final ReentrantLock mSurfaceLock = new ReentrantLock();
    @UnsupportedAppUsage
    final Surface mSurface = new Surface();
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    boolean mDrawingStopped = true;
    boolean mDrawFinished = false;
    final Rect mScreenRect = new Rect();
    private final SurfaceSession mSurfaceSession = new SurfaceSession();
    SurfaceControl mSurfaceControl;
    SurfaceControl mBackgroundControl;
    private boolean mDisableBackgroundLayer = false;
    final Object mSurfaceControlLock = new Object();
    final Rect mTmpRect = new Rect();
    Paint mRoundedViewportPaint;
    int mSubLayer = -2;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    boolean mIsCreating = false;
    private final ViewTreeObserver.OnScrollChangedListener mScrollChangedListener = (ViewTreeObserver.OnScrollChangedListener)LambdaMetafactory.metafactory(null, null, null, ()V, updateSurface(), ()V)((SurfaceView)((Object)this));
    @UnsupportedAppUsage
    private final ViewTreeObserver.OnPreDrawListener mDrawListener = (ViewTreeObserver.OnPreDrawListener)LambdaMetafactory.metafactory(null, null, null, ()Z, lambda$new$0(), ()Z)((SurfaceView)((Object)this));
    boolean mRequestedVisible = false;
    boolean mWindowVisibility = false;
    boolean mLastWindowVisibility = false;
    boolean mViewVisibility = false;
    boolean mWindowStopped = false;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    int mRequestedWidth = -1;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    int mRequestedHeight = -1;
    @UnsupportedAppUsage
    int mRequestedFormat = 4;
    boolean mUseAlpha = false;
    float mSurfaceAlpha = 1.0f;
    boolean mClipSurfaceToBounds;
    int mBackgroundColor = -16777216;
    @UnsupportedAppUsage
    boolean mHaveFrame = false;
    boolean mSurfaceCreated = false;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    long mLastLockTime = 0L;
    boolean mVisible = false;
    int mWindowSpaceLeft = -1;
    int mWindowSpaceTop = -1;
    int mSurfaceWidth = -1;
    int mSurfaceHeight = -1;
    float mCornerRadius;
    @UnsupportedAppUsage
    int mFormat = -1;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    final Rect mSurfaceFrame = new Rect();
    int mLastSurfaceWidth = -1;
    int mLastSurfaceHeight = -1;
    int mTransformHint = 0;
    private boolean mGlobalListenersAdded;
    private boolean mAttachedToWindow;
    private int mSurfaceFlags = 4;
    private final SurfaceSyncer mSurfaceSyncer = new SurfaceSyncer();
    private final ArraySet<Integer> mSyncIds = new ArraySet();
    private final SurfaceControl.Transaction mRtTransaction = new SurfaceControl.Transaction();
    private final SurfaceControl.Transaction mFrameCallbackTransaction = new SurfaceControl.Transaction();
    private int mParentSurfaceSequenceId;
    private RemoteAccessibilityController mRemoteAccessibilityController = new RemoteAccessibilityController(this);
    private final Matrix mTmpMatrix = new Matrix();
    SurfaceControlViewHost.SurfacePackage mSurfacePackage;
    private SurfaceControl mBlastSurfaceControl;
    private BLASTBufferQueue mBlastBufferQueue;
    private final Rect mRTLastReportedPosition = new Rect();
    private final Point mRTLastReportedSurfaceSize = new Point();
    private SurfaceViewPositionUpdateListener mPositionListener = null;
    @UnsupportedAppUsage
    private final SurfaceHolder mSurfaceHolder = new SurfaceHolder(){
        private static final String LOG_TAG = "SurfaceHolder";

        @Override
        public boolean isCreating() {
            return _Original_SurfaceView.this.mIsCreating;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addCallback(SurfaceHolder.Callback callback) {
            ArrayList<SurfaceHolder.Callback> arrayList = _Original_SurfaceView.this.mCallbacks;
            synchronized (arrayList) {
                if (!_Original_SurfaceView.this.mCallbacks.contains(callback)) {
                    _Original_SurfaceView.this.mCallbacks.add(callback);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeCallback(SurfaceHolder.Callback callback) {
            ArrayList<SurfaceHolder.Callback> arrayList = _Original_SurfaceView.this.mCallbacks;
            synchronized (arrayList) {
                _Original_SurfaceView.this.mCallbacks.remove(callback);
            }
        }

        @Override
        public void setFixedSize(int width, int height) {
            if (_Original_SurfaceView.this.mRequestedWidth != width || _Original_SurfaceView.this.mRequestedHeight != height) {
                _Original_SurfaceView.this.mRequestedWidth = width;
                _Original_SurfaceView.this.mRequestedHeight = height;
                _Original_SurfaceView.this.requestLayout();
            }
        }

        @Override
        public void setSizeFromLayout() {
            if (_Original_SurfaceView.this.mRequestedWidth != -1 || _Original_SurfaceView.this.mRequestedHeight != -1) {
                _Original_SurfaceView.this.mRequestedHeight = -1;
                _Original_SurfaceView.this.mRequestedWidth = -1;
                _Original_SurfaceView.this.requestLayout();
            }
        }

        @Override
        public void setFormat(int format) {
            if (format == -1) {
                format = 4;
            }
            _Original_SurfaceView.this.mRequestedFormat = format;
            if (_Original_SurfaceView.this.mSurfaceControl != null) {
                _Original_SurfaceView.this.updateSurface();
            }
        }

        @Override
        @Deprecated
        public void setType(int type) {
        }

        @Override
        public void setKeepScreenOn(boolean screenOn) {
            _Original_SurfaceView.this.runOnUiThread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$setKeepScreenOn$0(boolean ), ()V)((Object)this, (boolean)screenOn));
        }

        @Override
        public Canvas lockCanvas() {
            return this.internalLockCanvas(null, false);
        }

        @Override
        public Canvas lockCanvas(Rect inOutDirty) {
            return this.internalLockCanvas(inOutDirty, false);
        }

        @Override
        public Canvas lockHardwareCanvas() {
            return this.internalLockCanvas(null, true);
        }

        private Canvas internalLockCanvas(Rect dirty, boolean hardware) {
            _Original_SurfaceView.this.mSurfaceLock.lock();
            Canvas c = null;
            if (!_Original_SurfaceView.this.mDrawingStopped && _Original_SurfaceView.this.mSurfaceControl != null) {
                try {
                    c = hardware ? _Original_SurfaceView.this.mSurface.lockHardwareCanvas() : _Original_SurfaceView.this.mSurface.lockCanvas(dirty);
                }
                catch (Exception e) {
                    Log.e(LOG_TAG, "Exception locking surface", e);
                }
            }
            if (c != null) {
                _Original_SurfaceView.this.mLastLockTime = SystemClock.uptimeMillis();
                return c;
            }
            long nextTime = _Original_SurfaceView.this.mLastLockTime + 100L;
            long now = SystemClock.uptimeMillis();
            if (nextTime > now) {
                try {
                    Thread.sleep(nextTime - now);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                now = SystemClock.uptimeMillis();
            }
            _Original_SurfaceView.this.mLastLockTime = now;
            _Original_SurfaceView.this.mSurfaceLock.unlock();
            return null;
        }

        @Override
        public void unlockCanvasAndPost(Canvas canvas) {
            _Original_SurfaceView.this.mSurface.unlockCanvasAndPost(canvas);
            _Original_SurfaceView.this.mSurfaceLock.unlock();
        }

        @Override
        public Surface getSurface() {
            return _Original_SurfaceView.this.mSurface;
        }

        @Override
        public Rect getSurfaceFrame() {
            return _Original_SurfaceView.this.mSurfaceFrame;
        }

        private /* synthetic */ void lambda$setKeepScreenOn$0(boolean screenOn) {
            _Original_SurfaceView.this.setKeepScreenOn(screenOn);
        }
    };

    public _Original_SurfaceView(Context context) {
        this(context, null);
    }

    public _Original_SurfaceView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public _Original_SurfaceView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public _Original_SurfaceView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this(context, attrs, defStyleAttr, defStyleRes, false);
    }

    public _Original_SurfaceView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes, boolean disableBackgroundLayer) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setWillNotDraw(true);
        this.mDisableBackgroundLayer = disableBackgroundLayer;
    }

    public SurfaceHolder getHolder() {
        return this.mSurfaceHolder;
    }

    private void updateRequestedVisibility() {
        this.mRequestedVisible = this.mViewVisibility && this.mWindowVisibility && !this.mWindowStopped;
    }

    private void setWindowStopped(boolean stopped) {
        this.mWindowStopped = stopped;
        this.updateRequestedVisibility();
        this.updateSurface();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getViewRootImpl().addSurfaceChangedCallback(this);
        this.mWindowStopped = false;
        this.mViewVisibility = this.getVisibility() == 0;
        this.updateRequestedVisibility();
        this.mAttachedToWindow = true;
        this.mParent.requestTransparentRegion(this);
        if (!this.mGlobalListenersAdded) {
            ViewTreeObserver observer = this.getViewTreeObserver();
            observer.addOnScrollChangedListener(this.mScrollChangedListener);
            observer.addOnPreDrawListener(this.mDrawListener);
            this.mGlobalListenersAdded = true;
        }
    }

    @Override
    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.mWindowVisibility = visibility == 0;
        this.updateRequestedVisibility();
        this.updateSurface();
    }

    @Override
    public void setVisibility(int visibility) {
        boolean newRequestedVisible;
        super.setVisibility(visibility);
        this.mViewVisibility = visibility == 0;
        boolean bl = newRequestedVisible = this.mWindowVisibility && this.mViewVisibility && !this.mWindowStopped;
        if (newRequestedVisible != this.mRequestedVisible) {
            this.requestLayout();
        }
        this.mRequestedVisible = newRequestedVisible;
        this.updateSurface();
    }

    public void setUseAlpha() {
        if (!this.mUseAlpha) {
            this.mUseAlpha = true;
            this.updateSurfaceAlpha();
        }
    }

    @Override
    public void setAlpha(float alpha) {
        super.setAlpha(alpha);
        this.updateSurfaceAlpha();
    }

    private float getFixedAlpha() {
        float alpha = this.getAlpha();
        return this.mUseAlpha && (this.mSubLayer > 0 || alpha == 0.0f) ? alpha : 1.0f;
    }

    private void updateSurfaceAlpha() {
        ViewRootImpl viewRoot;
        if (!this.mUseAlpha || !this.mHaveFrame || this.mSurfaceControl == null) {
            return;
        }
        float viewAlpha = this.getAlpha();
        if (this.mSubLayer < 0 && 0.0f < viewAlpha && viewAlpha < 1.0f) {
            Log.w(TAG, System.identityHashCode(this) + " updateSurfaceAlpha: translucent color is not supported for a surface placed z-below.");
        }
        if ((viewRoot = this.getViewRootImpl()) == null) {
            return;
        }
        float alpha = this.getFixedAlpha();
        if (alpha != this.mSurfaceAlpha) {
            SurfaceControl.Transaction transaction = new SurfaceControl.Transaction();
            transaction.setAlpha(this.mSurfaceControl, alpha);
            viewRoot.applyTransactionOnDraw(transaction);
            this.damageInParent();
            this.mSurfaceAlpha = alpha;
        }
    }

    private void performDrawFinished() {
        this.mDrawFinished = true;
        if (this.mAttachedToWindow) {
            this.mParent.requestTransparentRegion(this);
            this.invalidate();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot != null) {
            viewRoot.removeSurfaceChangedCallback(this);
        }
        this.mAttachedToWindow = false;
        if (this.mGlobalListenersAdded) {
            ViewTreeObserver observer = this.getViewTreeObserver();
            observer.removeOnScrollChangedListener(this.mScrollChangedListener);
            observer.removeOnPreDrawListener(this.mDrawListener);
            this.mGlobalListenersAdded = false;
        }
        this.mRequestedVisible = false;
        this.updateSurface();
        this.releaseSurfaces(true);
        this.mHaveFrame = false;
        super.onDetachedFromWindow();
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = this.mRequestedWidth >= 0 ? _Original_SurfaceView.resolveSizeAndState(this.mRequestedWidth, widthMeasureSpec, 0) : _Original_SurfaceView.getDefaultSize(0, widthMeasureSpec);
        int height = this.mRequestedHeight >= 0 ? _Original_SurfaceView.resolveSizeAndState(this.mRequestedHeight, heightMeasureSpec, 0) : _Original_SurfaceView.getDefaultSize(0, heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    @Override
    @UnsupportedAppUsage
    protected boolean setFrame(int left, int top, int right, int bottom) {
        boolean result = super.setFrame(left, top, right, bottom);
        this.updateSurface();
        return result;
    }

    @Override
    public boolean gatherTransparentRegion(Region region) {
        if (this.isAboveParent() || !this.mDrawFinished) {
            return super.gatherTransparentRegion(region);
        }
        boolean opaque = true;
        if ((this.mPrivateFlags & 0x80) == 0) {
            opaque = super.gatherTransparentRegion(region);
        } else if (region != null) {
            int w = this.getWidth();
            int h = this.getHeight();
            if (w > 0 && h > 0) {
                this.getLocationInWindow(this.mLocation);
                int l = this.mLocation[0];
                int t = this.mLocation[1];
                region.op(l, t, l + w, t + h, Region.Op.UNION);
            }
        }
        if (PixelFormat.formatHasAlpha(this.mRequestedFormat)) {
            opaque = false;
        }
        return opaque;
    }

    @Override
    public void draw(Canvas canvas) {
        if (this.mDrawFinished && !this.isAboveParent() && (this.mPrivateFlags & 0x80) == 0) {
            this.clearSurfaceViewPort(canvas);
        }
        super.draw(canvas);
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        if (this.mDrawFinished && !this.isAboveParent() && (this.mPrivateFlags & 0x80) == 128) {
            this.clearSurfaceViewPort(canvas);
        }
        super.dispatchDraw(canvas);
    }

    public void setEnableSurfaceClipping(boolean enabled) {
        this.mClipSurfaceToBounds = enabled;
        this.invalidate();
    }

    @Override
    public void setClipBounds(Rect clipBounds) {
        super.setClipBounds(clipBounds);
        if (!this.mClipSurfaceToBounds || this.mSurfaceControl == null) {
            return;
        }
        if (this.mCornerRadius > 0.0f && !this.isAboveParent()) {
            this.invalidate();
        }
        if (this.mClipBounds != null) {
            this.mTmpRect.set(this.mClipBounds);
        } else {
            this.mTmpRect.set(0, 0, this.mSurfaceWidth, this.mSurfaceHeight);
        }
        SurfaceControl.Transaction transaction = new SurfaceControl.Transaction();
        transaction.setWindowCrop(this.mSurfaceControl, this.mTmpRect);
        this.applyTransactionOnVriDraw(transaction);
        this.invalidate();
    }

    private void clearSurfaceViewPort(Canvas canvas) {
        if (this.mCornerRadius > 0.0f) {
            canvas.getClipBounds(this.mTmpRect);
            if (this.mClipSurfaceToBounds && this.mClipBounds != null) {
                this.mTmpRect.intersect(this.mClipBounds);
            }
            canvas.punchHole(this.mTmpRect.left, this.mTmpRect.top, this.mTmpRect.right, this.mTmpRect.bottom, this.mCornerRadius, this.mCornerRadius);
        } else {
            canvas.punchHole(0.0f, 0.0f, this.getWidth(), this.getHeight(), 0.0f, 0.0f);
        }
    }

    public void setCornerRadius(float cornerRadius) {
        this.mCornerRadius = cornerRadius;
        if (this.mCornerRadius > 0.0f && this.mRoundedViewportPaint == null) {
            this.mRoundedViewportPaint = new Paint(1);
            this.mRoundedViewportPaint.setBlendMode(BlendMode.CLEAR);
            this.mRoundedViewportPaint.setColor(0);
        }
        this.invalidate();
    }

    public float getCornerRadius() {
        return this.mCornerRadius;
    }

    public void setZOrderMediaOverlay(boolean isMediaOverlay) {
        this.mSubLayer = isMediaOverlay ? -1 : -2;
    }

    public void setZOrderOnTop(boolean onTop) {
        boolean allowDynamicChange = this.getContext().getApplicationInfo().targetSdkVersion > 29;
        this.setZOrderedOnTop(onTop, allowDynamicChange);
    }

    public boolean isZOrderedOnTop() {
        return this.mSubLayer > 0;
    }

    public boolean setZOrderedOnTop(boolean onTop, boolean allowDynamicChange) {
        int subLayer = onTop ? 1 : -2;
        if (this.mSubLayer == subLayer) {
            return false;
        }
        this.mSubLayer = subLayer;
        if (!allowDynamicChange) {
            return false;
        }
        if (this.mSurfaceControl == null) {
            return true;
        }
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot == null) {
            return true;
        }
        SurfaceControl.Transaction transaction = new SurfaceControl.Transaction();
        this.updateRelativeZ(transaction);
        viewRoot.applyTransactionOnDraw(transaction);
        this.invalidate();
        return true;
    }

    public void setSecure(boolean isSecure) {
        this.mSurfaceFlags = isSecure ? (this.mSurfaceFlags |= 0x80) : (this.mSurfaceFlags &= 0xFFFFFF7F);
    }

    private void updateOpaqueFlag() {
        this.mSurfaceFlags = !PixelFormat.formatHasAlpha(this.mRequestedFormat) ? (this.mSurfaceFlags |= 0x400) : (this.mSurfaceFlags &= 0xFFFFFBFF);
    }

    private void updateBackgroundVisibility(SurfaceControl.Transaction t) {
        if (this.mBackgroundControl == null) {
            return;
        }
        if (this.mSubLayer < 0 && (this.mSurfaceFlags & 0x400) != 0 && !this.mDisableBackgroundLayer) {
            t.show(this.mBackgroundControl);
        } else {
            t.hide(this.mBackgroundControl);
        }
    }

    private SurfaceControl.Transaction updateBackgroundColor(SurfaceControl.Transaction t) {
        float[] colorComponents = new float[]{(float)Color.red(this.mBackgroundColor) / 255.0f, (float)Color.green(this.mBackgroundColor) / 255.0f, (float)Color.blue(this.mBackgroundColor) / 255.0f};
        t.setColor(this.mBackgroundControl, colorComponents);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSurfaces(boolean releaseSurfacePackage) {
        this.mSurfaceAlpha = 1.0f;
        this.mSurface.destroy();
        Object object = this.mSurfaceControlLock;
        synchronized (object) {
            if (this.mBlastBufferQueue != null) {
                this.mBlastBufferQueue.destroy();
                this.mBlastBufferQueue = null;
            }
            SurfaceControl.Transaction transaction = new SurfaceControl.Transaction();
            if (this.mSurfaceControl != null) {
                transaction.remove(this.mSurfaceControl);
                this.mSurfaceControl = null;
            }
            if (this.mBackgroundControl != null) {
                transaction.remove(this.mBackgroundControl);
                this.mBackgroundControl = null;
            }
            if (this.mBlastSurfaceControl != null) {
                transaction.remove(this.mBlastSurfaceControl);
                this.mBlastSurfaceControl = null;
            }
            if (releaseSurfacePackage && this.mSurfacePackage != null) {
                this.mSurfacePackage.release();
                this.mSurfacePackage = null;
            }
            this.applyTransactionOnVriDraw(transaction);
        }
    }

    private void replacePositionUpdateListener(int surfaceWidth, int surfaceHeight) {
        if (this.mPositionListener != null) {
            this.mRenderNode.removePositionUpdateListener(this.mPositionListener);
        }
        this.mPositionListener = new SurfaceViewPositionUpdateListener(surfaceWidth, surfaceHeight);
        this.mRenderNode.addPositionUpdateListener(this.mPositionListener);
    }

    private boolean performSurfaceTransaction(ViewRootImpl viewRoot, CompatibilityInfo.Translator translator, boolean creating, boolean sizeChanged, boolean hintChanged, SurfaceControl.Transaction surfaceUpdateTransaction) {
        boolean realSizeChanged = false;
        boolean bl = this.mDrawingStopped = !this.mVisible;
        if (creating) {
            this.updateRelativeZ(surfaceUpdateTransaction);
            if (this.mSurfacePackage != null) {
                this.reparentSurfacePackage(surfaceUpdateTransaction, this.mSurfacePackage);
            }
        }
        this.mParentSurfaceSequenceId = viewRoot.getSurfaceSequenceId();
        if (this.mViewVisibility) {
            surfaceUpdateTransaction.show(this.mSurfaceControl);
        } else {
            surfaceUpdateTransaction.hide(this.mSurfaceControl);
        }
        this.updateBackgroundVisibility(surfaceUpdateTransaction);
        this.updateBackgroundColor(surfaceUpdateTransaction);
        if (this.mUseAlpha) {
            float alpha = this.getFixedAlpha();
            surfaceUpdateTransaction.setAlpha(this.mSurfaceControl, alpha);
            this.mSurfaceAlpha = alpha;
        }
        surfaceUpdateTransaction.setCornerRadius(this.mSurfaceControl, this.mCornerRadius);
        if ((sizeChanged || hintChanged) && !creating) {
            this.setBufferSize(surfaceUpdateTransaction);
        }
        if (sizeChanged || creating || !this.isHardwareAccelerated()) {
            if (this.mClipSurfaceToBounds && this.mClipBounds != null) {
                surfaceUpdateTransaction.setWindowCrop(this.mSurfaceControl, this.mClipBounds);
            } else {
                surfaceUpdateTransaction.setWindowCrop(this.mSurfaceControl, this.mSurfaceWidth, this.mSurfaceHeight);
            }
            surfaceUpdateTransaction.setDesintationFrame(this.mBlastSurfaceControl, this.mSurfaceWidth, this.mSurfaceHeight);
            if (this.isHardwareAccelerated()) {
                this.replacePositionUpdateListener(this.mSurfaceWidth, this.mSurfaceHeight);
            } else {
                this.onSetSurfacePositionAndScale(surfaceUpdateTransaction, this.mSurfaceControl, this.mScreenRect.left, this.mScreenRect.top, (float)this.mScreenRect.width() / (float)this.mSurfaceWidth, (float)this.mScreenRect.height() / (float)this.mSurfaceHeight);
            }
        }
        this.applyTransactionOnVriDraw(surfaceUpdateTransaction);
        this.updateEmbeddedAccessibilityMatrix(false);
        this.mSurfaceFrame.left = 0;
        this.mSurfaceFrame.top = 0;
        if (translator == null) {
            this.mSurfaceFrame.right = this.mSurfaceWidth;
            this.mSurfaceFrame.bottom = this.mSurfaceHeight;
        } else {
            float appInvertedScale = translator.applicationInvertedScale;
            this.mSurfaceFrame.right = (int)((float)this.mSurfaceWidth * appInvertedScale + 0.5f);
            this.mSurfaceFrame.bottom = (int)((float)this.mSurfaceHeight * appInvertedScale + 0.5f);
        }
        int surfaceWidth = this.mSurfaceFrame.right;
        int surfaceHeight = this.mSurfaceFrame.bottom;
        realSizeChanged = this.mLastSurfaceWidth != surfaceWidth || this.mLastSurfaceHeight != surfaceHeight;
        this.mLastSurfaceWidth = surfaceWidth;
        this.mLastSurfaceHeight = surfaceHeight;
        return realSizeChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSurface() {
        boolean hintChanged;
        int myHeight;
        int myWidth;
        if (!this.mHaveFrame) {
            return;
        }
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot == null) {
            return;
        }
        if (viewRoot.mSurface == null || !viewRoot.mSurface.isValid()) {
            this.notifySurfaceDestroyed();
            this.releaseSurfaces(false);
            return;
        }
        CompatibilityInfo.Translator translator = viewRoot.mTranslator;
        if (translator != null) {
            this.mSurface.setCompatibilityTranslator(translator);
        }
        if ((myWidth = this.mRequestedWidth) <= 0) {
            myWidth = this.getWidth();
        }
        if ((myHeight = this.mRequestedHeight) <= 0) {
            myHeight = this.getHeight();
        }
        float alpha = this.getFixedAlpha();
        boolean formatChanged = this.mFormat != this.mRequestedFormat;
        boolean visibleChanged = this.mVisible != this.mRequestedVisible;
        boolean alphaChanged = this.mSurfaceAlpha != alpha;
        boolean creating = (this.mSurfaceControl == null || formatChanged || visibleChanged) && this.mRequestedVisible;
        boolean sizeChanged = this.mSurfaceWidth != myWidth || this.mSurfaceHeight != myHeight;
        boolean windowVisibleChanged = this.mWindowVisibility != this.mLastWindowVisibility;
        this.getLocationInSurface(this.mLocation);
        boolean positionChanged = this.mWindowSpaceLeft != this.mLocation[0] || this.mWindowSpaceTop != this.mLocation[1];
        boolean layoutSizeChanged = this.getWidth() != this.mScreenRect.width() || this.getHeight() != this.mScreenRect.height();
        boolean bl = hintChanged = viewRoot.getBufferTransformHint() != this.mTransformHint && this.mRequestedVisible;
        if (creating || formatChanged || sizeChanged || visibleChanged || this.mUseAlpha && alphaChanged || windowVisibleChanged || positionChanged || layoutSizeChanged || hintChanged) {
            this.getLocationInWindow(this.mLocation);
            try {
                this.mVisible = this.mRequestedVisible;
                this.mWindowSpaceLeft = this.mLocation[0];
                this.mWindowSpaceTop = this.mLocation[1];
                this.mSurfaceWidth = myWidth;
                this.mSurfaceHeight = myHeight;
                this.mFormat = this.mRequestedFormat;
                this.mLastWindowVisibility = this.mWindowVisibility;
                this.mTransformHint = viewRoot.getBufferTransformHint();
                this.mScreenRect.left = this.mWindowSpaceLeft;
                this.mScreenRect.top = this.mWindowSpaceTop;
                this.mScreenRect.right = this.mWindowSpaceLeft + this.getWidth();
                this.mScreenRect.bottom = this.mWindowSpaceTop + this.getHeight();
                if (translator != null) {
                    translator.translateRectInAppWindowToScreen(this.mScreenRect);
                }
                Rect surfaceInsets = viewRoot.mWindowAttributes.surfaceInsets;
                this.mScreenRect.offset(surfaceInsets.left, surfaceInsets.top);
                SurfaceControl.Transaction surfaceUpdateTransaction = new SurfaceControl.Transaction();
                if (creating) {
                    this.updateOpaqueFlag();
                    String name = "SurfaceView[" + viewRoot.getTitle().toString() + "]";
                    this.createBlastSurfaceControls(viewRoot, name, surfaceUpdateTransaction);
                } else if (this.mSurfaceControl == null) {
                    return;
                }
                boolean redrawNeeded = sizeChanged || creating || hintChanged || this.mVisible && !this.mDrawFinished;
                boolean shouldSyncBuffer = redrawNeeded && viewRoot.wasRelayoutRequested() && viewRoot.isInLocalSync();
                SyncBufferTransactionCallback syncBufferTransactionCallback = null;
                if (shouldSyncBuffer) {
                    syncBufferTransactionCallback = new SyncBufferTransactionCallback();
                    this.mBlastBufferQueue.syncNextTransaction(false, arg_0 -> ((SurfaceView.SyncBufferTransactionCallback)syncBufferTransactionCallback).onTransactionReady(arg_0));
                }
                boolean realSizeChanged = this.performSurfaceTransaction(viewRoot, translator, creating, sizeChanged, hintChanged, surfaceUpdateTransaction);
                try {
                    SurfaceHolder.Callback[] callbacks = null;
                    boolean surfaceChanged = creating;
                    if (this.mSurfaceCreated && (surfaceChanged || !this.mVisible && visibleChanged)) {
                        this.mSurfaceCreated = false;
                        this.notifySurfaceDestroyed();
                    }
                    this.copySurface(creating, sizeChanged);
                    if (this.mVisible && this.mSurface.isValid()) {
                        if (!this.mSurfaceCreated && (surfaceChanged || visibleChanged)) {
                            this.mSurfaceCreated = true;
                            this.mIsCreating = true;
                            for (SurfaceHolder.Callback c : callbacks = this.getSurfaceCallbacks()) {
                                c.surfaceCreated(this.mSurfaceHolder);
                            }
                        }
                        if (creating || formatChanged || sizeChanged || hintChanged || visibleChanged || realSizeChanged) {
                            if (callbacks == null) {
                                callbacks = this.getSurfaceCallbacks();
                            }
                            for (SurfaceHolder.Callback c : callbacks) {
                                c.surfaceChanged(this.mSurfaceHolder, this.mFormat, myWidth, myHeight);
                            }
                        }
                        if (redrawNeeded) {
                            if (callbacks == null) {
                                callbacks = this.getSurfaceCallbacks();
                            }
                            if (shouldSyncBuffer) {
                                this.handleSyncBufferCallback(callbacks, syncBufferTransactionCallback);
                            } else {
                                this.handleSyncNoBuffer(callbacks);
                            }
                        }
                    }
                }
                finally {
                    this.mIsCreating = false;
                    if (this.mSurfaceControl != null && !this.mSurfaceCreated) {
                        this.releaseSurfaces(false);
                    }
                }
            }
            catch (Exception ex) {
                Log.e(TAG, "Exception configuring surface", ex);
            }
        }
    }

    private void handleSyncBufferCallback(SurfaceHolder.Callback[] callbacks, SyncBufferTransactionCallback syncBufferTransactionCallback) {
        this.getViewRootImpl().addToSync((SurfaceSyncer.SyncTarget)LambdaMetafactory.metafactory(null, null, null, (Landroid/window/SurfaceSyncer$SyncBufferCallback;)V, lambda$handleSyncBufferCallback$2(android.view.SurfaceHolder$Callback[] android.view.SurfaceView$SyncBufferTransactionCallback android.window.SurfaceSyncer$SyncBufferCallback ), (Landroid/window/SurfaceSyncer$SyncBufferCallback;)V)((SurfaceView)((Object)this), (SurfaceHolder.Callback[])callbacks, (SurfaceView.SyncBufferTransactionCallback)syncBufferTransactionCallback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSyncNoBuffer(SurfaceHolder.Callback[] callbacks) {
        int syncId = this.mSurfaceSyncer.setupSync((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, onDrawFinished(), ()V)((SurfaceView)((Object)this)));
        this.mSurfaceSyncer.addToSync(syncId, (SurfaceSyncer.SyncTarget)LambdaMetafactory.metafactory(null, null, null, (Landroid/window/SurfaceSyncer$SyncBufferCallback;)V, lambda$handleSyncNoBuffer$4(android.view.SurfaceHolder$Callback[] int android.window.SurfaceSyncer$SyncBufferCallback ), (Landroid/window/SurfaceSyncer$SyncBufferCallback;)V)((SurfaceView)((Object)this), (SurfaceHolder.Callback[])callbacks, (int)syncId));
        this.mSurfaceSyncer.markSyncReady(syncId);
        ArraySet<Integer> arraySet = this.mSyncIds;
        synchronized (arraySet) {
            this.mSyncIds.add(syncId);
        }
    }

    private void redrawNeededAsync(SurfaceHolder.Callback[] callbacks, Runnable callbacksCollected) {
        SurfaceCallbackHelper sch = new SurfaceCallbackHelper(callbacksCollected);
        sch.dispatchSurfaceRedrawNeededAsync(this.mSurfaceHolder, callbacks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void surfaceSyncStarted() {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot != null) {
            ArraySet<Integer> arraySet = this.mSyncIds;
            synchronized (arraySet) {
                for (int syncId : this.mSyncIds) {
                    viewRoot.mergeSync(syncId, this.mSurfaceSyncer);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copySurface(boolean surfaceControlCreated, boolean bufferSizeChanged) {
        boolean needsWorkaround;
        boolean bl = needsWorkaround = bufferSizeChanged && this.getContext().getApplicationInfo().targetSdkVersion < 26;
        if (!surfaceControlCreated && !needsWorkaround) {
            return;
        }
        this.mSurfaceLock.lock();
        try {
            if (surfaceControlCreated) {
                this.mSurface.copyFrom(this.mBlastBufferQueue);
            }
            if (needsWorkaround && this.mBlastBufferQueue != null) {
                this.mSurface.transferFrom(this.mBlastBufferQueue.createSurfaceWithHandle());
            }
        }
        finally {
            this.mSurfaceLock.unlock();
        }
    }

    private void setBufferSize(SurfaceControl.Transaction transaction) {
        this.mBlastSurfaceControl.setTransformHint(this.mTransformHint);
        if (this.mBlastBufferQueue != null) {
            this.mBlastBufferQueue.update(this.mBlastSurfaceControl, this.mSurfaceWidth, this.mSurfaceHeight, this.mFormat);
        }
    }

    private void createBlastSurfaceControls(ViewRootImpl viewRoot, String name, SurfaceControl.Transaction surfaceUpdateTransaction) {
        if (this.mSurfaceControl == null) {
            this.mSurfaceControl = new SurfaceControl.Builder(this.mSurfaceSession).setName(name).setLocalOwnerView(this).setParent(viewRoot.getBoundsLayer()).setCallsite("SurfaceView.updateSurface").setContainerLayer().build();
        }
        if (this.mBlastSurfaceControl == null) {
            this.mBlastSurfaceControl = new SurfaceControl.Builder(this.mSurfaceSession).setName(name + "(BLAST)").setLocalOwnerView(this).setParent(this.mSurfaceControl).setFlags(this.mSurfaceFlags).setHidden(false).setBLASTLayer().setCallsite("SurfaceView.updateSurface").build();
        } else {
            surfaceUpdateTransaction.setOpaque(this.mBlastSurfaceControl, (this.mSurfaceFlags & 0x400) != 0).setSecure(this.mBlastSurfaceControl, (this.mSurfaceFlags & 0x80) != 0).show(this.mBlastSurfaceControl);
        }
        if (this.mBackgroundControl == null) {
            this.mBackgroundControl = new SurfaceControl.Builder(this.mSurfaceSession).setName("Background for " + name).setLocalOwnerView(this).setOpaque(true).setColorLayer().setParent(this.mSurfaceControl).setCallsite("SurfaceView.updateSurface").build();
        }
        if (this.mBlastBufferQueue != null) {
            this.mBlastBufferQueue.destroy();
        }
        this.mTransformHint = viewRoot.getBufferTransformHint();
        this.mBlastSurfaceControl.setTransformHint(this.mTransformHint);
        this.mBlastBufferQueue = new BLASTBufferQueue(name, false);
        this.mBlastBufferQueue.update(this.mBlastSurfaceControl, this.mSurfaceWidth, this.mSurfaceHeight, this.mFormat);
        this.mBlastBufferQueue.setTransactionHangCallback(ViewRootImpl.sTransactionHangCallback);
    }

    private void onDrawFinished() {
        this.runOnUiThread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, performDrawFinished(), ()V)((SurfaceView)((Object)this)));
    }

    protected void onSetSurfacePositionAndScale(SurfaceControl.Transaction transaction, SurfaceControl surface, int positionLeft, int positionTop, float postScaleX, float postScaleY) {
        transaction.setPosition(surface, positionLeft, positionTop);
        transaction.setMatrix(surface, postScaleX, 0.0f, 0.0f, postScaleY);
    }

    public void requestUpdateSurfacePositionAndScale() {
        if (this.mSurfaceControl == null) {
            return;
        }
        SurfaceControl.Transaction transaction = new SurfaceControl.Transaction();
        this.onSetSurfacePositionAndScale(transaction, this.mSurfaceControl, this.mScreenRect.left, this.mScreenRect.top, (float)this.mScreenRect.width() / (float)this.mSurfaceWidth, (float)this.mScreenRect.height() / (float)this.mSurfaceHeight);
        this.applyTransactionOnVriDraw(transaction);
        this.invalidate();
    }

    public Rect getSurfaceRenderPosition() {
        return this.mRTLastReportedPosition;
    }

    private void applyOrMergeTransaction(SurfaceControl.Transaction t, long frameNumber) {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot != null) {
            viewRoot.mergeWithNextTransaction(t, frameNumber);
        } else {
            t.apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SurfaceHolder.Callback[] getSurfaceCallbacks() {
        SurfaceHolder.Callback[] callbacks;
        ArrayList<SurfaceHolder.Callback> arrayList = this.mCallbacks;
        synchronized (arrayList) {
            callbacks = new SurfaceHolder.Callback[this.mCallbacks.size()];
            this.mCallbacks.toArray(callbacks);
        }
        return callbacks;
    }

    private void runOnUiThread(Runnable runnable) {
        Handler handler = this.getHandler();
        if (handler != null && handler.getLooper() != Looper.myLooper()) {
            handler.post(runnable);
        } else {
            runnable.run();
        }
    }

    @UnsupportedAppUsage
    public boolean isFixedSize() {
        return this.mRequestedWidth != -1 || this.mRequestedHeight != -1;
    }

    private boolean isAboveParent() {
        return this.mSubLayer >= 0;
    }

    public void setResizeBackgroundColor(int bgColor) {
        SurfaceControl.Transaction transaction = new SurfaceControl.Transaction();
        this.setResizeBackgroundColor(transaction, bgColor);
        this.applyTransactionOnVriDraw(transaction);
        this.invalidate();
    }

    public void setResizeBackgroundColor(SurfaceControl.Transaction t, int bgColor) {
        if (this.mBackgroundControl == null) {
            return;
        }
        this.mBackgroundColor = bgColor;
        this.updateBackgroundColor(t);
    }

    public SurfaceControl getSurfaceControl() {
        return this.mSurfaceControl;
    }

    public IBinder getHostToken() {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot == null) {
            return null;
        }
        return viewRoot.getInputToken();
    }

    @Override
    public void surfaceCreated(SurfaceControl.Transaction t) {
        this.setWindowStopped(false);
    }

    @Override
    public void surfaceDestroyed() {
        this.setWindowStopped(true);
        this.mRemoteAccessibilityController.disassosciateHierarchy();
    }

    @Override
    public void surfaceReplaced(SurfaceControl.Transaction t) {
        if (this.mSurfaceControl != null && this.mBackgroundControl != null) {
            this.updateRelativeZ(t);
        }
    }

    private void updateRelativeZ(SurfaceControl.Transaction t) {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot == null) {
            return;
        }
        SurfaceControl viewRootControl = viewRoot.getSurfaceControl();
        t.setRelativeLayer(this.mBackgroundControl, viewRootControl, Integer.MIN_VALUE);
        t.setRelativeLayer(this.mSurfaceControl, viewRootControl, this.mSubLayer);
    }

    public void setChildSurfacePackage(SurfaceControlViewHost.SurfacePackage p) {
        SurfaceControl lastSc = this.mSurfacePackage != null ? this.mSurfacePackage.getSurfaceControl() : null;
        SurfaceControl.Transaction transaction = new SurfaceControl.Transaction();
        if (this.mSurfaceControl != null) {
            if (lastSc != null) {
                transaction.reparent(lastSc, null);
                this.mSurfacePackage.release();
            }
            this.reparentSurfacePackage(transaction, p);
            this.applyTransactionOnVriDraw(transaction);
        }
        this.mSurfacePackage = p;
        this.invalidate();
    }

    private void reparentSurfacePackage(SurfaceControl.Transaction t, SurfaceControlViewHost.SurfacePackage p) {
        SurfaceControl sc = p.getSurfaceControl();
        if (sc == null || !sc.isValid()) {
            return;
        }
        this.initEmbeddedHierarchyForAccessibility(p);
        t.reparent(sc, this.mBlastSurfaceControl).show(sc);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        if (!this.mRemoteAccessibilityController.connected()) {
            return;
        }
        info.addChild(this.mRemoteAccessibilityController.getLeashToken());
    }

    @Override
    public int getImportantForAccessibility() {
        int mode = super.getImportantForAccessibility();
        if (this.mRemoteAccessibilityController != null && !this.mRemoteAccessibilityController.connected() || mode != 0) {
            return mode;
        }
        return 1;
    }

    private void initEmbeddedHierarchyForAccessibility(SurfaceControlViewHost.SurfacePackage p) {
        IAccessibilityEmbeddedConnection connection = p.getAccessibilityEmbeddedConnection();
        if (this.mRemoteAccessibilityController.alreadyAssociated(connection)) {
            return;
        }
        this.mRemoteAccessibilityController.assosciateHierarchy(connection, this.getViewRootImpl().mLeashToken, this.getAccessibilityViewId());
        this.updateEmbeddedAccessibilityMatrix(true);
    }

    private void notifySurfaceDestroyed() {
        if (this.mSurface.isValid()) {
            SurfaceHolder.Callback[] callbacks;
            for (SurfaceHolder.Callback c : callbacks = this.getSurfaceCallbacks()) {
                c.surfaceDestroyed(this.mSurfaceHolder);
            }
            if (this.mSurface.isValid()) {
                this.mSurface.forceScopedDisconnect();
            }
        }
    }

    void updateEmbeddedAccessibilityMatrix(boolean force) {
        if (!this.mRemoteAccessibilityController.connected()) {
            return;
        }
        this.getBoundsOnScreen(this.mTmpRect);
        this.mTmpRect.offset(-this.mAttachInfo.mWindowLeft, -this.mAttachInfo.mWindowTop);
        this.mTmpMatrix.reset();
        this.mTmpMatrix.setTranslate(this.mTmpRect.left, this.mTmpRect.top);
        this.mTmpMatrix.postScale((float)this.mScreenRect.width() / (float)this.mSurfaceWidth, (float)this.mScreenRect.height() / (float)this.mSurfaceHeight);
        this.mRemoteAccessibilityController.setWindowMatrix(this.mTmpMatrix, force);
    }

    @Override
    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (this.mSurfacePackage == null || viewRoot == null) {
            return;
        }
        try {
            viewRoot.mWindowSession.grantEmbeddedWindowFocus(viewRoot.mWindow, this.mSurfacePackage.getInputToken(), gainFocus);
        }
        catch (Exception e) {
            Log.e(TAG, System.identityHashCode(this) + "Exception requesting focus on embedded window", e);
        }
    }

    private void applyTransactionOnVriDraw(SurfaceControl.Transaction t) {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot != null) {
            viewRoot.applyTransactionOnDraw(t);
        } else {
            t.apply();
        }
    }

    public void syncNextFrame(Consumer<SurfaceControl.Transaction> t) {
        this.mBlastBufferQueue.syncNextTransaction(t);
    }

    private /* synthetic */ void lambda$handleSyncNoBuffer$4(SurfaceHolder.Callback[] callbacks, int syncId, SurfaceSyncer.SyncBufferCallback syncBufferCallback) {
        this.redrawNeededAsync(callbacks, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$handleSyncNoBuffer$3(android.window.SurfaceSyncer$SyncBufferCallback int ), ()V)((SurfaceView)((Object)this), (SurfaceSyncer.SyncBufferCallback)syncBufferCallback, (int)syncId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$handleSyncNoBuffer$3(SurfaceSyncer.SyncBufferCallback syncBufferCallback, int syncId) {
        syncBufferCallback.onBufferReady(null);
        ArraySet<Integer> arraySet = this.mSyncIds;
        synchronized (arraySet) {
            this.mSyncIds.remove(syncId);
        }
    }

    private /* synthetic */ void lambda$handleSyncBufferCallback$2(SurfaceHolder.Callback[] callbacks, SyncBufferTransactionCallback syncBufferTransactionCallback, SurfaceSyncer.SyncBufferCallback syncBufferCallback) {
        this.redrawNeededAsync(callbacks, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$handleSyncBufferCallback$1(android.view.SurfaceView$SyncBufferTransactionCallback android.window.SurfaceSyncer$SyncBufferCallback ), ()V)((SurfaceView)((Object)this), (SurfaceView.SyncBufferTransactionCallback)syncBufferTransactionCallback, (SurfaceSyncer.SyncBufferCallback)syncBufferCallback));
    }

    private /* synthetic */ void lambda$handleSyncBufferCallback$1(SyncBufferTransactionCallback syncBufferTransactionCallback, SurfaceSyncer.SyncBufferCallback syncBufferCallback) {
        SurfaceControl.Transaction t = null;
        if (this.mBlastBufferQueue != null) {
            this.mBlastBufferQueue.stopContinuousSyncTransaction();
            t = syncBufferTransactionCallback.waitForTransaction();
        }
        syncBufferCallback.onBufferReady(t);
        this.onDrawFinished();
    }

    private /* synthetic */ boolean lambda$new$0() {
        this.mHaveFrame = this.getWidth() > 0 && this.getHeight() > 0;
        this.updateSurface();
        return true;
    }

    private class SurfaceViewPositionUpdateListener
    implements RenderNode.PositionUpdateListener {
        private final int mRtSurfaceWidth;
        private final int mRtSurfaceHeight;
        private boolean mRtFirst = true;
        private final SurfaceControl.Transaction mPositionChangedTransaction = new SurfaceControl.Transaction();

        SurfaceViewPositionUpdateListener(int surfaceWidth, int surfaceHeight) {
            this.mRtSurfaceWidth = surfaceWidth;
            this.mRtSurfaceHeight = surfaceHeight;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void positionChanged(long frameNumber, int left, int top, int right, int bottom) {
            if (!this.mRtFirst && _Original_SurfaceView.this.mRTLastReportedPosition.left == left && _Original_SurfaceView.this.mRTLastReportedPosition.top == top && _Original_SurfaceView.this.mRTLastReportedPosition.right == right && _Original_SurfaceView.this.mRTLastReportedPosition.bottom == bottom && _Original_SurfaceView.this.mRTLastReportedSurfaceSize.x == this.mRtSurfaceWidth && _Original_SurfaceView.this.mRTLastReportedSurfaceSize.y == this.mRtSurfaceHeight) {
                return;
            }
            this.mRtFirst = false;
            try {
                Object object = _Original_SurfaceView.this.mSurfaceControlLock;
                synchronized (object) {
                    if (_Original_SurfaceView.this.mSurfaceControl == null) {
                        return;
                    }
                    _Original_SurfaceView.this.mRTLastReportedPosition.set(left, top, right, bottom);
                    _Original_SurfaceView.this.mRTLastReportedSurfaceSize.set(this.mRtSurfaceWidth, this.mRtSurfaceHeight);
                    _Original_SurfaceView.this.onSetSurfacePositionAndScale(this.mPositionChangedTransaction, _Original_SurfaceView.this.mSurfaceControl, _Original_SurfaceView.this.mRTLastReportedPosition.left, _Original_SurfaceView.this.mRTLastReportedPosition.top, (float)_Original_SurfaceView.this.mRTLastReportedPosition.width() / (float)this.mRtSurfaceWidth, (float)_Original_SurfaceView.this.mRTLastReportedPosition.height() / (float)this.mRtSurfaceHeight);
                    if (_Original_SurfaceView.this.mViewVisibility) {
                        this.mPositionChangedTransaction.show(_Original_SurfaceView.this.mSurfaceControl);
                    }
                }
                _Original_SurfaceView.this.applyOrMergeTransaction(this.mPositionChangedTransaction, frameNumber);
            }
            catch (Exception ex) {
                Log.e(_Original_SurfaceView.TAG, "Exception from repositionChild", ex);
            }
        }

        @Override
        public void applyStretch(long frameNumber, float width, float height, float vecX, float vecY, float maxStretchX, float maxStretchY, float childRelativeLeft, float childRelativeTop, float childRelativeRight, float childRelativeBottom) {
            _Original_SurfaceView.this.mRtTransaction.setStretchEffect(_Original_SurfaceView.this.mSurfaceControl, width, height, vecX, vecY, maxStretchX, maxStretchY, childRelativeLeft, childRelativeTop, childRelativeRight, childRelativeBottom);
            _Original_SurfaceView.this.applyOrMergeTransaction(_Original_SurfaceView.this.mRtTransaction, frameNumber);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void positionLost(long frameNumber) {
            _Original_SurfaceView.this.mRTLastReportedPosition.setEmpty();
            _Original_SurfaceView.this.mRTLastReportedSurfaceSize.set(-1, -1);
            Object object = _Original_SurfaceView.this.mSurfaceControlLock;
            synchronized (object) {
                if (_Original_SurfaceView.this.mSurfaceControl == null) {
                    return;
                }
                _Original_SurfaceView.this.mRtTransaction.hide(_Original_SurfaceView.this.mSurfaceControl);
                _Original_SurfaceView.this.applyOrMergeTransaction(_Original_SurfaceView.this.mRtTransaction, frameNumber);
            }
        }
    }

    private static class SyncBufferTransactionCallback {
        private final CountDownLatch mCountDownLatch = new CountDownLatch(1);
        private SurfaceControl.Transaction mTransaction;

        private SyncBufferTransactionCallback() {
        }

        SurfaceControl.Transaction waitForTransaction() {
            try {
                this.mCountDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.mTransaction;
        }

        void onTransactionReady(SurfaceControl.Transaction t) {
            this.mTransaction = t;
            this.mCountDownLatch.countDown();
        }
    }
}

