/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.animation.HasNativeInterpolator;
import android.graphics.animation.NativeInterpolator;
import android.graphics.animation.NativeInterpolatorFactory;
import android.util.AttributeSet;
import android.view.animation.BaseInterpolator;
import com.android.internal.R;

@HasNativeInterpolator
public class OvershootInterpolator
extends BaseInterpolator
implements NativeInterpolator {
    private final float mTension;

    public OvershootInterpolator() {
        this.mTension = 2.0f;
    }

    public OvershootInterpolator(float tension) {
        this.mTension = tension;
    }

    public OvershootInterpolator(Context context, AttributeSet attrs) {
        this(context.getResources(), context.getTheme(), attrs);
    }

    public OvershootInterpolator(Resources res, Resources.Theme theme, AttributeSet attrs) {
        TypedArray a = theme != null ? theme.obtainStyledAttributes(attrs, R.styleable.OvershootInterpolator, 0, 0) : res.obtainAttributes(attrs, R.styleable.OvershootInterpolator);
        this.mTension = a.getFloat(0, 2.0f);
        this.setChangingConfiguration(a.getChangingConfigurations());
        a.recycle();
    }

    @Override
    public float getInterpolation(float t) {
        return (t -= 1.0f) * t * ((this.mTension + 1.0f) * t + this.mTension) + 1.0f;
    }

    @Override
    public long createNativeInterpolator() {
        return NativeInterpolatorFactory.createOvershootInterpolator(this.mTension);
    }
}

