/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputContentInfo;
import android.view.inputmethod.SurroundingText;
import android.view.inputmethod.TextAttribute;
import android.view.inputmethod.TextSnapshot;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public interface InputConnection {
    public static final int GET_TEXT_WITH_STYLES = 1;
    public static final int GET_EXTRACTED_TEXT_MONITOR = 1;
    public static final int CURSOR_UPDATE_IMMEDIATE = 1;
    public static final int CURSOR_UPDATE_MONITOR = 2;
    public static final int CURSOR_UPDATE_FILTER_EDITOR_BOUNDS = 4;
    public static final int CURSOR_UPDATE_FILTER_CHARACTER_BOUNDS = 8;
    public static final int CURSOR_UPDATE_FILTER_INSERTION_MARKER = 16;
    public static final int INPUT_CONTENT_GRANT_READ_URI_PERMISSION = 1;

    public CharSequence getTextBeforeCursor(int var1, int var2);

    public CharSequence getTextAfterCursor(int var1, int var2);

    public CharSequence getSelectedText(int var1);

    default public SurroundingText getSurroundingText(int beforeLength, int afterLength, int flags) {
        Preconditions.checkArgumentNonnegative(beforeLength);
        Preconditions.checkArgumentNonnegative(afterLength);
        CharSequence textBeforeCursor = this.getTextBeforeCursor(beforeLength, flags);
        if (textBeforeCursor == null) {
            return null;
        }
        CharSequence textAfterCursor = this.getTextAfterCursor(afterLength, flags);
        if (textAfterCursor == null) {
            return null;
        }
        CharSequence selectedText = this.getSelectedText(flags);
        if (selectedText == null) {
            selectedText = "";
        }
        CharSequence surroundingText = TextUtils.concat(textBeforeCursor, selectedText, textAfterCursor);
        return new SurroundingText(surroundingText, textBeforeCursor.length(), textBeforeCursor.length() + selectedText.length(), -1);
    }

    public int getCursorCapsMode(int var1);

    public ExtractedText getExtractedText(ExtractedTextRequest var1, int var2);

    public boolean deleteSurroundingText(int var1, int var2);

    public boolean deleteSurroundingTextInCodePoints(int var1, int var2);

    public boolean setComposingText(CharSequence var1, int var2);

    default public boolean setComposingText(CharSequence text, int newCursorPosition, TextAttribute textAttribute) {
        return this.setComposingText(text, newCursorPosition);
    }

    public boolean setComposingRegion(int var1, int var2);

    default public boolean setComposingRegion(int start, int end, TextAttribute textAttribute) {
        return this.setComposingRegion(start, end);
    }

    public boolean finishComposingText();

    public boolean commitText(CharSequence var1, int var2);

    default public boolean commitText(CharSequence text, int newCursorPosition, TextAttribute textAttribute) {
        return this.commitText(text, newCursorPosition);
    }

    public boolean commitCompletion(CompletionInfo var1);

    public boolean commitCorrection(CorrectionInfo var1);

    public boolean setSelection(int var1, int var2);

    public boolean performEditorAction(int var1);

    public boolean performContextMenuAction(int var1);

    public boolean beginBatchEdit();

    public boolean endBatchEdit();

    public boolean sendKeyEvent(KeyEvent var1);

    public boolean clearMetaKeyStates(int var1);

    public boolean reportFullscreenMode(boolean var1);

    default public boolean performSpellCheck() {
        return false;
    }

    public boolean performPrivateCommand(String var1, Bundle var2);

    public boolean requestCursorUpdates(int var1);

    default public boolean requestCursorUpdates(int cursorUpdateMode, int cursorUpdateFilter) {
        if (cursorUpdateFilter == 0) {
            return this.requestCursorUpdates(cursorUpdateMode);
        }
        return false;
    }

    public Handler getHandler();

    public void closeConnection();

    public boolean commitContent(InputContentInfo var1, int var2, Bundle var3);

    default public boolean setImeConsumesInput(boolean imeConsumesInput) {
        return false;
    }

    default public TextSnapshot takeSnapshot() {
        return null;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CursorUpdateFilter {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CursorUpdateMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GetTextType {
    }
}

