/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ITransitionMetricsReporter
extends IInterface {
    public static final String DESCRIPTOR = "android.window.ITransitionMetricsReporter";

    public void reportAnimationStart(IBinder var1, long var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITransitionMetricsReporter {
        static final int TRANSACTION_reportAnimationStart = 1;

        public Stub() {
            this.attachInterface(this, ITransitionMetricsReporter.DESCRIPTOR);
        }

        public static ITransitionMetricsReporter asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITransitionMetricsReporter.DESCRIPTOR);
            if (iin != null && iin instanceof ITransitionMetricsReporter) {
                return (ITransitionMetricsReporter)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "reportAnimationStart";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITransitionMetricsReporter.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IBinder _arg0 = data.readStrongBinder();
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    this.reportAnimationStart(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements ITransitionMetricsReporter {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITransitionMetricsReporter.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportAnimationStart(IBinder transitionToken, long startTime) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITransitionMetricsReporter.DESCRIPTOR);
                    _data.writeStrongBinder(transitionToken);
                    _data.writeLong(startTime);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITransitionMetricsReporter {
        @Override
        public void reportAnimationStart(IBinder transitionToken, long startTime) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

