/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.graphics.palette;

import com.android.internal.graphics.palette.Palette;
import com.android.internal.graphics.palette.PointProvider;
import com.android.internal.graphics.palette.Quantizer;
import com.android.internal.graphics.palette.QuantizerMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class WSMeansQuantizer
implements Quantizer {
    private static final String TAG = "QuantizerWsmeans";
    private static final boolean DEBUG = false;
    private static final int MAX_ITERATIONS = 10;
    private static final float MIN_MOVEMENT_DISTANCE = 3.0f;
    private final PointProvider mPointProvider;
    private Map<Integer, Integer> mInputPixelToCount;
    private float[][] mClusters;
    private int[] mClusterPopulations;
    private float[][] mPoints;
    private int[] mPixels;
    private int[] mClusterIndices;
    private int[][] mIndexMatrix = new int[0][];
    private float[][] mDistanceMatrix = new float[0][];
    private Palette mPalette;

    public WSMeansQuantizer(int[] inClusters, PointProvider pointProvider, Map<Integer, Integer> inputPixelToCount) {
        this.mPointProvider = pointProvider;
        this.mClusters = new float[inClusters.length][3];
        int index = 0;
        for (int cluster : inClusters) {
            float[] point = pointProvider.fromInt(cluster);
            this.mClusters[index++] = point;
        }
        this.mInputPixelToCount = inputPixelToCount;
    }

    @Override
    public List<Palette.Swatch> getQuantizedColors() {
        return this.mPalette.getSwatches();
    }

    @Override
    public void quantize(int[] pixels, int maxColors) {
        assert (pixels.length > 0);
        if (this.mInputPixelToCount == null) {
            QuantizerMap mapQuantizer = new QuantizerMap();
            mapQuantizer.quantize(pixels, maxColors);
            this.mInputPixelToCount = mapQuantizer.getColorToCount();
        }
        this.mPoints = new float[this.mInputPixelToCount.size()][3];
        this.mPixels = new int[this.mInputPixelToCount.size()];
        int index = 0;
        Iterator<Integer> iterator = this.mInputPixelToCount.keySet().iterator();
        while (iterator.hasNext()) {
            int pixel;
            this.mPixels[index] = pixel = iterator.next().intValue();
            this.mPoints[index] = this.mPointProvider.fromInt(pixel);
            ++index;
        }
        if (this.mClusters.length > 0) {
            maxColors = Math.min(maxColors, this.mClusters.length);
        }
        maxColors = Math.min(maxColors, this.mPoints.length);
        this.initializeClusters(maxColors);
        for (int i = 0; i < 10; ++i) {
            this.calculateClusterDistances(maxColors);
            if (!this.reassignPoints(maxColors)) break;
            this.recalculateClusterCenters(maxColors);
        }
        ArrayList<Palette.Swatch> swatches = new ArrayList<Palette.Swatch>();
        for (int i = 0; i < maxColors; ++i) {
            float[] cluster = this.mClusters[i];
            int colorInt = this.mPointProvider.toInt(cluster);
            swatches.add(new Palette.Swatch(colorInt, this.mClusterPopulations[i]));
        }
        this.mPalette = Palette.from(swatches);
    }

    private void initializeClusters(int maxColors) {
        boolean hadInputClusters;
        boolean bl = hadInputClusters = this.mClusters.length > 0;
        if (!hadInputClusters) {
            int additionalClustersNeeded = maxColors - this.mClusters.length;
            Random random = new Random(272008L);
            ArrayList<float[]> additionalClusters = new ArrayList<float[]>(additionalClustersNeeded);
            HashSet<Integer> clusterIndicesUsed = new HashSet<Integer>();
            for (int i = 0; i < additionalClustersNeeded; ++i) {
                int index = random.nextInt(this.mPoints.length);
                while (clusterIndicesUsed.contains(index) && clusterIndicesUsed.size() < this.mPoints.length) {
                    index = random.nextInt(this.mPoints.length);
                }
                clusterIndicesUsed.add(index);
                additionalClusters.add(this.mPoints[index]);
            }
            float[][] newClusters = (float[][])additionalClusters.toArray();
            float[][] clusters = (float[][])Arrays.copyOf(this.mClusters, maxColors);
            System.arraycopy(newClusters, 0, clusters, clusters.length, newClusters.length);
            this.mClusters = clusters;
        }
        this.mClusterIndices = new int[this.mPixels.length];
        this.mClusterPopulations = new int[this.mPixels.length];
        Random random = new Random(272008L);
        for (int i = 0; i < this.mPixels.length; ++i) {
            int clusterIndex;
            this.mClusterIndices[i] = clusterIndex = random.nextInt(maxColors);
            this.mClusterPopulations[i] = this.mInputPixelToCount.get(this.mPixels[i]);
        }
    }

    void calculateClusterDistances(int maxColors) {
        int i;
        if (this.mDistanceMatrix.length != maxColors) {
            this.mDistanceMatrix = new float[maxColors][maxColors];
        }
        for (i = 0; i <= maxColors; ++i) {
            for (int j = i + 1; j < maxColors; ++j) {
                float distance;
                this.mDistanceMatrix[j][i] = distance = this.mPointProvider.distance(this.mClusters[i], this.mClusters[j]);
                this.mDistanceMatrix[i][j] = distance;
            }
        }
        if (this.mIndexMatrix.length != maxColors) {
            this.mIndexMatrix = new int[maxColors][maxColors];
        }
        for (i = 0; i < maxColors; ++i) {
            ArrayList<Distance> distances = new ArrayList<Distance>(maxColors);
            for (int index = 0; index < maxColors; ++index) {
                distances.add(new Distance(index, this.mDistanceMatrix[i][index]));
            }
            distances.sort((a, b) -> Float.compare(a.getDistance(), b.getDistance()));
            for (int j = 0; j < maxColors; ++j) {
                this.mIndexMatrix[i][j] = ((Distance)distances.get(j)).getIndex();
            }
        }
    }

    boolean reassignPoints(int maxColors) {
        boolean colorMoved = false;
        for (int i = 0; i < this.mPoints.length; ++i) {
            float distanceChange;
            int t;
            float previousDistance;
            float[] point = this.mPoints[i];
            int previousClusterIndex = this.mClusterIndices[i];
            float[] previousCluster = this.mClusters[previousClusterIndex];
            float minimumDistance = previousDistance = this.mPointProvider.distance(point, previousCluster);
            int newClusterIndex = -1;
            for (int j = 1; j < maxColors && !(this.mDistanceMatrix[previousClusterIndex][t = this.mIndexMatrix[previousClusterIndex][j]] >= 4.0f * previousDistance); ++j) {
                float distance = this.mPointProvider.distance(point, this.mClusters[t]);
                if (!(distance < minimumDistance)) continue;
                minimumDistance = distance;
                newClusterIndex = t;
            }
            if (newClusterIndex == -1 || !((distanceChange = (float)Math.abs(Math.sqrt(minimumDistance) - Math.sqrt(previousDistance))) > 3.0f)) continue;
            colorMoved = true;
            this.mClusterIndices[i] = newClusterIndex;
        }
        return colorMoved;
    }

    void recalculateClusterCenters(int maxColors) {
        int i;
        this.mClusterPopulations = new int[maxColors];
        float[] aSums = new float[maxColors];
        float[] bSums = new float[maxColors];
        float[] cSums = new float[maxColors];
        for (i = 0; i < this.mPoints.length; ++i) {
            int clusterIndex = this.mClusterIndices[i];
            float[] point = this.mPoints[i];
            int pixel = this.mPixels[i];
            int count = this.mInputPixelToCount.get(pixel);
            int n = clusterIndex;
            this.mClusterPopulations[n] = this.mClusterPopulations[n] + count;
            int n2 = clusterIndex;
            aSums[n2] = aSums[n2] + point[0] * (float)count;
            int n3 = clusterIndex;
            bSums[n3] = bSums[n3] + point[1] * (float)count;
            int n4 = clusterIndex;
            cSums[n4] = cSums[n4] + point[2] * (float)count;
        }
        for (i = 0; i < maxColors; ++i) {
            int count = this.mClusterPopulations[i];
            float aSum = aSums[i];
            float bSum = bSums[i];
            float cSum = cSums[i];
            this.mClusters[i][0] = aSum / (float)count;
            this.mClusters[i][1] = bSum / (float)count;
            this.mClusters[i][2] = cSum / (float)count;
        }
    }

    private static class Distance {
        private final int mIndex;
        private final float mDistance;

        int getIndex() {
            return this.mIndex;
        }

        float getDistance() {
            return this.mDistance;
        }

        Distance(int index, float distance) {
            this.mIndex = index;
            this.mDistance = distance;
        }
    }
}

