/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.os.RemoteException;
import android.os.ServiceManager;
import android.os._Original_Build;
import android.util.Log;
import android.util.proto.ProtoOutputStream;
import android.view.inputmethod.InputMethodManager;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.inputmethod.ImeTracing;
import com.android.internal.util.TraceBuffer;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

class ImeTracingServerImpl
extends ImeTracing {
    private static final String TRACE_DIRNAME = "/data/misc/wmtrace/";
    private static final String TRACE_FILENAME_CLIENTS = "ime_trace_clients.winscope";
    private static final String TRACE_FILENAME_IMS = "ime_trace_service.winscope";
    private static final String TRACE_FILENAME_IMMS = "ime_trace_managerservice.winscope";
    private static final int BUFFER_CAPACITY = 0x400000;
    private static final long MAGIC_NUMBER_CLIENTS_VALUE = 4990904633913462089L;
    private static final long MAGIC_NUMBER_IMS_VALUE = 4990904633914510665L;
    private static final long MAGIC_NUMBER_IMMS_VALUE = 4990904633914117449L;
    private final TraceBuffer mBufferClients;
    private final File mTraceFileClients;
    private final TraceBuffer mBufferIms;
    private final File mTraceFileIms;
    private final TraceBuffer mBufferImms;
    private final File mTraceFileImms;
    private final Object mEnabledLock = new Object();

    ImeTracingServerImpl() throws ServiceManager.ServiceNotFoundException {
        this.mBufferClients = new TraceBuffer(0x400000);
        this.mTraceFileClients = new File("/data/misc/wmtrace/ime_trace_clients.winscope");
        this.mBufferIms = new TraceBuffer(0x400000);
        this.mTraceFileIms = new File("/data/misc/wmtrace/ime_trace_service.winscope");
        this.mBufferImms = new TraceBuffer(0x400000);
        this.mTraceFileImms = new File("/data/misc/wmtrace/ime_trace_managerservice.winscope");
    }

    @Override
    public void addToBuffer(ProtoOutputStream proto, int source) {
        if (this.isAvailable() && this.isEnabled()) {
            switch (source) {
                case 0: {
                    this.mBufferClients.add(proto);
                    return;
                }
                case 1: {
                    this.mBufferIms.add(proto);
                    return;
                }
                case 2: {
                    this.mBufferImms.add(proto);
                    return;
                }
            }
            Log.w("imeTracing", "Request to add to buffer, but source not recognised.");
        }
    }

    @Override
    public void triggerClientDump(String where, InputMethodManager immInstance, byte[] icProto) {
    }

    @Override
    public void triggerServiceDump(String where, ImeTracing.ServiceDumper dumper, byte[] icProto) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerManagerServiceDump(String where) {
        if (!this.isEnabled() || !this.isAvailable()) {
            return;
        }
        Object object = this.mDumpInProgressLock;
        synchronized (object) {
            if (this.mDumpInProgress) {
                return;
            }
            this.mDumpInProgress = true;
        }
        try {
            this.sendToService(null, 2, where);
        }
        catch (RemoteException e) {
            Log.e("imeTracing", "Exception while sending ime-related manager service dump to server", e);
        }
        finally {
            this.mDumpInProgress = false;
        }
    }

    private void writeTracesToFilesLocked() {
        try {
            ProtoOutputStream clientsProto = new ProtoOutputStream();
            clientsProto.write(0x10600000001L, 4990904633913462089L);
            this.mBufferClients.writeTraceToFile(this.mTraceFileClients, clientsProto);
            ProtoOutputStream imsProto = new ProtoOutputStream();
            imsProto.write(0x10600000001L, 4990904633914510665L);
            this.mBufferIms.writeTraceToFile(this.mTraceFileIms, imsProto);
            ProtoOutputStream immsProto = new ProtoOutputStream();
            immsProto.write(0x10600000001L, 4990904633914117449L);
            this.mBufferImms.writeTraceToFile(this.mTraceFileImms, immsProto);
            this.resetBuffers();
        }
        catch (IOException e) {
            Log.e("imeTracing", "Unable to write buffer to file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value={"mEnabledLock"})
    public void startTrace(PrintWriter pw) {
        if (_Original_Build.IS_USER) {
            Log.w("imeTracing", "Warn: Tracing is not supported on user builds.");
            return;
        }
        Object object = this.mEnabledLock;
        synchronized (object) {
            if (this.isAvailable() && this.isEnabled()) {
                Log.w("imeTracing", "Warn: Tracing is already started.");
                return;
            }
            this.logAndPrintln(pw, "Starting tracing in /data/misc/wmtrace/: ime_trace_clients.winscope, ime_trace_service.winscope, ime_trace_managerservice.winscope");
            sEnabled = true;
            this.resetBuffers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopTrace(PrintWriter pw) {
        if (_Original_Build.IS_USER) {
            Log.w("imeTracing", "Warn: Tracing is not supported on user builds.");
            return;
        }
        Object object = this.mEnabledLock;
        synchronized (object) {
            if (!this.isAvailable() || !this.isEnabled()) {
                Log.w("imeTracing", "Warn: Tracing is not available or not started.");
                return;
            }
            this.logAndPrintln(pw, "Stopping tracing and writing traces in /data/misc/wmtrace/: ime_trace_clients.winscope, ime_trace_service.winscope, ime_trace_managerservice.winscope");
            sEnabled = false;
            this.writeTracesToFilesLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveForBugreport(PrintWriter pw) {
        if (_Original_Build.IS_USER) {
            return;
        }
        Object object = this.mEnabledLock;
        synchronized (object) {
            if (!this.isAvailable() || !this.isEnabled()) {
                return;
            }
            sEnabled = false;
            this.logAndPrintln(pw, "Writing traces in /data/misc/wmtrace/: ime_trace_clients.winscope, ime_trace_service.winscope, ime_trace_managerservice.winscope");
            this.writeTracesToFilesLocked();
            sEnabled = true;
        }
    }

    private void resetBuffers() {
        this.mBufferClients.resetBuffer();
        this.mBufferIms.resetBuffer();
        this.mBufferImms.resetBuffer();
    }
}

