/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import libcore.util.NativeAllocationRegistry;

public class LongArrayMultiStateCounter
implements Parcelable {
    private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(LongArrayMultiStateCounter.class.getClassLoader(), LongArrayMultiStateCounter.native_getReleaseFunc());
    private static final AtomicReference<LongArrayContainer> sTmpArrayContainer = new AtomicReference();
    private final int mStateCount;
    private final int mLength;
    final long mNativeObject;
    public static final Parcelable.Creator<LongArrayMultiStateCounter> CREATOR = new Parcelable.Creator<LongArrayMultiStateCounter>(){

        @Override
        public LongArrayMultiStateCounter createFromParcel(Parcel in) {
            return new LongArrayMultiStateCounter(in);
        }

        public LongArrayMultiStateCounter[] newArray(int size) {
            return new LongArrayMultiStateCounter[size];
        }
    };

    public LongArrayMultiStateCounter(int stateCount, int arrayLength) {
        Preconditions.checkArgumentPositive(stateCount, "stateCount must be greater than 0");
        this.mStateCount = stateCount;
        this.mLength = arrayLength;
        this.mNativeObject = LongArrayMultiStateCounter.native_init(stateCount, arrayLength);
        sRegistry.registerNativeAllocation(this, this.mNativeObject);
    }

    private LongArrayMultiStateCounter(Parcel in) {
        this.mNativeObject = LongArrayMultiStateCounter.native_initFromParcel(in);
        sRegistry.registerNativeAllocation(this, this.mNativeObject);
        this.mStateCount = LongArrayMultiStateCounter.native_getStateCount(this.mNativeObject);
        this.mLength = LongArrayMultiStateCounter.native_getArrayLength(this.mNativeObject);
    }

    public int getStateCount() {
        return this.mStateCount;
    }

    public int getArrayLength() {
        return this.mLength;
    }

    public void setEnabled(boolean enabled, long timestampMs) {
        LongArrayMultiStateCounter.native_setEnabled(this.mNativeObject, enabled, timestampMs);
    }

    public void setState(int state, long timestampMs) {
        if (state < 0 || state >= this.mStateCount) {
            throw new IllegalArgumentException("State: " + state + ", outside the range: [0-" + (this.mStateCount - 1) + "]");
        }
        LongArrayMultiStateCounter.native_setState(this.mNativeObject, state, timestampMs);
    }

    public void updateValues(LongArrayContainer longArrayContainer, long timestampMs) {
        if (longArrayContainer.mLength != this.mLength) {
            throw new IllegalArgumentException("Invalid array length: " + longArrayContainer.mLength + ", expected: " + this.mLength);
        }
        LongArrayMultiStateCounter.native_updateValues(this.mNativeObject, longArrayContainer.mNativeObject, timestampMs);
    }

    public void addCounts(LongArrayContainer counts) {
        if (counts.mLength != this.mLength) {
            throw new IllegalArgumentException("Invalid array length: " + counts.mLength + ", expected: " + this.mLength);
        }
        LongArrayMultiStateCounter.native_addCounts(this.mNativeObject, counts.mNativeObject);
    }

    public void reset() {
        LongArrayMultiStateCounter.native_reset(this.mNativeObject);
    }

    public void getCounts(long[] counts, int state) {
        LongArrayContainer container = sTmpArrayContainer.getAndSet(null);
        if (container == null || container.mLength != counts.length) {
            container = new LongArrayContainer(counts.length);
        }
        this.getCounts(container, state);
        container.getValues(counts);
        sTmpArrayContainer.set(container);
    }

    public void getCounts(LongArrayContainer longArrayContainer, int state) {
        if (state < 0 || state >= this.mStateCount) {
            throw new IllegalArgumentException("State: " + state + ", outside the range: [0-" + this.mStateCount + "]");
        }
        LongArrayMultiStateCounter.native_getCounts(this.mNativeObject, longArrayContainer.mNativeObject, state);
    }

    public String toString() {
        return this.native_toString(this.mNativeObject);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.native_writeToParcel(this.mNativeObject, dest, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @CriticalNative
    private static long native_init(int n, int n2) {
        return OverrideMethod.invokeL("com.android.internal.os.LongArrayMultiStateCounter#native_init(II)J", true, null);
    }

    @CriticalNative
    private static long native_getReleaseFunc() {
        return OverrideMethod.invokeL("com.android.internal.os.LongArrayMultiStateCounter#native_getReleaseFunc()J", true, null);
    }

    @CriticalNative
    private static void native_setEnabled(long l, boolean bl, long l2) {
        OverrideMethod.invokeV("com.android.internal.os.LongArrayMultiStateCounter#native_setEnabled(JZJ)V", true, null);
    }

    @CriticalNative
    private static void native_setState(long l, int n, long l2) {
        OverrideMethod.invokeV("com.android.internal.os.LongArrayMultiStateCounter#native_setState(JIJ)V", true, null);
    }

    @CriticalNative
    private static void native_updateValues(long l, long l2, long l3) {
        OverrideMethod.invokeV("com.android.internal.os.LongArrayMultiStateCounter#native_updateValues(JJJ)V", true, null);
    }

    @CriticalNative
    private static void native_addCounts(long l, long l2) {
        OverrideMethod.invokeV("com.android.internal.os.LongArrayMultiStateCounter#native_addCounts(JJ)V", true, null);
    }

    @CriticalNative
    private static void native_reset(long l) {
        OverrideMethod.invokeV("com.android.internal.os.LongArrayMultiStateCounter#native_reset(J)V", true, null);
    }

    @CriticalNative
    private static void native_getCounts(long l, long l2, int n) {
        OverrideMethod.invokeV("com.android.internal.os.LongArrayMultiStateCounter#native_getCounts(JJI)V", true, null);
    }

    @FastNative
    private String native_toString(long l) {
        return (String)OverrideMethod.invokeA("com.android.internal.os.LongArrayMultiStateCounter#native_toString(J)Ljava/lang/String;", true, this);
    }

    @FastNative
    private void native_writeToParcel(long l, Parcel parcel, int n) {
        OverrideMethod.invokeV("com.android.internal.os.LongArrayMultiStateCounter#native_writeToParcel(JLandroid/os/Parcel;I)V", true, this);
    }

    @FastNative
    private static long native_initFromParcel(Parcel parcel) {
        return OverrideMethod.invokeL("com.android.internal.os.LongArrayMultiStateCounter#native_initFromParcel(Landroid/os/Parcel;)J", true, null);
    }

    @CriticalNative
    private static int native_getStateCount(long l) {
        return OverrideMethod.invokeI("com.android.internal.os.LongArrayMultiStateCounter#native_getStateCount(J)I", true, null);
    }

    @CriticalNative
    private static int native_getArrayLength(long l) {
        return OverrideMethod.invokeI("com.android.internal.os.LongArrayMultiStateCounter#native_getArrayLength(J)I", true, null);
    }

    public static class LongArrayContainer {
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(LongArrayContainer.class.getClassLoader(), LongArrayContainer.native_getReleaseFunc());
        final long mNativeObject;
        private final int mLength;

        public LongArrayContainer(int length) {
            this.mLength = length;
            this.mNativeObject = LongArrayContainer.native_init(length);
            sRegistry.registerNativeAllocation(this, this.mNativeObject);
        }

        public void setValues(long[] array2) {
            if (array2.length != this.mLength) {
                throw new IllegalArgumentException("Invalid array length: " + this.mLength + ", expected: " + this.mLength);
            }
            this.native_setValues(this.mNativeObject, array2);
        }

        public void getValues(long[] array2) {
            if (array2.length != this.mLength) {
                throw new IllegalArgumentException("Invalid array length: " + this.mLength + ", expected: " + this.mLength);
            }
            this.native_getValues(this.mNativeObject, array2);
        }

        public String toString() {
            long[] array2 = new long[this.mLength];
            this.getValues(array2);
            return Arrays.toString(array2);
        }

        @CriticalNative
        private static long native_init(int n) {
            return OverrideMethod.invokeL("com.android.internal.os.LongArrayMultiStateCounter$LongArrayContainer#native_init(I)J", true, null);
        }

        @CriticalNative
        private static long native_getReleaseFunc() {
            return OverrideMethod.invokeL("com.android.internal.os.LongArrayMultiStateCounter$LongArrayContainer#native_getReleaseFunc()J", true, null);
        }

        @FastNative
        private void native_setValues(long l, long[] lArray) {
            OverrideMethod.invokeV("com.android.internal.os.LongArrayMultiStateCounter$LongArrayContainer#native_setValues(J[J)V", true, this);
        }

        @FastNative
        private void native_getValues(long l, long[] lArray) {
            OverrideMethod.invokeV("com.android.internal.os.LongArrayMultiStateCounter$LongArrayContainer#native_getValues(J[J)V", true, this);
        }
    }
}

