/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.Notification;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RemoteViews;
import com.android.internal.widget.IMessagingLayout;
import com.android.internal.widget.ImageResolver;
import com.android.internal.widget.LocalImageResolver;
import com.android.internal.widget.MessagingLayout;
import com.android.internal.widget.MessagingLinearLayout;
import com.android.internal.widget.MessagingMessage;
import com.android.internal.widget.MessagingMessageState;
import com.android.internal.widget.MessagingPool;
import com.android.internal.widget.MessagingTextMessage;
import java.io.IOException;

@RemoteViews.RemoteView
public class MessagingImageMessage
extends ImageView
implements MessagingMessage {
    private static final String TAG = "MessagingImageMessage";
    private static final MessagingPool<MessagingImageMessage> sInstancePool = new MessagingPool(10);
    private final MessagingMessageState mState = new MessagingMessageState(this);
    private final int mMinImageHeight;
    private final Path mPath = new Path();
    private final int mImageRounding;
    private final int mMaxImageHeight;
    private final int mIsolatedSize;
    private final int mExtraSpacing;
    private Drawable mDrawable;
    private float mAspectRatio;
    private int mActualWidth;
    private int mActualHeight;
    private boolean mIsIsolated;
    private ImageResolver mImageResolver;

    public MessagingImageMessage(Context context) {
        this(context, null);
    }

    public MessagingImageMessage(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MessagingImageMessage(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public MessagingImageMessage(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mMinImageHeight = context.getResources().getDimensionPixelSize(17105351);
        this.mMaxImageHeight = context.getResources().getDimensionPixelSize(17105350);
        this.mImageRounding = context.getResources().getDimensionPixelSize(17105352);
        this.mExtraSpacing = context.getResources().getDimensionPixelSize(17105349);
        this.setMaxHeight(this.mMaxImageHeight);
        this.mIsolatedSize = this.getResources().getDimensionPixelSize(17105346);
    }

    @Override
    public MessagingMessageState getState() {
        return this.mState;
    }

    @Override
    public boolean setMessage(Notification.MessagingStyle.Message message) {
        Drawable drawable2;
        MessagingMessage.super.setMessage(message);
        try {
            Uri uri = message.getDataUri();
            drawable2 = this.mImageResolver != null ? this.mImageResolver.loadImage(uri) : LocalImageResolver.resolveImage(uri, this.getContext());
        }
        catch (IOException | SecurityException e) {
            e.printStackTrace();
            return false;
        }
        if (drawable2 == null) {
            return false;
        }
        int intrinsicHeight = drawable2.getIntrinsicHeight();
        if (intrinsicHeight == 0) {
            Log.w(TAG, "Drawable with 0 intrinsic height was returned");
            return false;
        }
        this.mDrawable = drawable2;
        this.mAspectRatio = (float)this.mDrawable.getIntrinsicWidth() / (float)intrinsicHeight;
        this.setImageDrawable(drawable2);
        this.setContentDescription(message.getText());
        return true;
    }

    static MessagingMessage createMessage(IMessagingLayout layout2, Notification.MessagingStyle.Message m, ImageResolver resolver) {
        MessagingLinearLayout messagingLinearLayout = layout2.getMessagingLinearLayout();
        MessagingImageMessage createdMessage = (MessagingImageMessage)sInstancePool.acquire();
        if (createdMessage == null) {
            createdMessage = (MessagingImageMessage)LayoutInflater.from(layout2.getContext()).inflate(17367235, (ViewGroup)messagingLinearLayout, false);
            createdMessage.addOnLayoutChangeListener(MessagingLayout.MESSAGING_PROPERTY_ANIMATOR);
        }
        createdMessage.setImageResolver(resolver);
        boolean created = createdMessage.setMessage(m);
        if (!created) {
            createdMessage.recycle();
            return MessagingTextMessage.createMessage(layout2, m);
        }
        return createdMessage;
    }

    private void setImageResolver(ImageResolver resolver) {
        this.mImageResolver = resolver;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        canvas.save();
        canvas.clipPath(this.getRoundedRectPath());
        int width = (int)Math.max((float)Math.min(this.getHeight(), this.getActualHeight()) * this.mAspectRatio, (float)this.getActualWidth());
        int height = (int)Math.max((float)Math.min(this.getWidth(), this.getActualWidth()) / this.mAspectRatio, (float)this.getActualHeight());
        height = (int)Math.max((float)height, (float)width / this.mAspectRatio);
        int left = (int)((float)(this.getActualWidth() - width) / 2.0f);
        int top = (int)((float)(this.getActualHeight() - height) / 2.0f);
        this.mDrawable.setBounds(left, top, left + width, top + height);
        this.mDrawable.draw(canvas);
        canvas.restore();
    }

    public Path getRoundedRectPath() {
        int left = 0;
        int right = this.getActualWidth();
        int top = 0;
        int bottom = this.getActualHeight();
        this.mPath.reset();
        int width = right - left;
        float roundnessX = this.mImageRounding;
        float roundnessY = this.mImageRounding;
        roundnessX = Math.min((float)(width / 2), roundnessX);
        roundnessY = Math.min((float)((bottom - top) / 2), roundnessY);
        this.mPath.moveTo(left, (float)top + roundnessY);
        this.mPath.quadTo(left, top, (float)left + roundnessX, top);
        this.mPath.lineTo((float)right - roundnessX, top);
        this.mPath.quadTo(right, top, right, (float)top + roundnessY);
        this.mPath.lineTo(right, (float)bottom - roundnessY);
        this.mPath.quadTo(right, bottom, (float)right - roundnessX, bottom);
        this.mPath.lineTo((float)left + roundnessX, bottom);
        this.mPath.quadTo(left, bottom, left, (float)bottom - roundnessY);
        this.mPath.close();
        return this.mPath;
    }

    @Override
    public void recycle() {
        MessagingMessage.super.recycle();
        this.setImageBitmap(null);
        this.mDrawable = null;
        sInstancePool.release(this);
    }

    public static void dropCache() {
        sInstancePool.clear();
    }

    @Override
    public int getMeasuredType() {
        boolean measuredTooSmall;
        int measuredHeight = this.getMeasuredHeight();
        int minImageHeight = this.mIsIsolated ? this.mIsolatedSize : this.mMinImageHeight;
        boolean bl = measuredTooSmall = measuredHeight < minImageHeight && measuredHeight != this.mDrawable.getIntrinsicHeight();
        if (measuredTooSmall) {
            return 2;
        }
        if (!this.mIsIsolated && measuredHeight != this.mDrawable.getIntrinsicHeight()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void setMaxDisplayedLines(int lines) {
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mDrawable == null) {
            Log.e(TAG, "onMeasure() after recycle()!");
            this.setMeasuredDimension(0, 0);
            return;
        }
        if (this.mIsIsolated) {
            this.setMeasuredDimension(View.MeasureSpec.getSize(widthMeasureSpec), View.MeasureSpec.getSize(heightMeasureSpec));
        } else {
            int width = Math.min(View.MeasureSpec.getSize(widthMeasureSpec), this.mDrawable.getIntrinsicWidth());
            int height = (int)Math.min((float)View.MeasureSpec.getSize(heightMeasureSpec), (float)width / this.mAspectRatio);
            this.setMeasuredDimension(width, height);
        }
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.setActualWidth(this.getWidth());
        this.setActualHeight(this.getHeight());
    }

    @Override
    public int getConsumedLines() {
        return 3;
    }

    public void setActualWidth(int actualWidth) {
        this.mActualWidth = actualWidth;
        this.invalidate();
    }

    public int getActualWidth() {
        return this.mActualWidth;
    }

    public void setActualHeight(int actualHeight) {
        this.mActualHeight = actualHeight;
        this.invalidate();
    }

    public int getActualHeight() {
        return this.mActualHeight;
    }

    public void setIsolated(boolean isolated) {
        if (this.mIsIsolated != isolated) {
            this.mIsIsolated = isolated;
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
            layoutParams.topMargin = isolated ? 0 : this.mExtraSpacing;
            this.setLayoutParams(layoutParams);
        }
    }

    @Override
    public int getExtraSpacing() {
        return this.mExtraSpacing;
    }
}

