/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.BackStackRecord;
import android.app.Fragment;
import android.app.FragmentManagerImpl;
import android.app.SharedElementCallback;
import android.graphics.Rect;
import android.transition.Transition;
import android.transition.TransitionListenerAdapter;
import android.transition.TransitionManager;
import android.transition.TransitionSet;
import android.util.ArrayMap;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.view.OneShotPreDrawListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class FragmentTransition {
    private static final int[] INVERSE_OPS = new int[]{0, 3, 0, 1, 5, 4, 7, 6, 9, 8};

    FragmentTransition() {
    }

    static void startTransitions(FragmentManagerImpl fragmentManager, ArrayList<BackStackRecord> records, ArrayList<Boolean> isRecordPop, int startIndex, int endIndex, boolean isReordered) {
        if (fragmentManager.mCurState < 1) {
            return;
        }
        SparseArray<FragmentContainerTransition> transitioningFragments = new SparseArray<FragmentContainerTransition>();
        for (int i = startIndex; i < endIndex; ++i) {
            BackStackRecord record = records.get(i);
            boolean isPop = isRecordPop.get(i);
            if (isPop) {
                FragmentTransition.calculatePopFragments(record, transitioningFragments, isReordered);
                continue;
            }
            FragmentTransition.calculateFragments(record, transitioningFragments, isReordered);
        }
        if (transitioningFragments.size() != 0) {
            View nonExistentView = new View(fragmentManager.mHost.getContext());
            int numContainers = transitioningFragments.size();
            for (int i = 0; i < numContainers; ++i) {
                int containerId = transitioningFragments.keyAt(i);
                ArrayMap<String, String> nameOverrides = FragmentTransition.calculateNameOverrides(containerId, records, isRecordPop, startIndex, endIndex);
                FragmentContainerTransition containerTransition = transitioningFragments.valueAt(i);
                if (isReordered) {
                    FragmentTransition.configureTransitionsReordered(fragmentManager, containerId, containerTransition, nonExistentView, nameOverrides);
                    continue;
                }
                FragmentTransition.configureTransitionsOrdered(fragmentManager, containerId, containerTransition, nonExistentView, nameOverrides);
            }
        }
    }

    private static ArrayMap<String, String> calculateNameOverrides(int containerId, ArrayList<BackStackRecord> records, ArrayList<Boolean> isRecordPop, int startIndex, int endIndex) {
        ArrayMap<String, String> nameOverrides = new ArrayMap<String, String>();
        for (int recordNum = endIndex - 1; recordNum >= startIndex; --recordNum) {
            ArrayList<String> sources;
            ArrayList<String> targets;
            BackStackRecord record = records.get(recordNum);
            if (!record.interactsWith(containerId)) continue;
            boolean isPop = isRecordPop.get(recordNum);
            if (record.mSharedElementSourceNames == null) continue;
            int numSharedElements = record.mSharedElementSourceNames.size();
            if (isPop) {
                targets = record.mSharedElementSourceNames;
                sources = record.mSharedElementTargetNames;
            } else {
                sources = record.mSharedElementSourceNames;
                targets = record.mSharedElementTargetNames;
            }
            for (int i = 0; i < numSharedElements; ++i) {
                String sourceName = sources.get(i);
                String targetName = targets.get(i);
                String previousTarget = nameOverrides.remove(targetName);
                if (previousTarget != null) {
                    nameOverrides.put(sourceName, previousTarget);
                    continue;
                }
                nameOverrides.put(sourceName, targetName);
            }
        }
        return nameOverrides;
    }

    private static void configureTransitionsReordered(FragmentManagerImpl fragmentManager, int containerId, FragmentContainerTransition fragments, View nonExistentView, ArrayMap<String, String> nameOverrides) {
        ViewGroup sceneRoot = null;
        if (fragmentManager.mContainer.onHasView()) {
            sceneRoot = (ViewGroup)fragmentManager.mContainer.onFindViewById(containerId);
        }
        if (sceneRoot == null) {
            return;
        }
        Fragment inFragment = fragments.lastIn;
        Fragment outFragment = fragments.firstOut;
        boolean inIsPop = fragments.lastInIsPop;
        boolean outIsPop = fragments.firstOutIsPop;
        ArrayList<View> sharedElementsIn = new ArrayList<View>();
        ArrayList<View> sharedElementsOut = new ArrayList<View>();
        Transition enterTransition = FragmentTransition.getEnterTransition(inFragment, inIsPop);
        Transition exitTransition = FragmentTransition.getExitTransition(outFragment, outIsPop);
        TransitionSet sharedElementTransition = FragmentTransition.configureSharedElementsReordered(sceneRoot, nonExistentView, nameOverrides, fragments, sharedElementsOut, sharedElementsIn, enterTransition, exitTransition);
        if (enterTransition == null && sharedElementTransition == null && exitTransition == null) {
            return;
        }
        ArrayList<View> exitingViews = FragmentTransition.configureEnteringExitingViews(exitTransition, outFragment, sharedElementsOut, nonExistentView);
        ArrayList<View> enteringViews = FragmentTransition.configureEnteringExitingViews(enterTransition, inFragment, sharedElementsIn, nonExistentView);
        FragmentTransition.setViewVisibility(enteringViews, 4);
        Transition transition2 = FragmentTransition.mergeTransitions(enterTransition, exitTransition, sharedElementTransition, inFragment, inIsPop);
        if (transition2 != null) {
            FragmentTransition.replaceHide(exitTransition, outFragment, exitingViews);
            transition2.setNameOverrides(nameOverrides);
            FragmentTransition.scheduleRemoveTargets(transition2, enterTransition, enteringViews, exitTransition, exitingViews, sharedElementTransition, sharedElementsIn);
            TransitionManager.beginDelayedTransition(sceneRoot, transition2);
            FragmentTransition.setViewVisibility(enteringViews, 0);
            if (sharedElementTransition != null) {
                sharedElementTransition.getTargets().clear();
                sharedElementTransition.getTargets().addAll(sharedElementsIn);
                FragmentTransition.replaceTargets(sharedElementTransition, sharedElementsOut, sharedElementsIn);
            }
        }
    }

    private static void configureTransitionsOrdered(FragmentManagerImpl fragmentManager, int containerId, FragmentContainerTransition fragments, View nonExistentView, ArrayMap<String, String> nameOverrides) {
        Transition transition2;
        ViewGroup sceneRoot = null;
        if (fragmentManager.mContainer.onHasView()) {
            sceneRoot = (ViewGroup)fragmentManager.mContainer.onFindViewById(containerId);
        }
        if (sceneRoot == null) {
            return;
        }
        Fragment inFragment = fragments.lastIn;
        Fragment outFragment = fragments.firstOut;
        boolean inIsPop = fragments.lastInIsPop;
        boolean outIsPop = fragments.firstOutIsPop;
        Transition enterTransition = FragmentTransition.getEnterTransition(inFragment, inIsPop);
        Transition exitTransition = FragmentTransition.getExitTransition(outFragment, outIsPop);
        ArrayList<View> sharedElementsOut = new ArrayList<View>();
        ArrayList<View> sharedElementsIn = new ArrayList<View>();
        TransitionSet sharedElementTransition = FragmentTransition.configureSharedElementsOrdered(sceneRoot, nonExistentView, nameOverrides, fragments, sharedElementsOut, sharedElementsIn, enterTransition, exitTransition);
        if (enterTransition == null && sharedElementTransition == null && exitTransition == null) {
            return;
        }
        ArrayList<View> exitingViews = FragmentTransition.configureEnteringExitingViews(exitTransition, outFragment, sharedElementsOut, nonExistentView);
        if (exitingViews == null || exitingViews.isEmpty()) {
            exitTransition = null;
        }
        if (enterTransition != null) {
            enterTransition.addTarget(nonExistentView);
        }
        if ((transition2 = FragmentTransition.mergeTransitions(enterTransition, exitTransition, sharedElementTransition, inFragment, fragments.lastInIsPop)) != null) {
            transition2.setNameOverrides(nameOverrides);
            ArrayList<View> enteringViews = new ArrayList<View>();
            FragmentTransition.scheduleRemoveTargets(transition2, enterTransition, enteringViews, exitTransition, exitingViews, sharedElementTransition, sharedElementsIn);
            FragmentTransition.scheduleTargetChange(sceneRoot, inFragment, nonExistentView, sharedElementsIn, enterTransition, enteringViews, exitTransition, exitingViews);
            TransitionManager.beginDelayedTransition(sceneRoot, transition2);
        }
    }

    private static void replaceHide(Transition exitTransition, Fragment exitingFragment, final ArrayList<View> exitingViews) {
        if (exitingFragment != null && exitTransition != null && exitingFragment.mAdded && exitingFragment.mHidden && exitingFragment.mHiddenChanged) {
            exitingFragment.setHideReplaced(true);
            final View fragmentView = exitingFragment.getView();
            OneShotPreDrawListener.add(exitingFragment.mContainer, () -> FragmentTransition.setViewVisibility(exitingViews, 4));
            exitTransition.addListener(new TransitionListenerAdapter(){

                @Override
                public void onTransitionEnd(Transition transition2) {
                    transition2.removeListener(this);
                    fragmentView.setVisibility(8);
                    FragmentTransition.setViewVisibility(exitingViews, 0);
                }
            });
        }
    }

    private static void scheduleTargetChange(ViewGroup sceneRoot, Fragment inFragment, View nonExistentView, ArrayList<View> sharedElementsIn, Transition enterTransition, ArrayList<View> enteringViews, Transition exitTransition, ArrayList<View> exitingViews) {
        OneShotPreDrawListener.add(sceneRoot, () -> {
            if (enterTransition != null) {
                enterTransition.removeTarget(nonExistentView);
                ArrayList<View> views = FragmentTransition.configureEnteringExitingViews(enterTransition, inFragment, sharedElementsIn, nonExistentView);
                enteringViews.addAll(views);
            }
            if (exitingViews != null) {
                if (exitTransition != null) {
                    ArrayList<View> tempExiting = new ArrayList<View>();
                    tempExiting.add(nonExistentView);
                    FragmentTransition.replaceTargets(exitTransition, exitingViews, tempExiting);
                }
                exitingViews.clear();
                exitingViews.add(nonExistentView);
            }
        });
    }

    private static TransitionSet getSharedElementTransition(Fragment inFragment, Fragment outFragment, boolean isPop) {
        if (inFragment == null || outFragment == null) {
            return null;
        }
        Transition transition2 = FragmentTransition.cloneTransition(isPop ? outFragment.getSharedElementReturnTransition() : inFragment.getSharedElementEnterTransition());
        if (transition2 == null) {
            return null;
        }
        TransitionSet transitionSet = new TransitionSet();
        transitionSet.addTransition(transition2);
        return transitionSet;
    }

    private static Transition getEnterTransition(Fragment inFragment, boolean isPop) {
        if (inFragment == null) {
            return null;
        }
        return FragmentTransition.cloneTransition(isPop ? inFragment.getReenterTransition() : inFragment.getEnterTransition());
    }

    private static Transition getExitTransition(Fragment outFragment, boolean isPop) {
        if (outFragment == null) {
            return null;
        }
        return FragmentTransition.cloneTransition(isPop ? outFragment.getReturnTransition() : outFragment.getExitTransition());
    }

    private static Transition cloneTransition(Transition transition2) {
        if (transition2 != null) {
            transition2 = transition2.clone();
        }
        return transition2;
    }

    private static TransitionSet configureSharedElementsReordered(ViewGroup sceneRoot, View nonExistentView, ArrayMap<String, String> nameOverrides, FragmentContainerTransition fragments, ArrayList<View> sharedElementsOut, ArrayList<View> sharedElementsIn, Transition enterTransition, Transition exitTransition) {
        View epicenterView;
        Rect epicenter;
        Fragment inFragment = fragments.lastIn;
        Fragment outFragment = fragments.firstOut;
        if (inFragment != null) {
            inFragment.getView().setVisibility(0);
        }
        if (inFragment == null || outFragment == null) {
            return null;
        }
        boolean inIsPop = fragments.lastInIsPop;
        TransitionSet sharedElementTransition = nameOverrides.isEmpty() ? null : FragmentTransition.getSharedElementTransition(inFragment, outFragment, inIsPop);
        ArrayMap<String, View> outSharedElements = FragmentTransition.captureOutSharedElements(nameOverrides, sharedElementTransition, fragments);
        ArrayMap<String, View> inSharedElements = FragmentTransition.captureInSharedElements(nameOverrides, sharedElementTransition, fragments);
        if (nameOverrides.isEmpty()) {
            sharedElementTransition = null;
            if (outSharedElements != null) {
                outSharedElements.clear();
            }
            if (inSharedElements != null) {
                inSharedElements.clear();
            }
        } else {
            FragmentTransition.addSharedElementsWithMatchingNames(sharedElementsOut, outSharedElements, nameOverrides.keySet());
            FragmentTransition.addSharedElementsWithMatchingNames(sharedElementsIn, inSharedElements, nameOverrides.values());
        }
        if (enterTransition == null && exitTransition == null && sharedElementTransition == null) {
            return null;
        }
        FragmentTransition.callSharedElementStartEnd(inFragment, outFragment, inIsPop, outSharedElements, true);
        if (sharedElementTransition != null) {
            sharedElementsIn.add(nonExistentView);
            FragmentTransition.setSharedElementTargets(sharedElementTransition, nonExistentView, sharedElementsOut);
            boolean outIsPop = fragments.firstOutIsPop;
            BackStackRecord outTransaction = fragments.firstOutTransaction;
            FragmentTransition.setOutEpicenter(sharedElementTransition, exitTransition, outSharedElements, outIsPop, outTransaction);
            epicenter = new Rect();
            epicenterView = FragmentTransition.getInEpicenterView(inSharedElements, fragments, enterTransition, inIsPop);
            if (epicenterView != null) {
                enterTransition.setEpicenterCallback(new Transition.EpicenterCallback(){

                    @Override
                    public Rect onGetEpicenter(Transition transition2) {
                        return epicenter;
                    }
                });
            }
        } else {
            epicenter = null;
            epicenterView = null;
        }
        OneShotPreDrawListener.add(sceneRoot, () -> {
            FragmentTransition.callSharedElementStartEnd(inFragment, outFragment, inIsPop, inSharedElements, false);
            if (epicenterView != null) {
                epicenterView.getBoundsOnScreen(epicenter);
            }
        });
        return sharedElementTransition;
    }

    private static void addSharedElementsWithMatchingNames(ArrayList<View> views, ArrayMap<String, View> sharedElements, Collection<String> nameOverridesSet) {
        for (int i = sharedElements.size() - 1; i >= 0; --i) {
            View view = sharedElements.valueAt(i);
            if (view == null || !nameOverridesSet.contains(view.getTransitionName())) continue;
            views.add(view);
        }
    }

    private static TransitionSet configureSharedElementsOrdered(ViewGroup sceneRoot, View nonExistentView, ArrayMap<String, String> nameOverrides, FragmentContainerTransition fragments, ArrayList<View> sharedElementsOut, ArrayList<View> sharedElementsIn, Transition enterTransition, Transition exitTransition) {
        Rect inEpicenter;
        Fragment inFragment = fragments.lastIn;
        Fragment outFragment = fragments.firstOut;
        if (inFragment == null || outFragment == null) {
            return null;
        }
        boolean inIsPop = fragments.lastInIsPop;
        TransitionSet sharedElementTransition = nameOverrides.isEmpty() ? null : FragmentTransition.getSharedElementTransition(inFragment, outFragment, inIsPop);
        ArrayMap<String, View> outSharedElements = FragmentTransition.captureOutSharedElements(nameOverrides, sharedElementTransition, fragments);
        if (nameOverrides.isEmpty()) {
            sharedElementTransition = null;
        } else {
            sharedElementsOut.addAll(outSharedElements.values());
        }
        if (enterTransition == null && exitTransition == null && sharedElementTransition == null) {
            return null;
        }
        FragmentTransition.callSharedElementStartEnd(inFragment, outFragment, inIsPop, outSharedElements, true);
        if (sharedElementTransition != null) {
            inEpicenter = new Rect();
            FragmentTransition.setSharedElementTargets(sharedElementTransition, nonExistentView, sharedElementsOut);
            boolean outIsPop = fragments.firstOutIsPop;
            BackStackRecord outTransaction = fragments.firstOutTransaction;
            FragmentTransition.setOutEpicenter(sharedElementTransition, exitTransition, outSharedElements, outIsPop, outTransaction);
            if (enterTransition != null) {
                enterTransition.setEpicenterCallback(new Transition.EpicenterCallback(){

                    @Override
                    public Rect onGetEpicenter(Transition transition2) {
                        if (inEpicenter.isEmpty()) {
                            return null;
                        }
                        return inEpicenter;
                    }
                });
            }
        } else {
            inEpicenter = null;
        }
        TransitionSet finalSharedElementTransition = sharedElementTransition;
        OneShotPreDrawListener.add(sceneRoot, () -> {
            ArrayMap<String, View> inSharedElements = FragmentTransition.captureInSharedElements(nameOverrides, finalSharedElementTransition, fragments);
            if (inSharedElements != null) {
                sharedElementsIn.addAll(inSharedElements.values());
                sharedElementsIn.add(nonExistentView);
            }
            FragmentTransition.callSharedElementStartEnd(inFragment, outFragment, inIsPop, inSharedElements, false);
            if (finalSharedElementTransition != null) {
                finalSharedElementTransition.getTargets().clear();
                finalSharedElementTransition.getTargets().addAll(sharedElementsIn);
                FragmentTransition.replaceTargets(finalSharedElementTransition, sharedElementsOut, sharedElementsIn);
                View inEpicenterView = FragmentTransition.getInEpicenterView(inSharedElements, fragments, enterTransition, inIsPop);
                if (inEpicenterView != null) {
                    inEpicenterView.getBoundsOnScreen(inEpicenter);
                }
            }
        });
        return sharedElementTransition;
    }

    private static ArrayMap<String, View> captureOutSharedElements(ArrayMap<String, String> nameOverrides, TransitionSet sharedElementTransition, FragmentContainerTransition fragments) {
        ArrayList<String> names;
        SharedElementCallback sharedElementCallback;
        if (nameOverrides.isEmpty() || sharedElementTransition == null) {
            nameOverrides.clear();
            return null;
        }
        Fragment outFragment = fragments.firstOut;
        ArrayMap<String, View> outSharedElements = new ArrayMap<String, View>();
        outFragment.getView().findNamedViews(outSharedElements);
        BackStackRecord outTransaction = fragments.firstOutTransaction;
        if (fragments.firstOutIsPop) {
            sharedElementCallback = outFragment.getEnterTransitionCallback();
            names = outTransaction.mSharedElementTargetNames;
        } else {
            sharedElementCallback = outFragment.getExitTransitionCallback();
            names = outTransaction.mSharedElementSourceNames;
        }
        outSharedElements.retainAll(names);
        if (sharedElementCallback != null) {
            sharedElementCallback.onMapSharedElements(names, outSharedElements);
            for (int i = names.size() - 1; i >= 0; --i) {
                String name = names.get(i);
                View view = outSharedElements.get(name);
                if (view == null) {
                    nameOverrides.remove(name);
                    continue;
                }
                if (name.equals(view.getTransitionName())) continue;
                String targetValue = nameOverrides.remove(name);
                nameOverrides.put(view.getTransitionName(), targetValue);
            }
        } else {
            nameOverrides.retainAll(outSharedElements.keySet());
        }
        return outSharedElements;
    }

    private static ArrayMap<String, View> captureInSharedElements(ArrayMap<String, String> nameOverrides, TransitionSet sharedElementTransition, FragmentContainerTransition fragments) {
        ArrayList<String> names;
        SharedElementCallback sharedElementCallback;
        Fragment inFragment = fragments.lastIn;
        View fragmentView = inFragment.getView();
        if (nameOverrides.isEmpty() || sharedElementTransition == null || fragmentView == null) {
            nameOverrides.clear();
            return null;
        }
        ArrayMap<String, View> inSharedElements = new ArrayMap<String, View>();
        fragmentView.findNamedViews(inSharedElements);
        BackStackRecord inTransaction = fragments.lastInTransaction;
        if (fragments.lastInIsPop) {
            sharedElementCallback = inFragment.getExitTransitionCallback();
            names = inTransaction.mSharedElementSourceNames;
        } else {
            sharedElementCallback = inFragment.getEnterTransitionCallback();
            names = inTransaction.mSharedElementTargetNames;
        }
        if (names != null) {
            inSharedElements.retainAll(names);
        }
        if (names != null && sharedElementCallback != null) {
            sharedElementCallback.onMapSharedElements(names, inSharedElements);
            for (int i = names.size() - 1; i >= 0; --i) {
                String key;
                String name = names.get(i);
                View view = inSharedElements.get(name);
                if (view == null) {
                    key = FragmentTransition.findKeyForValue(nameOverrides, name);
                    if (key == null) continue;
                    nameOverrides.remove(key);
                    continue;
                }
                if (name.equals(view.getTransitionName()) || (key = FragmentTransition.findKeyForValue(nameOverrides, name)) == null) continue;
                nameOverrides.put(key, view.getTransitionName());
            }
        } else {
            FragmentTransition.retainValues(nameOverrides, inSharedElements);
        }
        return inSharedElements;
    }

    private static String findKeyForValue(ArrayMap<String, String> map, String value) {
        int numElements = map.size();
        for (int i = 0; i < numElements; ++i) {
            if (!value.equals(map.valueAt(i))) continue;
            return map.keyAt(i);
        }
        return null;
    }

    private static View getInEpicenterView(ArrayMap<String, View> inSharedElements, FragmentContainerTransition fragments, Transition enterTransition, boolean inIsPop) {
        BackStackRecord inTransaction = fragments.lastInTransaction;
        if (enterTransition != null && inSharedElements != null && inTransaction.mSharedElementSourceNames != null && !inTransaction.mSharedElementSourceNames.isEmpty()) {
            String targetName = inIsPop ? inTransaction.mSharedElementSourceNames.get(0) : inTransaction.mSharedElementTargetNames.get(0);
            return inSharedElements.get(targetName);
        }
        return null;
    }

    private static void setOutEpicenter(TransitionSet sharedElementTransition, Transition exitTransition, ArrayMap<String, View> outSharedElements, boolean outIsPop, BackStackRecord outTransaction) {
        if (outTransaction.mSharedElementSourceNames != null && !outTransaction.mSharedElementSourceNames.isEmpty()) {
            String sourceName = outIsPop ? outTransaction.mSharedElementTargetNames.get(0) : outTransaction.mSharedElementSourceNames.get(0);
            View outEpicenterView = outSharedElements.get(sourceName);
            FragmentTransition.setEpicenter(sharedElementTransition, outEpicenterView);
            if (exitTransition != null) {
                FragmentTransition.setEpicenter(exitTransition, outEpicenterView);
            }
        }
    }

    private static void setEpicenter(Transition transition2, View view) {
        if (view != null) {
            final Rect epicenter = new Rect();
            view.getBoundsOnScreen(epicenter);
            transition2.setEpicenterCallback(new Transition.EpicenterCallback(){

                @Override
                public Rect onGetEpicenter(Transition transition2) {
                    return epicenter;
                }
            });
        }
    }

    private static void retainValues(ArrayMap<String, String> nameOverrides, ArrayMap<String, View> namedViews) {
        for (int i = nameOverrides.size() - 1; i >= 0; --i) {
            String targetName = nameOverrides.valueAt(i);
            if (namedViews.containsKey(targetName)) continue;
            nameOverrides.removeAt(i);
        }
    }

    private static void callSharedElementStartEnd(Fragment inFragment, Fragment outFragment, boolean isPop, ArrayMap<String, View> sharedElements, boolean isStart) {
        SharedElementCallback sharedElementCallback;
        SharedElementCallback sharedElementCallback2 = sharedElementCallback = isPop ? outFragment.getEnterTransitionCallback() : inFragment.getEnterTransitionCallback();
        if (sharedElementCallback != null) {
            ArrayList<View> views = new ArrayList<View>();
            ArrayList<String> names = new ArrayList<String>();
            int count = sharedElements == null ? 0 : sharedElements.size();
            for (int i = 0; i < count; ++i) {
                names.add(sharedElements.keyAt(i));
                views.add(sharedElements.valueAt(i));
            }
            if (isStart) {
                sharedElementCallback.onSharedElementStart(names, views, null);
            } else {
                sharedElementCallback.onSharedElementEnd(names, views, null);
            }
        }
    }

    private static void setSharedElementTargets(TransitionSet transition2, View nonExistentView, ArrayList<View> sharedViews) {
        List<View> views = transition2.getTargets();
        views.clear();
        int count = sharedViews.size();
        for (int i = 0; i < count; ++i) {
            View view = sharedViews.get(i);
            FragmentTransition.bfsAddViewChildren(views, view);
        }
        views.add(nonExistentView);
        sharedViews.add(nonExistentView);
        FragmentTransition.addTargets(transition2, sharedViews);
    }

    private static void bfsAddViewChildren(List<View> views, View startView) {
        int startIndex = views.size();
        if (FragmentTransition.containedBeforeIndex(views, startView, startIndex)) {
            return;
        }
        views.add(startView);
        for (int index = startIndex; index < views.size(); ++index) {
            View view = views.get(index);
            if (!(view instanceof ViewGroup)) continue;
            ViewGroup viewGroup = (ViewGroup)view;
            int childCount = viewGroup.getChildCount();
            for (int childIndex = 0; childIndex < childCount; ++childIndex) {
                View child = viewGroup.getChildAt(childIndex);
                if (FragmentTransition.containedBeforeIndex(views, child, startIndex)) continue;
                views.add(child);
            }
        }
    }

    private static boolean containedBeforeIndex(List<View> views, View view, int maxIndex) {
        for (int i = 0; i < maxIndex; ++i) {
            if (views.get(i) != view) continue;
            return true;
        }
        return false;
    }

    private static void scheduleRemoveTargets(Transition overalTransition, final Transition enterTransition, final ArrayList<View> enteringViews, final Transition exitTransition, final ArrayList<View> exitingViews, final TransitionSet sharedElementTransition, final ArrayList<View> sharedElementsIn) {
        overalTransition.addListener(new TransitionListenerAdapter(){

            @Override
            public void onTransitionStart(Transition transition2) {
                if (enterTransition != null) {
                    FragmentTransition.replaceTargets(enterTransition, enteringViews, null);
                }
                if (exitTransition != null) {
                    FragmentTransition.replaceTargets(exitTransition, exitingViews, null);
                }
                if (sharedElementTransition != null) {
                    FragmentTransition.replaceTargets(sharedElementTransition, sharedElementsIn, null);
                }
            }

            @Override
            public void onTransitionEnd(Transition transition2) {
                transition2.removeListener(this);
            }
        });
    }

    public static void replaceTargets(Transition transition2, ArrayList<View> oldTargets, ArrayList<View> newTargets) {
        block4: {
            int i;
            List<View> targets;
            block3: {
                if (!(transition2 instanceof TransitionSet)) break block3;
                TransitionSet set = (TransitionSet)transition2;
                int numTransitions = set.getTransitionCount();
                for (int i2 = 0; i2 < numTransitions; ++i2) {
                    Transition child = set.getTransitionAt(i2);
                    FragmentTransition.replaceTargets(child, oldTargets, newTargets);
                }
                break block4;
            }
            if (FragmentTransition.hasSimpleTarget(transition2) || (targets = transition2.getTargets()) == null || targets.size() != oldTargets.size() || !targets.containsAll(oldTargets)) break block4;
            int targetCount = newTargets == null ? 0 : newTargets.size();
            for (i = 0; i < targetCount; ++i) {
                transition2.addTarget(newTargets.get(i));
            }
            for (i = oldTargets.size() - 1; i >= 0; --i) {
                transition2.removeTarget(oldTargets.get(i));
            }
        }
    }

    public static void addTargets(Transition transition2, ArrayList<View> views) {
        block4: {
            List<View> targets;
            block3: {
                if (transition2 == null) {
                    return;
                }
                if (!(transition2 instanceof TransitionSet)) break block3;
                TransitionSet set = (TransitionSet)transition2;
                int numTransitions = set.getTransitionCount();
                for (int i = 0; i < numTransitions; ++i) {
                    Transition child = set.getTransitionAt(i);
                    FragmentTransition.addTargets(child, views);
                }
                break block4;
            }
            if (FragmentTransition.hasSimpleTarget(transition2) || !FragmentTransition.isNullOrEmpty(targets = transition2.getTargets())) break block4;
            int numViews = views.size();
            for (int i = 0; i < numViews; ++i) {
                transition2.addTarget(views.get(i));
            }
        }
    }

    private static boolean hasSimpleTarget(Transition transition2) {
        return !FragmentTransition.isNullOrEmpty(transition2.getTargetIds()) || !FragmentTransition.isNullOrEmpty(transition2.getTargetNames()) || !FragmentTransition.isNullOrEmpty(transition2.getTargetTypes());
    }

    private static boolean isNullOrEmpty(List list) {
        return list == null || list.isEmpty();
    }

    private static ArrayList<View> configureEnteringExitingViews(Transition transition2, Fragment fragment, ArrayList<View> sharedElements, View nonExistentView) {
        ArrayList<View> viewList = null;
        if (transition2 != null) {
            viewList = new ArrayList<View>();
            View root = fragment.getView();
            if (root != null) {
                root.captureTransitioningViews(viewList);
            }
            if (sharedElements != null) {
                viewList.removeAll(sharedElements);
            }
            if (!viewList.isEmpty()) {
                viewList.add(nonExistentView);
                FragmentTransition.addTargets(transition2, viewList);
            }
        }
        return viewList;
    }

    private static void setViewVisibility(ArrayList<View> views, int visibility) {
        if (views == null) {
            return;
        }
        for (int i = views.size() - 1; i >= 0; --i) {
            View view = views.get(i);
            view.setVisibility(visibility);
        }
    }

    private static Transition mergeTransitions(Transition enterTransition, Transition exitTransition, Transition sharedElementTransition, Fragment inFragment, boolean isPop) {
        Transition transition2;
        boolean overlap = true;
        if (enterTransition != null && exitTransition != null && inFragment != null) {
            boolean bl = overlap = isPop ? inFragment.getAllowReturnTransitionOverlap() : inFragment.getAllowEnterTransitionOverlap();
        }
        if (overlap) {
            TransitionSet transitionSet = new TransitionSet();
            if (enterTransition != null) {
                transitionSet.addTransition(enterTransition);
            }
            if (exitTransition != null) {
                transitionSet.addTransition(exitTransition);
            }
            if (sharedElementTransition != null) {
                transitionSet.addTransition(sharedElementTransition);
            }
            transition2 = transitionSet;
        } else {
            Transition staggered = null;
            if (exitTransition != null && enterTransition != null) {
                staggered = new TransitionSet().addTransition(exitTransition).addTransition(enterTransition).setOrdering(1);
            } else if (exitTransition != null) {
                staggered = exitTransition;
            } else if (enterTransition != null) {
                staggered = enterTransition;
            }
            if (sharedElementTransition != null) {
                TransitionSet together = new TransitionSet();
                if (staggered != null) {
                    together.addTransition(staggered);
                }
                together.addTransition(sharedElementTransition);
                transition2 = together;
            } else {
                transition2 = staggered;
            }
        }
        return transition2;
    }

    public static void calculateFragments(BackStackRecord transaction, SparseArray<FragmentContainerTransition> transitioningFragments, boolean isReordered) {
        int numOps = transaction.mOps.size();
        for (int opNum = 0; opNum < numOps; ++opNum) {
            BackStackRecord.Op op = transaction.mOps.get(opNum);
            FragmentTransition.addToFirstInLastOut(transaction, op, transitioningFragments, false, isReordered);
        }
    }

    public static void calculatePopFragments(BackStackRecord transaction, SparseArray<FragmentContainerTransition> transitioningFragments, boolean isReordered) {
        if (!transaction.mManager.mContainer.onHasView()) {
            return;
        }
        int numOps = transaction.mOps.size();
        for (int opNum = numOps - 1; opNum >= 0; --opNum) {
            BackStackRecord.Op op = transaction.mOps.get(opNum);
            FragmentTransition.addToFirstInLastOut(transaction, op, transitioningFragments, true, isReordered);
        }
    }

    private static void addToFirstInLastOut(BackStackRecord transaction, BackStackRecord.Op op, SparseArray<FragmentContainerTransition> transitioningFragments, boolean isPop, boolean isReorderedTransaction) {
        Fragment fragment = op.fragment;
        if (fragment == null) {
            return;
        }
        int containerId = fragment.mContainerId;
        if (containerId == 0) {
            return;
        }
        int command = isPop ? INVERSE_OPS[op.cmd] : op.cmd;
        boolean setLastIn = false;
        boolean wasRemoved = false;
        boolean setFirstOut = false;
        boolean wasAdded = false;
        switch (command) {
            case 5: {
                setLastIn = isReorderedTransaction ? fragment.mHiddenChanged && !fragment.mHidden && fragment.mAdded : fragment.mHidden;
                wasAdded = true;
                break;
            }
            case 1: 
            case 7: {
                setLastIn = isReorderedTransaction ? fragment.mIsNewlyAdded : !fragment.mAdded && !fragment.mHidden;
                wasAdded = true;
                break;
            }
            case 4: {
                setFirstOut = isReorderedTransaction ? fragment.mHiddenChanged && fragment.mAdded && fragment.mHidden : fragment.mAdded && !fragment.mHidden;
                wasRemoved = true;
                break;
            }
            case 3: 
            case 6: {
                setFirstOut = isReorderedTransaction ? !fragment.mAdded && fragment.mView != null && fragment.mView.getVisibility() == 0 && fragment.mView.getTransitionAlpha() > 0.0f : fragment.mAdded && !fragment.mHidden;
                wasRemoved = true;
            }
        }
        FragmentContainerTransition containerTransition = transitioningFragments.get(containerId);
        if (setLastIn) {
            containerTransition = FragmentTransition.ensureContainer(containerTransition, transitioningFragments, containerId);
            containerTransition.lastIn = fragment;
            containerTransition.lastInIsPop = isPop;
            containerTransition.lastInTransaction = transaction;
        }
        if (!isReorderedTransaction && wasAdded) {
            if (containerTransition != null && containerTransition.firstOut == fragment) {
                containerTransition.firstOut = null;
            }
            FragmentManagerImpl manager = transaction.mManager;
            if (fragment.mState < 1 && manager.mCurState >= 1 && manager.mHost.getContext().getApplicationInfo().targetSdkVersion >= 24 && !transaction.mReorderingAllowed) {
                manager.makeActive(fragment);
                manager.moveToState(fragment, 1, 0, 0, false);
            }
        }
        if (setFirstOut && (containerTransition == null || containerTransition.firstOut == null)) {
            containerTransition = FragmentTransition.ensureContainer(containerTransition, transitioningFragments, containerId);
            containerTransition.firstOut = fragment;
            containerTransition.firstOutIsPop = isPop;
            containerTransition.firstOutTransaction = transaction;
        }
        if (!isReorderedTransaction && wasRemoved && containerTransition != null && containerTransition.lastIn == fragment) {
            containerTransition.lastIn = null;
        }
    }

    private static FragmentContainerTransition ensureContainer(FragmentContainerTransition containerTransition, SparseArray<FragmentContainerTransition> transitioningFragments, int containerId) {
        if (containerTransition == null) {
            containerTransition = new FragmentContainerTransition();
            transitioningFragments.put(containerId, containerTransition);
        }
        return containerTransition;
    }

    public static class FragmentContainerTransition {
        public Fragment lastIn;
        public boolean lastInIsPop;
        public BackStackRecord lastInTransaction;
        public Fragment firstOut;
        public boolean firstOutIsPop;
        public BackStackRecord firstOutTransaction;
    }
}

