/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.app.PendingIntent;
import android.app.Person;
import android.app.RemoteInput;
import android.app.RemoteInputHistoryItem;
import android.app.admin.DevicePolicyManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.Intent;
import android.content.LocusId;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.media.AudioAttributes;
import android.media.PlayerBase;
import android.media.session.MediaSession;
import android.net.Uri;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.text.BidiFormatter;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.CharacterStyle;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.TextAppearanceSpan;
import android.util.ArraySet;
import android.util.Log;
import android.util.Pair;
import android.util.SparseArray;
import android.util.TypedValue;
import android.util.proto.ProtoOutputStream;
import android.view.ContextThemeWrapper;
import android.widget.RemoteViews;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.graphics.ColorUtils;
import com.android.internal.lang.System_Delegate;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.ContrastColorUtil;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public class Notification
implements Parcelable {
    private static final String TAG = "Notification";
    public static final int FOREGROUND_SERVICE_DEFAULT = 0;
    public static final int FOREGROUND_SERVICE_IMMEDIATE = 1;
    public static final int FOREGROUND_SERVICE_DEFERRED = 2;
    private int mFgsDeferBehavior;
    public static final String INTENT_CATEGORY_NOTIFICATION_PREFERENCES = "android.intent.category.NOTIFICATION_PREFERENCES";
    public static final String EXTRA_CHANNEL_ID = "android.intent.extra.CHANNEL_ID";
    public static final String EXTRA_CHANNEL_GROUP_ID = "android.intent.extra.CHANNEL_GROUP_ID";
    public static final String EXTRA_NOTIFICATION_TAG = "android.intent.extra.NOTIFICATION_TAG";
    public static final String EXTRA_NOTIFICATION_ID = "android.intent.extra.NOTIFICATION_ID";
    public static final int DEFAULT_ALL = -1;
    public static final int DEFAULT_SOUND = 1;
    public static final int DEFAULT_VIBRATE = 2;
    public static final int DEFAULT_LIGHTS = 4;
    private static final int MAX_CHARSEQUENCE_LENGTH = 1024;
    private static final int MAX_REPLY_HISTORY = 5;
    private static final float MAX_LARGE_ICON_ASPECT_RATIO = 1.7777778f;
    public static final int MAX_ACTION_BUTTONS = 3;
    public static final String EXTRA_REMOTE_INPUT_DRAFT = "android.remoteInputDraft";
    public long when;
    private long creationTime;
    @Deprecated
    public int icon;
    public int iconLevel;
    public int number = 0;
    public PendingIntent contentIntent;
    public PendingIntent deleteIntent;
    public PendingIntent fullScreenIntent;
    public CharSequence tickerText;
    @Deprecated
    public RemoteViews tickerView;
    @Deprecated
    public RemoteViews contentView;
    @Deprecated
    public RemoteViews bigContentView;
    @Deprecated
    public RemoteViews headsUpContentView;
    private boolean mUsesStandardHeader;
    private static final ArraySet<Integer> STANDARD_LAYOUTS = new ArraySet();
    @Deprecated
    public Bitmap largeIcon;
    @Deprecated
    public Uri sound;
    @Deprecated
    public static final int STREAM_DEFAULT = -1;
    @Deprecated
    public int audioStreamType = -1;
    public static final AudioAttributes AUDIO_ATTRIBUTES_DEFAULT;
    @Deprecated
    public AudioAttributes audioAttributes = AUDIO_ATTRIBUTES_DEFAULT;
    @Deprecated
    public long[] vibrate;
    @Deprecated
    public int ledARGB;
    @Deprecated
    public int ledOnMS;
    @Deprecated
    public int ledOffMS;
    @Deprecated
    public int defaults;
    @Deprecated
    public static final int FLAG_SHOW_LIGHTS = 1;
    public static final int FLAG_ONGOING_EVENT = 2;
    public static final int FLAG_INSISTENT = 4;
    public static final int FLAG_ONLY_ALERT_ONCE = 8;
    public static final int FLAG_AUTO_CANCEL = 16;
    public static final int FLAG_NO_CLEAR = 32;
    public static final int FLAG_FOREGROUND_SERVICE = 64;
    @Deprecated
    public static final int FLAG_HIGH_PRIORITY = 128;
    public static final int FLAG_LOCAL_ONLY = 256;
    public static final int FLAG_GROUP_SUMMARY = 512;
    @SystemApi
    public static final int FLAG_AUTOGROUP_SUMMARY = 1024;
    public static final int FLAG_CAN_COLORIZE = 2048;
    public static final int FLAG_BUBBLE = 4096;
    private static final List<Class<? extends Style>> PLATFORM_STYLE_CLASSES;
    public int flags;
    @Deprecated
    public static final int PRIORITY_DEFAULT = 0;
    @Deprecated
    public static final int PRIORITY_LOW = -1;
    @Deprecated
    public static final int PRIORITY_MIN = -2;
    @Deprecated
    public static final int PRIORITY_HIGH = 1;
    @Deprecated
    public static final int PRIORITY_MAX = 2;
    @Deprecated
    public int priority;
    public int color = 0;
    public static final int COLOR_DEFAULT = 0;
    public static final int COLOR_INVALID = 1;
    public int visibility;
    public static final int VISIBILITY_PUBLIC = 1;
    public static final int VISIBILITY_PRIVATE = 0;
    public static final int VISIBILITY_SECRET = -1;
    public static final String CATEGORY_CALL = "call";
    public static final String CATEGORY_NAVIGATION = "navigation";
    public static final String CATEGORY_MESSAGE = "msg";
    public static final String CATEGORY_EMAIL = "email";
    public static final String CATEGORY_EVENT = "event";
    public static final String CATEGORY_PROMO = "promo";
    public static final String CATEGORY_ALARM = "alarm";
    public static final String CATEGORY_PROGRESS = "progress";
    public static final String CATEGORY_SOCIAL = "social";
    public static final String CATEGORY_ERROR = "err";
    public static final String CATEGORY_TRANSPORT = "transport";
    public static final String CATEGORY_SYSTEM = "sys";
    public static final String CATEGORY_SERVICE = "service";
    public static final String CATEGORY_RECOMMENDATION = "recommendation";
    public static final String CATEGORY_STATUS = "status";
    public static final String CATEGORY_REMINDER = "reminder";
    @SystemApi
    public static final String CATEGORY_CAR_EMERGENCY = "car_emergency";
    @SystemApi
    public static final String CATEGORY_CAR_WARNING = "car_warning";
    @SystemApi
    public static final String CATEGORY_CAR_INFORMATION = "car_information";
    public static final String CATEGORY_WORKOUT = "workout";
    public static final String CATEGORY_LOCATION_SHARING = "location_sharing";
    public static final String CATEGORY_STOPWATCH = "stopwatch";
    public static final String CATEGORY_MISSED_CALL = "missed_call";
    public String category;
    @UnsupportedAppUsage
    private String mGroupKey;
    private String mSortKey;
    public Bundle extras = new Bundle();
    @UnsupportedAppUsage
    public ArraySet<PendingIntent> allPendingIntents;
    private IBinder mAllowlistToken;
    public static IBinder processAllowlistToken;
    public static final String EXTRA_TITLE = "android.title";
    public static final String EXTRA_TITLE_BIG = "android.title.big";
    public static final String EXTRA_TEXT = "android.text";
    public static final String EXTRA_SUB_TEXT = "android.subText";
    public static final String EXTRA_REMOTE_INPUT_HISTORY = "android.remoteInputHistory";
    public static final String EXTRA_REMOTE_INPUT_HISTORY_ITEMS = "android.remoteInputHistoryItems";
    public static final String EXTRA_SHOW_REMOTE_INPUT_SPINNER = "android.remoteInputSpinner";
    public static final String EXTRA_HIDE_SMART_REPLIES = "android.hideSmartReplies";
    public static final String EXTRA_INFO_TEXT = "android.infoText";
    public static final String EXTRA_SUMMARY_TEXT = "android.summaryText";
    public static final String EXTRA_BIG_TEXT = "android.bigText";
    @Deprecated
    public static final String EXTRA_SMALL_ICON = "android.icon";
    @Deprecated
    public static final String EXTRA_LARGE_ICON = "android.largeIcon";
    public static final String EXTRA_LARGE_ICON_BIG = "android.largeIcon.big";
    public static final String EXTRA_PROGRESS = "android.progress";
    public static final String EXTRA_PROGRESS_MAX = "android.progressMax";
    public static final String EXTRA_PROGRESS_INDETERMINATE = "android.progressIndeterminate";
    public static final String EXTRA_SHOW_CHRONOMETER = "android.showChronometer";
    public static final String EXTRA_CHRONOMETER_COUNT_DOWN = "android.chronometerCountDown";
    public static final String EXTRA_SHOW_WHEN = "android.showWhen";
    public static final String EXTRA_PICTURE = "android.picture";
    public static final String EXTRA_PICTURE_ICON = "android.pictureIcon";
    public static final String EXTRA_PICTURE_CONTENT_DESCRIPTION = "android.pictureContentDescription";
    public static final String EXTRA_SHOW_BIG_PICTURE_WHEN_COLLAPSED = "android.showBigPictureWhenCollapsed";
    public static final String EXTRA_TEXT_LINES = "android.textLines";
    public static final String EXTRA_TEMPLATE = "android.template";
    public static final String EXTRA_PEOPLE = "android.people";
    public static final String EXTRA_PEOPLE_LIST = "android.people.list";
    @SystemApi
    @RequiresPermission(value="android.permission.NOTIFICATION_DURING_SETUP")
    public static final String EXTRA_ALLOW_DURING_SETUP = "android.allowDuringSetup";
    public static final String EXTRA_BACKGROUND_IMAGE_URI = "android.backgroundImageUri";
    public static final String EXTRA_MEDIA_SESSION = "android.mediaSession";
    public static final String EXTRA_MEDIA_REMOTE_DEVICE = "android.mediaRemoteDevice";
    public static final String EXTRA_MEDIA_REMOTE_ICON = "android.mediaRemoteIcon";
    public static final String EXTRA_MEDIA_REMOTE_INTENT = "android.mediaRemoteIntent";
    public static final String EXTRA_COMPACT_ACTIONS = "android.compactActions";
    public static final String EXTRA_SELF_DISPLAY_NAME = "android.selfDisplayName";
    public static final String EXTRA_MESSAGING_PERSON = "android.messagingUser";
    public static final String EXTRA_CONVERSATION_TITLE = "android.conversationTitle";
    public static final String EXTRA_CONVERSATION_ICON = "android.conversationIcon";
    public static final String EXTRA_CONVERSATION_UNREAD_MESSAGE_COUNT = "android.conversationUnreadMessageCount";
    public static final String EXTRA_MESSAGES = "android.messages";
    public static final String EXTRA_HISTORIC_MESSAGES = "android.messages.historic";
    public static final String EXTRA_IS_GROUP_CONVERSATION = "android.isGroupConversation";
    public static final String EXTRA_CALL_TYPE = "android.callType";
    public static final String EXTRA_CALL_IS_VIDEO = "android.callIsVideo";
    public static final String EXTRA_CALL_PERSON = "android.callPerson";
    public static final String EXTRA_VERIFICATION_ICON = "android.verificationIcon";
    public static final String EXTRA_VERIFICATION_TEXT = "android.verificationText";
    public static final String EXTRA_ANSWER_INTENT = "android.answerIntent";
    public static final String EXTRA_DECLINE_INTENT = "android.declineIntent";
    public static final String EXTRA_HANG_UP_INTENT = "android.hangUpIntent";
    public static final String EXTRA_ANSWER_COLOR = "android.answerColor";
    public static final String EXTRA_DECLINE_COLOR = "android.declineColor";
    public static final String EXTRA_COLORIZED = "android.colorized";
    public static final String EXTRA_BUILDER_APPLICATION_INFO = "android.appInfo";
    public static final String EXTRA_CONTAINS_CUSTOM_VIEW = "android.contains.customView";
    public static final String EXTRA_REDUCED_IMAGES = "android.reduced.images";
    public static final String EXTRA_AUDIO_CONTENTS_URI = "android.audioContents";
    @SystemApi
    @RequiresPermission(value="android.permission.SUBSTITUTE_NOTIFICATION_APP_NAME")
    public static final String EXTRA_SUBSTITUTE_APP_NAME = "android.substName";
    public static final String EXTRA_FOREGROUND_APPS = "android.foregroundApps";
    @UnsupportedAppUsage
    private Icon mSmallIcon;
    @UnsupportedAppUsage
    private Icon mLargeIcon;
    @UnsupportedAppUsage
    private String mChannelId;
    private long mTimeout;
    private String mShortcutId;
    private LocusId mLocusId;
    private CharSequence mSettingsText;
    private BubbleMetadata mBubbleMetadata;
    public static final int GROUP_ALERT_ALL = 0;
    public static final int GROUP_ALERT_SUMMARY = 1;
    public static final int GROUP_ALERT_CHILDREN = 2;
    private int mGroupAlertBehavior = 0;
    public static final int BADGE_ICON_NONE = 0;
    public static final int BADGE_ICON_SMALL = 1;
    public static final int BADGE_ICON_LARGE = 2;
    private int mBadgeIcon = 0;
    private boolean mAllowSystemGeneratedContextualActions = true;
    public Action[] actions;
    public Notification publicVersion;
    public static final Parcelable.Creator<Notification> CREATOR;

    public String getGroup() {
        return this.mGroupKey;
    }

    public String getSortKey() {
        return this.mSortKey;
    }

    public Notification() {
        this.when = System_Delegate.currentTimeMillis();
        this.creationTime = System_Delegate.currentTimeMillis();
        this.priority = 0;
    }

    @UnsupportedAppUsage
    public Notification(Context context, int icon, CharSequence tickerText, long when, CharSequence contentTitle, CharSequence contentText, Intent contentIntent) {
        new Builder(context).setWhen(when).setSmallIcon(icon).setTicker(tickerText).setContentTitle(contentTitle).setContentText(contentText).setContentIntent(PendingIntent.getActivity(context, 0, contentIntent, 0x2000000)).buildInto(this);
    }

    @Deprecated
    public Notification(int icon, CharSequence tickerText, long when) {
        this.icon = icon;
        this.tickerText = tickerText;
        this.when = when;
        this.creationTime = System_Delegate.currentTimeMillis();
    }

    public Notification(Parcel parcel) {
        this.readFromParcelImpl(parcel);
        this.allPendingIntents = parcel.readArraySet(null);
    }

    private void readFromParcelImpl(Parcel parcel) {
        int version = parcel.readInt();
        this.mAllowlistToken = parcel.readStrongBinder();
        if (this.mAllowlistToken == null) {
            this.mAllowlistToken = processAllowlistToken;
        }
        parcel.setClassCookie(PendingIntent.class, this.mAllowlistToken);
        this.when = parcel.readLong();
        this.creationTime = parcel.readLong();
        if (parcel.readInt() != 0) {
            this.mSmallIcon = Icon.CREATOR.createFromParcel(parcel);
            if (this.mSmallIcon.getType() == 2) {
                this.icon = this.mSmallIcon.getResId();
            }
        }
        this.number = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.contentIntent = PendingIntent.CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.deleteIntent = PendingIntent.CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.tickerText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.tickerView = RemoteViews.CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.contentView = RemoteViews.CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.mLargeIcon = Icon.CREATOR.createFromParcel(parcel);
        }
        this.defaults = parcel.readInt();
        this.flags = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.sound = Uri.CREATOR.createFromParcel(parcel);
        }
        this.audioStreamType = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.audioAttributes = AudioAttributes.CREATOR.createFromParcel(parcel);
        }
        this.vibrate = parcel.createLongArray();
        this.ledARGB = parcel.readInt();
        this.ledOnMS = parcel.readInt();
        this.ledOffMS = parcel.readInt();
        this.iconLevel = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.fullScreenIntent = PendingIntent.CREATOR.createFromParcel(parcel);
        }
        this.priority = parcel.readInt();
        this.category = parcel.readString8();
        this.mGroupKey = parcel.readString8();
        this.mSortKey = parcel.readString8();
        this.extras = Bundle.setDefusable(parcel.readBundle(), true);
        this.fixDuplicateExtras();
        this.actions = parcel.createTypedArray(Action.CREATOR);
        if (parcel.readInt() != 0) {
            this.bigContentView = RemoteViews.CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.headsUpContentView = RemoteViews.CREATOR.createFromParcel(parcel);
        }
        this.visibility = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.publicVersion = CREATOR.createFromParcel(parcel);
        }
        this.color = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.mChannelId = parcel.readString8();
        }
        this.mTimeout = parcel.readLong();
        if (parcel.readInt() != 0) {
            this.mShortcutId = parcel.readString8();
        }
        if (parcel.readInt() != 0) {
            this.mLocusId = LocusId.CREATOR.createFromParcel(parcel);
        }
        this.mBadgeIcon = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.mSettingsText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        }
        this.mGroupAlertBehavior = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.mBubbleMetadata = BubbleMetadata.CREATOR.createFromParcel(parcel);
        }
        this.mAllowSystemGeneratedContextualActions = parcel.readBoolean();
        this.mFgsDeferBehavior = parcel.readInt();
    }

    public Notification clone() {
        Notification that = new Notification();
        this.cloneInto(that, true);
        return that;
    }

    public void cloneInto(Notification that, boolean heavy) {
        long[] vibrate;
        that.mAllowlistToken = this.mAllowlistToken;
        that.when = this.when;
        that.creationTime = this.creationTime;
        that.mSmallIcon = this.mSmallIcon;
        that.number = this.number;
        that.contentIntent = this.contentIntent;
        that.deleteIntent = this.deleteIntent;
        that.fullScreenIntent = this.fullScreenIntent;
        if (this.tickerText != null) {
            that.tickerText = this.tickerText.toString();
        }
        if (heavy && this.tickerView != null) {
            that.tickerView = this.tickerView.clone();
        }
        if (heavy && this.contentView != null) {
            that.contentView = this.contentView.clone();
        }
        if (heavy && this.mLargeIcon != null) {
            that.mLargeIcon = this.mLargeIcon;
        }
        that.iconLevel = this.iconLevel;
        that.sound = this.sound;
        that.audioStreamType = this.audioStreamType;
        if (this.audioAttributes != null) {
            that.audioAttributes = new AudioAttributes.Builder(this.audioAttributes).build();
        }
        if ((vibrate = this.vibrate) != null) {
            int N = vibrate.length;
            that.vibrate = new long[N];
            long[] vib = that.vibrate;
            System.arraycopy(vibrate, 0, vib, 0, N);
        }
        that.ledARGB = this.ledARGB;
        that.ledOnMS = this.ledOnMS;
        that.ledOffMS = this.ledOffMS;
        that.defaults = this.defaults;
        that.flags = this.flags;
        that.priority = this.priority;
        that.category = this.category;
        that.mGroupKey = this.mGroupKey;
        that.mSortKey = this.mSortKey;
        if (this.extras != null) {
            try {
                that.extras = new Bundle(this.extras);
                that.extras.size();
            }
            catch (BadParcelableException e) {
                Log.e(TAG, "could not unparcel extras from notification: " + this, e);
                that.extras = null;
            }
        }
        if (!ArrayUtils.isEmpty(this.allPendingIntents)) {
            that.allPendingIntents = new ArraySet<PendingIntent>(this.allPendingIntents);
        }
        if (this.actions != null) {
            that.actions = new Action[this.actions.length];
            for (int i = 0; i < this.actions.length; ++i) {
                if (this.actions[i] == null) continue;
                that.actions[i] = this.actions[i].clone();
            }
        }
        if (heavy && this.bigContentView != null) {
            that.bigContentView = this.bigContentView.clone();
        }
        if (heavy && this.headsUpContentView != null) {
            that.headsUpContentView = this.headsUpContentView.clone();
        }
        that.visibility = this.visibility;
        if (this.publicVersion != null) {
            that.publicVersion = new Notification();
            this.publicVersion.cloneInto(that.publicVersion, heavy);
        }
        that.color = this.color;
        that.mChannelId = this.mChannelId;
        that.mTimeout = this.mTimeout;
        that.mShortcutId = this.mShortcutId;
        that.mLocusId = this.mLocusId;
        that.mBadgeIcon = this.mBadgeIcon;
        that.mSettingsText = this.mSettingsText;
        that.mGroupAlertBehavior = this.mGroupAlertBehavior;
        that.mFgsDeferBehavior = this.mFgsDeferBehavior;
        that.mBubbleMetadata = this.mBubbleMetadata;
        that.mAllowSystemGeneratedContextualActions = this.mAllowSystemGeneratedContextualActions;
        if (!heavy) {
            that.lightenPayload();
        }
    }

    private static void visitIconUri(Consumer<Uri> visitor, Icon icon) {
        if (icon == null) {
            return;
        }
        int iconType = icon.getType();
        if (iconType == 4 || iconType == 6) {
            visitor.accept(icon.getUri());
        }
    }

    public void visitUris(Consumer<Uri> visitor) {
        if (this.publicVersion != null) {
            this.publicVersion.visitUris(visitor);
        }
        visitor.accept(this.sound);
        if (this.tickerView != null) {
            this.tickerView.visitUris(visitor);
        }
        if (this.contentView != null) {
            this.contentView.visitUris(visitor);
        }
        if (this.bigContentView != null) {
            this.bigContentView.visitUris(visitor);
        }
        if (this.headsUpContentView != null) {
            this.headsUpContentView.visitUris(visitor);
        }
        Notification.visitIconUri(visitor, this.mSmallIcon);
        Notification.visitIconUri(visitor, this.mLargeIcon);
        if (this.actions != null) {
            for (Action action : this.actions) {
                Notification.visitIconUri(visitor, action.getIcon());
            }
        }
        if (this.extras != null) {
            RemoteInputHistoryItem[] history;
            Person person;
            ArrayList people;
            Notification.visitIconUri(visitor, this.extras.getParcelable(EXTRA_LARGE_ICON_BIG, Icon.class));
            Notification.visitIconUri(visitor, this.extras.getParcelable(EXTRA_PICTURE_ICON, Icon.class));
            Object audioContentsUri = this.extras.get(EXTRA_AUDIO_CONTENTS_URI);
            if (audioContentsUri instanceof Uri) {
                visitor.accept((Uri)audioContentsUri);
            } else if (audioContentsUri instanceof String) {
                visitor.accept(Uri.parse((String)audioContentsUri));
            }
            if (this.extras.containsKey(EXTRA_BACKGROUND_IMAGE_URI)) {
                visitor.accept(Uri.parse(this.extras.getString(EXTRA_BACKGROUND_IMAGE_URI)));
            }
            if ((people = this.extras.getParcelableArrayList(EXTRA_PEOPLE_LIST)) != null && !people.isEmpty()) {
                for (Person p : people) {
                    visitor.accept(p.getIconUri());
                }
            }
            if ((person = this.extras.getParcelable(EXTRA_MESSAGING_PERSON, Person.class)) != null) {
                visitor.accept(person.getIconUri());
            }
            if ((history = (RemoteInputHistoryItem[])this.extras.getParcelableArray(EXTRA_REMOTE_INPUT_HISTORY_ITEMS)) != null) {
                for (int i = 0; i < history.length; ++i) {
                    RemoteInputHistoryItem item = history[i];
                    if (item.getUri() == null) continue;
                    visitor.accept(item.getUri());
                }
            }
        }
        if (this.isStyle(MessagingStyle.class) && this.extras != null) {
            Parcelable[] historic;
            Parcelable[] messages = this.extras.getParcelableArray(EXTRA_MESSAGES);
            if (!ArrayUtils.isEmpty(messages)) {
                for (MessagingStyle.Message message : MessagingStyle.Message.getMessagesFromBundleArray(messages)) {
                    visitor.accept(message.getDataUri());
                    Person senderPerson = message.getSenderPerson();
                    if (senderPerson == null) continue;
                    visitor.accept(senderPerson.getIconUri());
                }
            }
            if (!ArrayUtils.isEmpty(historic = this.extras.getParcelableArray(EXTRA_HISTORIC_MESSAGES))) {
                for (MessagingStyle.Message message : MessagingStyle.Message.getMessagesFromBundleArray(historic)) {
                    visitor.accept(message.getDataUri());
                    Person senderPerson = message.getSenderPerson();
                    if (senderPerson == null) continue;
                    visitor.accept(senderPerson.getIconUri());
                }
            }
            Notification.visitIconUri(visitor, (Icon)this.extras.getParcelable(EXTRA_CONVERSATION_ICON));
        }
        if (this.isStyle(CallStyle.class) & this.extras != null) {
            Person callPerson = (Person)this.extras.getParcelable(EXTRA_CALL_PERSON);
            if (callPerson != null) {
                visitor.accept(callPerson.getIconUri());
            }
            Notification.visitIconUri(visitor, (Icon)this.extras.getParcelable(EXTRA_VERIFICATION_ICON));
        }
        if (this.mBubbleMetadata != null) {
            Notification.visitIconUri(visitor, this.mBubbleMetadata.getIcon());
        }
    }

    public void lightenPayload() {
        this.tickerView = null;
        this.contentView = null;
        this.bigContentView = null;
        this.headsUpContentView = null;
        this.mLargeIcon = null;
        if (this.extras != null && !this.extras.isEmpty()) {
            Set<String> keyset = this.extras.keySet();
            int N = keyset.size();
            String[] keys = keyset.toArray(new String[N]);
            for (int i = 0; i < N; ++i) {
                Object obj;
                String key = keys[i];
                if ("android.tv.EXTENSIONS".equals(key) || (obj = this.extras.get(key)) == null || !(obj instanceof Parcelable) && !(obj instanceof Parcelable[]) && !(obj instanceof SparseArray) && !(obj instanceof ArrayList)) continue;
                this.extras.remove(key);
            }
        }
    }

    public static CharSequence safeCharSequence(CharSequence cs) {
        if (cs == null) {
            return cs;
        }
        if (cs.length() > 1024) {
            cs = cs.subSequence(0, 1024);
        }
        if (cs instanceof Parcelable) {
            Log.e(TAG, "warning: " + cs.getClass().getCanonicalName() + " instance is a custom Parcelable and not allowed in Notification");
            return cs.toString();
        }
        return Notification.removeTextSizeSpans(cs);
    }

    private static CharSequence removeTextSizeSpans(CharSequence charSequence) {
        if (charSequence instanceof Spanned) {
            Spanned ss = (Spanned)charSequence;
            Object[] spans = ss.getSpans(0, ss.length(), Object.class);
            SpannableStringBuilder builder = new SpannableStringBuilder(ss.toString());
            for (Object span : spans) {
                Object resultSpan = span;
                if (resultSpan instanceof CharacterStyle) {
                    resultSpan = ((CharacterStyle)span).getUnderlying();
                }
                if (resultSpan instanceof TextAppearanceSpan) {
                    TextAppearanceSpan originalSpan = (TextAppearanceSpan)resultSpan;
                    resultSpan = new TextAppearanceSpan(originalSpan.getFamily(), originalSpan.getTextStyle(), -1, originalSpan.getTextColor(), originalSpan.getLinkTextColor());
                } else {
                    if (resultSpan instanceof RelativeSizeSpan || resultSpan instanceof AbsoluteSizeSpan) continue;
                    resultSpan = span;
                }
                builder.setSpan(resultSpan, ss.getSpanStart(span), ss.getSpanEnd(span), ss.getSpanFlags(span));
            }
            return builder;
        }
        return charSequence;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        boolean collectPendingIntents;
        boolean bl = collectPendingIntents = this.allPendingIntents == null;
        if (collectPendingIntents) {
            PendingIntent.setOnMarshaledListener((intent, out, outFlags) -> {
                if (parcel == out) {
                    Notification notification = this;
                    synchronized (notification) {
                        if (this.allPendingIntents == null) {
                            this.allPendingIntents = new ArraySet();
                        }
                        this.allPendingIntents.add(intent);
                    }
                }
            });
        }
        try {
            this.writeToParcelImpl(parcel, flags);
            Notification notification = this;
            synchronized (notification) {
                parcel.writeArraySet(this.allPendingIntents);
            }
        }
        finally {
            if (collectPendingIntents) {
                PendingIntent.setOnMarshaledListener(null);
            }
        }
    }

    private void writeToParcelImpl(Parcel parcel, int flags) {
        parcel.writeInt(1);
        parcel.writeStrongBinder(this.mAllowlistToken);
        parcel.writeLong(this.when);
        parcel.writeLong(this.creationTime);
        if (this.mSmallIcon == null && this.icon != 0) {
            this.mSmallIcon = Icon.createWithResource("", this.icon);
        }
        if (this.mSmallIcon != null) {
            parcel.writeInt(1);
            this.mSmallIcon.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.number);
        if (this.contentIntent != null) {
            parcel.writeInt(1);
            this.contentIntent.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.deleteIntent != null) {
            parcel.writeInt(1);
            this.deleteIntent.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.tickerText != null) {
            parcel.writeInt(1);
            TextUtils.writeToParcel(this.tickerText, parcel, flags);
        } else {
            parcel.writeInt(0);
        }
        if (this.tickerView != null) {
            parcel.writeInt(1);
            this.tickerView.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.contentView != null) {
            parcel.writeInt(1);
            this.contentView.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.mLargeIcon == null && this.largeIcon != null) {
            this.mLargeIcon = Icon.createWithBitmap(this.largeIcon);
        }
        if (this.mLargeIcon != null) {
            parcel.writeInt(1);
            this.mLargeIcon.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.defaults);
        parcel.writeInt(this.flags);
        if (this.sound != null) {
            parcel.writeInt(1);
            this.sound.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.audioStreamType);
        if (this.audioAttributes != null) {
            parcel.writeInt(1);
            this.audioAttributes.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeLongArray(this.vibrate);
        parcel.writeInt(this.ledARGB);
        parcel.writeInt(this.ledOnMS);
        parcel.writeInt(this.ledOffMS);
        parcel.writeInt(this.iconLevel);
        if (this.fullScreenIntent != null) {
            parcel.writeInt(1);
            this.fullScreenIntent.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.priority);
        parcel.writeString8(this.category);
        parcel.writeString8(this.mGroupKey);
        parcel.writeString8(this.mSortKey);
        parcel.writeBundle(this.extras);
        parcel.writeTypedArray(this.actions, 0);
        if (this.bigContentView != null) {
            parcel.writeInt(1);
            this.bigContentView.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.headsUpContentView != null) {
            parcel.writeInt(1);
            this.headsUpContentView.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.visibility);
        if (this.publicVersion != null) {
            parcel.writeInt(1);
            this.publicVersion.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.color);
        if (this.mChannelId != null) {
            parcel.writeInt(1);
            parcel.writeString8(this.mChannelId);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeLong(this.mTimeout);
        if (this.mShortcutId != null) {
            parcel.writeInt(1);
            parcel.writeString8(this.mShortcutId);
        } else {
            parcel.writeInt(0);
        }
        if (this.mLocusId != null) {
            parcel.writeInt(1);
            this.mLocusId.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.mBadgeIcon);
        if (this.mSettingsText != null) {
            parcel.writeInt(1);
            TextUtils.writeToParcel(this.mSettingsText, parcel, flags);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.mGroupAlertBehavior);
        if (this.mBubbleMetadata != null) {
            parcel.writeInt(1);
            this.mBubbleMetadata.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeBoolean(this.mAllowSystemGeneratedContextualActions);
        parcel.writeInt(this.mFgsDeferBehavior);
    }

    public static boolean areActionsVisiblyDifferent(Notification first, Notification second) {
        Action[] firstAs = first.actions;
        Action[] secondAs = second.actions;
        if (firstAs == null && secondAs != null || firstAs != null && secondAs == null) {
            return true;
        }
        if (firstAs != null && secondAs != null) {
            if (firstAs.length != secondAs.length) {
                return true;
            }
            for (int i = 0; i < firstAs.length; ++i) {
                if (!Objects.equals(String.valueOf(firstAs[i].title), String.valueOf(secondAs[i].title))) {
                    return true;
                }
                RemoteInput[] firstRs = firstAs[i].getRemoteInputs();
                RemoteInput[] secondRs = secondAs[i].getRemoteInputs();
                if (firstRs == null) {
                    firstRs = new RemoteInput[]{};
                }
                if (secondRs == null) {
                    secondRs = new RemoteInput[]{};
                }
                if (firstRs.length != secondRs.length) {
                    return true;
                }
                for (int j = 0; j < firstRs.length; ++j) {
                    if (Objects.equals(String.valueOf(firstRs[j].getLabel()), String.valueOf(secondRs[j].getLabel()))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean areStyledNotificationsVisiblyDifferent(Builder first, Builder second) {
        if (first.getStyle() == null) {
            return second.getStyle() != null;
        }
        if (second.getStyle() == null) {
            return true;
        }
        return first.getStyle().areNotificationsVisiblyDifferent(second.getStyle());
    }

    public static boolean areRemoteViewsChanged(Builder first, Builder second) {
        if (!Objects.equals(first.usesStandardHeader(), second.usesStandardHeader())) {
            return true;
        }
        if (Notification.areRemoteViewsChanged(first.mN.contentView, second.mN.contentView)) {
            return true;
        }
        if (Notification.areRemoteViewsChanged(first.mN.bigContentView, second.mN.bigContentView)) {
            return true;
        }
        return Notification.areRemoteViewsChanged(first.mN.headsUpContentView, second.mN.headsUpContentView);
    }

    private static boolean areRemoteViewsChanged(RemoteViews first, RemoteViews second) {
        if (first == null && second == null) {
            return false;
        }
        if (first == null && second != null || first != null && second == null) {
            return true;
        }
        if (!Objects.equals(first.getLayoutId(), second.getLayoutId())) {
            return true;
        }
        return !Objects.equals(first.getSequenceNumber(), second.getSequenceNumber());
    }

    private void fixDuplicateExtras() {
        if (this.extras != null) {
            this.fixDuplicateExtra(this.mLargeIcon, EXTRA_LARGE_ICON);
        }
    }

    private void fixDuplicateExtra(Parcelable original, String extraName) {
        if (original != null && this.extras.getParcelable(extraName) != null) {
            this.extras.putParcelable(extraName, original);
        }
    }

    @Deprecated
    public void setLatestEventInfo(Context context, CharSequence contentTitle, CharSequence contentText, PendingIntent contentIntent) {
        if (context.getApplicationInfo().targetSdkVersion > 22) {
            Log.e(TAG, "setLatestEventInfo() is deprecated and you should feel deprecated.", new Throwable());
        }
        if (context.getApplicationInfo().targetSdkVersion < 24) {
            this.extras.putBoolean(EXTRA_SHOW_WHEN, true);
        }
        Builder builder = new Builder(context, this);
        if (contentTitle != null) {
            builder.setContentTitle(contentTitle);
        }
        if (contentText != null) {
            builder.setContentText(contentText);
        }
        builder.setContentIntent(contentIntent);
        builder.build();
    }

    public void setAllowlistToken(IBinder token) {
        this.mAllowlistToken = token;
    }

    public static void addFieldsFromContext(Context context, Notification notification) {
        Notification.addFieldsFromContext(context.getApplicationInfo(), notification);
    }

    public static void addFieldsFromContext(ApplicationInfo ai, Notification notification) {
        notification.extras.putParcelable(EXTRA_BUILDER_APPLICATION_INFO, ai);
    }

    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10900000001L, this.getChannelId());
        proto.write(1133871366146L, this.tickerText != null);
        proto.write(1120986464259L, this.flags);
        proto.write(1120986464260L, this.color);
        proto.write(1138166333445L, this.category);
        proto.write(1138166333446L, this.mGroupKey);
        proto.write(1138166333447L, this.mSortKey);
        if (this.actions != null) {
            proto.write(1120986464264L, this.actions.length);
        }
        if (this.visibility >= -1 && this.visibility <= 1) {
            proto.write(1159641169929L, this.visibility);
        }
        if (this.publicVersion != null) {
            this.publicVersion.dumpDebug(proto, 1146756268042L);
        }
        proto.end(token);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Notification(channel=");
        sb.append(this.getChannelId());
        sb.append(" shortcut=");
        sb.append(this.getShortcutId());
        sb.append(" contentView=");
        if (this.contentView != null) {
            sb.append(this.contentView.getPackage());
            sb.append("/0x");
            sb.append(Integer.toHexString(this.contentView.getLayoutId()));
        } else {
            sb.append("null");
        }
        sb.append(" vibrate=");
        if ((this.defaults & 2) != 0) {
            sb.append("default");
        } else if (this.vibrate != null) {
            int N = this.vibrate.length - 1;
            sb.append("[");
            for (int i = 0; i < N; ++i) {
                sb.append(this.vibrate[i]);
                sb.append(',');
            }
            if (N != -1) {
                sb.append(this.vibrate[N]);
            }
            sb.append("]");
        } else {
            sb.append("null");
        }
        sb.append(" sound=");
        if ((this.defaults & 1) != 0) {
            sb.append("default");
        } else if (this.sound != null) {
            sb.append(this.sound.toString());
        } else {
            sb.append("null");
        }
        if (this.tickerText != null) {
            sb.append(" tick");
        }
        sb.append(" defaults=0x");
        sb.append(Integer.toHexString(this.defaults));
        sb.append(" flags=0x");
        sb.append(Integer.toHexString(this.flags));
        sb.append(String.format(" color=0x%08x", this.color));
        if (this.category != null) {
            sb.append(" category=");
            sb.append(this.category);
        }
        if (this.mGroupKey != null) {
            sb.append(" groupKey=");
            sb.append(this.mGroupKey);
        }
        if (this.mSortKey != null) {
            sb.append(" sortKey=");
            sb.append(this.mSortKey);
        }
        if (this.actions != null) {
            sb.append(" actions=");
            sb.append(this.actions.length);
        }
        sb.append(" vis=");
        sb.append(Notification.visibilityToString(this.visibility));
        if (this.publicVersion != null) {
            sb.append(" publicVersion=");
            sb.append(this.publicVersion.toString());
        }
        if (this.mLocusId != null) {
            sb.append(" locusId=");
            sb.append(this.mLocusId);
        }
        sb.append(")");
        return sb.toString();
    }

    public static String visibilityToString(int vis) {
        switch (vis) {
            case 0: {
                return "PRIVATE";
            }
            case 1: {
                return "PUBLIC";
            }
            case -1: {
                return "SECRET";
            }
        }
        return "UNKNOWN(" + String.valueOf(vis) + ")";
    }

    public static String priorityToString(int pri) {
        switch (pri) {
            case -2: {
                return "MIN";
            }
            case -1: {
                return "LOW";
            }
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "HIGH";
            }
            case 2: {
                return "MAX";
            }
        }
        return "UNKNOWN(" + String.valueOf(pri) + ")";
    }

    public boolean hasCompletedProgress() {
        if (!this.extras.containsKey(EXTRA_PROGRESS) || !this.extras.containsKey(EXTRA_PROGRESS_MAX)) {
            return false;
        }
        if (this.extras.getInt(EXTRA_PROGRESS_MAX) == 0) {
            return false;
        }
        return this.extras.getInt(EXTRA_PROGRESS) == this.extras.getInt(EXTRA_PROGRESS_MAX);
    }

    @Deprecated
    public String getChannel() {
        return this.mChannelId;
    }

    public String getChannelId() {
        return this.mChannelId;
    }

    @Deprecated
    public long getTimeout() {
        return this.mTimeout;
    }

    public long getTimeoutAfter() {
        return this.mTimeout;
    }

    public int getBadgeIconType() {
        return this.mBadgeIcon;
    }

    public String getShortcutId() {
        return this.mShortcutId;
    }

    public LocusId getLocusId() {
        return this.mLocusId;
    }

    public CharSequence getSettingsText() {
        return this.mSettingsText;
    }

    public int getGroupAlertBehavior() {
        return this.mGroupAlertBehavior;
    }

    public BubbleMetadata getBubbleMetadata() {
        return this.mBubbleMetadata;
    }

    public void setBubbleMetadata(BubbleMetadata data) {
        this.mBubbleMetadata = data;
    }

    public boolean getAllowSystemGeneratedContextualActions() {
        return this.mAllowSystemGeneratedContextualActions;
    }

    public Icon getSmallIcon() {
        return this.mSmallIcon;
    }

    @UnsupportedAppUsage
    public void setSmallIcon(Icon icon) {
        this.mSmallIcon = icon;
    }

    public Icon getLargeIcon() {
        return this.mLargeIcon;
    }

    @UnsupportedAppUsage
    public boolean isGroupSummary() {
        return this.mGroupKey != null && (this.flags & 0x200) != 0;
    }

    @UnsupportedAppUsage
    public boolean isGroupChild() {
        return this.mGroupKey != null && (this.flags & 0x200) == 0;
    }

    public boolean suppressAlertingDueToGrouping() {
        if (this.isGroupSummary() && this.getGroupAlertBehavior() == 2) {
            return true;
        }
        return this.isGroupChild() && this.getGroupAlertBehavior() == 1;
    }

    public Pair<RemoteInput, Action> findRemoteInputActionPair(boolean requiresFreeform) {
        if (this.actions == null) {
            return null;
        }
        for (Action action : this.actions) {
            if (action.getRemoteInputs() == null) continue;
            RemoteInput resultRemoteInput = null;
            for (RemoteInput remoteInput : action.getRemoteInputs()) {
                if (!remoteInput.getAllowFreeFormInput() && requiresFreeform) continue;
                resultRemoteInput = remoteInput;
            }
            if (resultRemoteInput == null) continue;
            return Pair.create(resultRemoteInput, action);
        }
        return null;
    }

    public List<Action> getContextualActions() {
        if (this.actions == null) {
            return Collections.emptyList();
        }
        ArrayList<Action> contextualActions = new ArrayList<Action>();
        for (Action action : this.actions) {
            if (!action.isContextual()) continue;
            contextualActions.add(action);
        }
        return contextualActions;
    }

    void reduceImageSizes(Context context) {
        Resources resources;
        if (this.extras.getBoolean(EXTRA_REDUCED_IMAGES)) {
            return;
        }
        boolean isLowRam = ActivityManager.isLowRamDeviceStatic();
        if (this.mSmallIcon != null && (this.mSmallIcon.getType() == 1 || this.mSmallIcon.getType() == 5)) {
            resources = context.getResources();
            int maxSize = resources.getDimensionPixelSize(isLowRam ? 17105433 : 17105432);
            this.mSmallIcon.scaleDownIfNecessary(maxSize, maxSize);
        }
        if (this.mLargeIcon != null || this.largeIcon != null) {
            resources = context.getResources();
            Class<? extends Style> style2 = this.getNotificationStyle();
            int maxSize = resources.getDimensionPixelSize(isLowRam ? 17105430 : 17105429);
            if (this.mLargeIcon != null) {
                this.mLargeIcon.scaleDownIfNecessary(maxSize, maxSize);
            }
            if (this.largeIcon != null) {
                this.largeIcon = Icon.scaleDownIfNecessary(this.largeIcon, maxSize, maxSize);
            }
        }
        this.reduceImageSizesForRemoteView(this.contentView, context, isLowRam);
        this.reduceImageSizesForRemoteView(this.headsUpContentView, context, isLowRam);
        this.reduceImageSizesForRemoteView(this.bigContentView, context, isLowRam);
        this.extras.putBoolean(EXTRA_REDUCED_IMAGES, true);
    }

    private void reduceImageSizesForRemoteView(RemoteViews remoteView, Context context, boolean isLowRam) {
        if (remoteView != null) {
            Resources resources = context.getResources();
            int maxWidth = resources.getDimensionPixelSize(isLowRam ? 17105390 : 17105389);
            int maxHeight = resources.getDimensionPixelSize(isLowRam ? 17105388 : 17105387);
            remoteView.reduceImageSizes(maxWidth, maxHeight);
        }
    }

    public boolean isForegroundService() {
        return (this.flags & 0x40) != 0;
    }

    public boolean shouldShowForegroundImmediately() {
        if (this.mFgsDeferBehavior == 1) {
            return true;
        }
        if (this.mFgsDeferBehavior == 2) {
            return false;
        }
        return this.isMediaNotification() || CATEGORY_CALL.equals(this.category) || CATEGORY_NAVIGATION.equals(this.category) || this.actions != null && this.actions.length > 0;
    }

    public boolean isForegroundDisplayForceDeferred() {
        return 2 == this.mFgsDeferBehavior;
    }

    public Class<? extends Style> getNotificationStyle() {
        String templateClass = this.extras.getString(EXTRA_TEMPLATE);
        if (!TextUtils.isEmpty(templateClass)) {
            return Notification.getNotificationStyleClass(templateClass);
        }
        return null;
    }

    public boolean isStyle(Class<? extends Style> styleClass) {
        String templateClass = this.extras.getString(EXTRA_TEMPLATE);
        return Objects.equals(templateClass, styleClass.getName());
    }

    public boolean isColorized() {
        return this.extras.getBoolean(EXTRA_COLORIZED) && (this.hasColorizedPermission() || this.isForegroundService());
    }

    private boolean hasColorizedPermission() {
        return (this.flags & 0x800) != 0;
    }

    public boolean isMediaNotification() {
        Class<? extends Style> style2 = this.getNotificationStyle();
        boolean isMediaStyle = MediaStyle.class.equals(style2) || DecoratedMediaCustomViewStyle.class.equals(style2);
        boolean hasMediaSession = this.extras.getParcelable(EXTRA_MEDIA_SESSION, MediaSession.Token.class) != null;
        return isMediaStyle && hasMediaSession;
    }

    public boolean isBubbleNotification() {
        return (this.flags & 0x1000) != 0;
    }

    private boolean hasLargeIcon() {
        return this.mLargeIcon != null || this.largeIcon != null;
    }

    public boolean showsTime() {
        return this.when != 0L && this.extras.getBoolean(EXTRA_SHOW_WHEN);
    }

    public boolean showsChronometer() {
        return this.when != 0L && this.extras.getBoolean(EXTRA_SHOW_CHRONOMETER);
    }

    public boolean hasImage() {
        if (this.isStyle(MessagingStyle.class) && this.extras != null) {
            Parcelable[] messages = this.extras.getParcelableArray(EXTRA_MESSAGES);
            if (!ArrayUtils.isEmpty(messages)) {
                for (MessagingStyle.Message m : MessagingStyle.Message.getMessagesFromBundleArray(messages)) {
                    if (m.getDataUri() == null || m.getDataMimeType() == null || !m.getDataMimeType().startsWith("image/")) continue;
                    return true;
                }
            }
        } else {
            if (this.hasLargeIcon()) {
                return true;
            }
            if (this.extras.containsKey(EXTRA_BACKGROUND_IMAGE_URI)) {
                return true;
            }
        }
        return false;
    }

    @SystemApi
    public static Class<? extends Style> getNotificationStyleClass(String templateClass) {
        for (Class<? extends Style> innerClass : PLATFORM_STYLE_CLASSES) {
            if (!templateClass.equals(innerClass.getName())) continue;
            return innerClass;
        }
        return null;
    }

    private static void buildCustomContentIntoTemplate(Context context, RemoteViews template, RemoteViews customContent, StandardTemplateParams p, TemplateBindResult result) {
        int childIndex = -1;
        if (customContent != null) {
            customContent = customContent.clone();
            if (p.mHeaderless) {
                template.removeFromParent(16909295);
                Builder.setHeaderlessVerticalMargins(template, p, true);
            } else {
                Resources resources = context.getResources();
                result.mTitleMarginSet.applyToView(template, 16909286, resources.getDimension(17105383) / resources.getDisplayMetrics().density);
            }
            template.removeAllViewsExceptId(16909286, 16908301);
            template.addView(16909286, customContent, 0);
            template.addFlags(1);
            childIndex = 0;
        }
        template.setIntTag(16909286, 16909282, childIndex);
    }

    private static <T extends Parcelable> T[] getParcelableArrayFromBundle(Bundle bundle, String key, Class<T> itemClass) {
        Parcelable[] array2 = bundle.getParcelableArray(key);
        Class<?> arrayClass = Array.newInstance(itemClass, 0).getClass();
        if (arrayClass.isInstance(array2) || array2 == null) {
            return array2;
        }
        Parcelable[] typedArray = (Parcelable[])Array.newInstance(itemClass, array2.length);
        for (int i = 0; i < array2.length; ++i) {
            typedArray[i] = array2[i];
        }
        bundle.putParcelableArray(key, typedArray);
        return typedArray;
    }

    static {
        STANDARD_LAYOUTS.add(17367221);
        STANDARD_LAYOUTS.add(17367230);
        STANDARD_LAYOUTS.add(17367222);
        STANDARD_LAYOUTS.add(17367226);
        STANDARD_LAYOUTS.add(17367227);
        STANDARD_LAYOUTS.add(17367231);
        STANDARD_LAYOUTS.add(17367233);
        STANDARD_LAYOUTS.add(17367225);
        STANDARD_LAYOUTS.add(17367229);
        STANDARD_LAYOUTS.add(17367232);
        STANDARD_LAYOUTS.add(17367224);
        STANDARD_LAYOUTS.add(17367228);
        STANDARD_LAYOUTS.add(17367223);
        STANDARD_LAYOUTS.add(17367220);
        AUDIO_ATTRIBUTES_DEFAULT = new AudioAttributes.Builder().setContentType(4).setUsage(5).build();
        PLATFORM_STYLE_CLASSES = Arrays.asList(BigTextStyle.class, BigPictureStyle.class, InboxStyle.class, MediaStyle.class, DecoratedCustomViewStyle.class, DecoratedMediaCustomViewStyle.class, MessagingStyle.class, CallStyle.class);
        CREATOR = new Parcelable.Creator<Notification>(){

            @Override
            public Notification createFromParcel(Parcel parcel) {
                return new Notification(parcel);
            }

            public Notification[] newArray(int size) {
                return new Notification[size];
            }
        };
    }

    @VisibleForTesting
    public static class Colors {
        private int mPaletteIsForRawColor = 1;
        private boolean mPaletteIsForColorized = false;
        private boolean mPaletteIsForNightMode = false;
        private int mBackgroundColor = 1;
        private int mProtectionColor = 1;
        private int mPrimaryTextColor = 1;
        private int mSecondaryTextColor = 1;
        private int mPrimaryAccentColor = 1;
        private int mSecondaryAccentColor = 1;
        private int mTertiaryAccentColor = 1;
        private int mOnAccentTextColor = 1;
        private int mErrorColor = 1;
        private int mContrastColor = 1;
        private int mRippleAlpha = 51;

        private static TypedArray obtainDayNightAttributes(Context ctx, int[] attrs) {
            if (ctx.getTheme() == null) {
                return null;
            }
            Resources.Theme theme = new ContextThemeWrapper(ctx, 16974563).getTheme();
            return theme.obtainStyledAttributes(attrs);
        }

        private static int getColor(TypedArray ta, int index, int defValue) {
            return ta == null ? defValue : ta.getColor(index, defValue);
        }

        public void resolvePalette(Context ctx, int rawColor, boolean isColorized, boolean nightMode) {
            if (this.mPaletteIsForRawColor == rawColor && this.mPaletteIsForColorized == isColorized && this.mPaletteIsForNightMode == nightMode) {
                return;
            }
            this.mPaletteIsForRawColor = rawColor;
            this.mPaletteIsForColorized = isColorized;
            this.mPaletteIsForNightMode = nightMode;
            if (isColorized) {
                if (rawColor == 0) {
                    int[] attrs = new int[]{17956902};
                    try (TypedArray ta = Colors.obtainDayNightAttributes(ctx, attrs);){
                        this.mBackgroundColor = Colors.getColor(ta, 0, -1);
                    }
                } else {
                    this.mBackgroundColor = rawColor;
                }
                this.mProtectionColor = 1;
                this.mPrimaryTextColor = ContrastColorUtil.findAlphaToMeetContrast(ContrastColorUtil.resolvePrimaryColor(ctx, this.mBackgroundColor, nightMode), this.mBackgroundColor, 4.5);
                this.mSecondaryTextColor = ContrastColorUtil.findAlphaToMeetContrast(ContrastColorUtil.resolveSecondaryColor(ctx, this.mBackgroundColor, nightMode), this.mBackgroundColor, 4.5);
                this.mContrastColor = this.mPrimaryTextColor;
                this.mPrimaryAccentColor = this.mPrimaryTextColor;
                this.mSecondaryAccentColor = this.mSecondaryTextColor;
                this.mTertiaryAccentColor = Colors.flattenAlpha(this.mPrimaryTextColor, this.mBackgroundColor);
                this.mOnAccentTextColor = this.mBackgroundColor;
                this.mErrorColor = this.mPrimaryTextColor;
                this.mRippleAlpha = 51;
            } else {
                int[] attrs = new int[]{17956909, 16844002, 16842806, 16842808, 16843829, 17956902, 17956904, 17957103, 16844099, 16843820};
                try (TypedArray ta = Colors.obtainDayNightAttributes(ctx, attrs);){
                    this.mBackgroundColor = Colors.getColor(ta, 0, nightMode ? -16777216 : -1);
                    this.mProtectionColor = Colors.getColor(ta, 1, 1);
                    this.mPrimaryTextColor = Colors.getColor(ta, 2, 1);
                    this.mSecondaryTextColor = Colors.getColor(ta, 3, 1);
                    this.mPrimaryAccentColor = Colors.getColor(ta, 4, 1);
                    this.mSecondaryAccentColor = Colors.getColor(ta, 5, 1);
                    this.mTertiaryAccentColor = Colors.getColor(ta, 6, 1);
                    this.mOnAccentTextColor = Colors.getColor(ta, 7, 1);
                    this.mErrorColor = Colors.getColor(ta, 8, 1);
                    this.mRippleAlpha = Color.alpha(Colors.getColor(ta, 9, 0x33FFFFFF));
                }
                this.mContrastColor = Colors.calculateContrastColor(ctx, rawColor, this.mPrimaryAccentColor, this.mBackgroundColor, nightMode);
                if (this.mPrimaryTextColor == 1) {
                    this.mPrimaryTextColor = ContrastColorUtil.resolvePrimaryColor(ctx, this.mBackgroundColor, nightMode);
                }
                if (this.mSecondaryTextColor == 1) {
                    this.mSecondaryTextColor = ContrastColorUtil.resolveSecondaryColor(ctx, this.mBackgroundColor, nightMode);
                }
                if (this.mPrimaryAccentColor == 1) {
                    this.mPrimaryAccentColor = this.mContrastColor;
                }
                if (this.mSecondaryAccentColor == 1) {
                    this.mSecondaryAccentColor = this.mContrastColor;
                }
                if (this.mTertiaryAccentColor == 1) {
                    this.mTertiaryAccentColor = this.mContrastColor;
                }
                if (this.mOnAccentTextColor == 1) {
                    this.mOnAccentTextColor = ColorUtils.setAlphaComponent(ContrastColorUtil.resolvePrimaryColor(ctx, this.mTertiaryAccentColor, nightMode), 255);
                }
                if (this.mErrorColor == 1) {
                    this.mErrorColor = this.mPrimaryTextColor;
                }
            }
            if (this.mProtectionColor == 1) {
                this.mProtectionColor = ColorUtils.blendARGB(this.mPrimaryTextColor, this.mBackgroundColor, 0.8f);
            }
        }

        private static int calculateContrastColor(Context ctx, int rawColor, int accentColor, int backgroundColor, boolean nightMode) {
            int color2;
            if (rawColor == 0) {
                color2 = accentColor;
                if (color2 == 1) {
                    color2 = ContrastColorUtil.resolveDefaultColor(ctx, backgroundColor, nightMode);
                }
            } else {
                color2 = ContrastColorUtil.resolveContrastColor(ctx, rawColor, backgroundColor, nightMode);
            }
            return Colors.flattenAlpha(color2, backgroundColor);
        }

        private static int flattenAlpha(int color2, int background) {
            return Color.alpha(color2) == 255 ? color2 : ContrastColorUtil.compositeColors(color2, background);
        }

        public int getBackgroundColor() {
            return this.mBackgroundColor;
        }

        public int getProtectionColor() {
            return this.mProtectionColor;
        }

        public int getPrimaryTextColor() {
            return this.mPrimaryTextColor;
        }

        public int getSecondaryTextColor() {
            return this.mSecondaryTextColor;
        }

        public int getPrimaryAccentColor() {
            return this.mPrimaryAccentColor;
        }

        public int getSecondaryAccentColor() {
            return this.mSecondaryAccentColor;
        }

        public int getTertiaryAccentColor() {
            return this.mTertiaryAccentColor;
        }

        public int getOnAccentTextColor() {
            return this.mOnAccentTextColor;
        }

        public int getContrastColor() {
            return this.mContrastColor;
        }

        public int getErrorColor() {
            return this.mErrorColor;
        }

        public int getRippleAlpha() {
            return this.mRippleAlpha;
        }
    }

    private static class StandardTemplateParams {
        public static final int DECORATION_MINIMAL = 1;
        public static final int DECORATION_PARTIAL = 2;
        public static int VIEW_TYPE_UNSPECIFIED = 0;
        public static int VIEW_TYPE_NORMAL = 1;
        public static int VIEW_TYPE_BIG = 2;
        public static int VIEW_TYPE_HEADS_UP = 3;
        public static int VIEW_TYPE_MINIMIZED = 4;
        public static int VIEW_TYPE_PUBLIC = 5;
        public static int VIEW_TYPE_GROUP_HEADER = 6;
        int mViewType = VIEW_TYPE_UNSPECIFIED;
        boolean mHeaderless;
        boolean mHideAppName;
        boolean mHideTitle;
        boolean mHideSubText;
        boolean mHideTime;
        boolean mHideActions;
        boolean mHideProgress;
        boolean mHideSnoozeButton;
        boolean mHideLeftIcon;
        boolean mHideRightIcon;
        Icon mPromotedPicture;
        boolean mCallStyleActions;
        boolean mAllowTextWithProgress;
        int mTitleViewId;
        int mTextViewId;
        CharSequence title;
        CharSequence text;
        CharSequence headerTextSecondary;
        CharSequence summaryText;
        int maxRemoteInputHistory = 3;
        boolean allowColorization = true;
        boolean mHighlightExpander = false;

        private StandardTemplateParams() {
        }

        StandardTemplateParams reset() {
            this.mViewType = VIEW_TYPE_UNSPECIFIED;
            this.mHeaderless = false;
            this.mHideAppName = false;
            this.mHideTitle = false;
            this.mHideSubText = false;
            this.mHideTime = false;
            this.mHideActions = false;
            this.mHideProgress = false;
            this.mHideSnoozeButton = false;
            this.mHideLeftIcon = false;
            this.mHideRightIcon = false;
            this.mPromotedPicture = null;
            this.mCallStyleActions = false;
            this.mAllowTextWithProgress = false;
            this.mTitleViewId = 16908310;
            this.mTextViewId = 16909579;
            this.title = null;
            this.text = null;
            this.summaryText = null;
            this.headerTextSecondary = null;
            this.maxRemoteInputHistory = 3;
            this.allowColorization = true;
            this.mHighlightExpander = false;
            return this;
        }

        boolean hasTitle() {
            return !TextUtils.isEmpty(this.title) && !this.mHideTitle;
        }

        StandardTemplateParams viewType(int viewType) {
            this.mViewType = viewType;
            return this;
        }

        public StandardTemplateParams headerless(boolean headerless) {
            this.mHeaderless = headerless;
            return this;
        }

        public StandardTemplateParams hideAppName(boolean hideAppName) {
            this.mHideAppName = hideAppName;
            return this;
        }

        public StandardTemplateParams hideSubText(boolean hideSubText) {
            this.mHideSubText = hideSubText;
            return this;
        }

        public StandardTemplateParams hideTime(boolean hideTime) {
            this.mHideTime = hideTime;
            return this;
        }

        StandardTemplateParams hideActions(boolean hideActions) {
            this.mHideActions = hideActions;
            return this;
        }

        StandardTemplateParams hideProgress(boolean hideProgress) {
            this.mHideProgress = hideProgress;
            return this;
        }

        StandardTemplateParams hideTitle(boolean hideTitle) {
            this.mHideTitle = hideTitle;
            return this;
        }

        StandardTemplateParams callStyleActions(boolean callStyleActions) {
            this.mCallStyleActions = callStyleActions;
            return this;
        }

        StandardTemplateParams allowTextWithProgress(boolean allowTextWithProgress) {
            this.mAllowTextWithProgress = allowTextWithProgress;
            return this;
        }

        StandardTemplateParams hideSnoozeButton(boolean hideSnoozeButton) {
            this.mHideSnoozeButton = hideSnoozeButton;
            return this;
        }

        StandardTemplateParams promotedPicture(Icon promotedPicture) {
            this.mPromotedPicture = promotedPicture;
            return this;
        }

        public StandardTemplateParams titleViewId(int titleViewId) {
            this.mTitleViewId = titleViewId;
            return this;
        }

        public StandardTemplateParams textViewId(int textViewId) {
            this.mTextViewId = textViewId;
            return this;
        }

        StandardTemplateParams title(CharSequence title) {
            this.title = title;
            return this;
        }

        StandardTemplateParams text(CharSequence text) {
            this.text = text;
            return this;
        }

        StandardTemplateParams summaryText(CharSequence text) {
            this.summaryText = text;
            return this;
        }

        StandardTemplateParams headerTextSecondary(CharSequence text) {
            this.headerTextSecondary = text;
            return this;
        }

        StandardTemplateParams hideLeftIcon(boolean hideLeftIcon) {
            this.mHideLeftIcon = hideLeftIcon;
            return this;
        }

        StandardTemplateParams hideRightIcon(boolean hideRightIcon) {
            this.mHideRightIcon = hideRightIcon;
            return this;
        }

        StandardTemplateParams disallowColorization() {
            this.allowColorization = false;
            return this;
        }

        StandardTemplateParams highlightExpander(boolean highlight) {
            this.mHighlightExpander = highlight;
            return this;
        }

        StandardTemplateParams fillTextsFrom(Builder b) {
            Bundle extras = b.mN.extras;
            this.title = b.processLegacyText(extras.getCharSequence(Notification.EXTRA_TITLE));
            this.text = b.processLegacyText(extras.getCharSequence(Notification.EXTRA_TEXT));
            this.summaryText = extras.getCharSequence(Notification.EXTRA_SUB_TEXT);
            return this;
        }

        public StandardTemplateParams setMaxRemoteInputHistory(int maxRemoteInputHistory) {
            this.maxRemoteInputHistory = maxRemoteInputHistory;
            return this;
        }

        public StandardTemplateParams decorationType(int decorationType) {
            this.hideTitle(true);
            boolean hideOtherFields = decorationType <= 1;
            this.hideLeftIcon(false);
            this.hideRightIcon(hideOtherFields);
            this.hideProgress(hideOtherFields);
            this.hideActions(hideOtherFields);
            return this;
        }
    }

    private static class TemplateBindResult {
        boolean mRightIconVisible;
        float mRightIconWidthDp;
        float mRightIconHeightDp;
        public final MarginSet mHeadingExtraMarginSet = new MarginSet();
        public final MarginSet mHeadingFullMarginSet = new MarginSet();
        public final MarginSet mTitleMarginSet = new MarginSet();

        private TemplateBindResult() {
        }

        public void setRightIconState(boolean visible, float widthDp, float heightDp, float marginEndDpIfVisible, float expanderSizeDp) {
            this.mRightIconVisible = visible;
            this.mRightIconWidthDp = widthDp;
            this.mRightIconHeightDp = heightDp;
            this.mHeadingExtraMarginSet.setValues(0.0f, marginEndDpIfVisible);
            this.mHeadingFullMarginSet.setValues(expanderSizeDp, marginEndDpIfVisible + expanderSizeDp);
            this.mTitleMarginSet.setValues(0.0f, marginEndDpIfVisible + expanderSizeDp);
        }

        private class MarginSet {
            private float mValueIfGone;
            private float mValueIfVisible;

            private MarginSet() {
            }

            public void setValues(float valueIfGone, float valueIfVisible) {
                this.mValueIfGone = valueIfGone;
                this.mValueIfVisible = valueIfVisible;
            }

            public void applyToView(RemoteViews views, int viewId) {
                this.applyToView(views, viewId, 0.0f);
            }

            public void applyToView(RemoteViews views, int viewId, float extraMarginDp) {
                float marginEndDp = this.getDpValue() + extraMarginDp;
                if (viewId == 16909283) {
                    views.setFloat(16909283, "setTopLineExtraMarginEndDp", marginEndDp);
                } else if (viewId == 16909579 || viewId == 16908822) {
                    if (this.mValueIfGone != 0.0f) {
                        throw new RuntimeException("Programming error: `text` and `big_text` use ImageFloatingTextView which can either show a margin or not; thus mValueIfGone must be 0, but it was " + this.mValueIfGone);
                    }
                    views.setFloat(viewId, "setImageEndMarginDp", this.mValueIfVisible);
                    views.setBoolean(viewId, "setHasImage", TemplateBindResult.this.mRightIconVisible);
                    views.setViewLayoutMargin(viewId, 5, extraMarginDp, 1);
                } else {
                    views.setViewLayoutMargin(viewId, 5, marginEndDp, 1);
                }
                if (TemplateBindResult.this.mRightIconVisible) {
                    views.setIntTag(viewId, 16909575, TypedValue.createComplexDimension(this.mValueIfVisible + extraMarginDp, 1));
                    views.setIntTag(viewId, 16909574, TypedValue.createComplexDimension(this.mValueIfGone + extraMarginDp, 1));
                }
            }

            public float getDpValue() {
                return TemplateBindResult.this.mRightIconVisible ? this.mValueIfVisible : this.mValueIfGone;
            }
        }
    }

    private static class BuilderRemoteViews
    extends RemoteViews {
        public BuilderRemoteViews(Parcel parcel) {
            super(parcel);
        }

        public BuilderRemoteViews(ApplicationInfo appInfo, int layoutId) {
            super(appInfo, layoutId);
        }

        @Override
        public BuilderRemoteViews clone() {
            Parcel p = Parcel.obtain();
            this.writeToParcel(p, 0);
            p.setDataPosition(0);
            BuilderRemoteViews brv = new BuilderRemoteViews(p);
            p.recycle();
            return brv;
        }

        @Override
        protected boolean shouldUseStaticFilter() {
            return true;
        }
    }

    @SystemApi
    public static class TvExtender
    implements Extender {
        private static final String TAG = "TvExtender";
        private static final String EXTRA_TV_EXTENDER = "android.tv.EXTENSIONS";
        private static final String EXTRA_FLAGS = "flags";
        static final String EXTRA_CONTENT_INTENT = "content_intent";
        static final String EXTRA_DELETE_INTENT = "delete_intent";
        private static final String EXTRA_CHANNEL_ID = "channel_id";
        private static final String EXTRA_SUPPRESS_SHOW_OVER_APPS = "suppressShowOverApps";
        private static final int FLAG_AVAILABLE_ON_TV = 1;
        private int mFlags;
        private String mChannelId;
        private PendingIntent mContentIntent;
        private PendingIntent mDeleteIntent;
        private boolean mSuppressShowOverApps;

        public TvExtender() {
            this.mFlags = 1;
        }

        public TvExtender(Notification notif) {
            Bundle bundle;
            Bundle bundle2 = bundle = notif.extras == null ? null : notif.extras.getBundle(EXTRA_TV_EXTENDER);
            if (bundle != null) {
                this.mFlags = bundle.getInt(EXTRA_FLAGS);
                this.mChannelId = bundle.getString(EXTRA_CHANNEL_ID);
                this.mSuppressShowOverApps = bundle.getBoolean(EXTRA_SUPPRESS_SHOW_OVER_APPS);
                this.mContentIntent = bundle.getParcelable(EXTRA_CONTENT_INTENT, PendingIntent.class);
                this.mDeleteIntent = bundle.getParcelable(EXTRA_DELETE_INTENT, PendingIntent.class);
            }
        }

        @Override
        public Builder extend(Builder builder) {
            Bundle bundle = new Bundle();
            bundle.putInt(EXTRA_FLAGS, this.mFlags);
            bundle.putString(EXTRA_CHANNEL_ID, this.mChannelId);
            bundle.putBoolean(EXTRA_SUPPRESS_SHOW_OVER_APPS, this.mSuppressShowOverApps);
            if (this.mContentIntent != null) {
                bundle.putParcelable(EXTRA_CONTENT_INTENT, this.mContentIntent);
            }
            if (this.mDeleteIntent != null) {
                bundle.putParcelable(EXTRA_DELETE_INTENT, this.mDeleteIntent);
            }
            builder.getExtras().putBundle(EXTRA_TV_EXTENDER, bundle);
            return builder;
        }

        public boolean isAvailableOnTv() {
            return (this.mFlags & 1) != 0;
        }

        public TvExtender setChannel(String channelId) {
            this.mChannelId = channelId;
            return this;
        }

        public TvExtender setChannelId(String channelId) {
            this.mChannelId = channelId;
            return this;
        }

        @Deprecated
        public String getChannel() {
            return this.mChannelId;
        }

        public String getChannelId() {
            return this.mChannelId;
        }

        public TvExtender setContentIntent(PendingIntent intent) {
            this.mContentIntent = intent;
            return this;
        }

        public PendingIntent getContentIntent() {
            return this.mContentIntent;
        }

        public TvExtender setDeleteIntent(PendingIntent intent) {
            this.mDeleteIntent = intent;
            return this;
        }

        public PendingIntent getDeleteIntent() {
            return this.mDeleteIntent;
        }

        public TvExtender setSuppressShowOverApps(boolean suppress) {
            this.mSuppressShowOverApps = suppress;
            return this;
        }

        public boolean getSuppressShowOverApps() {
            return this.mSuppressShowOverApps;
        }
    }

    public static class CarExtender
    implements Extender {
        private static final String TAG = "CarExtender";
        private static final String EXTRA_CAR_EXTENDER = "android.car.EXTENSIONS";
        private static final String EXTRA_LARGE_ICON = "large_icon";
        private static final String EXTRA_CONVERSATION = "car_conversation";
        private static final String EXTRA_COLOR = "app_color";
        private Bitmap mLargeIcon;
        private UnreadConversation mUnreadConversation;
        private int mColor = 0;

        public CarExtender() {
        }

        public CarExtender(Notification notif) {
            Bundle carBundle;
            Bundle bundle = carBundle = notif.extras == null ? null : notif.extras.getBundle(EXTRA_CAR_EXTENDER);
            if (carBundle != null) {
                this.mLargeIcon = carBundle.getParcelable(EXTRA_LARGE_ICON, Bitmap.class);
                this.mColor = carBundle.getInt(EXTRA_COLOR, 0);
                Bundle b = carBundle.getBundle(EXTRA_CONVERSATION);
                this.mUnreadConversation = UnreadConversation.getUnreadConversationFromBundle(b);
            }
        }

        @Override
        public android.app.Notification$Builder extend(android.app.Notification$Builder builder) {
            Bundle carExtensions = new Bundle();
            if (this.mLargeIcon != null) {
                carExtensions.putParcelable(EXTRA_LARGE_ICON, this.mLargeIcon);
            }
            if (this.mColor != 0) {
                carExtensions.putInt(EXTRA_COLOR, this.mColor);
            }
            if (this.mUnreadConversation != null) {
                Bundle b = this.mUnreadConversation.getBundleForUnreadConversation();
                carExtensions.putBundle(EXTRA_CONVERSATION, b);
            }
            builder.getExtras().putBundle(EXTRA_CAR_EXTENDER, carExtensions);
            return builder;
        }

        public CarExtender setColor(int color2) {
            this.mColor = color2;
            return this;
        }

        public int getColor() {
            return this.mColor;
        }

        public CarExtender setLargeIcon(Bitmap largeIcon) {
            this.mLargeIcon = largeIcon;
            return this;
        }

        public Bitmap getLargeIcon() {
            return this.mLargeIcon;
        }

        public CarExtender setUnreadConversation(UnreadConversation unreadConversation) {
            this.mUnreadConversation = unreadConversation;
            return this;
        }

        public UnreadConversation getUnreadConversation() {
            return this.mUnreadConversation;
        }

        public static class Builder {
            private final List<String> mMessages = new ArrayList<String>();
            private final String mParticipant;
            private RemoteInput mRemoteInput;
            private PendingIntent mReadPendingIntent;
            private PendingIntent mReplyPendingIntent;
            private long mLatestTimestamp;

            public Builder(String name) {
                this.mParticipant = name;
            }

            public Builder addMessage(String message) {
                this.mMessages.add(message);
                return this;
            }

            public Builder setReplyAction(PendingIntent pendingIntent, RemoteInput remoteInput) {
                this.mRemoteInput = remoteInput;
                this.mReplyPendingIntent = pendingIntent;
                return this;
            }

            public Builder setReadPendingIntent(PendingIntent pendingIntent) {
                this.mReadPendingIntent = pendingIntent;
                return this;
            }

            public Builder setLatestTimestamp(long timestamp) {
                this.mLatestTimestamp = timestamp;
                return this;
            }

            public UnreadConversation build() {
                String[] messages = this.mMessages.toArray(new String[this.mMessages.size()]);
                String[] participants = new String[]{this.mParticipant};
                return new UnreadConversation(messages, this.mRemoteInput, this.mReplyPendingIntent, this.mReadPendingIntent, participants, this.mLatestTimestamp);
            }
        }

        public static class UnreadConversation {
            private static final String KEY_AUTHOR = "author";
            private static final String KEY_TEXT = "text";
            private static final String KEY_MESSAGES = "messages";
            static final String KEY_REMOTE_INPUT = "remote_input";
            static final String KEY_ON_REPLY = "on_reply";
            static final String KEY_ON_READ = "on_read";
            private static final String KEY_PARTICIPANTS = "participants";
            private static final String KEY_TIMESTAMP = "timestamp";
            private final String[] mMessages;
            private final RemoteInput mRemoteInput;
            private final PendingIntent mReplyPendingIntent;
            private final PendingIntent mReadPendingIntent;
            private final String[] mParticipants;
            private final long mLatestTimestamp;

            UnreadConversation(String[] messages, RemoteInput remoteInput, PendingIntent replyPendingIntent, PendingIntent readPendingIntent, String[] participants, long latestTimestamp) {
                this.mMessages = messages;
                this.mRemoteInput = remoteInput;
                this.mReadPendingIntent = readPendingIntent;
                this.mReplyPendingIntent = replyPendingIntent;
                this.mParticipants = participants;
                this.mLatestTimestamp = latestTimestamp;
            }

            public String[] getMessages() {
                return this.mMessages;
            }

            public RemoteInput getRemoteInput() {
                return this.mRemoteInput;
            }

            public PendingIntent getReplyPendingIntent() {
                return this.mReplyPendingIntent;
            }

            public PendingIntent getReadPendingIntent() {
                return this.mReadPendingIntent;
            }

            public String[] getParticipants() {
                return this.mParticipants;
            }

            public String getParticipant() {
                return this.mParticipants.length > 0 ? this.mParticipants[0] : null;
            }

            public long getLatestTimestamp() {
                return this.mLatestTimestamp;
            }

            Bundle getBundleForUnreadConversation() {
                Bundle b = new Bundle();
                String author = null;
                if (this.mParticipants != null && this.mParticipants.length > 1) {
                    author = this.mParticipants[0];
                }
                Parcelable[] messages = new Parcelable[this.mMessages.length];
                for (int i = 0; i < messages.length; ++i) {
                    Bundle m = new Bundle();
                    m.putString(KEY_TEXT, this.mMessages[i]);
                    m.putString(KEY_AUTHOR, author);
                    messages[i] = m;
                }
                b.putParcelableArray(KEY_MESSAGES, messages);
                if (this.mRemoteInput != null) {
                    b.putParcelable(KEY_REMOTE_INPUT, this.mRemoteInput);
                }
                b.putParcelable(KEY_ON_REPLY, this.mReplyPendingIntent);
                b.putParcelable(KEY_ON_READ, this.mReadPendingIntent);
                b.putStringArray(KEY_PARTICIPANTS, this.mParticipants);
                b.putLong(KEY_TIMESTAMP, this.mLatestTimestamp);
                return b;
            }

            static UnreadConversation getUnreadConversationFromBundle(Bundle b) {
                if (b == null) {
                    return null;
                }
                Parcelable[] parcelableMessages = b.getParcelableArray(KEY_MESSAGES);
                String[] messages = null;
                if (parcelableMessages != null) {
                    String[] tmp = new String[parcelableMessages.length];
                    boolean success = true;
                    for (int i = 0; i < tmp.length; ++i) {
                        if (!(parcelableMessages[i] instanceof Bundle)) {
                            success = false;
                            break;
                        }
                        tmp[i] = ((Bundle)parcelableMessages[i]).getString(KEY_TEXT);
                        if (tmp[i] != null) continue;
                        success = false;
                        break;
                    }
                    if (success) {
                        messages = tmp;
                    } else {
                        return null;
                    }
                }
                PendingIntent onRead = b.getParcelable(KEY_ON_READ, PendingIntent.class);
                PendingIntent onReply = b.getParcelable(KEY_ON_REPLY, PendingIntent.class);
                RemoteInput remoteInput = b.getParcelable(KEY_REMOTE_INPUT, RemoteInput.class);
                String[] participants = b.getStringArray(KEY_PARTICIPANTS);
                if (participants == null || participants.length != 1) {
                    return null;
                }
                return new UnreadConversation(messages, remoteInput, onReply, onRead, participants, b.getLong(KEY_TIMESTAMP));
            }
        }
    }

    public static class WearableExtender
    implements Extender {
        public static final int UNSET_ACTION_INDEX = -1;
        @Deprecated
        public static final int SIZE_DEFAULT = 0;
        @Deprecated
        public static final int SIZE_XSMALL = 1;
        @Deprecated
        public static final int SIZE_SMALL = 2;
        @Deprecated
        public static final int SIZE_MEDIUM = 3;
        @Deprecated
        public static final int SIZE_LARGE = 4;
        @Deprecated
        public static final int SIZE_FULL_SCREEN = 5;
        @Deprecated
        public static final int SCREEN_TIMEOUT_SHORT = 0;
        @Deprecated
        public static final int SCREEN_TIMEOUT_LONG = -1;
        private static final String EXTRA_WEARABLE_EXTENSIONS = "android.wearable.EXTENSIONS";
        private static final String KEY_ACTIONS = "actions";
        private static final String KEY_FLAGS = "flags";
        static final String KEY_DISPLAY_INTENT = "displayIntent";
        private static final String KEY_PAGES = "pages";
        static final String KEY_BACKGROUND = "background";
        private static final String KEY_CONTENT_ICON = "contentIcon";
        private static final String KEY_CONTENT_ICON_GRAVITY = "contentIconGravity";
        private static final String KEY_CONTENT_ACTION_INDEX = "contentActionIndex";
        private static final String KEY_CUSTOM_SIZE_PRESET = "customSizePreset";
        private static final String KEY_CUSTOM_CONTENT_HEIGHT = "customContentHeight";
        private static final String KEY_GRAVITY = "gravity";
        private static final String KEY_HINT_SCREEN_TIMEOUT = "hintScreenTimeout";
        private static final String KEY_DISMISSAL_ID = "dismissalId";
        private static final String KEY_BRIDGE_TAG = "bridgeTag";
        private static final int FLAG_CONTENT_INTENT_AVAILABLE_OFFLINE = 1;
        private static final int FLAG_HINT_HIDE_ICON = 2;
        private static final int FLAG_HINT_SHOW_BACKGROUND_ONLY = 4;
        private static final int FLAG_START_SCROLL_BOTTOM = 8;
        private static final int FLAG_HINT_AVOID_BACKGROUND_CLIPPING = 16;
        private static final int FLAG_BIG_PICTURE_AMBIENT = 32;
        private static final int FLAG_HINT_CONTENT_INTENT_LAUNCHES_ACTIVITY = 64;
        private static final int DEFAULT_FLAGS = 1;
        private static final int DEFAULT_CONTENT_ICON_GRAVITY = 0x800005;
        private static final int DEFAULT_GRAVITY = 80;
        private ArrayList<Action> mActions = new ArrayList();
        private int mFlags = 1;
        private PendingIntent mDisplayIntent;
        private ArrayList<Notification> mPages = new ArrayList();
        private Bitmap mBackground;
        private int mContentIcon;
        private int mContentIconGravity = 0x800005;
        private int mContentActionIndex = -1;
        private int mCustomSizePreset = 0;
        private int mCustomContentHeight;
        private int mGravity = 80;
        private int mHintScreenTimeout;
        private String mDismissalId;
        private String mBridgeTag;

        public WearableExtender() {
        }

        public WearableExtender(Notification notif) {
            Bundle wearableBundle = notif.extras.getBundle(EXTRA_WEARABLE_EXTENSIONS);
            if (wearableBundle != null) {
                ArrayList actions = wearableBundle.getParcelableArrayList(KEY_ACTIONS);
                if (actions != null) {
                    this.mActions.addAll(actions);
                }
                this.mFlags = wearableBundle.getInt(KEY_FLAGS, 1);
                this.mDisplayIntent = wearableBundle.getParcelable(KEY_DISPLAY_INTENT, PendingIntent.class);
                Notification[] pages = (Notification[])Notification.getParcelableArrayFromBundle((Bundle)wearableBundle, (String)KEY_PAGES, Notification.class);
                if (pages != null) {
                    Collections.addAll(this.mPages, pages);
                }
                this.mBackground = wearableBundle.getParcelable(KEY_BACKGROUND, Bitmap.class);
                this.mContentIcon = wearableBundle.getInt(KEY_CONTENT_ICON);
                this.mContentIconGravity = wearableBundle.getInt(KEY_CONTENT_ICON_GRAVITY, 0x800005);
                this.mContentActionIndex = wearableBundle.getInt(KEY_CONTENT_ACTION_INDEX, -1);
                this.mCustomSizePreset = wearableBundle.getInt(KEY_CUSTOM_SIZE_PRESET, 0);
                this.mCustomContentHeight = wearableBundle.getInt(KEY_CUSTOM_CONTENT_HEIGHT);
                this.mGravity = wearableBundle.getInt(KEY_GRAVITY, 80);
                this.mHintScreenTimeout = wearableBundle.getInt(KEY_HINT_SCREEN_TIMEOUT);
                this.mDismissalId = wearableBundle.getString(KEY_DISMISSAL_ID);
                this.mBridgeTag = wearableBundle.getString(KEY_BRIDGE_TAG);
            }
        }

        @Override
        public Builder extend(Builder builder) {
            Bundle wearableBundle = new Bundle();
            if (!this.mActions.isEmpty()) {
                wearableBundle.putParcelableArrayList(KEY_ACTIONS, this.mActions);
            }
            if (this.mFlags != 1) {
                wearableBundle.putInt(KEY_FLAGS, this.mFlags);
            }
            if (this.mDisplayIntent != null) {
                wearableBundle.putParcelable(KEY_DISPLAY_INTENT, this.mDisplayIntent);
            }
            if (!this.mPages.isEmpty()) {
                wearableBundle.putParcelableArray(KEY_PAGES, this.mPages.toArray(new Notification[this.mPages.size()]));
            }
            if (this.mBackground != null) {
                wearableBundle.putParcelable(KEY_BACKGROUND, this.mBackground);
            }
            if (this.mContentIcon != 0) {
                wearableBundle.putInt(KEY_CONTENT_ICON, this.mContentIcon);
            }
            if (this.mContentIconGravity != 0x800005) {
                wearableBundle.putInt(KEY_CONTENT_ICON_GRAVITY, this.mContentIconGravity);
            }
            if (this.mContentActionIndex != -1) {
                wearableBundle.putInt(KEY_CONTENT_ACTION_INDEX, this.mContentActionIndex);
            }
            if (this.mCustomSizePreset != 0) {
                wearableBundle.putInt(KEY_CUSTOM_SIZE_PRESET, this.mCustomSizePreset);
            }
            if (this.mCustomContentHeight != 0) {
                wearableBundle.putInt(KEY_CUSTOM_CONTENT_HEIGHT, this.mCustomContentHeight);
            }
            if (this.mGravity != 80) {
                wearableBundle.putInt(KEY_GRAVITY, this.mGravity);
            }
            if (this.mHintScreenTimeout != 0) {
                wearableBundle.putInt(KEY_HINT_SCREEN_TIMEOUT, this.mHintScreenTimeout);
            }
            if (this.mDismissalId != null) {
                wearableBundle.putString(KEY_DISMISSAL_ID, this.mDismissalId);
            }
            if (this.mBridgeTag != null) {
                wearableBundle.putString(KEY_BRIDGE_TAG, this.mBridgeTag);
            }
            builder.getExtras().putBundle(EXTRA_WEARABLE_EXTENSIONS, wearableBundle);
            return builder;
        }

        public WearableExtender clone() {
            WearableExtender that = new WearableExtender();
            that.mActions = new ArrayList<Action>(this.mActions);
            that.mFlags = this.mFlags;
            that.mDisplayIntent = this.mDisplayIntent;
            that.mPages = new ArrayList<Notification>(this.mPages);
            that.mBackground = this.mBackground;
            that.mContentIcon = this.mContentIcon;
            that.mContentIconGravity = this.mContentIconGravity;
            that.mContentActionIndex = this.mContentActionIndex;
            that.mCustomSizePreset = this.mCustomSizePreset;
            that.mCustomContentHeight = this.mCustomContentHeight;
            that.mGravity = this.mGravity;
            that.mHintScreenTimeout = this.mHintScreenTimeout;
            that.mDismissalId = this.mDismissalId;
            that.mBridgeTag = this.mBridgeTag;
            return that;
        }

        public WearableExtender addAction(Action action) {
            this.mActions.add(action);
            return this;
        }

        public WearableExtender addActions(List<Action> actions) {
            this.mActions.addAll(actions);
            return this;
        }

        public WearableExtender clearActions() {
            this.mActions.clear();
            return this;
        }

        public List<Action> getActions() {
            return this.mActions;
        }

        @Deprecated
        public WearableExtender setDisplayIntent(PendingIntent intent) {
            this.mDisplayIntent = intent;
            return this;
        }

        @Deprecated
        public PendingIntent getDisplayIntent() {
            return this.mDisplayIntent;
        }

        @Deprecated
        public WearableExtender addPage(Notification page) {
            this.mPages.add(page);
            return this;
        }

        @Deprecated
        public WearableExtender addPages(List<Notification> pages) {
            this.mPages.addAll(pages);
            return this;
        }

        @Deprecated
        public WearableExtender clearPages() {
            this.mPages.clear();
            return this;
        }

        @Deprecated
        public List<Notification> getPages() {
            return this.mPages;
        }

        @Deprecated
        public WearableExtender setBackground(Bitmap background) {
            this.mBackground = background;
            return this;
        }

        @Deprecated
        public Bitmap getBackground() {
            return this.mBackground;
        }

        @Deprecated
        public WearableExtender setContentIcon(int icon) {
            this.mContentIcon = icon;
            return this;
        }

        @Deprecated
        public int getContentIcon() {
            return this.mContentIcon;
        }

        @Deprecated
        public WearableExtender setContentIconGravity(int contentIconGravity) {
            this.mContentIconGravity = contentIconGravity;
            return this;
        }

        @Deprecated
        public int getContentIconGravity() {
            return this.mContentIconGravity;
        }

        public WearableExtender setContentAction(int actionIndex) {
            this.mContentActionIndex = actionIndex;
            return this;
        }

        public int getContentAction() {
            return this.mContentActionIndex;
        }

        @Deprecated
        public WearableExtender setGravity(int gravity) {
            this.mGravity = gravity;
            return this;
        }

        @Deprecated
        public int getGravity() {
            return this.mGravity;
        }

        @Deprecated
        public WearableExtender setCustomSizePreset(int sizePreset) {
            this.mCustomSizePreset = sizePreset;
            return this;
        }

        @Deprecated
        public int getCustomSizePreset() {
            return this.mCustomSizePreset;
        }

        @Deprecated
        public WearableExtender setCustomContentHeight(int height) {
            this.mCustomContentHeight = height;
            return this;
        }

        @Deprecated
        public int getCustomContentHeight() {
            return this.mCustomContentHeight;
        }

        public WearableExtender setStartScrollBottom(boolean startScrollBottom) {
            this.setFlag(8, startScrollBottom);
            return this;
        }

        public boolean getStartScrollBottom() {
            return (this.mFlags & 8) != 0;
        }

        public WearableExtender setContentIntentAvailableOffline(boolean contentIntentAvailableOffline) {
            this.setFlag(1, contentIntentAvailableOffline);
            return this;
        }

        public boolean getContentIntentAvailableOffline() {
            return (this.mFlags & 1) != 0;
        }

        @Deprecated
        public WearableExtender setHintHideIcon(boolean hintHideIcon) {
            this.setFlag(2, hintHideIcon);
            return this;
        }

        @Deprecated
        public boolean getHintHideIcon() {
            return (this.mFlags & 2) != 0;
        }

        @Deprecated
        public WearableExtender setHintShowBackgroundOnly(boolean hintShowBackgroundOnly) {
            this.setFlag(4, hintShowBackgroundOnly);
            return this;
        }

        @Deprecated
        public boolean getHintShowBackgroundOnly() {
            return (this.mFlags & 4) != 0;
        }

        @Deprecated
        public WearableExtender setHintAvoidBackgroundClipping(boolean hintAvoidBackgroundClipping) {
            this.setFlag(16, hintAvoidBackgroundClipping);
            return this;
        }

        @Deprecated
        public boolean getHintAvoidBackgroundClipping() {
            return (this.mFlags & 0x10) != 0;
        }

        @Deprecated
        public WearableExtender setHintScreenTimeout(int timeout) {
            this.mHintScreenTimeout = timeout;
            return this;
        }

        @Deprecated
        public int getHintScreenTimeout() {
            return this.mHintScreenTimeout;
        }

        @Deprecated
        public WearableExtender setHintAmbientBigPicture(boolean hintAmbientBigPicture) {
            this.setFlag(32, hintAmbientBigPicture);
            return this;
        }

        @Deprecated
        public boolean getHintAmbientBigPicture() {
            return (this.mFlags & 0x20) != 0;
        }

        public WearableExtender setHintContentIntentLaunchesActivity(boolean hintContentIntentLaunchesActivity) {
            this.setFlag(64, hintContentIntentLaunchesActivity);
            return this;
        }

        public boolean getHintContentIntentLaunchesActivity() {
            return (this.mFlags & 0x40) != 0;
        }

        public WearableExtender setDismissalId(String dismissalId) {
            this.mDismissalId = dismissalId;
            return this;
        }

        public String getDismissalId() {
            return this.mDismissalId;
        }

        public WearableExtender setBridgeTag(String bridgeTag) {
            this.mBridgeTag = bridgeTag;
            return this;
        }

        public String getBridgeTag() {
            return this.mBridgeTag;
        }

        private void setFlag(int mask, boolean value) {
            this.mFlags = value ? (this.mFlags |= mask) : (this.mFlags &= ~mask);
        }
    }

    public static interface Extender {
        public Builder extend(Builder var1);
    }

    public static class BubbleMetadata
    implements Parcelable {
        private PendingIntent mPendingIntent;
        private PendingIntent mDeleteIntent;
        private Icon mIcon;
        private int mDesiredHeight;
        private int mDesiredHeightResId;
        private int mFlags;
        private String mShortcutId;
        public static final int FLAG_AUTO_EXPAND_BUBBLE = 1;
        public static final int FLAG_SUPPRESS_NOTIFICATION = 2;
        public static final int FLAG_SUPPRESSABLE_BUBBLE = 4;
        public static final int FLAG_SUPPRESS_BUBBLE = 8;
        public static final Parcelable.Creator<BubbleMetadata> CREATOR = new Parcelable.Creator<BubbleMetadata>(){

            @Override
            public BubbleMetadata createFromParcel(Parcel source) {
                return new BubbleMetadata(source);
            }

            public BubbleMetadata[] newArray(int size) {
                return new BubbleMetadata[size];
            }
        };

        private BubbleMetadata(PendingIntent expandIntent, PendingIntent deleteIntent, Icon icon, int height, int heightResId, String shortcutId) {
            this.mPendingIntent = expandIntent;
            this.mIcon = icon;
            this.mDesiredHeight = height;
            this.mDesiredHeightResId = heightResId;
            this.mDeleteIntent = deleteIntent;
            this.mShortcutId = shortcutId;
        }

        private BubbleMetadata(Parcel in) {
            if (in.readInt() != 0) {
                this.mPendingIntent = PendingIntent.CREATOR.createFromParcel(in);
            }
            if (in.readInt() != 0) {
                this.mIcon = Icon.CREATOR.createFromParcel(in);
            }
            this.mDesiredHeight = in.readInt();
            this.mFlags = in.readInt();
            if (in.readInt() != 0) {
                this.mDeleteIntent = PendingIntent.CREATOR.createFromParcel(in);
            }
            this.mDesiredHeightResId = in.readInt();
            if (in.readInt() != 0) {
                this.mShortcutId = in.readString8();
            }
        }

        public String getShortcutId() {
            return this.mShortcutId;
        }

        @SuppressLint(value={"InvalidNullConversion"})
        public PendingIntent getIntent() {
            return this.mPendingIntent;
        }

        @Deprecated
        public PendingIntent getBubbleIntent() {
            return this.mPendingIntent;
        }

        public PendingIntent getDeleteIntent() {
            return this.mDeleteIntent;
        }

        @SuppressLint(value={"InvalidNullConversion"})
        public Icon getIcon() {
            return this.mIcon;
        }

        @Deprecated
        public Icon getBubbleIcon() {
            return this.mIcon;
        }

        public int getDesiredHeight() {
            return this.mDesiredHeight;
        }

        public int getDesiredHeightResId() {
            return this.mDesiredHeightResId;
        }

        public boolean getAutoExpandBubble() {
            return (this.mFlags & 1) != 0;
        }

        public boolean isNotificationSuppressed() {
            return (this.mFlags & 2) != 0;
        }

        public boolean isBubbleSuppressable() {
            return (this.mFlags & 4) != 0;
        }

        public boolean isBubbleSuppressed() {
            return (this.mFlags & 8) != 0;
        }

        public void setSuppressNotification(boolean suppressed) {
            this.mFlags = suppressed ? (this.mFlags |= 2) : (this.mFlags &= 0xFFFFFFFD);
        }

        public void setSuppressBubble(boolean suppressed) {
            this.mFlags = suppressed ? (this.mFlags |= 8) : (this.mFlags &= 0xFFFFFFF7);
        }

        public void setFlags(int flags) {
            this.mFlags = flags;
        }

        public int getFlags() {
            return this.mFlags;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(this.mPendingIntent != null ? 1 : 0);
            if (this.mPendingIntent != null) {
                this.mPendingIntent.writeToParcel(out, 0);
            }
            out.writeInt(this.mIcon != null ? 1 : 0);
            if (this.mIcon != null) {
                this.mIcon.writeToParcel(out, 0);
            }
            out.writeInt(this.mDesiredHeight);
            out.writeInt(this.mFlags);
            out.writeInt(this.mDeleteIntent != null ? 1 : 0);
            if (this.mDeleteIntent != null) {
                this.mDeleteIntent.writeToParcel(out, 0);
            }
            out.writeInt(this.mDesiredHeightResId);
            out.writeInt(TextUtils.isEmpty(this.mShortcutId) ? 0 : 1);
            if (!TextUtils.isEmpty(this.mShortcutId)) {
                out.writeString8(this.mShortcutId);
            }
        }

        public static class Builder {
            private PendingIntent mPendingIntent;
            private Icon mIcon;
            private int mDesiredHeight;
            private int mDesiredHeightResId;
            private int mFlags;
            private PendingIntent mDeleteIntent;
            private String mShortcutId;

            @Deprecated
            public Builder() {
            }

            public Builder(String shortcutId) {
                if (TextUtils.isEmpty(shortcutId)) {
                    throw new NullPointerException("Bubble requires a non-null shortcut id");
                }
                this.mShortcutId = shortcutId;
            }

            public Builder(PendingIntent intent, Icon icon) {
                if (intent == null) {
                    throw new NullPointerException("Bubble requires non-null pending intent");
                }
                if (icon == null) {
                    throw new NullPointerException("Bubbles require non-null icon");
                }
                if (icon.getType() != 6 && icon.getType() != 4) {
                    Log.w(Notification.TAG, "Bubbles work best with icons of TYPE_URI or TYPE_URI_ADAPTIVE_BITMAP. In the future, using an icon of this type will be required.");
                }
                this.mPendingIntent = intent;
                this.mIcon = icon;
            }

            @Deprecated
            public Builder createShortcutBubble(String shortcutId) {
                if (!TextUtils.isEmpty(shortcutId)) {
                    this.mPendingIntent = null;
                    this.mIcon = null;
                }
                this.mShortcutId = shortcutId;
                return this;
            }

            @Deprecated
            public Builder createIntentBubble(PendingIntent intent, Icon icon) {
                if (intent == null) {
                    throw new IllegalArgumentException("Bubble requires non-null pending intent");
                }
                if (icon == null) {
                    throw new IllegalArgumentException("Bubbles require non-null icon");
                }
                if (icon.getType() != 6 && icon.getType() != 4) {
                    Log.w(Notification.TAG, "Bubbles work best with icons of TYPE_URI or TYPE_URI_ADAPTIVE_BITMAP. In the future, using an icon of this type will be required.");
                }
                this.mShortcutId = null;
                this.mPendingIntent = intent;
                this.mIcon = icon;
                return this;
            }

            public Builder setIntent(PendingIntent intent) {
                if (this.mShortcutId != null) {
                    throw new IllegalStateException("Created as a shortcut bubble, cannot set a PendingIntent. Consider using BubbleMetadata.Builder(PendingIntent,Icon) instead.");
                }
                if (intent == null) {
                    throw new NullPointerException("Bubble requires non-null pending intent");
                }
                this.mPendingIntent = intent;
                return this;
            }

            public Builder setIcon(Icon icon) {
                if (this.mShortcutId != null) {
                    throw new IllegalStateException("Created as a shortcut bubble, cannot set an Icon. Consider using BubbleMetadata.Builder(PendingIntent,Icon) instead.");
                }
                if (icon == null) {
                    throw new NullPointerException("Bubbles require non-null icon");
                }
                if (icon.getType() != 6 && icon.getType() != 4) {
                    Log.w(Notification.TAG, "Bubbles work best with icons of TYPE_URI or TYPE_URI_ADAPTIVE_BITMAP. In the future, using an icon of this type will be required.");
                }
                this.mIcon = icon;
                return this;
            }

            public Builder setDesiredHeight(int height) {
                this.mDesiredHeight = Math.max(height, 0);
                this.mDesiredHeightResId = 0;
                return this;
            }

            public Builder setDesiredHeightResId(int heightResId) {
                this.mDesiredHeightResId = heightResId;
                this.mDesiredHeight = 0;
                return this;
            }

            public Builder setAutoExpandBubble(boolean shouldExpand) {
                this.setFlag(1, shouldExpand);
                return this;
            }

            public Builder setSuppressNotification(boolean shouldSuppressNotif) {
                this.setFlag(2, shouldSuppressNotif);
                return this;
            }

            public Builder setSuppressableBubble(boolean suppressBubble) {
                this.setFlag(4, suppressBubble);
                return this;
            }

            public Builder setDeleteIntent(PendingIntent deleteIntent) {
                this.mDeleteIntent = deleteIntent;
                return this;
            }

            public BubbleMetadata build() {
                if (this.mShortcutId == null && this.mPendingIntent == null) {
                    throw new NullPointerException("Must supply pending intent or shortcut to bubble");
                }
                if (this.mShortcutId == null && this.mIcon == null) {
                    throw new NullPointerException("Must supply an icon or shortcut for the bubble");
                }
                BubbleMetadata data = new BubbleMetadata(this.mPendingIntent, this.mDeleteIntent, this.mIcon, this.mDesiredHeight, this.mDesiredHeightResId, this.mShortcutId);
                data.setFlags(this.mFlags);
                return data;
            }

            public Builder setFlag(int mask, boolean value) {
                this.mFlags = value ? (this.mFlags |= mask) : (this.mFlags &= ~mask);
                return this;
            }
        }
    }

    public static class DecoratedMediaCustomViewStyle
    extends MediaStyle {
        @Override
        public boolean displayCustomViewInline() {
            return true;
        }

        @Override
        public RemoteViews makeContentView(boolean increasedHeight) {
            return this.makeMediaContentView(this.mBuilder.mN.contentView);
        }

        @Override
        public RemoteViews makeBigContentView() {
            RemoteViews customContent = this.mBuilder.mN.bigContentView != null ? this.mBuilder.mN.bigContentView : this.mBuilder.mN.contentView;
            return this.makeMediaBigContentView(customContent);
        }

        @Override
        public RemoteViews makeHeadsUpContentView(boolean increasedHeight) {
            RemoteViews customContent = this.mBuilder.mN.headsUpContentView != null ? this.mBuilder.mN.headsUpContentView : this.mBuilder.mN.contentView;
            return this.makeMediaBigContentView(customContent);
        }

        @Override
        public boolean areNotificationsVisiblyDifferent(Style other) {
            return other == null || this.getClass() != other.getClass();
        }
    }

    public static class DecoratedCustomViewStyle
    extends Style {
        @Override
        public boolean displayCustomViewInline() {
            return true;
        }

        @Override
        public RemoteViews makeContentView(boolean increasedHeight) {
            return this.makeStandardTemplateWithCustomContent(this.mBuilder.mN.contentView);
        }

        @Override
        public RemoteViews makeBigContentView() {
            return this.makeDecoratedBigContentView();
        }

        @Override
        public RemoteViews makeHeadsUpContentView(boolean increasedHeight) {
            return this.makeDecoratedHeadsUpContentView();
        }

        private RemoteViews makeDecoratedHeadsUpContentView() {
            RemoteViews headsUpContentView;
            RemoteViews remoteViews = headsUpContentView = this.mBuilder.mN.headsUpContentView == null ? this.mBuilder.mN.contentView : this.mBuilder.mN.headsUpContentView;
            if (headsUpContentView == null) {
                return null;
            }
            if (this.mBuilder.mActions.size() == 0) {
                return this.makeStandardTemplateWithCustomContent(headsUpContentView);
            }
            TemplateBindResult result = new TemplateBindResult();
            StandardTemplateParams p = this.mBuilder.mParams.reset().viewType(StandardTemplateParams.VIEW_TYPE_HEADS_UP).decorationType(2).fillTextsFrom(this.mBuilder);
            RemoteViews remoteViews2 = this.mBuilder.applyStandardTemplateWithActions(this.mBuilder.getHeadsUpBaseLayoutResource(), p, result);
            Notification.buildCustomContentIntoTemplate(this.mBuilder.mContext, remoteViews2, headsUpContentView, p, result);
            return remoteViews2;
        }

        private RemoteViews makeStandardTemplateWithCustomContent(RemoteViews customContent) {
            if (customContent == null) {
                return null;
            }
            TemplateBindResult result = new TemplateBindResult();
            StandardTemplateParams p = this.mBuilder.mParams.reset().viewType(StandardTemplateParams.VIEW_TYPE_NORMAL).decorationType(2).fillTextsFrom(this.mBuilder);
            RemoteViews remoteViews = this.mBuilder.applyStandardTemplate(this.mBuilder.getBaseLayoutResource(), p, result);
            Notification.buildCustomContentIntoTemplate(this.mBuilder.mContext, remoteViews, customContent, p, result);
            return remoteViews;
        }

        private RemoteViews makeDecoratedBigContentView() {
            RemoteViews bigContentView;
            RemoteViews remoteViews = bigContentView = this.mBuilder.mN.bigContentView == null ? this.mBuilder.mN.contentView : this.mBuilder.mN.bigContentView;
            if (bigContentView == null) {
                return null;
            }
            TemplateBindResult result = new TemplateBindResult();
            StandardTemplateParams p = this.mBuilder.mParams.reset().viewType(StandardTemplateParams.VIEW_TYPE_BIG).decorationType(2).fillTextsFrom(this.mBuilder);
            RemoteViews remoteViews2 = this.mBuilder.applyStandardTemplateWithActions(this.mBuilder.getBigBaseLayoutResource(), p, result);
            Notification.buildCustomContentIntoTemplate(this.mBuilder.mContext, remoteViews2, bigContentView, p, result);
            return remoteViews2;
        }

        @Override
        public boolean areNotificationsVisiblyDifferent(Style other) {
            return other == null || this.getClass() != other.getClass();
        }
    }

    public static class CallStyle
    extends Style {
        public static final int CALL_TYPE_INCOMING = 1;
        public static final int CALL_TYPE_ONGOING = 2;
        public static final int CALL_TYPE_SCREENING = 3;
        private static final String KEY_ACTION_PRIORITY = "key_action_priority";
        private int mCallType;
        private Person mPerson;
        private PendingIntent mAnswerIntent;
        private PendingIntent mDeclineIntent;
        private PendingIntent mHangUpIntent;
        private boolean mIsVideo;
        private Integer mAnswerButtonColor;
        private Integer mDeclineButtonColor;
        private Icon mVerificationIcon;
        private CharSequence mVerificationText;

        CallStyle() {
        }

        public static CallStyle forIncomingCall(Person person, PendingIntent declineIntent, PendingIntent answerIntent) {
            return new CallStyle(1, person, null, Objects.requireNonNull(declineIntent, "declineIntent is required"), Objects.requireNonNull(answerIntent, "answerIntent is required"));
        }

        public static CallStyle forOngoingCall(Person person, PendingIntent hangUpIntent) {
            return new CallStyle(2, person, Objects.requireNonNull(hangUpIntent, "hangUpIntent is required"), null, null);
        }

        public static CallStyle forScreeningCall(Person person, PendingIntent hangUpIntent, PendingIntent answerIntent) {
            return new CallStyle(3, person, Objects.requireNonNull(hangUpIntent, "hangUpIntent is required"), null, Objects.requireNonNull(answerIntent, "answerIntent is required"));
        }

        private CallStyle(int callType, Person person, PendingIntent hangUpIntent, PendingIntent declineIntent, PendingIntent answerIntent) {
            if (person == null || TextUtils.isEmpty(person.getName())) {
                throw new IllegalArgumentException("person must have a non-empty a name");
            }
            this.mCallType = callType;
            this.mPerson = person;
            this.mAnswerIntent = answerIntent;
            this.mDeclineIntent = declineIntent;
            this.mHangUpIntent = hangUpIntent;
        }

        public CallStyle setIsVideo(boolean isVideo) {
            this.mIsVideo = isVideo;
            return this;
        }

        public CallStyle setVerificationIcon(Icon verificationIcon) {
            this.mVerificationIcon = verificationIcon;
            return this;
        }

        public CallStyle setVerificationText(CharSequence verificationText) {
            this.mVerificationText = Notification.safeCharSequence(verificationText);
            return this;
        }

        public CallStyle setAnswerButtonColorHint(int color2) {
            this.mAnswerButtonColor = color2;
            return this;
        }

        public CallStyle setDeclineButtonColorHint(int color2) {
            this.mDeclineButtonColor = color2;
            return this;
        }

        @Override
        public Notification buildStyled(Notification wip) {
            wip = super.buildStyled(wip);
            this.mBuilder.mActions = this.getActionsListWithSystemActions();
            wip.actions = new Action[this.mBuilder.mActions.size()];
            this.mBuilder.mActions.toArray(wip.actions);
            return wip;
        }

        @Override
        public boolean displayCustomViewInline() {
            return true;
        }

        @Override
        public void purgeResources() {
            super.purgeResources();
            if (this.mVerificationIcon != null) {
                this.mVerificationIcon.convertToAshmem();
            }
        }

        @Override
        public void reduceImageSizes(Context context) {
            super.reduceImageSizes(context);
            if (this.mVerificationIcon != null) {
                int rightIconSize = context.getResources().getDimensionPixelSize(ActivityManager.isLowRamDeviceStatic() ? 17105430 : 17105429);
                this.mVerificationIcon.scaleDownIfNecessary(rightIconSize, rightIconSize);
            }
        }

        @Override
        public RemoteViews makeContentView(boolean increasedHeight) {
            return this.makeCallLayout(StandardTemplateParams.VIEW_TYPE_NORMAL);
        }

        @Override
        public RemoteViews makeHeadsUpContentView(boolean increasedHeight) {
            return this.makeCallLayout(StandardTemplateParams.VIEW_TYPE_HEADS_UP);
        }

        @Override
        public RemoteViews makeBigContentView() {
            return this.makeCallLayout(StandardTemplateParams.VIEW_TYPE_BIG);
        }

        private Action makeNegativeAction() {
            if (this.mDeclineIntent == null) {
                return this.makeAction(17302359, 17039831, this.mDeclineButtonColor, 17170608, this.mHangUpIntent);
            }
            return this.makeAction(17302359, 17039830, this.mDeclineButtonColor, 17170608, this.mDeclineIntent);
        }

        private Action makeAnswerAction() {
            return this.mAnswerIntent == null ? null : this.makeAction(this.mIsVideo ? 17302358 : 17302357, this.mIsVideo ? 17039829 : 17039828, this.mAnswerButtonColor, 17170607, this.mAnswerIntent);
        }

        private Action makeAction(int icon, int title, Integer colorInt, int defaultColorRes, PendingIntent intent) {
            if (colorInt == null || !this.mBuilder.isCallActionColorCustomizable()) {
                colorInt = this.mBuilder.mContext.getColor(defaultColorRes);
            }
            Action action = new Action.Builder(Icon.createWithResource("", icon), (CharSequence)new SpannableStringBuilder().append((CharSequence)this.mBuilder.mContext.getString(title), new ForegroundColorSpan(colorInt), 18), intent).build();
            action.getExtras().putBoolean(KEY_ACTION_PRIORITY, true);
            return action;
        }

        private boolean isActionAddedByCallStyle(Action action) {
            return action != null && action.getExtras().getBoolean(KEY_ACTION_PRIORITY);
        }

        public ArrayList<Action> getActionsListWithSystemActions() {
            Action negativeAction = this.makeNegativeAction();
            Action answerAction = this.makeAnswerAction();
            Action firstAction = answerAction == null ? null : negativeAction;
            Action lastAction = answerAction == null ? negativeAction : answerAction;
            int nonContextualActionSlotsRemaining = 3;
            ArrayList<Action> resultActions = new ArrayList<Action>(3);
            if (firstAction != null) {
                resultActions.add(firstAction);
                --nonContextualActionSlotsRemaining;
            }
            if (this.mBuilder.mActions != null) {
                for (Action action : this.mBuilder.mActions) {
                    if (action.isContextual()) {
                        resultActions.add(action);
                    } else if (!this.isActionAddedByCallStyle(action)) {
                        resultActions.add(action);
                        --nonContextualActionSlotsRemaining;
                    }
                    if (nonContextualActionSlotsRemaining != 1) continue;
                    resultActions.add(lastAction);
                    --nonContextualActionSlotsRemaining;
                }
            }
            if (nonContextualActionSlotsRemaining >= 1) {
                resultActions.add(lastAction);
            }
            return resultActions;
        }

        private RemoteViews makeCallLayout(int viewType) {
            boolean isCollapsed = viewType == StandardTemplateParams.VIEW_TYPE_NORMAL;
            Bundle extras = this.mBuilder.mN.extras;
            CharSequence title = this.mPerson != null ? this.mPerson.getName() : null;
            CharSequence text = this.mBuilder.processLegacyText(extras.getCharSequence(Notification.EXTRA_TEXT));
            if (text == null) {
                text = this.getDefaultText();
            }
            StandardTemplateParams p = this.mBuilder.mParams.reset().viewType(viewType).callStyleActions(true).allowTextWithProgress(true).hideLeftIcon(true).hideRightIcon(true).hideAppName(isCollapsed).titleViewId(16908929).title(title).text(text).summaryText(this.mBuilder.processLegacyText(this.mVerificationText));
            this.mBuilder.mActions = this.getActionsListWithSystemActions();
            RemoteViews contentView = isCollapsed ? this.mBuilder.applyStandardTemplate(17367228, p, null) : this.mBuilder.applyStandardTemplateWithActions(17367223, p, null);
            if (!p.mHideAppName) {
                this.mBuilder.setTextViewColorSecondary(contentView, 16908783, p);
                contentView.setViewVisibility(16908783, 0);
            }
            this.bindCallerVerification(contentView, p);
            contentView.setInt(16909547, "setLayoutColor", this.mBuilder.getSmallIconColor(p));
            contentView.setInt(16909547, "setNotificationBackgroundColor", this.mBuilder.getBackgroundColor(p));
            contentView.setIcon(16909547, "setLargeIcon", this.mBuilder.mN.mLargeIcon);
            contentView.setBundle(16909547, "setData", this.mBuilder.mN.extras);
            return contentView;
        }

        private void bindCallerVerification(RemoteViews contentView, StandardTemplateParams p) {
            String iconContentDescription = null;
            boolean showDivider = true;
            if (this.mVerificationIcon != null) {
                contentView.setImageViewIcon(16909691, this.mVerificationIcon);
                contentView.setDrawableTint(16909691, false, this.mBuilder.getSecondaryTextColor(p), PorterDuff.Mode.SRC_ATOP);
                contentView.setViewVisibility(16909691, 0);
                iconContentDescription = this.mBuilder.mContext.getString(17040926);
                showDivider = false;
            } else {
                contentView.setViewVisibility(16909691, 8);
            }
            if (!TextUtils.isEmpty(this.mVerificationText)) {
                contentView.setTextViewText(16909692, this.mVerificationText);
                this.mBuilder.setTextViewColorSecondary(contentView, 16909692, p);
                contentView.setViewVisibility(16909692, 0);
                iconContentDescription = null;
            } else {
                contentView.setViewVisibility(16909692, 8);
                showDivider = false;
            }
            contentView.setContentDescription(16909691, iconContentDescription);
            if (showDivider) {
                contentView.setViewVisibility(16909690, 0);
                this.mBuilder.setTextViewColorSecondary(contentView, 16909690, p);
            } else {
                contentView.setViewVisibility(16909690, 8);
            }
        }

        private String getDefaultText() {
            switch (this.mCallType) {
                case 1: {
                    return this.mBuilder.mContext.getString(17039832);
                }
                case 2: {
                    return this.mBuilder.mContext.getString(17039833);
                }
                case 3: {
                    return this.mBuilder.mContext.getString(17039834);
                }
            }
            return null;
        }

        @Override
        public void addExtras(Bundle extras) {
            super.addExtras(extras);
            extras.putInt(Notification.EXTRA_CALL_TYPE, this.mCallType);
            extras.putBoolean(Notification.EXTRA_CALL_IS_VIDEO, this.mIsVideo);
            extras.putParcelable(Notification.EXTRA_CALL_PERSON, this.mPerson);
            if (this.mVerificationIcon != null) {
                extras.putParcelable(Notification.EXTRA_VERIFICATION_ICON, this.mVerificationIcon);
            }
            if (this.mVerificationText != null) {
                extras.putCharSequence(Notification.EXTRA_VERIFICATION_TEXT, this.mVerificationText);
            }
            if (this.mAnswerIntent != null) {
                extras.putParcelable(Notification.EXTRA_ANSWER_INTENT, this.mAnswerIntent);
            }
            if (this.mDeclineIntent != null) {
                extras.putParcelable(Notification.EXTRA_DECLINE_INTENT, this.mDeclineIntent);
            }
            if (this.mHangUpIntent != null) {
                extras.putParcelable(Notification.EXTRA_HANG_UP_INTENT, this.mHangUpIntent);
            }
            if (this.mAnswerButtonColor != null) {
                extras.putInt(Notification.EXTRA_ANSWER_COLOR, this.mAnswerButtonColor);
            }
            if (this.mDeclineButtonColor != null) {
                extras.putInt(Notification.EXTRA_DECLINE_COLOR, this.mDeclineButtonColor);
            }
            this.fixTitleAndTextExtras(extras);
        }

        private void fixTitleAndTextExtras(Bundle extras) {
            CharSequence sender;
            CharSequence charSequence = sender = this.mPerson != null ? this.mPerson.getName() : null;
            if (sender != null) {
                extras.putCharSequence(Notification.EXTRA_TITLE, sender);
            }
            if (extras.getCharSequence(Notification.EXTRA_TEXT) == null) {
                extras.putCharSequence(Notification.EXTRA_TEXT, this.getDefaultText());
            }
        }

        @Override
        protected void restoreFromExtras(Bundle extras) {
            super.restoreFromExtras(extras);
            this.mCallType = extras.getInt(Notification.EXTRA_CALL_TYPE);
            this.mIsVideo = extras.getBoolean(Notification.EXTRA_CALL_IS_VIDEO);
            this.mPerson = extras.getParcelable(Notification.EXTRA_CALL_PERSON, Person.class);
            this.mVerificationIcon = (Icon)extras.getParcelable(Notification.EXTRA_VERIFICATION_ICON);
            this.mVerificationText = extras.getCharSequence(Notification.EXTRA_VERIFICATION_TEXT);
            this.mAnswerIntent = extras.getParcelable(Notification.EXTRA_ANSWER_INTENT, PendingIntent.class);
            this.mDeclineIntent = extras.getParcelable(Notification.EXTRA_DECLINE_INTENT, PendingIntent.class);
            this.mHangUpIntent = extras.getParcelable(Notification.EXTRA_HANG_UP_INTENT, PendingIntent.class);
            this.mAnswerButtonColor = extras.containsKey(Notification.EXTRA_ANSWER_COLOR) ? Integer.valueOf(extras.getInt(Notification.EXTRA_ANSWER_COLOR)) : null;
            this.mDeclineButtonColor = extras.containsKey(Notification.EXTRA_DECLINE_COLOR) ? Integer.valueOf(extras.getInt(Notification.EXTRA_DECLINE_COLOR)) : null;
        }

        @Override
        public boolean hasSummaryInHeader() {
            return false;
        }

        @Override
        public boolean areNotificationsVisiblyDifferent(Style other) {
            if (other == null || this.getClass() != other.getClass()) {
                return true;
            }
            CallStyle otherS = (CallStyle)other;
            return !Objects.equals(this.mCallType, otherS.mCallType) || !Objects.equals(this.mPerson, otherS.mPerson) || !Objects.equals(this.mVerificationText, otherS.mVerificationText);
        }
    }

    public static class MediaStyle
    extends Style {
        static final int MAX_MEDIA_BUTTONS_IN_COMPACT = 3;
        static final int MAX_MEDIA_BUTTONS = 5;
        private static final int[] MEDIA_BUTTON_IDS = new int[]{16908718, 16908719, 16908720, 16908721, 16908722};
        private int[] mActionsToShowInCompact = null;
        private MediaSession.Token mToken;
        private CharSequence mDeviceName;
        private int mDeviceIcon;
        private PendingIntent mDeviceIntent;

        public MediaStyle() {
        }

        @Deprecated
        public MediaStyle(Builder builder) {
            this.setBuilder(builder);
        }

        public MediaStyle setShowActionsInCompactView(int ... actions) {
            this.mActionsToShowInCompact = actions;
            return this;
        }

        public MediaStyle setMediaSession(MediaSession.Token token) {
            this.mToken = token;
            return this;
        }

        @SystemApi
        @RequiresPermission(value="android.permission.MEDIA_CONTENT_CONTROL")
        public MediaStyle setRemotePlaybackInfo(CharSequence deviceName, int iconResource, PendingIntent chipIntent) {
            this.mDeviceName = deviceName;
            this.mDeviceIcon = iconResource;
            this.mDeviceIntent = chipIntent;
            return this;
        }

        @Override
        @UnsupportedAppUsage
        public Notification buildStyled(Notification wip) {
            super.buildStyled(wip);
            if (wip.category == null) {
                wip.category = Notification.CATEGORY_TRANSPORT;
            }
            return wip;
        }

        @Override
        public RemoteViews makeContentView(boolean increasedHeight) {
            return this.makeMediaContentView(null);
        }

        @Override
        public RemoteViews makeBigContentView() {
            return this.makeMediaBigContentView(null);
        }

        @Override
        public RemoteViews makeHeadsUpContentView(boolean increasedHeight) {
            return this.makeMediaContentView(null);
        }

        @Override
        public void addExtras(Bundle extras) {
            super.addExtras(extras);
            if (this.mToken != null) {
                extras.putParcelable(Notification.EXTRA_MEDIA_SESSION, this.mToken);
            }
            if (this.mActionsToShowInCompact != null) {
                extras.putIntArray(Notification.EXTRA_COMPACT_ACTIONS, this.mActionsToShowInCompact);
            }
            if (this.mDeviceName != null) {
                extras.putCharSequence(Notification.EXTRA_MEDIA_REMOTE_DEVICE, this.mDeviceName);
            }
            if (this.mDeviceIcon > 0) {
                extras.putInt(Notification.EXTRA_MEDIA_REMOTE_ICON, this.mDeviceIcon);
            }
            if (this.mDeviceIntent != null) {
                extras.putParcelable(Notification.EXTRA_MEDIA_REMOTE_INTENT, this.mDeviceIntent);
            }
        }

        @Override
        protected void restoreFromExtras(Bundle extras) {
            super.restoreFromExtras(extras);
            if (extras.containsKey(Notification.EXTRA_MEDIA_SESSION)) {
                this.mToken = extras.getParcelable(Notification.EXTRA_MEDIA_SESSION, MediaSession.Token.class);
            }
            if (extras.containsKey(Notification.EXTRA_COMPACT_ACTIONS)) {
                this.mActionsToShowInCompact = extras.getIntArray(Notification.EXTRA_COMPACT_ACTIONS);
            }
            if (extras.containsKey(Notification.EXTRA_MEDIA_REMOTE_DEVICE)) {
                this.mDeviceName = extras.getCharSequence(Notification.EXTRA_MEDIA_REMOTE_DEVICE);
            }
            if (extras.containsKey(Notification.EXTRA_MEDIA_REMOTE_ICON)) {
                this.mDeviceIcon = extras.getInt(Notification.EXTRA_MEDIA_REMOTE_ICON);
            }
            if (extras.containsKey(Notification.EXTRA_MEDIA_REMOTE_INTENT)) {
                this.mDeviceIntent = extras.getParcelable(Notification.EXTRA_MEDIA_REMOTE_INTENT, PendingIntent.class);
            }
        }

        @Override
        public boolean areNotificationsVisiblyDifferent(Style other) {
            return other == null || this.getClass() != other.getClass();
        }

        private void bindMediaActionButton(RemoteViews container, int buttonId, Action action, StandardTemplateParams p) {
            boolean tombstone = action.actionIntent == null;
            container.setViewVisibility(buttonId, 0);
            container.setImageViewIcon(buttonId, action.getIcon());
            int tintColor = this.mBuilder.getStandardActionColor(p);
            container.setDrawableTint(buttonId, false, tintColor, PorterDuff.Mode.SRC_ATOP);
            int rippleAlpha = this.mBuilder.getColors(p).getRippleAlpha();
            int rippleColor = Color.argb(rippleAlpha, Color.red(tintColor), Color.green(tintColor), Color.blue(tintColor));
            container.setRippleDrawableColor(buttonId, ColorStateList.valueOf(rippleColor));
            if (!tombstone) {
                container.setOnClickPendingIntent(buttonId, action.actionIntent);
            }
            container.setContentDescription(buttonId, action.title);
        }

        protected RemoteViews makeMediaContentView(RemoteViews customContent) {
            int numActions = this.mBuilder.mActions.size();
            int numActionsToShow = Math.min(this.mActionsToShowInCompact == null ? 0 : this.mActionsToShowInCompact.length, 3);
            if (numActionsToShow > numActions) {
                throw new IllegalArgumentException(String.format("setShowActionsInCompactView: action %d out of bounds (max %d)", numActions, numActions - 1));
            }
            StandardTemplateParams p = this.mBuilder.mParams.reset().viewType(StandardTemplateParams.VIEW_TYPE_NORMAL).hideTime(numActionsToShow > 1).hideSubText(numActionsToShow > 1).hideLeftIcon(false).hideRightIcon(numActionsToShow > 0).hideProgress(true).fillTextsFrom(this.mBuilder);
            TemplateBindResult result = new TemplateBindResult();
            RemoteViews template = this.mBuilder.applyStandardTemplate(17367232, p, null);
            for (int i = 0; i < 3; ++i) {
                if (i < numActionsToShow) {
                    Action action = this.mBuilder.mActions.get(this.mActionsToShowInCompact[i]);
                    this.bindMediaActionButton(template, MEDIA_BUTTON_IDS[i], action, p);
                    continue;
                }
                template.setViewVisibility(MEDIA_BUTTON_IDS[i], 8);
            }
            boolean hasActions = numActionsToShow != 0;
            template.setViewVisibility(16909212, hasActions ? 0 : 8);
            Notification.buildCustomContentIntoTemplate(this.mBuilder.mContext, template, customContent, p, result);
            return template;
        }

        protected RemoteViews makeMediaBigContentView(RemoteViews customContent) {
            int actionCount = Math.min(this.mBuilder.mActions.size(), 5);
            StandardTemplateParams p = this.mBuilder.mParams.reset().viewType(StandardTemplateParams.VIEW_TYPE_BIG).hideProgress(true).fillTextsFrom(this.mBuilder);
            TemplateBindResult result = new TemplateBindResult();
            RemoteViews template = this.mBuilder.applyStandardTemplate(17367224, p, result);
            for (int i = 0; i < 5; ++i) {
                if (i < actionCount) {
                    this.bindMediaActionButton(template, MEDIA_BUTTON_IDS[i], this.mBuilder.mActions.get(i), p);
                    continue;
                }
                template.setViewVisibility(MEDIA_BUTTON_IDS[i], 8);
            }
            Notification.buildCustomContentIntoTemplate(this.mBuilder.mContext, template, customContent, p, result);
            return template;
        }
    }

    public static class InboxStyle
    extends Style {
        private static final int NUMBER_OF_HISTORY_ALLOWED_UNTIL_REDUCTION = 1;
        private ArrayList<CharSequence> mTexts = new ArrayList(5);

        public InboxStyle() {
        }

        @Deprecated
        public InboxStyle(Builder builder) {
            this.setBuilder(builder);
        }

        public InboxStyle setBigContentTitle(CharSequence title) {
            this.internalSetBigContentTitle(Notification.safeCharSequence(title));
            return this;
        }

        public InboxStyle setSummaryText(CharSequence cs) {
            this.internalSetSummaryText(Notification.safeCharSequence(cs));
            return this;
        }

        public InboxStyle addLine(CharSequence cs) {
            this.mTexts.add(Notification.safeCharSequence(cs));
            return this;
        }

        public ArrayList<CharSequence> getLines() {
            return this.mTexts;
        }

        @Override
        public void addExtras(Bundle extras) {
            super.addExtras(extras);
            CharSequence[] a = new CharSequence[this.mTexts.size()];
            extras.putCharSequenceArray(Notification.EXTRA_TEXT_LINES, this.mTexts.toArray(a));
        }

        @Override
        protected void restoreFromExtras(Bundle extras) {
            super.restoreFromExtras(extras);
            this.mTexts.clear();
            if (extras.containsKey(Notification.EXTRA_TEXT_LINES)) {
                Collections.addAll(this.mTexts, extras.getCharSequenceArray(Notification.EXTRA_TEXT_LINES));
            }
        }

        @Override
        public RemoteViews makeBigContentView() {
            RemoteInputHistoryItem[] remoteInputHistory;
            int[] rowIds;
            StandardTemplateParams p = this.mBuilder.mParams.reset().viewType(StandardTemplateParams.VIEW_TYPE_BIG).fillTextsFrom(this.mBuilder).text(null);
            TemplateBindResult result = new TemplateBindResult();
            RemoteViews contentView = this.getStandardView(this.mBuilder.getInboxLayoutResource(), p, result);
            for (int rowId : rowIds = new int[]{16909105, 16909106, 16909107, 16909108, 16909109, 16909110, 16909111}) {
                contentView.setViewVisibility(rowId, 8);
            }
            int i = 0;
            int topPadding = this.mBuilder.mContext.getResources().getDimensionPixelSize(17105415);
            boolean first = true;
            int onlyViewId = 0;
            int maxRows = rowIds.length;
            if (this.mBuilder.mActions.size() > 0) {
                --maxRows;
            }
            if ((remoteInputHistory = (RemoteInputHistoryItem[])Notification.getParcelableArrayFromBundle((Bundle)this.mBuilder.mN.extras, (String)Notification.EXTRA_REMOTE_INPUT_HISTORY_ITEMS, RemoteInputHistoryItem.class)) != null && remoteInputHistory.length > 1) {
                int numRemoteInputs = Math.min(remoteInputHistory.length, 3);
                int totalNumRows = this.mTexts.size() + numRemoteInputs - 1;
                if (totalNumRows > maxRows) {
                    int overflow = totalNumRows - maxRows;
                    if (this.mTexts.size() > maxRows) {
                        maxRows -= overflow;
                    } else {
                        i = overflow;
                    }
                }
            }
            while (i < this.mTexts.size() && i < maxRows) {
                CharSequence str = this.mTexts.get(i);
                if (!TextUtils.isEmpty(str)) {
                    contentView.setViewVisibility(rowIds[i], 0);
                    contentView.setTextViewText(rowIds[i], this.mBuilder.processTextSpans(this.mBuilder.processLegacyText(str)));
                    this.mBuilder.setTextViewColorSecondary(contentView, rowIds[i], p);
                    contentView.setViewPadding(rowIds[i], 0, topPadding, 0, 0);
                    onlyViewId = first ? rowIds[i] : 0;
                    first = false;
                }
                ++i;
            }
            if (onlyViewId != 0) {
                topPadding = this.mBuilder.mContext.getResources().getDimensionPixelSize(17105436);
                contentView.setViewPadding(onlyViewId, 0, topPadding, 0, 0);
            }
            return contentView;
        }

        @Override
        public boolean areNotificationsVisiblyDifferent(Style other) {
            if (other == null || this.getClass() != other.getClass()) {
                return true;
            }
            InboxStyle newS = (InboxStyle)other;
            ArrayList<CharSequence> myLines = this.getLines();
            ArrayList<CharSequence> newLines = newS.getLines();
            int n = myLines.size();
            if (n != newLines.size()) {
                return true;
            }
            for (int i = 0; i < n; ++i) {
                if (Objects.equals(String.valueOf(myLines.get(i)), String.valueOf(newLines.get(i)))) continue;
                return true;
            }
            return false;
        }
    }

    public static class MessagingStyle
    extends Style {
        public static final int MAXIMUM_RETAINED_MESSAGES = 25;
        public static final int CONVERSATION_TYPE_LEGACY = 0;
        public static final int CONVERSATION_TYPE_NORMAL = 1;
        public static final int CONVERSATION_TYPE_IMPORTANT = 2;
        Person mUser;
        CharSequence mConversationTitle;
        Icon mShortcutIcon;
        List<Message> mMessages = new ArrayList<Message>();
        List<Message> mHistoricMessages = new ArrayList<Message>();
        boolean mIsGroupConversation;
        int mConversationType = 0;
        int mUnreadMessageCount;

        MessagingStyle() {
        }

        public MessagingStyle(CharSequence userDisplayName) {
            this(new Person.Builder().setName(userDisplayName).build());
        }

        public MessagingStyle(Person user) {
            this.mUser = user;
        }

        @Override
        public void validate(Context context) {
            super.validate(context);
            if (context.getApplicationInfo().targetSdkVersion >= 28 && (this.mUser == null || this.mUser.getName() == null)) {
                throw new RuntimeException("User must be valid and have a name.");
            }
        }

        @Override
        public CharSequence getHeadsUpStatusBarText() {
            CharSequence conversationTitle;
            CharSequence charSequence = conversationTitle = !TextUtils.isEmpty(this.mBigContentTitle) ? this.mBigContentTitle : this.mConversationTitle;
            if (this.mConversationType == 0 && !TextUtils.isEmpty(conversationTitle) && !this.hasOnlyWhiteSpaceSenders()) {
                return conversationTitle;
            }
            return null;
        }

        public Person getUser() {
            return this.mUser;
        }

        public CharSequence getUserDisplayName() {
            return this.mUser.getName();
        }

        public MessagingStyle setConversationTitle(CharSequence conversationTitle) {
            this.mConversationTitle = conversationTitle;
            return this;
        }

        public CharSequence getConversationTitle() {
            return this.mConversationTitle;
        }

        public MessagingStyle setShortcutIcon(Icon conversationIcon) {
            this.mShortcutIcon = conversationIcon;
            return this;
        }

        public Icon getShortcutIcon() {
            return this.mShortcutIcon;
        }

        public MessagingStyle setConversationType(int conversationType) {
            this.mConversationType = conversationType;
            return this;
        }

        public int getConversationType() {
            return this.mConversationType;
        }

        public int getUnreadMessageCount() {
            return this.mUnreadMessageCount;
        }

        public MessagingStyle setUnreadMessageCount(int unreadMessageCount) {
            this.mUnreadMessageCount = unreadMessageCount;
            return this;
        }

        public MessagingStyle addMessage(CharSequence text, long timestamp, CharSequence sender) {
            return this.addMessage(text, timestamp, sender == null ? null : new Person.Builder().setName(sender).build());
        }

        public MessagingStyle addMessage(CharSequence text, long timestamp, Person sender) {
            return this.addMessage(new Message(text, timestamp, sender));
        }

        public MessagingStyle addMessage(Message message) {
            this.mMessages.add(message);
            if (this.mMessages.size() > 25) {
                this.mMessages.remove(0);
            }
            return this;
        }

        public MessagingStyle addHistoricMessage(Message message) {
            this.mHistoricMessages.add(message);
            if (this.mHistoricMessages.size() > 25) {
                this.mHistoricMessages.remove(0);
            }
            return this;
        }

        public List<Message> getMessages() {
            return this.mMessages;
        }

        public List<Message> getHistoricMessages() {
            return this.mHistoricMessages;
        }

        public MessagingStyle setGroupConversation(boolean isGroupConversation) {
            this.mIsGroupConversation = isGroupConversation;
            return this;
        }

        public boolean isGroupConversation() {
            if (this.mBuilder != null && this.mBuilder.mContext.getApplicationInfo().targetSdkVersion < 28) {
                return this.mConversationTitle != null;
            }
            return this.mIsGroupConversation;
        }

        @Override
        public void addExtras(Bundle extras) {
            super.addExtras(extras);
            if (this.mUser != null) {
                extras.putCharSequence(Notification.EXTRA_SELF_DISPLAY_NAME, this.mUser.getName());
                extras.putParcelable(Notification.EXTRA_MESSAGING_PERSON, this.mUser);
            }
            if (this.mConversationTitle != null) {
                extras.putCharSequence(Notification.EXTRA_CONVERSATION_TITLE, this.mConversationTitle);
            }
            if (!this.mMessages.isEmpty()) {
                extras.putParcelableArray(Notification.EXTRA_MESSAGES, Message.getBundleArrayForMessages(this.mMessages));
            }
            if (!this.mHistoricMessages.isEmpty()) {
                extras.putParcelableArray(Notification.EXTRA_HISTORIC_MESSAGES, Message.getBundleArrayForMessages(this.mHistoricMessages));
            }
            if (this.mShortcutIcon != null) {
                extras.putParcelable(Notification.EXTRA_CONVERSATION_ICON, this.mShortcutIcon);
            }
            extras.putInt(Notification.EXTRA_CONVERSATION_UNREAD_MESSAGE_COUNT, this.mUnreadMessageCount);
            this.fixTitleAndTextExtras(extras);
            extras.putBoolean(Notification.EXTRA_IS_GROUP_CONVERSATION, this.mIsGroupConversation);
        }

        private void fixTitleAndTextExtras(Bundle extras) {
            CharSequence title;
            CharSequence sender;
            CharSequence text;
            Message m = this.findLatestIncomingMessage();
            CharSequence charSequence = text = m == null ? null : m.mText;
            CharSequence charSequence2 = m == null ? null : (sender = m.mSender == null || TextUtils.isEmpty(m.mSender.getName()) ? this.mUser.getName() : m.mSender.getName());
            if (!TextUtils.isEmpty(this.mConversationTitle)) {
                if (!TextUtils.isEmpty(sender)) {
                    BidiFormatter bidi = BidiFormatter.getInstance();
                    title = this.mBuilder.mContext.getString(17040919, bidi.unicodeWrap(this.mConversationTitle), bidi.unicodeWrap(sender));
                } else {
                    title = this.mConversationTitle;
                }
            } else {
                title = sender;
            }
            if (title != null) {
                extras.putCharSequence(Notification.EXTRA_TITLE, title);
            }
            if (text != null) {
                extras.putCharSequence(Notification.EXTRA_TEXT, text);
            }
        }

        @Override
        protected void restoreFromExtras(Bundle extras) {
            super.restoreFromExtras(extras);
            this.mUser = extras.getParcelable(Notification.EXTRA_MESSAGING_PERSON, Person.class);
            if (this.mUser == null) {
                CharSequence displayName = extras.getCharSequence(Notification.EXTRA_SELF_DISPLAY_NAME);
                this.mUser = new Person.Builder().setName(displayName).build();
            }
            this.mConversationTitle = extras.getCharSequence(Notification.EXTRA_CONVERSATION_TITLE);
            Parcelable[] messages = extras.getParcelableArray(Notification.EXTRA_MESSAGES);
            this.mMessages = Message.getMessagesFromBundleArray(messages);
            Parcelable[] histMessages = extras.getParcelableArray(Notification.EXTRA_HISTORIC_MESSAGES);
            this.mHistoricMessages = Message.getMessagesFromBundleArray(histMessages);
            this.mIsGroupConversation = extras.getBoolean(Notification.EXTRA_IS_GROUP_CONVERSATION);
            this.mUnreadMessageCount = extras.getInt(Notification.EXTRA_CONVERSATION_UNREAD_MESSAGE_COUNT);
            this.mShortcutIcon = extras.getParcelable(Notification.EXTRA_CONVERSATION_ICON, Icon.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RemoteViews makeContentView(boolean increasedHeight) {
            ArrayList<Action> originalActions = this.mBuilder.mActions;
            try {
                this.mBuilder.mActions = new ArrayList();
                RemoteViews remoteViews = this.makeMessagingView(StandardTemplateParams.VIEW_TYPE_NORMAL);
                return remoteViews;
            }
            finally {
                this.mBuilder.mActions = originalActions;
            }
        }

        @Override
        public boolean areNotificationsVisiblyDifferent(Style other) {
            int n;
            if (other == null || this.getClass() != other.getClass()) {
                return true;
            }
            MessagingStyle newS = (MessagingStyle)other;
            List<Message> oldMs = this.getMessages();
            List<Message> newMs = newS.getMessages();
            if (oldMs == null || newMs == null) {
                newMs = new ArrayList<Message>();
            }
            if ((n = oldMs.size()) != newMs.size()) {
                return true;
            }
            for (int i = 0; i < n; ++i) {
                String newKey;
                String newSender;
                Message oldM = oldMs.get(i);
                Message newM = newMs.get(i);
                if (!Objects.equals(String.valueOf(oldM.getText()), String.valueOf(newM.getText()))) {
                    return true;
                }
                if (!Objects.equals(oldM.getDataUri(), newM.getDataUri())) {
                    return true;
                }
                String oldSender = String.valueOf(oldM.getSenderPerson() == null ? oldM.getSender() : oldM.getSenderPerson().getName());
                if (!Objects.equals(oldSender, newSender = String.valueOf(newM.getSenderPerson() == null ? newM.getSender() : newM.getSenderPerson().getName()))) {
                    return true;
                }
                String oldKey = oldM.getSenderPerson() == null ? null : oldM.getSenderPerson().getKey();
                String string2 = newKey = newM.getSenderPerson() == null ? null : newM.getSenderPerson().getKey();
                if (Objects.equals(oldKey, newKey)) continue;
                return true;
            }
            return false;
        }

        private Message findLatestIncomingMessage() {
            return MessagingStyle.findLatestIncomingMessage(this.mMessages);
        }

        public static Message findLatestIncomingMessage(List<Message> messages) {
            for (int i = messages.size() - 1; i >= 0; --i) {
                Message m = messages.get(i);
                if (m.mSender == null || TextUtils.isEmpty(m.mSender.getName())) continue;
                return m;
            }
            if (!messages.isEmpty()) {
                return messages.get(messages.size() - 1);
            }
            return null;
        }

        @Override
        public RemoteViews makeBigContentView() {
            return this.makeMessagingView(StandardTemplateParams.VIEW_TYPE_BIG);
        }

        private RemoteViews makeMessagingView(int viewType) {
            boolean isOneToOne;
            boolean isCollapsed = viewType != StandardTemplateParams.VIEW_TYPE_BIG;
            boolean hideRightIcons = viewType != StandardTemplateParams.VIEW_TYPE_NORMAL;
            boolean isConversationLayout = this.mConversationType != 0;
            boolean isImportantConversation = this.mConversationType == 2;
            boolean isHeaderless = !isConversationLayout && isCollapsed;
            CharSequence conversationTitle = !TextUtils.isEmpty(this.mBigContentTitle) ? this.mBigContentTitle : this.mConversationTitle;
            boolean atLeastP = this.mBuilder.mContext.getApplicationInfo().targetSdkVersion >= 28;
            CharSequence nameReplacement = null;
            if (!atLeastP) {
                isOneToOne = TextUtils.isEmpty(conversationTitle);
                if (this.hasOnlyWhiteSpaceSenders()) {
                    isOneToOne = true;
                    nameReplacement = conversationTitle;
                    conversationTitle = null;
                }
            } else {
                boolean bl = isOneToOne = !this.isGroupConversation();
            }
            if (isHeaderless && isOneToOne && TextUtils.isEmpty(conversationTitle)) {
                conversationTitle = this.getOtherPersonName();
            }
            Icon largeIcon = this.mBuilder.mN.mLargeIcon;
            TemplateBindResult bindResult = new TemplateBindResult();
            StandardTemplateParams p = this.mBuilder.mParams.reset().viewType(viewType).highlightExpander(isConversationLayout).hideProgress(true).title(isHeaderless ? conversationTitle : null).text(null).hideLeftIcon(isOneToOne).hideRightIcon(hideRightIcons || isOneToOne).headerTextSecondary(isHeaderless ? null : conversationTitle);
            RemoteViews contentView = this.mBuilder.applyStandardTemplateWithActions(isConversationLayout ? this.mBuilder.getConversationLayoutResource() : (isCollapsed ? this.mBuilder.getMessagingLayoutResource() : this.mBuilder.getBigMessagingLayoutResource()), p, bindResult);
            if (isConversationLayout) {
                this.mBuilder.setTextViewColorPrimary(contentView, 16908929, p);
                this.mBuilder.setTextViewColorSecondary(contentView, 16908783, p);
            }
            this.addExtras(this.mBuilder.mN.extras);
            contentView.setInt(16909547, "setLayoutColor", this.mBuilder.getSmallIconColor(p));
            contentView.setInt(16909547, "setSenderTextColor", this.mBuilder.getPrimaryTextColor(p));
            contentView.setInt(16909547, "setMessageTextColor", this.mBuilder.getSecondaryTextColor(p));
            contentView.setInt(16909547, "setNotificationBackgroundColor", this.mBuilder.getBackgroundColor(p));
            contentView.setBoolean(16909547, "setIsCollapsed", isCollapsed);
            contentView.setIcon(16909547, "setAvatarReplacement", this.mBuilder.mN.mLargeIcon);
            contentView.setCharSequence(16909547, "setNameReplacement", nameReplacement);
            contentView.setBoolean(16909547, "setIsOneToOne", isOneToOne);
            contentView.setCharSequence(16909547, "setConversationTitle", conversationTitle);
            if (isConversationLayout) {
                contentView.setIcon(16909547, "setShortcutIcon", this.mShortcutIcon);
                contentView.setBoolean(16909547, "setIsImportantConversation", isImportantConversation);
            }
            if (isHeaderless) {
                contentView.setInt(16909294, "setMaxDisplayedLines", 1);
            }
            contentView.setIcon(16909547, "setLargeIcon", largeIcon);
            contentView.setBundle(16909547, "setData", this.mBuilder.mN.extras);
            return contentView;
        }

        private CharSequence getKey(Person person) {
            return person == null ? null : (person.getKey() == null ? person.getName() : person.getKey());
        }

        private CharSequence getOtherPersonName() {
            CharSequence userKey = this.getKey(this.mUser);
            for (int i = this.mMessages.size() - 1; i >= 0; --i) {
                Person sender = this.mMessages.get(i).getSenderPerson();
                if (sender == null || TextUtils.equals(userKey, this.getKey(sender))) continue;
                return sender.getName();
            }
            return null;
        }

        private boolean hasOnlyWhiteSpaceSenders() {
            for (int i = 0; i < this.mMessages.size(); ++i) {
                Message m = this.mMessages.get(i);
                Person sender = m.getSenderPerson();
                if (sender == null || this.isWhiteSpace(sender.getName())) continue;
                return false;
            }
            return true;
        }

        private boolean isWhiteSpace(CharSequence sender) {
            if (TextUtils.isEmpty(sender)) {
                return true;
            }
            if (sender.toString().matches("^\\s*$")) {
                return true;
            }
            for (int i = 0; i < sender.length(); ++i) {
                char c = sender.charAt(i);
                if (c == '\u200b') continue;
                return false;
            }
            return true;
        }

        @Override
        public RemoteViews makeHeadsUpContentView(boolean increasedHeight) {
            return this.makeMessagingView(StandardTemplateParams.VIEW_TYPE_HEADS_UP);
        }

        @Override
        public void reduceImageSizes(Context context) {
            super.reduceImageSizes(context);
            Resources resources = context.getResources();
            boolean isLowRam = ActivityManager.isLowRamDeviceStatic();
            if (this.mShortcutIcon != null) {
                int maxSize = resources.getDimensionPixelSize(isLowRam ? 17105433 : 17105432);
                this.mShortcutIcon.scaleDownIfNecessary(maxSize, maxSize);
            }
            int maxAvatarSize = resources.getDimensionPixelSize(isLowRam ? 17105421 : 17105422);
            if (this.mUser != null && this.mUser.getIcon() != null) {
                this.mUser.getIcon().scaleDownIfNecessary(maxAvatarSize, maxAvatarSize);
            }
            MessagingStyle.reduceMessagesIconSizes(this.mMessages, maxAvatarSize);
            MessagingStyle.reduceMessagesIconSizes(this.mHistoricMessages, maxAvatarSize);
        }

        private static void reduceMessagesIconSizes(List<Message> messages, int maxSize) {
            if (messages == null) {
                return;
            }
            for (Message message : messages) {
                Icon icon;
                Person sender = message.mSender;
                if (sender == null || (icon = sender.getIcon()) == null) continue;
                icon.scaleDownIfNecessary(maxSize, maxSize);
            }
        }

        public static class Message {
            public static final String KEY_TEXT = "text";
            static final String KEY_TIMESTAMP = "time";
            static final String KEY_SENDER = "sender";
            static final String KEY_SENDER_PERSON = "sender_person";
            static final String KEY_DATA_MIME_TYPE = "type";
            static final String KEY_DATA_URI = "uri";
            static final String KEY_EXTRAS_BUNDLE = "extras";
            static final String KEY_REMOTE_INPUT_HISTORY = "remote_input_history";
            private final CharSequence mText;
            private final long mTimestamp;
            private final Person mSender;
            private final boolean mRemoteInputHistory;
            private Bundle mExtras = new Bundle();
            private String mDataMimeType;
            private Uri mDataUri;

            public Message(CharSequence text, long timestamp, CharSequence sender) {
                this(text, timestamp, sender == null ? null : new Person.Builder().setName(sender).build());
            }

            public Message(CharSequence text, long timestamp, Person sender) {
                this(text, timestamp, sender, false);
            }

            public Message(CharSequence text, long timestamp, Person sender, boolean remoteInputHistory) {
                this.mText = Notification.safeCharSequence(text);
                this.mTimestamp = timestamp;
                this.mSender = sender;
                this.mRemoteInputHistory = remoteInputHistory;
            }

            public Message setData(String dataMimeType, Uri dataUri) {
                this.mDataMimeType = dataMimeType;
                this.mDataUri = dataUri;
                return this;
            }

            public CharSequence getText() {
                return this.mText;
            }

            public long getTimestamp() {
                return this.mTimestamp;
            }

            public Bundle getExtras() {
                return this.mExtras;
            }

            public CharSequence getSender() {
                return this.mSender == null ? null : this.mSender.getName();
            }

            public Person getSenderPerson() {
                return this.mSender;
            }

            public String getDataMimeType() {
                return this.mDataMimeType;
            }

            public Uri getDataUri() {
                return this.mDataUri;
            }

            public boolean isRemoteInputHistory() {
                return this.mRemoteInputHistory;
            }

            @VisibleForTesting
            public Bundle toBundle() {
                Bundle bundle = new Bundle();
                if (this.mText != null) {
                    bundle.putCharSequence(KEY_TEXT, this.mText);
                }
                bundle.putLong(KEY_TIMESTAMP, this.mTimestamp);
                if (this.mSender != null) {
                    bundle.putCharSequence(KEY_SENDER, Notification.safeCharSequence(this.mSender.getName()));
                    bundle.putParcelable(KEY_SENDER_PERSON, this.mSender);
                }
                if (this.mDataMimeType != null) {
                    bundle.putString(KEY_DATA_MIME_TYPE, this.mDataMimeType);
                }
                if (this.mDataUri != null) {
                    bundle.putParcelable(KEY_DATA_URI, this.mDataUri);
                }
                if (this.mExtras != null) {
                    bundle.putBundle(KEY_EXTRAS_BUNDLE, this.mExtras);
                }
                if (this.mRemoteInputHistory) {
                    bundle.putBoolean(KEY_REMOTE_INPUT_HISTORY, this.mRemoteInputHistory);
                }
                return bundle;
            }

            static Bundle[] getBundleArrayForMessages(List<Message> messages) {
                Bundle[] bundles = new Bundle[messages.size()];
                int N = messages.size();
                for (int i = 0; i < N; ++i) {
                    bundles[i] = messages.get(i).toBundle();
                }
                return bundles;
            }

            public static List<Message> getMessagesFromBundleArray(Parcelable[] bundles) {
                if (bundles == null) {
                    return new ArrayList<Message>();
                }
                ArrayList<Message> messages = new ArrayList<Message>(bundles.length);
                for (int i = 0; i < bundles.length; ++i) {
                    Message message;
                    if (!(bundles[i] instanceof Bundle) || (message = Message.getMessageFromBundle((Bundle)bundles[i])) == null) continue;
                    messages.add(message);
                }
                return messages;
            }

            public static Message getMessageFromBundle(Bundle bundle) {
                try {
                    CharSequence senderName;
                    if (!bundle.containsKey(KEY_TEXT) || !bundle.containsKey(KEY_TIMESTAMP)) {
                        return null;
                    }
                    Person senderPerson = bundle.getParcelable(KEY_SENDER_PERSON, Person.class);
                    if (senderPerson == null && (senderName = bundle.getCharSequence(KEY_SENDER)) != null) {
                        senderPerson = new Person.Builder().setName(senderName).build();
                    }
                    Message message = new Message(bundle.getCharSequence(KEY_TEXT), bundle.getLong(KEY_TIMESTAMP), senderPerson, bundle.getBoolean(KEY_REMOTE_INPUT_HISTORY, false));
                    if (bundle.containsKey(KEY_DATA_MIME_TYPE) && bundle.containsKey(KEY_DATA_URI)) {
                        message.setData(bundle.getString(KEY_DATA_MIME_TYPE), bundle.getParcelable(KEY_DATA_URI, Uri.class));
                    }
                    if (bundle.containsKey(KEY_EXTRAS_BUNDLE)) {
                        message.getExtras().putAll(bundle.getBundle(KEY_EXTRAS_BUNDLE));
                    }
                    return message;
                }
                catch (ClassCastException e) {
                    return null;
                }
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ConversationType {
        }
    }

    public static class BigTextStyle
    extends Style {
        private CharSequence mBigText;

        public BigTextStyle() {
        }

        @Deprecated
        public BigTextStyle(Builder builder) {
            this.setBuilder(builder);
        }

        public BigTextStyle setBigContentTitle(CharSequence title) {
            this.internalSetBigContentTitle(Notification.safeCharSequence(title));
            return this;
        }

        public BigTextStyle setSummaryText(CharSequence cs) {
            this.internalSetSummaryText(Notification.safeCharSequence(cs));
            return this;
        }

        public BigTextStyle bigText(CharSequence cs) {
            this.mBigText = Notification.safeCharSequence(cs);
            return this;
        }

        public CharSequence getBigText() {
            return this.mBigText;
        }

        @Override
        public void addExtras(Bundle extras) {
            super.addExtras(extras);
            extras.putCharSequence(Notification.EXTRA_BIG_TEXT, this.mBigText);
        }

        @Override
        protected void restoreFromExtras(Bundle extras) {
            super.restoreFromExtras(extras);
            this.mBigText = extras.getCharSequence(Notification.EXTRA_BIG_TEXT);
        }

        @Override
        public RemoteViews makeContentView(boolean increasedHeight) {
            if (increasedHeight) {
                ArrayList<Action> originalActions = this.mBuilder.mActions;
                this.mBuilder.mActions = new ArrayList();
                RemoteViews remoteViews = this.makeBigContentView();
                this.mBuilder.mActions = originalActions;
                return remoteViews;
            }
            return super.makeContentView(increasedHeight);
        }

        @Override
        public RemoteViews makeHeadsUpContentView(boolean increasedHeight) {
            if (increasedHeight && this.mBuilder.mActions.size() > 0) {
                return this.makeBigContentView();
            }
            return super.makeHeadsUpContentView(increasedHeight);
        }

        @Override
        public RemoteViews makeBigContentView() {
            StandardTemplateParams p = this.mBuilder.mParams.reset().viewType(StandardTemplateParams.VIEW_TYPE_BIG).allowTextWithProgress(true).textViewId(16908822).fillTextsFrom(this.mBuilder);
            CharSequence bigTextText = this.mBuilder.processLegacyText(this.mBigText);
            if (!TextUtils.isEmpty(bigTextText)) {
                p.text(bigTextText);
            }
            return this.getStandardView(this.mBuilder.getBigTextLayoutResource(), p, null);
        }

        @Override
        public boolean areNotificationsVisiblyDifferent(Style other) {
            if (other == null || this.getClass() != other.getClass()) {
                return true;
            }
            BigTextStyle newS = (BigTextStyle)other;
            return !Objects.equals(String.valueOf(this.getBigText()), String.valueOf(newS.getBigText()));
        }
    }

    public static class BigPictureStyle
    extends Style {
        private Icon mPictureIcon;
        private Icon mBigLargeIcon;
        private boolean mBigLargeIconSet = false;
        private CharSequence mPictureContentDescription;
        private boolean mShowBigPictureWhenCollapsed;
        public static final int MIN_ASHMEM_BITMAP_SIZE = 131072;

        public BigPictureStyle() {
        }

        @Deprecated
        public BigPictureStyle(Builder builder) {
            this.setBuilder(builder);
        }

        public BigPictureStyle setBigContentTitle(CharSequence title) {
            this.internalSetBigContentTitle(Notification.safeCharSequence(title));
            return this;
        }

        public BigPictureStyle setSummaryText(CharSequence cs) {
            this.internalSetSummaryText(Notification.safeCharSequence(cs));
            return this;
        }

        public BigPictureStyle setContentDescription(CharSequence contentDescription) {
            this.mPictureContentDescription = contentDescription;
            return this;
        }

        public Icon getBigPicture() {
            if (this.mPictureIcon != null) {
                return this.mPictureIcon;
            }
            return null;
        }

        public BigPictureStyle bigPicture(Bitmap b) {
            this.mPictureIcon = b == null ? null : Icon.createWithBitmap(b);
            return this;
        }

        public BigPictureStyle bigPicture(Icon icon) {
            this.mPictureIcon = icon;
            return this;
        }

        public BigPictureStyle showBigPictureWhenCollapsed(boolean show) {
            this.mShowBigPictureWhenCollapsed = show;
            return this;
        }

        public BigPictureStyle bigLargeIcon(Bitmap b) {
            return this.bigLargeIcon(b != null ? Icon.createWithBitmap(b) : null);
        }

        public BigPictureStyle bigLargeIcon(Icon icon) {
            this.mBigLargeIconSet = true;
            this.mBigLargeIcon = icon;
            return this;
        }

        @Override
        public void purgeResources() {
            super.purgeResources();
            if (this.mPictureIcon != null) {
                this.mPictureIcon.convertToAshmem();
            }
            if (this.mBigLargeIcon != null) {
                this.mBigLargeIcon.convertToAshmem();
            }
        }

        @Override
        public void reduceImageSizes(Context context) {
            super.reduceImageSizes(context);
            Resources resources = context.getResources();
            boolean isLowRam = ActivityManager.isLowRamDeviceStatic();
            if (this.mPictureIcon != null) {
                int maxPictureWidth = resources.getDimensionPixelSize(isLowRam ? 17105378 : 17105377);
                int maxPictureHeight = resources.getDimensionPixelSize(isLowRam ? 17105380 : 17105379);
                this.mPictureIcon.scaleDownIfNecessary(maxPictureWidth, maxPictureHeight);
            }
            if (this.mBigLargeIcon != null) {
                int rightIconSize = resources.getDimensionPixelSize(isLowRam ? 17105430 : 17105429);
                this.mBigLargeIcon.scaleDownIfNecessary(rightIconSize, rightIconSize);
            }
        }

        @Override
        public RemoteViews makeContentView(boolean increasedHeight) {
            if (this.mPictureIcon == null || !this.mShowBigPictureWhenCollapsed) {
                return super.makeContentView(increasedHeight);
            }
            StandardTemplateParams p = this.mBuilder.mParams.reset().viewType(StandardTemplateParams.VIEW_TYPE_NORMAL).fillTextsFrom(this.mBuilder).promotedPicture(this.mPictureIcon);
            return this.getStandardView(this.mBuilder.getBaseLayoutResource(), p, null);
        }

        @Override
        public RemoteViews makeHeadsUpContentView(boolean increasedHeight) {
            if (this.mPictureIcon == null || !this.mShowBigPictureWhenCollapsed) {
                return super.makeHeadsUpContentView(increasedHeight);
            }
            StandardTemplateParams p = this.mBuilder.mParams.reset().viewType(StandardTemplateParams.VIEW_TYPE_HEADS_UP).fillTextsFrom(this.mBuilder).promotedPicture(this.mPictureIcon);
            return this.getStandardView(this.mBuilder.getHeadsUpBaseLayoutResource(), p, null);
        }

        @Override
        public RemoteViews makeBigContentView() {
            Icon oldLargeIcon = null;
            Bitmap largeIconLegacy = null;
            if (this.mBigLargeIconSet) {
                oldLargeIcon = this.mBuilder.mN.mLargeIcon;
                this.mBuilder.mN.mLargeIcon = this.mBigLargeIcon;
                largeIconLegacy = this.mBuilder.mN.largeIcon;
                this.mBuilder.mN.largeIcon = null;
            }
            StandardTemplateParams p = this.mBuilder.mParams.reset().viewType(StandardTemplateParams.VIEW_TYPE_BIG).fillTextsFrom(this.mBuilder);
            RemoteViews contentView = this.getStandardView(this.mBuilder.getBigPictureLayoutResource(), p, null);
            if (this.mSummaryTextSet) {
                contentView.setTextViewText(16909579, this.mBuilder.processTextSpans(this.mBuilder.processLegacyText(this.mSummaryText)));
                this.mBuilder.setTextViewColorSecondary(contentView, 16909579, p);
                contentView.setViewVisibility(16909579, 0);
            }
            if (this.mBigLargeIconSet) {
                this.mBuilder.mN.mLargeIcon = oldLargeIcon;
                this.mBuilder.mN.largeIcon = largeIconLegacy;
            }
            contentView.setImageViewIcon(16908821, this.mPictureIcon);
            if (this.mPictureContentDescription != null) {
                contentView.setContentDescription(16908821, this.mPictureContentDescription);
            }
            return contentView;
        }

        @Override
        public void addExtras(Bundle extras) {
            super.addExtras(extras);
            if (this.mBigLargeIconSet) {
                extras.putParcelable(Notification.EXTRA_LARGE_ICON_BIG, this.mBigLargeIcon);
            }
            if (this.mPictureContentDescription != null) {
                extras.putCharSequence(Notification.EXTRA_PICTURE_CONTENT_DESCRIPTION, this.mPictureContentDescription);
            }
            extras.putBoolean(Notification.EXTRA_SHOW_BIG_PICTURE_WHEN_COLLAPSED, this.mShowBigPictureWhenCollapsed);
            if (this.mPictureIcon != null && this.mPictureIcon.getType() == 1) {
                extras.putParcelable(Notification.EXTRA_PICTURE, this.mPictureIcon.getBitmap());
                extras.putParcelable(Notification.EXTRA_PICTURE_ICON, null);
            } else {
                extras.putParcelable(Notification.EXTRA_PICTURE, null);
                extras.putParcelable(Notification.EXTRA_PICTURE_ICON, this.mPictureIcon);
            }
        }

        @Override
        protected void restoreFromExtras(Bundle extras) {
            super.restoreFromExtras(extras);
            if (extras.containsKey(Notification.EXTRA_LARGE_ICON_BIG)) {
                this.mBigLargeIconSet = true;
                this.mBigLargeIcon = extras.getParcelable(Notification.EXTRA_LARGE_ICON_BIG, Icon.class);
            }
            if (extras.containsKey(Notification.EXTRA_PICTURE_CONTENT_DESCRIPTION)) {
                this.mPictureContentDescription = extras.getCharSequence(Notification.EXTRA_PICTURE_CONTENT_DESCRIPTION);
            }
            this.mShowBigPictureWhenCollapsed = extras.getBoolean(Notification.EXTRA_SHOW_BIG_PICTURE_WHEN_COLLAPSED);
            this.mPictureIcon = BigPictureStyle.getPictureIcon(extras);
        }

        public static Icon getPictureIcon(Bundle extras) {
            if (extras == null) {
                return null;
            }
            Bitmap bitmapPicture = extras.getParcelable(Notification.EXTRA_PICTURE, Bitmap.class);
            if (bitmapPicture != null) {
                return Icon.createWithBitmap(bitmapPicture);
            }
            return extras.getParcelable(Notification.EXTRA_PICTURE_ICON, Icon.class);
        }

        @Override
        public boolean hasSummaryInHeader() {
            return false;
        }

        @Override
        public boolean areNotificationsVisiblyDifferent(Style other) {
            if (other == null || this.getClass() != other.getClass()) {
                return true;
            }
            BigPictureStyle otherS = (BigPictureStyle)other;
            return BigPictureStyle.areIconsObviouslyDifferent(this.getBigPicture(), otherS.getBigPicture());
        }

        private static boolean areIconsObviouslyDifferent(Icon a, Icon b) {
            if (a == b) {
                return false;
            }
            if (a == null || b == null) {
                return true;
            }
            if (a.sameAs(b)) {
                return false;
            }
            int aType = a.getType();
            if (aType != b.getType()) {
                return true;
            }
            if (aType == 1 || aType == 5) {
                Bitmap aBitmap = a.getBitmap();
                Bitmap bBitmap = b.getBitmap();
                return aBitmap.getWidth() != bBitmap.getWidth() || aBitmap.getHeight() != bBitmap.getHeight() || aBitmap.getConfig() != bBitmap.getConfig() || aBitmap.getGenerationId() != bBitmap.getGenerationId();
            }
            return true;
        }
    }

    public static abstract class Style {
        static final int MAX_REMOTE_INPUT_HISTORY_LINES = 3;
        private CharSequence mBigContentTitle;
        protected CharSequence mSummaryText = null;
        protected boolean mSummaryTextSet = false;
        protected Builder mBuilder;

        protected void internalSetBigContentTitle(CharSequence title) {
            this.mBigContentTitle = title;
        }

        protected void internalSetSummaryText(CharSequence cs) {
            this.mSummaryText = cs;
            this.mSummaryTextSet = true;
        }

        public void setBuilder(Builder builder) {
            if (this.mBuilder != builder) {
                this.mBuilder = builder;
                if (this.mBuilder != null) {
                    this.mBuilder.setStyle(this);
                }
            }
        }

        protected void checkBuilder() {
            if (this.mBuilder == null) {
                throw new IllegalArgumentException("Style requires a valid Builder object");
            }
        }

        protected RemoteViews getStandardView(int layoutId) {
            StandardTemplateParams p = this.mBuilder.mParams.reset().viewType(StandardTemplateParams.VIEW_TYPE_UNSPECIFIED).fillTextsFrom(this.mBuilder);
            return this.getStandardView(layoutId, p, null);
        }

        protected RemoteViews getStandardView(int layoutId, StandardTemplateParams p, TemplateBindResult result) {
            this.checkBuilder();
            if (this.mBigContentTitle != null) {
                p.title = this.mBigContentTitle;
            }
            return this.mBuilder.applyStandardTemplateWithActions(layoutId, p, result);
        }

        public RemoteViews makeContentView(boolean increasedHeight) {
            return null;
        }

        public RemoteViews makeBigContentView() {
            return null;
        }

        public RemoteViews makeHeadsUpContentView(boolean increasedHeight) {
            return null;
        }

        public void addExtras(Bundle extras) {
            if (this.mSummaryTextSet) {
                extras.putCharSequence(Notification.EXTRA_SUMMARY_TEXT, this.mSummaryText);
            }
            if (this.mBigContentTitle != null) {
                extras.putCharSequence(Notification.EXTRA_TITLE_BIG, this.mBigContentTitle);
            }
            extras.putString(Notification.EXTRA_TEMPLATE, this.getClass().getName());
        }

        protected void restoreFromExtras(Bundle extras) {
            if (extras.containsKey(Notification.EXTRA_SUMMARY_TEXT)) {
                this.mSummaryText = extras.getCharSequence(Notification.EXTRA_SUMMARY_TEXT);
                this.mSummaryTextSet = true;
            }
            if (extras.containsKey(Notification.EXTRA_TITLE_BIG)) {
                this.mBigContentTitle = extras.getCharSequence(Notification.EXTRA_TITLE_BIG);
            }
        }

        public Notification buildStyled(Notification wip) {
            this.addExtras(wip.extras);
            return wip;
        }

        public void purgeResources() {
        }

        public Notification build() {
            this.checkBuilder();
            return this.mBuilder.build();
        }

        public boolean hasSummaryInHeader() {
            return true;
        }

        public boolean displayCustomViewInline() {
            return false;
        }

        public void reduceImageSizes(Context context) {
        }

        public void validate(Context context) {
        }

        public abstract boolean areNotificationsVisiblyDifferent(Style var1);

        public CharSequence getHeadsUpStatusBarText() {
            return null;
        }
    }

    public static class Builder {
        public static final String EXTRA_REBUILD_CONTENT_VIEW_ACTION_COUNT = "android.rebuild.contentViewActionCount";
        public static final String EXTRA_REBUILD_BIG_CONTENT_VIEW_ACTION_COUNT = "android.rebuild.bigViewActionCount";
        public static final String EXTRA_REBUILD_HEADS_UP_CONTENT_VIEW_ACTION_COUNT = "android.rebuild.hudViewActionCount";
        private static final boolean USE_ONLY_TITLE_IN_LOW_PRIORITY_SUMMARY = SystemProperties.getBoolean("notifications.only_title", true);
        private static final int LIGHTNESS_TEXT_DIFFERENCE_LIGHT = 20;
        private static final int LIGHTNESS_TEXT_DIFFERENCE_DARK = -10;
        private Context mContext;
        private Notification mN;
        private Bundle mUserExtras = new Bundle();
        private Style mStyle;
        @UnsupportedAppUsage
        private ArrayList<Action> mActions = new ArrayList(3);
        private ArrayList<Person> mPersonList = new ArrayList();
        private ContrastColorUtil mColorUtil;
        private boolean mIsLegacy;
        private boolean mIsLegacyInitialized;
        StandardTemplateParams mParams = new StandardTemplateParams();
        Colors mColors = new Colors();
        private boolean mTintActionButtons;
        private boolean mInNightMode;

        public Builder(Context context, String channelId) {
            this(context, (Notification)null);
            this.mN.mChannelId = channelId;
        }

        @Deprecated
        public Builder(Context context) {
            this(context, (Notification)null);
        }

        public Builder(Context context, Notification toAdopt) {
            this.mContext = context;
            Resources res = this.mContext.getResources();
            this.mTintActionButtons = res.getBoolean(17891799);
            if (res.getBoolean(17891643)) {
                Configuration currentConfig = res.getConfiguration();
                boolean bl = this.mInNightMode = (currentConfig.uiMode & 0x30) == 32;
            }
            if (toAdopt == null) {
                this.mN = new Notification();
                if (context.getApplicationInfo().targetSdkVersion < 24) {
                    this.mN.extras.putBoolean(Notification.EXTRA_SHOW_WHEN, true);
                }
                this.mN.priority = 0;
                this.mN.visibility = 0;
            } else {
                String templateClass;
                this.mN = toAdopt;
                if (this.mN.actions != null) {
                    Collections.addAll(this.mActions, this.mN.actions);
                }
                if (this.mN.extras.containsKey(Notification.EXTRA_PEOPLE_LIST)) {
                    ArrayList people = this.mN.extras.getParcelableArrayList(Notification.EXTRA_PEOPLE_LIST);
                    this.mPersonList.addAll(people);
                }
                if (this.mN.getSmallIcon() == null && this.mN.icon != 0) {
                    this.setSmallIcon(this.mN.icon);
                }
                if (this.mN.getLargeIcon() == null && this.mN.largeIcon != null) {
                    this.setLargeIcon(this.mN.largeIcon);
                }
                if (!TextUtils.isEmpty(templateClass = this.mN.extras.getString(Notification.EXTRA_TEMPLATE))) {
                    Class<? extends Style> styleClass = Notification.getNotificationStyleClass(templateClass);
                    if (styleClass == null) {
                        Log.d(Notification.TAG, "Unknown style class: " + templateClass);
                    } else {
                        try {
                            Constructor<? extends Style> ctor = styleClass.getDeclaredConstructor(new Class[0]);
                            ctor.setAccessible(true);
                            Style style2 = ctor.newInstance(new Object[0]);
                            style2.restoreFromExtras(this.mN.extras);
                            if (style2 != null) {
                                this.setStyle(style2);
                            }
                        }
                        catch (Throwable t) {
                            Log.e(Notification.TAG, "Could not create Style", t);
                        }
                    }
                }
            }
        }

        private ContrastColorUtil getColorUtil() {
            if (this.mColorUtil == null) {
                this.mColorUtil = ContrastColorUtil.getInstance(this.mContext);
            }
            return this.mColorUtil;
        }

        public Builder setShortcutId(String shortcutId) {
            this.mN.mShortcutId = shortcutId;
            return this;
        }

        public Builder setLocusId(LocusId locusId) {
            this.mN.mLocusId = locusId;
            return this;
        }

        public Builder setBadgeIconType(int icon) {
            this.mN.mBadgeIcon = icon;
            return this;
        }

        public Builder setGroupAlertBehavior(int groupAlertBehavior) {
            this.mN.mGroupAlertBehavior = groupAlertBehavior;
            return this;
        }

        public Builder setBubbleMetadata(BubbleMetadata data) {
            this.mN.mBubbleMetadata = data;
            return this;
        }

        @Deprecated
        public Builder setChannel(String channelId) {
            this.mN.mChannelId = channelId;
            return this;
        }

        public Builder setChannelId(String channelId) {
            this.mN.mChannelId = channelId;
            return this;
        }

        @Deprecated
        public Builder setTimeout(long durationMs) {
            this.mN.mTimeout = durationMs;
            return this;
        }

        public Builder setTimeoutAfter(long durationMs) {
            this.mN.mTimeout = durationMs;
            return this;
        }

        public Builder setWhen(long when) {
            this.mN.when = when;
            return this;
        }

        public Builder setShowWhen(boolean show) {
            this.mN.extras.putBoolean(Notification.EXTRA_SHOW_WHEN, show);
            return this;
        }

        public Builder setUsesChronometer(boolean b) {
            this.mN.extras.putBoolean(Notification.EXTRA_SHOW_CHRONOMETER, b);
            return this;
        }

        public Builder setChronometerCountDown(boolean countDown) {
            this.mN.extras.putBoolean(Notification.EXTRA_CHRONOMETER_COUNT_DOWN, countDown);
            return this;
        }

        public Builder setSmallIcon(int icon) {
            return this.setSmallIcon(icon != 0 ? Icon.createWithResource(this.mContext, icon) : null);
        }

        public Builder setSmallIcon(int icon, int level) {
            this.mN.iconLevel = level;
            return this.setSmallIcon(icon);
        }

        public Builder setSmallIcon(Icon icon) {
            this.mN.setSmallIcon(icon);
            if (icon != null && icon.getType() == 2) {
                this.mN.icon = icon.getResId();
            }
            return this;
        }

        public Builder setContentTitle(CharSequence title) {
            this.mN.extras.putCharSequence(Notification.EXTRA_TITLE, Notification.safeCharSequence(title));
            return this;
        }

        public Builder setContentText(CharSequence text) {
            this.mN.extras.putCharSequence(Notification.EXTRA_TEXT, Notification.safeCharSequence(text));
            return this;
        }

        public Builder setSubText(CharSequence text) {
            this.mN.extras.putCharSequence(Notification.EXTRA_SUB_TEXT, Notification.safeCharSequence(text));
            return this;
        }

        public Builder setSettingsText(CharSequence text) {
            this.mN.mSettingsText = Notification.safeCharSequence(text);
            return this;
        }

        public Builder setRemoteInputHistory(CharSequence[] text) {
            if (text == null) {
                this.mN.extras.putCharSequenceArray(Notification.EXTRA_REMOTE_INPUT_HISTORY, null);
            } else {
                int itemCount = Math.min(5, text.length);
                CharSequence[] safe = new CharSequence[itemCount];
                Parcelable[] items = new RemoteInputHistoryItem[itemCount];
                for (int i = 0; i < itemCount; ++i) {
                    safe[i] = Notification.safeCharSequence(text[i]);
                    items[i] = new RemoteInputHistoryItem(text[i]);
                }
                this.mN.extras.putCharSequenceArray(Notification.EXTRA_REMOTE_INPUT_HISTORY, safe);
                this.mN.extras.putParcelableArray(Notification.EXTRA_REMOTE_INPUT_HISTORY_ITEMS, items);
            }
            return this;
        }

        public Builder setRemoteInputHistory(RemoteInputHistoryItem[] items) {
            if (items == null) {
                this.mN.extras.putParcelableArray(Notification.EXTRA_REMOTE_INPUT_HISTORY_ITEMS, null);
            } else {
                int itemCount = Math.min(5, items.length);
                Parcelable[] history = new RemoteInputHistoryItem[itemCount];
                for (int i = 0; i < itemCount; ++i) {
                    history[i] = items[i];
                }
                this.mN.extras.putParcelableArray(Notification.EXTRA_REMOTE_INPUT_HISTORY_ITEMS, history);
            }
            return this;
        }

        public Builder setShowRemoteInputSpinner(boolean showSpinner) {
            this.mN.extras.putBoolean(Notification.EXTRA_SHOW_REMOTE_INPUT_SPINNER, showSpinner);
            return this;
        }

        public Builder setHideSmartReplies(boolean hideSmartReplies) {
            this.mN.extras.putBoolean(Notification.EXTRA_HIDE_SMART_REPLIES, hideSmartReplies);
            return this;
        }

        public Builder setNumber(int number) {
            this.mN.number = number;
            return this;
        }

        @Deprecated
        public Builder setContentInfo(CharSequence info) {
            this.mN.extras.putCharSequence(Notification.EXTRA_INFO_TEXT, Notification.safeCharSequence(info));
            return this;
        }

        public Builder setProgress(int max, int progress, boolean indeterminate) {
            this.mN.extras.putInt(Notification.EXTRA_PROGRESS, progress);
            this.mN.extras.putInt(Notification.EXTRA_PROGRESS_MAX, max);
            this.mN.extras.putBoolean(Notification.EXTRA_PROGRESS_INDETERMINATE, indeterminate);
            return this;
        }

        @Deprecated
        public Builder setContent(RemoteViews views) {
            return this.setCustomContentView(views);
        }

        public Builder setCustomContentView(RemoteViews contentView) {
            this.mN.contentView = contentView;
            return this;
        }

        public Builder setCustomBigContentView(RemoteViews contentView) {
            this.mN.bigContentView = contentView;
            return this;
        }

        public Builder setCustomHeadsUpContentView(RemoteViews contentView) {
            this.mN.headsUpContentView = contentView;
            return this;
        }

        public Builder setContentIntent(PendingIntent intent) {
            this.mN.contentIntent = intent;
            return this;
        }

        public Builder setDeleteIntent(PendingIntent intent) {
            this.mN.deleteIntent = intent;
            return this;
        }

        public Builder setFullScreenIntent(PendingIntent intent, boolean highPriority) {
            this.mN.fullScreenIntent = intent;
            this.setFlag(128, highPriority);
            return this;
        }

        public Builder setTicker(CharSequence tickerText) {
            this.mN.tickerText = Notification.safeCharSequence(tickerText);
            return this;
        }

        @Deprecated
        public Builder setTicker(CharSequence tickerText, RemoteViews views) {
            this.setTicker(tickerText);
            return this;
        }

        public Builder setLargeIcon(Bitmap b) {
            return this.setLargeIcon(b != null ? Icon.createWithBitmap(b) : null);
        }

        public Builder setLargeIcon(Icon icon) {
            this.mN.mLargeIcon = icon;
            this.mN.extras.putParcelable(Notification.EXTRA_LARGE_ICON, icon);
            return this;
        }

        @Deprecated
        public Builder setSound(Uri sound) {
            this.mN.sound = sound;
            this.mN.audioAttributes = AUDIO_ATTRIBUTES_DEFAULT;
            return this;
        }

        @Deprecated
        public Builder setSound(Uri sound, int streamType) {
            PlayerBase.deprecateStreamTypeForPlayback(streamType, Notification.TAG, "setSound()");
            this.mN.sound = sound;
            this.mN.audioStreamType = streamType;
            return this;
        }

        @Deprecated
        public Builder setSound(Uri sound, AudioAttributes audioAttributes) {
            this.mN.sound = sound;
            this.mN.audioAttributes = audioAttributes;
            return this;
        }

        @Deprecated
        public Builder setVibrate(long[] pattern) {
            this.mN.vibrate = pattern;
            return this;
        }

        @Deprecated
        public Builder setLights(int argb, int onMs, int offMs) {
            this.mN.ledARGB = argb;
            this.mN.ledOnMS = onMs;
            this.mN.ledOffMS = offMs;
            if (onMs != 0 || offMs != 0) {
                this.mN.flags |= 1;
            }
            return this;
        }

        public Builder setOngoing(boolean ongoing) {
            this.setFlag(2, ongoing);
            return this;
        }

        public Builder setColorized(boolean colorize) {
            this.mN.extras.putBoolean(Notification.EXTRA_COLORIZED, colorize);
            return this;
        }

        public Builder setOnlyAlertOnce(boolean onlyAlertOnce) {
            this.setFlag(8, onlyAlertOnce);
            return this;
        }

        public Builder setForegroundServiceBehavior(int behavior) {
            this.mN.mFgsDeferBehavior = behavior;
            return this;
        }

        public Builder setAutoCancel(boolean autoCancel) {
            this.setFlag(16, autoCancel);
            return this;
        }

        public Builder setLocalOnly(boolean localOnly) {
            this.setFlag(256, localOnly);
            return this;
        }

        @Deprecated
        public Builder setDefaults(int defaults) {
            this.mN.defaults = defaults;
            return this;
        }

        @Deprecated
        public Builder setPriority(int pri) {
            this.mN.priority = pri;
            return this;
        }

        public Builder setCategory(String category) {
            this.mN.category = category;
            return this;
        }

        public Builder addPerson(String uri) {
            this.addPerson(new Person.Builder().setUri(uri).build());
            return this;
        }

        public Builder addPerson(Person person) {
            this.mPersonList.add(person);
            return this;
        }

        public Builder setGroup(String groupKey) {
            this.mN.mGroupKey = groupKey;
            return this;
        }

        public Builder setGroupSummary(boolean isGroupSummary) {
            this.setFlag(512, isGroupSummary);
            return this;
        }

        public Builder setSortKey(String sortKey) {
            this.mN.mSortKey = sortKey;
            return this;
        }

        public Builder addExtras(Bundle extras) {
            if (extras != null) {
                this.mUserExtras.putAll(extras);
            }
            return this;
        }

        public Builder setExtras(Bundle extras) {
            if (extras != null) {
                this.mUserExtras = extras;
            }
            return this;
        }

        public Bundle getExtras() {
            return this.mUserExtras;
        }

        private Bundle getAllExtras() {
            Bundle saveExtras = (Bundle)this.mUserExtras.clone();
            saveExtras.putAll(this.mN.extras);
            return saveExtras;
        }

        @Deprecated
        public Builder addAction(int icon, CharSequence title, PendingIntent intent) {
            this.mActions.add(new Action(icon, Notification.safeCharSequence(title), intent));
            return this;
        }

        public Builder addAction(Action action) {
            if (action != null) {
                this.mActions.add(action);
            }
            return this;
        }

        public Builder setActions(Action ... actions) {
            this.mActions.clear();
            for (int i = 0; i < actions.length; ++i) {
                if (actions[i] == null) continue;
                this.mActions.add(actions[i]);
            }
            return this;
        }

        public Builder setStyle(Style style2) {
            if (this.mStyle != style2) {
                this.mStyle = style2;
                if (this.mStyle != null) {
                    this.mStyle.setBuilder(this);
                    this.mN.extras.putString(Notification.EXTRA_TEMPLATE, style2.getClass().getName());
                } else {
                    this.mN.extras.remove(Notification.EXTRA_TEMPLATE);
                }
            }
            return this;
        }

        public Style getStyle() {
            return this.mStyle;
        }

        public Builder setVisibility(int visibility) {
            this.mN.visibility = visibility;
            return this;
        }

        public Builder setPublicVersion(Notification n) {
            if (n != null) {
                this.mN.publicVersion = new Notification();
                n.cloneInto(this.mN.publicVersion, true);
            } else {
                this.mN.publicVersion = null;
            }
            return this;
        }

        public Builder extend(Extender extender) {
            extender.extend(this);
            return this;
        }

        public Builder setFlag(int mask, boolean value) {
            this.mN.flags = value ? (this.mN.flags |= mask) : (this.mN.flags &= ~mask);
            return this;
        }

        public Builder setColor(int argb) {
            this.mN.color = argb;
            this.sanitizeColor();
            return this;
        }

        private void bindPhishingAlertIcon(RemoteViews contentView, StandardTemplateParams p) {
            contentView.setDrawableTint(16909349, false, this.getColors(p).getErrorColor(), PorterDuff.Mode.SRC_ATOP);
        }

        private Drawable getProfileBadgeDrawable() {
            if (this.mContext.getUserId() == 0) {
                return null;
            }
            DevicePolicyManager dpm = this.mContext.getSystemService(DevicePolicyManager.class);
            return dpm.getResources().getDrawable(this.getUpdatableProfileBadgeId(), "SOLID_COLORED", "NOTIFICATION", this::getDefaultProfileBadgeDrawable);
        }

        private String getUpdatableProfileBadgeId() {
            return this.mContext.getSystemService(UserManager.class).isManagedProfile() ? "WORK_PROFILE_ICON" : "UNDEFINED";
        }

        private Drawable getDefaultProfileBadgeDrawable() {
            return this.mContext.getPackageManager().getUserBadgeForDensityNoBackground(new UserHandle(this.mContext.getUserId()), 0);
        }

        private Bitmap getProfileBadge() {
            Drawable badge = this.getProfileBadgeDrawable();
            if (badge == null) {
                return null;
            }
            int size = this.mContext.getResources().getDimensionPixelSize(17105376);
            Bitmap bitmap = Bitmap.createBitmap(size, size, Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            badge.setBounds(0, 0, size, size);
            badge.draw(canvas);
            return bitmap;
        }

        private void bindProfileBadge(RemoteViews contentView, StandardTemplateParams p) {
            Bitmap profileBadge = this.getProfileBadge();
            if (profileBadge != null) {
                contentView.setImageViewBitmap(16909376, profileBadge);
                contentView.setViewVisibility(16909376, 0);
                if (this.isBackgroundColorized(p)) {
                    contentView.setDrawableTint(16909376, false, this.getPrimaryTextColor(p), PorterDuff.Mode.SRC_ATOP);
                }
            }
        }

        private void bindAlertedIcon(RemoteViews contentView, StandardTemplateParams p) {
            contentView.setDrawableTint(16908762, false, this.getColors(p).getSecondaryTextColor(), PorterDuff.Mode.SRC_IN);
        }

        public boolean usesStandardHeader() {
            if (this.mN.mUsesStandardHeader) {
                return true;
            }
            if (this.mContext.getApplicationInfo().targetSdkVersion >= 24 && this.mN.contentView == null && this.mN.bigContentView == null) {
                return true;
            }
            boolean contentViewUsesHeader = this.mN.contentView == null || STANDARD_LAYOUTS.contains(this.mN.contentView.getLayoutId());
            boolean bigContentViewUsesHeader = this.mN.bigContentView == null || STANDARD_LAYOUTS.contains(this.mN.bigContentView.getLayoutId());
            return contentViewUsesHeader && bigContentViewUsesHeader;
        }

        private void resetStandardTemplate(RemoteViews contentView) {
            this.resetNotificationHeader(contentView);
            contentView.setViewVisibility(16909431, 8);
            contentView.setViewVisibility(16908310, 8);
            contentView.setTextViewText(16908310, null);
            contentView.setViewVisibility(16909579, 8);
            contentView.setTextViewText(16909579, null);
        }

        private void resetNotificationHeader(RemoteViews contentView) {
            contentView.setBoolean(16908982, "setExpanded", false);
            contentView.setViewVisibility(16908784, 8);
            contentView.setTextViewText(16908784, null);
            contentView.setViewVisibility(16908876, 8);
            contentView.setViewVisibility(16909073, 8);
            contentView.setTextViewText(16909073, null);
            contentView.setViewVisibility(16909075, 8);
            contentView.setTextViewText(16909075, null);
            contentView.setViewVisibility(16909074, 8);
            contentView.setViewVisibility(16909076, 8);
            contentView.setViewVisibility(16909614, 8);
            contentView.setViewVisibility(16909610, 8);
            contentView.setImageViewIcon(16909376, null);
            contentView.setViewVisibility(16909376, 8);
            this.mN.mUsesStandardHeader = false;
        }

        private RemoteViews applyStandardTemplate(int resId, StandardTemplateParams p, TemplateBindResult result) {
            boolean showProgress;
            p.headerless(resId == this.getBaseLayoutResource() || resId == this.getHeadsUpBaseLayoutResource() || resId == this.getMessagingLayoutResource() || resId == 17367232);
            BuilderRemoteViews contentView = new BuilderRemoteViews(this.mContext.getApplicationInfo(), resId);
            this.resetStandardTemplate(contentView);
            Bundle ex = this.mN.extras;
            this.updateBackgroundColor(contentView, p);
            this.bindNotificationHeader(contentView, p);
            this.bindLargeIconAndApplyMargin(contentView, p, result);
            boolean hasSecondLine = showProgress = this.handleProgressBar(contentView, ex, p);
            if (p.hasTitle()) {
                contentView.setViewVisibility(p.mTitleViewId, 0);
                contentView.setTextViewText(p.mTitleViewId, this.processTextSpans(p.title));
                this.setTextViewColorPrimary(contentView, p.mTitleViewId, p);
            } else if (p.mTitleViewId != 16908310) {
                contentView.setViewVisibility(p.mTitleViewId, 8);
                contentView.setTextViewText(p.mTitleViewId, null);
            }
            if (p.text != null && p.text.length() != 0 && (!showProgress || p.mAllowTextWithProgress)) {
                contentView.setViewVisibility(p.mTextViewId, 0);
                contentView.setTextViewText(p.mTextViewId, this.processTextSpans(p.text));
                this.setTextViewColorSecondary(contentView, p.mTextViewId, p);
                hasSecondLine = true;
            } else if (p.mTextViewId != 16909579) {
                contentView.setViewVisibility(p.mTextViewId, 8);
                contentView.setTextViewText(p.mTextViewId, null);
            }
            Builder.setHeaderlessVerticalMargins(contentView, p, hasSecondLine);
            return contentView;
        }

        private static void setHeaderlessVerticalMargins(RemoteViews contentView, StandardTemplateParams p, boolean hasSecondLine) {
            if (!p.mHeaderless) {
                return;
            }
            int marginDimen = hasSecondLine ? 17105409 : 17105408;
            contentView.setViewLayoutMarginDimen(16909284, 1, marginDimen);
            contentView.setViewLayoutMarginDimen(16909284, 3, marginDimen);
        }

        private CharSequence processTextSpans(CharSequence text) {
            if (this.mInNightMode) {
                return ContrastColorUtil.clearColorSpans(text);
            }
            return text;
        }

        private void setTextViewColorPrimary(RemoteViews contentView, int id2, StandardTemplateParams p) {
            contentView.setTextColor(id2, this.getPrimaryTextColor(p));
        }

        @VisibleForTesting
        public int getPrimaryTextColor(StandardTemplateParams p) {
            return this.getColors(p).getPrimaryTextColor();
        }

        @VisibleForTesting
        public int getSecondaryTextColor(StandardTemplateParams p) {
            return this.getColors(p).getSecondaryTextColor();
        }

        private void setTextViewColorSecondary(RemoteViews contentView, int id2, StandardTemplateParams p) {
            contentView.setTextColor(id2, this.getSecondaryTextColor(p));
        }

        private Colors getColors(StandardTemplateParams p) {
            this.mColors.resolvePalette(this.mContext, this.mN.color, this.isBackgroundColorized(p), this.mInNightMode);
            return this.mColors;
        }

        private void updateBackgroundColor(RemoteViews contentView, StandardTemplateParams p) {
            if (this.isBackgroundColorized(p)) {
                contentView.setInt(16909547, "setBackgroundColor", this.getBackgroundColor(p));
            } else {
                contentView.setInt(16909547, "setBackgroundResource", 0);
            }
        }

        private boolean handleProgressBar(RemoteViews contentView, Bundle ex, StandardTemplateParams p) {
            int max = ex.getInt(Notification.EXTRA_PROGRESS_MAX, 0);
            int progress = ex.getInt(Notification.EXTRA_PROGRESS, 0);
            boolean ind = ex.getBoolean(Notification.EXTRA_PROGRESS_INDETERMINATE);
            if (!p.mHideProgress && (max != 0 || ind)) {
                contentView.setViewVisibility(16908301, 0);
                contentView.setProgressBar(16908301, max, progress, ind);
                contentView.setProgressBackgroundTintList(16908301, this.mContext.getColorStateList(17170981));
                ColorStateList progressTint = ColorStateList.valueOf(this.getPrimaryAccentColor(p));
                contentView.setProgressTintList(16908301, progressTint);
                contentView.setProgressIndeterminateTintList(16908301, progressTint);
                return true;
            }
            contentView.setViewVisibility(16908301, 8);
            return false;
        }

        private void bindLargeIconAndApplyMargin(RemoteViews contentView, StandardTemplateParams p, TemplateBindResult result) {
            if (result == null) {
                result = new TemplateBindResult();
            }
            this.bindLargeIcon(contentView, p, result);
            if (!p.mHeaderless) {
                result.mHeadingExtraMarginSet.applyToView(contentView, 16909283);
                result.mTitleMarginSet.applyToView(contentView, 16908310);
                result.mTitleMarginSet.applyToView(contentView, p.mTextViewId);
                contentView.setInt(p.mTextViewId, "setNumIndentLines", p.hasTitle() ? 0 : 1);
            }
        }

        private void calculateRightIconDimens(Icon rightIcon, boolean isPromotedPicture, TemplateBindResult result) {
            int iconHeight;
            int iconWidth;
            Drawable drawable2;
            float viewHeightDp;
            Resources resources = this.mContext.getResources();
            float density = resources.getDisplayMetrics().density;
            float iconMarginDp = resources.getDimension(17105427) / density;
            float contentMarginDp = resources.getDimension(17105383) / density;
            float expanderSizeDp = resources.getDimension(17105396) / density - contentMarginDp;
            float viewWidthDp = viewHeightDp = resources.getDimension(17105429) / density;
            if (rightIcon != null && (isPromotedPicture || this.mContext.getApplicationInfo().targetSdkVersion >= 31) && (drawable2 = rightIcon.loadDrawable(this.mContext)) != null && (iconWidth = drawable2.getIntrinsicWidth()) > (iconHeight = drawable2.getIntrinsicHeight()) && iconHeight > 0) {
                float maxViewWidthDp = viewHeightDp * 1.7777778f;
                viewWidthDp = Math.min(viewHeightDp * (float)iconWidth / (float)iconHeight, maxViewWidthDp);
            }
            float extraMarginEndDpIfVisible = viewWidthDp + iconMarginDp;
            result.setRightIconState(rightIcon != null, viewWidthDp, viewHeightDp, extraMarginEndDpIfVisible, expanderSizeDp);
        }

        private void bindLargeIcon(RemoteViews contentView, StandardTemplateParams p, TemplateBindResult result) {
            Icon rightIcon;
            Icon leftIcon;
            if (this.mN.mLargeIcon == null && this.mN.largeIcon != null) {
                this.mN.mLargeIcon = Icon.createWithBitmap(this.mN.largeIcon);
            }
            Icon icon = leftIcon = p.mHideLeftIcon ? null : this.mN.mLargeIcon;
            Icon icon2 = p.mHideRightIcon ? null : (rightIcon = p.mPromotedPicture != null ? p.mPromotedPicture : this.mN.mLargeIcon);
            if (leftIcon != rightIcon || leftIcon == null) {
                contentView.setImageViewIcon(16909175, leftIcon);
                contentView.setIntTag(16909175, 16909578, 0);
            } else {
                contentView.setIntTag(16909175, 16909578, 1);
            }
            boolean isPromotedPicture = p.mPromotedPicture != null;
            this.calculateRightIconDimens(rightIcon, isPromotedPicture, result);
            if (rightIcon != null) {
                contentView.setViewLayoutWidth(16909431, result.mRightIconWidthDp, 1);
                contentView.setViewLayoutHeight(16909431, result.mRightIconHeightDp, 1);
                contentView.setViewVisibility(16909431, 0);
                contentView.setImageViewIcon(16909431, rightIcon);
                contentView.setIntTag(16909431, 16909572, isPromotedPicture ? 1 : 0);
                this.processLargeLegacyIcon(rightIcon, contentView, p);
            } else {
                contentView.setImageViewIcon(16909431, null);
                contentView.setIntTag(16909431, 16909572, 0);
            }
        }

        private void bindNotificationHeader(RemoteViews contentView, StandardTemplateParams p) {
            this.bindSmallIcon(contentView, p);
            boolean hasTextToLeft = this.bindHeaderAppName(contentView, p, false);
            hasTextToLeft |= this.bindHeaderTextSecondary(contentView, p, hasTextToLeft);
            hasTextToLeft |= this.bindHeaderText(contentView, p, hasTextToLeft);
            if (!hasTextToLeft) {
                hasTextToLeft |= this.bindHeaderAppName(contentView, p, true);
            }
            this.bindHeaderChronometerAndTime(contentView, p, hasTextToLeft);
            this.bindPhishingAlertIcon(contentView, p);
            this.bindProfileBadge(contentView, p);
            this.bindAlertedIcon(contentView, p);
            this.bindExpandButton(contentView, p);
            this.mN.mUsesStandardHeader = true;
        }

        private void bindExpandButton(RemoteViews contentView, StandardTemplateParams p) {
            int bgColor = this.getBackgroundColor(p);
            int pillColor = Colors.flattenAlpha(this.getColors(p).getProtectionColor(), bgColor);
            int textColor = Colors.flattenAlpha(this.getPrimaryTextColor(p), pillColor);
            contentView.setInt(16908982, "setDefaultTextColor", textColor);
            contentView.setInt(16908982, "setDefaultPillColor", pillColor);
            if (p.mHighlightExpander) {
                pillColor = Colors.flattenAlpha(this.getColors(p).getTertiaryAccentColor(), bgColor);
                textColor = Colors.flattenAlpha(this.getColors(p).getOnAccentTextColor(), pillColor);
            }
            contentView.setInt(16908982, "setHighlightTextColor", textColor);
            contentView.setInt(16908982, "setHighlightPillColor", pillColor);
        }

        private void bindHeaderChronometerAndTime(RemoteViews contentView, StandardTemplateParams p, boolean hasTextToLeft) {
            if (!p.mHideTime && this.showsTimeOrChronometer()) {
                if (hasTextToLeft) {
                    contentView.setViewVisibility(16909614, 0);
                    this.setTextViewColorSecondary(contentView, 16909614, p);
                }
                if (this.mN.extras.getBoolean(Notification.EXTRA_SHOW_CHRONOMETER)) {
                    contentView.setViewVisibility(16908876, 0);
                    contentView.setLong(16908876, "setBase", this.mN.when + (SystemClock.elapsedRealtime() - System_Delegate.currentTimeMillis()));
                    contentView.setBoolean(16908876, "setStarted", true);
                    boolean countsDown = this.mN.extras.getBoolean(Notification.EXTRA_CHRONOMETER_COUNT_DOWN);
                    contentView.setChronometerCountDown(16908876, countsDown);
                    this.setTextViewColorSecondary(contentView, 16908876, p);
                } else {
                    contentView.setViewVisibility(16909610, 0);
                    contentView.setLong(16909610, "setTime", this.mN.when);
                    this.setTextViewColorSecondary(contentView, 16909610, p);
                }
            } else {
                contentView.setLong(16909610, "setTime", this.mN.when != 0L ? this.mN.when : this.mN.creationTime);
                this.setTextViewColorSecondary(contentView, 16909610, p);
            }
        }

        private boolean bindHeaderText(RemoteViews contentView, StandardTemplateParams p, boolean hasTextToLeft) {
            if (p.mHideSubText) {
                return false;
            }
            CharSequence summaryText = p.summaryText;
            if (summaryText == null && this.mStyle != null && this.mStyle.mSummaryTextSet && this.mStyle.hasSummaryInHeader()) {
                summaryText = this.mStyle.mSummaryText;
            }
            if (summaryText == null && this.mContext.getApplicationInfo().targetSdkVersion < 24 && this.mN.extras.getCharSequence(Notification.EXTRA_INFO_TEXT) != null) {
                summaryText = this.mN.extras.getCharSequence(Notification.EXTRA_INFO_TEXT);
            }
            if (!TextUtils.isEmpty(summaryText)) {
                contentView.setTextViewText(16909073, this.processTextSpans(this.processLegacyText(summaryText)));
                this.setTextViewColorSecondary(contentView, 16909073, p);
                contentView.setViewVisibility(16909073, 0);
                if (hasTextToLeft) {
                    contentView.setViewVisibility(16909074, 0);
                    this.setTextViewColorSecondary(contentView, 16909074, p);
                }
                return true;
            }
            return false;
        }

        private boolean bindHeaderTextSecondary(RemoteViews contentView, StandardTemplateParams p, boolean hasTextToLeft) {
            if (p.mHideSubText) {
                return false;
            }
            if (!TextUtils.isEmpty(p.headerTextSecondary)) {
                contentView.setTextViewText(16909075, this.processTextSpans(this.processLegacyText(p.headerTextSecondary)));
                this.setTextViewColorSecondary(contentView, 16909075, p);
                contentView.setViewVisibility(16909075, 0);
                if (hasTextToLeft) {
                    contentView.setViewVisibility(16909076, 0);
                    this.setTextViewColorSecondary(contentView, 16909076, p);
                }
                return true;
            }
            return false;
        }

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public String loadHeaderAppName() {
            CharSequence name = null;
            PackageManager pm = this.mContext.getPackageManager();
            if (this.mN.extras.containsKey(Notification.EXTRA_SUBSTITUTE_APP_NAME)) {
                String pkg = this.mContext.getPackageName();
                String subName = this.mN.extras.getString(Notification.EXTRA_SUBSTITUTE_APP_NAME);
                if (0 == pm.checkPermission("android.permission.SUBSTITUTE_NOTIFICATION_APP_NAME", pkg)) {
                    name = subName;
                } else {
                    Log.w(Notification.TAG, "warning: pkg " + pkg + " attempting to substitute app name '" + subName + "' without holding perm " + "android.permission.SUBSTITUTE_NOTIFICATION_APP_NAME");
                }
            }
            if (TextUtils.isEmpty(name)) {
                name = pm.getApplicationLabel(this.mContext.getApplicationInfo());
            }
            if (TextUtils.isEmpty(name)) {
                return null;
            }
            return String.valueOf(name);
        }

        private boolean bindHeaderAppName(RemoteViews contentView, StandardTemplateParams p, boolean force) {
            if (p.mViewType == StandardTemplateParams.VIEW_TYPE_MINIMIZED && !force) {
                return false;
            }
            if (p.mHeaderless && p.hasTitle()) {
                return true;
            }
            if (p.mHideAppName) {
                return p.hasTitle();
            }
            contentView.setViewVisibility(16908784, 0);
            contentView.setTextViewText(16908784, this.loadHeaderAppName());
            contentView.setTextColor(16908784, this.getSecondaryTextColor(p));
            return true;
        }

        private boolean isBackgroundColorized(StandardTemplateParams p) {
            return p.allowColorization && this.mN.isColorized();
        }

        private boolean isCallActionColorCustomizable() {
            return this.mN.isColorized() && this.mContext.getResources().getBoolean(17891397);
        }

        private void bindSmallIcon(RemoteViews contentView, StandardTemplateParams p) {
            if (this.mN.mSmallIcon == null && this.mN.icon != 0) {
                this.mN.mSmallIcon = Icon.createWithResource(this.mContext, this.mN.icon);
            }
            contentView.setImageViewIcon(16908294, this.mN.mSmallIcon);
            contentView.setInt(16908294, "setImageLevel", this.mN.iconLevel);
            this.processSmallIconColor(this.mN.mSmallIcon, contentView, p);
        }

        private boolean showsTimeOrChronometer() {
            return this.mN.showsTime() || this.mN.showsChronometer();
        }

        private void resetStandardTemplateWithActions(RemoteViews big) {
            big.setViewVisibility(16908743, 8);
            big.removeAllViews(16908743);
            big.setViewVisibility(16909287, 8);
            big.setTextViewText(16909289, null);
            big.setViewVisibility(16909290, 8);
            big.setViewVisibility(16909288, 8);
            big.setViewVisibility(16909291, 8);
            big.setTextViewText(16909291, null);
            big.setViewVisibility(16909292, 8);
            big.setTextViewText(16909292, null);
            big.setViewLayoutMarginDimen(16909281, 3, 17105382);
        }

        private void bindSnoozeAction(RemoteViews big, StandardTemplateParams p) {
            boolean snoozeEnabled;
            boolean hideSnoozeButton = this.mN.isForegroundService() || this.mN.fullScreenIntent != null || this.isBackgroundColorized(p) || p.mViewType != StandardTemplateParams.VIEW_TYPE_BIG;
            big.setBoolean(16909519, "setEnabled", !hideSnoozeButton);
            if (hideSnoozeButton) {
                big.setViewVisibility(16909519, 8);
            }
            boolean bl = snoozeEnabled = !hideSnoozeButton && this.mContext.getContentResolver() != null && this.isSnoozeSettingEnabled();
            if (snoozeEnabled) {
                big.setViewLayoutMarginDimen(16909281, 3, 0);
            }
        }

        private boolean isSnoozeSettingEnabled() {
            try {
                return Settings.Secure.getInt(this.mContext.getContentResolver(), "show_notification_snooze", 0) == 1;
            }
            catch (SecurityException ex) {
                return false;
            }
        }

        private List<Action> getNonContextualActions() {
            if (this.mActions == null) {
                return Collections.emptyList();
            }
            ArrayList<Action> standardActions = new ArrayList<Action>();
            for (Action action : this.mActions) {
                if (action.isContextual()) continue;
                standardActions.add(action);
            }
            return standardActions;
        }

        private RemoteViews applyStandardTemplateWithActions(int layoutId, StandardTemplateParams p, TemplateBindResult result) {
            boolean emphazisedMode;
            RemoteViews big = this.applyStandardTemplate(layoutId, p, result);
            this.resetStandardTemplateWithActions(big);
            this.bindSnoozeAction(big, p);
            ColorStateList actionColor = ColorStateList.valueOf(this.getStandardActionColor(p));
            big.setColorStateList(16909519, "setImageTintList", actionColor);
            big.setColorStateList(16908831, "setImageTintList", actionColor);
            boolean validRemoteInput = false;
            List<Action> nonContextualActions = this.getNonContextualActions();
            int numActions = Math.min(nonContextualActions.size(), 3);
            boolean bl = emphazisedMode = this.mN.fullScreenIntent != null || p.mCallStyleActions;
            if (p.mCallStyleActions) {
                big.setViewPadding(16908743, 0, 0, 0, 0);
                big.setInt(16908743, "setCollapsibleIndentDimen", 17104975);
            }
            big.setBoolean(16908743, "setEmphasizedMode", emphazisedMode);
            if (numActions > 0 && !p.mHideActions) {
                big.setViewVisibility(16908744, 0);
                big.setViewVisibility(16908743, 0);
                big.setViewLayoutMarginDimen(16909281, 3, 0);
                for (int i = 0; i < numActions; ++i) {
                    Action action = nonContextualActions.get(i);
                    boolean actionHasValidInput = this.hasValidRemoteInput(action);
                    validRemoteInput |= actionHasValidInput;
                    RemoteViews button = this.generateActionButton(action, emphazisedMode, p);
                    if (actionHasValidInput && !emphazisedMode) {
                        button.setInt(16908718, "setBackgroundResource", 0);
                    }
                    if (emphazisedMode && i > 0) {
                        button.setViewLayoutMarginDimen(16908718, 4, 0);
                    }
                    big.addView(16908743, button);
                }
            } else {
                big.setViewVisibility(16908744, 8);
            }
            RemoteInputHistoryItem[] replyText = (RemoteInputHistoryItem[])Notification.getParcelableArrayFromBundle((Bundle)this.mN.extras, (String)Notification.EXTRA_REMOTE_INPUT_HISTORY_ITEMS, RemoteInputHistoryItem.class);
            if (validRemoteInput && replyText != null && replyText.length > 0 && !TextUtils.isEmpty(replyText[0].getText()) && p.maxRemoteInputHistory > 0) {
                boolean showSpinner = this.mN.extras.getBoolean(Notification.EXTRA_SHOW_REMOTE_INPUT_SPINNER);
                big.setViewVisibility(16909287, 0);
                big.setViewVisibility(16909290, 0);
                big.setTextViewText(16909289, this.processTextSpans(replyText[0].getText()));
                this.setTextViewColorSecondary(big, 16909289, p);
                big.setViewVisibility(16909288, showSpinner ? 0 : 8);
                big.setProgressIndeterminateTintList(16909288, ColorStateList.valueOf(this.getPrimaryAccentColor(p)));
                if (replyText.length > 1 && !TextUtils.isEmpty(replyText[1].getText()) && p.maxRemoteInputHistory > 1) {
                    big.setViewVisibility(16909291, 0);
                    big.setTextViewText(16909291, this.processTextSpans(replyText[1].getText()));
                    this.setTextViewColorSecondary(big, 16909291, p);
                    if (replyText.length > 2 && !TextUtils.isEmpty(replyText[2].getText()) && p.maxRemoteInputHistory > 2) {
                        big.setViewVisibility(16909292, 0);
                        big.setTextViewText(16909292, this.processTextSpans(replyText[2].getText()));
                        this.setTextViewColorSecondary(big, 16909292, p);
                    }
                }
            }
            return big;
        }

        private boolean hasValidRemoteInput(Action action) {
            if (TextUtils.isEmpty(action.title) || action.actionIntent == null) {
                return false;
            }
            RemoteInput[] remoteInputs = action.getRemoteInputs();
            if (remoteInputs == null) {
                return false;
            }
            for (RemoteInput r : remoteInputs) {
                CharSequence[] choices = r.getChoices();
                if (!r.getAllowFreeFormInput() && (choices == null || choices.length == 0)) continue;
                return true;
            }
            return false;
        }

        public RemoteViews createContentView() {
            return this.createContentView(false);
        }

        private boolean fullyCustomViewRequiresDecoration(boolean fromStyle) {
            if (fromStyle && PLATFORM_STYLE_CLASSES.contains(this.mStyle.getClass())) {
                return false;
            }
            return this.mContext.getApplicationInfo().targetSdkVersion >= 31;
        }

        private RemoteViews minimallyDecoratedContentView(RemoteViews customContent) {
            StandardTemplateParams p = this.mParams.reset().viewType(StandardTemplateParams.VIEW_TYPE_NORMAL).decorationType(1).fillTextsFrom(this);
            TemplateBindResult result = new TemplateBindResult();
            RemoteViews standard = this.applyStandardTemplate(this.getBaseLayoutResource(), p, result);
            Notification.buildCustomContentIntoTemplate(this.mContext, standard, customContent, p, result);
            return standard;
        }

        private RemoteViews minimallyDecoratedBigContentView(RemoteViews customContent) {
            StandardTemplateParams p = this.mParams.reset().viewType(StandardTemplateParams.VIEW_TYPE_BIG).decorationType(1).fillTextsFrom(this);
            TemplateBindResult result = new TemplateBindResult();
            RemoteViews standard = this.applyStandardTemplateWithActions(this.getBigBaseLayoutResource(), p, result);
            Notification.buildCustomContentIntoTemplate(this.mContext, standard, customContent, p, result);
            Builder.makeHeaderExpanded(standard);
            return standard;
        }

        private RemoteViews minimallyDecoratedHeadsUpContentView(RemoteViews customContent) {
            StandardTemplateParams p = this.mParams.reset().viewType(StandardTemplateParams.VIEW_TYPE_HEADS_UP).decorationType(1).fillTextsFrom(this);
            TemplateBindResult result = new TemplateBindResult();
            RemoteViews standard = this.applyStandardTemplateWithActions(this.getHeadsUpBaseLayoutResource(), p, result);
            Notification.buildCustomContentIntoTemplate(this.mContext, standard, customContent, p, result);
            return standard;
        }

        public RemoteViews createContentView(boolean increasedHeight) {
            RemoteViews styleView;
            if (this.useExistingRemoteView(this.mN.contentView)) {
                return this.fullyCustomViewRequiresDecoration(false) ? this.minimallyDecoratedContentView(this.mN.contentView) : this.mN.contentView;
            }
            if (this.mStyle != null && (styleView = this.mStyle.makeContentView(increasedHeight)) != null) {
                return this.fullyCustomViewRequiresDecoration(true) ? this.minimallyDecoratedContentView(styleView) : styleView;
            }
            StandardTemplateParams p = this.mParams.reset().viewType(StandardTemplateParams.VIEW_TYPE_NORMAL).fillTextsFrom(this);
            return this.applyStandardTemplate(this.getBaseLayoutResource(), p, null);
        }

        private boolean useExistingRemoteView(RemoteViews customContent) {
            if (customContent == null) {
                return false;
            }
            if (this.styleDisplaysCustomViewInline()) {
                return false;
            }
            if (this.fullyCustomViewRequiresDecoration(false) && STANDARD_LAYOUTS.contains(customContent.getLayoutId())) {
                Log.w(Notification.TAG, "For apps targeting S, a custom content view that is a modified version of any standard layout is disallowed.");
                return false;
            }
            return true;
        }

        public RemoteViews createBigContentView() {
            RemoteViews result = null;
            if (this.useExistingRemoteView(this.mN.bigContentView)) {
                return this.fullyCustomViewRequiresDecoration(false) ? this.minimallyDecoratedBigContentView(this.mN.bigContentView) : this.mN.bigContentView;
            }
            if (this.mStyle != null) {
                result = this.mStyle.makeBigContentView();
                if (this.fullyCustomViewRequiresDecoration(true)) {
                    result = this.minimallyDecoratedBigContentView(result);
                }
            }
            if (result == null && this.bigContentViewRequired()) {
                StandardTemplateParams p = this.mParams.reset().viewType(StandardTemplateParams.VIEW_TYPE_BIG).allowTextWithProgress(true).fillTextsFrom(this);
                result = this.applyStandardTemplateWithActions(this.getBigBaseLayoutResource(), p, null);
            }
            Builder.makeHeaderExpanded(result);
            return result;
        }

        private boolean bigContentViewRequired() {
            if (this.mContext.getApplicationInfo().targetSdkVersion >= 31) {
                return true;
            }
            boolean exempt = this.mN.contentView != null && this.mN.bigContentView == null && this.mStyle == null && this.mActions.size() == 0;
            return !exempt;
        }

        public RemoteViews makeNotificationGroupHeader() {
            return this.makeNotificationHeader(this.mParams.reset().viewType(StandardTemplateParams.VIEW_TYPE_GROUP_HEADER).fillTextsFrom(this));
        }

        private RemoteViews makeNotificationHeader(StandardTemplateParams p) {
            p.disallowColorization();
            BuilderRemoteViews header = new BuilderRemoteViews(this.mContext.getApplicationInfo(), 17367220);
            this.resetNotificationHeader(header);
            this.bindNotificationHeader(header, p);
            return header;
        }

        public RemoteViews makeAmbientNotification() {
            RemoteViews headsUpContentView = this.createHeadsUpContentView(false);
            if (headsUpContentView != null) {
                return headsUpContentView;
            }
            return this.createContentView();
        }

        public static void makeHeaderExpanded(RemoteViews result) {
            if (result != null) {
                result.setBoolean(16908982, "setExpanded", true);
            }
        }

        public RemoteViews createHeadsUpContentView(boolean increasedHeight) {
            if (this.useExistingRemoteView(this.mN.headsUpContentView)) {
                return this.fullyCustomViewRequiresDecoration(false) ? this.minimallyDecoratedHeadsUpContentView(this.mN.headsUpContentView) : this.mN.headsUpContentView;
            }
            if (this.mStyle != null) {
                RemoteViews styleView = this.mStyle.makeHeadsUpContentView(increasedHeight);
                if (styleView != null) {
                    return this.fullyCustomViewRequiresDecoration(true) ? this.minimallyDecoratedHeadsUpContentView(styleView) : styleView;
                }
            } else if (this.mActions.size() == 0) {
                return null;
            }
            StandardTemplateParams p = this.mParams.reset().viewType(StandardTemplateParams.VIEW_TYPE_HEADS_UP).fillTextsFrom(this).setMaxRemoteInputHistory(1);
            return this.applyStandardTemplateWithActions(this.getHeadsUpBaseLayoutResource(), p, null);
        }

        public RemoteViews createHeadsUpContentView() {
            return this.createHeadsUpContentView(false);
        }

        @UnsupportedAppUsage
        public RemoteViews makePublicContentView(boolean isLowPriority) {
            if (this.mN.publicVersion != null) {
                Builder builder = Builder.recoverBuilder(this.mContext, this.mN.publicVersion);
                return builder.createContentView();
            }
            Bundle savedBundle = this.mN.extras;
            Style style2 = this.mStyle;
            this.mStyle = null;
            Icon largeIcon = this.mN.mLargeIcon;
            this.mN.mLargeIcon = null;
            Bitmap largeIconLegacy = this.mN.largeIcon;
            this.mN.largeIcon = null;
            ArrayList<Action> actions = this.mActions;
            this.mActions = new ArrayList();
            Bundle publicExtras = new Bundle();
            publicExtras.putBoolean(Notification.EXTRA_SHOW_WHEN, savedBundle.getBoolean(Notification.EXTRA_SHOW_WHEN));
            publicExtras.putBoolean(Notification.EXTRA_SHOW_CHRONOMETER, savedBundle.getBoolean(Notification.EXTRA_SHOW_CHRONOMETER));
            publicExtras.putBoolean(Notification.EXTRA_CHRONOMETER_COUNT_DOWN, savedBundle.getBoolean(Notification.EXTRA_CHRONOMETER_COUNT_DOWN));
            String appName = savedBundle.getString(Notification.EXTRA_SUBSTITUTE_APP_NAME);
            if (appName != null) {
                publicExtras.putString(Notification.EXTRA_SUBSTITUTE_APP_NAME, appName);
            }
            this.mN.extras = publicExtras;
            StandardTemplateParams params = this.mParams.reset().viewType(StandardTemplateParams.VIEW_TYPE_PUBLIC).fillTextsFrom(this);
            if (isLowPriority) {
                params.highlightExpander(false);
            }
            RemoteViews view = this.makeNotificationHeader(params);
            view.setBoolean(16909283, "setExpandOnlyOnButton", true);
            this.mN.extras = savedBundle;
            this.mN.mLargeIcon = largeIcon;
            this.mN.largeIcon = largeIconLegacy;
            this.mActions = actions;
            this.mStyle = style2;
            return view;
        }

        public RemoteViews makeLowPriorityContentView(boolean useRegularSubtext) {
            StandardTemplateParams p = this.mParams.reset().viewType(StandardTemplateParams.VIEW_TYPE_MINIMIZED).highlightExpander(false).fillTextsFrom(this);
            if (!useRegularSubtext || TextUtils.isEmpty(p.summaryText)) {
                p.summaryText(this.createSummaryText());
            }
            RemoteViews header = this.makeNotificationHeader(p);
            header.setBoolean(16909283, "setAcceptAllTouches", true);
            header.setBoolean(16909283, "styleTextAsTitle", true);
            return header;
        }

        private CharSequence createSummaryText() {
            CharSequence titleText = this.mN.extras.getCharSequence(Notification.EXTRA_TITLE);
            if (USE_ONLY_TITLE_IN_LOW_PRIORITY_SUMMARY) {
                return titleText;
            }
            SpannableStringBuilder summary = new SpannableStringBuilder();
            if (titleText == null) {
                titleText = this.mN.extras.getCharSequence(Notification.EXTRA_TITLE_BIG);
            }
            BidiFormatter bidi = BidiFormatter.getInstance();
            if (titleText != null) {
                summary.append(bidi.unicodeWrap(titleText));
            }
            CharSequence contentText = this.mN.extras.getCharSequence(Notification.EXTRA_TEXT);
            if (titleText != null && contentText != null) {
                summary.append(bidi.unicodeWrap(this.mContext.getText(17040914)));
            }
            if (contentText != null) {
                summary.append(bidi.unicodeWrap(contentText));
            }
            return summary;
        }

        private RemoteViews generateActionButton(Action action, boolean emphasizedMode, StandardTemplateParams p) {
            boolean tombstone = action.actionIntent == null;
            BuilderRemoteViews button = new BuilderRemoteViews(this.mContext.getApplicationInfo(), emphasizedMode ? this.getEmphasizedActionLayoutResource() : (tombstone ? this.getActionTombstoneLayoutResource() : this.getActionLayoutResource()));
            if (!tombstone) {
                button.setOnClickPendingIntent(16908718, action.actionIntent);
            }
            button.setContentDescription(16908718, action.title);
            if (action.mRemoteInputs != null) {
                button.setRemoteInputs(16908718, action.mRemoteInputs);
            }
            if (emphasizedMode) {
                CharSequence title = action.title;
                int buttonFillColor = this.getColors(p).getSecondaryAccentColor();
                if (this.isLegacy()) {
                    title = ContrastColorUtil.clearColorSpans(title);
                } else {
                    Integer fullLengthColor = Builder.getFullLengthSpanColor(title);
                    if (fullLengthColor != null) {
                        int notifBackgroundColor = this.getColors(p).getBackgroundColor();
                        buttonFillColor = Builder.ensureButtonFillContrast(fullLengthColor, notifBackgroundColor);
                    }
                    title = Builder.ensureColorSpanContrast(title, buttonFillColor);
                }
                button.setTextViewText(16908718, this.processTextSpans(title));
                int textColor = ContrastColorUtil.resolvePrimaryColor(this.mContext, buttonFillColor, this.mInNightMode);
                button.setTextColor(16908718, textColor);
                int rippleColor = textColor & 0xFFFFFF | 0x33000000;
                button.setColorStateList(16908718, "setRippleColor", ColorStateList.valueOf(rippleColor));
                button.setColorStateList(16908718, "setButtonBackground", ColorStateList.valueOf(buttonFillColor));
                if (p.mCallStyleActions) {
                    button.setImageViewIcon(16908718, action.getIcon());
                    boolean priority = action.getExtras().getBoolean("key_action_priority");
                    button.setBoolean(16908718, "setIsPriority", priority);
                    int minWidthDimen = priority ? 0x1050050 : 0;
                    button.setIntDimen(16908718, "setMinimumWidth", minWidthDimen);
                }
            } else {
                button.setTextViewText(16908718, this.processTextSpans(this.processLegacyText(action.title)));
                button.setTextColor(16908718, this.getStandardActionColor(p));
            }
            int actionIndex = this.mActions.indexOf(action);
            if (actionIndex != -1) {
                button.setIntTag(16908718, 16909280, actionIndex);
            }
            return button;
        }

        @VisibleForTesting
        public static Integer getFullLengthSpanColor(CharSequence charSequence) {
            Integer result = null;
            if (charSequence instanceof Spanned) {
                Object[] spans;
                Spanned ss = (Spanned)charSequence;
                for (Object span : spans = ss.getSpans(0, ss.length(), Object.class)) {
                    CharacterStyle originalSpan;
                    boolean fullLength;
                    int spanStart = ss.getSpanStart(span);
                    int spanEnd = ss.getSpanEnd(span);
                    boolean bl = fullLength = spanEnd - spanStart == charSequence.length();
                    if (!fullLength) continue;
                    if (span instanceof TextAppearanceSpan) {
                        originalSpan = (TextAppearanceSpan)span;
                        ColorStateList textColor = ((TextAppearanceSpan)originalSpan).getTextColor();
                        if (textColor == null) continue;
                        result = textColor.getDefaultColor();
                        continue;
                    }
                    if (!(span instanceof ForegroundColorSpan)) continue;
                    originalSpan = (ForegroundColorSpan)span;
                    result = ((ForegroundColorSpan)originalSpan).getForegroundColor();
                }
            }
            return result;
        }

        @VisibleForTesting
        public static CharSequence ensureColorSpanContrast(CharSequence charSequence, int background) {
            if (charSequence instanceof Spanned) {
                Spanned ss = (Spanned)charSequence;
                Object[] spans = ss.getSpans(0, ss.length(), Object.class);
                SpannableStringBuilder builder = new SpannableStringBuilder(ss.toString());
                Object[] objectArray = spans;
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    CharacterStyle originalSpan;
                    boolean fullLength;
                    Object span;
                    Object resultSpan = span = objectArray[i];
                    int spanStart = ss.getSpanStart(span);
                    int spanEnd = ss.getSpanEnd(span);
                    boolean bl = fullLength = spanEnd - spanStart == charSequence.length();
                    if (resultSpan instanceof CharacterStyle) {
                        resultSpan = ((CharacterStyle)span).getUnderlying();
                    }
                    if (resultSpan instanceof TextAppearanceSpan) {
                        originalSpan = (TextAppearanceSpan)resultSpan;
                        ColorStateList textColor = ((TextAppearanceSpan)originalSpan).getTextColor();
                        if (textColor != null) {
                            if (fullLength) {
                                textColor = null;
                            } else {
                                int[] colors = textColor.getColors();
                                int[] newColors = new int[colors.length];
                                for (int i2 = 0; i2 < newColors.length; ++i2) {
                                    boolean isBgDark = Builder.isColorDark(background);
                                    newColors[i2] = ContrastColorUtil.ensureLargeTextContrast(colors[i2], background, isBgDark);
                                }
                                textColor = new ColorStateList((int[][])textColor.getStates().clone(), newColors);
                            }
                            resultSpan = new TextAppearanceSpan(((TextAppearanceSpan)originalSpan).getFamily(), ((TextAppearanceSpan)originalSpan).getTextStyle(), ((TextAppearanceSpan)originalSpan).getTextSize(), textColor, ((TextAppearanceSpan)originalSpan).getLinkTextColor());
                        }
                    } else if (resultSpan instanceof ForegroundColorSpan) {
                        if (fullLength) {
                            resultSpan = null;
                        } else {
                            originalSpan = (ForegroundColorSpan)resultSpan;
                            int foregroundColor = ((ForegroundColorSpan)originalSpan).getForegroundColor();
                            boolean isBgDark = Builder.isColorDark(background);
                            foregroundColor = ContrastColorUtil.ensureLargeTextContrast(foregroundColor, background, isBgDark);
                            resultSpan = new ForegroundColorSpan(foregroundColor);
                        }
                    } else {
                        resultSpan = span;
                    }
                    if (resultSpan == null) continue;
                    builder.setSpan(resultSpan, spanStart, spanEnd, ss.getSpanFlags(span));
                }
                return builder;
            }
            return charSequence;
        }

        public static boolean isColorDark(int color2) {
            return ContrastColorUtil.calculateLuminance(color2) <= 0.17912878474;
        }

        @VisibleForTesting
        public static int ensureButtonFillContrast(int color2, int bg) {
            return Builder.isColorDark(bg) ? ContrastColorUtil.findContrastColorAgainstDark(color2, bg, true, 1.3) : ContrastColorUtil.findContrastColor(color2, bg, true, 1.3);
        }

        private boolean isLegacy() {
            if (!this.mIsLegacyInitialized) {
                this.mIsLegacy = this.mContext.getApplicationInfo().targetSdkVersion < 21;
                this.mIsLegacyInitialized = true;
            }
            return this.mIsLegacy;
        }

        private CharSequence processLegacyText(CharSequence charSequence) {
            boolean isAlreadyLightText;
            boolean bl = isAlreadyLightText = this.isLegacy() || this.textColorsNeedInversion();
            if (isAlreadyLightText) {
                return this.getColorUtil().invertCharSequenceColors(charSequence);
            }
            return charSequence;
        }

        private void processSmallIconColor(Icon smallIcon, RemoteViews contentView, StandardTemplateParams p) {
            boolean colorable = !this.isLegacy() || this.getColorUtil().isGrayscaleIcon(this.mContext, smallIcon);
            int color2 = this.getSmallIconColor(p);
            contentView.setInt(16908294, "setBackgroundColor", this.getBackgroundColor(p));
            contentView.setInt(16908294, "setOriginalIconColor", colorable ? color2 : 1);
        }

        private void processLargeLegacyIcon(Icon largeIcon, RemoteViews contentView, StandardTemplateParams p) {
            if (largeIcon != null && this.isLegacy() && this.getColorUtil().isGrayscaleIcon(this.mContext, largeIcon)) {
                int color2 = this.getSmallIconColor(p);
                contentView.setInt(16908294, "setOriginalIconColor", color2);
            }
        }

        private void sanitizeColor() {
            if (this.mN.color != 0) {
                this.mN.color |= 0xFF000000;
            }
        }

        private int getStandardActionColor(StandardTemplateParams p) {
            return this.mTintActionButtons || this.isBackgroundColorized(p) ? this.getPrimaryAccentColor(p) : this.getSecondaryTextColor(p);
        }

        private int getSmallIconColor(StandardTemplateParams p) {
            return this.getColors(p).getContrastColor();
        }

        private int getPrimaryAccentColor(StandardTemplateParams p) {
            return this.getColors(p).getPrimaryAccentColor();
        }

        public Notification buildUnstyled() {
            if (this.mActions.size() > 0) {
                this.mN.actions = new Action[this.mActions.size()];
                this.mActions.toArray(this.mN.actions);
            }
            if (!this.mPersonList.isEmpty()) {
                this.mN.extras.putParcelableArrayList(Notification.EXTRA_PEOPLE_LIST, this.mPersonList);
            }
            if (this.mN.bigContentView != null || this.mN.contentView != null || this.mN.headsUpContentView != null) {
                this.mN.extras.putBoolean(Notification.EXTRA_CONTAINS_CUSTOM_VIEW, true);
            }
            return this.mN;
        }

        public static Builder recoverBuilder(Context context, Notification n) {
            Context builderContext;
            ApplicationInfo applicationInfo = n.extras.getParcelable(Notification.EXTRA_BUILDER_APPLICATION_INFO, ApplicationInfo.class);
            if (applicationInfo != null) {
                try {
                    builderContext = context.createApplicationContext(applicationInfo, 4);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.e(Notification.TAG, "ApplicationInfo " + applicationInfo + " not found");
                    builderContext = context;
                }
            } else {
                builderContext = context;
            }
            return new Builder(builderContext, n);
        }

        public Builder setAllowSystemGeneratedContextualActions(boolean allowed) {
            this.mN.mAllowSystemGeneratedContextualActions = allowed;
            return this;
        }

        @Deprecated
        public Notification getNotification() {
            return this.build();
        }

        public Notification build() {
            if (this.mN.mShortcutId != null && this.mN.mBubbleMetadata != null && this.mN.mBubbleMetadata.getShortcutId() != null && !this.mN.mShortcutId.equals(this.mN.mBubbleMetadata.getShortcutId())) {
                throw new IllegalArgumentException("Notification and BubbleMetadata shortcut id's don't match, notification: " + this.mN.mShortcutId + " vs bubble: " + this.mN.mBubbleMetadata.getShortcutId());
            }
            if (this.mUserExtras != null) {
                this.mN.extras = this.getAllExtras();
            }
            this.mN.creationTime = System_Delegate.currentTimeMillis();
            Notification.addFieldsFromContext(this.mContext, this.mN);
            this.buildUnstyled();
            if (this.mStyle != null) {
                this.mStyle.reduceImageSizes(this.mContext);
                this.mStyle.purgeResources();
                this.mStyle.validate(this.mContext);
                this.mStyle.buildStyled(this.mN);
            }
            this.mN.reduceImageSizes(this.mContext);
            if (this.mContext.getApplicationInfo().targetSdkVersion < 24 && !this.styleDisplaysCustomViewInline()) {
                RemoteViews newContentView = this.mN.contentView;
                RemoteViews newBigContentView = this.mN.bigContentView;
                RemoteViews newHeadsUpContentView = this.mN.headsUpContentView;
                if (newContentView == null) {
                    newContentView = this.createContentView();
                    this.mN.extras.putInt(EXTRA_REBUILD_CONTENT_VIEW_ACTION_COUNT, newContentView.getSequenceNumber());
                }
                if (newBigContentView == null && (newBigContentView = this.createBigContentView()) != null) {
                    this.mN.extras.putInt(EXTRA_REBUILD_BIG_CONTENT_VIEW_ACTION_COUNT, newBigContentView.getSequenceNumber());
                }
                if (newHeadsUpContentView == null && (newHeadsUpContentView = this.createHeadsUpContentView()) != null) {
                    this.mN.extras.putInt(EXTRA_REBUILD_HEADS_UP_CONTENT_VIEW_ACTION_COUNT, newHeadsUpContentView.getSequenceNumber());
                }
                this.mN.contentView = newContentView;
                this.mN.bigContentView = newBigContentView;
                this.mN.headsUpContentView = newHeadsUpContentView;
            }
            if ((this.mN.defaults & 4) != 0) {
                this.mN.flags |= 1;
            }
            this.mN.allPendingIntents = null;
            return this.mN;
        }

        private boolean styleDisplaysCustomViewInline() {
            return this.mStyle != null && this.mStyle.displayCustomViewInline();
        }

        public Notification buildInto(Notification n) {
            this.build().cloneInto(n, true);
            return n;
        }

        public static Notification maybeCloneStrippedForDelivery(Notification n) {
            boolean stripHeadsUpContentView;
            String templateClass = n.extras.getString(Notification.EXTRA_TEMPLATE);
            if (!TextUtils.isEmpty(templateClass) && Notification.getNotificationStyleClass(templateClass) == null) {
                return n;
            }
            boolean stripContentView = n.contentView instanceof BuilderRemoteViews && n.extras.getInt(EXTRA_REBUILD_CONTENT_VIEW_ACTION_COUNT, -1) == n.contentView.getSequenceNumber();
            boolean stripBigContentView = n.bigContentView instanceof BuilderRemoteViews && n.extras.getInt(EXTRA_REBUILD_BIG_CONTENT_VIEW_ACTION_COUNT, -1) == n.bigContentView.getSequenceNumber();
            boolean bl = stripHeadsUpContentView = n.headsUpContentView instanceof BuilderRemoteViews && n.extras.getInt(EXTRA_REBUILD_HEADS_UP_CONTENT_VIEW_ACTION_COUNT, -1) == n.headsUpContentView.getSequenceNumber();
            if (!(stripContentView || stripBigContentView || stripHeadsUpContentView)) {
                return n;
            }
            Notification clone = n.clone();
            if (stripContentView) {
                clone.contentView = null;
                clone.extras.remove(EXTRA_REBUILD_CONTENT_VIEW_ACTION_COUNT);
            }
            if (stripBigContentView) {
                clone.bigContentView = null;
                clone.extras.remove(EXTRA_REBUILD_BIG_CONTENT_VIEW_ACTION_COUNT);
            }
            if (stripHeadsUpContentView) {
                clone.headsUpContentView = null;
                clone.extras.remove(EXTRA_REBUILD_HEADS_UP_CONTENT_VIEW_ACTION_COUNT);
            }
            return clone;
        }

        @UnsupportedAppUsage
        private int getBaseLayoutResource() {
            return 17367221;
        }

        private int getHeadsUpBaseLayoutResource() {
            return 17367230;
        }

        private int getBigBaseLayoutResource() {
            return 17367222;
        }

        private int getBigPictureLayoutResource() {
            return 17367226;
        }

        private int getBigTextLayoutResource() {
            return 17367227;
        }

        private int getInboxLayoutResource() {
            return 17367231;
        }

        private int getMessagingLayoutResource() {
            return 17367233;
        }

        private int getBigMessagingLayoutResource() {
            return 17367225;
        }

        private int getConversationLayoutResource() {
            return 17367229;
        }

        private int getActionLayoutResource() {
            return 17367212;
        }

        private int getEmphasizedActionLayoutResource() {
            return 17367213;
        }

        private int getActionTombstoneLayoutResource() {
            return 17367215;
        }

        private int getBackgroundColor(StandardTemplateParams p) {
            return this.getColors(p).getBackgroundColor();
        }

        private boolean textColorsNeedInversion() {
            if (this.mStyle == null || !MediaStyle.class.equals(this.mStyle.getClass())) {
                return false;
            }
            int targetSdkVersion = this.mContext.getApplicationInfo().targetSdkVersion;
            return targetSdkVersion > 23 && targetSdkVersion < 26;
        }

        public CharSequence getHeadsUpStatusBarText(boolean publicMode) {
            CharSequence text;
            if (this.mStyle != null && !publicMode && !TextUtils.isEmpty(text = this.mStyle.getHeadsUpStatusBarText())) {
                return text;
            }
            return this.loadHeaderAppName();
        }

        public boolean usesTemplate() {
            return this.mN.contentView == null && this.mN.headsUpContentView == null && this.mN.bigContentView == null || this.styleDisplaysCustomViewInline();
        }
    }

    public static class Action
    implements Parcelable {
        private static final String EXTRA_DATA_ONLY_INPUTS = "android.extra.DATA_ONLY_INPUTS";
        public static final int SEMANTIC_ACTION_NONE = 0;
        public static final int SEMANTIC_ACTION_REPLY = 1;
        public static final int SEMANTIC_ACTION_MARK_AS_READ = 2;
        public static final int SEMANTIC_ACTION_MARK_AS_UNREAD = 3;
        public static final int SEMANTIC_ACTION_DELETE = 4;
        public static final int SEMANTIC_ACTION_ARCHIVE = 5;
        public static final int SEMANTIC_ACTION_MUTE = 6;
        public static final int SEMANTIC_ACTION_UNMUTE = 7;
        public static final int SEMANTIC_ACTION_THUMBS_UP = 8;
        public static final int SEMANTIC_ACTION_THUMBS_DOWN = 9;
        public static final int SEMANTIC_ACTION_CALL = 10;
        @SystemApi
        public static final int SEMANTIC_ACTION_MARK_CONVERSATION_AS_PRIORITY = 11;
        @SystemApi
        public static final int SEMANTIC_ACTION_CONVERSATION_IS_PHISHING = 12;
        private final Bundle mExtras;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        private Icon mIcon;
        private final RemoteInput[] mRemoteInputs;
        private boolean mAllowGeneratedReplies = true;
        private final int mSemanticAction;
        private final boolean mIsContextual;
        private boolean mAuthenticationRequired;
        @Deprecated
        public int icon;
        public CharSequence title;
        public PendingIntent actionIntent;
        public static final Parcelable.Creator<Action> CREATOR = new Parcelable.Creator<Action>(){

            @Override
            public Action createFromParcel(Parcel in) {
                return new Action(in);
            }

            public Action[] newArray(int size) {
                return new Action[size];
            }
        };

        private Action(Parcel in) {
            if (in.readInt() != 0) {
                this.mIcon = Icon.CREATOR.createFromParcel(in);
                if (this.mIcon.getType() == 2) {
                    this.icon = this.mIcon.getResId();
                }
            }
            this.title = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            if (in.readInt() == 1) {
                this.actionIntent = PendingIntent.CREATOR.createFromParcel(in);
            }
            this.mExtras = Bundle.setDefusable(in.readBundle(), true);
            this.mRemoteInputs = in.createTypedArray(RemoteInput.CREATOR);
            this.mAllowGeneratedReplies = in.readInt() == 1;
            this.mSemanticAction = in.readInt();
            this.mIsContextual = in.readInt() == 1;
            this.mAuthenticationRequired = in.readInt() == 1;
        }

        @Deprecated
        public Action(int icon, CharSequence title, PendingIntent intent) {
            this(Icon.createWithResource("", icon), title, intent, new Bundle(), null, true, 0, false, false);
        }

        private Action(Icon icon, CharSequence title, PendingIntent intent, Bundle extras, RemoteInput[] remoteInputs, boolean allowGeneratedReplies, int semanticAction, boolean isContextual, boolean requireAuth) {
            this.mIcon = icon;
            if (icon != null && icon.getType() == 2) {
                this.icon = icon.getResId();
            }
            this.title = title;
            this.actionIntent = intent;
            this.mExtras = extras != null ? extras : new Bundle();
            this.mRemoteInputs = remoteInputs;
            this.mAllowGeneratedReplies = allowGeneratedReplies;
            this.mSemanticAction = semanticAction;
            this.mIsContextual = isContextual;
            this.mAuthenticationRequired = requireAuth;
        }

        public Icon getIcon() {
            if (this.mIcon == null && this.icon != 0) {
                this.mIcon = Icon.createWithResource("", this.icon);
            }
            return this.mIcon;
        }

        public Bundle getExtras() {
            return this.mExtras;
        }

        public boolean getAllowGeneratedReplies() {
            return this.mAllowGeneratedReplies;
        }

        public RemoteInput[] getRemoteInputs() {
            return this.mRemoteInputs;
        }

        public int getSemanticAction() {
            return this.mSemanticAction;
        }

        public boolean isContextual() {
            return this.mIsContextual;
        }

        public RemoteInput[] getDataOnlyRemoteInputs() {
            return (RemoteInput[])Notification.getParcelableArrayFromBundle((Bundle)this.mExtras, (String)EXTRA_DATA_ONLY_INPUTS, RemoteInput.class);
        }

        public boolean isAuthenticationRequired() {
            return this.mAuthenticationRequired;
        }

        public Action clone() {
            return new Action(this.getIcon(), this.title, this.actionIntent, this.mExtras == null ? new Bundle() : new Bundle(this.mExtras), this.getRemoteInputs(), this.getAllowGeneratedReplies(), this.getSemanticAction(), this.isContextual(), this.isAuthenticationRequired());
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            Icon ic = this.getIcon();
            if (ic != null) {
                out.writeInt(1);
                ic.writeToParcel(out, 0);
            } else {
                out.writeInt(0);
            }
            TextUtils.writeToParcel(this.title, out, flags);
            if (this.actionIntent != null) {
                out.writeInt(1);
                this.actionIntent.writeToParcel(out, flags);
            } else {
                out.writeInt(0);
            }
            out.writeBundle(this.mExtras);
            out.writeTypedArray(this.mRemoteInputs, flags);
            out.writeInt(this.mAllowGeneratedReplies ? 1 : 0);
            out.writeInt(this.mSemanticAction);
            out.writeInt(this.mIsContextual ? 1 : 0);
            out.writeInt(this.mAuthenticationRequired ? 1 : 0);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface SemanticAction {
        }

        public static class WearableExtender
        implements Extender {
            private static final String EXTRA_WEARABLE_EXTENSIONS = "android.wearable.EXTENSIONS";
            private static final String KEY_FLAGS = "flags";
            private static final String KEY_IN_PROGRESS_LABEL = "inProgressLabel";
            private static final String KEY_CONFIRM_LABEL = "confirmLabel";
            private static final String KEY_CANCEL_LABEL = "cancelLabel";
            private static final int FLAG_AVAILABLE_OFFLINE = 1;
            private static final int FLAG_HINT_LAUNCHES_ACTIVITY = 2;
            private static final int FLAG_HINT_DISPLAY_INLINE = 4;
            private static final int DEFAULT_FLAGS = 1;
            private int mFlags = 1;
            private CharSequence mInProgressLabel;
            private CharSequence mConfirmLabel;
            private CharSequence mCancelLabel;

            public WearableExtender() {
            }

            public WearableExtender(Action action) {
                Bundle wearableBundle = action.getExtras().getBundle(EXTRA_WEARABLE_EXTENSIONS);
                if (wearableBundle != null) {
                    this.mFlags = wearableBundle.getInt(KEY_FLAGS, 1);
                    this.mInProgressLabel = wearableBundle.getCharSequence(KEY_IN_PROGRESS_LABEL);
                    this.mConfirmLabel = wearableBundle.getCharSequence(KEY_CONFIRM_LABEL);
                    this.mCancelLabel = wearableBundle.getCharSequence(KEY_CANCEL_LABEL);
                }
            }

            @Override
            public Builder extend(Builder builder) {
                Bundle wearableBundle = new Bundle();
                if (this.mFlags != 1) {
                    wearableBundle.putInt(KEY_FLAGS, this.mFlags);
                }
                if (this.mInProgressLabel != null) {
                    wearableBundle.putCharSequence(KEY_IN_PROGRESS_LABEL, this.mInProgressLabel);
                }
                if (this.mConfirmLabel != null) {
                    wearableBundle.putCharSequence(KEY_CONFIRM_LABEL, this.mConfirmLabel);
                }
                if (this.mCancelLabel != null) {
                    wearableBundle.putCharSequence(KEY_CANCEL_LABEL, this.mCancelLabel);
                }
                builder.getExtras().putBundle(EXTRA_WEARABLE_EXTENSIONS, wearableBundle);
                return builder;
            }

            public WearableExtender clone() {
                WearableExtender that = new WearableExtender();
                that.mFlags = this.mFlags;
                that.mInProgressLabel = this.mInProgressLabel;
                that.mConfirmLabel = this.mConfirmLabel;
                that.mCancelLabel = this.mCancelLabel;
                return that;
            }

            public WearableExtender setAvailableOffline(boolean availableOffline) {
                this.setFlag(1, availableOffline);
                return this;
            }

            public boolean isAvailableOffline() {
                return (this.mFlags & 1) != 0;
            }

            private void setFlag(int mask, boolean value) {
                this.mFlags = value ? (this.mFlags |= mask) : (this.mFlags &= ~mask);
            }

            @Deprecated
            public WearableExtender setInProgressLabel(CharSequence label) {
                this.mInProgressLabel = label;
                return this;
            }

            @Deprecated
            public CharSequence getInProgressLabel() {
                return this.mInProgressLabel;
            }

            @Deprecated
            public WearableExtender setConfirmLabel(CharSequence label) {
                this.mConfirmLabel = label;
                return this;
            }

            @Deprecated
            public CharSequence getConfirmLabel() {
                return this.mConfirmLabel;
            }

            @Deprecated
            public WearableExtender setCancelLabel(CharSequence label) {
                this.mCancelLabel = label;
                return this;
            }

            @Deprecated
            public CharSequence getCancelLabel() {
                return this.mCancelLabel;
            }

            public WearableExtender setHintLaunchesActivity(boolean hintLaunchesActivity) {
                this.setFlag(2, hintLaunchesActivity);
                return this;
            }

            public boolean getHintLaunchesActivity() {
                return (this.mFlags & 2) != 0;
            }

            public WearableExtender setHintDisplayActionInline(boolean hintDisplayInline) {
                this.setFlag(4, hintDisplayInline);
                return this;
            }

            public boolean getHintDisplayActionInline() {
                return (this.mFlags & 4) != 0;
            }
        }

        public static interface Extender {
            public Builder extend(Builder var1);
        }

        public static class Builder {
            private final Icon mIcon;
            private final CharSequence mTitle;
            private final PendingIntent mIntent;
            private boolean mAllowGeneratedReplies = true;
            private final Bundle mExtras;
            private ArrayList<RemoteInput> mRemoteInputs;
            private int mSemanticAction;
            private boolean mIsContextual;
            private boolean mAuthenticationRequired;

            @Deprecated
            public Builder(int icon, CharSequence title, PendingIntent intent) {
                this(Icon.createWithResource("", icon), title, intent);
            }

            public Builder(Icon icon, CharSequence title, PendingIntent intent) {
                this(icon, title, intent, new Bundle(), null, true, 0, false);
            }

            public Builder(Action action) {
                this(action.getIcon(), action.title, action.actionIntent, new Bundle(action.mExtras), action.getRemoteInputs(), action.getAllowGeneratedReplies(), action.getSemanticAction(), action.isAuthenticationRequired());
            }

            private Builder(Icon icon, CharSequence title, PendingIntent intent, Bundle extras, RemoteInput[] remoteInputs, boolean allowGeneratedReplies, int semanticAction, boolean authRequired) {
                this.mIcon = icon;
                this.mTitle = title;
                this.mIntent = intent;
                this.mExtras = extras;
                if (remoteInputs != null) {
                    this.mRemoteInputs = new ArrayList(remoteInputs.length);
                    Collections.addAll(this.mRemoteInputs, remoteInputs);
                }
                this.mAllowGeneratedReplies = allowGeneratedReplies;
                this.mSemanticAction = semanticAction;
                this.mAuthenticationRequired = authRequired;
            }

            public Builder addExtras(Bundle extras) {
                if (extras != null) {
                    this.mExtras.putAll(extras);
                }
                return this;
            }

            public Bundle getExtras() {
                return this.mExtras;
            }

            public Builder addRemoteInput(RemoteInput remoteInput) {
                if (this.mRemoteInputs == null) {
                    this.mRemoteInputs = new ArrayList();
                }
                this.mRemoteInputs.add(remoteInput);
                return this;
            }

            public Builder setAllowGeneratedReplies(boolean allowGeneratedReplies) {
                this.mAllowGeneratedReplies = allowGeneratedReplies;
                return this;
            }

            public Builder setSemanticAction(int semanticAction) {
                this.mSemanticAction = semanticAction;
                return this;
            }

            public Builder setContextual(boolean isContextual) {
                this.mIsContextual = isContextual;
                return this;
            }

            public Builder extend(Extender extender) {
                extender.extend(this);
                return this;
            }

            public Builder setAuthenticationRequired(boolean authenticationRequired) {
                this.mAuthenticationRequired = authenticationRequired;
                return this;
            }

            private void checkContextualActionNullFields() {
                if (!this.mIsContextual) {
                    return;
                }
                if (this.mIcon == null) {
                    throw new NullPointerException("Contextual Actions must contain a valid icon");
                }
                if (this.mIntent == null) {
                    throw new NullPointerException("Contextual Actions must contain a valid PendingIntent");
                }
            }

            public Action build() {
                this.checkContextualActionNullFields();
                ArrayList<RemoteInput> dataOnlyInputs = new ArrayList<RemoteInput>();
                RemoteInput[] previousDataInputs = (RemoteInput[])Notification.getParcelableArrayFromBundle((Bundle)this.mExtras, (String)Action.EXTRA_DATA_ONLY_INPUTS, RemoteInput.class);
                if (previousDataInputs != null) {
                    for (RemoteInput input : previousDataInputs) {
                        dataOnlyInputs.add(input);
                    }
                }
                ArrayList<RemoteInput> textInputs = new ArrayList<RemoteInput>();
                if (this.mRemoteInputs != null) {
                    for (RemoteInput input : this.mRemoteInputs) {
                        if (input.isDataOnly()) {
                            dataOnlyInputs.add(input);
                            continue;
                        }
                        textInputs.add(input);
                    }
                }
                if (!dataOnlyInputs.isEmpty()) {
                    Parcelable[] dataInputsArr = dataOnlyInputs.toArray(new RemoteInput[dataOnlyInputs.size()]);
                    this.mExtras.putParcelableArray(Action.EXTRA_DATA_ONLY_INPUTS, dataInputsArr);
                }
                RemoteInput[] textInputsArr = textInputs.isEmpty() ? null : textInputs.toArray(new RemoteInput[textInputs.size()]);
                return new Action(this.mIcon, this.mTitle, this.mIntent, this.mExtras, textInputsArr, this.mAllowGeneratedReplies, this.mSemanticAction, this.mIsContextual, this.mAuthenticationRequired);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GroupAlertBehavior {
    }

    public static @interface NotificationVisibilityOverride {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Visibility {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Priority {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NotificationFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ServiceNotificationPolicy {
    }
}

