/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.observer;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class SchemaChangeInfo {
    private final String mPackageName;
    private final String mDatabaseName;
    private final Set<String> mChangedSchemaNames;

    public SchemaChangeInfo(String packageName, String databaseName, Set<String> changedSchemaNames) {
        this.mPackageName = Objects.requireNonNull(packageName);
        this.mDatabaseName = Objects.requireNonNull(databaseName);
        this.mChangedSchemaNames = Collections.unmodifiableSet(Objects.requireNonNull(changedSchemaNames));
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getDatabaseName() {
        return this.mDatabaseName;
    }

    public Set<String> getChangedSchemaNames() {
        return this.mChangedSchemaNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SchemaChangeInfo)) {
            return false;
        }
        SchemaChangeInfo that = (SchemaChangeInfo)o;
        return this.mPackageName.equals(that.mPackageName) && this.mDatabaseName.equals(that.mDatabaseName) && this.mChangedSchemaNames.equals(that.mChangedSchemaNames);
    }

    public int hashCode() {
        return Objects.hash(this.mPackageName, this.mDatabaseName, this.mChangedSchemaNames);
    }

    public String toString() {
        return "SchemaChangeInfo{packageName='" + this.mPackageName + '\'' + ", databaseName='" + this.mDatabaseName + '\'' + ", changedSchemaNames='" + this.mChangedSchemaNames + '\'' + '}';
    }
}

