/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.bluetooth.BluetoothAvrcpPlayerSettings;
import android.bluetooth.BluetoothDevice;
import android.content.AttributionSource;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver;

public interface IBluetoothAvrcpController
extends IInterface {
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getConnectedDevices(AttributionSource var1, SynchronousResultReceiver var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getDevicesMatchingConnectionStates(int[] var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getConnectionState(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getPlayerSettings(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void setPlayerApplicationSetting(BluetoothAvrcpPlayerSettings var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void sendGroupNavigationCmd(BluetoothDevice var1, int var2, int var3, AttributionSource var4, SynchronousResultReceiver var5) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothAvrcpController {
        public static final String DESCRIPTOR = "android.bluetooth.IBluetoothAvrcpController";
        static final int TRANSACTION_getConnectedDevices = 1;
        static final int TRANSACTION_getDevicesMatchingConnectionStates = 2;
        static final int TRANSACTION_getConnectionState = 3;
        static final int TRANSACTION_getPlayerSettings = 4;
        static final int TRANSACTION_setPlayerApplicationSetting = 5;
        static final int TRANSACTION_sendGroupNavigationCmd = 6;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IBluetoothAvrcpController asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothAvrcpController) {
                return (IBluetoothAvrcpController)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg1 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getConnectedDevices(_arg0, _arg1);
                    break;
                }
                case 2: {
                    int[] _arg0 = data.createIntArray();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getDevicesMatchingConnectionStates(_arg0, _arg1, _arg2);
                    break;
                }
                case 3: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getConnectionState(_arg0, _arg1, _arg2);
                    break;
                }
                case 4: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getPlayerSettings(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    BluetoothAvrcpPlayerSettings _arg0 = data.readTypedObject(BluetoothAvrcpPlayerSettings.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.setPlayerApplicationSetting(_arg0, _arg1, _arg2);
                    break;
                }
                case 6: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    AttributionSource _arg3 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg4 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.sendGroupNavigationCmd(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IBluetoothAvrcpController {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getConnectedDevices(AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getDevicesMatchingConnectionStates(int[] states, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(states);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getConnectionState(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getPlayerSettings(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPlayerApplicationSetting(BluetoothAvrcpPlayerSettings plAppSetting, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(plAppSetting, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendGroupNavigationCmd(BluetoothDevice device, int keyCode, int keyState, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(keyCode);
                    _data.writeInt(keyState);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBluetoothAvrcpController {
        @Override
        public void getConnectedDevices(AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getDevicesMatchingConnectionStates(int[] states, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getConnectionState(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getPlayerSettings(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void setPlayerApplicationSetting(BluetoothAvrcpPlayerSettings plAppSetting, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void sendGroupNavigationCmd(BluetoothDevice device, int keyCode, int keyState, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

