/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.SystemApi;
import android.content.ComponentName;
import android.content.pm.DataLoaderParamsParcel;
import android.content.pm.DataLoaderType;

@SystemApi
public class DataLoaderParams {
    private final DataLoaderParamsParcel mData;

    public static DataLoaderParams forStreaming(ComponentName componentName, String arguments) {
        return new DataLoaderParams(1, componentName, arguments);
    }

    @SystemApi
    public static DataLoaderParams forIncremental(ComponentName componentName, String arguments) {
        return new DataLoaderParams(2, componentName, arguments);
    }

    public DataLoaderParams(@DataLoaderType int type, ComponentName componentName, String arguments) {
        DataLoaderParamsParcel data = new DataLoaderParamsParcel();
        data.type = type;
        data.packageName = componentName.getPackageName();
        data.className = componentName.getClassName();
        data.arguments = arguments;
        this.mData = data;
    }

    DataLoaderParams(DataLoaderParamsParcel data) {
        this.mData = data;
    }

    public DataLoaderParamsParcel getData() {
        return this.mData;
    }

    @DataLoaderType
    public int getType() {
        return this.mData.type;
    }

    public ComponentName getComponentName() {
        return new ComponentName(this.mData.packageName, this.mData.className);
    }

    public String getArguments() {
        return this.mData.arguments;
    }
}

