/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.face;

import android.annotation.RequiresPermission;
import android.content.Context;
import android.hardware.biometrics.BiometricAuthenticator;
import android.hardware.biometrics.BiometricFaceConstants;
import android.hardware.biometrics.CryptoObject;
import android.hardware.biometrics.IBiometricServiceLockoutResetCallback;
import android.hardware.face.Face;
import android.hardware.face.FaceAuthenticationFrame;
import android.hardware.face.FaceDataFrame;
import android.hardware.face.FaceEnrollCell;
import android.hardware.face.FaceEnrollFrame;
import android.hardware.face.FaceSensorProperties;
import android.hardware.face.FaceSensorPropertiesInternal;
import android.hardware.face.IFaceService;
import android.hardware.face.IFaceServiceReceiver;
import android.os.Binder;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.Trace;
import android.os.UserHandle;
import android.util.Slog;
import android.view.Surface;
import com.android.internal.os.SomeArgs;
import java.util.ArrayList;
import java.util.List;

public class FaceManager
implements BiometricAuthenticator,
BiometricFaceConstants {
    private static final String TAG = "FaceManager";
    private static final int MSG_ENROLL_RESULT = 100;
    private static final int MSG_ACQUIRED = 101;
    private static final int MSG_AUTHENTICATION_SUCCEEDED = 102;
    private static final int MSG_AUTHENTICATION_FAILED = 103;
    private static final int MSG_ERROR = 104;
    private static final int MSG_REMOVED = 105;
    private static final int MSG_GET_FEATURE_COMPLETED = 106;
    private static final int MSG_SET_FEATURE_COMPLETED = 107;
    private static final int MSG_CHALLENGE_GENERATED = 108;
    private static final int MSG_FACE_DETECTED = 109;
    private static final int MSG_AUTHENTICATION_FRAME = 112;
    private static final int MSG_ENROLLMENT_FRAME = 113;
    private final IFaceService mService;
    private final Context mContext;
    private final IBinder mToken = new Binder();
    private AuthenticationCallback mAuthenticationCallback;
    private FaceDetectionCallback mFaceDetectionCallback;
    private EnrollmentCallback mEnrollmentCallback;
    private RemovalCallback mRemovalCallback;
    private SetFeatureCallback mSetFeatureCallback;
    private GetFeatureCallback mGetFeatureCallback;
    private GenerateChallengeCallback mGenerateChallengeCallback;
    private CryptoObject mCryptoObject;
    private Face mRemovalFace;
    private Handler mHandler;
    private final IFaceServiceReceiver mServiceReceiver = new IFaceServiceReceiver.Stub(){

        @Override
        public void onEnrollResult(Face face, int remaining) {
            FaceManager.this.mHandler.obtainMessage(100, remaining, 0, face).sendToTarget();
        }

        @Override
        public void onAcquired(int acquireInfo, int vendorCode) {
            FaceManager.this.mHandler.obtainMessage(101, acquireInfo, vendorCode).sendToTarget();
        }

        @Override
        public void onAuthenticationSucceeded(Face face, int userId, boolean isStrongBiometric) {
            FaceManager.this.mHandler.obtainMessage(102, userId, isStrongBiometric ? 1 : 0, face).sendToTarget();
        }

        @Override
        public void onFaceDetected(int sensorId, int userId, boolean isStrongBiometric) {
            FaceManager.this.mHandler.obtainMessage(109, sensorId, userId, isStrongBiometric).sendToTarget();
        }

        @Override
        public void onAuthenticationFailed() {
            FaceManager.this.mHandler.obtainMessage(103).sendToTarget();
        }

        @Override
        public void onError(int error, int vendorCode) {
            FaceManager.this.mHandler.obtainMessage(104, error, vendorCode).sendToTarget();
        }

        @Override
        public void onRemoved(Face face, int remaining) {
            FaceManager.this.mHandler.obtainMessage(105, remaining, 0, face).sendToTarget();
        }

        @Override
        public void onFeatureSet(boolean success, int feature) {
            FaceManager.this.mHandler.obtainMessage(107, feature, 0, success).sendToTarget();
        }

        @Override
        public void onFeatureGet(boolean success, int[] features, boolean[] featureState) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = success;
            args.arg2 = features;
            args.arg3 = featureState;
            FaceManager.this.mHandler.obtainMessage(106, args).sendToTarget();
        }

        @Override
        public void onChallengeGenerated(int sensorId, int userId, long challenge) {
            FaceManager.this.mHandler.obtainMessage(108, sensorId, userId, challenge).sendToTarget();
        }

        @Override
        public void onAuthenticationFrame(FaceAuthenticationFrame frame) {
            FaceManager.this.mHandler.obtainMessage(112, frame).sendToTarget();
        }

        @Override
        public void onEnrollmentFrame(FaceEnrollFrame frame) {
            FaceManager.this.mHandler.obtainMessage(113, frame).sendToTarget();
        }
    };

    public FaceManager(Context context, IFaceService service) {
        this.mContext = context;
        this.mService = service;
        if (this.mService == null) {
            Slog.v(TAG, "FaceAuthenticationManagerService was null");
        }
        this.mHandler = new MyHandler(context);
    }

    private void useHandler(Handler handler) {
        if (handler != null) {
            this.mHandler = new MyHandler(handler.getLooper());
        } else if (this.mHandler.getLooper() != this.mContext.getMainLooper()) {
            this.mHandler = new MyHandler(this.mContext.getMainLooper());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void authenticate(CryptoObject crypto, CancellationSignal cancel, AuthenticationCallback callback, Handler handler, int userId, boolean isKeyguardBypassEnabled) {
        if (callback == null) {
            throw new IllegalArgumentException("Must supply an authentication callback");
        }
        if (cancel != null && cancel.isCanceled()) {
            Slog.w(TAG, "authentication already canceled");
            return;
        }
        if (this.mService != null) {
            try {
                this.useHandler(handler);
                this.mAuthenticationCallback = callback;
                this.mCryptoObject = crypto;
                long operationId = crypto != null ? crypto.getOpId() : 0L;
                Trace.beginSection("FaceManager#authenticate");
                long authId = this.mService.authenticate(this.mToken, operationId, userId, this.mServiceReceiver, this.mContext.getOpPackageName(), isKeyguardBypassEnabled);
                if (cancel != null) {
                    cancel.setOnCancelListener(new OnAuthenticationCancelListener(authId));
                }
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Remote exception while authenticating: ", e);
                callback.onAuthenticationError(1, FaceManager.getErrorString(this.mContext, 1, 0));
            }
            finally {
                Trace.endSection();
            }
        }
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void detectFace(CancellationSignal cancel, FaceDetectionCallback callback, int userId) {
        if (this.mService == null) {
            return;
        }
        if (cancel.isCanceled()) {
            Slog.w(TAG, "Detection already cancelled");
            return;
        }
        this.mFaceDetectionCallback = callback;
        try {
            long authId = this.mService.detectFace(this.mToken, userId, this.mServiceReceiver, this.mContext.getOpPackageName());
            cancel.setOnCancelListener(new OnFaceDetectionCancelListener(authId));
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Remote exception when requesting finger detect", e);
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_BIOMETRIC")
    public void enroll(int userId, byte[] hardwareAuthToken, CancellationSignal cancel, EnrollmentCallback callback, int[] disabledFeatures) {
        this.enroll(userId, hardwareAuthToken, cancel, callback, disabledFeatures, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_BIOMETRIC")
    public void enroll(int userId, byte[] hardwareAuthToken, CancellationSignal cancel, EnrollmentCallback callback, int[] disabledFeatures, Surface previewSurface, boolean debugConsent) {
        if (callback == null) {
            throw new IllegalArgumentException("Must supply an enrollment callback");
        }
        if (cancel != null && cancel.isCanceled()) {
            Slog.w(TAG, "enrollment already canceled");
            return;
        }
        if (this.mService != null) {
            try {
                this.mEnrollmentCallback = callback;
                Trace.beginSection("FaceManager#enroll");
                long enrollId = this.mService.enroll(userId, this.mToken, hardwareAuthToken, this.mServiceReceiver, this.mContext.getOpPackageName(), disabledFeatures, previewSurface, debugConsent);
                if (cancel != null) {
                    cancel.setOnCancelListener(new OnEnrollCancelListener(enrollId));
                }
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Remote exception in enroll: ", e);
                callback.onEnrollmentError(1, FaceManager.getErrorString(this.mContext, 1, 0));
            }
            finally {
                Trace.endSection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_BIOMETRIC")
    public void enrollRemotely(int userId, byte[] hardwareAuthToken, CancellationSignal cancel, EnrollmentCallback callback, int[] disabledFeatures) {
        if (callback == null) {
            throw new IllegalArgumentException("Must supply an enrollment callback");
        }
        if (cancel != null && cancel.isCanceled()) {
            Slog.w(TAG, "enrollRemotely is already canceled.");
            return;
        }
        if (this.mService != null) {
            try {
                this.mEnrollmentCallback = callback;
                Trace.beginSection("FaceManager#enrollRemotely");
                long enrolId = this.mService.enrollRemotely(userId, this.mToken, hardwareAuthToken, this.mServiceReceiver, this.mContext.getOpPackageName(), disabledFeatures);
                if (cancel != null) {
                    cancel.setOnCancelListener(new OnEnrollCancelListener(enrolId));
                }
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Remote exception in enrollRemotely: ", e);
                callback.onEnrollmentError(1, FaceManager.getErrorString(this.mContext, 1, 0));
            }
            finally {
                Trace.endSection();
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_BIOMETRIC")
    public void generateChallenge(int sensorId, int userId, GenerateChallengeCallback callback) {
        if (this.mService != null) {
            try {
                this.mGenerateChallengeCallback = callback;
                this.mService.generateChallenge(this.mToken, sensorId, userId, this.mServiceReceiver, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_BIOMETRIC")
    public void generateChallenge(int userId, GenerateChallengeCallback callback) {
        List<FaceSensorPropertiesInternal> faceSensorProperties = this.getSensorPropertiesInternal();
        if (faceSensorProperties.isEmpty()) {
            Slog.e(TAG, "No sensors");
            return;
        }
        int sensorId = faceSensorProperties.get((int)0).sensorId;
        this.generateChallenge(sensorId, userId, callback);
    }

    @RequiresPermission(value="android.permission.MANAGE_BIOMETRIC")
    public void revokeChallenge(int sensorId, int userId, long challenge) {
        if (this.mService != null) {
            try {
                this.mService.revokeChallenge(this.mToken, sensorId, userId, this.mContext.getOpPackageName(), challenge);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void resetLockout(int sensorId, int userId, byte[] hardwareAuthToken) {
        if (this.mService != null) {
            try {
                this.mService.resetLockout(this.mToken, sensorId, userId, hardwareAuthToken, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_BIOMETRIC")
    public void setFeature(int userId, int feature, boolean enabled, byte[] hardwareAuthToken, SetFeatureCallback callback) {
        if (this.mService != null) {
            try {
                this.mSetFeatureCallback = callback;
                this.mService.setFeature(this.mToken, userId, feature, enabled, hardwareAuthToken, this.mServiceReceiver, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_BIOMETRIC")
    public void getFeature(int userId, int feature, GetFeatureCallback callback) {
        if (this.mService != null) {
            try {
                this.mGetFeatureCallback = callback;
                this.mService.getFeature(this.mToken, userId, feature, this.mServiceReceiver, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_BIOMETRIC")
    public void remove(Face face, int userId, RemovalCallback callback) {
        if (this.mService != null) {
            try {
                this.mRemovalCallback = callback;
                this.mRemovalFace = face;
                this.mService.remove(this.mToken, face.getBiometricId(), userId, this.mServiceReceiver, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_BIOMETRIC")
    public void removeAll(int userId, RemovalCallback callback) {
        if (this.mService != null) {
            try {
                this.mRemovalCallback = callback;
                this.mService.removeAll(this.mToken, userId, this.mServiceReceiver, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_BIOMETRIC")
    public List<Face> getEnrolledFaces(int userId) {
        List<FaceSensorPropertiesInternal> faceSensorProperties = this.getSensorPropertiesInternal();
        if (faceSensorProperties.isEmpty()) {
            Slog.e(TAG, "No sensors");
            return new ArrayList<Face>();
        }
        if (this.mService != null) {
            try {
                return this.mService.getEnrolledFaces(faceSensorProperties.get((int)0).sensorId, userId, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    @RequiresPermission(value="android.permission.MANAGE_BIOMETRIC")
    public List<Face> getEnrolledFaces() {
        return this.getEnrolledFaces(UserHandle.myUserId());
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public boolean hasEnrolledTemplates() {
        return this.hasEnrolledTemplates(UserHandle.myUserId());
    }

    @RequiresPermission(allOf={"android.permission.USE_BIOMETRIC_INTERNAL", "android.permission.INTERACT_ACROSS_USERS"})
    public boolean hasEnrolledTemplates(int userId) {
        List<FaceSensorPropertiesInternal> faceSensorProperties = this.getSensorPropertiesInternal();
        if (faceSensorProperties.isEmpty()) {
            Slog.e(TAG, "No sensors");
            return false;
        }
        if (this.mService != null) {
            try {
                return this.mService.hasEnrolledFaces(faceSensorProperties.get((int)0).sensorId, userId, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public boolean isHardwareDetected() {
        List<FaceSensorPropertiesInternal> faceSensorProperties = this.getSensorPropertiesInternal();
        if (faceSensorProperties.isEmpty()) {
            Slog.e(TAG, "No sensors");
            return false;
        }
        if (this.mService != null) {
            try {
                return this.mService.isHardwareDetected(faceSensorProperties.get((int)0).sensorId, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        Slog.w(TAG, "isFaceHardwareDetected(): Service not connected!");
        return false;
    }

    public List<FaceSensorProperties> getSensorProperties() {
        ArrayList<FaceSensorProperties> properties = new ArrayList<FaceSensorProperties>();
        List<FaceSensorPropertiesInternal> internalProperties = this.getSensorPropertiesInternal();
        for (FaceSensorPropertiesInternal internalProp : internalProperties) {
            properties.add(FaceSensorProperties.from(internalProp));
        }
        return properties;
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public List<FaceSensorPropertiesInternal> getSensorPropertiesInternal() {
        try {
            if (this.mService == null) {
                return new ArrayList<FaceSensorPropertiesInternal>();
            }
            return this.mService.getSensorPropertiesInternal(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return new ArrayList<FaceSensorPropertiesInternal>();
        }
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public int getLockoutModeForUser(int sensorId, int userId) {
        if (this.mService != null) {
            try {
                return this.mService.getLockoutModeForUser(sensorId, userId);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void addLockoutResetCallback(final LockoutResetCallback callback) {
        if (this.mService != null) {
            try {
                final PowerManager powerManager = this.mContext.getSystemService(PowerManager.class);
                this.mService.addLockoutResetCallback(new IBiometricServiceLockoutResetCallback.Stub(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onLockoutReset(int sensorId, IRemoteCallback serverCallback) throws RemoteException {
                        try {
                            PowerManager.WakeLock wakeLock = powerManager.newWakeLock(1, "faceLockoutResetCallback");
                            wakeLock.acquire();
                            FaceManager.this.mHandler.post(() -> {
                                try {
                                    callback.onLockoutReset(sensorId);
                                }
                                finally {
                                    wakeLock.release();
                                }
                            });
                        }
                        finally {
                            serverCallback.sendResult(null);
                        }
                    }
                }, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        } else {
            Slog.w(TAG, "addLockoutResetCallback(): Service not connected!");
        }
    }

    private void cancelEnrollment(long requestId) {
        if (this.mService != null) {
            try {
                this.mService.cancelEnrollment(this.mToken, requestId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private void cancelAuthentication(long requestId) {
        if (this.mService != null) {
            try {
                this.mService.cancelAuthentication(this.mToken, this.mContext.getOpPackageName(), requestId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private void cancelFaceDetect(long requestId) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.cancelFaceDetect(this.mToken, this.mContext.getOpPackageName(), requestId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static String getErrorString(Context context, int errMsg, int vendorCode) {
        switch (errMsg) {
            case 1: {
                return context.getString(17040288);
            }
            case 2: {
                return context.getString(17040297);
            }
            case 3: {
                return context.getString(17040296);
            }
            case 4: {
                return context.getString(17040293);
            }
            case 5: {
                return context.getString(17040287);
            }
            case 7: {
                return context.getString(17040290);
            }
            case 9: {
                return context.getString(17040291);
            }
            case 10: {
                return context.getString(17040298);
            }
            case 11: {
                return context.getString(17040294);
            }
            case 12: {
                return context.getString(17040289);
            }
            case 15: {
                return context.getString(17040295);
            }
            case 16: {
                return context.getString(17040304);
            }
            case 8: {
                String[] msgArray = context.getResources().getStringArray(17236159);
                if (vendorCode >= msgArray.length) break;
                return msgArray[vendorCode];
            }
        }
        Slog.w(TAG, "Invalid error message: " + errMsg + ", " + vendorCode);
        return context.getString(17040299);
    }

    public static int getMappedAcquiredInfo(int acquireInfo, int vendorCode) {
        switch (acquireInfo) {
            case 0: {
                return 0;
            }
            case 1: 
            case 2: 
            case 3: {
                return 2;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return 1;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return 2;
            }
            case 22: {
                return 1000 + vendorCode;
            }
        }
        return 0;
    }

    private void sendSetFeatureCompleted(boolean success, int feature) {
        if (this.mSetFeatureCallback == null) {
            return;
        }
        this.mSetFeatureCallback.onCompleted(success, feature);
    }

    private void sendGetFeatureCompleted(boolean success, int[] features, boolean[] featureState) {
        if (this.mGetFeatureCallback == null) {
            return;
        }
        this.mGetFeatureCallback.onCompleted(success, features, featureState);
    }

    private void sendChallengeGenerated(int sensorId, int userId, long challenge) {
        if (this.mGenerateChallengeCallback == null) {
            return;
        }
        this.mGenerateChallengeCallback.onGenerateChallengeResult(sensorId, userId, challenge);
    }

    private void sendFaceDetected(int sensorId, int userId, boolean isStrongBiometric) {
        if (this.mFaceDetectionCallback == null) {
            Slog.e(TAG, "sendFaceDetected, callback null");
            return;
        }
        this.mFaceDetectionCallback.onFaceDetected(sensorId, userId, isStrongBiometric);
    }

    private void sendRemovedResult(Face face, int remaining) {
        if (this.mRemovalCallback == null) {
            return;
        }
        this.mRemovalCallback.onRemovalSucceeded(face, remaining);
    }

    private void sendErrorResult(int errMsgId, int vendorCode) {
        int clientErrMsgId;
        int n = clientErrMsgId = errMsgId == 8 ? vendorCode + 1000 : errMsgId;
        if (this.mEnrollmentCallback != null) {
            this.mEnrollmentCallback.onEnrollmentError(clientErrMsgId, FaceManager.getErrorString(this.mContext, errMsgId, vendorCode));
        } else if (this.mAuthenticationCallback != null) {
            this.mAuthenticationCallback.onAuthenticationError(clientErrMsgId, FaceManager.getErrorString(this.mContext, errMsgId, vendorCode));
        } else if (this.mRemovalCallback != null) {
            this.mRemovalCallback.onRemovalError(this.mRemovalFace, clientErrMsgId, FaceManager.getErrorString(this.mContext, errMsgId, vendorCode));
        }
    }

    private void sendEnrollResult(Face face, int remaining) {
        if (this.mEnrollmentCallback != null) {
            this.mEnrollmentCallback.onEnrollmentProgress(remaining);
        }
    }

    private void sendAuthenticatedSucceeded(Face face, int userId, boolean isStrongBiometric) {
        if (this.mAuthenticationCallback != null) {
            AuthenticationResult result = new AuthenticationResult(this.mCryptoObject, face, userId, isStrongBiometric);
            this.mAuthenticationCallback.onAuthenticationSucceeded(result);
        }
    }

    private void sendAuthenticatedFailed() {
        if (this.mAuthenticationCallback != null) {
            this.mAuthenticationCallback.onAuthenticationFailed();
        }
    }

    private void sendAcquiredResult(int acquireInfo, int vendorCode) {
        if (this.mAuthenticationCallback != null) {
            FaceAuthenticationFrame frame = new FaceAuthenticationFrame(new FaceDataFrame(acquireInfo, vendorCode));
            this.sendAuthenticationFrame(frame);
        } else if (this.mEnrollmentCallback != null) {
            FaceEnrollFrame frame = new FaceEnrollFrame(null, 0, new FaceDataFrame(acquireInfo, vendorCode));
            this.sendEnrollmentFrame(frame);
        }
    }

    private void sendAuthenticationFrame(FaceAuthenticationFrame frame) {
        if (frame == null) {
            Slog.w(TAG, "Received null authentication frame");
        } else if (this.mAuthenticationCallback != null) {
            int acquireInfo = frame.getData().getAcquiredInfo();
            int vendorCode = frame.getData().getVendorCode();
            int helpCode = FaceManager.getHelpCode(acquireInfo, vendorCode);
            String helpMessage = FaceManager.getAuthHelpMessage(this.mContext, acquireInfo, vendorCode);
            this.mAuthenticationCallback.onAuthenticationAcquired(acquireInfo);
            if (helpMessage != null) {
                this.mAuthenticationCallback.onAuthenticationHelp(helpCode, helpMessage);
            }
        }
    }

    private void sendEnrollmentFrame(FaceEnrollFrame frame) {
        if (frame == null) {
            Slog.w(TAG, "Received null enrollment frame");
        } else if (this.mEnrollmentCallback != null) {
            FaceDataFrame data = frame.getData();
            int acquireInfo = data.getAcquiredInfo();
            int vendorCode = data.getVendorCode();
            int helpCode = FaceManager.getHelpCode(acquireInfo, vendorCode);
            String helpMessage = FaceManager.getEnrollHelpMessage(this.mContext, acquireInfo, vendorCode);
            this.mEnrollmentCallback.onEnrollmentFrame(helpCode, helpMessage, frame.getCell(), frame.getStage(), data.getPan(), data.getTilt(), data.getDistance());
        }
    }

    private static int getHelpCode(int acquireInfo, int vendorCode) {
        return acquireInfo == 22 ? vendorCode + 1000 : acquireInfo;
    }

    public static String getAuthHelpMessage(Context context, int acquireInfo, int vendorCode) {
        switch (acquireInfo) {
            case 0: 
            case 20: {
                return null;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                return context.getString(17040267);
            }
            case 1: {
                return context.getString(17040263);
            }
            case 2: {
                return context.getString(17040272);
            }
            case 3: {
                return context.getString(17040274);
            }
            case 12: {
                return context.getString(17040280);
            }
            case 13: {
                return context.getString(17040268);
            }
            case 14: {
                return context.getString(17040275);
            }
            case 15: {
                return context.getString(17040282);
            }
            case 19: {
                return context.getString(17040265);
            }
            case 21: {
                return context.getString(17040270);
            }
            case 22: {
                String[] msgArray = context.getResources().getStringArray(17236158);
                if (vendorCode >= msgArray.length) break;
                return msgArray[vendorCode];
            }
        }
        Slog.w(TAG, "Unknown authentication acquired message: " + acquireInfo + ", " + vendorCode);
        return null;
    }

    public static String getEnrollHelpMessage(Context context, int acquireInfo, int vendorCode) {
        switch (acquireInfo) {
            case 0: 
            case 20: {
                return null;
            }
            case 1: {
                return context.getString(17040263);
            }
            case 2: {
                return context.getString(17040272);
            }
            case 3: {
                return context.getString(17040274);
            }
            case 4: {
                return context.getString(17040273);
            }
            case 5: {
                return context.getString(17040276);
            }
            case 6: {
                return context.getString(17040279);
            }
            case 7: {
                return context.getString(17040277);
            }
            case 8: {
                return context.getString(17040278);
            }
            case 9: {
                return context.getString(17040281);
            }
            case 10: {
                return context.getString(17040267);
            }
            case 11: {
                return context.getString(17040264);
            }
            case 12: {
                return context.getString(17040280);
            }
            case 13: {
                return context.getString(17040268);
            }
            case 14: {
                return context.getString(17040275);
            }
            case 15: {
                return context.getString(17040282);
            }
            case 16: {
                return context.getString(17040266);
            }
            case 17: {
                return context.getString(17040271);
            }
            case 18: {
                return context.getString(17040269);
            }
            case 19: 
            case 25: 
            case 26: {
                return context.getString(17040265);
            }
            case 21: {
                return context.getString(17040270);
            }
            case 22: {
                String[] msgArray = context.getResources().getStringArray(17236158);
                if (vendorCode >= msgArray.length) break;
                return msgArray[vendorCode];
            }
        }
        Slog.w(TAG, "Unknown enrollment acquired message: " + acquireInfo + ", " + vendorCode);
        return null;
    }

    private class MyHandler
    extends Handler {
        private MyHandler(Context context) {
            super(context.getMainLooper());
        }

        private MyHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            Trace.beginSection("FaceManager#handleMessage: " + Integer.toString(msg.what));
            switch (msg.what) {
                case 100: {
                    FaceManager.this.sendEnrollResult((Face)msg.obj, msg.arg1);
                    break;
                }
                case 101: {
                    FaceManager.this.sendAcquiredResult(msg.arg1, msg.arg2);
                    break;
                }
                case 102: {
                    FaceManager.this.sendAuthenticatedSucceeded((Face)msg.obj, msg.arg1, msg.arg2 == 1);
                    break;
                }
                case 103: {
                    FaceManager.this.sendAuthenticatedFailed();
                    break;
                }
                case 104: {
                    FaceManager.this.sendErrorResult(msg.arg1, msg.arg2);
                    break;
                }
                case 105: {
                    FaceManager.this.sendRemovedResult((Face)msg.obj, msg.arg1);
                    break;
                }
                case 107: {
                    FaceManager.this.sendSetFeatureCompleted((Boolean)msg.obj, msg.arg1);
                    break;
                }
                case 106: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    FaceManager.this.sendGetFeatureCompleted((Boolean)args.arg1, (int[])args.arg2, (boolean[])args.arg3);
                    args.recycle();
                    break;
                }
                case 108: {
                    FaceManager.this.sendChallengeGenerated(msg.arg1, msg.arg2, (Long)msg.obj);
                    break;
                }
                case 109: {
                    FaceManager.this.sendFaceDetected(msg.arg1, msg.arg2, (Boolean)msg.obj);
                    break;
                }
                case 112: {
                    FaceManager.this.sendAuthenticationFrame((FaceAuthenticationFrame)msg.obj);
                    break;
                }
                case 113: {
                    FaceManager.this.sendEnrollmentFrame((FaceEnrollFrame)msg.obj);
                    break;
                }
                default: {
                    Slog.w(FaceManager.TAG, "Unknown message: " + msg.what);
                }
            }
            Trace.endSection();
        }
    }

    private class OnFaceDetectionCancelListener
    implements CancellationSignal.OnCancelListener {
        private final long mAuthRequestId;

        OnFaceDetectionCancelListener(long id2) {
            this.mAuthRequestId = id2;
        }

        @Override
        public void onCancel() {
            Slog.d(FaceManager.TAG, "Cancel face detect requested for: " + this.mAuthRequestId);
            FaceManager.this.cancelFaceDetect(this.mAuthRequestId);
        }
    }

    private class OnAuthenticationCancelListener
    implements CancellationSignal.OnCancelListener {
        private final long mAuthRequestId;

        OnAuthenticationCancelListener(long id2) {
            this.mAuthRequestId = id2;
        }

        @Override
        public void onCancel() {
            Slog.d(FaceManager.TAG, "Cancel face authentication requested for: " + this.mAuthRequestId);
            FaceManager.this.cancelAuthentication(this.mAuthRequestId);
        }
    }

    private class OnEnrollCancelListener
    implements CancellationSignal.OnCancelListener {
        private final long mAuthRequestId;

        private OnEnrollCancelListener(long id2) {
            this.mAuthRequestId = id2;
        }

        @Override
        public void onCancel() {
            Slog.d(FaceManager.TAG, "Cancel face enrollment requested for: " + this.mAuthRequestId);
            FaceManager.this.cancelEnrollment(this.mAuthRequestId);
        }
    }

    public static interface GenerateChallengeCallback {
        public void onGenerateChallengeResult(int var1, int var2, long var3);
    }

    public static abstract class GetFeatureCallback {
        public abstract void onCompleted(boolean var1, int[] var2, boolean[] var3);
    }

    public static abstract class SetFeatureCallback {
        public abstract void onCompleted(boolean var1, int var2);
    }

    public static abstract class LockoutResetCallback {
        public void onLockoutReset(int sensorId) {
        }
    }

    public static abstract class RemovalCallback {
        public void onRemovalError(Face face, int errMsgId, CharSequence errString) {
        }

        public void onRemovalSucceeded(Face face, int remaining) {
        }
    }

    public static abstract class EnrollmentCallback {
        public void onEnrollmentError(int errMsgId, CharSequence errString) {
        }

        public void onEnrollmentHelp(int helpMsgId, CharSequence helpString) {
        }

        public void onEnrollmentFrame(int helpCode, CharSequence helpMessage, FaceEnrollCell cell, int stage, float pan, float tilt, float distance) {
            this.onEnrollmentHelp(helpCode, helpMessage);
        }

        public void onEnrollmentProgress(int remaining) {
        }
    }

    public static interface FaceDetectionCallback {
        public void onFaceDetected(int var1, int var2, boolean var3);
    }

    public static abstract class AuthenticationCallback
    extends BiometricAuthenticator.AuthenticationCallback {
        @Override
        public void onAuthenticationError(int errorCode, CharSequence errString) {
        }

        @Override
        public void onAuthenticationHelp(int helpCode, CharSequence helpString) {
        }

        public void onAuthenticationSucceeded(AuthenticationResult result) {
        }

        @Override
        public void onAuthenticationFailed() {
        }

        @Override
        public void onAuthenticationAcquired(int acquireInfo) {
        }
    }

    public static class AuthenticationResult {
        private final Face mFace;
        private final CryptoObject mCryptoObject;
        private final int mUserId;
        private final boolean mIsStrongBiometric;

        public AuthenticationResult(CryptoObject crypto, Face face, int userId, boolean isStrongBiometric) {
            this.mCryptoObject = crypto;
            this.mFace = face;
            this.mUserId = userId;
            this.mIsStrongBiometric = isStrongBiometric;
        }

        public CryptoObject getCryptoObject() {
            return this.mCryptoObject;
        }

        public Face getFace() {
            return this.mFace;
        }

        public int getUserId() {
            return this.mUserId;
        }

        public boolean isStrongBiometric() {
            return this.mIsStrongBiometric;
        }
    }
}

