/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IInputSensorEventListener
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.input.IInputSensorEventListener";

    public void onInputSensorChanged(int var1, int var2, int var3, long var4, float[] var6) throws RemoteException;

    public void onInputSensorAccuracyChanged(int var1, int var2, int var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInputSensorEventListener {
        static final int TRANSACTION_onInputSensorChanged = 1;
        static final int TRANSACTION_onInputSensorAccuracyChanged = 2;

        public Stub() {
            this.attachInterface(this, IInputSensorEventListener.DESCRIPTOR);
        }

        public static IInputSensorEventListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IInputSensorEventListener.DESCRIPTOR);
            if (iin != null && iin instanceof IInputSensorEventListener) {
                return (IInputSensorEventListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onInputSensorChanged";
                }
                case 2: {
                    return "onInputSensorAccuracyChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IInputSensorEventListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    long _arg3 = data.readLong();
                    float[] _arg4 = data.createFloatArray();
                    data.enforceNoDataAvail();
                    this.onInputSensorChanged(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onInputSensorAccuracyChanged(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IInputSensorEventListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IInputSensorEventListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInputSensorChanged(int deviceId, int sensorId, int accuracy, long timestamp, float[] values) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInputSensorEventListener.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeInt(sensorId);
                    _data.writeInt(accuracy);
                    _data.writeLong(timestamp);
                    _data.writeFloatArray(values);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInputSensorAccuracyChanged(int deviceId, int sensorId, int accuracy) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInputSensorEventListener.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeInt(sensorId);
                    _data.writeInt(accuracy);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IInputSensorEventListener {
        @Override
        public void onInputSensorChanged(int deviceId, int sensorId, int accuracy, long timestamp, float[] values) throws RemoteException {
        }

        @Override
        public void onInputSensorAccuracyChanged(int deviceId, int sensorId, int accuracy) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

