/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.SystemServiceRegistry;
import android.media.MediaServiceManager;
import android.media.session.MediaSessionManager;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class MediaFrameworkPlatformInitializer {
    private static volatile MediaServiceManager sMediaServiceManager;

    private MediaFrameworkPlatformInitializer() {
    }

    public static void setMediaServiceManager(MediaServiceManager mediaServiceManager) {
        Preconditions.checkState(sMediaServiceManager == null, "setMediaServiceManager called twice!");
        sMediaServiceManager = Objects.requireNonNull(mediaServiceManager);
    }

    public static MediaServiceManager getMediaServiceManager() {
        return sMediaServiceManager;
    }

    public static void registerServiceWrappers() {
        SystemServiceRegistry.registerContextAwareService("media_session", MediaSessionManager.class, context -> new MediaSessionManager(context));
    }
}

