/*
 * Decompiled with CFR 0.152.
 */
package android.media.metrics;

import android.media.metrics.Event;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class PlaybackStateEvent
extends Event
implements Parcelable {
    public static final int STATE_NOT_STARTED = 0;
    public static final int STATE_JOINING_BACKGROUND = 1;
    public static final int STATE_JOINING_FOREGROUND = 2;
    public static final int STATE_PLAYING = 3;
    public static final int STATE_PAUSED = 4;
    public static final int STATE_SEEKING = 5;
    public static final int STATE_BUFFERING = 6;
    public static final int STATE_PAUSED_BUFFERING = 7;
    public static final int STATE_SUPPRESSED = 9;
    public static final int STATE_SUPPRESSED_BUFFERING = 10;
    public static final int STATE_ENDED = 11;
    public static final int STATE_STOPPED = 12;
    public static final int STATE_FAILED = 13;
    public static final int STATE_INTERRUPTED_BY_AD = 14;
    public static final int STATE_ABANDONED = 15;
    private final int mState;
    private final long mTimeSinceCreatedMillis;
    public static final Parcelable.Creator<PlaybackStateEvent> CREATOR = new Parcelable.Creator<PlaybackStateEvent>(){

        public PlaybackStateEvent[] newArray(int size) {
            return new PlaybackStateEvent[size];
        }

        @Override
        public PlaybackStateEvent createFromParcel(Parcel in) {
            return new PlaybackStateEvent(in);
        }
    };

    public static String stateToString(int value) {
        switch (value) {
            case 0: {
                return "STATE_NOT_STARTED";
            }
            case 1: {
                return "STATE_JOINING_BACKGROUND";
            }
            case 2: {
                return "STATE_JOINING_FOREGROUND";
            }
            case 3: {
                return "STATE_PLAYING";
            }
            case 4: {
                return "STATE_PAUSED";
            }
            case 5: {
                return "STATE_SEEKING";
            }
            case 6: {
                return "STATE_BUFFERING";
            }
            case 7: {
                return "STATE_PAUSED_BUFFERING";
            }
            case 9: {
                return "STATE_SUPPRESSED";
            }
            case 10: {
                return "STATE_SUPPRESSED_BUFFERING";
            }
            case 11: {
                return "STATE_ENDED";
            }
            case 12: {
                return "STATE_STOPPED";
            }
            case 13: {
                return "STATE_FAILED";
            }
            case 14: {
                return "STATE_INTERRUPTED_BY_AD";
            }
            case 15: {
                return "STATE_ABANDONED";
            }
        }
        return Integer.toHexString(value);
    }

    private PlaybackStateEvent(int state, long timeSinceCreatedMillis, Bundle extras) {
        this.mTimeSinceCreatedMillis = timeSinceCreatedMillis;
        this.mState = state;
        this.mMetricsBundle = extras.deepCopy();
    }

    public int getState() {
        return this.mState;
    }

    @Override
    public long getTimeSinceCreatedMillis() {
        return this.mTimeSinceCreatedMillis;
    }

    @Override
    public Bundle getMetricsBundle() {
        return this.mMetricsBundle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlaybackStateEvent that = (PlaybackStateEvent)o;
        return this.mState == that.mState && this.mTimeSinceCreatedMillis == that.mTimeSinceCreatedMillis;
    }

    public int hashCode() {
        return Objects.hash(this.mState, this.mTimeSinceCreatedMillis);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mState);
        dest.writeLong(this.mTimeSinceCreatedMillis);
        dest.writeBundle(this.mMetricsBundle);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private PlaybackStateEvent(Parcel in) {
        int state = in.readInt();
        long timeSinceCreatedMillis = in.readLong();
        Bundle extras = in.readBundle();
        this.mState = state;
        this.mTimeSinceCreatedMillis = timeSinceCreatedMillis;
        this.mMetricsBundle = extras;
    }

    public static class Builder {
        private int mState = 0;
        private long mTimeSinceCreatedMillis = -1L;
        private Bundle mMetricsBundle = new Bundle();

        public Builder setState(int value) {
            this.mState = value;
            return this;
        }

        public Builder setTimeSinceCreatedMillis(long value) {
            this.mTimeSinceCreatedMillis = value;
            return this;
        }

        public Builder setMetricsBundle(Bundle metricsBundle) {
            this.mMetricsBundle = metricsBundle;
            return this;
        }

        public PlaybackStateEvent build() {
            PlaybackStateEvent o = new PlaybackStateEvent(this.mState, this.mTimeSinceCreatedMillis, this.mMetricsBundle);
            return o;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }
}

