/*
 * Decompiled with CFR 0.152.
 */
package android.nearby;

import android.nearby.NearbyDeviceParcelable;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IScanListener
extends IInterface {
    public static final String DESCRIPTOR = "android.nearby.IScanListener";

    public void onDiscovered(NearbyDeviceParcelable var1) throws RemoteException;

    public void onUpdated(NearbyDeviceParcelable var1) throws RemoteException;

    public void onLost(NearbyDeviceParcelable var1) throws RemoteException;

    public void onError() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IScanListener {
        static final int TRANSACTION_onDiscovered = 1;
        static final int TRANSACTION_onUpdated = 2;
        static final int TRANSACTION_onLost = 3;
        static final int TRANSACTION_onError = 4;

        public Stub() {
            this.attachInterface(this, IScanListener.DESCRIPTOR);
        }

        public static IScanListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IScanListener.DESCRIPTOR);
            if (iin != null && iin instanceof IScanListener) {
                return (IScanListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onDiscovered";
                }
                case 2: {
                    return "onUpdated";
                }
                case 3: {
                    return "onLost";
                }
                case 4: {
                    return "onError";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IScanListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    NearbyDeviceParcelable _arg0 = data.readTypedObject(NearbyDeviceParcelable.CREATOR);
                    data.enforceNoDataAvail();
                    this.onDiscovered(_arg0);
                    break;
                }
                case 2: {
                    NearbyDeviceParcelable _arg0 = data.readTypedObject(NearbyDeviceParcelable.CREATOR);
                    data.enforceNoDataAvail();
                    this.onUpdated(_arg0);
                    break;
                }
                case 3: {
                    NearbyDeviceParcelable _arg0 = data.readTypedObject(NearbyDeviceParcelable.CREATOR);
                    data.enforceNoDataAvail();
                    this.onLost(_arg0);
                    break;
                }
                case 4: {
                    this.onError();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements IScanListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IScanListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDiscovered(NearbyDeviceParcelable nearbyDeviceParcelable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScanListener.DESCRIPTOR);
                    _data.writeTypedObject(nearbyDeviceParcelable, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUpdated(NearbyDeviceParcelable nearbyDeviceParcelable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScanListener.DESCRIPTOR);
                    _data.writeTypedObject(nearbyDeviceParcelable, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLost(NearbyDeviceParcelable nearbyDeviceParcelable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScanListener.DESCRIPTOR);
                    _data.writeTypedObject(nearbyDeviceParcelable, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onError() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IScanListener.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IScanListener {
        @Override
        public void onDiscovered(NearbyDeviceParcelable nearbyDeviceParcelable) throws RemoteException {
        }

        @Override
        public void onUpdated(NearbyDeviceParcelable nearbyDeviceParcelable) throws RemoteException {
        }

        @Override
        public void onLost(NearbyDeviceParcelable nearbyDeviceParcelable) throws RemoteException {
        }

        @Override
        public void onError() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

