/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.ConnectivityManager;
import android.net.IQosCallback;
import android.net.QosCallback;
import android.net.QosCallbackException;
import android.net.QosSession;
import android.telephony.data.EpsBearerQosSessionAttributes;
import android.telephony.data.NrQosSessionAttributes;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.concurrent.Executor;

class QosCallbackConnection
extends IQosCallback.Stub {
    private final ConnectivityManager mConnectivityManager;
    private volatile QosCallback mCallback;
    private final Executor mExecutor;

    @VisibleForTesting
    public QosCallback getCallback() {
        return this.mCallback;
    }

    QosCallbackConnection(ConnectivityManager connectivityManager, QosCallback callback, Executor executor) {
        this.mConnectivityManager = Objects.requireNonNull(connectivityManager, "connectivityManager must be non-null");
        this.mCallback = Objects.requireNonNull(callback, "callback must be non-null");
        this.mExecutor = Objects.requireNonNull(executor, "executor must be non-null");
    }

    @Override
    public void onQosEpsBearerSessionAvailable(QosSession session, EpsBearerQosSessionAttributes attributes) {
        this.mExecutor.execute(() -> {
            QosCallback callback = this.mCallback;
            if (callback != null) {
                callback.onQosSessionAvailable(session, attributes);
            }
        });
    }

    @Override
    public void onNrQosSessionAvailable(QosSession session, NrQosSessionAttributes attributes) {
        this.mExecutor.execute(() -> {
            QosCallback callback = this.mCallback;
            if (callback != null) {
                callback.onQosSessionAvailable(session, attributes);
            }
        });
    }

    @Override
    public void onQosSessionLost(QosSession session) {
        this.mExecutor.execute(() -> {
            QosCallback callback = this.mCallback;
            if (callback != null) {
                callback.onQosSessionLost(session);
            }
        });
    }

    @Override
    public void onError(int errorType) {
        this.mExecutor.execute(() -> {
            QosCallback callback = this.mCallback;
            if (callback != null) {
                this.stopReceivingMessages();
                this.mConnectivityManager.unregisterQosCallback(callback);
                callback.onError(QosCallbackException.createException(errorType));
            }
        });
    }

    void stopReceivingMessages() {
        this.mCallback = null;
    }
}

