/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.android.net.mdns.aidl;

import android.net.connectivity.android.net.mdns.aidl.DiscoveryInfo;
import android.net.connectivity.android.net.mdns.aidl.GetAddressInfo;
import android.net.connectivity.android.net.mdns.aidl.IMDnsEventListener;
import android.net.connectivity.android.net.mdns.aidl.RegistrationInfo;
import android.net.connectivity.android.net.mdns.aidl.ResolutionInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IMDns
extends IInterface {
    public static final int VERSION = 1;
    public static final String HASH = "ae4cfe565d66acc7d816aabd0dfab991e64031ab";
    public static final String DESCRIPTOR = "android$net$mdns$aidl$IMDns".replace('$', '.');

    public void startDaemon() throws RemoteException;

    public void stopDaemon() throws RemoteException;

    public void registerService(RegistrationInfo var1) throws RemoteException;

    public void discover(DiscoveryInfo var1) throws RemoteException;

    public void resolve(ResolutionInfo var1) throws RemoteException;

    public void getServiceAddress(GetAddressInfo var1) throws RemoteException;

    public void stopOperation(int var1) throws RemoteException;

    public void registerEventListener(IMDnsEventListener var1) throws RemoteException;

    public void unregisterEventListener(IMDnsEventListener var1) throws RemoteException;

    public int getInterfaceVersion() throws RemoteException;

    public String getInterfaceHash() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMDns {
        static final int TRANSACTION_startDaemon = 1;
        static final int TRANSACTION_stopDaemon = 2;
        static final int TRANSACTION_registerService = 3;
        static final int TRANSACTION_discover = 4;
        static final int TRANSACTION_resolve = 5;
        static final int TRANSACTION_getServiceAddress = 6;
        static final int TRANSACTION_stopOperation = 7;
        static final int TRANSACTION_registerEventListener = 8;
        static final int TRANSACTION_unregisterEventListener = 9;
        static final int TRANSACTION_getInterfaceVersion = 0xFFFFFF;
        static final int TRANSACTION_getInterfaceHash = 0xFFFFFE;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IMDns asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IMDns) {
                return (IMDns)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 0xFFFFFF: {
                    reply.writeNoException();
                    reply.writeInt(this.getInterfaceVersion());
                    return true;
                }
                case 0xFFFFFE: {
                    reply.writeNoException();
                    reply.writeString(this.getInterfaceHash());
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    this.startDaemon();
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    this.stopDaemon();
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    RegistrationInfo _arg0 = data.readTypedObject(RegistrationInfo.CREATOR);
                    this.registerService(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    DiscoveryInfo _arg0 = data.readTypedObject(DiscoveryInfo.CREATOR);
                    this.discover(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    ResolutionInfo _arg0 = data.readTypedObject(ResolutionInfo.CREATOR);
                    this.resolve(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    GetAddressInfo _arg0 = data.readTypedObject(GetAddressInfo.CREATOR);
                    this.getServiceAddress(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    this.stopOperation(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    IMDnsEventListener _arg0 = IMDnsEventListener.Stub.asInterface(data.readStrongBinder());
                    this.registerEventListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    IMDnsEventListener _arg0 = IMDnsEventListener.Stub.asInterface(data.readStrongBinder());
                    this.unregisterEventListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IMDns {
            private IBinder mRemote;
            private int mCachedVersion = -1;
            private String mCachedHash = "-1";

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startDaemon() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method startDaemon is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopDaemon() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method stopDaemon is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerService(RegistrationInfo info) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(info, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method registerService is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void discover(DiscoveryInfo info) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(info, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method discover is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resolve(ResolutionInfo info) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(info, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method resolve is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getServiceAddress(GetAddressInfo info) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(info, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method getServiceAddress is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopOperation(int id2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(id2);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method stopOperation is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerEventListener(IMDnsEventListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method registerEventListener is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterEventListener(IMDnsEventListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method unregisterEventListener is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getInterfaceVersion() throws RemoteException {
                if (this.mCachedVersion == -1) {
                    Parcel data = Parcel.obtain();
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(DESCRIPTOR);
                        boolean _status = this.mRemote.transact(0xFFFFFF, data, reply, 0);
                        reply.readException();
                        this.mCachedVersion = reply.readInt();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedVersion;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized String getInterfaceHash() throws RemoteException {
                if ("-1".equals(this.mCachedHash)) {
                    Parcel data = Parcel.obtain();
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(DESCRIPTOR);
                        boolean _status = this.mRemote.transact(0xFFFFFE, data, reply, 0);
                        reply.readException();
                        this.mCachedHash = reply.readString();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedHash;
            }
        }
    }

    public static class Default
    implements IMDns {
        @Override
        public void startDaemon() throws RemoteException {
        }

        @Override
        public void stopDaemon() throws RemoteException {
        }

        @Override
        public void registerService(RegistrationInfo info) throws RemoteException {
        }

        @Override
        public void discover(DiscoveryInfo info) throws RemoteException {
        }

        @Override
        public void resolve(ResolutionInfo info) throws RemoteException {
        }

        @Override
        public void getServiceAddress(GetAddressInfo info) throws RemoteException {
        }

        @Override
        public void stopOperation(int id2) throws RemoteException {
        }

        @Override
        public void registerEventListener(IMDnsEventListener listener) throws RemoteException {
        }

        @Override
        public void unregisterEventListener(IMDnsEventListener listener) throws RemoteException {
        }

        @Override
        public int getInterfaceVersion() {
            return 0;
        }

        @Override
        public String getInterfaceHash() {
            return "";
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

